/*! For license information please see bundle.js.LICENSE.txt */
(()=>{"use strict";var t={d:(e,n)=>{for(var r in n)t.o(n,r)&&!t.o(e,r)&&Object.defineProperty(e,r,{enumerable:1,get:n[r]})},o:(t,e)=>Object.prototype.hasOwnProperty.call(t,e)};t.d({},{l:()=>Bd});class e{callbacks=[];connect(t){this.callbacks.push(t)}disconnect(t){const e=this.callbacks.indexOf(t);e>=0&&this.callbacks.splice(e,1)}emit(t){this.callbacks.forEach(e=>e(t))}}class n{static hexToArray(t){return[(t>>16&255)/255,(t>>8&255)/255,(255&t)/255]}static cross(t,e){return[t[1]*e[2]-t[2]*e[1],t[2]*e[0]-t[0]*e[2],t[0]*e[1]-t[1]*e[0]]}static normalize(t){const e=[];let n=0;for(let e=0;e<t.length;e++)n+=t[e]*t[e];const r=Math.sqrt(n);for(let n=0;n<t.length;n++)e.push(t[n]/r);return e}static normalizeValue(t,e,r){return n.clamp(0,1,(r-t)/(e-t))}static smoothstep(t,e,n){return(n=this.clamp(0,1,(n-t)/(e-t)))*n*(3-2*n)}static clamp(t,e,n){return Math.min(e,Math.max(t,n))}static lerp(t,e,n){return(1-n)*t+n*e}static lerpList(t,e,r,i=[]){if(t.length!==e.length)return t;for(let a=0;a<t.length;a++)i[a]=n.lerp(t[a],e[a],r);return i}static lpad(t,e,n="0"){let r=t.toString();for(;r.length<e;)r=n+r;return r}static distance2d(t,e){const n=t[0]-e[0],r=t[1]-e[1];return Math.sqrt(n*n+r*r)}}const r={range:16/9,label:"16:9"},i=[{label:"240p",resolution:240},{label:"720p",resolution:720},{label:"1080p",resolution:1080,default:1},{label:"fit screen",resolution:-1}];class a{title;images;textures;shaderConstants={};beatsPerBar;ticksPerBeat;beatsPerMinute;aspectRatio;resolutions;music;generateFFT;precision=1024;debug;looping;parts;muted;enableKHRParallelCompilation;analyserVersion;debugUniformSliders;constructor(){this.title="",this.beatsPerBar=4,this.ticksPerBeat=16,this.beatsPerMinute=120,this.aspectRatio=r,this.resolutions=i,this.music="music.ogg",this.debug=1,this.looping=0,this.muted=0,this.parts=[],this.images=[],this.enableKHRParallelCompilation=1,this.generateFFT=1,this.debugUniformSliders=this.debug,this.analyserVersion="modern"}}const s=t=>new p(t[0],t[1],t[2],h.ABSOLUTE);let o=new a;function l(){return o}new e;function c(t,e){const n=t.split(".");let r=window;for(let t=0;t<n.length-1;t++)if(Reflect.has(r,n[t]))r=Reflect.get(r,n[t]);else{const e={};Reflect.set(r,n[t],e),r=e}Reflect.set(r,n[n.length-1],e)}var h,u,d;!function(t){t[t.RELATIVE=0]="RELATIVE",t[t.ABSOLUTE=1]="ABSOLUTE",t[t.PATTERN=2]="PATTERN"}(h||(h={}));class p{static zero=()=>new p;bar=0;beat=0;tick=0;pattern;delta=0;constructor(t=0,e=0,n=0,r=h.ABSOLUTE){this.bar=t,this.beat=e,this.tick=n,this.pattern=r}matchesPattern(t,e){return this.pattern===h.ABSOLUTE?this.equals(t):this.pattern===h.RELATIVE?t.bar===e.bar+this.bar&&t.beat===e.beat+this.beat&&t.tick===e.tick+this.tick:this.pattern===h.PATTERN?!(-1!==this.bar&&t.bar%this.bar!==0||-1!==this.beat&&t.beat%l().beatsPerBar!==this.beat||-1!==this.tick&&t.tick%l().ticksPerBeat!==this.tick):0}add(t){return this.addBars(t.bar),this.addBeats(t.beat),this.addTicks(t.tick),this}addBars(t){return this.bar+=t,this}addBeats(t){return this.beat+=t,this.bar+=Math.floor(this.beat/l().beatsPerBar),this.beat%=l().beatsPerBar,this}addTicks(t){for(this.tick+=t;this.tick>=l().ticksPerBeat;)this.tick-=l().ticksPerBeat,this.beat++;for(;this.beat>=l().beatsPerBar;)this.beat-=l().beatsPerBar,this.bar++;return this}subtract(t){return this.subtractBars(t.bar),this.subtractBeats(t.beat),this.subtractTicks(t.tick),this}subtractBars(t){return this.bar-=t,this}subtractBeats(t){for(this.beat-=t;this.beat<0;)this.bar--,this.beat+=l().beatsPerBar;return this}subtractTicks(t){for(this.tick-=t;this.tick<0;)this.tick+=l().ticksPerBeat,this.beat--;for(;this.beat<0;)this.bar--,this.beat+=l().beatsPerBar;return this}fromTime(t){const e=l().beatsPerMinute*t;return this.bar=Math.floor(e/l().beatsPerBar),this.beat=Math.floor(e%l().beatsPerBar),this.tick=Math.floor((e-Math.floor(e))*l().ticksPerBeat),this}static create(t){return(new p).fromTime(t)}isInside(t,e,n){return n?this.isSmallerThan(e.clone().add(n))&&this.isLargerThan(t.clone().add(n)):this.isSmallerThan(e)&&this.isLargerThan(t)}isSmallerThan(t){const e=this.bar*l().beatsPerBar*l().ticksPerBeat+this.beat*l().ticksPerBeat+this.tick,n=t.bar*l().beatsPerBar*l().ticksPerBeat+t.beat*l().ticksPerBeat+t.tick;return e<n||e===n}isLargerThan(t){const e=this.bar*l().beatsPerBar*l().ticksPerBeat+this.beat*l().ticksPerBeat+this.tick,n=t.bar*l().beatsPerBar*l().ticksPerBeat+t.beat*l().ticksPerBeat+t.tick;return e>n||e===n}toMilliseconds(){return 60*(this.bar*l().beatsPerBar/l().beatsPerMinute+this.beat/l().beatsPerMinute+this.tick/l().ticksPerBeat/l().beatsPerMinute)*1e3}equals(t){return this.bar*l().beatsPerBar*l().ticksPerBeat+this.beat*l().ticksPerBeat+this.tick===t.bar*l().beatsPerBar*l().ticksPerBeat+t.beat*l().ticksPerBeat+t.tick}clone(){return new p(this.bar,this.beat,this.tick,this.pattern)}toString(t=1){return`${n.lpad(this.bar,3)}:${n.lpad(this.beat,2)}:${n.lpad(this.tick,2)}${t?" ["+h[this.pattern]+"]":""}`}static toMilliseconds(t=0,e=0,n=0){return 60*(t*l().beatsPerBar/l().beatsPerMinute+e/l().beatsPerMinute+n/l().ticksPerBeat/l().beatsPerMinute)*1e3}}c("kvg.Timesig",p),function(t){t[t.UnInitialized=0]="UnInitialized",t[t.Initializing=1]="Initializing",t[t.Loading=2]="Loading",t[t.Ready=3]="Ready",t[t.Running=4]="Running",t[t.Paused=5]="Paused",t[t.Stopped=6]="Stopped"}(u||(u={}));class f{static PRECISION=1024;static ended=1;static duration;static fft;static FFTex;static sourceNode;static context;static analyserLeft;static analyserRight;static scriptNode;static gainNode;static splitNode;static mergeNode;static started=0;static elapsedWithPreviousPlaybackRate=0;static state;static pausedAt=0;static INIT(){this.state=u.Initializing,f.context=new AudioContext,f.analyserLeft=f.context.createAnalyser(),f.analyserRight=f.context.createAnalyser(),f.scriptNode=f.context.createScriptProcessor(f.PRECISION,1,1),f.gainNode=f.context.createGain(),f.splitNode=f.context.createChannelSplitter(2),f.mergeNode=f.context.createChannelMerger(2),f.gainNode.connect(f.context.destination),f.splitNode.connect(f.analyserLeft,0,0),f.splitNode.connect(f.analyserRight,1,0),f.analyserLeft.connect(f.mergeNode,0,0),f.analyserRight.connect(f.mergeNode,0,1),f.mergeNode.connect(f.gainNode),f.fft={fftsize:f.PRECISION,sampleRate:f.context.sampleRate,dbLeft:new Float32Array(f.analyserLeft.frequencyBinCount),frequencyLeft:new Uint8Array(f.analyserLeft.frequencyBinCount),waveformLeft:new Uint8Array(f.analyserLeft.frequencyBinCount),dbRight:new Float32Array(f.analyserLeft.frequencyBinCount),frequencyRight:new Uint8Array(f.analyserLeft.frequencyBinCount),waveformRight:new Uint8Array(f.analyserLeft.frequencyBinCount)}}static reset(){this.createSourceNode()}static adjustSpeed(t){if(f.sourceNode){const e=f.sourceNode.playbackRate.value,n=f.position();f.elapsedWithPreviousPlaybackRate=f.position(),f.sourceNode.playbackRate.value=t,f.started=f.context.currentTime,t>=0&&e<0&&f.gotoPosition(1e3*n)}}static createSourceNode(t){let e=null;f.sourceNode?.buffer&&(e=f.sourceNode.buffer),f.sourceNode=f.context.createBufferSource(),f.sourceNode.onended=()=>f.ended=1,f.sourceNode.connect(f.splitNode),f.sourceNode.buffer=t||e}static updateFFT(){f.analyserLeft.getFloatFrequencyData(f.fft.dbLeft),f.analyserLeft.getByteFrequencyData(f.fft.frequencyLeft),f.analyserLeft.getByteTimeDomainData(f.fft.waveformLeft),f.analyserRight.getFloatFrequencyData(f.fft.dbRight),f.analyserRight.getByteFrequencyData(f.fft.frequencyRight),f.analyserRight.getByteTimeDomainData(f.fft.waveformRight)}static async loadMusic(t){this.state=u.Loading;try{const e=await fetch(t),n=await e.arrayBuffer(),r=await f.context.decodeAudioData(n);return this.createSourceNode(r),f.duration=r.duration,this.state=u.Ready,1}catch(t){return 0}}static start(){f.ended=0,f.gainNode.gain.setValueAtTime(l().muted?0:1,0),this.state=u.Running,f.started=f.context.currentTime,f.sourceNode.start(0)}static stop(){this.state=u.Stopped,f.sourceNode.stop(0)}static pause(){this.state===u.Running&&(f.pausedAt=f.context.currentTime-f.started,f.context.suspend(),this.state=u.Paused)}static play(){this.state===u.Paused&&this.pausedAt>0&&(f.context.resume(),this.state=u.Running)}static pauseOrResume(){this.state===u.Paused?this.play():this.pause()}static position(){return f.sourceNode.playbackRate.value*(f.context.currentTime-f.started)+f.elapsedWithPreviousPlaybackRate}static gotoPosition(t,e=0){if(!e&&![u.Running,u.Paused].includes(this.state))return;t=Math.max(t,0);let n=1;this.sourceNode&&(f.sourceNode.onended=null,f.sourceNode.stop(),n=f.sourceNode.playbackRate.value),this.createSourceNode(),f.elapsedWithPreviousPlaybackRate=0,f.sourceNode.start(0,t),t/=n,f.started=f.context.currentTime-t,f.sourceNode.playbackRate.value=n}static getGainNode=()=>this.gainNode;static getContext=()=>this.context}c("kvg.Music",f);class m{demo;isRunning=0;isStarted=0;timesig=new p;previoustime=0;get started(){return this.isStarted}get delta(){return this.timesig.delta}constructor(t){this.demo=t}start(){if(!this.isStarted){f.start(),this.isStarted=1,this.isRunning=1,g.instance.emitChange(d.Running),window.requestAnimationFrame(this.onTick);const t=/#t(ime)?=([0-9]+)/.exec(location.hash);t&&t.length>2?f.gotoPosition(p.toMilliseconds(parseInt(t[2],10),0,0)/1e3):0!==l().parts[0].start[0]&&f.gotoPosition(p.toMilliseconds(l().parts[0].start[0])/1e3)}}stop(){g.instance.emitChange(d.Stopped),f.stop(),this.isRunning=0,this.isStarted=0,f.reset()}pause(){g.instance.emitChange(d.Paused),f.pause()}resume(){g.instance.emitChange(d.Running),f.play()}seek(t){let e=t.toMilliseconds();e=Math.max(0,e),f.gotoPosition(e/1e3)}onTick=t=>{if(this.isRunning){if(window.requestAnimationFrame(this.onTick),f.ended){if(!this.demo.looping)return g.instance.emitChange(d.Stopped),void this.stop();f.ended=0,f.gotoPosition(0,1),this.demo.previousTs=new p(0,0,0),g.instance.overlay.hideAll()}const e=f.position();this.timesig.fromTime(e/60),this.timesig.delta=this.calculateDelta(t),this.demo.update(this.timesig),this.previoustime=t}};calculateDelta(t){return(t-this.previoustime)/(1e3/60)}}!function(t){t[t.Stopped=0]="Stopped",t[t.Running=1]="Running",t[t.Paused=2]="Paused"}(d||(d={}));class g{static instance;onUpdate=new e;onDebugUpdate=new e;onStateChange=new e;onRenderComplete=new e;beforeRender=new e;beforeUpdate=new e;options;renderer;overlay;_runner;get runner(){return this._runner}activeParts=[];coDependant=[];previousTs=new p;looping;state=d.Stopped;constructor(t){g.instance=this,this.looping=t.looping,this.renderer=t.renderer,this.options=t,this.overlay=t.overlay,this._runner=new m(this)}getPart(t){let e;if(this.options.parts.forEach(n=>{n.id===t&&(e=n)}),!e)throw new Error("Part "+t+"not found");return e}update(t){f.updateFFT();let e=0;for(;!t.equals(this.previousTs);){this.previousTs.isSmallerThan(t)?this.previousTs.addTicks(1):this.previousTs.subtractTicks(1),e=1,this.coDependant=[];const n=[];let r=0;for(let e=0;e<this.options.timeline.length;e++){const i=this.options.timeline[e];i.partInstance.running||(i.running=0),this.previousTs.isLargerThan(i.start)&&t.isSmallerThan(i.end)&&(i.running||(i.partInstance.start(this.previousTs,i),i.running=1,r=1,i.partInstance.renderToScreen=!i.dontRenderToScreen),n.push(i.partInstance),i.requires.forEach(t=>{const e=this.getPart(t);-1===this.coDependant.indexOf(e)&&this.coDependant.push(e)}))}this.previousTs.delta=t.delta,this.coDependant.forEach(t=>t.runTriggers(this.previousTs)),n.forEach(t=>t.runTriggers(this.previousTs)),this.activeParts=n,r&&this.emitChange(d.Running),this.options.parts.forEach(t=>{-1===this.activeParts.indexOf(t)&&t.running&&t.stop()})}e&&(this.beforeUpdate.emit({timesig:t}),this.onUpdate.emit({timesig:t})),l().debug&&this.onDebugUpdate.emit({timesig:t}),this.render(t)}renderAllOnce(){this.options.renderer.render(p.zero(),this.options.parts,1)}render(t){const e={timesig:t,rendered:[...this.coDependant,...this.activeParts]};this.beforeRender.emit(e),this.coDependant.length>0&&this.options.renderer.render(t,this.coDependant),this.activeParts.length>0&&this.options.renderer.render(t,this.activeParts),this.onRenderComplete.emit(e)}emitChange(t){this.state=t,t===d.Stopped&&this.onUpdate.emit({timesig:p.zero()}),this.onStateChange.emit({state:t,activeParts:this.activeParts})}}const v="#version 300 es\r\n\r\nin vec2 a_position;\r\nout vec4 position;\r\n\r\nvoid main() {\r\n  gl_Position = vec4(a_position, 0, 1);\r\n}",x="#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D texture;\r\n\r\nout vec4 outColor;\r\n\r\nvoid main() {\r\n    vec4 col = texelFetch(texture, ivec2(gl_FragCoord.xy), 0 );\r\n    // Always set alpha to 1 when rendering to final screen so no blending happens.\r\n    col.a = 1.0;\r\n    // Gamma correction\r\n    //col.xyz = pow( col.xyz, vec3(1.0/2.2) );\r\n    outColor = col;\r\n    //outColor= vec4(1.0);\r\n}",_=(t,e,n)=>{const r=t.createShader(n);if(t.shaderSource(r,e),t.compileShader(r),!t.getShaderParameter(r,t.COMPILE_STATUS)){const e=t.getShaderInfoLog(r);throw new Error(`Could not compile WebGL program.\n\n${e}`)}return r},y=new Map;function b(t,e,n){const r=t.createTexture(),i=t.RGBA,a=t.RGBA,s=t.UNSIGNED_BYTE;if(!e)throw new Error("Missing image - check config.json");return t.bindTexture(t.TEXTURE_2D,r),t.texImage2D(t.TEXTURE_2D,0,i,e.width,e.height,0,a,s,e),n?(t.generateMipmap(t.TEXTURE_2D),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.NEAREST),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.NEAREST)):t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),r}class E{enabled=1;textures;fbs;renderer;constructor(t){this.renderer=t,this.textures=[t.createRenderTarget(),t.createRenderTarget()],this.fbs=[t.createFrameBuffer(this.textures[0]),t.createFrameBuffer(this.textures[1])]}render(t,e){const n=this.renderer.context;let r=0,i=t;n.drawBuffers([n.COLOR_ATTACHMENT0]),n.activeTexture(n.TEXTURE0),n.bindTexture(n.TEXTURE_2D,t);let a=0;e.posts.forEach(t=>{t.enabled&&this.enabled&&a++}),e.posts.forEach(t=>{if(t.enabled&&this.enabled){const s=r===a-1&&a>1?e.part?e.part.framebuffer:null:this.fbs[r%2];t.render(n,s,i,e.part),i=this.textures[r%2],n.activeTexture(n.TEXTURE0),n.bindTexture(n.TEXTURE_2D,i),r++}}),1===a&&e.part&&(n.bindFramebuffer(n.FRAMEBUFFER,e.part.framebuffer),n.drawBuffers([n.COLOR_ATTACHMENT0]),n.useProgram(this.renderer.program),n.activeTexture(n.TEXTURE0),n.drawArrays(n.TRIANGLES,0,3)),e.posts.forEach(t=>{if(t.enabled&&this.enabled){const s=r===a-1&&a>1?e.part?e.part.framebuffer:null:this.fbs[r%2];t.postRender(n,s,i,e.part)}})}}const T={alpha:0,antialias:0,background:"#000000",blockRender:0,depth:0,dpr:1,failIfMajorPerformanceCaveat:1,height:1080,powerPreference:"high-performance",premultipliedAlpha:0,preserveDrawingBuffer:0,stencil:0,width:1920};class S{options;context;program;buffer;textureLocation;postprocessing;constructor(t){void 0===t.canvas&&(t.canvas=document.createElement("canvas")),this.options={...T,...t},this.options.width*=this.options.dpr,this.options.height*=this.options.dpr,this.context=this.createWebGlContext(),this.context.getExtension("EXT_color_buffer_float"),this.context.viewport(0,0,this.options.width,this.options.height),this.program=((t,e,n,r,i)=>{const a=e+n;if(y.has(a))return y.get(a);const s=t.createProgram();if(t.attachShader(s,_(t,e??v,t.VERTEX_SHADER)),t.attachShader(s,_(t,n??x,t.FRAGMENT_SHADER)),r&&i&&t.transformFeedbackVaryings(s,r,i),t.linkProgram(s),t.validateProgram(s),y.set(a,s),!t.getProgramParameter(s,t.LINK_STATUS))throw new Error(`program failed to link: ${t.getProgramInfoLog(s)}`);return s})(this.context),this.context.useProgram(this.program),this.textureLocation=this.context.getUniformLocation(this.program,"texture"),this.buffer=this.context.createBuffer(),this.context.bindBuffer(this.context.ARRAY_BUFFER,this.buffer),this.context.bufferData(this.context.ARRAY_BUFFER,new Float32Array([1,1,1,-3,-3,1]),this.context.DYNAMIC_DRAW),this.postprocessing=new E(this)}createWebGlContext(){const t=this.options.canvas;t.id="demoCanvas",t.width=this.options.width,t.height=this.options.height,t.style.width=this.options.width/this.options.dpr+"px",t.style.height=this.options.height/this.options.dpr+"px",t.style.background=this.options.background;const e=t.getContext("webgl2",this.options);return e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,1),e}render(t,e,n=0){let r=e[0],i=null;for(let a=0;a<e.length;a++){const s=e[a];s.framebuffer?(s.setFramebuffer(),s.clearRendertarget(),s.preRender(t,this.context),s.render(t,s.getRTWebglTexture(),this.context),s.postRender(t,this.context,this.postprocessing),s.renderToScreen&&!n&&(r=s),s.renderDebug&&(i=s)):(s.preRender(t,this.context),s.render(t,s.getRTWebglTexture(),this.context),s.postRender(t,this.context,this.postprocessing))}if(n)this.context.flush(),this.context.getError();else{this.context.cullFace(this.context.BACK),this.context.disable(this.context.CULL_FACE);for(let t=0;t<80;t++)this.context.disableVertexAttribArray(1);this.context.useProgram(this.program);const t=this.context,e=t.getAttribLocation(this.program,"a_position");t.bindBuffer(this.context.ARRAY_BUFFER,this.buffer),t.enableVertexAttribArray(e),t.vertexAttribPointer(e,2,t.FLOAT,0,0,0),this.context.bufferData(this.context.ARRAY_BUFFER,new Float32Array([1,1,1,-3,-3,1]),this.context.DYNAMIC_DRAW),this.context.bindFramebuffer(this.context.FRAMEBUFFER,null),this.context.activeTexture(this.context.TEXTURE0),this.context.bindTexture(this.context.TEXTURE_2D,i?i.getRTWebglTexture():r.getRTWebglTexture()),this.context.uniform1i(this.textureLocation,0),this.context.drawArrays(this.context.TRIANGLES,0,3)}}initParts(t){t.forEach(t=>{t.renderAlwaysToScreen||(t.renderTo=t.createRenderTarget()??this.createRenderTarget(),t.framebuffer=this.createFrameBuffer(t.getRTWebglTexture(),void 0))})}createFrameBuffer(t,e){const n=this.context.createFramebuffer();return this.context.bindFramebuffer(this.context.FRAMEBUFFER,n),e||(e=this.context.COLOR_ATTACHMENT0),this.context.framebufferTexture2D(this.context.FRAMEBUFFER,e,this.context.TEXTURE_2D,t,0),n}createRenderTarget(t,e,n){t||(t=this.options.width),e||(e=this.options.height);const r=this.context.createTexture();this.context.bindTexture(this.context.TEXTURE_2D,r);const i=n?.internalFormat??this.context.RGBA16F,a=this.context.RGBA,s=this.context.FLOAT;return this.context.texImage2D(this.context.TEXTURE_2D,0,i,t,e,0,a,s,null),this.context.texParameteri(this.context.TEXTURE_2D,this.context.TEXTURE_MIN_FILTER,n?.filter?.min??this.context.LINEAR),this.context.texParameteri(this.context.TEXTURE_2D,this.context.TEXTURE_MAG_FILTER,n?.filter?.mag??this.context.LINEAR),this.context.texParameteri(this.context.TEXTURE_2D,this.context.TEXTURE_WRAP_S,n?.wrapping?.wrapS??this.context.CLAMP_TO_EDGE),this.context.texParameteri(this.context.TEXTURE_2D,this.context.TEXTURE_WRAP_T,n?.wrapping?.wrapT??this.context.CLAMP_TO_EDGE),r}}class M{x;y;constructor(t=0,e=0){this.x=t,this.y=e}length(){return Math.sqrt(this.x*this.x+this.y*this.y)}lengthSquared(){return this.x*this.x+this.y*this.y}}class w{part;posts;As(){return Object.fromEntries(this.posts)}constructor(t){this.posts=new Map,this.part=t}sort(t){this.posts=new Map([...this.posts.entries()].sort((e,n)=>t.indexOf(e[0])-t.indexOf(n[0])))}attach(t,e){if(e||(e=t.name),this.posts.has(e))throw new Error(`Adding a duplicate postprocess: ${e}`);this.posts.set(e,t)}deattach(t){this.posts.delete(t)}}var R,A,C;!function(t){t[t.max=0]="max",t[t.min=1]="min",t[t.average=2]="average"}(R||(R={}));class P{historySize=6;filters;historyLeft=[];historyRight=[];As(){return Object.fromEntries([...this.filters.entries()])}constructor(t){this.filters=new Map;for(let t=0;t<f.PRECISION;t++)this.historyLeft.push([]),this.historyRight.push([]);"legacy"!==t||(this.update=this.updateLegacy.bind(this))}addFilter(t,e){return t??=`filter-${this.filters.entries.length}`,e||(e={low:0,high:5e3,isolate:1,channel:.5,result:{triggered:0,max:0,min:0,accumulated:0}}),this.filters.set(t,e),e}removeFilter(t){this.filters.delete(t)}update(){if(this.filters.forEach(t=>{t.result.min=g.instance.state!==d.Running?0:1,t.result.max=0,t.result.triggered=0}),g.instance.state!==d.Running)return;const t=f.fft,e=t.sampleRate/f.PRECISION;for(let r=0;r<t.frequencyLeft.length;r++){const i=this.historyLeft[r];for(i.push(t.frequencyLeft[r]/255);i.length>this.historySize;)i.shift();const a=this.historyRight[r];for(a.push(t.frequencyRight[r]/255);a.length>this.historySize;)a.shift();let s=0;i.forEach(t=>s+=t),s/=this.historySize;let o=0;a.forEach(t=>o+=t),o/=this.historySize;const l=e*r;this.filters.forEach(t=>{const e=t.isolate?l>=t.low&&l<=t.high:l>t.high||l<t.low,r=n.lerp(s,o,t.channel)-(t.requireAmplitude??0);e&&r>=0&&(t.result.min=t.result.min>r?r:t.result.min,t.result.max=t.result.max<r?r:t.result.max,t.result.triggered=1)})}this.filters.forEach(t=>{t.result.triggered?t.accumulateType===R.min?t.result.accumulated+=t.result.min*g.instance.runner.delta:t.accumulateType===R.max?t.result.accumulated+=t.result.max*g.instance.runner.delta:t.result.accumulated+=(t.result.max+t.result.min)/2*g.instance.runner.delta:(t.result.min=0,t.result.max=0)})}updateLegacy(){this.filters.forEach(t=>{t.result.min=1,t.result.max=0,t.result.triggered=0});const t=f.fft,e=t.sampleRate/f.PRECISION;for(let n=0;n<t.frequencyLeft.length;n++){const r=this.historyLeft[n];for(r.push(t.frequencyLeft[n]/255);r.length>this.historySize;)r.shift();let i=0;r.forEach(t=>i+=t),i/=this.historySize;let a=e*n;this.filters.forEach(t=>{if((t.isolate?a>=t.low&&a<=t.high:a>t.high||a<t.low)&&i>=(t.requireAmplitude??0)){let e=i-(t.requireAmplitude??0);e*=1-t.channel,t.result.min=t.result.min>e?e:t.result.min,t.result.max=t.result.max<e?e:t.result.max,t.result.triggered=1}});const s=this.historyRight[n];for(s.push(t.frequencyRight[n]/255);s.length>this.historySize;)s.shift();i=0,s.forEach(t=>i+=t),i/=this.historySize,a=e*n,this.filters.forEach(t=>{if((t.isolate?a>=t.low&&a<=t.high:a>t.high||a<t.low)&&i>=(t.requireAmplitude??0)){let e=i-(t.requireAmplitude??0);e*=t.channel,t.result.min=t.result.min>e?e:t.result.min,t.result.max=t.result.max<e?e:t.result.max,t.result.triggered=1}})}this.filters.forEach(t=>{t.result.triggered&&(t.result.accumulated+=(t.result.max+t.result.min)/2)})}}!function(t){t[t.Trigger=0]="Trigger",t[t.Reactor=1]="Reactor",t[t.Curve=2]="Curve"}(A||(A={})),function(t){t[t.EnablePostProcess=0]="EnablePostProcess",t[t.EnableAudioAnalyzer=1]="EnableAudioAnalyzer",t[t.DefaultPostProcess=2]="DefaultPostProcess",t[t.DefaultAudioFilters=3]="DefaultAudioFilters",t[t.DefaultOnRender=4]="DefaultOnRender"}(C||(C={}));class D{renderer;context;id="";features=new Set([C.EnablePostProcess,C.EnableAudioAnalyzer]);renderAlwaysToScreen=0;renderToScreen=0;renderDebug=0;running=0;renderTo;framebuffer=null;clearColor=[0,0,0,1];postProcessing;analyser;triggers=new Set;reactors=new Set;curves=new Set;getTimelineEvents(){return[...[...this.triggers].map(t=>({startAt:t.triggerAt,type:A.Trigger})),...[...this.reactors].map(t=>({startAt:t.start,endAt:t.end,type:A.Reactor})),...[...this.curves].map(t=>({startAt:t.start,endAt:t.end,type:A.Curve}))]}constructor(t){this.id=t}onUpdate=t=>this.update(t.timesig);runTriggers(t){this.curves.forEach(e=>{if(t.isInside(e.start,e.end,e.start.pattern===h.RELATIVE?this.timeline.start:void 0)){const n=e.start.toMilliseconds(),r=e.end.toMilliseconds(),i=t.toMilliseconds()-(e.start.pattern===h.RELATIVE?this.timeline.start.toMilliseconds():0);e.onUpdate(e.curve((i-n)/(r-n)))}}),this.reactors.forEach(e=>{t.isInside(e.start,e.end,e.start.pattern===h.RELATIVE?this.timeline.start:void 0)&&(e.onUpdate(t),e.pattern.matchesPattern(t,e.pattern)&&e.onPattern(t))}),this.triggers.forEach(e=>{null!=e.triggered?e.triggerAt.matchesPattern(t,this.timeline.start)&&(void 0!==e.reverse&&e.reverse(t),e.triggered=null):e.triggerAt.matchesPattern(t,this.timeline.start)&&e.forward(t)})}update(t){}initPreCompile(){this.renderer=g.instance.renderer,this.context=this.renderer.context,this.features.has(C.EnableAudioAnalyzer)&&(this.analyser=new P(l().analyserVersion)),this.features.has(C.EnablePostProcess)&&(this.postProcessing=new w(this))}onStandardComplete(){}getPrograms(){if(this.postProcessing){const t=[];return this.postProcessing.posts.forEach(e=>{e.programs.forEach(e=>{t.push({program:e.program,fragmentShader:e.fragmentShader,vertexShader:e.vertexShader})})}),t}return[]}init(){this.postProcessing&&this.postProcessing.posts.forEach(t=>t.programReady())}updateProgram(t){}timeline;start(t,e){this.running||g.instance.onUpdate.connect(this.onUpdate),this.timeline=e,this.running=1}stop(){g.instance.onUpdate.disconnect(this.onUpdate),this.running=0}postInit(){}setFramebuffer(){this.renderer.context.bindFramebuffer(this.context.FRAMEBUFFER,this.framebuffer)}clearRendertarget(){this.context.clearColor(this.clearColor[0],this.clearColor[1],this.clearColor[2],this.clearColor[3]),this.context.clear(this.context.COLOR_BUFFER_BIT|this.context.DEPTH_BUFFER_BIT)}render(t,e,n){}preRender(t,e){this.analyser.update()}postRender(t,e,n){this.postProcessing&&n.render(this.getRTWebglTexture(),this.postProcessing)}addTrigger(t,e,n){const r={triggerAt:t,forward:e,reverse:n,triggered:null};return this.triggers.add(r),r}clearTrigger(t){this.triggers.delete(t)}addReactor(t,e,n,r,i){const a={start:t,end:e,pattern:n,onPattern:r,onUpdate:i};return this.reactors.add(a),a}removeReactor(t){this.reactors.delete(t)}addCurve(t,e,n,r){const i={start:t,end:e,onUpdate:n,curve:r??(t=>t)};return this.curves.add(i),i}removeCurve(t){this.curves.delete(t)}createRenderTarget(){}getRTWebglTexture(){return this.renderTo}}const U=document.createElement("div");class L{speeds=[];timestamp;timestampMs;timestampSeconds;fpsCounter;lastFrame=0;previousFrames=[];constructor(){if(!l().debug)return;const t=document.getElementById("debug-placeholder");this.timestamp=document.createElement("div"),this.timestampMs=document.createElement("div"),this.timestampSeconds=document.createElement("div"),this.fpsCounter=document.createElement("div"),t.appendChild(this.timestamp),t.appendChild(this.timestampMs),t.appendChild(this.timestampSeconds),t.appendChild(this.fpsCounter);const e=function(t){return U.innerHTML=t,U.firstElementChild}("\n<div id='debug-speed-control' style='background:#505050'>\nplayback speed\n\n<input id='debug-speed-control-⅛' name='debug-speed' type=\"radio\" value=\"0.125\" />\n<label for='debug-speed-control-⅛'>⅛</label>\n\n<input id='debug-speed-control-¼' name='debug-speed' type=\"radio\" value=\"0.25\" />\n<label for='debug-speed-control-¼'>¼</label>\n\n<input id='debug-speed-control-½' name='debug-speed' type=\"radio\" value=\"0.5\" />\n<label for='debug-speed-control-½'>½</label>\n\n<input id='debug-speed-control-1' checked=\"checked\" name='debug-speed' type=\"radio\" value=\"1\" />\n<label for='debug-speed-control-1'>1</label>\n\n<input id='debug-speed-control-2' name='debug-speed' type=\"radio\" value=\"2\" />\n<label for='debug-speed-control-2'>2</label>\n\n<input id='debug-speed-control-4' name='debug-speed' type=\"radio\" value=\"4\" />\n<label for='debug-speed-control-4'>4</label>\n\n</div>\n");t.appendChild(e);const n=e.querySelectorAll('input[type=radio][name="debug-speed"]');Array.prototype.forEach.call(n,t=>{t.addEventListener("change",()=>{const e=t.getAttribute("value"),n=Number.parseFloat(e);f.adjustSpeed(n)})}),g.instance.onUpdate.connect(this.onUpdate),window.addEventListener("keydown",t=>{const e=t.ctrlKey?p.toMilliseconds(0,0,1)/1e3:t.shiftKey?10:1;"ArrowLeft"===t.key?this.onLeft(e):"ArrowRight"===t.key?this.onRight(e):" "===t.key&&(t.preventDefault(),this.onPause())})}onUpdate=t=>{this.timestamp&&(this.timestamp.innerText=t.timesig.toString(0));const e=Date.now(),n=1e3/(e-this.lastFrame);this.lastFrame=e,this.previousFrames.push(n),this.previousFrames.length>10&&this.previousFrames.shift();const r=this.previousFrames.reduce((t,e)=>t+e,0)/this.previousFrames.length;this.fpsCounter.innerText=r.toFixed(2).toString();const i=t.timesig.toMilliseconds();this.timestampMs.innerText=Math.floor(i).toString(),this.timestampSeconds.innerText=`${Math.floor(i/6e4)}:${Math.floor(i%6e4/1e3)}`};moveTo(t){f.gotoPosition(t)}onPause=()=>{g.instance.state===d.Paused?g.instance.runner.resume():g.instance.runner.pause()};onLeft=t=>{this.moveTo(Math.max(0,f.position()-t))};onRight=t=>{this.moveTo(Math.min(f.duration,f.position()+t))}}class I{constructor(){}}class N{static set EnablePostProcessing(t){g.instance.renderer.postprocessing.enabled=t}}c("kvg.RuntimeConfig",N);class O{constructor(){const t=document.createElement("div");t.innerHTML='<div><label>Enable postprocessing <input type="checkbox" checked/></label></div>',document.getElementById("debug-placeholder")?.append(t);const e=t.getElementsByTagName("input")[0];e.addEventListener("change",()=>{N.EnablePostProcessing=e.checked})}}const F={automaticUniformSliderGeneration:1},B=localStorage.getItem("kvg-editor-options");if(B)try{const t=JSON.parse(B);Object.keys(t).forEach(e=>{Reflect.set(F,e,t[e])})}catch(t){}var k;!function(t){t[t.f1=0]="f1",t[t.f1v=1]="f1v",t[t.i1=2]="i1",t[t.i1v=3]="i1v",t[t.f2=4]="f2",t[t.f2v=5]="f2v",t[t.i2=6]="i2",t[t.i2v=7]="i2v",t[t.f3=8]="f3",t[t.f3v=9]="f3v",t[t.i3=10]="i3",t[t.i3v=11]="i3v",t[t.f4=12]="f4",t[t.f4v=13]="f4v",t[t.i4=14]="i4",t[t.i4v=15]="i4v"}(k||(k={}));class z{max;min;enableDebug=0;name;program;gl;uniformValue;location;changed=0;type;constructor(t,e,{type:n,value:r,name:i,max:a,min:s,generateDebugSlider:o,programId:c}){this.type=n,this.value=r,this.name=i,this.program=t,this.gl=e,this.location=e.getUniformLocation(t,i),this.changed=1,"_"!==this.name.charAt(0)&&F.automaticUniformSliderGeneration&&(o=1),o&&l().debugUniformSliders&&(this.enableDebug=1,a&&(this.max=a),s&&(this.min=s)),this.location}set value(t){this.changed=t!==this.uniformValue,this.uniformValue=t}get value(){return this.uniformValue}sync(){switch(this.type){case k.f1:this.gl.uniform1f(this.location,this.uniformValue);break;case k.f1v:this.gl.uniform1fv(this.location,this.uniformValue);break;case k.i1:this.gl.uniform1i(this.location,this.uniformValue);break;case k.i1v:this.gl.uniform1iv(this.location,this.uniformValue);break;case k.f2:{const t=this.uniformValue;this.gl.uniform2f(this.location,t.x,t.y);break}case k.f2v:this.gl.uniform2fv(this.location,this.uniformValue);break;case k.i2:{const t=this.uniformValue;this.gl.uniform2i(this.location,t.x,t.y);break}case k.i2v:this.gl.uniform2iv(this.location,this.uniformValue);break;case k.f3:{const t=this.uniformValue;this.gl.uniform3f(this.location,t.x,t.y,t.z);break}case k.f3v:this.gl.uniform3fv(this.location,this.uniformValue);break;case k.i3:{const t=this.uniformValue;this.gl.uniform3i(this.location,t.x,t.y,t.z);break}case k.i3v:this.gl.uniform3iv(this.location,this.uniformValue);break;case k.f4:{const t=this.uniformValue;this.gl.uniform4f(this.location,t.x,t.y,t.z,t.w);break}case k.f4v:this.gl.uniform4fv(this.location,this.uniformValue);break;case k.i4:{const t=this.uniformValue;this.gl.uniform4i(this.location,t.x,t.y,t.z,t.w);break}case k.i4v:this.gl.uniform4iv(this.location,this.uniformValue)}this.changed=0}}class V{x;y;z;constructor(t,e,n){this.x=t,this.y=e,this.z=n}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)}lengthSquared(){return this.x*this.x+this.y*this.y+this.z*this.z}}class H{x;y;z;w;constructor(t=0,e=0,n=0,r=0){this.x=t,this.y=e,this.z=n,this.w=r}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)}lengthSquared(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w}}function G(t){return Array.isArray(t)}function W(t){return"object"==typeof t&&Reflect.has(t,"range")&&Reflect.has(t,"label")}const X=new Map([[k.f1,1],[k.f1v,1],[k.f2,2],[k.f2v,2],[k.f3,3],[k.f3v,3],[k.f4,4],[k.f4v,4],[k.i1,1],[k.i1v,1],[k.i2,2],[k.i2v,2],[k.i3,3],[k.i3v,3],[k.i4,4],[k.i4v,4]]);function j(t){return[k.i1,k.i1v,k.i2,k.i2v,k.i3,k.i3v,k.i4,k.i4v].indexOf(t)>=0}const q=["x","y","z","w"];class Y{uniform;sliderContainers=[];isVector=0;hasMultipleSliders=0;defaultValue;constructor(t,e){this.uniform=t,this.isVector="object"==typeof t.value&&!Array.isArray(t.value);const n=document.createElement("div");n.classList.add("debug-container");const r=document.createElement("div"),i=document.createElement("label");r.classList.add("debug-label-container"),i.textContent=t.name,r.append(i),n.append(r);const a=X.get(t.type)??0;this.hasMultipleSliders=a>1;const s=t.value,o=t.max,l=t.min;this.defaultValue="object"==typeof t.value?Object.assign({},t.value):t.value;const c=[];for(let e=0;e<a;e++){const r=document.createElement("div");r.classList.add("debug-row-container"),this.sliderContainers.push(r);const i=1===a?"":q[e],h=Array.isArray(t.value);let u=this.getValue(l,e,0),d=this.getValue(o,e,100);const p=this.getValue(s,e,0);if(u=Math.min(u,p),d=Math.max(d,p),a>1){const t=document.createElement("label");t.textContent=i,r.append(t)}const f=document.createElement("input");f.type="range",f.classList.add("slider"),f.step=j(t.type)?"1":"0.001",f.max=d.toString(),f.min=u.toString(),f.value=p.toString(),f.addEventListener("input",this.onSliderChange(f,t,e)),c.push(f);const m=document.createElement("input");m.type="text",m.value="100",m.addEventListener("change",this.onValueChange(m,t,e,f)),r.append(f),r.append(m),n.append(r),g.instance.onDebugUpdate.connect(()=>{m!==document.activeElement&&(this.isVector||h?this.isVector?(f.value=Reflect.get(this.uniform.value,i).toString(),m.value=Reflect.get(this.uniform.value,i).toFixed(2)):(f.value=this.uniform.value[e].toString(),m.value=this.uniform.value[e].toFixed(2)):(f.value=this.uniform.value.toString(),m.value=this.uniform.value.toFixed(2)),this.minMaxUpdate(m,this.uniform,f))})}const h=document.createElement("input");h.type="button",h.value="S",h.addEventListener("click",()=>this.saveValues());const u=document.createElement("input");u.type="button",u.value="R",u.addEventListener("click",()=>this.resetDefaults()),r.append(h),r.append(u),e.append(n)}getValue(t,e,n){return t?(r=t)instanceof M||r instanceof V||r instanceof H?Reflect.get(t,q[e]):function(t){return Array.isArray(t)}(t)?t[e]:t:n;var r}parseValue(t,e){return j(e)?parseInt(t,10):parseFloat(t)}minMaxUpdate(t,e,n){const r=this.parseValue(t.value,e.type),i=this.parseValue(n.max,e.type),a=this.parseValue(n.min,e.type);[r,i,a].includes(NaN)||(n.max=Math.max(r,i,a).toString(),n.min=Math.min(r,i,a).toString())}onValueChange(t,e,n,r){return()=>{const i=this.parseValue(t.value,e.type);this.changeUniformValue(e,n,i),this.minMaxUpdate(t,e,r),r.value=i.toFixed(2)}}changeUniformValue(t,e,n){if(this.hasMultipleSliders){const r=t.value;this.isVector?r[q[e]]=n:r[e]=n,this.uniform.value=r}else this.uniform.value=n}onSliderChange(t,e,n){return()=>{const r=this.parseValue(t.value,e.type);this.changeUniformValue(e,n,r)}}resetDefaults(){"object"==typeof this.uniform.value?Object.assign(this.uniform.value,this.defaultValue):this.uniform.value=this.defaultValue}saveValues(){Object.assign(this.defaultValue,this.uniform.value),"object"==typeof this.uniform.value?Object.assign(this.defaultValue,this.uniform.value):this.defaultValue=this.uniform.value}destroy(){this.sliderContainers.forEach(t=>t.remove())}}class K{container;constructor(){this.container=document.createElement("div"),this.container.style.zIndex="50",this.container.style.background="none",this.container.style.overflowY="scroll",this.container.style.bottom="0px",this.container.addEventListener("mousemove",t=>t.stopImmediatePropagation()),document.getElementById("debug-placeholder").append(this.container),document.addEventListener("resize",this.onResize),this.onResize()}onResize=()=>{this.container.style.maxHeight=window.innerHeight-150+"px"};addPart(t){const e=document.createElement("div"),n=document.createElement("div"),r=document.createElement("div"),i=document.createElement("div");e.style.background="none",r.style.background="none",i.style.background="none";const a=document.createElement("div");a.style.display="flex",a.style.justifyContent="space-between";const s=document.createElement("input");s.type="button",s.value="Export",s.addEventListener("click",e=>this.exportAsJson(e,t)),a.appendChild(s);const o=document.createElement("span");o.textContent="Postprocessing",a.appendChild(o);const l=document.createElement("div");l.textContent="Uniforms",n.style.cursor="pointer",n.style.background="rgba(64,168,64,0.95)",n.style.borderBottom="3px solid rgba(64,128,64,1.0)",a.style.background="rgba(128,128,255,0.95)",l.style.background="rgba(128,128,255,0.95)",n.style.cursor="pointer",a.style.cursor="pointer",l.style.cursor="pointer",r.style.marginLeft="10px",i.style.marginLeft="10px",n.textContent=t.id,e.append(n),e.append(r),e.append(i),this.container.append(e),r.append(a),i.append(l),e.style.height="25px",r.style.height="auto",i.style.height="auto",e.style.overflow="hidden",r.style.overflow="hidden",i.style.overflow="hidden",n.addEventListener("click",()=>{e.style.height="auto"===e.style.height?"25px":"auto"}),a.addEventListener("click",()=>{r.style.height="auto"===r.style.height?"22px":"auto"}),l.addEventListener("click",()=>{i.style.height="auto"===i.style.height?"22px":"auto"}),t.postProcessing&&t.postProcessing.posts.forEach(t=>{const e=document.createElement("div"),n=document.createElement("div");n.style.cursor="pointer",n.textContent=t.constructor.name,n.style.textAlign="center",n.style.background="#603030",n.style.borderBottom="1px solid black",e.append(n),r.append(e),e.style.height="23px",e.style.overflow="hidden",n.addEventListener("click",()=>{e.style.height="auto"===e.style.height?"23px":"auto"}),t.uniforms.forEach(t=>{t.forEach(t=>{t.enableDebug&&new Y(t,e)})})}),function(t){return Reflect.has(t,"CreateUniform")}(t)&&t.uniforms.forEach(t=>{t.enableDebug&&new Y(t,i)})}exportAsJson(t,e){const n=["size","resolution"];t.stopImmediatePropagation();const r={};[...e.postProcessing.posts].forEach(t=>{const e={};[...t[1].uniforms].forEach(t=>{t[1].forEach(t=>{-1===n.indexOf(t.name)&&(e[t.name]=t.value)})}),r[t.constructor.name]=e})}}function Z(t){return Reflect.has(t,"CreateUniform")}class ${active=0;camera=[0,0,0];target=[0,0,0];fov=1;keysDown=new Map;theta=0;phi=0;debug;constructor(){this.debug=document.createElement("div"),this.debug.style.position="fixed",this.debug.style.top="0px",this.debug.style.left="0px",document.body.appendChild(this.debug),g.instance.beforeRender.connect(this.postRender),window.addEventListener("keydown",t=>{this.keysDown.set(t.key.toLowerCase(),1),"§"===t.key&&(this.active=!this.active,this.active&&this.readShaderValues()),t.key}),window.addEventListener("keyup",t=>{this.keysDown.set(t.key.toLowerCase(),0)});let t=0,e=0;window.addEventListener("mousedown",n=>{t=n.pageX,e=n.pageY}),window.addEventListener("mousemove",r=>{if(1===r.buttons){const i=r.pageX-t,a=r.pageY-e;t=r.pageX,e=r.pageY,this.phi+=i/500,this.theta+=a/500,this.theta=n.clamp(.01,Math.PI-.01,this.theta),this.target=[this.camera[0]+Math.sin(this.theta)*Math.sin(this.phi),this.camera[1]+Math.cos(this.theta),this.camera[2]+Math.sin(this.theta)*Math.cos(this.phi)]}})}postRender=()=>{if(!this.active)return;const t=this.keysDown.get("shift")?10:1;this.target=[this.camera[0]+Math.sin(this.theta)*Math.sin(this.phi),this.camera[1]+Math.cos(this.theta),this.camera[2]+Math.sin(this.theta)*Math.cos(this.phi)];const e=this.target[0]-this.camera[0],r=this.target[1]-this.camera[1],i=this.target[2]-this.camera[2],a=[e,r,i],s=n.normalize(n.cross(a,[0,1,0])),o=n.normalize(n.cross(a,[0,-1,0])),l=n.normalize(n.cross(a,s)),c=n.normalize(n.cross(a,o));this.keysDown.get("a")&&(this.camera[0]+=s[0]/100*t,this.camera[1]+=s[1]/100*t,this.camera[2]+=s[2]/100*t),this.keysDown.get("d")&&(this.camera[0]+=o[0]/100*t,this.camera[1]+=o[1]/100*t,this.camera[2]+=o[2]/100*t),this.keysDown.get("w")&&(this.camera[0]+=e/100*t,this.camera[1]+=r/100*t,this.camera[2]+=i/100*t),this.keysDown.get("s")&&(this.camera[0]-=e/100*t,this.camera[1]-=r/100*t,this.camera[2]-=i/100*t),this.keysDown.get("q")&&(this.camera[0]+=c[0]/100*t,this.camera[1]+=c[1]/100*t,this.camera[2]+=c[2]/100*t),this.keysDown.get("e")&&(this.camera[0]+=l[0]/100*t,this.camera[1]+=l[1]/100*t,this.camera[2]+=l[2]/100*t),this.target=[this.camera[0]+Math.sin(this.theta)*Math.sin(this.phi),this.camera[1]+Math.cos(this.theta),this.camera[2]+Math.sin(this.theta)*Math.cos(this.phi)],g.instance.activeParts.forEach(t=>{if(Z(t)){const e=t.uniforms.find(t=>"camera"===t.name);e&&(e.value=this.camera);const n=t.uniforms.find(t=>"fov"===t.name);n&&(n.value=this.fov);const r=t.uniforms.find(t=>"target"===t.name);r&&(r.value=this.target),this.debug.innerHTML="CAM:"+this.camera.map(t=>t.toFixed(2)).join(",")+"<br/>TGT:"+this.target.map(t=>t.toFixed(2)).join(",")}})};readShaderValues=()=>{g.instance.activeParts.forEach(t=>{if(Z(t)){const e=t.uniforms.find(t=>"camera"===t.name);e&&(this.camera=e.value);const n=t.uniforms.find(t=>"fov"===t.name);n&&(this.fov=n.value);const r=t.uniforms.find(t=>"target"===t.name);r&&(this.target=r.value);const i=this.target[0]-this.camera[0],a=this.target[1]-this.camera[1],s=this.target[2]-this.camera[2],o=Math.sqrt(i*i+a*a+s*s);this.target[0]=this.camera[0]+i/o,this.target[1]=this.camera[1]+a/o,this.target[2]=this.camera[2]+s/o,this.theta=Math.acos(a/o),this.phi=Math.atan2(i/o,s/o),this.target=[this.camera[0]+Math.sin(this.theta)*Math.sin(this.phi),this.camera[1]+Math.cos(this.theta),this.camera[2]+Math.sin(this.theta)*Math.cos(this.phi)]}})}}class J{container;trackA;trackB;aTS=new p;bTS;totalTime;spacerContainer;dragging;constructor(t){this.bTS=t.clone(),this.totalTime=t.clone(),this.container=document.createElement("div"),this.container.style.position="absolute",this.container.style.display="block",this.container.style.width="100%",this.container.style.height="22px",this.container.style.textAlign="center",this.container.style.userSelect="none",this.spacerContainer=document.createElement("div"),this.spacerContainer.style.position="absolute",this.spacerContainer.style.pointerEvents="none",this.spacerContainer.style.width="100%",this.spacerContainer.style.height="22px",this.spacerContainer.style.userSelect="none",this.container.appendChild(this.spacerContainer);for(let e=0;e<t.bar;e++){const n=document.createElement("span");n.textContent="|",n.style.fontWeight=e%4==0?"bold":"normal",n.style.position="absolute",n.style.textIndent="-4px",n.style.left=p.toMilliseconds(e,0,0)/t.toMilliseconds()*100+"%",this.spacerContainer.appendChild(n)}const e=document.createElement("span");e.style.marginLeft="-2px",e.style.width="4px",e.style.background="white",e.style.position="absolute",e.style.fontSize="20px",e.style.height="200px",e.style.zIndex="99",e.style.marginTop="4px",this.container.appendChild(e),g.instance.onDebugUpdate.connect(n=>{e.style.left=n.timesig.toMilliseconds()/t.toMilliseconds()*100+"%",this.aTS.toMilliseconds()>0&&this.bTS.toMilliseconds()<this.totalTime.toMilliseconds()&&(n.timesig.toMilliseconds()>this.bTS.toMilliseconds()||n.timesig.toMilliseconds()<this.aTS.toMilliseconds())&&f.gotoPosition(this.aTS.toMilliseconds()/1e3)}),this.trackA=document.createElement("div"),this.trackA.innerHTML="\n        <div style='background:green; width:14px; height:14px; transform:rotate(45deg); transform-origin:50% 50%; position:absolute; left:3px; top:10px;'></div>\n        <div style='background:green; position:absolute; width:20px; height:20px;'>A</div>\n        ",this.trackA.style.position="absolute",this.trackA.style.left="10%",this.trackA.style.top="-24px",this.trackA.style.width="20px",this.trackA.style.height="30px",this.trackA.style.marginLeft="-10px",this.container.appendChild(this.trackA),this.trackB=document.createElement("div"),this.trackB.innerHTML="\n        <div style='background:green; width:14px; height:14px; transform:rotate(45deg); transform-origin:50% 50%; position:absolute; left:3px; top:10px;'></div>\n        <div style='background:green; position:absolute; width:20px; height:20px;'>B</div>\n        ",this.trackB.style.position="absolute",this.trackB.style.right="10%",this.trackB.style.top="-24px",this.trackB.style.width="20px",this.trackB.style.height="30px",this.trackB.style.marginRight="-10px",this.container.appendChild(this.trackB),this.updatePositions(),this.trackA.addEventListener("pointerdown",this.startDrag(this.trackA)),this.trackB.addEventListener("pointerdown",this.startDrag(this.trackB)),window.addEventListener("pointerup",this.mouseUp),window.addEventListener("pointermove",this.mouseMove)}mouseMove=t=>{const e=t.pageX/window.innerWidth*this.totalTime.toMilliseconds();this.dragging===this.trackA&&e<this.bTS.toMilliseconds()&&(this.aTS.fromTime(Math.max(0,e)/1e3/60),this.updatePositions()),this.dragging===this.trackB&&e>this.aTS.toMilliseconds()&&(this.bTS.fromTime(Math.min(this.totalTime.toMilliseconds(),e)/1e3/60),this.updatePositions())};mouseUp=()=>{this.dragging=void 0};startDrag(t){return()=>{this.dragging=t}}updatePositions(){this.trackA.style.left=this.aTS.toMilliseconds()/this.totalTime.toMilliseconds()*100+"%",this.trackB.style.right=(this.totalTime.toMilliseconds()-this.bTS.toMilliseconds())/this.totalTime.toMilliseconds()*100+"%"}}const Q=["#ff0000","#00ff00","#0000ff","#ffff00","#00ffff","#ff00ff"],tt=["#151515","#050505"];let et=0;class nt{part;container;start;end;constructor(t,e){this.start=p.toMilliseconds(t.start[0],t.start[1],t.start[2]),this.end=p.toMilliseconds(t.end[0],t.end[1],t.end[2]),this.part=t,this.container=document.createElement("div"),this.container.style.position="absolute",this.container.style.display="block",this.container.style.width="100%",this.container.style.height="22px",this.container.style.background=tt[et%tt.length],this.container.style.textAlign="center",this.container.innerHTML=`\n        <div style='display:inline-block;'>\n            <div style='position:relative'></div>\n            <span style='text-shadow: 0px 0px 4px black, 0px 0px 2px black'>${t.instanceId}</span>            \n        </div>\n        `;const n=this.container.children[0];n.style.position="absolute",n.style.background=Q[et%Q.length],n.style.width=(this.end-this.start)/e.toMilliseconds()*100+"%",n.style.left=this.start/e.toMilliseconds()*100+"%",et++}markers={[A.Trigger]:{text:"T",absoluteBackground:"#5e5b00",relativeBackground:"a6a003"},[A.Curve]:{text:"C",absoluteBackground:"#75000b",relativeBackground:"#ad2633"},[A.Reactor]:{text:"R",absoluteBackground:"#0f5c00",relativeBackground:"#0e2e08"}};getMarker(t){const e=t.type,n=t.startAt.pattern===h.ABSOLUTE,r=this.markers[e],i=document.createElement("div");return i.style.width="10px",i.style.height="10px",i.style.fontSize="8px",i.style.color="white",i.style.backgroundColor=n?r.absoluteBackground:r.relativeBackground,i.innerHTML=r.text,i.style.position="absolute",i.style.zIndex="999",t.type===A.Curve&&(i.style.top="12px"),t.startAt.pattern===h.RELATIVE?i.style.left=t.startAt.toMilliseconds()/(this.end-this.start)*100+"%":t.startAt.pattern===h.ABSOLUTE&&(i.style.left=(t.startAt.toMilliseconds()-this.start)/(this.end-this.start)*100+"%"),i}attachTimelineEvents(t){t.forEach(t=>{if(t.startAt.toMilliseconds()>this.end)return;const e=this.getMarker(t);this.container.children[0].children[0].append(e)})}}class rt{tracks=[];container;playHead;totalTime;constructor(){this.container=document.createElement("div"),this.container.id="debug-timeline",this.container.style.position="fixed",this.container.style.bottom="0px",this.container.style.left="0px",this.container.style.right="0px",this.container.style.background="black",this.container.addEventListener("pointermove",this.onPointerMove),this.container.addEventListener("pointerdown",this.onPointerMove),document.body.appendChild(this.container),this.buildTrack(l()),g.instance.options.parts.forEach(t=>{this.tracks.filter(e=>e.part.instanceId===t.id).forEach(e=>e.attachTimelineEvents(t.getTimelineEvents()))})}onPointerMove=t=>{if(1===t.buttons){const e=t.pageX/window.innerWidth*this.totalTime.toMilliseconds();f.gotoPosition(e/1e3)}};buildTrack(t){let e=t.parts[0].end;for(let n=1;n<t.parts.length;n++){const r=t.parts[n].end;r[0]>e[0]&&(e=r)}const n=new p(e[0],e[1],e[2],h.ABSOLUTE);this.totalTime=n,this.playHead=new J(n),this.playHead.container.style.bottom=22*t.parts.length+"px",this.container.appendChild(this.playHead.container),t.parts.forEach((t,e)=>{const r=new nt(t,n);this.container.appendChild(r.container),this.tracks.push(r),r.container.style.top=22*e+"px",r.container.style.pointerEvents="none"}),this.container.style.height=22*t.parts.length+"px"}}class it{constructor(){const t=document.createElement("div");t.innerHTML="<div>Shader constants</div>";const e=l().shaderConstants;for(const n in e){const r=e[n],i=document.createElement("div");if(i.innerHTML=`${n}:${r}`,i.style.width="150px","#"===r.charAt(0))i.style.background=r;else if(r.indexOf("vec")>=0){const t=r.substring(5).split(",").map(t=>Math.round(255*parseFloat(t))),e="#"+(t[0]<<16|t[1]<<8|t[2]).toString(16);i.style.background=`rgb(${t[0]},${t[1]},${t[2]}`,i.innerHTML=`${n}:${e}`;const a=(t[0]+t[1]+t[2])/3<128?"#ffffff":"#000000";i.style.color=a}t.appendChild(i)}t.style.position="fixed",t.style.top="50px",t.style.left="0px",document.getElementById("debug-placeholder")?.appendChild(t)}}class at{canvasW=512;canvasH=512;container;canvas;ctx;bandPass;gainNode;context;low=0;high=24e3;zoom=4;enabled=0;lowTrigger=0;highTrigger=1;filter;analyzer;constructor(){this.container=document.createElement("div"),this.container.innerHTML='\n        <select  style=\'float:left\'>\n            <option value="frequency">Frequency</option>\n            <option value="waveform">Waveform</option>\n            <option value="db">Db</option>\n        </select>\n        <label style="float:right">Enable frequency isolation<input type="checkbox"/></label>\n        <canvas style="clear:both; display:block" transform-origin:0 0\'></canvas>\n        <br/>\n        <div style=\'float:left\' id=\'debug-fft-left\'>2000hz</div>\n        <div style=\'float:right\' id=\'debug-fft-right\'>4000hz</div>\n        <br/>\n        <div id=\'debug-fft-peak\' style="clear:both">2000hz</div>\n        ',this.container.style.transform="scale(0.5, 0.5)",this.container.style.transformOrigin="0 0",this.container.style.zIndex="99",this.canvas=this.container.getElementsByTagName("canvas")[0],this.canvas.width=this.canvasW,this.canvas.height=this.canvasH,this.ctx=this.canvas.getContext("2d"),this.container.style.position="fixed",this.container.style.top="300px",this.container.style.left="10px",g.instance.onDebugUpdate.connect(this.update),document.getElementById("debug-placeholder")?.appendChild(this.container),this.gainNode=f.getGainNode(),this.context=f.getContext(),this.container.querySelector("input")?.addEventListener("click",()=>{this.enabled=!this.enabled,this.enabled?(this.container.style.transform="scale(1,1)",this.gainNode.disconnect(this.context.destination),this.gainNode.connect(this.bandPass).connect(this.context.destination)):(this.lowTrigger=0,this.highTrigger=1,this.low=0,this.high=this.context.sampleRate,this.container.style.transform="scale(0.5,0.5)",this.gainNode.disconnect(this.bandPass),this.bandPass.disconnect(this.context.destination),this.gainNode.connect(this.context.destination))}),this.bandPass=this.context.createBiquadFilter(),this.bandPass.type="bandpass",this.bandPass.frequency.value=2e3,this.bandPass.Q.value=1,this.analyzer=new P(l().analyserVersion),this.filter=this.analyzer.addFilter(),this.filter.low=0,this.filter.channel=0,this.filter.high=this.context.sampleRate,this.canvas.addEventListener("mousedown",t=>{if(!this.enabled)return;const e=t.target.getBoundingClientRect(),r=t.clientX-e.left;this.low=n.clamp(0,this.context.sampleRate,r/this.zoom/this.canvasW*this.context.sampleRate);const i=t.clientY-e.top;this.lowTrigger=n.clamp(0,1,(this.canvasH-i)/this.canvasH),this.setupBandPass(this.low,this.high)}),this.canvas.addEventListener("mousemove",t=>{if(this.enabled&&1===t.buttons){const e=t.target.getBoundingClientRect(),r=t.clientX-e.left,i=n.clamp(0,this.context.sampleRate,r/this.zoom/this.canvasW*this.context.sampleRate);i<this.low?this.low=i:this.high=i;const a=t.clientY-e.top;this.highTrigger=n.clamp(0,1,(this.canvasH-a)/this.canvasH),this.setupBandPass(this.low,this.high),t.preventDefault()}}),this.canvas.addEventListener("mouseup",t=>{if(!this.enabled)return;const e=t.target.getBoundingClientRect(),r=t.clientX-e.left,i=n.clamp(0,this.context.sampleRate,r/this.zoom/this.canvasW*this.context.sampleRate);i<this.low?this.low=i:this.high=i;const a=t.clientY-e.top;this.highTrigger=n.clamp(0,1,(this.canvasH-a)/this.canvasH),this.setupBandPass(this.low,this.high)})}setupBandPass(t,e){0===t&&(t=1),t===e&&(e=t+Math.ceil(this.context.sampleRate/f.PRECISION));const n=Math.sqrt(t*e);if(this.bandPass.frequency.value=n,this.bandPass.Q.value=n/(e-t),this.high=e,this.low=t,this.highTrigger<this.lowTrigger){const t=this.lowTrigger;this.lowTrigger=this.highTrigger,this.highTrigger=t}this.highTrigger,this.lowTrigger,this.filter.low=this.low,this.filter.high=this.high,this.container.querySelector("#debug-fft-left").textContent=this.low.toString()+"Hz : "+this.lowTrigger.toPrecision(2),this.container.querySelector("#debug-fft-right").textContent=this.high.toString()+"Hz : "+this.highTrigger.toPrecision(2)}update=()=>{this.ctx.clearRect(0,0,this.canvasW,this.canvasH),this.analyzer.update();const t=n.clamp(0,255,(this.filter.result.max-this.lowTrigger)/(this.highTrigger-this.lowTrigger)*255);this.ctx.fillStyle=`#${(0|t).toString(16).padStart(2,"0")}0000`,this.ctx.fillRect(0,0,this.canvasW,this.canvasH),this.ctx.fillStyle="#ffffff";const e=this.container.getElementsByTagName("select")[0].value;if("waveform"===e){this.ctx.strokeStyle="#ffffff",this.ctx.lineWidth=1,this.ctx.beginPath(),this.ctx.moveTo(0,this.canvasH/2);for(let t=0;t<this.canvasW;t++){const e=Math.floor(t/this.canvasW*f.PRECISION),n=f.fft.waveformLeft[e]/128*this.canvasH/2;this.ctx.lineTo(t,n)}this.ctx.stroke()}else if("frequency"===e){let t=0;for(let e=0;e<f.PRECISION/this.zoom;e++){const n=f.fft.frequencyLeft[e];e<this.low/(this.context.sampleRate/f.PRECISION)||e>this.high/(this.context.sampleRate/f.PRECISION)?this.ctx.fillStyle="#333333":(this.ctx.fillStyle="#ffffff",t=Math.max(t,n));const r=n/255*this.canvasH;this.ctx.fillRect(Math.floor(e/f.PRECISION*this.canvasW)*this.zoom,this.canvasH-r,this.zoom,r)}this.ctx.strokeStyle="rgba(0,255,0,1)",this.ctx.beginPath(),this.ctx.rect(this.low/this.context.sampleRate*this.zoom*this.canvasW|0,(1-this.highTrigger)*this.canvasH|0,(this.high-this.low)/this.context.sampleRate*this.zoom*this.canvasW|0,(this.highTrigger-this.lowTrigger)*this.canvasH|0),this.ctx.stroke(),this.ctx.strokeStyle="rgba(0,0,0,0)",this.container.querySelector("#debug-fft-peak").textContent=`${t}:${(t/255).toFixed(3)}`}else if("db"===e)for(let t=0;t<f.PRECISION;t++){const e=this.canvasH+f.fft.dbLeft[t];this.ctx.fillRect(Math.floor(t/f.PRECISION*this.canvasW),this.canvasH-e,1,e)}}}class st{static timecontrol;static midiControl;static runtimePanel;static sliders;static runTimeCameraControl;static timeline;static shaderConstants;static fftDisplay;static INIT(){if(!l().debug)throw new Error("Tried to initialize debug without debug flag");st.runtimePanel=new O,st.timecontrol=new L,st.midiControl=new I,st.sliders=new K,st.runTimeCameraControl=new $,st.shaderConstants=new it,st.fftDisplay=new at,st.timeline=new rt;const t=document.getElementById("demo");t&&(t.classList.add("enable-cursor"),t.style.position="relative"),g.instance.options.parts.forEach(t=>{st.sliders.addPart(t)});const e=document.getElementById("debug-placeholder");location.hash.indexOf("hideDebug")>=0&&(e.style.display="none"),document.addEventListener("keypress",t=>{"m"===t.key&&(e.style.display="none"===e.style.display?"":"none")})}}function ot(t){return new Promise(e=>{window.setTimeout(e,t)})}c("kvg.Debug",st);class lt{shaderCache=new Map;overlay;renderer;config;parts;timeline;constructor(t,e,n,r){this.renderer=t,this.overlay=e,this.config=n,this.parts=r,this.timeline=this.buildTimeline(),o=n}build=async(t,e)=>{this.timeline.forEach(t=>{if(-1===this.parts.indexOf(t.partInstance))throw new Error(`Missing instantiated part for ${t.id}. Check your configuration and Main.ts`)});const n=new g({overlay:this.overlay,parts:this.parts,renderer:this.renderer,timeline:this.timeline,looping:this.config.looping}),r=this.renderer.context;this.parts.map(t=>t.initPreCompile()),e&&e.onPartPreCompile&&this.parts.filter(t=>t.features.has(C.DefaultPostProcess)).map(t=>e.onPartPreCompile(t)),this.parts.map(t=>t.onStandardComplete());const i=this.parts.map(t=>({Id:t.id,Shaders:t.getPrograms()})),a=window.navigator.userAgent.indexOf("Firefox")>=0;if(this.config.enableKHRParallelCompilation&&!a){r.getExtension("KHR_parallel_shader_compile")}t(.1),await ot(50);const s=i.map(e=>{const n=[];for(let i=0;i<e.Shaders.length;i++){const a=e.Shaders[i],s=this.replaceConstants(a.vertexShader??v,this.config.shaderConstants);let o=this.shaderCache.get(s);if(!o){o=r.createShader(r.VERTEX_SHADER),r.shaderSource(o,s),r.compileShader(o);if(!r.getShaderParameter(o,r.COMPILE_STATUS)){r.getShaderInfoLog(o)}this.shaderCache.set(s,o)}const l=this.replaceConstants(a.fragmentShader??x,this.config.shaderConstants);let c=this.shaderCache.get(l);if(!c){c=r.createShader(r.FRAGMENT_SHADER),r.shaderSource(c,l),r.compileShader(c);if(!r.getShaderParameter(c,r.COMPILE_STATUS)){document.getElementsByTagName("body")[0].classList.add("error");r.getShaderInfoLog(c)}this.shaderCache.set(l,c)}const h=a.program??r.createProgram();r.attachShader(h,o),r.attachShader(h,c),this.config.debug&&(h.dbg={part:e.Id,fragment:a.fragmentShader,vertex:a.vertexShader}),n.push({vs:o,fs:c,program:h,customProgram:void 0!==a.program}),t(.1+i/n.length*.3)}return{id:e.Id,shaders:e.Shaders,programs:n}});return s.forEach((e,n)=>{e.programs.forEach(t=>{r.linkProgram(t.program)}),t(.4+.1*n/s.length)}),await this.checkLinkingStatus(s,r,t),s.forEach(t=>t.programs.forEach(t=>{t.customProgram||this.useShader(r,t.program)})),s.forEach(t=>this.getPart(t.id).updateProgram(t.programs)),this.parts.forEach(t=>{e&&e.onPartInit&&(t.features.has(C.DefaultAudioFilters)||t.features.has(C.DefaultPostProcess))&&e.onPartInit(t),t.init()}),this.renderer.initParts(this.parts),this.parts.forEach(t=>t.postInit()),e&&n.beforeRender.connect(t=>{t.rendered.forEach(n=>{n.features.has(C.DefaultOnRender)&&e.onPartRender(t.timesig,n)})}),this.config.debug&&st.INIT(),n};checkLinkingStatus(t,e,n){return new Promise(r=>{const i=t.map(t=>t.programs).flat().map(t=>t.program);let a;const s=()=>(a=function*(t,e){const n=e.getExtension("KHR_parallel_shader_compile");let r=t.slice();for(;r.length;){if(n)r=r.filter(t=>!e.getProgramParameter(t,n.COMPLETION_STATUS_KHR));else{const t=r.pop();e.getProgramParameter(t,e.LINK_STATUS)}if(!r.length)return;n&&(yield 1-r.length/t.length)}}(i,e).next(),a.done?n(1):n(.5+.5*a.value),a.done);for(;!s();)new Promise(t=>setTimeout(t,50));r()})}useShader=(t,e)=>{t.useProgram(e);const n=t.getAttribLocation(e,"a_position"),r=t.createBuffer();t.bindBuffer(t.ARRAY_BUFFER,r);t.bufferData(t.ARRAY_BUFFER,new Float32Array([1,1,1,-3,-3,1]),t.STATIC_DRAW);const i=t.createVertexArray();t.bindVertexArray(i),t.enableVertexAttribArray(n),t.viewport(0,0,t.canvas.width,t.canvas.height),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT),t.uniform2fv(t.getUniformLocation(e,"resolution"),[this.renderer.options.width,this.renderer.options.height]),t.bindVertexArray(i)};replaceConstants(t,e){if(!t)return t;for(const r in e){let i=e[r];i.length>0&&"#"===i[0]&&(i=`vec3(${n.hexToArray(parseInt(e[r].substr(1),16)).join(",")})`),t=t.replace(new RegExp("\\$\\{"+r+"\\}","g"),i)}return t}buildTimeline=()=>this.config.parts.map((t,e)=>({id:t.instanceId,part:t.instanceId,partInstance:this.getPart(t.instanceId),start:s(t.start),end:s(t.end),requires:t.requires??[],options:t.options,dontRenderToScreen:t.dontRenderToScreen,running:0}));getPart=t=>this.parts.find(e=>e.id===t)??{}}class ct{container;elements=new Map;images;textures;width=1280;height=720;constructor(t,e){this.images=t,this.textures=e,this.container=document.createElement("div"),this.container.style.position="absolute",this.container.style.zIndex="10",this.container.style.background="transparent",this.container.style.overflow="hidden"}async preload(){return new Promise(t=>{let e=0;const n=this.images.length+this.textures.length;0===n&&t(),this.images.forEach(r=>{const i=document.createElement("img");i.onload=()=>{++e===n&&t()},i.src=r,this.elements.set(r,i),this.container.appendChild(i),i.style.position="absolute",-1===i.src.indexOf("logo")?(i.classList.add("hide"),i.classList.add("animate")):i.style.display="none"}),this.textures.forEach(r=>{const i=document.createElement("img");i.onload=()=>{++e===n&&t()},i.src=r,this.elements.set(r,i)})})}resize(t,e){this.width=t,this.height=e,this.container.style.width=`${t}px`,this.container.style.height=`${e}px`,this.elements.forEach(e=>{if(this.images.indexOf(e.src)>=0){const n=t/1920;e.style.width=n*e.width+"px",e.style.height=n*e.height+"px",e.style.left=n*(this.width-e.width)/2+"px",e.style.top=n*(this.height-e.height)/2+"px"}})}showImage(t,e={x:0,y:0},n="show"){if(!this.elements.has(t))return;const r=this.elements.get(t);r.classList.add(n),r.style.display="block",r.id=t;const i=this.width/1920;r.style.left=e.x*i-r.width/2+"px",r.style.top=e.y*i-r.height/2+"px",r.style.transform=`scale(${i},${i})`}hide(t,e){if(!this.elements.has(t))return;const n=this.elements.get(t);e?n?.classList.add(e):n?.classList.remove("show")}hideAll(){this.elements.forEach(t=>{t.style.display="none"})}}class ht{fftDataCanvas;fftDataContext;imageData;texture;gl;constructor(t,e){this.gl=t,this.fftDataCanvas=document.createElement("canvas"),this.fftDataCanvas.width=f.PRECISION,this.fftDataCanvas.height=2,this.fftDataContext=this.fftDataCanvas.getContext("2d"),this.imageData=this.fftDataContext.getImageData(0,0,f.PRECISION,2),this.texture=e.createRenderTarget(f.PRECISION,2)}update(){for(let t=0;t<f.PRECISION;t++)this.imageData.data[4*t]=f.fft.frequencyLeft[t],this.imageData.data[4*t+1]=f.fft.frequencyLeft[t],this.imageData.data[4*t+2]=f.fft.frequencyLeft[t],this.imageData.data[4*t+3]=255,this.imageData.data[4*t+2048]=f.fft.frequencyRight[t],this.imageData.data[4*t+2048+1]=f.fft.frequencyRight[t],this.imageData.data[4*t+2048+2]=f.fft.frequencyRight[t],this.imageData.data[4*t+2048+3]=255;this.fftDataContext.putImageData(this.imageData,0,0),this.gl.bindTexture(this.gl.TEXTURE_2D,this.texture),this.gl.texImage2D(this.gl.TEXTURE_2D,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,this.fftDataCanvas)}}class ut{inputResolutions=[];inputDPRQ;inputDPR0;inputDPR1;inputDPR2;inputDPR3;inputAAOff;inputAA2x;inputAA4x;inputAA8x;inputLockAspect;inputDebug;inputMuted;buttonStartWindowed;buttonStartFullscreen;looping;demoLauncherBar;demoLauncherBarText;config;demoContainer;setupContainer;loaderContainer;demo;parts;partsById=new Map;renderer;overlay;creationEvents;defaultPartCallbacks;constructor(t,e,n,r){if(null==t)throw new Error("invalid configuration");t={...new a,...t},this.creationEvents=n,this.defaultPartCallbacks=r,f.PRECISION=t.precision??f.PRECISION;const i=/#config=([^#]*)/.exec(location.hash);i&&(t.parts=[JSON.parse(decodeURI(i[1]).toLowerCase())],e=e.filter(e=>void 0!==t.parts.find(t=>t.instanceId.toLowerCase()===e.id.toLowerCase())));const s=/#part=([^#]*)/.exec(location.hash);if(s){const n=s[1].toLowerCase();t.parts=[{instanceId:n,start:[0,0,0],end:[140,0,0]}],e=e.filter(t=>t.id===n)}e.forEach(t=>{if(this.partsById.has(t.id))throw new Error("Trying to initialize part with existing name '"+t.id+"'");this.partsById.set(t.id,t)}),this.config=t,this.parts=e,"loading"===document.readyState?document.addEventListener("DOMContentLoaded",this.onDomContentReady):this.onDomContentReady()}testWebglFeatures=()=>{const t=document.createElement("canvas").getContext("webgl2");if(!t)return" Webgl2 not supported. Demo will not work.";return t.getExtension("KHR_parallel_shader_compile")?void 0:" Paraller compilation not supported. Startup might hang browser for a moment."};onDomContentReady=async()=>{document.removeEventListener("DOMContentLoaded",this.onDomContentReady);const t=this.testWebglFeatures();if(t){const e=document.getElementById("webglWarning");e.style.display="block",e.childNodes[1].textContent=t}"file:"===document.location.protocol&&this.showLocalFileWarning(),this.showZoomWarning(),window.addEventListener("resize",this.showZoomWarning),document.title=this.config.title,document.getElementById("title").textContent=this.config.title,document.querySelector("#aspectLock label").textContent="Lock "+(W(this.config.aspectRatio)?this.config.aspectRatio.label:"16:9"),this.setupContainer=document.getElementById("setup"),this.setupContainer.style.display="none",this.demoContainer=document.getElementById("demo"),this.loaderContainer=document.getElementById("loader"),this.demoLauncherBar=document.getElementById("launcherBar"),this.demoLauncherBarText=document.getElementById("launcherBarText");const e=document.getElementById("resolution");this.config.resolutions?.forEach(t=>{const n=document.createElement("input");n.type="radio",n.name="resolution",n.value=t.label,n.id=`resolution-${t.label}`;const r=document.createElement("label");r.setAttribute("for",n.id),r.textContent=t.label,r.classList.add("btn","btn-default"),t.default&&(r.classList.add("active"),n.checked=1),e.appendChild(n),e.appendChild(r),this.inputResolutions.push(n)}),this.inputDPRQ=document.getElementById("setup-dpr-q"),this.inputDPR0=document.getElementById("setup-dpr-0"),this.inputDPR1=document.getElementById("setup-dpr-1"),this.inputDPR2=document.getElementById("setup-dpr-2"),this.inputDPR3=document.getElementById("setup-dpr-3"),this.inputLockAspect=document.getElementById("setup-aspect-lock"),this.inputAAOff=document.getElementById("setup-aa-0"),this.inputAA2x=document.getElementById("setup-aa-2"),this.inputAA4x=document.getElementById("setup-aa-4"),this.inputAA8x=document.getElementById("setup-aa-8"),this.inputMuted=document.getElementById("setup-muted"),this.inputDebug=document.getElementById("setup-debug"),this.buttonStartFullscreen=document.getElementById("setup-fullscreen"),this.buttonStartWindowed=document.getElementById("setup-windowed"),this.looping=document.getElementById("setup-looping"),this.inputDPRQ.onclick=this.inputDPR0.onclick=this.showLowDprWarning,this.inputDPR2.onclick=this.inputDPR3.onclick=this.showHighDprWarning,this.inputDPR1.onclick=this.hideDprWarning,this.buttonStartFullscreen.onclick=this.onFullScreenClick,this.buttonStartWindowed.onclick=this.onWindowedClick;const n=this.config.shaderConstants["AA-LEVEL"];"0.0"===n?this.inputAAOff.checked=1:"2.0"===n?this.inputAA2x.checked=1:"4.0"===n?this.inputAA4x.checked=1:"8.0"===n&&(this.inputAA8x.checked=1),window.innerWidth,this.loadSettings(),this.overlay=new ct(this.config.images??[],this.config.textures??[]),await this.overlay.preload(),f.INIT();await f.loadMusic(this.config.music);this.setupContainer.style.display="",this.loaderContainer.style.display="none"};loadSettings(){const t=localStorage.getItem(l().debug?"kvg-settings-debug":"kvg-settings");if(t)try{const e=JSON.parse(t);this.inputMuted&&(this.inputMuted.checked=e.muted),this.inputLockAspect&&(this.inputLockAspect.checked=e.lockAspect),this.inputDebug&&(this.inputDebug.checked=e.debug),.25===e.dpr?this.inputDPRQ.checked=1:.5===e.dpr?this.inputDPR0.checked=1:[this.inputDPR1,this.inputDPR2,this.inputDPR3][e.dpr-1].checked=1,this.inputResolutions[e.resolution].checked=1,"0.0"===e.aa?this.inputAAOff.checked=1:"2.0"===e.aa?this.inputAA2x.checked=1:"4.0"===e.aa?this.inputAA4x.checked=1:"8.0"===e.aa&&(this.inputAA8x.checked=1),e.dpr<1?this.showLowDprWarning():e.dpr>1&&this.showHighDprWarning()}catch(t){}}saveSettings(){const t=this.inputResolutions.find(t=>t.checked),e=this.config.resolutions.findIndex(e=>e.label===t?.value);localStorage.setItem(l().debug?"kvg-settings-debug":"kvg-settings",JSON.stringify({muted:this.inputMuted?.checked,lockAspect:this.inputLockAspect?.checked,debug:this.inputDebug?.checked,dpr:this.determineDPR(),resolution:e,aa:"0.0"}))}onFullScreenClick=async()=>{this.setupContainer.style.display="none",await this.demoContainer.requestFullscreen({}),await ot(5e3),this.buildDemo()};onWindowedClick=async()=>{this.setupContainer.style.display="none",await ot(10),this.buildDemo()};determineDPR=()=>{let t=window.devicePixelRatio;return isNaN(t)&&(t=1),this.inputDPRQ?.checked?t=.25:this.inputDPR0?.checked?t=.5:this.inputDPR1?.checked?t=1:this.inputDPR2?.checked?t=2:this.inputDPR3?.checked&&(t=3),t};determineAA=()=>"0.0";determineResolution=()=>{const t=new M(1920,1080);let e=W(this.config.aspectRatio)?this.config.aspectRatio.range:this.config.aspectRatio;G(e)&&(e=e[0]);const n=this.inputResolutions.find(t=>t.checked),r=this.config.resolutions.find(t=>t.label===n?.value).resolution;if(G(r)?(t.x=r[0],t.y=r[1]):-1!==r&&(t.x=e*r,t.y=r),-1===r||t.x>window.innerWidth||t.y>window.innerHeight){let n=window.innerHeight,r=window.innerWidth;this.inputLockAspect.checked&&(r/e<n&&(n=Math.round(r/e)),n*e<r&&(r=Math.round(n*e))),t.y=n,t.x=r}return t};buildDemo=async()=>{this.config.debug=this.inputDebug?.checked&&this.config.debug,this.config.looping=this.looping&&this.looping.checked,this.config.debugUniformSliders=this.config.debugUniformSliders&&-1===location.hash.indexOf("disableUniformDebug");const t=document.getElementsByClassName("debug");for(let e=0;e<t.length;e++)t[e].style.display=this.config.debug?"":"none";const e=this.determineDPR(),n=this.determineResolution(),r=this.determineAA();this.config.shaderConstants["AA-LEVEL"]=r,this.config.muted=this.inputMuted?.checked??1,this.saveSettings(),this.renderer=new S({width:n.x,height:n.y,dpr:e,alpha:1});const i=this.demoContainer.firstElementChild;i.appendChild(this.renderer.options.canvas),this.demoContainer.style.display="";const a=this.renderer.options.height/1080;this.demoContainer.getElementsByTagName("img")[0].style.transform=`scale(${a},${a})`,this.demoLauncherBar.style.transform=`scale(${a},${a})`,this.demoLauncherBar.style.marginTop=this.renderer.options.height/2-45+"px",this.demoLauncherBarText.style.marginTop=this.renderer.options.height/2-70+"px",this.overlay.resize(n.x,n.y),i.appendChild(this.overlay.container),this.creationEvents&&this.creationEvents.onSetup&&this.creationEvents.onSetup(this),await ot(100),setTimeout(this.buildDelay,100)};delayMessages={5:"WebGL is now linking shaders. This may take a moment.",20:"Modern browsers have an excellent shader cache - the demo should load up quickly on second run.",30:"Linking progress might have hung up due to browser timeout. Reload to launch with cached shaders.",60:"Compilation time has taken over one minute. The demo should load up very soon! If not, reload",120:"Something's wrong. Should not take this long."};buildDelay=async()=>{const t=Date.now(),e=await new lt(this.renderer,this.overlay,this.config,this.parts).build(e=>{this.demoLauncherBar.children[0].style.width=50*e+50+"%";const n=(Date.now()-t)/1e3;let r="WebGL is now compiling shaders. This may take a moment.";n>5&&(r=this.delayMessages[5]),n>20&&(r=this.delayMessages[20]),n>30&&(r=this.delayMessages[30]),n>60&&(r=this.delayMessages[60]),n>120&&(r=this.delayMessages[120]),this.demoLauncherBarText.innerHTML=r},this.defaultPartCallbacks);this.demo=e,this.creationEvents&&this.creationEvents.onBuilt&&this.creationEvents.onBuilt(e),this.config.generateFFT&&(f.FFTex=new ht(e.renderer.context,e.renderer),e.beforeRender.connect(t=>f.FFTex.update())),window.demo=e,setTimeout(this.startDelay,100)};startDelay=()=>{this.demoLauncherBar.remove(),this.demoLauncherBarText.remove();const t=this.demoContainer.getElementsByTagName("img")[0];this.creationEvents&&this.creationEvents.onStart&&this.creationEvents.onStart(this.demo),this.demo.runner.start(),window.setTimeout(()=>t.remove(),50)};showZoomWarning=()=>{const t=window.outerWidth>window.screen.availWidth||window.outerHeight>window.screen.availHeight,e=Math.abs(window.innerWidth-window.outerWidth)<20||window.innerHeight<window.outerHeight&&Math.abs(window.innerHeight-window.outerHeight)<120;(t?window.screen.availWidth===window.innerWidth&&window.screen.availHeight===window.innerHeight:e)?document.getElementById("zoomWarning")?.setAttribute("style","display:none"):document.getElementById("zoomWarning")?.setAttribute("style","display:block")};showLowDprWarning=()=>document.getElementById("dpLowWarning")?.setAttribute("style","display:block");showHighDprWarning=()=>document.getElementById("dpHighWarning")?.setAttribute("style","display:block");hideDprWarning=()=>{document.getElementById("dpLowWarning")?.setAttribute("style","display:none"),document.getElementById("dpHighWarning")?.setAttribute("style","display:none")};showLocalFileWarning=()=>document.getElementById("localFileWarning")?.setAttribute("style","display:block")}class dt{name="pp-base-class";programs;program;uniforms;enabled=1;renderer;compiled=0;constructor(t,e,n){this.renderer=t,this.programs=[{vertexShader:e,fragmentShader:n,program:t.context.createProgram()}],this.program=this.programs[0].program,this.uniforms=new Map}programReady(){this.compiled=1}buildUniforms(t,e){if(e||(e=this.program),!this.compiled)throw new Error("Accessing uniforms before compilation.");t&&(this.uniforms.has(e)||this.uniforms.set(e,new Map),t.forEach(t=>{const n=new z(e,this.renderer.context,t);this.uniforms.get(e).set(t.name,n)}))}render(t,e,n,r){t.bindFramebuffer(t.FRAMEBUFFER,e),t.useProgram(this.program),this.syncShader(this.uniforms.get(this.program)),t.drawArrays(t.TRIANGLES,0,3)}postRender(t,e,n,r){}syncShader(t){t.forEach(t=>t.sync())}}const pt={amount:50,radius:1,direction:[0,1],focus:.04,aperture:5,range:0};let ft,mt,gt,vt;const xt={grain:0,noise:0,blueNoise:0};const _t={intensity:0,lensing:0};let yt,bt,Et,Tt;const St={thresholdLow:0,thresholdHigh:1,amount:0,radius:50,distance:1,distanceY:1,radiusY:50};const Mt={vignetting:1};const wt={exposure:1,contrast:1,brightness:0,saturation:1};const Rt={offset:[0,0],rotation:0,scale:[1.02,1.02],pivot:[0,0],addAmount:.1,enabled:1};const At={intensity:1,limit:.25,splits:[25,5],seed:123,rotation:0,enabled:0};const Ct={center:[.5,.5],amount:1,color:[1,1,1]};const Pt=JSON.parse('{"title":"Mökkielämää - Hütteleben","images":["perlin-512.png","greets.png","logo.png","outro.png","polyhaven/planks_brown_10_rough_1k.jpg","polyhaven/planks_brown_10_diff_1k.jpg","polyhaven/planks_brown_10_disp_1k.png","textures/tech1_height.jpg","textures/sky1.jpg","textures/sky2.jpg","textures/sky3.jpg","textures/sky4.jpg","textures/grass-heightmap.png"],"shaderConstants":{"color1":"#f2e205","color2":"#f29f05","color3":"#f27405","color4":"#d93d04","color5":"#591e08"},"beatsPerBar":4,"ticksPerBeat":16,"beatsPerMinute":128,"aspectRatio":{"label":"16:9","range":1.77777},"music":"Makkarahumppa.mp3","generateFFT":true,"debug":false,"muted":false,"looping":false,"enableKHRParallelCompilation":true,"analyserVersion":"modern","precision":1024,"parts":[{"note":"Esimerkkikuutios","instanceId":"tikkataulu","start":[0,0,0],"end":[4,1,0]},{"note":"Esimerkkikuutios","instanceId":"threejsisland","start":[3,2,0],"end":[16,1,0]},{"note":"tikkataulu->thjreesisland","instanceId":"beeroverlay","start":[2,2,0],"end":[6,2,0]},{"note":"grill","instanceId":"grill","start":[15,2,0],"end":[30,1,0]},{"note":">thjreesisland->grill","instanceId":"beeroverlay2","start":[15,2,0],"end":[16,1,0]},{"note":"tikka","instanceId":"tikkataulu","start":[29,2,0],"end":[43,2,0]},{"note":">thjreesisland->grill","instanceId":"beeroverlay4","start":[29,2,0],"end":[30,1,0]},{"note":"murkut","instanceId":"ants","start":[43,2,0],"end":[49,0,0]},{"note":">thjreesisland->grill","instanceId":"beeroverlay5","start":[47,2,0],"end":[49,3,0]}]}');const Dt={sampleFrames:3,amountBase:.5,amountDelta:1,enabled:0};const Ut={intensity:.95,color:[1,1,1]};class Lt extends D{program;vertexShader;fragmentShader;uniforms=[];constructor(t,e,n){super(t),this.vertexShader=n,this.fragmentShader=e}init(){super.init()}getPrograms(){return[{vertexShader:this.vertexShader,fragmentShader:this.fragmentShader}].concat(super.getPrograms())}updateProgram(t){this.vertexShader=t[0].vertexShader,this.fragmentShader=t[0].fragmentShader,this.program=t[0].program}preRender(t,e){super.preRender(t,e),e.useProgram(this.program),this.uniforms.forEach(t=>t.sync())}render(t,e,n){super.render(t,e,n),n.useProgram(this.program);const r=n.FLOAT;n.vertexAttribPointer(0,2,r,0,0,0);const i=n.TRIANGLES;n.drawArrays(i,0,3)}CreateUniform(t){const e=new z(this.program,this.context,t);return this.uniforms.push(e),e}}class It extends Lt{features=new Set([C.DefaultAudioFilters,C.DefaultPostProcess,C.EnableAudioAnalyzer,C.EnablePostProcess,C.DefaultOnRender]);timeU;cameraU;targetU;fovU;ambienceU;light1U;light2U;light3U;constructor(t){super(t,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nlayout(location = 0) out vec4 outColor;\r\n\r\nuniform vec2 resolution;\r\nuniform float time;\r\nuniform float fov;\r\nuniform vec3 camera;\r\nuniform vec3 target;\r\nuniform vec3 light1;\r\nuniform vec3 light2;\r\nuniform vec3 light3;\r\nuniform vec3 cubepos;\r\nuniform vec3 cuberot;\r\nuniform float ambience;\r\n\r\nconst float PI2 = 6.28318530717;\r\nconst float PI = 3.14159265359;\r\nconst float PHI = 1.61803398874;\r\nconst vec3 V3Z = vec3(0.);\r\nstruct O\r\n{\r\n    // Distance the ray has travelled to the object\r\n    float dist;\r\n    // Material of the object\r\n    float mat;\r\n    // The position of the object in 3d space\r\n    vec3 pos;\r\n};\r\n\r\nstruct MarchResult{\r\n   // Object the marching hits.\r\n   O O;\r\n   // How many steps did the march take.\r\n   int steps;\r\n   // The position in world for march.\r\n   vec3 worldPosition;\r\n   // Normal for the object surface.\r\n   vec3 normal;\r\n   // How much did the ray travel.\r\n   float travel;\r\n};\r\n\r\n// Point rotations\r\nvec3 RotPointX(vec3 p, float d) {\r\n    mat4 rotM= mat4(1.0, 0.0, 0.0, 0.0, \r\n                    0.0, cos(d), -sin(d), 0.0, \r\n                    0.0, sin(d), cos(d), 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\nvec3 RotPointY(vec3 p, float d) {\r\n    mat4 rotM= mat4(cos(d), 0.0, sin(d), 0.0, \r\n                    0.0, 1.0, 0.0, 0.0,\r\n                    -sin(d), 0.0, cos(d), 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\nvec3 RotPointZ(vec3 p, float d) {\r\n    mat4 rotM= mat4(cos(d), -sin(d), 0.0, 0.0, \r\n                    sin(d), cos(d), 0.0, 0.0, \r\n                    0.0, 0.0, 1.0, 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\n\r\n// Matrix rotations.\r\nmat3 RotX(float a)\r\n{\r\n    return mat3(\r\n        1.0, 0.0, 0.0, \r\n        0.0, cos(a), -sin(a), \r\n        0.0, sin(a), cos(a)\r\n    );\r\n}\r\nmat3 RotY(float a)\r\n{\r\n    return mat3(\r\n        cos(a), 0.0, sin(a), \r\n        0.0, 1.0, 0.0, \r\n        -sin(a), 0.0, cos(a)\r\n    );\r\n}\r\nmat3 RotZ(float a)\r\n{\r\n    return mat3(\r\n        cos(a), -sin(a), 0.0, \r\n        sin(a), cos(a), 0.0, \r\n        0.0, 0.0, 1.0\r\n    );\r\n}\r\nmat3 Rot(float x,float y,float z)\r\n{\r\n    float xca = cos(x);\r\n    float xsa = sin(x);\r\n    float yca = cos(y);\r\n    float ysa = sin(y);\r\n    float zca = cos(z);\r\n    float zsa = sin(z);\r\n    \r\n    return mat3( \r\n        1.0, 0.0, 0.0,\r\n        0.0, xca, -xsa,\r\n        0.0, xsa, xca\r\n    ) * \r\n    mat3(\r\n        yca, 0.0, ysa,\r\n        0.0, 1.0, 0.0,\r\n        -ysa, 0.0, yca\r\n    ) * \r\n    mat3(\r\n        yca, -ysa, 0.0,\r\n        ysa, yca, 0.0,\r\n        0.0, 0.0, 1.0\r\n    );\r\n}\r\n\r\n// Rotation around fixed axis\r\nmat3 RotationMatrix(vec3 axis, float angle)\r\n{\r\n    axis = normalize(axis);\r\n    float s = sin(angle);\r\n    float c = cos(angle);\r\n    float oc = 1.0 - c;\r\n    \r\n    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,\r\n                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,\r\n                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);\r\n}\r\nfloat HexPrism( vec3 p, vec2 h )\r\n{\r\n  const vec3 k = vec3(-0.8660254, 0.5, 0.57735);\r\n  p = abs(p);\r\n  p.xy -= 2.0*min(dot(k.xy, p.xy), 0.0)*k.xy;\r\n  vec2 d = vec2(\r\n       length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x), h.x))*sign(p.y-h.x),\r\n       p.z-h.y );\r\n  return min(max(d.x,d.y),0.0) + length(max(d,0.0));\r\n}\r\nfloat Ground(vec3 position, float height)\r\n{\r\n    return position.y - height;\r\n}\r\nfloat Torus( vec3 pos, vec2 t )\r\n{\r\n  vec2 q = vec2(length(pos.xz)-t.x,pos.y);\r\n  return length(q)-t.y;\r\n}\r\nfloat RoundBox( vec3 p, vec3 b, float r )\r\n{\r\n  vec3 d = abs(p) - b;\r\n  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0)) - r;\r\n}\r\nfloat Sphere( vec3 pos, float radius )\r\n{\r\n    return length(pos) - radius;\r\n}\r\n// Union of two objects with support for material mixing\r\nO Union(O a, O b){\r\n    float s = step(b.dist, a.dist);\r\n    return O( mix(a.dist, b.dist, s),\r\n                       mix(a.mat, b.mat, s),\r\n                       mix(a.pos, b.pos, s));\r\n}\r\nvec3 Repeat( vec3 p, vec3 c)\r\n{\r\n    vec3 q = vec3(0.);\r\n    vec3 q2 = mod(p+0.5*c,c)-0.5*c;\r\n    q.x = c.x > 0. ? q2.x : p.x;\r\n    q.y = c.y > 0. ? q2.y : p.y;\r\n    q.z = c.z > 0. ? q2.z : p.z;\r\n    return q;\r\n}\r\n#define HASHSCALE1 .1031\r\nfloat Hash(float p)\r\n{\r\n\tvec3 p3  = fract(vec3(p) * HASHSCALE1);\r\n    p3 += dot(p3, p3.yzx + 19.19);\r\n    return fract((p3.x + p3.y) * p3.z);\r\n}\r\n\r\n\r\n/** CONSTANTS **/\r\nconst float STEP = 0.001;\r\nconst float VOLUMETRIC_STEP = 0.01;\r\nconst float MAXDIST = 30.;\r\n\r\nvec3 volumetric = vec3(0.0);\r\n\r\n/******************\r\n*** 2d textures ***\r\n******************/\r\nfloat arrow( vec2 uv, float tip, vec2 offset, vec2 scale )\r\n{\r\n    uv -= vec2(0.5, 0.0);\r\n    uv *= scale;\r\n    uv += offset;\r\n    uv.y += abs(uv.x)*tip;\r\n    return length(mod(uv.y+0.5, 1.0)-0.5);\r\n}\r\n\r\n\r\n/*************\r\n*** CAMERA ***\r\n*************/\r\nvec3 getCameraRayDir(vec2 uv, vec3 pos, vec3 target, float fov)\r\n{\r\n    vec3 forward = normalize( target - pos );\r\n    vec3 right = normalize(cross(vec3(0., 1.0, 0.), forward));\r\n    vec3 up = normalize(cross(forward,right));\r\n    return normalize( uv.x * right + uv.y * up + forward * fov);\r\n}\r\n\r\n// Scene mapping method \r\nO map( vec3 pos )\r\n{\r\n    vec3 cubePos = (pos + cubepos);\r\n    \r\n    O cube = O( Sphere( \r\n        cubePos * Rot(cuberot.x*1.5, cuberot.y*1.5, cuberot.z*1.5), \r\n        0.5\r\n        ), 1.0, vec3(0.,0.9,0.));\r\n    \r\n    O groundBottom = O( Ground( pos, -1.0 ), 0.0, pos);\r\n    \r\n    O result = Union( groundBottom, cube);\r\n    \r\n    return result;\r\n}\r\n\r\n// Requires hash.fs to be included\r\n\r\nvec3 RandomSphereDir(vec2 rnd)\r\n{\r\n\tfloat s = rnd.x*PI*2.;\r\n\tfloat t = rnd.y*2.-1.;\r\n\treturn vec3(sin(s), cos(s), t) / sqrt(1.0 + t * t);\r\n}\r\nvec3 RandomHemisphereDir(vec3 dir, float i)\r\n{\r\n\tvec3 v = RandomSphereDir( vec2(Hash(i+1.), Hash(i+2.)) );\r\n\treturn v * sign(dot(v, dir));\r\n}\r\n\r\nfloat AmbientOcclusion( in vec3 p, in vec3 n, in float maxDist, in float falloff )\r\n{\r\n\tconst int nbIte = 32;\r\n    const float nbIteInv = 1./float(nbIte);\r\n    const float rad = 1.-1.*nbIteInv; //Hemispherical factor (self occlusion correction)\r\n    \r\n\tfloat ao = 0.0;\r\n    \r\n    for( int i=0; i<nbIte; i++ )\r\n    {\r\n        float l = Hash(float(i))*maxDist;\r\n        vec3 rd = normalize(n+RandomHemisphereDir(n, l )*rad)*l; // mix direction with the normal\r\n        \t\t\t\t\t\t\t\t\t\t\t\t\t    // for self occlusion problems!\r\n        \r\n        ao += (l - max(map( p + rd ).dist,0.)) / maxDist * falloff;\r\n    }\r\n\t\r\n    return clamp( 1.-ao*nbIteInv, 0., 1.);\r\n}\r\n\r\n\r\n// Calculates the surface normal\r\nvec3 CalcNormal( vec3 pos)\r\n{\r\n    float c = map(pos).dist;\r\n    vec2 e = vec2(0.001, 0.0);\r\n    return normalize( vec3( map( pos + e.xyy).dist,\r\n                            map( pos + e.yxy).dist,\r\n                            map( pos + e.yyx).dist) -c);\r\n}\r\n\r\nvec3 Diffuse( vec3 pos, vec3 light, vec3 normal )\r\n{\r\n    float dotNL = max(dot( normal, normalize(light - pos)), 0.0);\r\n    return vec3(1.) * dotNL;\r\n}\r\n\r\n\r\n/**\r\n * Main raymarch function for main image & reflections. \r\n */\r\nMarchResult raymarch(vec3 cam, vec3 rd){\r\n    float t = 0.0;\r\n    vec3 col = vec3(0.);\r\n    O res;\r\n    int steps = 0;\r\n    vec3 p = vec3(0.);\r\n    for( int i = 0; i < 256; i++)\r\n    {\r\n        p = cam + rd*t;\r\n        res = map( p );\r\n        t+= res.mat < 10.0 ? res.dist : max(VOLUMETRIC_STEP, res.dist-VOLUMETRIC_STEP);\r\n        if(res.mat >= 10.0 && res.dist <VOLUMETRIC_STEP)// Materials over 10 are volumetric.\r\n        {\r\n            volumetric += vec3(10.9,10.6,10.55)*VOLUMETRIC_STEP;\r\n        }\r\n        else if(res.dist < STEP ) \r\n        {\r\n            // Ray trace hit an object\r\n            break;\r\n        }\r\n        if(t > MAXDIST) {\r\n            res.mat = -1.;\r\n            t = MAXDIST;\r\n            break;\r\n        }\r\n        \r\n        steps++;\r\n    }\r\n    MarchResult mr = MarchResult(res, steps, p, vec3(0), t);\r\n    // Only calculate normals if result material is [0,9]. Negative materials are skyhits, over 10 are volumetric\r\n    if(res.mat > -0.5 && res.mat < 9.5){\r\n        mr.normal = CalcNormal(mr.worldPosition);\r\n    }\r\n    return mr;\r\n}\r\n\r\nconst float STEP_LOW = 0.01;\r\n/**\r\n * Lower quality raymarch. Use for shadows etc. \r\n * Does not support volumetric materials.\r\n */\r\nMarchResult raymarchLow(vec3 cam, vec3 rd, float maxdist){\r\n    float t = 0.0;\r\n    vec3 col = vec3(0.);\r\n    O res;\r\n    int steps = 0;\r\n    vec3 p = vec3(0.);\r\n    float minval = 1.0;\r\n    for( int i = 0; i < 512; i++)\r\n    {\r\n        p = cam + rd*t;\r\n        res = map( p );\r\n        t+= max(STEP_LOW,res.dist);\r\n        // Only calculate how close the ray was to solid object.\r\n        if(res.mat < 9.5 && res.mat >0.5)\r\n        {\r\n            minval = min(minval, res.dist);\r\n        }\r\n        \r\n        if(res.dist < STEP_LOW && res.mat < 9.5 && res.mat >0.5 ) \r\n        {\r\n            // Ray trace hit an object\r\n            break;\r\n        }\r\n        if(t > maxdist) {\r\n            res.mat = -1.;\r\n            t = maxdist;\r\n            break;\r\n        }\r\n        \r\n        steps++;\r\n    }\r\n    if(steps >=512) res.mat = -1.0;\r\n    p.x = minval;\r\n    MarchResult mr = MarchResult(res, steps, p, vec3(0), t);\r\n    \r\n    return mr;\r\n}\r\n\r\nvoid colorize(MarchResult result, vec3 rayDir, out vec3 col){\r\n    // Black bg\r\n    col = vec3(0.);\r\n    if(result.O.mat < -0.5)\r\n    {\r\n        //Skydome\r\n    }\r\n    else if (result.O.mat < 0.5) \r\n    {\r\n        // Ground\r\n        vec3 p = result.worldPosition;\r\n        vec3 normal = result.normal;\r\n        vec3 fr = fract(result.worldPosition.xyz);\r\n        float id = result.O.mat < 0.1 ? length( fr.x -0.5 ) + length( fr.z - 0.5) :\r\n                   result.O.mat < 0.2 ? length( fr.z - 0.5) + length( fr.y - 0.5) :\r\n                                        length( fr.x - 0.5) + length( fr.y - 0.5);\r\n\r\n        vec3 color = mix( ${color2}, ${color3}, smoothstep( 0.49, 0.5, id) );\r\n        \r\n        col = color * ( ambience + \r\n                        ${color1} * Diffuse(p, light1, normal) +\r\n                        ${color2} * Diffuse(p, light2, normal) +\r\n                        ${color3} * Diffuse(p, light3, normal)\r\n                      );\r\n        float arr = arrow( result.worldPosition.xz*vec2(3.0,3.0), 0.15, vec2(0.0, -time), vec2(1.0) );\r\n        col = vec3(1.0) * smoothstep(0.4, 0.41, arr) + ${color3}*smoothstep(0.41,0.4,arr);\r\n        // Reflect\r\n        vec3 refCol = vec3(0.0);\r\n        vec3 refRd = reflect( rayDir, normal );\r\n        MarchResult reflectMarch = raymarch( p+normal*STEP_LOW, refRd );\r\n        if(reflectMarch.O.mat < -0.5)\r\n        { \r\n            //SKydome\r\n            \r\n        } \r\n        else if(reflectMarch.O.mat < 0.5)\r\n        {\r\n            // Ground\r\n            \r\n        }\r\n        else if(reflectMarch.O.mat < 1.5)\r\n        {\r\n            // Cube\r\n            vec3 rp = reflectMarch.worldPosition;\r\n            vec3 rnormal = reflectMarch.normal;\r\n            vec3 color = ${color1};\r\n            refCol = color*(ambience+0.5*Diffuse(rp, light1, rnormal));// * AmbientOcclusion(rp, normal, 4., 2.);\r\n            \r\n            // Shadow calculate\r\n           // MarchResult shadowMarch = raymarchLow( rp+normal*STEP_LOW, normalize( light-rp ), distance(light,rp)   );\r\n            //refCol*= 0.5 + 0.5*smoothstep(0.0,0.1,shadowMarch.worldPosition.x);\r\n        }\r\n        \r\n        // Shadow calculate\r\n        MarchResult shadowMarch = raymarchLow( p+normal*STEP_LOW, normalize( light1-p ), distance(light1,p) );\r\n        col = mix(refCol, col, 1.00);\r\n        col*= 0.75 + 0.25*smoothstep(0.0,0.1,shadowMarch.worldPosition.x);\r\n        \r\n    }\r\n    else if(result.O.mat < 1.5)\r\n    {\r\n        // Cube\r\n        vec3 p = result.worldPosition;\r\n        vec3 normal = result.normal;\r\n        \r\n        vec3 color = vec3(1.0,0.5,0.0);/// ${color1};\r\n        col = color * ( ambience + \r\n                        ${color1} * Diffuse(p, light1, normal) +\r\n                        ${color2} * Diffuse(p, light2, normal) +\r\n                        ${color3} * Diffuse(p, light3, normal)\r\n                      );\r\n        \r\n        // Shadow calculate\r\n        MarchResult shadowMarch = raymarchLow( p+normal*STEP_LOW, normalize( light1-p ), distance(light1,p)   );\r\n        \r\n        //col*= 0.5 + 0.5*smoothstep(0.0,0.1,shadowMarch.worldPosition.x);\r\n    }\r\n}\r\n\r\nvoid render( vec2 uv, out vec4 diffuse)\r\n{\r\n    vec3 rd = getCameraRayDir( uv, camera, target, fov);\r\n    MarchResult result= raymarch(camera, rd);\r\n    colorize(result, rd, diffuse.rgb);\r\n    diffuse.a = result.travel/MAXDIST;\r\n    \r\n    diffuse.rgb = mix(diffuse.rgb, vec3(0), smoothstep(MAXDIST*3.0/4.0, MAXDIST, result.travel));\r\n}\r\n\r\nvec4 Main(vec2 uv, float AA)\r\n{\r\n    // Output to screen\r\n    vec4 emissive = vec4(0.);\r\n    vec4 col = vec4(0.);\r\n    render(uv, col);\r\n    return col + vec4(volumetric/(1.0+AA),0.0);\r\n}\r\n\r\nfloat AA = ${AA-LEVEL};\r\n\r\nvoid main()\r\n{\r\n    vec2 uv = (gl_FragCoord.xy/resolution.xy-0.5)*2.0;\r\n    uv.y*=resolution.y/resolution.x;\r\n    \r\n\tvec4 col = Main( uv, AA );\r\n    float count = 1.0;\r\n    vec2 aaStep = vec2(1.0/AA) / resolution.xy;\r\n    for( float aaX = 0.0; aaX < AA; aaX++)\r\n    {\r\n        for( float aaY = 0.0; aaY < AA; aaY++)\r\n        {\r\n            col += Main( uv + vec2( aaX, aaY ) * aaStep, AA );\r\n            count++;\r\n        }\r\n    }\r\n    col /= count;\r\n    \r\n    // Output to screen\r\n    outColor = col;\r\n}\r\n")}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:k.f1,value:0}),this.cameraU=this.CreateUniform({name:"camera",type:k.f3v,value:[0,2,4]}),this.targetU=this.CreateUniform({name:"target",type:k.f3v,value:[0,0,0]}),this.light1U=this.CreateUniform({name:"light1",type:k.f3v,value:[0,1,0]}),this.light2U=this.CreateUniform({name:"light2",type:k.f3v,value:[0,.7,-1]}),this.light3U=this.CreateUniform({name:"light3",type:k.f3v,value:[0,.7,1]}),this.fovU=this.CreateUniform({name:"fov",type:k.f1,value:1.1,max:20}),this.ambienceU=this.CreateUniform({name:"ambience",type:k.f1,value:1,min:-2,max:2})}start(t,e){super.start(t,e),this.timeU.value=.001*t.toMilliseconds()}update(t){super.update(t),this.timeU.value=.001*t.toMilliseconds()}render(t,e,n){super.render(t,e,n)}}class Nt extends Lt{features=new Set([C.DefaultAudioFilters,C.DefaultPostProcess,C.EnableAudioAnalyzer,C.EnablePostProcess,C.DefaultOnRender]);timeU;cameraU;targetU;fovU;ambienceU;light1U;light2U;light3U;constructor(t){super(t,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nlayout(location = 0) out vec4 outColor;\r\n\r\nuniform vec2 resolution;\r\nuniform float time;\r\nuniform float fov;\r\nuniform vec3 camera;\r\nuniform vec3 target;\r\nuniform vec3 light1;\r\nuniform vec3 light2;\r\nuniform vec3 light3;\r\nuniform vec3 cubepos;\r\nuniform vec3 cuberot;\r\nuniform float ambience;\r\n\r\nconst float PI2 = 6.28318530717;\r\nconst float PI = 3.14159265359;\r\nconst float PHI = 1.61803398874;\r\nconst vec3 V3Z = vec3(0.);\r\nstruct O\r\n{\r\n    // Distance the ray has travelled to the object\r\n    float dist;\r\n    // Material of the object\r\n    float mat;\r\n    // The position of the object in 3d space\r\n    vec3 pos;\r\n};\r\n\r\nstruct MarchResult{\r\n   // Object the marching hits.\r\n   O O;\r\n   // How many steps did the march take.\r\n   int steps;\r\n   // The position in world for march.\r\n   vec3 worldPosition;\r\n   // Normal for the object surface.\r\n   vec3 normal;\r\n   // How much did the ray travel.\r\n   float travel;\r\n};\r\n\r\n// Point rotations\r\nvec3 RotPointX(vec3 p, float d) {\r\n    mat4 rotM= mat4(1.0, 0.0, 0.0, 0.0, \r\n                    0.0, cos(d), -sin(d), 0.0, \r\n                    0.0, sin(d), cos(d), 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\nvec3 RotPointY(vec3 p, float d) {\r\n    mat4 rotM= mat4(cos(d), 0.0, sin(d), 0.0, \r\n                    0.0, 1.0, 0.0, 0.0,\r\n                    -sin(d), 0.0, cos(d), 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\nvec3 RotPointZ(vec3 p, float d) {\r\n    mat4 rotM= mat4(cos(d), -sin(d), 0.0, 0.0, \r\n                    sin(d), cos(d), 0.0, 0.0, \r\n                    0.0, 0.0, 1.0, 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\n\r\n// Matrix rotations.\r\nmat3 RotX(float a)\r\n{\r\n    return mat3(\r\n        1.0, 0.0, 0.0, \r\n        0.0, cos(a), -sin(a), \r\n        0.0, sin(a), cos(a)\r\n    );\r\n}\r\nmat3 RotY(float a)\r\n{\r\n    return mat3(\r\n        cos(a), 0.0, sin(a), \r\n        0.0, 1.0, 0.0, \r\n        -sin(a), 0.0, cos(a)\r\n    );\r\n}\r\nmat3 RotZ(float a)\r\n{\r\n    return mat3(\r\n        cos(a), -sin(a), 0.0, \r\n        sin(a), cos(a), 0.0, \r\n        0.0, 0.0, 1.0\r\n    );\r\n}\r\nmat3 Rot(float x,float y,float z)\r\n{\r\n    float xca = cos(x);\r\n    float xsa = sin(x);\r\n    float yca = cos(y);\r\n    float ysa = sin(y);\r\n    float zca = cos(z);\r\n    float zsa = sin(z);\r\n    \r\n    return mat3( \r\n        1.0, 0.0, 0.0,\r\n        0.0, xca, -xsa,\r\n        0.0, xsa, xca\r\n    ) * \r\n    mat3(\r\n        yca, 0.0, ysa,\r\n        0.0, 1.0, 0.0,\r\n        -ysa, 0.0, yca\r\n    ) * \r\n    mat3(\r\n        yca, -ysa, 0.0,\r\n        ysa, yca, 0.0,\r\n        0.0, 0.0, 1.0\r\n    );\r\n}\r\n\r\n// Rotation around fixed axis\r\nmat3 RotationMatrix(vec3 axis, float angle)\r\n{\r\n    axis = normalize(axis);\r\n    float s = sin(angle);\r\n    float c = cos(angle);\r\n    float oc = 1.0 - c;\r\n    \r\n    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,\r\n                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,\r\n                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);\r\n}\r\nfloat HexPrism( vec3 p, vec2 h )\r\n{\r\n  const vec3 k = vec3(-0.8660254, 0.5, 0.57735);\r\n  p = abs(p);\r\n  p.xy -= 2.0*min(dot(k.xy, p.xy), 0.0)*k.xy;\r\n  vec2 d = vec2(\r\n       length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x), h.x))*sign(p.y-h.x),\r\n       p.z-h.y );\r\n  return min(max(d.x,d.y),0.0) + length(max(d,0.0));\r\n}\r\nfloat Ground(vec3 position, float height)\r\n{\r\n    return position.y - height;\r\n}\r\nfloat Torus( vec3 pos, vec2 t )\r\n{\r\n  vec2 q = vec2(length(pos.xz)-t.x,pos.y);\r\n  return length(q)-t.y;\r\n}\r\nfloat RoundBox( vec3 p, vec3 b, float r )\r\n{\r\n  vec3 d = abs(p) - b;\r\n  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0)) - r;\r\n}\r\nfloat Sphere( vec3 pos, float radius )\r\n{\r\n    return length(pos) - radius;\r\n}\r\n// Union of two objects with support for material mixing\r\nO Union(O a, O b){\r\n    float s = step(b.dist, a.dist);\r\n    return O( mix(a.dist, b.dist, s),\r\n                       mix(a.mat, b.mat, s),\r\n                       mix(a.pos, b.pos, s));\r\n}\r\nvec3 Repeat( vec3 p, vec3 c)\r\n{\r\n    vec3 q = vec3(0.);\r\n    vec3 q2 = mod(p+0.5*c,c)-0.5*c;\r\n    q.x = c.x > 0. ? q2.x : p.x;\r\n    q.y = c.y > 0. ? q2.y : p.y;\r\n    q.z = c.z > 0. ? q2.z : p.z;\r\n    return q;\r\n}\r\n#define HASHSCALE1 .1031\r\nfloat Hash(float p)\r\n{\r\n\tvec3 p3  = fract(vec3(p) * HASHSCALE1);\r\n    p3 += dot(p3, p3.yzx + 19.19);\r\n    return fract((p3.x + p3.y) * p3.z);\r\n}\r\n\r\n\r\n/** CONSTANTS **/\r\nconst float STEP = 0.001;\r\nconst float VOLUMETRIC_STEP = 0.01;\r\nconst float MAXDIST = 30.;\r\n\r\nvec3 volumetric = vec3(0.0);\r\n\r\n/******************\r\n*** 2d textures ***\r\n******************/\r\nfloat arrow( vec2 uv, float tip, vec2 offset, vec2 scale )\r\n{\r\n    uv -= vec2(0.5, 0.0);\r\n    uv *= scale;\r\n    uv += offset;\r\n    uv.y += abs(uv.x)*tip;\r\n    return length(mod(uv.y+0.5, 1.0)-0.5);\r\n}\r\n\r\n\r\n/*************\r\n*** CAMERA ***\r\n*************/\r\nvec3 getCameraRayDir(vec2 uv, vec3 pos, vec3 target, float fov)\r\n{\r\n    vec3 forward = normalize( target - pos );\r\n    vec3 right = normalize(cross(vec3(0., 1.0, 0.), forward));\r\n    vec3 up = normalize(cross(forward,right));\r\n    return normalize( uv.x * right + uv.y * up + forward * fov);\r\n}\r\n\r\n// Scene mapping method \r\nO map( vec3 pos )\r\n{\r\n    vec3 cubePos = (pos + cubepos);\r\n    \r\n    O cube = O( Sphere( \r\n        cubePos *vec3(0.04,4.0,0.2), \r\n        0.5\r\n        ), 1.0, vec3(0.,0.9,0.));\r\n    \r\n    vec3 waterPos =pos* 2.0;\r\n    float l1 = length(waterPos.xz);\r\n    float l2 = length(waterPos.xz+vec2(3.0,-33.0));\r\n    float l3 = length(waterPos.xz+vec2(7.11,21.1));\r\n    float l4 = length(waterPos.xz+vec2(2.98,1.1));\r\n    \r\n    \r\n    waterPos*=14.0;\r\n    float l5 = length(waterPos.xz);\r\n    float l6 = length(waterPos.xz+vec2(2.0,-1.0));\r\n    float l7 = length(waterPos.xz+vec2(5.11,1.1));\r\n    float l8 = length(waterPos.xz+vec2(4.98,3.1));\r\n    \r\n    \r\n    float groundH = (sin(waterPos.x-waterPos.z*0.3)*0.01+0.12*cos(waterPos.x*-0.242+waterPos.z*0.054)+\r\n                    sin(l1+time*0.24) + \r\n                    sin(l2+time*0.873) +\r\n                    sin(l3-time*0.54) +\r\n                    sin(l4-time*0.21)) * 0.01 + \r\n                    // Extra detail\r\n                    (0.2*sin(waterPos.x-waterPos.z*0.43)+0.13*cos(waterPos.x*-0.3242+waterPos.z*0.654)+\r\n                    sin(l1+time*0.524) + \r\n                    sin(l2+time*0.9873) +\r\n                    sin(l3-time*0.854) +\r\n                    sin(l4-time*0.421))*0.004 +\r\n                    // Extra detail\r\n                    (0.02*sin(waterPos.x*1.98-waterPos.z*2.93)+0.013*cos(waterPos.x*-2.1242+waterPos.z*2.454)+\r\n                    sin(l1*3.0+time*2.524) + \r\n                    sin(l2*3.0+time*3.9873) +\r\n                    sin(l3*4.0-time*1.854) +\r\n                    sin(l4*5.0-time*2.421))*0.001;\r\n    \r\n    O groundBottom = O( Ground( pos, groundH )*0.75, 0.0, pos);\r\n    \r\n    O result = Union( groundBottom, cube);\r\n    \r\n    return result;\r\n}\r\n\r\n// Requires hash.fs to be included\r\n\r\nvec3 RandomSphereDir(vec2 rnd)\r\n{\r\n\tfloat s = rnd.x*PI*2.;\r\n\tfloat t = rnd.y*2.-1.;\r\n\treturn vec3(sin(s), cos(s), t) / sqrt(1.0 + t * t);\r\n}\r\nvec3 RandomHemisphereDir(vec3 dir, float i)\r\n{\r\n\tvec3 v = RandomSphereDir( vec2(Hash(i+1.), Hash(i+2.)) );\r\n\treturn v * sign(dot(v, dir));\r\n}\r\n\r\nfloat AmbientOcclusion( in vec3 p, in vec3 n, in float maxDist, in float falloff )\r\n{\r\n\tconst int nbIte = 32;\r\n    const float nbIteInv = 1./float(nbIte);\r\n    const float rad = 1.-1.*nbIteInv; //Hemispherical factor (self occlusion correction)\r\n    \r\n\tfloat ao = 0.0;\r\n    \r\n    for( int i=0; i<nbIte; i++ )\r\n    {\r\n        float l = Hash(float(i))*maxDist;\r\n        vec3 rd = normalize(n+RandomHemisphereDir(n, l )*rad)*l; // mix direction with the normal\r\n        \t\t\t\t\t\t\t\t\t\t\t\t\t    // for self occlusion problems!\r\n        \r\n        ao += (l - max(map( p + rd ).dist,0.)) / maxDist * falloff;\r\n    }\r\n\t\r\n    return clamp( 1.-ao*nbIteInv, 0., 1.);\r\n}\r\n\r\n\r\n// Calculates the surface normal\r\nvec3 CalcNormal( vec3 pos)\r\n{\r\n    float c = map(pos).dist;\r\n    vec2 e = vec2(0.001, 0.0);\r\n    return normalize( vec3( map( pos + e.xyy).dist,\r\n                            map( pos + e.yxy).dist,\r\n                            map( pos + e.yyx).dist) -c);\r\n}\r\n\r\nvec3 Diffuse( vec3 pos, vec3 light, vec3 normal )\r\n{\r\n    float dotNL = max(dot( normal, normalize(light - pos)), 0.0);\r\n    return vec3(1.) * dotNL;\r\n}\r\n\r\n\r\n/**\r\n * Main raymarch function for main image & reflections. \r\n */\r\nMarchResult raymarch(vec3 cam, vec3 rd){\r\n    float t = 0.0;\r\n    vec3 col = vec3(0.);\r\n    O res;\r\n    int steps = 0;\r\n    vec3 p = vec3(0.);\r\n    for( int i = 0; i < 1024; i++)\r\n    {\r\n        p = cam + rd*t;\r\n        res = map( p );\r\n        t+= res.mat < 10.0 ? res.dist : max(VOLUMETRIC_STEP, res.dist-VOLUMETRIC_STEP);\r\n        if(res.mat >= 10.0 && res.dist <VOLUMETRIC_STEP)// Materials over 10 are volumetric.\r\n        {\r\n            volumetric += vec3(10.9,10.6,10.55)*VOLUMETRIC_STEP;\r\n        }\r\n        else if(res.dist < STEP ) \r\n        {\r\n            // Ray trace hit an object\r\n            break;\r\n        }\r\n        if(t > MAXDIST) {\r\n            res.mat = -1.;\r\n            t = MAXDIST;\r\n            break;\r\n        }\r\n        \r\n        steps++;\r\n    }\r\n    MarchResult mr = MarchResult(res, steps, p, vec3(0), t);\r\n    // Only calculate normals if result material is [0,9]. Negative materials are skyhits, over 10 are volumetric\r\n    if(res.mat > -0.5 && res.mat < 9.5){\r\n        mr.normal = CalcNormal(mr.worldPosition);\r\n    }\r\n    return mr;\r\n}\r\n\r\nconst float STEP_LOW = 0.01;\r\n/**\r\n * Lower quality raymarch. Use for shadows etc. \r\n * Does not support volumetric materials.\r\n */\r\nMarchResult raymarchLow(vec3 cam, vec3 rd, float maxdist){\r\n    float t = 0.0;\r\n    vec3 col = vec3(0.);\r\n    O res;\r\n    int steps = 0;\r\n    vec3 p = vec3(0.);\r\n    float minval = 1.0;\r\n    for( int i = 0; i < 512; i++)\r\n    {\r\n        p = cam + rd*t;\r\n        res = map( p );\r\n        t+= max(STEP_LOW,res.dist);\r\n        // Only calculate how close the ray was to solid object.\r\n        if(res.mat < 9.5 && res.mat >0.5)\r\n        {\r\n            minval = min(minval, res.dist);\r\n        }\r\n        \r\n        if(res.dist < STEP_LOW && res.mat < 9.5 && res.mat >0.5 ) \r\n        {\r\n            // Ray trace hit an object\r\n            break;\r\n        }\r\n        if(t > maxdist) {\r\n            res.mat = -1.;\r\n            t = maxdist;\r\n            break;\r\n        }\r\n        \r\n        steps++;\r\n    }\r\n    if(steps >=512) res.mat = -1.0;\r\n    p.x = minval;\r\n    MarchResult mr = MarchResult(res, steps, p, vec3(0), t);\r\n    \r\n    return mr;\r\n}\r\n\r\nvoid colorize(MarchResult result, vec3 rayDir, out vec3 col){\r\n    // Black bg\r\n    col = vec3(0.);\r\n    if(result.O.mat < -0.5)\r\n    {\r\n        //Skydome\r\n        col=vec3(0.3,0.4,1.0);\r\n    }\r\n    else if (result.O.mat < 0.5) \r\n    {\r\n        // Ground\r\n        vec3 p = result.worldPosition;\r\n        vec3 normal = result.normal;\r\n        vec3 fr = fract(result.worldPosition.xyz);\r\n        float id = result.O.mat < 0.1 ? length( fr.x -0.5 ) + length( fr.z - 0.5) :\r\n                   result.O.mat < 0.2 ? length( fr.z - 0.5) + length( fr.y - 0.5) :\r\n                                        length( fr.x - 0.5) + length( fr.y - 0.5);\r\n\r\n        vec3 color = mix( vec3(0.0,0.2,0.5), vec3(0.1,0.4,1.5), p.y )*3.0;\r\n        \r\n        col = color * ( ambience + \r\n                        ${color1} * Diffuse(p, light1, normal) +\r\n                        ${color2} * Diffuse(p, light2, normal) +\r\n                        ${color3} * Diffuse(p, light3, normal)\r\n                      );\r\n                      col=normal;\r\n        // Reflect\r\n        vec3 refCol = vec3(0.0);\r\n        vec3 refRd = reflect( rayDir, normal );\r\n        MarchResult reflectMarch = raymarch( p+normal*STEP_LOW, refRd );\r\n        if(reflectMarch.O.mat < -0.5)\r\n        { \r\n            //SKydome\r\n            refCol=vec3(0.3,0.4,1.0);\r\n        } \r\n        else if(reflectMarch.O.mat < 0.5)\r\n        {\r\n            // Ground\r\n            \r\n        }\r\n        else if(reflectMarch.O.mat < 1.5)\r\n        {\r\n            // Cube\r\n            vec3 rp = reflectMarch.worldPosition;\r\n            vec3 rnormal = reflectMarch.normal;\r\n            vec3 color = ${color1};\r\n            refCol = color*(ambience+0.5*Diffuse(rp, light1, rnormal));// * AmbientOcclusion(rp, normal, 4., 2.);\r\n            \r\n            // Shadow calculate\r\n           // MarchResult shadowMarch = raymarchLow( rp+normal*STEP_LOW, normalize( light-rp ), distance(light,rp)   );\r\n            //refCol*= 0.5 + 0.5*smoothstep(0.0,0.1,shadowMarch.worldPosition.x);\r\n        }\r\n        \r\n        // Shadow calculate\r\n        MarchResult shadowMarch = raymarchLow( p+normal*STEP_LOW, normalize( light1-p ), distance(light1,p) );\r\n        col = mix(refCol, col, 1.00);\r\n        col*= 0.75 + 0.25*smoothstep(0.0,0.1,shadowMarch.worldPosition.x);\r\n        \r\n    }\r\n    else if(result.O.mat < 1.5)\r\n    {\r\n        // Cube\r\n        vec3 p = result.worldPosition;\r\n        vec3 normal = result.normal;\r\n        \r\n        vec3 color = vec3(1.0,0.5,0.0);/// ${color1};\r\n        col = color * ( ambience + \r\n                        ${color1} * Diffuse(p, light1, normal) +\r\n                        ${color2} * Diffuse(p, light2, normal) +\r\n                        ${color3} * Diffuse(p, light3, normal)\r\n                      );\r\n        \r\n        // Shadow calculate\r\n        MarchResult shadowMarch = raymarchLow( p+normal*STEP_LOW, normalize( light1-p ), distance(light1,p)   );\r\n        \r\n        //col*= 0.5 + 0.5*smoothstep(0.0,0.1,shadowMarch.worldPosition.x);\r\n    }\r\n}\r\n\r\nvoid render( vec2 uv, out vec4 diffuse)\r\n{\r\n    vec3 rd = getCameraRayDir( uv, camera, target, fov);\r\n    MarchResult result= raymarch(camera, rd);\r\n    colorize(result, rd, diffuse.rgb);\r\n    diffuse.a = result.travel/MAXDIST;\r\n    \r\n    //diffuse.rgb = mix(diffuse.rgb, vec3(0), smoothstep(MAXDIST*3.0/4.0, MAXDIST, result.travel));\r\n}\r\n\r\nvec4 Main(vec2 uv, float AA)\r\n{\r\n    // Output to screen\r\n    vec4 emissive = vec4(0.);\r\n    vec4 col = vec4(0.);\r\n    render(uv, col);\r\n    return col + vec4(volumetric/(1.0+AA),0.0);\r\n}\r\n\r\nfloat AA = ${AA-LEVEL};\r\n\r\nvoid main()\r\n{\r\n    vec2 uv = (gl_FragCoord.xy/resolution.xy-0.5)*2.0;\r\n    uv.y*=resolution.y/resolution.x;\r\n    \r\n\tvec4 col = Main( uv, AA );\r\n    float count = 1.0;\r\n    vec2 aaStep = vec2(1.0/AA) / resolution.xy;\r\n    for( float aaX = 0.0; aaX < AA; aaX++)\r\n    {\r\n        for( float aaY = 0.0; aaY < AA; aaY++)\r\n        {\r\n            col += Main( uv + vec2( aaX, aaY ) * aaStep, AA );\r\n            count++;\r\n        }\r\n    }\r\n    col /= count;\r\n    \r\n    // Output to screen\r\n    outColor = col;\r\n}\r\n")}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:k.f1,value:0}),this.cameraU=this.CreateUniform({name:"camera",type:k.f3v,value:[0,2,4]}),this.targetU=this.CreateUniform({name:"target",type:k.f3v,value:[0,0,0]}),this.light1U=this.CreateUniform({name:"light1",type:k.f3v,value:[0,1,0]}),this.light2U=this.CreateUniform({name:"light2",type:k.f3v,value:[0,.7,-1]}),this.light3U=this.CreateUniform({name:"light3",type:k.f3v,value:[0,.7,1]}),this.fovU=this.CreateUniform({name:"fov",type:k.f1,value:1.1,max:20}),this.ambienceU=this.CreateUniform({name:"ambience",type:k.f1,value:1,min:-2,max:2})}start(t,e){super.start(t,e),this.timeU.value=.001*t.toMilliseconds()}update(t){super.update(t),this.timeU.value=.001*t.toMilliseconds()}render(t,e,n){super.render(t,e,n)}}class Ot{seed;constructor(t=Math.random()*Number.MAX_SAFE_INTEGER|0){this.seed=t}next(){return this.seed=16807*this.seed%2147483647}nextFloat(){return this.next()/2147483647}static next(){return Ft.next()}static nextFloat(){return Ft.nextFloat()}static seed(){return Ft.seed}range(t,e){return(e-t)*this.nextFloat()+t}}const Ft=new Ot(123);c("kvg.Random",Ot);const Bt=t=>e=>Math.pow(e,t),kt=t=>e=>1-Math.pow(1-e,t),zt=t=>e=>(e*=2)<1?.5*Math.pow(e,t):1-.5*Math.abs(Math.pow(2-e,t)),Vt=Bt(2),Ht=kt(2),Gt=zt(2),Wt=(Bt(3),kt(3),zt(3),Bt(4),kt(4),zt(4),Bt(5),kt(5),zt(5),Xt=1.7,t=>t*t*((Xt+1)*t-Xt));var Xt;const jt=(t=>e=>--e*e*((t+1)*e+t)+1)(1.7),qt=((t=>{t*=1.525})(1.7),t=>t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375);((t,e)=>{const n=2*Math.PI})(1,.3),((t,e)=>{const n=2*Math.PI})(1,.3),((t,e)=>{const n=2*Math.PI})(1,.3*1.5);class Yt extends Lt{features=new Set([C.DefaultAudioFilters,C.DefaultPostProcess,C.EnableAudioAnalyzer,C.EnablePostProcess,C.DefaultOnRender]);timeU;cameraU;targetU;fovU;skyColorU;lightPosU;lightColU;sausagePositionU;sausageRotU;coalBurnU;cheapGlowU;dof;bloom;ca;blur;grain;phaseU;sausageSizeU;texLocation;groundLocation;imgindex=1;constructor(t){super(t,"#version 300 es\r\n\r\nprecision highp float;\r\nfloat shadows = 0.0;\r\n\r\nlayout(location = 0) out vec4 outColor;\r\n\r\nuniform vec3 skyCol;\r\nuniform vec2 resolution;\r\nuniform float time;\r\nuniform vec3 camera;\r\nuniform vec3 target;\r\nuniform vec3 lightPos;\r\nuniform vec3 lightCol;\r\nuniform vec3 sausagePos;\r\nuniform vec2 sausageRot;\r\nuniform float fov;\r\nuniform float coalburn;\r\nuniform float cheapGlow;\r\nuniform float sausageSize;\r\nuniform float phase;\r\nuniform sampler2D skyTex;\r\nuniform sampler2D groundTex;\r\n\r\nconst float PI2 = 6.28318530717;\r\nconst float PI = 3.14159265359;\r\nconst float PHI = 1.61803398874;\r\nconst vec3 V3Z = vec3(0.);\r\nstruct O\r\n{\r\n    // Distance the ray has travelled to the object\r\n    float dist;\r\n    // Material of the object\r\n    float mat;\r\n    // The position of the object in 3d space\r\n    vec3 pos;\r\n};\r\n\r\nstruct MarchResult{\r\n   // Object the marching hits.\r\n   O O;\r\n   // How many steps did the march take.\r\n   int steps;\r\n   // The position in world for march.\r\n   vec3 worldPosition;\r\n   // Normal for the object surface.\r\n   vec3 normal;\r\n   // How much did the ray travel.\r\n   float travel;\r\n};\r\n\r\n#define HASHSCALE1 .1031\r\nfloat Hash(float p)\r\n{\r\n\tvec3 p3  = fract(vec3(p) * HASHSCALE1);\r\n    p3 += dot(p3, p3.yzx + 19.19);\r\n    return fract((p3.x + p3.y) * p3.z);\r\n}\r\n\r\n// Point rotations\r\nvec3 RotPointX(vec3 p, float d) {\r\n    mat4 rotM= mat4(1.0, 0.0, 0.0, 0.0, \r\n                    0.0, cos(d), -sin(d), 0.0, \r\n                    0.0, sin(d), cos(d), 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\nvec3 RotPointY(vec3 p, float d) {\r\n    mat4 rotM= mat4(cos(d), 0.0, sin(d), 0.0, \r\n                    0.0, 1.0, 0.0, 0.0,\r\n                    -sin(d), 0.0, cos(d), 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\nvec3 RotPointZ(vec3 p, float d) {\r\n    mat4 rotM= mat4(cos(d), -sin(d), 0.0, 0.0, \r\n                    sin(d), cos(d), 0.0, 0.0, \r\n                    0.0, 0.0, 1.0, 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\n\r\n// Matrix rotations.\r\nmat3 RotX(float a)\r\n{\r\n    return mat3(\r\n        1.0, 0.0, 0.0, \r\n        0.0, cos(a), -sin(a), \r\n        0.0, sin(a), cos(a)\r\n    );\r\n}\r\nmat3 RotY(float a)\r\n{\r\n    return mat3(\r\n        cos(a), 0.0, sin(a), \r\n        0.0, 1.0, 0.0, \r\n        -sin(a), 0.0, cos(a)\r\n    );\r\n}\r\nmat3 RotZ(float a)\r\n{\r\n    return mat3(\r\n        cos(a), -sin(a), 0.0, \r\n        sin(a), cos(a), 0.0, \r\n        0.0, 0.0, 1.0\r\n    );\r\n}\r\nmat3 Rot(float x,float y,float z)\r\n{\r\n    float xca = cos(x);\r\n    float xsa = sin(x);\r\n    float yca = cos(y);\r\n    float ysa = sin(y);\r\n    float zca = cos(z);\r\n    float zsa = sin(z);\r\n    \r\n    return mat3( \r\n        1.0, 0.0, 0.0,\r\n        0.0, xca, -xsa,\r\n        0.0, xsa, xca\r\n    ) * \r\n    mat3(\r\n        yca, 0.0, ysa,\r\n        0.0, 1.0, 0.0,\r\n        -ysa, 0.0, yca\r\n    ) * \r\n    mat3(\r\n        yca, -ysa, 0.0,\r\n        ysa, yca, 0.0,\r\n        0.0, 0.0, 1.0\r\n    );\r\n}\r\n\r\n// Rotation around fixed axis\r\nmat3 RotationMatrix(vec3 axis, float angle)\r\n{\r\n    axis = normalize(axis);\r\n    float s = sin(angle);\r\n    float c = cos(angle);\r\n    float oc = 1.0 - c;\r\n    \r\n    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,\r\n                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,\r\n                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);\r\n}\r\nfloat Noise( in vec3 x ) { // in [0,1]\r\n    vec3 p = floor(x);\r\n    vec3 f = fract(x);\r\n\r\n    f = f*f*(3.-2.*f);\r\n\r\n    float n = p.x + p.y*57. + 113.*p.z;\r\n\r\n    float res = mix(mix(mix( Hash(n+  0.), Hash(n+  1.),f.x),\r\n                        mix( Hash(n+ 57.), Hash(n+ 58.),f.x),f.y),\r\n                    mix(mix( Hash(n+113.), Hash(n+114.),f.x),\r\n                        mix( Hash(n+170.), Hash(n+171.),f.x),f.y),f.z);\r\n    return res;\r\n}\r\n\r\nfloat SNoise( in vec3 x ) {\r\n    return Noise(x) * 2.0 - 1.0;\r\n}\r\n// Another hash method that may result in better values\r\nfloat HashB(float n) {return fract(sin(n)*43758.5453123);}\r\n\r\n// Alternative noise implementation that may result in better results in fbm for example\r\nfloat NoiseB( in vec3 x ) { // in [0,1]\r\n    vec3 p = floor(x);\r\n    vec3 f = fract(x);\r\n\r\n    f = f*f*(3.-2.*f);\r\n\r\n    float n = p.x + p.y*57. + 113.*p.z;\r\n\r\n    float res = mix(mix(mix( HashB(n+  0.), HashB(n+  1.),f.x),\r\n                        mix( HashB(n+ 57.), HashB(n+ 58.),f.x),f.y),\r\n                    mix(mix( HashB(n+113.), HashB(n+114.),f.x),\r\n                        mix( HashB(n+170.), HashB(n+171.),f.x),f.y),f.z);\r\n    return res;\r\n}\r\n\r\nfloat SNoiseB( in vec3 x ) {\r\n    return Noise(x) * 2.0 - 1.0;\r\n}\r\nfloat RoundBox( vec3 p, vec3 b, float r )\r\n{\r\n  vec3 d = abs(p) - b;\r\n  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0)) - r;\r\n}\r\nfloat Octahedron( vec3 p, float s)\r\n{\r\n  p = abs(p);\r\n  return (p.x+p.y+p.z-s)*0.57735027;\r\n}\r\nfloat Ground(vec3 position, float height)\r\n{\r\n    return position.y - height;\r\n}\r\nfloat Ceiling(vec3 pos, float y){\r\n    return -(pos.y+y);\r\n}\r\nfloat Sphere( vec3 pos, float radius )\r\n{\r\n    return length(pos) - radius;\r\n}\r\nfloat BoxFrame( vec3 p, vec3 b, float e )\r\n{\r\n  p = abs(p  )-b;\r\n  vec3 q = abs(p+e)-e;\r\n  return min(min(\r\n      length(max(vec3(p.x,q.y,q.z),0.0))+min(max(p.x,max(q.y,q.z)),0.0),\r\n      length(max(vec3(q.x,p.y,q.z),0.0))+min(max(q.x,max(p.y,q.z)),0.0)),\r\n      length(max(vec3(q.x,q.y,p.z),0.0))+min(max(q.x,max(q.y,p.z)),0.0));\r\n}\r\nfloat CappedCylinder( vec3 p, float h, float r )\r\n{\r\n  vec2 d = abs(vec2(length(p.xz),p.y)) - vec2(h,r);\r\n  return min(max(d.x,d.y),0.0) + length(max(d,0.0));\r\n}\r\nfloat Cylinder(vec3 pos, float radius)\r\n{\r\n    return length(pos.xy) - radius;\r\n}\r\n// Creates a round tunnel positioned to penetrate given plane (pos.xy creates tunnel in z-axis)\r\nfloat Tunnel(vec2 posPlane, float diameter){\r\n    return -length(posPlane.xy) + diameter;\r\n}\r\nfloat Cone( vec3 p, vec2 c, float h )\r\n{\r\n  float q = length(p.xz);\r\n  return max(dot(c.xy,vec2(q,p.y)),-h-p.y);\r\n}\r\n// Union of two objects with support for material mixing\r\nO Union(O a, O b){\r\n    float s = step(b.dist, a.dist);\r\n    return O( mix(a.dist, b.dist, s),\r\n                       mix(a.mat, b.mat, s),\r\n                       mix(a.pos, b.pos, s));\r\n}\r\nfloat Union(float a, float b){\r\n    return min(a, b);\r\n}\r\nfloat SmoothSubtraction( float d1, float d2, float k )\r\n{\r\n    float h = max(k-abs(-d1-d2),0.0);\r\n    return max(-d2, d1) + h*h*0.25/k;\r\n}\r\nfloat SmoothUnion(float a, float b, float k)\r\n{\r\n \tfloat h = clamp(0.5 + 0.5 * (b-a)/k, 0.0, 1.0);\r\n    //return mix( b,a,h) - k*h*(1.0-h);\r\n    float dist =mix(b, a, h) - k*h*(1.0-h);\r\n    return dist;\r\n}\r\nO SmoothUnion(O a, O b, float k)\r\n{\r\n \tfloat h = clamp(0.5 + 0.5 * (b.dist-a.dist)/k, 0.0, 1.0);\r\n    //return mix( b,a,h) - k*h*(1.0-h);\r\n    float dist =mix(b.dist, a.dist, h) - k*h*(1.0-h);\r\n    float s = step(b.dist, a.dist);\r\n    return O( dist,\r\n              mix(a.mat, b.mat, s),\r\n              mix(a.pos, b.pos, s));\r\n}\r\nO SmoothSubtraction( O a, O b, float k ) {\r\n    float d1 = a.dist;\r\n    float d2 = b.dist;\r\n    float s = step(d1, d2);\r\n    float h = clamp( 0.5 - 0.5*(d2+d1)/k, 0.0, 1.0 );\r\n    float d = mix( d2, -d1, h ) + k*h*(1.0-h); \r\n    return O( d,\r\n              mix(a.mat, b.mat, s),\r\n              mix(a.pos, b.pos, s));\r\n}\r\nvec3 Repeat( vec3 p, vec3 c)\r\n{\r\n    vec3 q = vec3(0.);\r\n    vec3 q2 = mod(p+0.5*c,c)-0.5*c;\r\n    q.x = c.x > 0. ? q2.x : p.x;\r\n    q.y = c.y > 0. ? q2.y : p.y;\r\n    q.z = c.z > 0. ? q2.z : p.z;\r\n    return q;\r\n}\r\n\r\nvec3 volumetric = vec3(0.0);\r\n\r\n// fbm with gyroid as noise generator\r\nfloat gyroid (vec3 seed) { return dot(cos(seed),sin(seed.zxy)); }\r\nfloat fbm(vec3 p)\r\n{\t\r\n\tfloat t = 0.;\r\n    float a = .5;\r\n    for (int i = 0; i < 8; ++i) {\r\n        // each iteration creates a smaller effect. Travelling in any direction provides animated value from gyroid\r\n        p.z -= (t*0.1);\r\n        // the actual distance\r\n        t += abs(gyroid(p/a))*a;\r\n        // making sure next step is treated as smaller traverse\r\n        a *= .5;\r\n    }\r\n    return t;\r\n}\r\n\r\n/*************\r\n*** CAMERA ***\r\n*************/\r\nvec3 getCameraRayDir(vec2 uv, vec3 pos, vec3 target, float fov, float rot)\r\n{\r\n    \r\n    //vec3 forward = normalize( target - pos );\r\n    //mat3 rotmat = RotationMatrix(forward, rot);\r\n    //forward = (rotmat[2]);\r\n    //vec3 up = (rotmat[1]);\r\n    //vec3 right = (rotmat[0]);\r\n    \r\n    //vec3 right = normalize(cross(cameraUp, forward));\r\n    //vec3 up = normalize(cross(forward,right));\r\n    \r\n    //return normalize( uv.x * right + uv.y * up + forward * fov);\r\n    \r\n    \r\n    vec3 forward = normalize( target - pos );\r\n    vec3 right = normalize(cross(vec3(0., 1.0, 0.), forward));\r\n    vec3 up = normalize(cross(forward,right));\r\n    return normalize( uv.x * right + uv.y * up + forward * fov);\r\n}\r\n\r\nvec2 wpToTexture(vec2 p) { return p*0.01;}\r\n\r\n\r\nO mapVolumes(vec3 pos) {\r\n    pos += vec3(2.55, -2.3, 0.);\r\n    return O(Cone(pos, vec2(1., 0.42), 4.), 11., V3Z);\r\n    //return O(RoundBox(pos, vec3(1.),0.1), 11., V3Z);\r\n}\r\n\r\nconst float MAXDIST = 50.;\r\n\r\nO mapGrill(vec3 pos){\r\n    float grillD = Sphere(pos, 1.);\r\n    \r\n    // using ground texture to generate some roughness\r\n    vec3 c = texture(groundTex, pos.xy*0.1).rgb;\r\n    float biomeD = (c.x+c.y+c.z)/3.;\r\n    grillD -= biomeD*0.04;\r\n\r\n    grillD = SmoothSubtraction(grillD, RoundBox(pos-vec3(0., 1., 0.), vec3(1.), 0.1), 0.05);\r\n    grillD = SmoothSubtraction(grillD, Sphere(pos, 0.95), 0.1);\r\n\r\n    O res = O(grillD, 0., V3Z);\r\n\r\n    // Ritilä\r\n    vec3 pr = pos + vec3(0., +0.2, 0.);\r\n    pr = Repeat(pr, vec3(0., 0., .15));\r\n    float rd = RoundBox(pr, vec3(2., 0.02, 0.02), 0.0);\r\n    //rd = SmoothSubtraction(rd, -Sphere(pos, 0.95), 0.0);\r\n    // Limit ritilä to sphere\r\n    rd = max(rd, length(pos)-0.98);\r\n    O g = O(rd, 2., V3Z);\r\n    \r\n\r\n    // Legs\r\n    vec3 po = pos;\r\n    // leg1\r\n    vec3 legsp = po + vec3(0.0, 0., 0.25);\r\n    legsp = legsp*Rot(-0.2, 0., 0.0);\r\n    legsp = legsp + vec3(0., 1.85, 0.);\r\n    float ld1 = CappedCylinder(legsp, 0.05, 1.);\r\n    // leg 2\r\n    legsp = po + vec3(0.25, 0., -0.25);\r\n    legsp = legsp*RotX(0.2)*RotZ(0.2);\r\n    legsp = legsp + vec3(0., 1.85, 0.);\r\n    float ld2 = CappedCylinder(legsp, 0.05, 1.);\r\n    \r\n    // leg 3\r\n    legsp = po + vec3(-0.25, 0., -0.25);\r\n    legsp = legsp*RotX(0.2)*RotZ(-0.2); \r\n    legsp = legsp + vec3(0., 1.85, 0.);\r\n    float ld3 = CappedCylinder(legsp, 0.05, 1.);\r\n    \r\n\r\n    ld1 = Union(ld1, ld2);\r\n    ld1 = Union(ld1, ld3);\r\n    O leg = O(ld1, 3., V3Z);\r\n\r\n    res = Union(res, g);\r\n    res = SmoothUnion(res, leg, 0.05);\r\n    return res;\r\n}\r\n\r\nvec3 cheapBend(in vec3 p, float i)\r\n{\r\n    float k = 0.9; // TODO, uniform\r\n    float c = cos(k*p.x);\r\n    float s = sin(k*p.y);\r\n    mat2  m = mat2(c,-s,s,c);\r\n    vec3  q = vec3( (m*p.xy).x, p.y, p.z);\r\n    return q;\r\n}\r\n\r\nO mapSausage(vec3 pos){\r\n    //pos = pos * RotY(time);\r\n    pos = pos * RotX(PI/2.);\r\n\r\n    vec3 po = pos;\r\n    pos = pos + vec3(0., 0.1, 0);\r\n    vec3 cp = pos;\r\n    cp = cp * RotZ(PI/2.);\r\n    cp = cheapBend(cp, 0.0);\r\n    \r\n    float sausageDist = CappedCylinder(cp, .10*sausageSize, 0.35*sausageSize); \r\n    sausageDist = SmoothUnion(sausageDist, Sphere(pos + vec3(0.35, -0.20, 0.)*sausageSize, 0.05*sausageSize), 0.15 );\r\n    sausageDist = SmoothUnion(sausageDist, Sphere(pos + vec3(-0.35, -0.20, 0.)*sausageSize, 0.05*sausageSize), 0.15 );\r\n    //float displacement = -po.x;\r\n    // Limit to sphere\r\n    sausageDist = max(sausageDist, length(pos)-0.98);\r\n    return O(sausageDist, 1., V3Z);\r\n}\r\n\r\nO mapCoals(vec3 pos){\r\n    vec3 po = pos + vec3(0., 0.45, 0.);\r\n    \r\n    /*\r\n    mustat hiiloset\r\n    vec3 pr = Repeat(po, vec3(0.15, 0., .15));\r\n    float rd = RoundBox(pr, vec3(0.01, 0.01, 0.01), 0.2);\r\n    //rd = SmoothSubtraction(rd, -Sphere(pos, 0.95), 0.0);\r\n    // Limit ritilä to sphere\r\n    rd = max(rd, length(pos)-0.85);\r\n    O g = O(rd, 3., V3Z);\r\n    */\r\n\r\n    vec3 pr = Repeat(po, vec3(0.3, 0., 0.3));\r\n    float rd = RoundBox(pr, vec3(0.03, 0.08, 0.03), 0.1);\r\n    //rd = SmoothSubtraction(rd, -Sphere(pos, 0.95), 0.0);\r\n    // Limit ritilä to sphere\r\n    rd = max(rd, length(pos)-0.85);\r\n    O rc = O(rd, 4., V3Z);\r\n    return rc;\r\n}\r\n\r\nO map( vec3 pos )\r\n{\r\n    O grill = mapGrill(pos);\r\n    O coals = mapCoals(pos);\r\n    O sausage = mapSausage( (pos-sausagePos) * RotX(sausageRot.x)*RotY(sausageRot.y) );\r\n\r\n    O res = Union(grill, sausage);\r\n    res = Union(res, coals);\r\n    if(res.dist > 0. && cheapGlow < 0.1){\r\n        // volumes\r\n        O smoke = O(CappedCylinder(pos-vec3(0., 1.9, 0.), 2.0, 2.), 11.,V3Z);\r\n        res = Union(smoke, res);\r\n    }\r\n\r\n    vec3 po = pos;\r\n    pos = pos * RotY(time);\r\n    // 4 big screens rotating in the bg\r\n    \r\n    if(phase > 0.5){\r\n        float backplateD = RoundBox(pos+vec3(0., -10., -12.), vec3(16., 12., 0.2), 0.0);\r\n        O bplate = O(backplateD, -1., pos);\r\n        \r\n        float backplateD2 = RoundBox(pos+vec3(0., -10., 12.), vec3(16., 12., 0.2), 0.0);\r\n        O bplate2 = O(backplateD2, -1.1, pos);\r\n        \r\n        float backplateD3 = RoundBox(pos+vec3(12., -10., 0.), vec3(.2, 12., 16.), 0.0);\r\n        O bplate3 = O(backplateD3, -1.2, pos);\r\n\r\n        float backplateD4 = RoundBox(pos+vec3(-12., -10., 0.), vec3(.2, 12., 16.), 0.0);\r\n        O bplate4 = O(backplateD4, -1.3, pos);\r\n    \r\n        bplate = SmoothUnion(bplate, bplate2, 4.);\r\n        bplate = SmoothUnion(bplate, bplate3, 4.);\r\n        bplate = SmoothUnion(bplate, bplate4, 4.);    \r\n        res = SmoothUnion(res, bplate, 2.2);\r\n\r\n    }\r\n\r\n    pos = po;\r\n    // ground\r\n    vec3 c = texture(groundTex, wpToTexture(pos.xz)).rgb;\r\n    float biomeD = (c.x+c.y+c.z)/3.;\r\n    \r\n    float sphericalGroundD = Sphere(pos+vec3(0., 22.,0.), 20.);\r\n    sphericalGroundD = Ground(pos, 0.5  );\r\n    res = Union(res, O(sphericalGroundD + biomeD*4., -2., V3Z)); \r\n\r\n    return res;\r\n}\r\n\r\n// Requires hash.fs to be included\r\n\r\nvec3 RandomSphereDir(vec2 rnd)\r\n{\r\n\tfloat s = rnd.x*PI*2.;\r\n\tfloat t = rnd.y*2.-1.;\r\n\treturn vec3(sin(s), cos(s), t) / sqrt(1.0 + t * t);\r\n}\r\nvec3 RandomHemisphereDir(vec3 dir, float i)\r\n{\r\n\tvec3 v = RandomSphereDir( vec2(Hash(i+1.), Hash(i+2.)) );\r\n\treturn v * sign(dot(v, dir));\r\n}\r\n\r\nfloat AmbientOcclusion( in vec3 p, in vec3 n, in float maxDist, in float falloff )\r\n{\r\n\tconst int nbIte = 32;\r\n    const float nbIteInv = 1./float(nbIte);\r\n    const float rad = 1.-1.*nbIteInv; //Hemispherical factor (self occlusion correction)\r\n    \r\n\tfloat ao = 0.0;\r\n    \r\n    for( int i=0; i<nbIte; i++ )\r\n    {\r\n        float l = Hash(float(i))*maxDist;\r\n        vec3 rd = normalize(n+RandomHemisphereDir(n, l )*rad)*l; // mix direction with the normal\r\n        \t\t\t\t\t\t\t\t\t\t\t\t\t    // for self occlusion problems!\r\n        \r\n        ao += (l - max(map( p + rd ).dist,0.)) / maxDist * falloff;\r\n    }\r\n\t\r\n    return clamp( 1.-ao*nbIteInv, 0., 1.);\r\n}\r\n\r\n\r\n// Calculates the surface normal\r\nvec3 CalcNormal( vec3 pos)\r\n{\r\n    float c = map(pos).dist;\r\n    vec2 e = vec2(0.001, 0.0);\r\n    return normalize( vec3( map( pos + e.xyy).dist,\r\n                            map( pos + e.yxy).dist,\r\n                            map( pos + e.yyx).dist) -c);\r\n}\r\n\r\nvec3 Diffuse( vec3 pos, vec3 light, vec3 normal )\r\n{\r\n    float dotNL = max(dot( normal, normalize(light - pos)), 0.0);\r\n    return vec3(1.) * dotNL;\r\n}\r\n\r\n\r\nconst float STEP = 0.001;\r\nconst float VOLUMETRIC_STEP = 0.02;\r\n\r\n\r\n/**\r\n * Main raymarch function for main image & reflections. \r\n */\r\nMarchResult raymarch(vec3 cam, vec3 rd){\r\n    float t = 0.0;\r\n    vec3 col = vec3(0.);\r\n    O res;\r\n    int steps = 0;\r\n    vec3 p = vec3(0.);\r\n    vec4 sum = vec4(0,0,0,1); // single volumetric pass sum, alpha is used to check if we can end volumetric traverse\r\n    float s = MAXDIST/512.;\r\n    // apply ground displacement to camera as well\r\n   // cam.y -= groundDisplacement(cam);\r\n    //cam.y -= NoiseB(vec3(0,0,time*0.1))*3.0;\r\n    for( int i = 0; i < 512; i++)\r\n    {\r\n        // to rotate world, add this: \r\n        // float a = smoothstep(10.0, MAXDIST, t);\r\n        // p = cam + RotationMatrix( vec3(0., 1.0, 0.0), a)*rd*t; \r\n        p = cam + rd*t;\r\n        res = map( p );\r\n        t+= res.mat < 10.0 ? res.dist : max(VOLUMETRIC_STEP, res.dist-VOLUMETRIC_STEP);\r\n\r\n        vec3 psmoke = p;\r\n        psmoke.y -= time;\r\n        psmoke.x += sin(time*.05);\r\n        psmoke.z += cos(time*.1);\r\n        float fbm = fbm(psmoke);\r\n        if(res.dist < STEP && res.mat > 10.){\r\n            // volumetric\r\n            vec3 volAmount = 1.05*fbm*vec3(1.)/MAXDIST;\r\n            volAmount = mix(volAmount, vec3(0.,0.0,0.), smoothstep(0., 2., length(p)));\r\n            sum.xyz += volAmount;\r\n        }\r\n        else {\r\n            // bg volumetrics\r\n            // this adds very cheap glow\r\n            sum += cheapGlow*fbm*vec4(0.65, 0.95, 0.65, 0.0)/t*.08;\r\n        }\r\n       // if (sum.a<.01) break; // optimization\r\n        if(res.dist < STEP && res.mat < 10. ) \r\n        {\r\n            // Ray trace hit an object\r\n            break;\r\n        }\r\n        if(t > MAXDIST) {\r\n            res.mat = -1.;\r\n            t = MAXDIST;\r\n            break;\r\n        }\r\n        steps++;\r\n    }\r\n    MarchResult mr = MarchResult(res, steps, p, vec3(0), t);\r\n// Only calculate normals if result material is [0,9]. Negative materials are skyhits, over 10 are volumetric\r\n    if(res.mat > -0.5 && res.mat < 9.5){\r\n        mr.normal = CalcNormal(mr.worldPosition);\r\n    }\r\n    sum.rgb = clamp(sum.rgb, vec3(0.), vec3(0.9));\r\n    volumetric = sum.rgb;\r\n    \r\n    return mr;\r\n}\r\n\r\nconst float STEP_LOW = 0.01;\r\n/**\r\n * Lower quality raymarch. Use for shadows etc. \r\n * Does not support volumetric materials.\r\n */\r\nMarchResult raymarchLow(vec3 cam, vec3 rd, float maxdist){\r\n    float t = 0.0;\r\n    vec3 col = vec3(0.);\r\n    O res;\r\n    int steps = 0;\r\n    vec3 p = vec3(0.);\r\n    float minval = 1.0;\r\n    for( int i = 0; i < 512; i++)\r\n    {\r\n        p = cam + rd*t;\r\n        res = map( p );\r\n        t+= max(STEP_LOW,res.dist);\r\n        // Only calculate how close the ray was to solid object.\r\n        if(res.mat < 9.5 && res.mat >0.5)\r\n        {\r\n            minval = min(minval, res.dist);\r\n        }\r\n        \r\n        if(res.dist < STEP_LOW && res.mat < 9.5 && res.mat >0.5 ) \r\n        {\r\n            // Ray trace hit an object\r\n            break;\r\n        }\r\n        if(t > maxdist) {\r\n            res.mat = -1.;\r\n            t = maxdist;\r\n            break;\r\n        }\r\n        \r\n        steps++;\r\n    }\r\n    if(steps >=512) res.mat = -1.0;\r\n    p.x = minval;\r\n    MarchResult mr = MarchResult(res, steps, p, vec3(0), t);\r\n    \r\n    return mr;\r\n}\r\n\r\n\r\nvec3 textureMap( vec3 surfacepos, vec3 normal, float mat )\r\n{\r\n    vec2 sp = surfacepos.xy;\r\n    if(mat>-1.05) sp =surfacepos.xy;\r\n    else if(mat>-1.15) sp =surfacepos.xy*vec2(-1.0,1.0);\r\n    else if(mat>-1.25) sp =surfacepos.zy*vec2(-1.0,1.0);\r\n    else if(mat>-1.35) sp =surfacepos.zy;\r\n    \r\n    \r\n    // pos: 0,10,10\r\n    // size: 16,9,1\r\n    // 0,0 == -8,0\r\n    // 1,1 == 5,10\r\n    vec2 p = vec2((sp.x+16.)/32., sp.y/20.+0.1);\r\n    return texture(skyTex, p.xy).rgb;\r\n    // not bad?\r\n    return surfacepos*0.1;\r\n}\r\n\r\nvoid colorize(MarchResult result, vec3 rayDir, out vec3 col){\r\n    vec3 p = result.worldPosition;\r\n    vec3 light = lightPos;\r\n    vec3 normal = result.normal;\r\n    vec3 colImg = vec3(0.0);\r\n    float ambience = 0.75;\r\n    if(result.O.mat > 10.){\r\n        // Invalid\r\n        col = vec3(99., 0., 0.);    \r\n        return;\r\n    }\r\n    if(result.O.mat < -1.5){\r\n        // spherical ground\r\n        col = abs(p)*0.1;\r\n        col.g += 0.25;\r\n    }\r\n    else if(result.O.mat < -0.5)\r\n    {\r\n        //Skydome\r\n      //  col = skyCol;\r\n        colImg = textureMap(result.O.pos, normal, result.O.mat);\r\n        colImg *= 0.5+0.5*smoothstep(-1.0,1.0,result.O.pos.y);\r\n        colImg *= 2.;\r\n    }\r\n    else if (result.O.mat < 0.5) \r\n    {\r\n        // grillin ulko-osat\r\n        col = vec3(0.5);//\r\n        col *= Diffuse(p, light, normal) * AmbientOcclusion(p, normal, 4., 2.);\r\n        //col.r *=1.1;\r\n\r\n    }\r\n    else if(result.O.mat < 1.5)\r\n    {\r\n        // makkara\r\n        vec3 color = ${color2}*0.15;\r\n        col = color*(ambience+Diffuse(p, light, normal));// * AmbientOcclusion(p, normal, 4., 2.);\r\n        \r\n        // Reflect\r\n        //vec3 refCol = reflection(p, rayDir, normal);\r\n        //col = mix(col, refCol, .5);\r\n        //col *= col;\r\n        //col = mix(col, forceColor, 0.5);\r\n    } \r\n    else if(result.O.mat < 2.5)\r\n    {\r\n        // grillin ritilät\r\n        vec3 color = vec3(0.2);\r\n        col = color * AmbientOcclusion(p, normal, 4., 2.);\r\n        \r\n        \r\n        // Reflect\r\n        //vec3 refCol = reflection(p, rayDir, normal);\r\n        //col = mix(col, refCol, .5);\r\n        //col *= col;\r\n        //col = mix(col, forceColor, 0.5);\r\n    }  \r\n    else if (result.O.mat < 3.5){\r\n        // mustat hiilet\r\n        col = vec3(0.001);\r\n       // vec3 refCol = reflection(p, rayDir, normal);\r\n      //  col = mix(col, refCol, .5);\r\n      //  col *= col;\r\n    }\r\n    else if(result.O.mat < 4.5){\r\n        // hohkaavat hiilet\r\n        col = vec3(4.3, 0.35, 0.4) * AmbientOcclusion(p, normal, 4., 2.)*coalburn;\r\n        //col = ${color4} * smoothstep(-0.4, -0.25, result.worldPosition.y);\r\n    }\r\n    else if(result.O.mat < 5.5){\r\n        // light\r\n        col = lightCol;\r\n    }\r\n    else if(result.O.mat < 6.5){\r\n        // window\r\n        col = vec3(0.22, 0.37, 0.64)*Diffuse(p, light, result.normal)* AmbientOcclusion(p, result.normal, 8., 2.);; \r\n        //vec3 texturepos = p-result.O.pos;\r\n        //vec3 pcol = textureMap(texturepos, result.normal, 6.).rgb;\r\n        //col = mix(col, pcol, 0.0);\r\n    }\r\ncol+=colImg;\r\n}\r\n\r\n\r\nvoid render( vec2 uv, out vec4 diffuse)\r\n{\r\n    vec3 rd = getCameraRayDir( uv, camera, target, fov, sin(time*0.68)*0.6);\r\n    \r\n    MarchResult result= raymarch(camera, rd);\r\n    \r\n    if(result.O.mat < 10.){\r\n        colorize(result, rd, diffuse.rgb);\r\n    }\r\n\r\n    diffuse.a = result.travel/MAXDIST;\r\n    diffuse.rgb = mix(diffuse.rgb, skyCol, smoothstep(MAXDIST*.6, MAXDIST, result.travel));\r\n}\r\n\r\nvec4 Main(vec2 uv, float AA)\r\n{\r\n    // Output to screen\r\n    vec4 emissive = vec4(0.);\r\n    vec4 col = vec4(0.);\r\n    render(uv, col);    \r\n\r\n    return col + vec4(volumetric.rgb/(1.0+AA),0.0);\r\n}\r\n\r\nfloat AA = ${AA-LEVEL};\r\n\r\nvoid main()\r\n{\r\n    vec2 uv = (gl_FragCoord.xy/resolution.xy-0.5)*2.0;\r\n    uv.y*=resolution.y/resolution.x;\r\n    \r\n\tvec4 col = Main( uv, AA );\r\n    float count = 1.0;\r\n    vec2 aaStep = vec2(1.0/AA) / resolution.xy;\r\n    for( float aaX = 0.0; aaX < AA; aaX++)\r\n    {\r\n        for( float aaY = 0.0; aaY < AA; aaY++)\r\n        {\r\n            col += Main( uv + vec2( aaX, aaY ) * aaStep, AA );\r\n            count++;\r\n        }\r\n    }\r\n    col /= count;\r\n    \r\n    // Output to screen\r\n    outColor = col;\r\n}\r\n\r\n")}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:k.f1,value:0}),this.cameraU=this.CreateUniform({name:"camera",type:k.f3v,value:[.1,2,-4.01]}),this.targetU=this.CreateUniform({name:"target",type:k.f3v,value:[0,0,0]}),this.lightColU=this.CreateUniform({name:"lightCol",type:k.f3v,value:[2,2,2]}),this.fovU=this.CreateUniform({name:"fov",type:k.f1,value:1.95,max:20}),this.lightPosU=this.CreateUniform({name:"lightPos",type:k.f3v,value:[0,5,0]}),this.sausagePositionU=this.CreateUniform({name:"sausagePos",type:k.f3v,value:[0,0,0]}),this.sausageRotU=this.CreateUniform({name:"sausageRot",type:k.f2v,value:[0,0]}),this.coalBurnU=this.CreateUniform({name:"coalburn",type:k.f1,value:2,max:2,min:0}),this.cheapGlowU=this.CreateUniform({name:"cheapGlow",type:k.f1,value:0,max:2,min:0}),this.phaseU=this.CreateUniform({name:"phase",type:k.f1,value:0,max:2,min:0}),this.sausageSizeU=this.CreateUniform({name:"sausageSize",type:k.f1,value:1,max:4,min:1}),this.skyColorU=this.CreateUniform({name:"skyCol",type:k.f3v,value:[.2,.2,1],min:[0,0,0],max:[1,1,1]}),this.texLocation=this.renderer.context.getUniformLocation(this.program,"skyTex"),this.groundLocation=this.renderer.context.getUniformLocation(this.program,"groundTex");const t=this.postProcessing.As();t.Bloom.amount.value=4,t.Bloom.thresholdHigh.value=[3,3,3],t.Bloom.thresholdLow.value=[1,1,1],t.Bloom.radius.value=50,t.Bloom.distance.value=.2,t.Bloom.radiusY.value=50,t.Bloom.distanceY.value=.2,t.Godrays.amount.value=.7,t.Godrays.color.value=[.22,.7,.6],t.ColorAdjustment.brightness.value=-.18,t.ColorAdjustment.contrast.value=1.24,t.ColorAdjustment.exposure.value=1.11,t.BarrelDistort.amount.value=-.24;let e=.5;for(let t=0;t<9;t++)this.addCurve(new p(0,2*t,0,h.RELATIVE),new p(0,2*t+1,6,h.RELATIVE),t=>{const r=n.normalizeValue(0,.25,t),i=n.normalizeValue(.25,1,t);this.sausagePositionU.value=[0,(Ht(r)-qt(i))*e,0]}),this.addCurve(new p(0,2*t,0,h.RELATIVE),new p(0,2*t+1,6,h.RELATIVE),e=>{this.sausageRotU.value=[.5*Math.sin(2*t+2*qt(e)),3*Math.sin(t+Gt(e))]});for(let t=0;t<42;t++)this.addCurve(new p(4,1*t,0,h.RELATIVE),new p(4,1*t+1,6,h.RELATIVE),t=>{const r=n.normalizeValue(0,.25,t),i=n.normalizeValue(.25,1,t);this.sausagePositionU.value=[0,(Ht(r)-qt(i))*e,0]}),this.addCurve(new p(4,1*t,0,h.RELATIVE),new p(4,1*t+1,6,h.RELATIVE),e=>{this.sausageRotU.value=[.5*Math.sin(2*t+2*qt(e)),3*Math.sin(t+Gt(e))]});this.addCurve(new p(0,0,0,h.RELATIVE),new p(4,2,0,h.RELATIVE),t=>{this.cameraU.value=[0,2.5*t-1.5,2*t-20],this.targetU.value=[0,0,0],this.fovU.value=0+3*t,this.cheapGlowU.value=2},t=>Vt(t)),this.addCurve(new p(4,2,0,h.RELATIVE),new p(8,1,0,h.RELATIVE),t=>{this.cameraU.value=[(3+t)*Math.sin(t*Math.PI/2+Math.PI),4+4*t,(2+t)*Math.cos(t*Math.PI/2+Math.PI)],this.targetU.value=[0,.2*this.sausagePositionU.value[1]-.5,0],e=.5,this.fovU.value=2});new Ot(199);this.addCurve(new p(8,0,0,h.RELATIVE),new p(16,0,0,h.RELATIVE),t=>{this.cameraU.value=[2*Math.sin(2*Math.PI*t),.275-.5*Math.sin(Math.cos(t*Math.PI*4)),2*Math.cos(2*Math.PI*t)],this.targetU.value=[0,.3,0],e=.5,this.fovU.value=.54-.3*t,this.phaseU.value=1}),this.addTrigger(new p(-1,1,0,h.PATTERN),t=>{this.coalBurnU.value=3,this.sausageSizeU.value=this.sausageSizeU.value+.015}),this.addTrigger(new p(-1,2,0,h.PATTERN),t=>{this.coalBurnU.value=3,this.sausageSizeU.value=this.sausageSizeU.value+.015}),this.addTrigger(new p(-1,3,0,h.PATTERN),t=>{this.coalBurnU.value=3,this.sausageSizeU.value=this.sausageSizeU.value+.015}),this.addTrigger(new p(-1,0,0,h.PATTERN),t=>{this.imgindex=this.imgindex++%4+1})}start(t,e){super.start(t,e),this.postProcessing.As().ColorAdjustment.brightness.value=-.17,this.timeU.value=.001*t.toMilliseconds()}update(t){super.update(t),this.timeU.value=.001*t.toMilliseconds(),this.cheapGlowU.value=Math.max(0,this.cheapGlowU.value-.05*t.delta),this.coalBurnU.value=Math.max(0,this.coalBurnU.value-.065*t.delta),this.lightPosU.value=this.cameraU.value}render(t,e,n){this.renderer.context.uniform1i(this.texLocation,0),n.activeTexture(n.TEXTURE0),n.bindTexture(n.TEXTURE_2D,Bd.get(`textures/sky${this.imgindex}.jpg`)),this.renderer.context.uniform1i(this.groundLocation,1),n.activeTexture(n.TEXTURE1),n.bindTexture(n.TEXTURE_2D,Bd.get("textures/tech1_height.jpg")),super.render(t,e,n)}}const Kt="179",Zt=0,$t=1,Jt=2,Qt=100,te=101,ee=102,ne=200,re=201,ie=202,ae=203,se=204,oe=205,le=206,ce=207,he=208,ue=209,de=210,pe=211,fe=212,me=213,ge=214,ve=0,xe=1,_e=2,ye=3,be=4,Ee=5,Te=6,Se=7,Me="attached",we=301,Re=302,Ae=303,Ce=304,Pe=306,De=1e3,Ue=1001,Le=1002,Ie=1003,Ne=1004,Oe=1005,Fe=1006,Be=1007,ke=1008,ze=1009,Ve=1010,He=1011,Ge=1012,We=1013,Xe=1014,je=1015,qe=1016,Ye=1017,Ke=1018,Ze=1020,$e=35902,Je=1023,Qe=1026,tn=1027,en=1028,nn=1029,rn=1031,an=1033,sn=33776,on=33777,ln=33778,cn=33779,hn=35840,un=35841,dn=35842,pn=35843,fn=36196,mn=37492,gn=37496,vn=37808,xn=37809,_n=37810,yn=37811,bn=37812,En=37813,Tn=37814,Sn=37815,Mn=37816,wn=37817,Rn=37818,An=37819,Cn=37820,Pn=37821,Dn=36492,Un=36494,Ln=36495,In=36284,Nn=36285,On=36286,Fn=2300,Bn=2301,kn=2302,zn=2400,Vn=2401,Hn=2402,Gn="",Wn="srgb",Xn="srgb-linear",jn="linear",qn="srgb",Yn=7680,Kn=512,Zn=513,$n=514,Jn=515,Qn=516,tr=517,er=518,nr=519,rr=35044,ir="300 es",ar=2e3,sr=2001;class or{addEventListener(t,e){void 0===this._listeners&&(this._listeners={});const n=this._listeners;void 0===n[t]&&(n[t]=[]),-1===n[t].indexOf(e)&&n[t].push(e)}hasEventListener(t,e){const n=this._listeners;return void 0===n?0:void 0!==n[t]&&-1!==n[t].indexOf(e)}removeEventListener(t,e){const n=this._listeners;if(void 0===n)return;const r=n[t];if(void 0!==r){const t=r.indexOf(e);-1!==t&&r.splice(t,1)}}dispatchEvent(t){const e=this._listeners;if(void 0===e)return;const n=e[t.type];if(void 0!==n){t.target=this;const e=n.slice(0);for(let n=0,r=e.length;n<r;n++)e[n].call(this,t);t.target=null}}}const lr=["00","01","02","03","04","05","06","07","08","09","0a","0b","0c","0d","0e","0f","10","11","12","13","14","15","16","17","18","19","1a","1b","1c","1d","1e","1f","20","21","22","23","24","25","26","27","28","29","2a","2b","2c","2d","2e","2f","30","31","32","33","34","35","36","37","38","39","3a","3b","3c","3d","3e","3f","40","41","42","43","44","45","46","47","48","49","4a","4b","4c","4d","4e","4f","50","51","52","53","54","55","56","57","58","59","5a","5b","5c","5d","5e","5f","60","61","62","63","64","65","66","67","68","69","6a","6b","6c","6d","6e","6f","70","71","72","73","74","75","76","77","78","79","7a","7b","7c","7d","7e","7f","80","81","82","83","84","85","86","87","88","89","8a","8b","8c","8d","8e","8f","90","91","92","93","94","95","96","97","98","99","9a","9b","9c","9d","9e","9f","a0","a1","a2","a3","a4","a5","a6","a7","a8","a9","aa","ab","ac","ad","ae","af","b0","b1","b2","b3","b4","b5","b6","b7","b8","b9","ba","bb","bc","bd","be","bf","c0","c1","c2","c3","c4","c5","c6","c7","c8","c9","ca","cb","cc","cd","ce","cf","d0","d1","d2","d3","d4","d5","d6","d7","d8","d9","da","db","dc","dd","de","df","e0","e1","e2","e3","e4","e5","e6","e7","e8","e9","ea","eb","ec","ed","ee","ef","f0","f1","f2","f3","f4","f5","f6","f7","f8","f9","fa","fb","fc","fd","fe","ff"];let cr=1234567;const hr=Math.PI/180,ur=180/Math.PI;function dr(){const t=4294967295*Math.random()|0,e=4294967295*Math.random()|0,n=4294967295*Math.random()|0,r=4294967295*Math.random()|0;return(lr[255&t]+lr[t>>8&255]+lr[t>>16&255]+lr[t>>24&255]+"-"+lr[255&e]+lr[e>>8&255]+"-"+lr[e>>16&15|64]+lr[e>>24&255]+"-"+lr[63&n|128]+lr[n>>8&255]+"-"+lr[n>>16&255]+lr[n>>24&255]+lr[255&r]+lr[r>>8&255]+lr[r>>16&255]+lr[r>>24&255]).toLowerCase()}function pr(t,e,n){return Math.max(e,Math.min(n,t))}function fr(t,e){return(t%e+e)%e}function mr(t,e,n){return(1-n)*t+n*e}function gr(t,e){switch(e.constructor){case Float32Array:return t;case Uint32Array:return t/4294967295;case Uint16Array:return t/65535;case Uint8Array:return t/255;case Int32Array:return Math.max(t/2147483647,-1);case Int16Array:return Math.max(t/32767,-1);case Int8Array:return Math.max(t/127,-1);default:throw new Error("Invalid component type.")}}function vr(t,e){switch(e.constructor){case Float32Array:return t;case Uint32Array:return Math.round(4294967295*t);case Uint16Array:return Math.round(65535*t);case Uint8Array:return Math.round(255*t);case Int32Array:return Math.round(2147483647*t);case Int16Array:return Math.round(32767*t);case Int8Array:return Math.round(127*t);default:throw new Error("Invalid component type.")}}const xr={DEG2RAD:hr,RAD2DEG:ur,generateUUID:dr,clamp:pr,euclideanModulo:fr,mapLinear:function(t,e,n,r,i){return r+(t-e)*(i-r)/(n-e)},inverseLerp:function(t,e,n){return t!==e?(n-t)/(e-t):0},lerp:mr,damp:function(t,e,n,r){return mr(t,e,1-Math.exp(-n*r))},pingpong:function(t,e=1){return e-Math.abs(fr(t,2*e)-e)},smoothstep:function(t,e,n){return t<=e?0:t>=n?1:(t=(t-e)/(n-e))*t*(3-2*t)},smootherstep:function(t,e,n){return t<=e?0:t>=n?1:(t=(t-e)/(n-e))*t*t*(t*(6*t-15)+10)},randInt:function(t,e){return t+Math.floor(Math.random()*(e-t+1))},randFloat:function(t,e){return t+Math.random()*(e-t)},randFloatSpread:function(t){return t*(.5-Math.random())},seededRandom:function(t){void 0!==t&&(cr=t);let e=cr+=1831565813;return e=Math.imul(e^e>>>15,1|e),e^=e+Math.imul(e^e>>>7,61|e),((e^e>>>14)>>>0)/4294967296},degToRad:function(t){return t*hr},radToDeg:function(t){return t*ur},isPowerOfTwo:function(t){return!(t&t-1)&&0!==t},ceilPowerOfTwo:function(t){return Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))},floorPowerOfTwo:function(t){return Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},setQuaternionFromProperEuler:function(t,e,n,r,i){const a=Math.cos,s=Math.sin,o=a(n/2),l=s(n/2),c=a((e+r)/2),h=s((e+r)/2),u=a((e-r)/2),d=s((e-r)/2),p=a((r-e)/2),f=s((r-e)/2);switch(i){case"XYX":t.set(o*h,l*u,l*d,o*c);break;case"YZY":t.set(l*d,o*h,l*u,o*c);break;case"ZXZ":t.set(l*u,l*d,o*h,o*c);break;case"XZX":t.set(o*h,l*f,l*p,o*c);break;case"YXY":t.set(l*p,o*h,l*f,o*c);break;case"ZYZ":t.set(l*f,l*p,o*h,o*c)}},normalize:vr,denormalize:gr};class _r{constructor(t=0,e=0){_r.prototype.isVector2=1,this.x=t,this.y=e}get width(){return this.x}set width(t){this.x=t}get height(){return this.y}set height(t){this.y=t}set(t,e){return this.x=t,this.y=e,this}setScalar(t){return this.x=t,this.y=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setComponent(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y)}copy(t){return this.x=t.x,this.y=t.y,this}add(t){return this.x+=t.x,this.y+=t.y,this}addScalar(t){return this.x+=t,this.y+=t,this}addVectors(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this}addScaledVector(t,e){return this.x+=t.x*e,this.y+=t.y*e,this}sub(t){return this.x-=t.x,this.y-=t.y,this}subScalar(t){return this.x-=t,this.y-=t,this}subVectors(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this}multiply(t){return this.x*=t.x,this.y*=t.y,this}multiplyScalar(t){return this.x*=t,this.y*=t,this}divide(t){return this.x/=t.x,this.y/=t.y,this}divideScalar(t){return this.multiplyScalar(1/t)}applyMatrix3(t){const e=this.x,n=this.y,r=t.elements;return this.x=r[0]*e+r[3]*n+r[6],this.y=r[1]*e+r[4]*n+r[7],this}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this}clamp(t,e){return this.x=pr(this.x,t.x,e.x),this.y=pr(this.y,t.y,e.y),this}clampScalar(t,e){return this.x=pr(this.x,t,e),this.y=pr(this.y,t,e),this}clampLength(t,e){const n=this.length();return this.divideScalar(n||1).multiplyScalar(pr(n,t,e))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this}negate(){return this.x=-this.x,this.y=-this.y,this}dot(t){return this.x*t.x+this.y*t.y}cross(t){return this.x*t.y-this.y*t.x}lengthSq(){return this.x*this.x+this.y*this.y}length(){return Math.sqrt(this.x*this.x+this.y*this.y)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)}normalize(){return this.divideScalar(this.length()||1)}angle(){return Math.atan2(-this.y,-this.x)+Math.PI}angleTo(t){const e=Math.sqrt(this.lengthSq()*t.lengthSq());if(0===e)return Math.PI/2;const n=this.dot(t)/e;return Math.acos(pr(n,-1,1))}distanceTo(t){return Math.sqrt(this.distanceToSquared(t))}distanceToSquared(t){const e=this.x-t.x,n=this.y-t.y;return e*e+n*n}manhattanDistanceTo(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this}lerpVectors(t,e,n){return this.x=t.x+(e.x-t.x)*n,this.y=t.y+(e.y-t.y)*n,this}equals(t){return t.x===this.x&&t.y===this.y}fromArray(t,e=0){return this.x=t[e],this.y=t[e+1],this}toArray(t=[],e=0){return t[e]=this.x,t[e+1]=this.y,t}fromBufferAttribute(t,e){return this.x=t.getX(e),this.y=t.getY(e),this}rotateAround(t,e){const n=Math.cos(e),r=Math.sin(e),i=this.x-t.x,a=this.y-t.y;return this.x=i*n-a*r+t.x,this.y=i*r+a*n+t.y,this}random(){return this.x=Math.random(),this.y=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y}}class yr{constructor(t=0,e=0,n=0,r=1){this.isQuaternion=1,this._x=t,this._y=e,this._z=n,this._w=r}static slerpFlat(t,e,n,r,i,a,s){let o=n[r+0],l=n[r+1],c=n[r+2],h=n[r+3];const u=i[a+0],d=i[a+1],p=i[a+2],f=i[a+3];if(0===s)return t[e+0]=o,t[e+1]=l,t[e+2]=c,void(t[e+3]=h);if(1===s)return t[e+0]=u,t[e+1]=d,t[e+2]=p,void(t[e+3]=f);if(h!==f||o!==u||l!==d||c!==p){let t=1-s;const e=o*u+l*d+c*p+h*f,n=e>=0?1:-1,r=1-e*e;if(r>Number.EPSILON){const i=Math.sqrt(r),a=Math.atan2(i,e*n);t=Math.sin(t*a)/i,s=Math.sin(s*a)/i}const i=s*n;if(o=o*t+u*i,l=l*t+d*i,c=c*t+p*i,h=h*t+f*i,t===1-s){const t=1/Math.sqrt(o*o+l*l+c*c+h*h);o*=t,l*=t,c*=t,h*=t}}t[e]=o,t[e+1]=l,t[e+2]=c,t[e+3]=h}static multiplyQuaternionsFlat(t,e,n,r,i,a){const s=n[r],o=n[r+1],l=n[r+2],c=n[r+3],h=i[a],u=i[a+1],d=i[a+2],p=i[a+3];return t[e]=s*p+c*h+o*d-l*u,t[e+1]=o*p+c*u+l*h-s*d,t[e+2]=l*p+c*d+s*u-o*h,t[e+3]=c*p-s*h-o*u-l*d,t}get x(){return this._x}set x(t){this._x=t,this._onChangeCallback()}get y(){return this._y}set y(t){this._y=t,this._onChangeCallback()}get z(){return this._z}set z(t){this._z=t,this._onChangeCallback()}get w(){return this._w}set w(t){this._w=t,this._onChangeCallback()}set(t,e,n,r){return this._x=t,this._y=e,this._z=n,this._w=r,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._w)}copy(t){return this._x=t.x,this._y=t.y,this._z=t.z,this._w=t.w,this._onChangeCallback(),this}setFromEuler(t,e=1){const n=t._x,r=t._y,i=t._z,a=t._order,s=Math.cos,o=Math.sin,l=s(n/2),c=s(r/2),h=s(i/2),u=o(n/2),d=o(r/2),p=o(i/2);switch(a){case"XYZ":this._x=u*c*h+l*d*p,this._y=l*d*h-u*c*p,this._z=l*c*p+u*d*h,this._w=l*c*h-u*d*p;break;case"YXZ":this._x=u*c*h+l*d*p,this._y=l*d*h-u*c*p,this._z=l*c*p-u*d*h,this._w=l*c*h+u*d*p;break;case"ZXY":this._x=u*c*h-l*d*p,this._y=l*d*h+u*c*p,this._z=l*c*p+u*d*h,this._w=l*c*h-u*d*p;break;case"ZYX":this._x=u*c*h-l*d*p,this._y=l*d*h+u*c*p,this._z=l*c*p-u*d*h,this._w=l*c*h+u*d*p;break;case"YZX":this._x=u*c*h+l*d*p,this._y=l*d*h+u*c*p,this._z=l*c*p-u*d*h,this._w=l*c*h-u*d*p;break;case"XZY":this._x=u*c*h-l*d*p,this._y=l*d*h-u*c*p,this._z=l*c*p+u*d*h,this._w=l*c*h+u*d*p}return 1==e&&this._onChangeCallback(),this}setFromAxisAngle(t,e){const n=e/2,r=Math.sin(n);return this._x=t.x*r,this._y=t.y*r,this._z=t.z*r,this._w=Math.cos(n),this._onChangeCallback(),this}setFromRotationMatrix(t){const e=t.elements,n=e[0],r=e[4],i=e[8],a=e[1],s=e[5],o=e[9],l=e[2],c=e[6],h=e[10],u=n+s+h;if(u>0){const t=.5/Math.sqrt(u+1);this._w=.25/t,this._x=(c-o)*t,this._y=(i-l)*t,this._z=(a-r)*t}else if(n>s&&n>h){const t=2*Math.sqrt(1+n-s-h);this._w=(c-o)/t,this._x=.25*t,this._y=(r+a)/t,this._z=(i+l)/t}else if(s>h){const t=2*Math.sqrt(1+s-n-h);this._w=(i-l)/t,this._x=(r+a)/t,this._y=.25*t,this._z=(o+c)/t}else{const t=2*Math.sqrt(1+h-n-s);this._w=(a-r)/t,this._x=(i+l)/t,this._y=(o+c)/t,this._z=.25*t}return this._onChangeCallback(),this}setFromUnitVectors(t,e){let n=t.dot(e)+1;return n<1e-8?(n=0,Math.abs(t.x)>Math.abs(t.z)?(this._x=-t.y,this._y=t.x,this._z=0,this._w=n):(this._x=0,this._y=-t.z,this._z=t.y,this._w=n)):(this._x=t.y*e.z-t.z*e.y,this._y=t.z*e.x-t.x*e.z,this._z=t.x*e.y-t.y*e.x,this._w=n),this.normalize()}angleTo(t){return 2*Math.acos(Math.abs(pr(this.dot(t),-1,1)))}rotateTowards(t,e){const n=this.angleTo(t);if(0===n)return this;const r=Math.min(1,e/n);return this.slerp(t,r),this}identity(){return this.set(0,0,0,1)}invert(){return this.conjugate()}conjugate(){return this._x*=-1,this._y*=-1,this._z*=-1,this._onChangeCallback(),this}dot(t){return this._x*t._x+this._y*t._y+this._z*t._z+this._w*t._w}lengthSq(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w}length(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)}normalize(){let t=this.length();return 0===t?(this._x=0,this._y=0,this._z=0,this._w=1):(t=1/t,this._x=this._x*t,this._y=this._y*t,this._z=this._z*t,this._w=this._w*t),this._onChangeCallback(),this}multiply(t){return this.multiplyQuaternions(this,t)}premultiply(t){return this.multiplyQuaternions(t,this)}multiplyQuaternions(t,e){const n=t._x,r=t._y,i=t._z,a=t._w,s=e._x,o=e._y,l=e._z,c=e._w;return this._x=n*c+a*s+r*l-i*o,this._y=r*c+a*o+i*s-n*l,this._z=i*c+a*l+n*o-r*s,this._w=a*c-n*s-r*o-i*l,this._onChangeCallback(),this}slerp(t,e){if(0===e)return this;if(1===e)return this.copy(t);const n=this._x,r=this._y,i=this._z,a=this._w;let s=a*t._w+n*t._x+r*t._y+i*t._z;if(s<0?(this._w=-t._w,this._x=-t._x,this._y=-t._y,this._z=-t._z,s=-s):this.copy(t),s>=1)return this._w=a,this._x=n,this._y=r,this._z=i,this;const o=1-s*s;if(o<=Number.EPSILON){const t=1-e;return this._w=t*a+e*this._w,this._x=t*n+e*this._x,this._y=t*r+e*this._y,this._z=t*i+e*this._z,this.normalize(),this}const l=Math.sqrt(o),c=Math.atan2(l,s),h=Math.sin((1-e)*c)/l,u=Math.sin(e*c)/l;return this._w=a*h+this._w*u,this._x=n*h+this._x*u,this._y=r*h+this._y*u,this._z=i*h+this._z*u,this._onChangeCallback(),this}slerpQuaternions(t,e,n){return this.copy(t).slerp(e,n)}random(){const t=2*Math.PI*Math.random(),e=2*Math.PI*Math.random(),n=Math.random(),r=Math.sqrt(1-n),i=Math.sqrt(n);return this.set(r*Math.sin(t),r*Math.cos(t),i*Math.sin(e),i*Math.cos(e))}equals(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._w===this._w}fromArray(t,e=0){return this._x=t[e],this._y=t[e+1],this._z=t[e+2],this._w=t[e+3],this._onChangeCallback(),this}toArray(t=[],e=0){return t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._w,t}fromBufferAttribute(t,e){return this._x=t.getX(e),this._y=t.getY(e),this._z=t.getZ(e),this._w=t.getW(e),this._onChangeCallback(),this}toJSON(){return this.toArray()}_onChange(t){return this._onChangeCallback=t,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._w}}class br{constructor(t=0,e=0,n=0){br.prototype.isVector3=1,this.x=t,this.y=e,this.z=n}set(t,e,n){return void 0===n&&(n=this.z),this.x=t,this.y=e,this.z=n,this}setScalar(t){return this.x=t,this.y=t,this.z=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setZ(t){return this.z=t,this}setComponent(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y,this.z)}copy(t){return this.x=t.x,this.y=t.y,this.z=t.z,this}add(t){return this.x+=t.x,this.y+=t.y,this.z+=t.z,this}addScalar(t){return this.x+=t,this.y+=t,this.z+=t,this}addVectors(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this}addScaledVector(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this}sub(t){return this.x-=t.x,this.y-=t.y,this.z-=t.z,this}subScalar(t){return this.x-=t,this.y-=t,this.z-=t,this}subVectors(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this}multiply(t){return this.x*=t.x,this.y*=t.y,this.z*=t.z,this}multiplyScalar(t){return this.x*=t,this.y*=t,this.z*=t,this}multiplyVectors(t,e){return this.x=t.x*e.x,this.y=t.y*e.y,this.z=t.z*e.z,this}applyEuler(t){return this.applyQuaternion(Tr.setFromEuler(t))}applyAxisAngle(t,e){return this.applyQuaternion(Tr.setFromAxisAngle(t,e))}applyMatrix3(t){const e=this.x,n=this.y,r=this.z,i=t.elements;return this.x=i[0]*e+i[3]*n+i[6]*r,this.y=i[1]*e+i[4]*n+i[7]*r,this.z=i[2]*e+i[5]*n+i[8]*r,this}applyNormalMatrix(t){return this.applyMatrix3(t).normalize()}applyMatrix4(t){const e=this.x,n=this.y,r=this.z,i=t.elements,a=1/(i[3]*e+i[7]*n+i[11]*r+i[15]);return this.x=(i[0]*e+i[4]*n+i[8]*r+i[12])*a,this.y=(i[1]*e+i[5]*n+i[9]*r+i[13])*a,this.z=(i[2]*e+i[6]*n+i[10]*r+i[14])*a,this}applyQuaternion(t){const e=this.x,n=this.y,r=this.z,i=t.x,a=t.y,s=t.z,o=t.w,l=2*(a*r-s*n),c=2*(s*e-i*r),h=2*(i*n-a*e);return this.x=e+o*l+a*h-s*c,this.y=n+o*c+s*l-i*h,this.z=r+o*h+i*c-a*l,this}project(t){return this.applyMatrix4(t.matrixWorldInverse).applyMatrix4(t.projectionMatrix)}unproject(t){return this.applyMatrix4(t.projectionMatrixInverse).applyMatrix4(t.matrixWorld)}transformDirection(t){const e=this.x,n=this.y,r=this.z,i=t.elements;return this.x=i[0]*e+i[4]*n+i[8]*r,this.y=i[1]*e+i[5]*n+i[9]*r,this.z=i[2]*e+i[6]*n+i[10]*r,this.normalize()}divide(t){return this.x/=t.x,this.y/=t.y,this.z/=t.z,this}divideScalar(t){return this.multiplyScalar(1/t)}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this}clamp(t,e){return this.x=pr(this.x,t.x,e.x),this.y=pr(this.y,t.y,e.y),this.z=pr(this.z,t.z,e.z),this}clampScalar(t,e){return this.x=pr(this.x,t,e),this.y=pr(this.y,t,e),this.z=pr(this.z,t,e),this}clampLength(t,e){const n=this.length();return this.divideScalar(n||1).multiplyScalar(pr(n,t,e))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this.z=Math.trunc(this.z),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this}dot(t){return this.x*t.x+this.y*t.y+this.z*t.z}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)}normalize(){return this.divideScalar(this.length()||1)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this}lerpVectors(t,e,n){return this.x=t.x+(e.x-t.x)*n,this.y=t.y+(e.y-t.y)*n,this.z=t.z+(e.z-t.z)*n,this}cross(t){return this.crossVectors(this,t)}crossVectors(t,e){const n=t.x,r=t.y,i=t.z,a=e.x,s=e.y,o=e.z;return this.x=r*o-i*s,this.y=i*a-n*o,this.z=n*s-r*a,this}projectOnVector(t){const e=t.lengthSq();if(0===e)return this.set(0,0,0);const n=t.dot(this)/e;return this.copy(t).multiplyScalar(n)}projectOnPlane(t){return Er.copy(this).projectOnVector(t),this.sub(Er)}reflect(t){return this.sub(Er.copy(t).multiplyScalar(2*this.dot(t)))}angleTo(t){const e=Math.sqrt(this.lengthSq()*t.lengthSq());if(0===e)return Math.PI/2;const n=this.dot(t)/e;return Math.acos(pr(n,-1,1))}distanceTo(t){return Math.sqrt(this.distanceToSquared(t))}distanceToSquared(t){const e=this.x-t.x,n=this.y-t.y,r=this.z-t.z;return e*e+n*n+r*r}manhattanDistanceTo(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)+Math.abs(this.z-t.z)}setFromSpherical(t){return this.setFromSphericalCoords(t.radius,t.phi,t.theta)}setFromSphericalCoords(t,e,n){const r=Math.sin(e)*t;return this.x=r*Math.sin(n),this.y=Math.cos(e)*t,this.z=r*Math.cos(n),this}setFromCylindrical(t){return this.setFromCylindricalCoords(t.radius,t.theta,t.y)}setFromCylindricalCoords(t,e,n){return this.x=t*Math.sin(e),this.y=n,this.z=t*Math.cos(e),this}setFromMatrixPosition(t){const e=t.elements;return this.x=e[12],this.y=e[13],this.z=e[14],this}setFromMatrixScale(t){const e=this.setFromMatrixColumn(t,0).length(),n=this.setFromMatrixColumn(t,1).length(),r=this.setFromMatrixColumn(t,2).length();return this.x=e,this.y=n,this.z=r,this}setFromMatrixColumn(t,e){return this.fromArray(t.elements,4*e)}setFromMatrix3Column(t,e){return this.fromArray(t.elements,3*e)}setFromEuler(t){return this.x=t._x,this.y=t._y,this.z=t._z,this}setFromColor(t){return this.x=t.r,this.y=t.g,this.z=t.b,this}equals(t){return t.x===this.x&&t.y===this.y&&t.z===this.z}fromArray(t,e=0){return this.x=t[e],this.y=t[e+1],this.z=t[e+2],this}toArray(t=[],e=0){return t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t}fromBufferAttribute(t,e){return this.x=t.getX(e),this.y=t.getY(e),this.z=t.getZ(e),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this}randomDirection(){const t=Math.random()*Math.PI*2,e=2*Math.random()-1,n=Math.sqrt(1-e*e);return this.x=n*Math.cos(t),this.y=e,this.z=n*Math.sin(t),this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z}}const Er=new br,Tr=new yr;class Sr{constructor(t,e,n,r,i,a,s,o,l){Sr.prototype.isMatrix3=1,this.elements=[1,0,0,0,1,0,0,0,1],void 0!==t&&this.set(t,e,n,r,i,a,s,o,l)}set(t,e,n,r,i,a,s,o,l){const c=this.elements;return c[0]=t,c[1]=r,c[2]=s,c[3]=e,c[4]=i,c[5]=o,c[6]=n,c[7]=a,c[8]=l,this}identity(){return this.set(1,0,0,0,1,0,0,0,1),this}copy(t){const e=this.elements,n=t.elements;return e[0]=n[0],e[1]=n[1],e[2]=n[2],e[3]=n[3],e[4]=n[4],e[5]=n[5],e[6]=n[6],e[7]=n[7],e[8]=n[8],this}extractBasis(t,e,n){return t.setFromMatrix3Column(this,0),e.setFromMatrix3Column(this,1),n.setFromMatrix3Column(this,2),this}setFromMatrix4(t){const e=t.elements;return this.set(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10]),this}multiply(t){return this.multiplyMatrices(this,t)}premultiply(t){return this.multiplyMatrices(t,this)}multiplyMatrices(t,e){const n=t.elements,r=e.elements,i=this.elements,a=n[0],s=n[3],o=n[6],l=n[1],c=n[4],h=n[7],u=n[2],d=n[5],p=n[8],f=r[0],m=r[3],g=r[6],v=r[1],x=r[4],_=r[7],y=r[2],b=r[5],E=r[8];return i[0]=a*f+s*v+o*y,i[3]=a*m+s*x+o*b,i[6]=a*g+s*_+o*E,i[1]=l*f+c*v+h*y,i[4]=l*m+c*x+h*b,i[7]=l*g+c*_+h*E,i[2]=u*f+d*v+p*y,i[5]=u*m+d*x+p*b,i[8]=u*g+d*_+p*E,this}multiplyScalar(t){const e=this.elements;return e[0]*=t,e[3]*=t,e[6]*=t,e[1]*=t,e[4]*=t,e[7]*=t,e[2]*=t,e[5]*=t,e[8]*=t,this}determinant(){const t=this.elements,e=t[0],n=t[1],r=t[2],i=t[3],a=t[4],s=t[5],o=t[6],l=t[7],c=t[8];return e*a*c-e*s*l-n*i*c+n*s*o+r*i*l-r*a*o}invert(){const t=this.elements,e=t[0],n=t[1],r=t[2],i=t[3],a=t[4],s=t[5],o=t[6],l=t[7],c=t[8],h=c*a-s*l,u=s*o-c*i,d=l*i-a*o,p=e*h+n*u+r*d;if(0===p)return this.set(0,0,0,0,0,0,0,0,0);const f=1/p;return t[0]=h*f,t[1]=(r*l-c*n)*f,t[2]=(s*n-r*a)*f,t[3]=u*f,t[4]=(c*e-r*o)*f,t[5]=(r*i-s*e)*f,t[6]=d*f,t[7]=(n*o-l*e)*f,t[8]=(a*e-n*i)*f,this}transpose(){let t;const e=this.elements;return t=e[1],e[1]=e[3],e[3]=t,t=e[2],e[2]=e[6],e[6]=t,t=e[5],e[5]=e[7],e[7]=t,this}getNormalMatrix(t){return this.setFromMatrix4(t).invert().transpose()}transposeIntoArray(t){const e=this.elements;return t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],this}setUvTransform(t,e,n,r,i,a,s){const o=Math.cos(i),l=Math.sin(i);return this.set(n*o,n*l,-n*(o*a+l*s)+a+t,-r*l,r*o,-r*(-l*a+o*s)+s+e,0,0,1),this}scale(t,e){return this.premultiply(Mr.makeScale(t,e)),this}rotate(t){return this.premultiply(Mr.makeRotation(-t)),this}translate(t,e){return this.premultiply(Mr.makeTranslation(t,e)),this}makeTranslation(t,e){return t.isVector2?this.set(1,0,t.x,0,1,t.y,0,0,1):this.set(1,0,t,0,1,e,0,0,1),this}makeRotation(t){const e=Math.cos(t),n=Math.sin(t);return this.set(e,-n,0,n,e,0,0,0,1),this}makeScale(t,e){return this.set(t,0,0,0,e,0,0,0,1),this}equals(t){const e=this.elements,n=t.elements;for(let t=0;t<9;t++)if(e[t]!==n[t])return 0;return 1}fromArray(t,e=0){for(let n=0;n<9;n++)this.elements[n]=t[n+e];return this}toArray(t=[],e=0){const n=this.elements;return t[e]=n[0],t[e+1]=n[1],t[e+2]=n[2],t[e+3]=n[3],t[e+4]=n[4],t[e+5]=n[5],t[e+6]=n[6],t[e+7]=n[7],t[e+8]=n[8],t}clone(){return(new this.constructor).fromArray(this.elements)}}const Mr=new Sr;function wr(t){for(let e=t.length-1;e>=0;--e)if(t[e]>=65535)return 1;return 0}Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array;function Rr(t){return document.createElementNS("http://www.w3.org/1999/xhtml",t)}function Ar(){const t=Rr("canvas");return t.style.display="block",t}const Cr={};function Pr(t){t in Cr||(Cr[t]=1)}const Dr=(new Sr).set(.4123908,.3575843,.1804808,.212639,.7151687,.0721923,.0193308,.1191948,.9505322),Ur=(new Sr).set(3.2409699,-1.5373832,-.4986108,-.9692436,1.8759675,.0415551,.0556301,-.203977,1.0569715);function Lr(){const t={enabled:1,workingColorSpace:Xn,spaces:{},convert:function(t,e,n){return 0!=this.enabled&&e!==n&&e&&n?(this.spaces[e].transfer===qn&&(t.r=Nr(t.r),t.g=Nr(t.g),t.b=Nr(t.b)),this.spaces[e].primaries!==this.spaces[n].primaries&&(t.applyMatrix3(this.spaces[e].toXYZ),t.applyMatrix3(this.spaces[n].fromXYZ)),this.spaces[n].transfer===qn&&(t.r=Or(t.r),t.g=Or(t.g),t.b=Or(t.b)),t):t},workingToColorSpace:function(t,e){return this.convert(t,this.workingColorSpace,e)},colorSpaceToWorking:function(t,e){return this.convert(t,e,this.workingColorSpace)},getPrimaries:function(t){return this.spaces[t].primaries},getTransfer:function(t){return t===Gn?jn:this.spaces[t].transfer},getLuminanceCoefficients:function(t,e=this.workingColorSpace){return t.fromArray(this.spaces[e].luminanceCoefficients)},define:function(t){Object.assign(this.spaces,t)},_getMatrix:function(t,e,n){return t.copy(this.spaces[e].toXYZ).multiply(this.spaces[n].fromXYZ)},_getDrawingBufferColorSpace:function(t){return this.spaces[t].outputColorSpaceConfig.drawingBufferColorSpace},_getUnpackColorSpace:function(t=this.workingColorSpace){return this.spaces[t].workingColorSpaceConfig.unpackColorSpace},fromWorkingColorSpace:function(e,n){return Pr("THREE.ColorManagement: .fromWorkingColorSpace() has been renamed to .workingToColorSpace()."),t.workingToColorSpace(e,n)},toWorkingColorSpace:function(e,n){return Pr("THREE.ColorManagement: .toWorkingColorSpace() has been renamed to .colorSpaceToWorking()."),t.colorSpaceToWorking(e,n)}},e=[.64,.33,.3,.6,.15,.06],n=[.2126,.7152,.0722],r=[.3127,.329];return t.define({[Xn]:{primaries:e,whitePoint:r,transfer:jn,toXYZ:Dr,fromXYZ:Ur,luminanceCoefficients:n,workingColorSpaceConfig:{unpackColorSpace:Wn},outputColorSpaceConfig:{drawingBufferColorSpace:Wn}},[Wn]:{primaries:e,whitePoint:r,transfer:qn,toXYZ:Dr,fromXYZ:Ur,luminanceCoefficients:n,outputColorSpaceConfig:{drawingBufferColorSpace:Wn}}}),t}const Ir=Lr();function Nr(t){return t<.04045?.0773993808*t:Math.pow(.9478672986*t+.0521327014,2.4)}function Or(t){return t<.0031308?12.92*t:1.055*Math.pow(t,.41666)-.055}let Fr;class Br{static getDataURL(t,e="image/png"){if(/^data:/i.test(t.src))return t.src;if("undefined"==typeof HTMLCanvasElement)return t.src;let n;if(t instanceof HTMLCanvasElement)n=t;else{void 0===Fr&&(Fr=Rr("canvas")),Fr.width=t.width,Fr.height=t.height;const e=Fr.getContext("2d");t instanceof ImageData?e.putImageData(t,0,0):e.drawImage(t,0,0,t.width,t.height),n=Fr}return n.toDataURL(e)}static sRGBToLinear(t){if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap){const e=Rr("canvas");e.width=t.width,e.height=t.height;const n=e.getContext("2d");n.drawImage(t,0,0,t.width,t.height);const r=n.getImageData(0,0,t.width,t.height),i=r.data;for(let t=0;t<i.length;t++)i[t]=255*Nr(i[t]/255);return n.putImageData(r,0,0),e}if(t.data){const e=t.data.slice(0);for(let t=0;t<e.length;t++)e instanceof Uint8Array||e instanceof Uint8ClampedArray?e[t]=Math.floor(255*Nr(e[t]/255)):e[t]=Nr(e[t]);return{data:e,width:t.width,height:t.height}}return t}}let kr=0;class zr{constructor(t=null){this.isSource=1,Object.defineProperty(this,"id",{value:kr++}),this.uuid=dr(),this.data=t,this.dataReady=1,this.version=0}getSize(t){const e=this.data;return e instanceof HTMLVideoElement?t.set(e.videoWidth,e.videoHeight,0):e instanceof VideoFrame?t.set(e.displayHeight,e.displayWidth,0):null!==e?t.set(e.width,e.height,e.depth||0):t.set(0,0,0),t}set needsUpdate(t){1==t&&this.version++}toJSON(t){const e=void 0===t||"string"==typeof t;if(!e&&void 0!==t.images[this.uuid])return t.images[this.uuid];const n={uuid:this.uuid,url:""},r=this.data;if(null!==r){let t;if(Array.isArray(r)){t=[];for(let e=0,n=r.length;e<n;e++)r[e].isDataTexture?t.push(Vr(r[e].image)):t.push(Vr(r[e]))}else t=Vr(r);n.url=t}return e||(t.images[this.uuid]=n),n}}function Vr(t){return"undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap?Br.getDataURL(t):t.data?{data:Array.from(t.data),width:t.width,height:t.height,type:t.data.constructor.name}:{}}let Hr=0;const Gr=new br;class Wr extends or{constructor(t=Wr.DEFAULT_IMAGE,e=Wr.DEFAULT_MAPPING,n=1001,r=1001,i=1006,a=1008,s=1023,o=1009,l=Wr.DEFAULT_ANISOTROPY,c=""){super(),this.isTexture=1,Object.defineProperty(this,"id",{value:Hr++}),this.uuid=dr(),this.name="",this.source=new zr(t),this.mipmaps=[],this.mapping=e,this.channel=0,this.wrapS=n,this.wrapT=r,this.magFilter=i,this.minFilter=a,this.anisotropy=l,this.format=s,this.internalFormat=null,this.type=o,this.offset=new _r(0,0),this.repeat=new _r(1,1),this.center=new _r(0,0),this.rotation=0,this.matrixAutoUpdate=1,this.matrix=new Sr,this.generateMipmaps=1,this.premultiplyAlpha=0,this.flipY=1,this.unpackAlignment=4,this.colorSpace=c,this.userData={},this.updateRanges=[],this.version=0,this.onUpdate=null,this.renderTarget=null,this.isRenderTargetTexture=0,this.isArrayTexture=t&&t.depth&&t.depth>1?1:0,this.pmremVersion=0}get width(){return this.source.getSize(Gr).x}get height(){return this.source.getSize(Gr).y}get depth(){return this.source.getSize(Gr).z}get image(){return this.source.data}set image(t=null){this.source.data=t}updateMatrix(){this.matrix.setUvTransform(this.offset.x,this.offset.y,this.repeat.x,this.repeat.y,this.rotation,this.center.x,this.center.y)}addUpdateRange(t,e){this.updateRanges.push({start:t,count:e})}clearUpdateRanges(){this.updateRanges.length=0}clone(){return(new this.constructor).copy(this)}copy(t){return this.name=t.name,this.source=t.source,this.mipmaps=t.mipmaps.slice(0),this.mapping=t.mapping,this.channel=t.channel,this.wrapS=t.wrapS,this.wrapT=t.wrapT,this.magFilter=t.magFilter,this.minFilter=t.minFilter,this.anisotropy=t.anisotropy,this.format=t.format,this.internalFormat=t.internalFormat,this.type=t.type,this.offset.copy(t.offset),this.repeat.copy(t.repeat),this.center.copy(t.center),this.rotation=t.rotation,this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrix.copy(t.matrix),this.generateMipmaps=t.generateMipmaps,this.premultiplyAlpha=t.premultiplyAlpha,this.flipY=t.flipY,this.unpackAlignment=t.unpackAlignment,this.colorSpace=t.colorSpace,this.renderTarget=t.renderTarget,this.isRenderTargetTexture=t.isRenderTargetTexture,this.isArrayTexture=t.isArrayTexture,this.userData=JSON.parse(JSON.stringify(t.userData)),this.needsUpdate=1,this}setValues(t){for(const e in t){const n=t[e];if(void 0===n)continue;const r=this[e];void 0!==r&&(r&&n&&r.isVector2&&n.isVector2||r&&n&&r.isVector3&&n.isVector3||r&&n&&r.isMatrix3&&n.isMatrix3?r.copy(n):this[e]=n)}}toJSON(t){const e=void 0===t||"string"==typeof t;if(!e&&void 0!==t.textures[this.uuid])return t.textures[this.uuid];const n={metadata:{version:4.7,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,image:this.source.toJSON(t).uuid,mapping:this.mapping,channel:this.channel,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],center:[this.center.x,this.center.y],rotation:this.rotation,wrap:[this.wrapS,this.wrapT],format:this.format,internalFormat:this.internalFormat,type:this.type,colorSpace:this.colorSpace,minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy,flipY:this.flipY,generateMipmaps:this.generateMipmaps,premultiplyAlpha:this.premultiplyAlpha,unpackAlignment:this.unpackAlignment};return Object.keys(this.userData).length>0&&(n.userData=this.userData),e||(t.textures[this.uuid]=n),n}dispose(){this.dispatchEvent({type:"dispose"})}transformUv(t){if(300!==this.mapping)return t;if(t.applyMatrix3(this.matrix),t.x<0||t.x>1)switch(this.wrapS){case De:t.x=t.x-Math.floor(t.x);break;case Ue:t.x=t.x<0?0:1;break;case Le:1===Math.abs(Math.floor(t.x)%2)?t.x=Math.ceil(t.x)-t.x:t.x=t.x-Math.floor(t.x)}if(t.y<0||t.y>1)switch(this.wrapT){case De:t.y=t.y-Math.floor(t.y);break;case Ue:t.y=t.y<0?0:1;break;case Le:1===Math.abs(Math.floor(t.y)%2)?t.y=Math.ceil(t.y)-t.y:t.y=t.y-Math.floor(t.y)}return this.flipY&&(t.y=1-t.y),t}set needsUpdate(t){1==t&&(this.version++,this.source.needsUpdate=1)}set needsPMREMUpdate(t){1==t&&this.pmremVersion++}}Wr.DEFAULT_IMAGE=null,Wr.DEFAULT_MAPPING=300,Wr.DEFAULT_ANISOTROPY=1;class Xr{constructor(t=0,e=0,n=0,r=1){Xr.prototype.isVector4=1,this.x=t,this.y=e,this.z=n,this.w=r}get width(){return this.z}set width(t){this.z=t}get height(){return this.w}set height(t){this.w=t}set(t,e,n,r){return this.x=t,this.y=e,this.z=n,this.w=r,this}setScalar(t){return this.x=t,this.y=t,this.z=t,this.w=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setZ(t){return this.z=t,this}setW(t){return this.w=t,this}setComponent(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;case 3:this.w=e;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y,this.z,this.w)}copy(t){return this.x=t.x,this.y=t.y,this.z=t.z,this.w=void 0!==t.w?t.w:1,this}add(t){return this.x+=t.x,this.y+=t.y,this.z+=t.z,this.w+=t.w,this}addScalar(t){return this.x+=t,this.y+=t,this.z+=t,this.w+=t,this}addVectors(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this.w=t.w+e.w,this}addScaledVector(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this.w+=t.w*e,this}sub(t){return this.x-=t.x,this.y-=t.y,this.z-=t.z,this.w-=t.w,this}subScalar(t){return this.x-=t,this.y-=t,this.z-=t,this.w-=t,this}subVectors(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this.w=t.w-e.w,this}multiply(t){return this.x*=t.x,this.y*=t.y,this.z*=t.z,this.w*=t.w,this}multiplyScalar(t){return this.x*=t,this.y*=t,this.z*=t,this.w*=t,this}applyMatrix4(t){const e=this.x,n=this.y,r=this.z,i=this.w,a=t.elements;return this.x=a[0]*e+a[4]*n+a[8]*r+a[12]*i,this.y=a[1]*e+a[5]*n+a[9]*r+a[13]*i,this.z=a[2]*e+a[6]*n+a[10]*r+a[14]*i,this.w=a[3]*e+a[7]*n+a[11]*r+a[15]*i,this}divide(t){return this.x/=t.x,this.y/=t.y,this.z/=t.z,this.w/=t.w,this}divideScalar(t){return this.multiplyScalar(1/t)}setAxisAngleFromQuaternion(t){this.w=2*Math.acos(t.w);const e=Math.sqrt(1-t.w*t.w);return e<1e-4?(this.x=1,this.y=0,this.z=0):(this.x=t.x/e,this.y=t.y/e,this.z=t.z/e),this}setAxisAngleFromRotationMatrix(t){let e,n,r,i;const a=.01,s=.1,o=t.elements,l=o[0],c=o[4],h=o[8],u=o[1],d=o[5],p=o[9],f=o[2],m=o[6],g=o[10];if(Math.abs(c-u)<a&&Math.abs(h-f)<a&&Math.abs(p-m)<a){if(Math.abs(c+u)<s&&Math.abs(h+f)<s&&Math.abs(p+m)<s&&Math.abs(l+d+g-3)<s)return this.set(1,0,0,0),this;e=Math.PI;const t=(l+1)/2,o=(d+1)/2,v=(g+1)/2,x=(c+u)/4,_=(h+f)/4,y=(p+m)/4;return t>o&&t>v?t<a?(n=0,r=.707106781,i=.707106781):(n=Math.sqrt(t),r=x/n,i=_/n):o>v?o<a?(n=.707106781,r=0,i=.707106781):(r=Math.sqrt(o),n=x/r,i=y/r):v<a?(n=.707106781,r=.707106781,i=0):(i=Math.sqrt(v),n=_/i,r=y/i),this.set(n,r,i,e),this}let v=Math.sqrt((m-p)*(m-p)+(h-f)*(h-f)+(u-c)*(u-c));return Math.abs(v)<.001&&(v=1),this.x=(m-p)/v,this.y=(h-f)/v,this.z=(u-c)/v,this.w=Math.acos((l+d+g-1)/2),this}setFromMatrixPosition(t){const e=t.elements;return this.x=e[12],this.y=e[13],this.z=e[14],this.w=e[15],this}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this.w=Math.min(this.w,t.w),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this.w=Math.max(this.w,t.w),this}clamp(t,e){return this.x=pr(this.x,t.x,e.x),this.y=pr(this.y,t.y,e.y),this.z=pr(this.z,t.z,e.z),this.w=pr(this.w,t.w,e.w),this}clampScalar(t,e){return this.x=pr(this.x,t,e),this.y=pr(this.y,t,e),this.z=pr(this.z,t,e),this.w=pr(this.w,t,e),this}clampLength(t,e){const n=this.length();return this.divideScalar(n||1).multiplyScalar(pr(n,t,e))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this.z=Math.trunc(this.z),this.w=Math.trunc(this.w),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this}dot(t){return this.x*t.x+this.y*t.y+this.z*t.z+this.w*t.w}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)}normalize(){return this.divideScalar(this.length()||1)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this.w+=(t.w-this.w)*e,this}lerpVectors(t,e,n){return this.x=t.x+(e.x-t.x)*n,this.y=t.y+(e.y-t.y)*n,this.z=t.z+(e.z-t.z)*n,this.w=t.w+(e.w-t.w)*n,this}equals(t){return t.x===this.x&&t.y===this.y&&t.z===this.z&&t.w===this.w}fromArray(t,e=0){return this.x=t[e],this.y=t[e+1],this.z=t[e+2],this.w=t[e+3],this}toArray(t=[],e=0){return t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t[e+3]=this.w,t}fromBufferAttribute(t,e){return this.x=t.getX(e),this.y=t.getY(e),this.z=t.getZ(e),this.w=t.getW(e),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this.w=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z,yield this.w}}class jr extends or{constructor(t=1,e=1,n={}){super(),n=Object.assign({generateMipmaps:0,internalFormat:null,minFilter:Fe,depthBuffer:1,stencilBuffer:0,resolveDepthBuffer:1,resolveStencilBuffer:1,depthTexture:null,samples:0,count:1,depth:1,multiview:0},n),this.isRenderTarget=1,this.width=t,this.height=e,this.depth=n.depth,this.scissor=new Xr(0,0,t,e),this.scissorTest=0,this.viewport=new Xr(0,0,t,e);const r={width:t,height:e,depth:n.depth},i=new Wr(r);this.textures=[];const a=n.count;for(let t=0;t<a;t++)this.textures[t]=i.clone(),this.textures[t].isRenderTargetTexture=1,this.textures[t].renderTarget=this;this._setTextureOptions(n),this.depthBuffer=n.depthBuffer,this.stencilBuffer=n.stencilBuffer,this.resolveDepthBuffer=n.resolveDepthBuffer,this.resolveStencilBuffer=n.resolveStencilBuffer,this._depthTexture=null,this.depthTexture=n.depthTexture,this.samples=n.samples,this.multiview=n.multiview}_setTextureOptions(t={}){const e={minFilter:Fe,generateMipmaps:0,flipY:0,internalFormat:null};void 0!==t.mapping&&(e.mapping=t.mapping),void 0!==t.wrapS&&(e.wrapS=t.wrapS),void 0!==t.wrapT&&(e.wrapT=t.wrapT),void 0!==t.wrapR&&(e.wrapR=t.wrapR),void 0!==t.magFilter&&(e.magFilter=t.magFilter),void 0!==t.minFilter&&(e.minFilter=t.minFilter),void 0!==t.format&&(e.format=t.format),void 0!==t.type&&(e.type=t.type),void 0!==t.anisotropy&&(e.anisotropy=t.anisotropy),void 0!==t.colorSpace&&(e.colorSpace=t.colorSpace),void 0!==t.flipY&&(e.flipY=t.flipY),void 0!==t.generateMipmaps&&(e.generateMipmaps=t.generateMipmaps),void 0!==t.internalFormat&&(e.internalFormat=t.internalFormat);for(let t=0;t<this.textures.length;t++){this.textures[t].setValues(e)}}get texture(){return this.textures[0]}set texture(t){this.textures[0]=t}set depthTexture(t){null!==this._depthTexture&&(this._depthTexture.renderTarget=null),null!==t&&(t.renderTarget=this),this._depthTexture=t}get depthTexture(){return this._depthTexture}setSize(t,e,n=1){if(this.width!==t||this.height!==e||this.depth!==n){this.width=t,this.height=e,this.depth=n;for(let r=0,i=this.textures.length;r<i;r++)this.textures[r].image.width=t,this.textures[r].image.height=e,this.textures[r].image.depth=n,this.textures[r].isArrayTexture=this.textures[r].image.depth>1;this.dispose()}this.viewport.set(0,0,t,e),this.scissor.set(0,0,t,e)}clone(){return(new this.constructor).copy(this)}copy(t){this.width=t.width,this.height=t.height,this.depth=t.depth,this.scissor.copy(t.scissor),this.scissorTest=t.scissorTest,this.viewport.copy(t.viewport),this.textures.length=0;for(let e=0,n=t.textures.length;e<n;e++){this.textures[e]=t.textures[e].clone(),this.textures[e].isRenderTargetTexture=1,this.textures[e].renderTarget=this;const n=Object.assign({},t.textures[e].image);this.textures[e].source=new zr(n)}return this.depthBuffer=t.depthBuffer,this.stencilBuffer=t.stencilBuffer,this.resolveDepthBuffer=t.resolveDepthBuffer,this.resolveStencilBuffer=t.resolveStencilBuffer,null!==t.depthTexture&&(this.depthTexture=t.depthTexture.clone()),this.samples=t.samples,this}dispose(){this.dispatchEvent({type:"dispose"})}}class qr extends jr{constructor(t=1,e=1,n={}){super(t,e,n),this.isWebGLRenderTarget=1}}class Yr extends Wr{constructor(t=null,e=1,n=1,r=1){super(null),this.isDataArrayTexture=1,this.image={data:t,width:e,height:n,depth:r},this.magFilter=Ie,this.minFilter=Ie,this.wrapR=Ue,this.generateMipmaps=0,this.flipY=0,this.unpackAlignment=1,this.layerUpdates=new Set}addLayerUpdate(t){this.layerUpdates.add(t)}clearLayerUpdates(){this.layerUpdates.clear()}}class Kr extends Wr{constructor(t=null,e=1,n=1,r=1){super(null),this.isData3DTexture=1,this.image={data:t,width:e,height:n,depth:r},this.magFilter=Ie,this.minFilter=Ie,this.wrapR=Ue,this.generateMipmaps=0,this.flipY=0,this.unpackAlignment=1}}class Zr{constructor(t=new br(1/0,1/0,1/0),e=new br(-1/0,-1/0,-1/0)){this.isBox3=1,this.min=t,this.max=e}set(t,e){return this.min.copy(t),this.max.copy(e),this}setFromArray(t){this.makeEmpty();for(let e=0,n=t.length;e<n;e+=3)this.expandByPoint(Jr.fromArray(t,e));return this}setFromBufferAttribute(t){this.makeEmpty();for(let e=0,n=t.count;e<n;e++)this.expandByPoint(Jr.fromBufferAttribute(t,e));return this}setFromPoints(t){this.makeEmpty();for(let e=0,n=t.length;e<n;e++)this.expandByPoint(t[e]);return this}setFromCenterAndSize(t,e){const n=Jr.copy(e).multiplyScalar(.5);return this.min.copy(t).sub(n),this.max.copy(t).add(n),this}setFromObject(t,e=0){return this.makeEmpty(),this.expandByObject(t,e)}clone(){return(new this.constructor).copy(this)}copy(t){return this.min.copy(t.min),this.max.copy(t.max),this}makeEmpty(){return this.min.x=this.min.y=this.min.z=1/0,this.max.x=this.max.y=this.max.z=-1/0,this}isEmpty(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z}getCenter(t){return this.isEmpty()?t.set(0,0,0):t.addVectors(this.min,this.max).multiplyScalar(.5)}getSize(t){return this.isEmpty()?t.set(0,0,0):t.subVectors(this.max,this.min)}expandByPoint(t){return this.min.min(t),this.max.max(t),this}expandByVector(t){return this.min.sub(t),this.max.add(t),this}expandByScalar(t){return this.min.addScalar(-t),this.max.addScalar(t),this}expandByObject(t,e=0){t.updateWorldMatrix(0,0);const n=t.geometry;if(void 0!==n){const r=n.getAttribute("position");if(1==e&&void 0!==r&&1!=t.isInstancedMesh)for(let e=0,n=r.count;e<n;e++)1==t.isMesh?t.getVertexPosition(e,Jr):Jr.fromBufferAttribute(r,e),Jr.applyMatrix4(t.matrixWorld),this.expandByPoint(Jr);else void 0!==t.boundingBox?(null===t.boundingBox&&t.computeBoundingBox(),Qr.copy(t.boundingBox)):(null===n.boundingBox&&n.computeBoundingBox(),Qr.copy(n.boundingBox)),Qr.applyMatrix4(t.matrixWorld),this.union(Qr)}const r=t.children;for(let t=0,n=r.length;t<n;t++)this.expandByObject(r[t],e);return this}containsPoint(t){return t.x>=this.min.x&&t.x<=this.max.x&&t.y>=this.min.y&&t.y<=this.max.y&&t.z>=this.min.z&&t.z<=this.max.z}containsBox(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y&&this.min.z<=t.min.z&&t.max.z<=this.max.z}getParameter(t,e){return e.set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y),(t.z-this.min.z)/(this.max.z-this.min.z))}intersectsBox(t){return t.max.x>=this.min.x&&t.min.x<=this.max.x&&t.max.y>=this.min.y&&t.min.y<=this.max.y&&t.max.z>=this.min.z&&t.min.z<=this.max.z}intersectsSphere(t){return this.clampPoint(t.center,Jr),Jr.distanceToSquared(t.center)<=t.radius*t.radius}intersectsPlane(t){let e,n;return t.normal.x>0?(e=t.normal.x*this.min.x,n=t.normal.x*this.max.x):(e=t.normal.x*this.max.x,n=t.normal.x*this.min.x),t.normal.y>0?(e+=t.normal.y*this.min.y,n+=t.normal.y*this.max.y):(e+=t.normal.y*this.max.y,n+=t.normal.y*this.min.y),t.normal.z>0?(e+=t.normal.z*this.min.z,n+=t.normal.z*this.max.z):(e+=t.normal.z*this.max.z,n+=t.normal.z*this.min.z),e<=-t.constant&&n>=-t.constant}intersectsTriangle(t){if(this.isEmpty())return 0;this.getCenter(si),oi.subVectors(this.max,si),ti.subVectors(t.a,si),ei.subVectors(t.b,si),ni.subVectors(t.c,si),ri.subVectors(ei,ti),ii.subVectors(ni,ei),ai.subVectors(ti,ni);let e=[0,-ri.z,ri.y,0,-ii.z,ii.y,0,-ai.z,ai.y,ri.z,0,-ri.x,ii.z,0,-ii.x,ai.z,0,-ai.x,-ri.y,ri.x,0,-ii.y,ii.x,0,-ai.y,ai.x,0];return hi(e,ti,ei,ni,oi)?(e=[1,0,0,0,1,0,0,0,1],hi(e,ti,ei,ni,oi)?(li.crossVectors(ri,ii),e=[li.x,li.y,li.z],hi(e,ti,ei,ni,oi)):0):0}clampPoint(t,e){return e.copy(t).clamp(this.min,this.max)}distanceToPoint(t){return this.clampPoint(t,Jr).distanceTo(t)}getBoundingSphere(t){return this.isEmpty()?t.makeEmpty():(this.getCenter(t.center),t.radius=.5*this.getSize(Jr).length()),t}intersect(t){return this.min.max(t.min),this.max.min(t.max),this.isEmpty()&&this.makeEmpty(),this}union(t){return this.min.min(t.min),this.max.max(t.max),this}applyMatrix4(t){return this.isEmpty()||($r[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(t),$r[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(t),$r[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(t),$r[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(t),$r[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(t),$r[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(t),$r[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(t),$r[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(t),this.setFromPoints($r)),this}translate(t){return this.min.add(t),this.max.add(t),this}equals(t){return t.min.equals(this.min)&&t.max.equals(this.max)}toJSON(){return{min:this.min.toArray(),max:this.max.toArray()}}fromJSON(t){return this.min.fromArray(t.min),this.max.fromArray(t.max),this}}const $r=[new br,new br,new br,new br,new br,new br,new br,new br],Jr=new br,Qr=new Zr,ti=new br,ei=new br,ni=new br,ri=new br,ii=new br,ai=new br,si=new br,oi=new br,li=new br,ci=new br;function hi(t,e,n,r,i){for(let a=0,s=t.length-3;a<=s;a+=3){ci.fromArray(t,a);const s=i.x*Math.abs(ci.x)+i.y*Math.abs(ci.y)+i.z*Math.abs(ci.z),o=e.dot(ci),l=n.dot(ci),c=r.dot(ci);if(Math.max(-Math.max(o,l,c),Math.min(o,l,c))>s)return 0}return 1}const ui=new Zr,di=new br,pi=new br;class fi{constructor(t=new br,e=-1){this.isSphere=1,this.center=t,this.radius=e}set(t,e){return this.center.copy(t),this.radius=e,this}setFromPoints(t,e){const n=this.center;void 0!==e?n.copy(e):ui.setFromPoints(t).getCenter(n);let r=0;for(let e=0,i=t.length;e<i;e++)r=Math.max(r,n.distanceToSquared(t[e]));return this.radius=Math.sqrt(r),this}copy(t){return this.center.copy(t.center),this.radius=t.radius,this}isEmpty(){return this.radius<0}makeEmpty(){return this.center.set(0,0,0),this.radius=-1,this}containsPoint(t){return t.distanceToSquared(this.center)<=this.radius*this.radius}distanceToPoint(t){return t.distanceTo(this.center)-this.radius}intersectsSphere(t){const e=this.radius+t.radius;return t.center.distanceToSquared(this.center)<=e*e}intersectsBox(t){return t.intersectsSphere(this)}intersectsPlane(t){return Math.abs(t.distanceToPoint(this.center))<=this.radius}clampPoint(t,e){const n=this.center.distanceToSquared(t);return e.copy(t),n>this.radius*this.radius&&(e.sub(this.center).normalize(),e.multiplyScalar(this.radius).add(this.center)),e}getBoundingBox(t){return this.isEmpty()?(t.makeEmpty(),t):(t.set(this.center,this.center),t.expandByScalar(this.radius),t)}applyMatrix4(t){return this.center.applyMatrix4(t),this.radius=this.radius*t.getMaxScaleOnAxis(),this}translate(t){return this.center.add(t),this}expandByPoint(t){if(this.isEmpty())return this.center.copy(t),this.radius=0,this;di.subVectors(t,this.center);const e=di.lengthSq();if(e>this.radius*this.radius){const t=Math.sqrt(e),n=.5*(t-this.radius);this.center.addScaledVector(di,n/t),this.radius+=n}return this}union(t){return t.isEmpty()?this:this.isEmpty()?(this.copy(t),this):(1==this.center.equals(t.center)?this.radius=Math.max(this.radius,t.radius):(pi.subVectors(t.center,this.center).setLength(t.radius),this.expandByPoint(di.copy(t.center).add(pi)),this.expandByPoint(di.copy(t.center).sub(pi))),this)}equals(t){return t.center.equals(this.center)&&t.radius===this.radius}clone(){return(new this.constructor).copy(this)}toJSON(){return{radius:this.radius,center:this.center.toArray()}}fromJSON(t){return this.radius=t.radius,this.center.fromArray(t.center),this}}const mi=new br,gi=new br,vi=new br,xi=new br,_i=new br,yi=new br,bi=new br;class Ei{constructor(t=new br,e=new br(0,0,-1)){this.origin=t,this.direction=e}set(t,e){return this.origin.copy(t),this.direction.copy(e),this}copy(t){return this.origin.copy(t.origin),this.direction.copy(t.direction),this}at(t,e){return e.copy(this.origin).addScaledVector(this.direction,t)}lookAt(t){return this.direction.copy(t).sub(this.origin).normalize(),this}recast(t){return this.origin.copy(this.at(t,mi)),this}closestPointToPoint(t,e){e.subVectors(t,this.origin);const n=e.dot(this.direction);return n<0?e.copy(this.origin):e.copy(this.origin).addScaledVector(this.direction,n)}distanceToPoint(t){return Math.sqrt(this.distanceSqToPoint(t))}distanceSqToPoint(t){const e=mi.subVectors(t,this.origin).dot(this.direction);return e<0?this.origin.distanceToSquared(t):(mi.copy(this.origin).addScaledVector(this.direction,e),mi.distanceToSquared(t))}distanceSqToSegment(t,e,n,r){gi.copy(t).add(e).multiplyScalar(.5),vi.copy(e).sub(t).normalize(),xi.copy(this.origin).sub(gi);const i=.5*t.distanceTo(e),a=-this.direction.dot(vi),s=xi.dot(this.direction),o=-xi.dot(vi),l=xi.lengthSq(),c=Math.abs(1-a*a);let h,u,d,p;if(c>0)if(h=a*o-s,u=a*s-o,p=i*c,h>=0)if(u>=-p)if(u<=p){const t=1/c;h*=t,u*=t,d=h*(h+a*u+2*s)+u*(a*h+u+2*o)+l}else u=i,h=Math.max(0,-(a*u+s)),d=-h*h+u*(u+2*o)+l;else u=-i,h=Math.max(0,-(a*u+s)),d=-h*h+u*(u+2*o)+l;else u<=-p?(h=Math.max(0,-(-a*i+s)),u=h>0?-i:Math.min(Math.max(-i,-o),i),d=-h*h+u*(u+2*o)+l):u<=p?(h=0,u=Math.min(Math.max(-i,-o),i),d=u*(u+2*o)+l):(h=Math.max(0,-(a*i+s)),u=h>0?i:Math.min(Math.max(-i,-o),i),d=-h*h+u*(u+2*o)+l);else u=a>0?-i:i,h=Math.max(0,-(a*u+s)),d=-h*h+u*(u+2*o)+l;return n&&n.copy(this.origin).addScaledVector(this.direction,h),r&&r.copy(gi).addScaledVector(vi,u),d}intersectSphere(t,e){mi.subVectors(t.center,this.origin);const n=mi.dot(this.direction),r=mi.dot(mi)-n*n,i=t.radius*t.radius;if(r>i)return null;const a=Math.sqrt(i-r),s=n-a,o=n+a;return o<0?null:s<0?this.at(o,e):this.at(s,e)}intersectsSphere(t){return t.radius<0?0:this.distanceSqToPoint(t.center)<=t.radius*t.radius}distanceToPlane(t){const e=t.normal.dot(this.direction);if(0===e)return 0===t.distanceToPoint(this.origin)?0:null;const n=-(this.origin.dot(t.normal)+t.constant)/e;return n>=0?n:null}intersectPlane(t,e){const n=this.distanceToPlane(t);return null===n?null:this.at(n,e)}intersectsPlane(t){const e=t.distanceToPoint(this.origin);if(0===e)return 1;return t.normal.dot(this.direction)*e<0?1:0}intersectBox(t,e){let n,r,i,a,s,o;const l=1/this.direction.x,c=1/this.direction.y,h=1/this.direction.z,u=this.origin;return l>=0?(n=(t.min.x-u.x)*l,r=(t.max.x-u.x)*l):(n=(t.max.x-u.x)*l,r=(t.min.x-u.x)*l),c>=0?(i=(t.min.y-u.y)*c,a=(t.max.y-u.y)*c):(i=(t.max.y-u.y)*c,a=(t.min.y-u.y)*c),n>a||i>r?null:((i>n||isNaN(n))&&(n=i),(a<r||isNaN(r))&&(r=a),h>=0?(s=(t.min.z-u.z)*h,o=(t.max.z-u.z)*h):(s=(t.max.z-u.z)*h,o=(t.min.z-u.z)*h),n>o||s>r?null:((s>n||n!=n)&&(n=s),(o<r||r!=r)&&(r=o),r<0?null:this.at(n>=0?n:r,e)))}intersectsBox(t){return null!==this.intersectBox(t,mi)}intersectTriangle(t,e,n,r,i){_i.subVectors(e,t),yi.subVectors(n,t),bi.crossVectors(_i,yi);let a,s=this.direction.dot(bi);if(s>0){if(r)return null;a=1}else{if(!(s<0))return null;a=-1,s=-s}xi.subVectors(this.origin,t);const o=a*this.direction.dot(yi.crossVectors(xi,yi));if(o<0)return null;const l=a*this.direction.dot(_i.cross(xi));if(l<0)return null;if(o+l>s)return null;const c=-a*xi.dot(bi);return c<0?null:this.at(c/s,i)}applyMatrix4(t){return this.origin.applyMatrix4(t),this.direction.transformDirection(t),this}equals(t){return t.origin.equals(this.origin)&&t.direction.equals(this.direction)}clone(){return(new this.constructor).copy(this)}}class Ti{constructor(t,e,n,r,i,a,s,o,l,c,h,u,d,p,f,m){Ti.prototype.isMatrix4=1,this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1],void 0!==t&&this.set(t,e,n,r,i,a,s,o,l,c,h,u,d,p,f,m)}set(t,e,n,r,i,a,s,o,l,c,h,u,d,p,f,m){const g=this.elements;return g[0]=t,g[4]=e,g[8]=n,g[12]=r,g[1]=i,g[5]=a,g[9]=s,g[13]=o,g[2]=l,g[6]=c,g[10]=h,g[14]=u,g[3]=d,g[7]=p,g[11]=f,g[15]=m,this}identity(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this}clone(){return(new Ti).fromArray(this.elements)}copy(t){const e=this.elements,n=t.elements;return e[0]=n[0],e[1]=n[1],e[2]=n[2],e[3]=n[3],e[4]=n[4],e[5]=n[5],e[6]=n[6],e[7]=n[7],e[8]=n[8],e[9]=n[9],e[10]=n[10],e[11]=n[11],e[12]=n[12],e[13]=n[13],e[14]=n[14],e[15]=n[15],this}copyPosition(t){const e=this.elements,n=t.elements;return e[12]=n[12],e[13]=n[13],e[14]=n[14],this}setFromMatrix3(t){const e=t.elements;return this.set(e[0],e[3],e[6],0,e[1],e[4],e[7],0,e[2],e[5],e[8],0,0,0,0,1),this}extractBasis(t,e,n){return t.setFromMatrixColumn(this,0),e.setFromMatrixColumn(this,1),n.setFromMatrixColumn(this,2),this}makeBasis(t,e,n){return this.set(t.x,e.x,n.x,0,t.y,e.y,n.y,0,t.z,e.z,n.z,0,0,0,0,1),this}extractRotation(t){const e=this.elements,n=t.elements,r=1/Si.setFromMatrixColumn(t,0).length(),i=1/Si.setFromMatrixColumn(t,1).length(),a=1/Si.setFromMatrixColumn(t,2).length();return e[0]=n[0]*r,e[1]=n[1]*r,e[2]=n[2]*r,e[3]=0,e[4]=n[4]*i,e[5]=n[5]*i,e[6]=n[6]*i,e[7]=0,e[8]=n[8]*a,e[9]=n[9]*a,e[10]=n[10]*a,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this}makeRotationFromEuler(t){const e=this.elements,n=t.x,r=t.y,i=t.z,a=Math.cos(n),s=Math.sin(n),o=Math.cos(r),l=Math.sin(r),c=Math.cos(i),h=Math.sin(i);if("XYZ"===t.order){const t=a*c,n=a*h,r=s*c,i=s*h;e[0]=o*c,e[4]=-o*h,e[8]=l,e[1]=n+r*l,e[5]=t-i*l,e[9]=-s*o,e[2]=i-t*l,e[6]=r+n*l,e[10]=a*o}else if("YXZ"===t.order){const t=o*c,n=o*h,r=l*c,i=l*h;e[0]=t+i*s,e[4]=r*s-n,e[8]=a*l,e[1]=a*h,e[5]=a*c,e[9]=-s,e[2]=n*s-r,e[6]=i+t*s,e[10]=a*o}else if("ZXY"===t.order){const t=o*c,n=o*h,r=l*c,i=l*h;e[0]=t-i*s,e[4]=-a*h,e[8]=r+n*s,e[1]=n+r*s,e[5]=a*c,e[9]=i-t*s,e[2]=-a*l,e[6]=s,e[10]=a*o}else if("ZYX"===t.order){const t=a*c,n=a*h,r=s*c,i=s*h;e[0]=o*c,e[4]=r*l-n,e[8]=t*l+i,e[1]=o*h,e[5]=i*l+t,e[9]=n*l-r,e[2]=-l,e[6]=s*o,e[10]=a*o}else if("YZX"===t.order){const t=a*o,n=a*l,r=s*o,i=s*l;e[0]=o*c,e[4]=i-t*h,e[8]=r*h+n,e[1]=h,e[5]=a*c,e[9]=-s*c,e[2]=-l*c,e[6]=n*h+r,e[10]=t-i*h}else if("XZY"===t.order){const t=a*o,n=a*l,r=s*o,i=s*l;e[0]=o*c,e[4]=-h,e[8]=l*c,e[1]=t*h+i,e[5]=a*c,e[9]=n*h-r,e[2]=r*h-n,e[6]=s*c,e[10]=i*h+t}return e[3]=0,e[7]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this}makeRotationFromQuaternion(t){return this.compose(wi,t,Ri)}lookAt(t,e,n){const r=this.elements;return Pi.subVectors(t,e),0===Pi.lengthSq()&&(Pi.z=1),Pi.normalize(),Ai.crossVectors(n,Pi),0===Ai.lengthSq()&&(1===Math.abs(n.z)?Pi.x+=1e-4:Pi.z+=1e-4,Pi.normalize(),Ai.crossVectors(n,Pi)),Ai.normalize(),Ci.crossVectors(Pi,Ai),r[0]=Ai.x,r[4]=Ci.x,r[8]=Pi.x,r[1]=Ai.y,r[5]=Ci.y,r[9]=Pi.y,r[2]=Ai.z,r[6]=Ci.z,r[10]=Pi.z,this}multiply(t){return this.multiplyMatrices(this,t)}premultiply(t){return this.multiplyMatrices(t,this)}multiplyMatrices(t,e){const n=t.elements,r=e.elements,i=this.elements,a=n[0],s=n[4],o=n[8],l=n[12],c=n[1],h=n[5],u=n[9],d=n[13],p=n[2],f=n[6],m=n[10],g=n[14],v=n[3],x=n[7],_=n[11],y=n[15],b=r[0],E=r[4],T=r[8],S=r[12],M=r[1],w=r[5],R=r[9],A=r[13],C=r[2],P=r[6],D=r[10],U=r[14],L=r[3],I=r[7],N=r[11],O=r[15];return i[0]=a*b+s*M+o*C+l*L,i[4]=a*E+s*w+o*P+l*I,i[8]=a*T+s*R+o*D+l*N,i[12]=a*S+s*A+o*U+l*O,i[1]=c*b+h*M+u*C+d*L,i[5]=c*E+h*w+u*P+d*I,i[9]=c*T+h*R+u*D+d*N,i[13]=c*S+h*A+u*U+d*O,i[2]=p*b+f*M+m*C+g*L,i[6]=p*E+f*w+m*P+g*I,i[10]=p*T+f*R+m*D+g*N,i[14]=p*S+f*A+m*U+g*O,i[3]=v*b+x*M+_*C+y*L,i[7]=v*E+x*w+_*P+y*I,i[11]=v*T+x*R+_*D+y*N,i[15]=v*S+x*A+_*U+y*O,this}multiplyScalar(t){const e=this.elements;return e[0]*=t,e[4]*=t,e[8]*=t,e[12]*=t,e[1]*=t,e[5]*=t,e[9]*=t,e[13]*=t,e[2]*=t,e[6]*=t,e[10]*=t,e[14]*=t,e[3]*=t,e[7]*=t,e[11]*=t,e[15]*=t,this}determinant(){const t=this.elements,e=t[0],n=t[4],r=t[8],i=t[12],a=t[1],s=t[5],o=t[9],l=t[13],c=t[2],h=t[6],u=t[10],d=t[14];return t[3]*(+i*o*h-r*l*h-i*s*u+n*l*u+r*s*d-n*o*d)+t[7]*(+e*o*d-e*l*u+i*a*u-r*a*d+r*l*c-i*o*c)+t[11]*(+e*l*h-e*s*d-i*a*h+n*a*d+i*s*c-n*l*c)+t[15]*(-r*s*c-e*o*h+e*s*u+r*a*h-n*a*u+n*o*c)}transpose(){const t=this.elements;let e;return e=t[1],t[1]=t[4],t[4]=e,e=t[2],t[2]=t[8],t[8]=e,e=t[6],t[6]=t[9],t[9]=e,e=t[3],t[3]=t[12],t[12]=e,e=t[7],t[7]=t[13],t[13]=e,e=t[11],t[11]=t[14],t[14]=e,this}setPosition(t,e,n){const r=this.elements;return t.isVector3?(r[12]=t.x,r[13]=t.y,r[14]=t.z):(r[12]=t,r[13]=e,r[14]=n),this}invert(){const t=this.elements,e=t[0],n=t[1],r=t[2],i=t[3],a=t[4],s=t[5],o=t[6],l=t[7],c=t[8],h=t[9],u=t[10],d=t[11],p=t[12],f=t[13],m=t[14],g=t[15],v=h*m*l-f*u*l+f*o*d-s*m*d-h*o*g+s*u*g,x=p*u*l-c*m*l-p*o*d+a*m*d+c*o*g-a*u*g,_=c*f*l-p*h*l+p*s*d-a*f*d-c*s*g+a*h*g,y=p*h*o-c*f*o-p*s*u+a*f*u+c*s*m-a*h*m,b=e*v+n*x+r*_+i*y;if(0===b)return this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);const E=1/b;return t[0]=v*E,t[1]=(f*u*i-h*m*i-f*r*d+n*m*d+h*r*g-n*u*g)*E,t[2]=(s*m*i-f*o*i+f*r*l-n*m*l-s*r*g+n*o*g)*E,t[3]=(h*o*i-s*u*i-h*r*l+n*u*l+s*r*d-n*o*d)*E,t[4]=x*E,t[5]=(c*m*i-p*u*i+p*r*d-e*m*d-c*r*g+e*u*g)*E,t[6]=(p*o*i-a*m*i-p*r*l+e*m*l+a*r*g-e*o*g)*E,t[7]=(a*u*i-c*o*i+c*r*l-e*u*l-a*r*d+e*o*d)*E,t[8]=_*E,t[9]=(p*h*i-c*f*i-p*n*d+e*f*d+c*n*g-e*h*g)*E,t[10]=(a*f*i-p*s*i+p*n*l-e*f*l-a*n*g+e*s*g)*E,t[11]=(c*s*i-a*h*i-c*n*l+e*h*l+a*n*d-e*s*d)*E,t[12]=y*E,t[13]=(c*f*r-p*h*r+p*n*u-e*f*u-c*n*m+e*h*m)*E,t[14]=(p*s*r-a*f*r-p*n*o+e*f*o+a*n*m-e*s*m)*E,t[15]=(a*h*r-c*s*r+c*n*o-e*h*o-a*n*u+e*s*u)*E,this}scale(t){const e=this.elements,n=t.x,r=t.y,i=t.z;return e[0]*=n,e[4]*=r,e[8]*=i,e[1]*=n,e[5]*=r,e[9]*=i,e[2]*=n,e[6]*=r,e[10]*=i,e[3]*=n,e[7]*=r,e[11]*=i,this}getMaxScaleOnAxis(){const t=this.elements,e=t[0]*t[0]+t[1]*t[1]+t[2]*t[2],n=t[4]*t[4]+t[5]*t[5]+t[6]*t[6],r=t[8]*t[8]+t[9]*t[9]+t[10]*t[10];return Math.sqrt(Math.max(e,n,r))}makeTranslation(t,e,n){return t.isVector3?this.set(1,0,0,t.x,0,1,0,t.y,0,0,1,t.z,0,0,0,1):this.set(1,0,0,t,0,1,0,e,0,0,1,n,0,0,0,1),this}makeRotationX(t){const e=Math.cos(t),n=Math.sin(t);return this.set(1,0,0,0,0,e,-n,0,0,n,e,0,0,0,0,1),this}makeRotationY(t){const e=Math.cos(t),n=Math.sin(t);return this.set(e,0,n,0,0,1,0,0,-n,0,e,0,0,0,0,1),this}makeRotationZ(t){const e=Math.cos(t),n=Math.sin(t);return this.set(e,-n,0,0,n,e,0,0,0,0,1,0,0,0,0,1),this}makeRotationAxis(t,e){const n=Math.cos(e),r=Math.sin(e),i=1-n,a=t.x,s=t.y,o=t.z,l=i*a,c=i*s;return this.set(l*a+n,l*s-r*o,l*o+r*s,0,l*s+r*o,c*s+n,c*o-r*a,0,l*o-r*s,c*o+r*a,i*o*o+n,0,0,0,0,1),this}makeScale(t,e,n){return this.set(t,0,0,0,0,e,0,0,0,0,n,0,0,0,0,1),this}makeShear(t,e,n,r,i,a){return this.set(1,n,i,0,t,1,a,0,e,r,1,0,0,0,0,1),this}compose(t,e,n){const r=this.elements,i=e._x,a=e._y,s=e._z,o=e._w,l=i+i,c=a+a,h=s+s,u=i*l,d=i*c,p=i*h,f=a*c,m=a*h,g=s*h,v=o*l,x=o*c,_=o*h,y=n.x,b=n.y,E=n.z;return r[0]=(1-(f+g))*y,r[1]=(d+_)*y,r[2]=(p-x)*y,r[3]=0,r[4]=(d-_)*b,r[5]=(1-(u+g))*b,r[6]=(m+v)*b,r[7]=0,r[8]=(p+x)*E,r[9]=(m-v)*E,r[10]=(1-(u+f))*E,r[11]=0,r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=1,this}decompose(t,e,n){const r=this.elements;let i=Si.set(r[0],r[1],r[2]).length();const a=Si.set(r[4],r[5],r[6]).length(),s=Si.set(r[8],r[9],r[10]).length();this.determinant()<0&&(i=-i),t.x=r[12],t.y=r[13],t.z=r[14],Mi.copy(this);const o=1/i,l=1/a,c=1/s;return Mi.elements[0]*=o,Mi.elements[1]*=o,Mi.elements[2]*=o,Mi.elements[4]*=l,Mi.elements[5]*=l,Mi.elements[6]*=l,Mi.elements[8]*=c,Mi.elements[9]*=c,Mi.elements[10]*=c,e.setFromRotationMatrix(Mi),n.x=i,n.y=a,n.z=s,this}makePerspective(t,e,n,r,i,a,s=2e3,o=0){const l=this.elements,c=2*i/(e-t),h=2*i/(n-r),u=(e+t)/(e-t),d=(n+r)/(n-r);let p,f;if(o)p=i/(a-i),f=a*i/(a-i);else if(s===ar)p=-(a+i)/(a-i),f=-2*a*i/(a-i);else{if(s!==sr)throw new Error("THREE.Matrix4.makePerspective(): Invalid coordinate system: "+s);p=-a/(a-i),f=-a*i/(a-i)}return l[0]=c,l[4]=0,l[8]=u,l[12]=0,l[1]=0,l[5]=h,l[9]=d,l[13]=0,l[2]=0,l[6]=0,l[10]=p,l[14]=f,l[3]=0,l[7]=0,l[11]=-1,l[15]=0,this}makeOrthographic(t,e,n,r,i,a,s=2e3,o=0){const l=this.elements,c=2/(e-t),h=2/(n-r),u=-(e+t)/(e-t),d=-(n+r)/(n-r);let p,f;if(o)p=1/(a-i),f=a/(a-i);else if(s===ar)p=-2/(a-i),f=-(a+i)/(a-i);else{if(s!==sr)throw new Error("THREE.Matrix4.makeOrthographic(): Invalid coordinate system: "+s);p=-1/(a-i),f=-i/(a-i)}return l[0]=c,l[4]=0,l[8]=0,l[12]=u,l[1]=0,l[5]=h,l[9]=0,l[13]=d,l[2]=0,l[6]=0,l[10]=p,l[14]=f,l[3]=0,l[7]=0,l[11]=0,l[15]=1,this}equals(t){const e=this.elements,n=t.elements;for(let t=0;t<16;t++)if(e[t]!==n[t])return 0;return 1}fromArray(t,e=0){for(let n=0;n<16;n++)this.elements[n]=t[n+e];return this}toArray(t=[],e=0){const n=this.elements;return t[e]=n[0],t[e+1]=n[1],t[e+2]=n[2],t[e+3]=n[3],t[e+4]=n[4],t[e+5]=n[5],t[e+6]=n[6],t[e+7]=n[7],t[e+8]=n[8],t[e+9]=n[9],t[e+10]=n[10],t[e+11]=n[11],t[e+12]=n[12],t[e+13]=n[13],t[e+14]=n[14],t[e+15]=n[15],t}}const Si=new br,Mi=new Ti,wi=new br(0,0,0),Ri=new br(1,1,1),Ai=new br,Ci=new br,Pi=new br,Di=new Ti,Ui=new yr;class Li{constructor(t=0,e=0,n=0,r=Li.DEFAULT_ORDER){this.isEuler=1,this._x=t,this._y=e,this._z=n,this._order=r}get x(){return this._x}set x(t){this._x=t,this._onChangeCallback()}get y(){return this._y}set y(t){this._y=t,this._onChangeCallback()}get z(){return this._z}set z(t){this._z=t,this._onChangeCallback()}get order(){return this._order}set order(t){this._order=t,this._onChangeCallback()}set(t,e,n,r=this._order){return this._x=t,this._y=e,this._z=n,this._order=r,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._order)}copy(t){return this._x=t._x,this._y=t._y,this._z=t._z,this._order=t._order,this._onChangeCallback(),this}setFromRotationMatrix(t,e=this._order,n=1){const r=t.elements,i=r[0],a=r[4],s=r[8],o=r[1],l=r[5],c=r[9],h=r[2],u=r[6],d=r[10];switch(e){case"XYZ":this._y=Math.asin(pr(s,-1,1)),Math.abs(s)<.9999999?(this._x=Math.atan2(-c,d),this._z=Math.atan2(-a,i)):(this._x=Math.atan2(u,l),this._z=0);break;case"YXZ":this._x=Math.asin(-pr(c,-1,1)),Math.abs(c)<.9999999?(this._y=Math.atan2(s,d),this._z=Math.atan2(o,l)):(this._y=Math.atan2(-h,i),this._z=0);break;case"ZXY":this._x=Math.asin(pr(u,-1,1)),Math.abs(u)<.9999999?(this._y=Math.atan2(-h,d),this._z=Math.atan2(-a,l)):(this._y=0,this._z=Math.atan2(o,i));break;case"ZYX":this._y=Math.asin(-pr(h,-1,1)),Math.abs(h)<.9999999?(this._x=Math.atan2(u,d),this._z=Math.atan2(o,i)):(this._x=0,this._z=Math.atan2(-a,l));break;case"YZX":this._z=Math.asin(pr(o,-1,1)),Math.abs(o)<.9999999?(this._x=Math.atan2(-c,l),this._y=Math.atan2(-h,i)):(this._x=0,this._y=Math.atan2(s,d));break;case"XZY":this._z=Math.asin(-pr(a,-1,1)),Math.abs(a)<.9999999?(this._x=Math.atan2(u,l),this._y=Math.atan2(s,i)):(this._x=Math.atan2(-c,d),this._y=0)}return this._order=e,1==n&&this._onChangeCallback(),this}setFromQuaternion(t,e,n){return Di.makeRotationFromQuaternion(t),this.setFromRotationMatrix(Di,e,n)}setFromVector3(t,e=this._order){return this.set(t.x,t.y,t.z,e)}reorder(t){return Ui.setFromEuler(this),this.setFromQuaternion(Ui,t)}equals(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._order===this._order}fromArray(t){return this._x=t[0],this._y=t[1],this._z=t[2],void 0!==t[3]&&(this._order=t[3]),this._onChangeCallback(),this}toArray(t=[],e=0){return t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._order,t}_onChange(t){return this._onChangeCallback=t,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._order}}Li.DEFAULT_ORDER="XYZ";class Ii{constructor(){this.mask=1}set(t){this.mask=1<<t>>>0}enable(t){this.mask|=1<<t}enableAll(){this.mask=-1}toggle(t){this.mask^=1<<t}disable(t){this.mask&=~(1<<t)}disableAll(){this.mask=0}test(t){return 0!==(this.mask&t.mask)}isEnabled(t){return!!(this.mask&1<<t)}}let Ni=0;const Oi=new br,Fi=new yr,Bi=new Ti,ki=new br,zi=new br,Vi=new br,Hi=new yr,Gi=new br(1,0,0),Wi=new br(0,1,0),Xi=new br(0,0,1),ji={type:"added"},qi={type:"removed"},Yi={type:"childadded",child:null},Ki={type:"childremoved",child:null};class Zi extends or{constructor(){super(),this.isObject3D=1,Object.defineProperty(this,"id",{value:Ni++}),this.uuid=dr(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=Zi.DEFAULT_UP.clone();const t=new br,e=new Li,n=new yr,r=new br(1,1,1);e._onChange(function(){n.setFromEuler(e,0)}),n._onChange(function(){e.setFromQuaternion(n,void 0,0)}),Object.defineProperties(this,{position:{configurable:1,enumerable:1,value:t},rotation:{configurable:1,enumerable:1,value:e},quaternion:{configurable:1,enumerable:1,value:n},scale:{configurable:1,enumerable:1,value:r},modelViewMatrix:{value:new Ti},normalMatrix:{value:new Sr}}),this.matrix=new Ti,this.matrixWorld=new Ti,this.matrixAutoUpdate=Zi.DEFAULT_MATRIX_AUTO_UPDATE,this.matrixWorldAutoUpdate=Zi.DEFAULT_MATRIX_WORLD_AUTO_UPDATE,this.matrixWorldNeedsUpdate=0,this.layers=new Ii,this.visible=1,this.castShadow=0,this.receiveShadow=0,this.frustumCulled=1,this.renderOrder=0,this.animations=[],this.customDepthMaterial=void 0,this.customDistanceMaterial=void 0,this.userData={}}onBeforeShadow(){}onAfterShadow(){}onBeforeRender(){}onAfterRender(){}applyMatrix4(t){this.matrixAutoUpdate&&this.updateMatrix(),this.matrix.premultiply(t),this.matrix.decompose(this.position,this.quaternion,this.scale)}applyQuaternion(t){return this.quaternion.premultiply(t),this}setRotationFromAxisAngle(t,e){this.quaternion.setFromAxisAngle(t,e)}setRotationFromEuler(t){this.quaternion.setFromEuler(t,1)}setRotationFromMatrix(t){this.quaternion.setFromRotationMatrix(t)}setRotationFromQuaternion(t){this.quaternion.copy(t)}rotateOnAxis(t,e){return Fi.setFromAxisAngle(t,e),this.quaternion.multiply(Fi),this}rotateOnWorldAxis(t,e){return Fi.setFromAxisAngle(t,e),this.quaternion.premultiply(Fi),this}rotateX(t){return this.rotateOnAxis(Gi,t)}rotateY(t){return this.rotateOnAxis(Wi,t)}rotateZ(t){return this.rotateOnAxis(Xi,t)}translateOnAxis(t,e){return Oi.copy(t).applyQuaternion(this.quaternion),this.position.add(Oi.multiplyScalar(e)),this}translateX(t){return this.translateOnAxis(Gi,t)}translateY(t){return this.translateOnAxis(Wi,t)}translateZ(t){return this.translateOnAxis(Xi,t)}localToWorld(t){return this.updateWorldMatrix(1,0),t.applyMatrix4(this.matrixWorld)}worldToLocal(t){return this.updateWorldMatrix(1,0),t.applyMatrix4(Bi.copy(this.matrixWorld).invert())}lookAt(t,e,n){t.isVector3?ki.copy(t):ki.set(t,e,n);const r=this.parent;this.updateWorldMatrix(1,0),zi.setFromMatrixPosition(this.matrixWorld),this.isCamera||this.isLight?Bi.lookAt(zi,ki,this.up):Bi.lookAt(ki,zi,this.up),this.quaternion.setFromRotationMatrix(Bi),r&&(Bi.extractRotation(r.matrixWorld),Fi.setFromRotationMatrix(Bi),this.quaternion.premultiply(Fi.invert()))}add(t){if(arguments.length>1){for(let t=0;t<arguments.length;t++)this.add(arguments[t]);return this}return t===this||t&&t.isObject3D&&(t.removeFromParent(),t.parent=this,this.children.push(t),t.dispatchEvent(ji),Yi.child=t,this.dispatchEvent(Yi),Yi.child=null),this}remove(t){if(arguments.length>1){for(let t=0;t<arguments.length;t++)this.remove(arguments[t]);return this}const e=this.children.indexOf(t);return-1!==e&&(t.parent=null,this.children.splice(e,1),t.dispatchEvent(qi),Ki.child=t,this.dispatchEvent(Ki),Ki.child=null),this}removeFromParent(){const t=this.parent;return null!==t&&t.remove(this),this}clear(){return this.remove(...this.children)}attach(t){return this.updateWorldMatrix(1,0),Bi.copy(this.matrixWorld).invert(),null!==t.parent&&(t.parent.updateWorldMatrix(1,0),Bi.multiply(t.parent.matrixWorld)),t.applyMatrix4(Bi),t.removeFromParent(),t.parent=this,this.children.push(t),t.updateWorldMatrix(0,1),t.dispatchEvent(ji),Yi.child=t,this.dispatchEvent(Yi),Yi.child=null,this}getObjectById(t){return this.getObjectByProperty("id",t)}getObjectByName(t){return this.getObjectByProperty("name",t)}getObjectByProperty(t,e){if(this[t]===e)return this;for(let n=0,r=this.children.length;n<r;n++){const r=this.children[n].getObjectByProperty(t,e);if(void 0!==r)return r}}getObjectsByProperty(t,e,n=[]){this[t]===e&&n.push(this);const r=this.children;for(let i=0,a=r.length;i<a;i++)r[i].getObjectsByProperty(t,e,n);return n}getWorldPosition(t){return this.updateWorldMatrix(1,0),t.setFromMatrixPosition(this.matrixWorld)}getWorldQuaternion(t){return this.updateWorldMatrix(1,0),this.matrixWorld.decompose(zi,t,Vi),t}getWorldScale(t){return this.updateWorldMatrix(1,0),this.matrixWorld.decompose(zi,Hi,t),t}getWorldDirection(t){this.updateWorldMatrix(1,0);const e=this.matrixWorld.elements;return t.set(e[8],e[9],e[10]).normalize()}raycast(){}traverse(t){t(this);const e=this.children;for(let n=0,r=e.length;n<r;n++)e[n].traverse(t)}traverseVisible(t){if(0==this.visible)return;t(this);const e=this.children;for(let n=0,r=e.length;n<r;n++)e[n].traverseVisible(t)}traverseAncestors(t){const e=this.parent;null!==e&&(t(e),e.traverseAncestors(t))}updateMatrix(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=1}updateMatrixWorld(t){this.matrixAutoUpdate&&this.updateMatrix(),(this.matrixWorldNeedsUpdate||t)&&(1==this.matrixWorldAutoUpdate&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix)),this.matrixWorldNeedsUpdate=0,t=1);const e=this.children;for(let n=0,r=e.length;n<r;n++){e[n].updateMatrixWorld(t)}}updateWorldMatrix(t,e){const n=this.parent;if(1==t&&null!==n&&n.updateWorldMatrix(1,0),this.matrixAutoUpdate&&this.updateMatrix(),1==this.matrixWorldAutoUpdate&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix)),1==e){const t=this.children;for(let e=0,n=t.length;e<n;e++){t[e].updateWorldMatrix(0,1)}}}toJSON(t){const e=void 0===t||"string"==typeof t,n={};e&&(t={geometries:{},materials:{},textures:{},images:{},shapes:{},skeletons:{},animations:{},nodes:{}},n.metadata={version:4.7,type:"Object",generator:"Object3D.toJSON"});const r={};function i(e,n){return void 0===e[n.uuid]&&(e[n.uuid]=n.toJSON(t)),n.uuid}if(r.uuid=this.uuid,r.type=this.type,""!==this.name&&(r.name=this.name),1==this.castShadow&&(r.castShadow=1),1==this.receiveShadow&&(r.receiveShadow=1),0==this.visible&&(r.visible=0),0==this.frustumCulled&&(r.frustumCulled=0),0!==this.renderOrder&&(r.renderOrder=this.renderOrder),Object.keys(this.userData).length>0&&(r.userData=this.userData),r.layers=this.layers.mask,r.matrix=this.matrix.toArray(),r.up=this.up.toArray(),0==this.matrixAutoUpdate&&(r.matrixAutoUpdate=0),this.isInstancedMesh&&(r.type="InstancedMesh",r.count=this.count,r.instanceMatrix=this.instanceMatrix.toJSON(),null!==this.instanceColor&&(r.instanceColor=this.instanceColor.toJSON())),this.isBatchedMesh&&(r.type="BatchedMesh",r.perObjectFrustumCulled=this.perObjectFrustumCulled,r.sortObjects=this.sortObjects,r.drawRanges=this._drawRanges,r.reservedRanges=this._reservedRanges,r.geometryInfo=this._geometryInfo.map(t=>({...t,boundingBox:t.boundingBox?t.boundingBox.toJSON():void 0,boundingSphere:t.boundingSphere?t.boundingSphere.toJSON():void 0})),r.instanceInfo=this._instanceInfo.map(t=>({...t})),r.availableInstanceIds=this._availableInstanceIds.slice(),r.availableGeometryIds=this._availableGeometryIds.slice(),r.nextIndexStart=this._nextIndexStart,r.nextVertexStart=this._nextVertexStart,r.geometryCount=this._geometryCount,r.maxInstanceCount=this._maxInstanceCount,r.maxVertexCount=this._maxVertexCount,r.maxIndexCount=this._maxIndexCount,r.geometryInitialized=this._geometryInitialized,r.matricesTexture=this._matricesTexture.toJSON(t),r.indirectTexture=this._indirectTexture.toJSON(t),null!==this._colorsTexture&&(r.colorsTexture=this._colorsTexture.toJSON(t)),null!==this.boundingSphere&&(r.boundingSphere=this.boundingSphere.toJSON()),null!==this.boundingBox&&(r.boundingBox=this.boundingBox.toJSON())),this.isScene)this.background&&(this.background.isColor?r.background=this.background.toJSON():this.background.isTexture&&(r.background=this.background.toJSON(t).uuid)),this.environment&&this.environment.isTexture&&1!=this.environment.isRenderTargetTexture&&(r.environment=this.environment.toJSON(t).uuid);else if(this.isMesh||this.isLine||this.isPoints){r.geometry=i(t.geometries,this.geometry);const e=this.geometry.parameters;if(void 0!==e&&void 0!==e.shapes){const n=e.shapes;if(Array.isArray(n))for(let e=0,r=n.length;e<r;e++){const r=n[e];i(t.shapes,r)}else i(t.shapes,n)}}if(this.isSkinnedMesh&&(r.bindMode=this.bindMode,r.bindMatrix=this.bindMatrix.toArray(),void 0!==this.skeleton&&(i(t.skeletons,this.skeleton),r.skeleton=this.skeleton.uuid)),void 0!==this.material)if(Array.isArray(this.material)){const e=[];for(let n=0,r=this.material.length;n<r;n++)e.push(i(t.materials,this.material[n]));r.material=e}else r.material=i(t.materials,this.material);if(this.children.length>0){r.children=[];for(let e=0;e<this.children.length;e++)r.children.push(this.children[e].toJSON(t).object)}if(this.animations.length>0){r.animations=[];for(let e=0;e<this.animations.length;e++){const n=this.animations[e];r.animations.push(i(t.animations,n))}}if(e){const e=a(t.geometries),r=a(t.materials),i=a(t.textures),s=a(t.images),o=a(t.shapes),l=a(t.skeletons),c=a(t.animations),h=a(t.nodes);e.length>0&&(n.geometries=e),r.length>0&&(n.materials=r),i.length>0&&(n.textures=i),s.length>0&&(n.images=s),o.length>0&&(n.shapes=o),l.length>0&&(n.skeletons=l),c.length>0&&(n.animations=c),h.length>0&&(n.nodes=h)}return n.object=r,n;function a(t){const e=[];for(const n in t){const r=t[n];delete r.metadata,e.push(r)}return e}}clone(t){return(new this.constructor).copy(this,t)}copy(t,e=1){if(this.name=t.name,this.up.copy(t.up),this.position.copy(t.position),this.rotation.order=t.rotation.order,this.quaternion.copy(t.quaternion),this.scale.copy(t.scale),this.matrix.copy(t.matrix),this.matrixWorld.copy(t.matrixWorld),this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrixWorldAutoUpdate=t.matrixWorldAutoUpdate,this.matrixWorldNeedsUpdate=t.matrixWorldNeedsUpdate,this.layers.mask=t.layers.mask,this.visible=t.visible,this.castShadow=t.castShadow,this.receiveShadow=t.receiveShadow,this.frustumCulled=t.frustumCulled,this.renderOrder=t.renderOrder,this.animations=t.animations.slice(),this.userData=JSON.parse(JSON.stringify(t.userData)),1==e)for(let e=0;e<t.children.length;e++){const n=t.children[e];this.add(n.clone())}return this}}Zi.DEFAULT_UP=new br(0,1,0),Zi.DEFAULT_MATRIX_AUTO_UPDATE=1,Zi.DEFAULT_MATRIX_WORLD_AUTO_UPDATE=1;const $i=new br,Ji=new br,Qi=new br,ta=new br,ea=new br,na=new br,ra=new br,ia=new br,aa=new br,sa=new br,oa=new Xr,la=new Xr,ca=new Xr;class ha{constructor(t=new br,e=new br,n=new br){this.a=t,this.b=e,this.c=n}static getNormal(t,e,n,r){r.subVectors(n,e),$i.subVectors(t,e),r.cross($i);const i=r.lengthSq();return i>0?r.multiplyScalar(1/Math.sqrt(i)):r.set(0,0,0)}static getBarycoord(t,e,n,r,i){$i.subVectors(r,e),Ji.subVectors(n,e),Qi.subVectors(t,e);const a=$i.dot($i),s=$i.dot(Ji),o=$i.dot(Qi),l=Ji.dot(Ji),c=Ji.dot(Qi),h=a*l-s*s;if(0===h)return i.set(0,0,0),null;const u=1/h,d=(l*o-s*c)*u,p=(a*c-s*o)*u;return i.set(1-d-p,p,d)}static containsPoint(t,e,n,r){return null===this.getBarycoord(t,e,n,r,ta)?0:ta.x>=0&&ta.y>=0&&ta.x+ta.y<=1}static getInterpolation(t,e,n,r,i,a,s,o){return null===this.getBarycoord(t,e,n,r,ta)?(o.x=0,o.y=0,"z"in o&&(o.z=0),"w"in o&&(o.w=0),null):(o.setScalar(0),o.addScaledVector(i,ta.x),o.addScaledVector(a,ta.y),o.addScaledVector(s,ta.z),o)}static getInterpolatedAttribute(t,e,n,r,i,a){return oa.setScalar(0),la.setScalar(0),ca.setScalar(0),oa.fromBufferAttribute(t,e),la.fromBufferAttribute(t,n),ca.fromBufferAttribute(t,r),a.setScalar(0),a.addScaledVector(oa,i.x),a.addScaledVector(la,i.y),a.addScaledVector(ca,i.z),a}static isFrontFacing(t,e,n,r){return $i.subVectors(n,e),Ji.subVectors(t,e),$i.cross(Ji).dot(r)<0?1:0}set(t,e,n){return this.a.copy(t),this.b.copy(e),this.c.copy(n),this}setFromPointsAndIndices(t,e,n,r){return this.a.copy(t[e]),this.b.copy(t[n]),this.c.copy(t[r]),this}setFromAttributeAndIndices(t,e,n,r){return this.a.fromBufferAttribute(t,e),this.b.fromBufferAttribute(t,n),this.c.fromBufferAttribute(t,r),this}clone(){return(new this.constructor).copy(this)}copy(t){return this.a.copy(t.a),this.b.copy(t.b),this.c.copy(t.c),this}getArea(){return $i.subVectors(this.c,this.b),Ji.subVectors(this.a,this.b),.5*$i.cross(Ji).length()}getMidpoint(t){return t.addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)}getNormal(t){return ha.getNormal(this.a,this.b,this.c,t)}getPlane(t){return t.setFromCoplanarPoints(this.a,this.b,this.c)}getBarycoord(t,e){return ha.getBarycoord(t,this.a,this.b,this.c,e)}getInterpolation(t,e,n,r,i){return ha.getInterpolation(t,this.a,this.b,this.c,e,n,r,i)}containsPoint(t){return ha.containsPoint(t,this.a,this.b,this.c)}isFrontFacing(t){return ha.isFrontFacing(this.a,this.b,this.c,t)}intersectsBox(t){return t.intersectsTriangle(this)}closestPointToPoint(t,e){const n=this.a,r=this.b,i=this.c;let a,s;ea.subVectors(r,n),na.subVectors(i,n),ia.subVectors(t,n);const o=ea.dot(ia),l=na.dot(ia);if(o<=0&&l<=0)return e.copy(n);aa.subVectors(t,r);const c=ea.dot(aa),h=na.dot(aa);if(c>=0&&h<=c)return e.copy(r);const u=o*h-c*l;if(u<=0&&o>=0&&c<=0)return a=o/(o-c),e.copy(n).addScaledVector(ea,a);sa.subVectors(t,i);const d=ea.dot(sa),p=na.dot(sa);if(p>=0&&d<=p)return e.copy(i);const f=d*l-o*p;if(f<=0&&l>=0&&p<=0)return s=l/(l-p),e.copy(n).addScaledVector(na,s);const m=c*p-d*h;if(m<=0&&h-c>=0&&d-p>=0)return ra.subVectors(i,r),s=(h-c)/(h-c+(d-p)),e.copy(r).addScaledVector(ra,s);const g=1/(m+f+u);return a=f*g,s=u*g,e.copy(n).addScaledVector(ea,a).addScaledVector(na,s)}equals(t){return t.a.equals(this.a)&&t.b.equals(this.b)&&t.c.equals(this.c)}}const ua={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074},da={h:0,s:0,l:0},pa={h:0,s:0,l:0};function fa(t,e,n){return n<0&&(n+=1),n>1&&(n-=1),n<1/6?t+6*(e-t)*n:n<.5?e:n<2/3?t+6*(e-t)*(2/3-n):t}class ma{constructor(t,e,n){return this.isColor=1,this.r=1,this.g=1,this.b=1,this.set(t,e,n)}set(t,e,n){if(void 0===e&&void 0===n){const e=t;e&&e.isColor?this.copy(e):"number"==typeof e?this.setHex(e):"string"==typeof e&&this.setStyle(e)}else this.setRGB(t,e,n);return this}setScalar(t){return this.r=t,this.g=t,this.b=t,this}setHex(t,e=Wn){return t=Math.floor(t),this.r=(t>>16&255)/255,this.g=(t>>8&255)/255,this.b=(255&t)/255,Ir.colorSpaceToWorking(this,e),this}setRGB(t,e,n,r=Ir.workingColorSpace){return this.r=t,this.g=e,this.b=n,Ir.colorSpaceToWorking(this,r),this}setHSL(t,e,n,r=Ir.workingColorSpace){if(t=fr(t,1),e=pr(e,0,1),n=pr(n,0,1),0===e)this.r=this.g=this.b=n;else{const r=n<=.5?n*(1+e):n+e-n*e,i=2*n-r;this.r=fa(i,r,t+1/3),this.g=fa(i,r,t),this.b=fa(i,r,t-1/3)}return Ir.colorSpaceToWorking(this,r),this}setStyle(t,e=Wn){function n(t){void 0!==t&&parseFloat(t)}let r;if(r=/^(\w+)\(([^\)]*)\)/.exec(t)){let t;const i=r[1],a=r[2];switch(i){case"rgb":case"rgba":if(t=/^\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(a))return n(t[4]),this.setRGB(Math.min(255,parseInt(t[1],10))/255,Math.min(255,parseInt(t[2],10))/255,Math.min(255,parseInt(t[3],10))/255,e);if(t=/^\s*(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(a))return n(t[4]),this.setRGB(Math.min(100,parseInt(t[1],10))/100,Math.min(100,parseInt(t[2],10))/100,Math.min(100,parseInt(t[3],10))/100,e);break;case"hsl":case"hsla":if(t=/^\s*(\d*\.?\d+)\s*,\s*(\d*\.?\d+)\%\s*,\s*(\d*\.?\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(a))return n(t[4]),this.setHSL(parseFloat(t[1])/360,parseFloat(t[2])/100,parseFloat(t[3])/100,e)}}else if(r=/^\#([A-Fa-f\d]+)$/.exec(t)){const t=r[1],n=t.length;if(3===n)return this.setRGB(parseInt(t.charAt(0),16)/15,parseInt(t.charAt(1),16)/15,parseInt(t.charAt(2),16)/15,e);if(6===n)return this.setHex(parseInt(t,16),e)}else if(t&&t.length>0)return this.setColorName(t,e);return this}setColorName(t,e=Wn){const n=ua[t.toLowerCase()];return void 0!==n&&this.setHex(n,e),this}clone(){return new this.constructor(this.r,this.g,this.b)}copy(t){return this.r=t.r,this.g=t.g,this.b=t.b,this}copySRGBToLinear(t){return this.r=Nr(t.r),this.g=Nr(t.g),this.b=Nr(t.b),this}copyLinearToSRGB(t){return this.r=Or(t.r),this.g=Or(t.g),this.b=Or(t.b),this}convertSRGBToLinear(){return this.copySRGBToLinear(this),this}convertLinearToSRGB(){return this.copyLinearToSRGB(this),this}getHex(t=Wn){return Ir.workingToColorSpace(ga.copy(this),t),65536*Math.round(pr(255*ga.r,0,255))+256*Math.round(pr(255*ga.g,0,255))+Math.round(pr(255*ga.b,0,255))}getHexString(t=Wn){return("000000"+this.getHex(t).toString(16)).slice(-6)}getHSL(t,e=Ir.workingColorSpace){Ir.workingToColorSpace(ga.copy(this),e);const n=ga.r,r=ga.g,i=ga.b,a=Math.max(n,r,i),s=Math.min(n,r,i);let o,l;const c=(s+a)/2;if(s===a)o=0,l=0;else{const t=a-s;switch(l=c<=.5?t/(a+s):t/(2-a-s),a){case n:o=(r-i)/t+(r<i?6:0);break;case r:o=(i-n)/t+2;break;case i:o=(n-r)/t+4}o/=6}return t.h=o,t.s=l,t.l=c,t}getRGB(t,e=Ir.workingColorSpace){return Ir.workingToColorSpace(ga.copy(this),e),t.r=ga.r,t.g=ga.g,t.b=ga.b,t}getStyle(t=Wn){Ir.workingToColorSpace(ga.copy(this),t);const e=ga.r,n=ga.g,r=ga.b;return t!==Wn?`color(${t} ${e.toFixed(3)} ${n.toFixed(3)} ${r.toFixed(3)})`:`rgb(${Math.round(255*e)},${Math.round(255*n)},${Math.round(255*r)})`}offsetHSL(t,e,n){return this.getHSL(da),this.setHSL(da.h+t,da.s+e,da.l+n)}add(t){return this.r+=t.r,this.g+=t.g,this.b+=t.b,this}addColors(t,e){return this.r=t.r+e.r,this.g=t.g+e.g,this.b=t.b+e.b,this}addScalar(t){return this.r+=t,this.g+=t,this.b+=t,this}sub(t){return this.r=Math.max(0,this.r-t.r),this.g=Math.max(0,this.g-t.g),this.b=Math.max(0,this.b-t.b),this}multiply(t){return this.r*=t.r,this.g*=t.g,this.b*=t.b,this}multiplyScalar(t){return this.r*=t,this.g*=t,this.b*=t,this}lerp(t,e){return this.r+=(t.r-this.r)*e,this.g+=(t.g-this.g)*e,this.b+=(t.b-this.b)*e,this}lerpColors(t,e,n){return this.r=t.r+(e.r-t.r)*n,this.g=t.g+(e.g-t.g)*n,this.b=t.b+(e.b-t.b)*n,this}lerpHSL(t,e){this.getHSL(da),t.getHSL(pa);const n=mr(da.h,pa.h,e),r=mr(da.s,pa.s,e),i=mr(da.l,pa.l,e);return this.setHSL(n,r,i),this}setFromVector3(t){return this.r=t.x,this.g=t.y,this.b=t.z,this}applyMatrix3(t){const e=this.r,n=this.g,r=this.b,i=t.elements;return this.r=i[0]*e+i[3]*n+i[6]*r,this.g=i[1]*e+i[4]*n+i[7]*r,this.b=i[2]*e+i[5]*n+i[8]*r,this}equals(t){return t.r===this.r&&t.g===this.g&&t.b===this.b}fromArray(t,e=0){return this.r=t[e],this.g=t[e+1],this.b=t[e+2],this}toArray(t=[],e=0){return t[e]=this.r,t[e+1]=this.g,t[e+2]=this.b,t}fromBufferAttribute(t,e){return this.r=t.getX(e),this.g=t.getY(e),this.b=t.getZ(e),this}toJSON(){return this.getHex()}*[Symbol.iterator](){yield this.r,yield this.g,yield this.b}}const ga=new ma;ma.NAMES=ua;let va=0;class xa extends or{constructor(){super(),this.isMaterial=1,Object.defineProperty(this,"id",{value:va++}),this.uuid=dr(),this.name="",this.type="Material",this.blending=1,this.side=0,this.vertexColors=0,this.opacity=1,this.transparent=0,this.alphaHash=0,this.blendSrc=204,this.blendDst=205,this.blendEquation=Qt,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.blendColor=new ma(0,0,0),this.blendAlpha=0,this.depthFunc=3,this.depthTest=1,this.depthWrite=1,this.stencilWriteMask=255,this.stencilFunc=519,this.stencilRef=0,this.stencilFuncMask=255,this.stencilFail=Yn,this.stencilZFail=Yn,this.stencilZPass=Yn,this.stencilWrite=0,this.clippingPlanes=null,this.clipIntersection=0,this.clipShadows=0,this.shadowSide=null,this.colorWrite=1,this.precision=null,this.polygonOffset=0,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.dithering=0,this.alphaToCoverage=0,this.premultipliedAlpha=0,this.forceSinglePass=0,this.allowOverride=1,this.visible=1,this.toneMapped=1,this.userData={},this.version=0,this._alphaTest=0}get alphaTest(){return this._alphaTest}set alphaTest(t){this._alphaTest>0!=t>0&&this.version++,this._alphaTest=t}onBeforeRender(){}onBeforeCompile(){}customProgramCacheKey(){return this.onBeforeCompile.toString()}setValues(t){if(void 0!==t)for(const e in t){const n=t[e];if(void 0===n)continue;const r=this[e];void 0!==r&&(r&&r.isColor?r.set(n):r&&r.isVector3&&n&&n.isVector3?r.copy(n):this[e]=n)}}toJSON(t){const e=void 0===t||"string"==typeof t;e&&(t={textures:{},images:{}});const n={metadata:{version:4.7,type:"Material",generator:"Material.toJSON"}};function r(t){const e=[];for(const n in t){const r=t[n];delete r.metadata,e.push(r)}return e}if(n.uuid=this.uuid,n.type=this.type,""!==this.name&&(n.name=this.name),this.color&&this.color.isColor&&(n.color=this.color.getHex()),void 0!==this.roughness&&(n.roughness=this.roughness),void 0!==this.metalness&&(n.metalness=this.metalness),void 0!==this.sheen&&(n.sheen=this.sheen),this.sheenColor&&this.sheenColor.isColor&&(n.sheenColor=this.sheenColor.getHex()),void 0!==this.sheenRoughness&&(n.sheenRoughness=this.sheenRoughness),this.emissive&&this.emissive.isColor&&(n.emissive=this.emissive.getHex()),void 0!==this.emissiveIntensity&&1!==this.emissiveIntensity&&(n.emissiveIntensity=this.emissiveIntensity),this.specular&&this.specular.isColor&&(n.specular=this.specular.getHex()),void 0!==this.specularIntensity&&(n.specularIntensity=this.specularIntensity),this.specularColor&&this.specularColor.isColor&&(n.specularColor=this.specularColor.getHex()),void 0!==this.shininess&&(n.shininess=this.shininess),void 0!==this.clearcoat&&(n.clearcoat=this.clearcoat),void 0!==this.clearcoatRoughness&&(n.clearcoatRoughness=this.clearcoatRoughness),this.clearcoatMap&&this.clearcoatMap.isTexture&&(n.clearcoatMap=this.clearcoatMap.toJSON(t).uuid),this.clearcoatRoughnessMap&&this.clearcoatRoughnessMap.isTexture&&(n.clearcoatRoughnessMap=this.clearcoatRoughnessMap.toJSON(t).uuid),this.clearcoatNormalMap&&this.clearcoatNormalMap.isTexture&&(n.clearcoatNormalMap=this.clearcoatNormalMap.toJSON(t).uuid,n.clearcoatNormalScale=this.clearcoatNormalScale.toArray()),void 0!==this.dispersion&&(n.dispersion=this.dispersion),void 0!==this.iridescence&&(n.iridescence=this.iridescence),void 0!==this.iridescenceIOR&&(n.iridescenceIOR=this.iridescenceIOR),void 0!==this.iridescenceThicknessRange&&(n.iridescenceThicknessRange=this.iridescenceThicknessRange),this.iridescenceMap&&this.iridescenceMap.isTexture&&(n.iridescenceMap=this.iridescenceMap.toJSON(t).uuid),this.iridescenceThicknessMap&&this.iridescenceThicknessMap.isTexture&&(n.iridescenceThicknessMap=this.iridescenceThicknessMap.toJSON(t).uuid),void 0!==this.anisotropy&&(n.anisotropy=this.anisotropy),void 0!==this.anisotropyRotation&&(n.anisotropyRotation=this.anisotropyRotation),this.anisotropyMap&&this.anisotropyMap.isTexture&&(n.anisotropyMap=this.anisotropyMap.toJSON(t).uuid),this.map&&this.map.isTexture&&(n.map=this.map.toJSON(t).uuid),this.matcap&&this.matcap.isTexture&&(n.matcap=this.matcap.toJSON(t).uuid),this.alphaMap&&this.alphaMap.isTexture&&(n.alphaMap=this.alphaMap.toJSON(t).uuid),this.lightMap&&this.lightMap.isTexture&&(n.lightMap=this.lightMap.toJSON(t).uuid,n.lightMapIntensity=this.lightMapIntensity),this.aoMap&&this.aoMap.isTexture&&(n.aoMap=this.aoMap.toJSON(t).uuid,n.aoMapIntensity=this.aoMapIntensity),this.bumpMap&&this.bumpMap.isTexture&&(n.bumpMap=this.bumpMap.toJSON(t).uuid,n.bumpScale=this.bumpScale),this.normalMap&&this.normalMap.isTexture&&(n.normalMap=this.normalMap.toJSON(t).uuid,n.normalMapType=this.normalMapType,n.normalScale=this.normalScale.toArray()),this.displacementMap&&this.displacementMap.isTexture&&(n.displacementMap=this.displacementMap.toJSON(t).uuid,n.displacementScale=this.displacementScale,n.displacementBias=this.displacementBias),this.roughnessMap&&this.roughnessMap.isTexture&&(n.roughnessMap=this.roughnessMap.toJSON(t).uuid),this.metalnessMap&&this.metalnessMap.isTexture&&(n.metalnessMap=this.metalnessMap.toJSON(t).uuid),this.emissiveMap&&this.emissiveMap.isTexture&&(n.emissiveMap=this.emissiveMap.toJSON(t).uuid),this.specularMap&&this.specularMap.isTexture&&(n.specularMap=this.specularMap.toJSON(t).uuid),this.specularIntensityMap&&this.specularIntensityMap.isTexture&&(n.specularIntensityMap=this.specularIntensityMap.toJSON(t).uuid),this.specularColorMap&&this.specularColorMap.isTexture&&(n.specularColorMap=this.specularColorMap.toJSON(t).uuid),this.envMap&&this.envMap.isTexture&&(n.envMap=this.envMap.toJSON(t).uuid,void 0!==this.combine&&(n.combine=this.combine)),void 0!==this.envMapRotation&&(n.envMapRotation=this.envMapRotation.toArray()),void 0!==this.envMapIntensity&&(n.envMapIntensity=this.envMapIntensity),void 0!==this.reflectivity&&(n.reflectivity=this.reflectivity),void 0!==this.refractionRatio&&(n.refractionRatio=this.refractionRatio),this.gradientMap&&this.gradientMap.isTexture&&(n.gradientMap=this.gradientMap.toJSON(t).uuid),void 0!==this.transmission&&(n.transmission=this.transmission),this.transmissionMap&&this.transmissionMap.isTexture&&(n.transmissionMap=this.transmissionMap.toJSON(t).uuid),void 0!==this.thickness&&(n.thickness=this.thickness),this.thicknessMap&&this.thicknessMap.isTexture&&(n.thicknessMap=this.thicknessMap.toJSON(t).uuid),void 0!==this.attenuationDistance&&this.attenuationDistance!==1/0&&(n.attenuationDistance=this.attenuationDistance),void 0!==this.attenuationColor&&(n.attenuationColor=this.attenuationColor.getHex()),void 0!==this.size&&(n.size=this.size),null!==this.shadowSide&&(n.shadowSide=this.shadowSide),void 0!==this.sizeAttenuation&&(n.sizeAttenuation=this.sizeAttenuation),1!==this.blending&&(n.blending=this.blending),0!==this.side&&(n.side=this.side),1==this.vertexColors&&(n.vertexColors=1),this.opacity<1&&(n.opacity=this.opacity),1==this.transparent&&(n.transparent=1),204!==this.blendSrc&&(n.blendSrc=this.blendSrc),205!==this.blendDst&&(n.blendDst=this.blendDst),this.blendEquation!==Qt&&(n.blendEquation=this.blendEquation),null!==this.blendSrcAlpha&&(n.blendSrcAlpha=this.blendSrcAlpha),null!==this.blendDstAlpha&&(n.blendDstAlpha=this.blendDstAlpha),null!==this.blendEquationAlpha&&(n.blendEquationAlpha=this.blendEquationAlpha),this.blendColor&&this.blendColor.isColor&&(n.blendColor=this.blendColor.getHex()),0!==this.blendAlpha&&(n.blendAlpha=this.blendAlpha),3!==this.depthFunc&&(n.depthFunc=this.depthFunc),0==this.depthTest&&(n.depthTest=this.depthTest),0==this.depthWrite&&(n.depthWrite=this.depthWrite),0==this.colorWrite&&(n.colorWrite=this.colorWrite),255!==this.stencilWriteMask&&(n.stencilWriteMask=this.stencilWriteMask),519!==this.stencilFunc&&(n.stencilFunc=this.stencilFunc),0!==this.stencilRef&&(n.stencilRef=this.stencilRef),255!==this.stencilFuncMask&&(n.stencilFuncMask=this.stencilFuncMask),this.stencilFail!==Yn&&(n.stencilFail=this.stencilFail),this.stencilZFail!==Yn&&(n.stencilZFail=this.stencilZFail),this.stencilZPass!==Yn&&(n.stencilZPass=this.stencilZPass),1==this.stencilWrite&&(n.stencilWrite=this.stencilWrite),void 0!==this.rotation&&0!==this.rotation&&(n.rotation=this.rotation),1==this.polygonOffset&&(n.polygonOffset=1),0!==this.polygonOffsetFactor&&(n.polygonOffsetFactor=this.polygonOffsetFactor),0!==this.polygonOffsetUnits&&(n.polygonOffsetUnits=this.polygonOffsetUnits),void 0!==this.linewidth&&1!==this.linewidth&&(n.linewidth=this.linewidth),void 0!==this.dashSize&&(n.dashSize=this.dashSize),void 0!==this.gapSize&&(n.gapSize=this.gapSize),void 0!==this.scale&&(n.scale=this.scale),1==this.dithering&&(n.dithering=1),this.alphaTest>0&&(n.alphaTest=this.alphaTest),1==this.alphaHash&&(n.alphaHash=1),1==this.alphaToCoverage&&(n.alphaToCoverage=1),1==this.premultipliedAlpha&&(n.premultipliedAlpha=1),1==this.forceSinglePass&&(n.forceSinglePass=1),1==this.wireframe&&(n.wireframe=1),this.wireframeLinewidth>1&&(n.wireframeLinewidth=this.wireframeLinewidth),"round"!==this.wireframeLinecap&&(n.wireframeLinecap=this.wireframeLinecap),"round"!==this.wireframeLinejoin&&(n.wireframeLinejoin=this.wireframeLinejoin),1==this.flatShading&&(n.flatShading=1),0==this.visible&&(n.visible=0),0==this.toneMapped&&(n.toneMapped=0),0==this.fog&&(n.fog=0),Object.keys(this.userData).length>0&&(n.userData=this.userData),e){const e=r(t.textures),i=r(t.images);e.length>0&&(n.textures=e),i.length>0&&(n.images=i)}return n}clone(){return(new this.constructor).copy(this)}copy(t){this.name=t.name,this.blending=t.blending,this.side=t.side,this.vertexColors=t.vertexColors,this.opacity=t.opacity,this.transparent=t.transparent,this.blendSrc=t.blendSrc,this.blendDst=t.blendDst,this.blendEquation=t.blendEquation,this.blendSrcAlpha=t.blendSrcAlpha,this.blendDstAlpha=t.blendDstAlpha,this.blendEquationAlpha=t.blendEquationAlpha,this.blendColor.copy(t.blendColor),this.blendAlpha=t.blendAlpha,this.depthFunc=t.depthFunc,this.depthTest=t.depthTest,this.depthWrite=t.depthWrite,this.stencilWriteMask=t.stencilWriteMask,this.stencilFunc=t.stencilFunc,this.stencilRef=t.stencilRef,this.stencilFuncMask=t.stencilFuncMask,this.stencilFail=t.stencilFail,this.stencilZFail=t.stencilZFail,this.stencilZPass=t.stencilZPass,this.stencilWrite=t.stencilWrite;const e=t.clippingPlanes;let n=null;if(null!==e){const t=e.length;n=new Array(t);for(let r=0;r!==t;++r)n[r]=e[r].clone()}return this.clippingPlanes=n,this.clipIntersection=t.clipIntersection,this.clipShadows=t.clipShadows,this.shadowSide=t.shadowSide,this.colorWrite=t.colorWrite,this.precision=t.precision,this.polygonOffset=t.polygonOffset,this.polygonOffsetFactor=t.polygonOffsetFactor,this.polygonOffsetUnits=t.polygonOffsetUnits,this.dithering=t.dithering,this.alphaTest=t.alphaTest,this.alphaHash=t.alphaHash,this.alphaToCoverage=t.alphaToCoverage,this.premultipliedAlpha=t.premultipliedAlpha,this.forceSinglePass=t.forceSinglePass,this.visible=t.visible,this.toneMapped=t.toneMapped,this.userData=JSON.parse(JSON.stringify(t.userData)),this}dispose(){this.dispatchEvent({type:"dispose"})}set needsUpdate(t){1==t&&this.version++}}class _a extends xa{constructor(t){super(),this.isMeshBasicMaterial=1,this.type="MeshBasicMaterial",this.color=new ma(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Li,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=0,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.fog=1,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapRotation.copy(t.envMapRotation),this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.fog=t.fog,this}}const ya=new br,ba=new _r;let Ea=0;class Ta{constructor(t,e,n=0){if(Array.isArray(t))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.isBufferAttribute=1,Object.defineProperty(this,"id",{value:Ea++}),this.name="",this.array=t,this.itemSize=e,this.count=void 0!==t?t.length/e:0,this.normalized=n,this.usage=rr,this.updateRanges=[],this.gpuType=je,this.version=0}onUploadCallback(){}set needsUpdate(t){1==t&&this.version++}setUsage(t){return this.usage=t,this}addUpdateRange(t,e){this.updateRanges.push({start:t,count:e})}clearUpdateRanges(){this.updateRanges.length=0}copy(t){return this.name=t.name,this.array=new t.array.constructor(t.array),this.itemSize=t.itemSize,this.count=t.count,this.normalized=t.normalized,this.usage=t.usage,this.gpuType=t.gpuType,this}copyAt(t,e,n){t*=this.itemSize,n*=e.itemSize;for(let r=0,i=this.itemSize;r<i;r++)this.array[t+r]=e.array[n+r];return this}copyArray(t){return this.array.set(t),this}applyMatrix3(t){if(2===this.itemSize)for(let e=0,n=this.count;e<n;e++)ba.fromBufferAttribute(this,e),ba.applyMatrix3(t),this.setXY(e,ba.x,ba.y);else if(3===this.itemSize)for(let e=0,n=this.count;e<n;e++)ya.fromBufferAttribute(this,e),ya.applyMatrix3(t),this.setXYZ(e,ya.x,ya.y,ya.z);return this}applyMatrix4(t){for(let e=0,n=this.count;e<n;e++)ya.fromBufferAttribute(this,e),ya.applyMatrix4(t),this.setXYZ(e,ya.x,ya.y,ya.z);return this}applyNormalMatrix(t){for(let e=0,n=this.count;e<n;e++)ya.fromBufferAttribute(this,e),ya.applyNormalMatrix(t),this.setXYZ(e,ya.x,ya.y,ya.z);return this}transformDirection(t){for(let e=0,n=this.count;e<n;e++)ya.fromBufferAttribute(this,e),ya.transformDirection(t),this.setXYZ(e,ya.x,ya.y,ya.z);return this}set(t,e=0){return this.array.set(t,e),this}getComponent(t,e){let n=this.array[t*this.itemSize+e];return this.normalized&&(n=gr(n,this.array)),n}setComponent(t,e,n){return this.normalized&&(n=vr(n,this.array)),this.array[t*this.itemSize+e]=n,this}getX(t){let e=this.array[t*this.itemSize];return this.normalized&&(e=gr(e,this.array)),e}setX(t,e){return this.normalized&&(e=vr(e,this.array)),this.array[t*this.itemSize]=e,this}getY(t){let e=this.array[t*this.itemSize+1];return this.normalized&&(e=gr(e,this.array)),e}setY(t,e){return this.normalized&&(e=vr(e,this.array)),this.array[t*this.itemSize+1]=e,this}getZ(t){let e=this.array[t*this.itemSize+2];return this.normalized&&(e=gr(e,this.array)),e}setZ(t,e){return this.normalized&&(e=vr(e,this.array)),this.array[t*this.itemSize+2]=e,this}getW(t){let e=this.array[t*this.itemSize+3];return this.normalized&&(e=gr(e,this.array)),e}setW(t,e){return this.normalized&&(e=vr(e,this.array)),this.array[t*this.itemSize+3]=e,this}setXY(t,e,n){return t*=this.itemSize,this.normalized&&(e=vr(e,this.array),n=vr(n,this.array)),this.array[t+0]=e,this.array[t+1]=n,this}setXYZ(t,e,n,r){return t*=this.itemSize,this.normalized&&(e=vr(e,this.array),n=vr(n,this.array),r=vr(r,this.array)),this.array[t+0]=e,this.array[t+1]=n,this.array[t+2]=r,this}setXYZW(t,e,n,r,i){return t*=this.itemSize,this.normalized&&(e=vr(e,this.array),n=vr(n,this.array),r=vr(r,this.array),i=vr(i,this.array)),this.array[t+0]=e,this.array[t+1]=n,this.array[t+2]=r,this.array[t+3]=i,this}onUpload(t){return this.onUploadCallback=t,this}clone(){return new this.constructor(this.array,this.itemSize).copy(this)}toJSON(){const t={itemSize:this.itemSize,type:this.array.constructor.name,array:Array.from(this.array),normalized:this.normalized};return""!==this.name&&(t.name=this.name),this.usage!==rr&&(t.usage=this.usage),t}}class Sa extends Ta{constructor(t,e,n){super(new Uint16Array(t),e,n)}}class Ma extends Ta{constructor(t,e,n){super(new Uint32Array(t),e,n)}}class wa extends Ta{constructor(t,e,n){super(new Float32Array(t),e,n)}}let Ra=0;const Aa=new Ti,Ca=new Zi,Pa=new br,Da=new Zr,Ua=new Zr,La=new br;class Ia extends or{constructor(){super(),this.isBufferGeometry=1,Object.defineProperty(this,"id",{value:Ra++}),this.uuid=dr(),this.name="",this.type="BufferGeometry",this.index=null,this.indirect=null,this.attributes={},this.morphAttributes={},this.morphTargetsRelative=0,this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.drawRange={start:0,count:1/0},this.userData={}}getIndex(){return this.index}setIndex(t){return Array.isArray(t)?this.index=new(wr(t)?Ma:Sa)(t,1):this.index=t,this}setIndirect(t){return this.indirect=t,this}getIndirect(){return this.indirect}getAttribute(t){return this.attributes[t]}setAttribute(t,e){return this.attributes[t]=e,this}deleteAttribute(t){return delete this.attributes[t],this}hasAttribute(t){return void 0!==this.attributes[t]}addGroup(t,e,n=0){this.groups.push({start:t,count:e,materialIndex:n})}clearGroups(){this.groups=[]}setDrawRange(t,e){this.drawRange.start=t,this.drawRange.count=e}applyMatrix4(t){const e=this.attributes.position;void 0!==e&&(e.applyMatrix4(t),e.needsUpdate=1);const n=this.attributes.normal;if(void 0!==n){const e=(new Sr).getNormalMatrix(t);n.applyNormalMatrix(e),n.needsUpdate=1}const r=this.attributes.tangent;return void 0!==r&&(r.transformDirection(t),r.needsUpdate=1),null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this}applyQuaternion(t){return Aa.makeRotationFromQuaternion(t),this.applyMatrix4(Aa),this}rotateX(t){return Aa.makeRotationX(t),this.applyMatrix4(Aa),this}rotateY(t){return Aa.makeRotationY(t),this.applyMatrix4(Aa),this}rotateZ(t){return Aa.makeRotationZ(t),this.applyMatrix4(Aa),this}translate(t,e,n){return Aa.makeTranslation(t,e,n),this.applyMatrix4(Aa),this}scale(t,e,n){return Aa.makeScale(t,e,n),this.applyMatrix4(Aa),this}lookAt(t){return Ca.lookAt(t),Ca.updateMatrix(),this.applyMatrix4(Ca.matrix),this}center(){return this.computeBoundingBox(),this.boundingBox.getCenter(Pa).negate(),this.translate(Pa.x,Pa.y,Pa.z),this}setFromPoints(t){const e=this.getAttribute("position");if(void 0===e){const e=[];for(let n=0,r=t.length;n<r;n++){const r=t[n];e.push(r.x,r.y,r.z||0)}this.setAttribute("position",new wa(e,3))}else{const n=Math.min(t.length,e.count);for(let r=0;r<n;r++){const n=t[r];e.setXYZ(r,n.x,n.y,n.z||0)}t.length,e.count,e.needsUpdate=1}return this}computeBoundingBox(){null===this.boundingBox&&(this.boundingBox=new Zr);const t=this.attributes.position,e=this.morphAttributes.position;if(t&&t.isGLBufferAttribute)this.boundingBox.set(new br(-1/0,-1/0,-1/0),new br(1/0,1/0,1/0));else{if(void 0!==t){if(this.boundingBox.setFromBufferAttribute(t),e)for(let t=0,n=e.length;t<n;t++){const n=e[t];Da.setFromBufferAttribute(n),this.morphTargetsRelative?(La.addVectors(this.boundingBox.min,Da.min),this.boundingBox.expandByPoint(La),La.addVectors(this.boundingBox.max,Da.max),this.boundingBox.expandByPoint(La)):(this.boundingBox.expandByPoint(Da.min),this.boundingBox.expandByPoint(Da.max))}}else this.boundingBox.makeEmpty();isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z)}}computeBoundingSphere(){null===this.boundingSphere&&(this.boundingSphere=new fi);const t=this.attributes.position,e=this.morphAttributes.position;if(t&&t.isGLBufferAttribute)this.boundingSphere.set(new br,1/0);else if(t){const n=this.boundingSphere.center;if(Da.setFromBufferAttribute(t),e)for(let t=0,n=e.length;t<n;t++){const n=e[t];Ua.setFromBufferAttribute(n),this.morphTargetsRelative?(La.addVectors(Da.min,Ua.min),Da.expandByPoint(La),La.addVectors(Da.max,Ua.max),Da.expandByPoint(La)):(Da.expandByPoint(Ua.min),Da.expandByPoint(Ua.max))}Da.getCenter(n);let r=0;for(let e=0,i=t.count;e<i;e++)La.fromBufferAttribute(t,e),r=Math.max(r,n.distanceToSquared(La));if(e)for(let i=0,a=e.length;i<a;i++){const a=e[i],s=this.morphTargetsRelative;for(let e=0,i=a.count;e<i;e++)La.fromBufferAttribute(a,e),s&&(Pa.fromBufferAttribute(t,e),La.add(Pa)),r=Math.max(r,n.distanceToSquared(La))}this.boundingSphere.radius=Math.sqrt(r),isNaN(this.boundingSphere.radius)}}computeTangents(){const t=this.index,e=this.attributes;if(null===t||void 0===e.position||void 0===e.normal||void 0===e.uv)return;const n=e.position,r=e.normal,i=e.uv;0==this.hasAttribute("tangent")&&this.setAttribute("tangent",new Ta(new Float32Array(4*n.count),4));const a=this.getAttribute("tangent"),s=[],o=[];for(let t=0;t<n.count;t++)s[t]=new br,o[t]=new br;const l=new br,c=new br,h=new br,u=new _r,d=new _r,p=new _r,f=new br,m=new br;function g(t,e,r){l.fromBufferAttribute(n,t),c.fromBufferAttribute(n,e),h.fromBufferAttribute(n,r),u.fromBufferAttribute(i,t),d.fromBufferAttribute(i,e),p.fromBufferAttribute(i,r),c.sub(l),h.sub(l),d.sub(u),p.sub(u);const a=1/(d.x*p.y-p.x*d.y);isFinite(a)&&(f.copy(c).multiplyScalar(p.y).addScaledVector(h,-d.y).multiplyScalar(a),m.copy(h).multiplyScalar(d.x).addScaledVector(c,-p.x).multiplyScalar(a),s[t].add(f),s[e].add(f),s[r].add(f),o[t].add(m),o[e].add(m),o[r].add(m))}let v=this.groups;0===v.length&&(v=[{start:0,count:t.count}]);for(let e=0,n=v.length;e<n;++e){const n=v[e],r=n.start;for(let e=r,i=r+n.count;e<i;e+=3)g(t.getX(e+0),t.getX(e+1),t.getX(e+2))}const x=new br,_=new br,y=new br,b=new br;function E(t){y.fromBufferAttribute(r,t),b.copy(y);const e=s[t];x.copy(e),x.sub(y.multiplyScalar(y.dot(e))).normalize(),_.crossVectors(b,e);const n=_.dot(o[t])<0?-1:1;a.setXYZW(t,x.x,x.y,x.z,n)}for(let e=0,n=v.length;e<n;++e){const n=v[e],r=n.start;for(let e=r,i=r+n.count;e<i;e+=3)E(t.getX(e+0)),E(t.getX(e+1)),E(t.getX(e+2))}}computeVertexNormals(){const t=this.index,e=this.getAttribute("position");if(void 0!==e){let n=this.getAttribute("normal");if(void 0===n)n=new Ta(new Float32Array(3*e.count),3),this.setAttribute("normal",n);else for(let t=0,e=n.count;t<e;t++)n.setXYZ(t,0,0,0);const r=new br,i=new br,a=new br,s=new br,o=new br,l=new br,c=new br,h=new br;if(t)for(let u=0,d=t.count;u<d;u+=3){const d=t.getX(u+0),p=t.getX(u+1),f=t.getX(u+2);r.fromBufferAttribute(e,d),i.fromBufferAttribute(e,p),a.fromBufferAttribute(e,f),c.subVectors(a,i),h.subVectors(r,i),c.cross(h),s.fromBufferAttribute(n,d),o.fromBufferAttribute(n,p),l.fromBufferAttribute(n,f),s.add(c),o.add(c),l.add(c),n.setXYZ(d,s.x,s.y,s.z),n.setXYZ(p,o.x,o.y,o.z),n.setXYZ(f,l.x,l.y,l.z)}else for(let t=0,s=e.count;t<s;t+=3)r.fromBufferAttribute(e,t+0),i.fromBufferAttribute(e,t+1),a.fromBufferAttribute(e,t+2),c.subVectors(a,i),h.subVectors(r,i),c.cross(h),n.setXYZ(t+0,c.x,c.y,c.z),n.setXYZ(t+1,c.x,c.y,c.z),n.setXYZ(t+2,c.x,c.y,c.z);this.normalizeNormals(),n.needsUpdate=1}}normalizeNormals(){const t=this.attributes.normal;for(let e=0,n=t.count;e<n;e++)La.fromBufferAttribute(t,e),La.normalize(),t.setXYZ(e,La.x,La.y,La.z)}toNonIndexed(){function t(t,e){const n=t.array,r=t.itemSize,i=t.normalized,a=new n.constructor(e.length*r);let s=0,o=0;for(let i=0,l=e.length;i<l;i++){s=t.isInterleavedBufferAttribute?e[i]*t.data.stride+t.offset:e[i]*r;for(let t=0;t<r;t++)a[o++]=n[s++]}return new Ta(a,r,i)}if(null===this.index)return this;const e=new Ia,n=this.index.array,r=this.attributes;for(const i in r){const a=t(r[i],n);e.setAttribute(i,a)}const i=this.morphAttributes;for(const r in i){const a=[],s=i[r];for(let e=0,r=s.length;e<r;e++){const r=t(s[e],n);a.push(r)}e.morphAttributes[r]=a}e.morphTargetsRelative=this.morphTargetsRelative;const a=this.groups;for(let t=0,n=a.length;t<n;t++){const n=a[t];e.addGroup(n.start,n.count,n.materialIndex)}return e}toJSON(){const t={metadata:{version:4.7,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(t.uuid=this.uuid,t.type=this.type,""!==this.name&&(t.name=this.name),Object.keys(this.userData).length>0&&(t.userData=this.userData),void 0!==this.parameters){const e=this.parameters;for(const n in e)void 0!==e[n]&&(t[n]=e[n]);return t}t.data={attributes:{}};const e=this.index;null!==e&&(t.data.index={type:e.array.constructor.name,array:Array.prototype.slice.call(e.array)});const n=this.attributes;for(const e in n){const r=n[e];t.data.attributes[e]=r.toJSON(t.data)}const r={};let i=0;for(const e in this.morphAttributes){const n=this.morphAttributes[e],a=[];for(let e=0,r=n.length;e<r;e++){const r=n[e];a.push(r.toJSON(t.data))}a.length>0&&(r[e]=a,i=1)}i&&(t.data.morphAttributes=r,t.data.morphTargetsRelative=this.morphTargetsRelative);const a=this.groups;a.length>0&&(t.data.groups=JSON.parse(JSON.stringify(a)));const s=this.boundingSphere;return null!==s&&(t.data.boundingSphere=s.toJSON()),t}clone(){return(new this.constructor).copy(this)}copy(t){this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null;const e={};this.name=t.name;const n=t.index;null!==n&&this.setIndex(n.clone());const r=t.attributes;for(const t in r){const n=r[t];this.setAttribute(t,n.clone(e))}const i=t.morphAttributes;for(const t in i){const n=[],r=i[t];for(let t=0,i=r.length;t<i;t++)n.push(r[t].clone(e));this.morphAttributes[t]=n}this.morphTargetsRelative=t.morphTargetsRelative;const a=t.groups;for(let t=0,e=a.length;t<e;t++){const e=a[t];this.addGroup(e.start,e.count,e.materialIndex)}const s=t.boundingBox;null!==s&&(this.boundingBox=s.clone());const o=t.boundingSphere;return null!==o&&(this.boundingSphere=o.clone()),this.drawRange.start=t.drawRange.start,this.drawRange.count=t.drawRange.count,this.userData=t.userData,this}dispose(){this.dispatchEvent({type:"dispose"})}}const Na=new Ti,Oa=new Ei,Fa=new fi,Ba=new br,ka=new br,za=new br,Va=new br,Ha=new br,Ga=new br,Wa=new br,Xa=new br;class ja extends Zi{constructor(t=new Ia,e=new _a){super(),this.isMesh=1,this.type="Mesh",this.geometry=t,this.material=e,this.morphTargetDictionary=void 0,this.morphTargetInfluences=void 0,this.count=1,this.updateMorphTargets()}copy(t,e){return super.copy(t,e),void 0!==t.morphTargetInfluences&&(this.morphTargetInfluences=t.morphTargetInfluences.slice()),void 0!==t.morphTargetDictionary&&(this.morphTargetDictionary=Object.assign({},t.morphTargetDictionary)),this.material=Array.isArray(t.material)?t.material.slice():t.material,this.geometry=t.geometry,this}updateMorphTargets(){const t=this.geometry.morphAttributes,e=Object.keys(t);if(e.length>0){const n=t[e[0]];if(void 0!==n){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,e=n.length;t<e;t++){const e=n[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[e]=t}}}}getVertexPosition(t,e){const n=this.geometry,r=n.attributes.position,i=n.morphAttributes.position,a=n.morphTargetsRelative;e.fromBufferAttribute(r,t);const s=this.morphTargetInfluences;if(i&&s){Ga.set(0,0,0);for(let n=0,r=i.length;n<r;n++){const r=s[n],o=i[n];0!==r&&(Ha.fromBufferAttribute(o,t),a?Ga.addScaledVector(Ha,r):Ga.addScaledVector(Ha.sub(e),r))}e.add(Ga)}return e}raycast(t,e){const n=this.geometry,r=this.material,i=this.matrixWorld;if(void 0!==r){if(null===n.boundingSphere&&n.computeBoundingSphere(),Fa.copy(n.boundingSphere),Fa.applyMatrix4(i),Oa.copy(t.ray).recast(t.near),0==Fa.containsPoint(Oa.origin)){if(null===Oa.intersectSphere(Fa,Ba))return;if(Oa.origin.distanceToSquared(Ba)>(t.far-t.near)**2)return}Na.copy(i).invert(),Oa.copy(t.ray).applyMatrix4(Na),null!==n.boundingBox&&0==Oa.intersectsBox(n.boundingBox)||this._computeIntersections(t,e,Oa)}}_computeIntersections(t,e,n){let r;const i=this.geometry,a=this.material,s=i.index,o=i.attributes.position,l=i.attributes.uv,c=i.attributes.uv1,h=i.attributes.normal,u=i.groups,d=i.drawRange;if(null!==s)if(Array.isArray(a))for(let i=0,o=u.length;i<o;i++){const o=u[i],p=a[o.materialIndex];for(let i=Math.max(o.start,d.start),a=Math.min(s.count,Math.min(o.start+o.count,d.start+d.count));i<a;i+=3){r=qa(this,p,t,n,l,c,h,s.getX(i),s.getX(i+1),s.getX(i+2)),r&&(r.faceIndex=Math.floor(i/3),r.face.materialIndex=o.materialIndex,e.push(r))}}else{for(let i=Math.max(0,d.start),o=Math.min(s.count,d.start+d.count);i<o;i+=3){r=qa(this,a,t,n,l,c,h,s.getX(i),s.getX(i+1),s.getX(i+2)),r&&(r.faceIndex=Math.floor(i/3),e.push(r))}}else if(void 0!==o)if(Array.isArray(a))for(let i=0,s=u.length;i<s;i++){const s=u[i],p=a[s.materialIndex];for(let i=Math.max(s.start,d.start),a=Math.min(o.count,Math.min(s.start+s.count,d.start+d.count));i<a;i+=3){r=qa(this,p,t,n,l,c,h,i,i+1,i+2),r&&(r.faceIndex=Math.floor(i/3),r.face.materialIndex=s.materialIndex,e.push(r))}}else{for(let i=Math.max(0,d.start),s=Math.min(o.count,d.start+d.count);i<s;i+=3){r=qa(this,a,t,n,l,c,h,i,i+1,i+2),r&&(r.faceIndex=Math.floor(i/3),e.push(r))}}}}function qa(t,e,n,r,i,a,s,o,l,c){t.getVertexPosition(o,ka),t.getVertexPosition(l,za),t.getVertexPosition(c,Va);const h=function(t,e,n,r,i,a,s,o){let l;if(l=1===e.side?r.intersectTriangle(s,a,i,1,o):r.intersectTriangle(i,a,s,0===e.side,o),null===l)return null;Xa.copy(o),Xa.applyMatrix4(t.matrixWorld);const c=n.ray.origin.distanceTo(Xa);return c<n.near||c>n.far?null:{distance:c,point:Xa.clone(),object:t}}(t,e,n,r,ka,za,Va,Wa);if(h){const t=new br;ha.getBarycoord(Wa,ka,za,Va,t),i&&(h.uv=ha.getInterpolatedAttribute(i,o,l,c,t,new _r)),a&&(h.uv1=ha.getInterpolatedAttribute(a,o,l,c,t,new _r)),s&&(h.normal=ha.getInterpolatedAttribute(s,o,l,c,t,new br),h.normal.dot(r.direction)>0&&h.normal.multiplyScalar(-1));const e={a:o,b:l,c,normal:new br,materialIndex:0};ha.getNormal(ka,za,Va,e.normal),h.face=e,h.barycoord=t}return h}class Ya extends Ia{constructor(t=1,e=1,n=1,r=1,i=1,a=1){super(),this.type="BoxGeometry",this.parameters={width:t,height:e,depth:n,widthSegments:r,heightSegments:i,depthSegments:a};const s=this;r=Math.floor(r),i=Math.floor(i),a=Math.floor(a);const o=[],l=[],c=[],h=[];let u=0,d=0;function p(t,e,n,r,i,a,p,f,m,g,v){const x=a/m,_=p/g,y=a/2,b=p/2,E=f/2,T=m+1,S=g+1;let M=0,w=0;const R=new br;for(let a=0;a<S;a++){const s=a*_-b;for(let o=0;o<T;o++){const u=o*x-y;R[t]=u*r,R[e]=s*i,R[n]=E,l.push(R.x,R.y,R.z),R[t]=0,R[e]=0,R[n]=f>0?1:-1,c.push(R.x,R.y,R.z),h.push(o/m),h.push(1-a/g),M+=1}}for(let t=0;t<g;t++)for(let e=0;e<m;e++){const n=u+e+T*t,r=u+e+T*(t+1),i=u+(e+1)+T*(t+1),a=u+(e+1)+T*t;o.push(n,r,a),o.push(r,i,a),w+=6}s.addGroup(d,w,v),d+=w,u+=M}p("z","y","x",-1,-1,n,e,t,a,i,0),p("z","y","x",1,-1,n,e,-t,a,i,1),p("x","z","y",1,1,t,n,e,r,a,2),p("x","z","y",1,-1,t,n,-e,r,a,3),p("x","y","z",1,-1,t,e,n,r,i,4),p("x","y","z",-1,-1,t,e,-n,r,i,5),this.setIndex(o),this.setAttribute("position",new wa(l,3)),this.setAttribute("normal",new wa(c,3)),this.setAttribute("uv",new wa(h,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new Ya(t.width,t.height,t.depth,t.widthSegments,t.heightSegments,t.depthSegments)}}function Ka(t){const e={};for(const n in t){e[n]={};for(const r in t[n]){const i=t[n][r];i&&(i.isColor||i.isMatrix3||i.isMatrix4||i.isVector2||i.isVector3||i.isVector4||i.isTexture||i.isQuaternion)?i.isRenderTargetTexture?e[n][r]=null:e[n][r]=i.clone():Array.isArray(i)?e[n][r]=i.slice():e[n][r]=i}}return e}function Za(t){const e={};for(let n=0;n<t.length;n++){const r=Ka(t[n]);for(const t in r)e[t]=r[t]}return e}function $a(t){const e=t.getRenderTarget();return null===e?t.outputColorSpace:1==e.isXRRenderTarget?e.texture.colorSpace:Ir.workingColorSpace}const Ja={clone:Ka,merge:Za};class Qa extends xa{constructor(t){super(),this.isShaderMaterial=1,this.type="ShaderMaterial",this.defines={},this.uniforms={},this.uniformsGroups=[],this.vertexShader="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",this.fragmentShader="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}",this.linewidth=1,this.wireframe=0,this.wireframeLinewidth=1,this.fog=0,this.lights=0,this.clipping=0,this.forceSinglePass=1,this.extensions={clipCullDistance:0,multiDraw:0},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv1:[0,0]},this.index0AttributeName=void 0,this.uniformsNeedUpdate=0,this.glslVersion=null,void 0!==t&&this.setValues(t)}copy(t){return super.copy(t),this.fragmentShader=t.fragmentShader,this.vertexShader=t.vertexShader,this.uniforms=Ka(t.uniforms),this.uniformsGroups=function(t){const e=[];for(let n=0;n<t.length;n++)e.push(t[n].clone());return e}(t.uniformsGroups),this.defines=Object.assign({},t.defines),this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.fog=t.fog,this.lights=t.lights,this.clipping=t.clipping,this.extensions=Object.assign({},t.extensions),this.glslVersion=t.glslVersion,this}toJSON(t){const e=super.toJSON(t);e.glslVersion=this.glslVersion,e.uniforms={};for(const n in this.uniforms){const r=this.uniforms[n].value;r&&r.isTexture?e.uniforms[n]={type:"t",value:r.toJSON(t).uuid}:r&&r.isColor?e.uniforms[n]={type:"c",value:r.getHex()}:r&&r.isVector2?e.uniforms[n]={type:"v2",value:r.toArray()}:r&&r.isVector3?e.uniforms[n]={type:"v3",value:r.toArray()}:r&&r.isVector4?e.uniforms[n]={type:"v4",value:r.toArray()}:r&&r.isMatrix3?e.uniforms[n]={type:"m3",value:r.toArray()}:r&&r.isMatrix4?e.uniforms[n]={type:"m4",value:r.toArray()}:e.uniforms[n]={value:r}}Object.keys(this.defines).length>0&&(e.defines=this.defines),e.vertexShader=this.vertexShader,e.fragmentShader=this.fragmentShader,e.lights=this.lights,e.clipping=this.clipping;const n={};for(const t in this.extensions)1==this.extensions[t]&&(n[t]=1);return Object.keys(n).length>0&&(e.extensions=n),e}}class ts extends Zi{constructor(){super(),this.isCamera=1,this.type="Camera",this.matrixWorldInverse=new Ti,this.projectionMatrix=new Ti,this.projectionMatrixInverse=new Ti,this.coordinateSystem=ar,this._reversedDepth=0}get reversedDepth(){return this._reversedDepth}copy(t,e){return super.copy(t,e),this.matrixWorldInverse.copy(t.matrixWorldInverse),this.projectionMatrix.copy(t.projectionMatrix),this.projectionMatrixInverse.copy(t.projectionMatrixInverse),this.coordinateSystem=t.coordinateSystem,this}getWorldDirection(t){return super.getWorldDirection(t).negate()}updateMatrixWorld(t){super.updateMatrixWorld(t),this.matrixWorldInverse.copy(this.matrixWorld).invert()}updateWorldMatrix(t,e){super.updateWorldMatrix(t,e),this.matrixWorldInverse.copy(this.matrixWorld).invert()}clone(){return(new this.constructor).copy(this)}}const es=new br,ns=new _r,rs=new _r;class is extends ts{constructor(t=50,e=1,n=.1,r=2e3){super(),this.isPerspectiveCamera=1,this.type="PerspectiveCamera",this.fov=t,this.zoom=1,this.near=n,this.far=r,this.focus=10,this.aspect=e,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()}copy(t,e){return super.copy(t,e),this.fov=t.fov,this.zoom=t.zoom,this.near=t.near,this.far=t.far,this.focus=t.focus,this.aspect=t.aspect,this.view=null===t.view?null:Object.assign({},t.view),this.filmGauge=t.filmGauge,this.filmOffset=t.filmOffset,this}setFocalLength(t){const e=.5*this.getFilmHeight()/t;this.fov=2*ur*Math.atan(e),this.updateProjectionMatrix()}getFocalLength(){const t=Math.tan(.5*hr*this.fov);return.5*this.getFilmHeight()/t}getEffectiveFOV(){return 2*ur*Math.atan(Math.tan(.5*hr*this.fov)/this.zoom)}getFilmWidth(){return this.filmGauge*Math.min(this.aspect,1)}getFilmHeight(){return this.filmGauge/Math.max(this.aspect,1)}getViewBounds(t,e,n){es.set(-1,-1,.5).applyMatrix4(this.projectionMatrixInverse),e.set(es.x,es.y).multiplyScalar(-t/es.z),es.set(1,1,.5).applyMatrix4(this.projectionMatrixInverse),n.set(es.x,es.y).multiplyScalar(-t/es.z)}getViewSize(t,e){return this.getViewBounds(t,ns,rs),e.subVectors(rs,ns)}setViewOffset(t,e,n,r,i,a){this.aspect=t/e,null===this.view&&(this.view={enabled:1,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=1,this.view.fullWidth=t,this.view.fullHeight=e,this.view.offsetX=n,this.view.offsetY=r,this.view.width=i,this.view.height=a,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=0),this.updateProjectionMatrix()}updateProjectionMatrix(){const t=this.near;let e=t*Math.tan(.5*hr*this.fov)/this.zoom,n=2*e,r=this.aspect*n,i=-.5*r;const a=this.view;if(null!==this.view&&this.view.enabled){const t=a.fullWidth,s=a.fullHeight;i+=a.offsetX*r/t,e-=a.offsetY*n/s,r*=a.width/t,n*=a.height/s}const s=this.filmOffset;0!==s&&(i+=t*s/this.getFilmWidth()),this.projectionMatrix.makePerspective(i,i+r,e,e-n,t,this.far,this.coordinateSystem,this.reversedDepth),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}toJSON(t){const e=super.toJSON(t);return e.object.fov=this.fov,e.object.zoom=this.zoom,e.object.near=this.near,e.object.far=this.far,e.object.focus=this.focus,e.object.aspect=this.aspect,null!==this.view&&(e.object.view=Object.assign({},this.view)),e.object.filmGauge=this.filmGauge,e.object.filmOffset=this.filmOffset,e}}const as=-90;class ss extends Zi{constructor(t,e,n){super(),this.type="CubeCamera",this.renderTarget=n,this.coordinateSystem=null,this.activeMipmapLevel=0;const r=new is(as,1,t,e);r.layers=this.layers,this.add(r);const i=new is(as,1,t,e);i.layers=this.layers,this.add(i);const a=new is(as,1,t,e);a.layers=this.layers,this.add(a);const s=new is(as,1,t,e);s.layers=this.layers,this.add(s);const o=new is(as,1,t,e);o.layers=this.layers,this.add(o);const l=new is(as,1,t,e);l.layers=this.layers,this.add(l)}updateCoordinateSystem(){const t=this.coordinateSystem,e=this.children.concat(),[n,r,i,a,s,o]=e;for(const t of e)this.remove(t);if(t===ar)n.up.set(0,1,0),n.lookAt(1,0,0),r.up.set(0,1,0),r.lookAt(-1,0,0),i.up.set(0,0,-1),i.lookAt(0,1,0),a.up.set(0,0,1),a.lookAt(0,-1,0),s.up.set(0,1,0),s.lookAt(0,0,1),o.up.set(0,1,0),o.lookAt(0,0,-1);else{if(t!==sr)throw new Error("THREE.CubeCamera.updateCoordinateSystem(): Invalid coordinate system: "+t);n.up.set(0,-1,0),n.lookAt(-1,0,0),r.up.set(0,-1,0),r.lookAt(1,0,0),i.up.set(0,0,1),i.lookAt(0,1,0),a.up.set(0,0,-1),a.lookAt(0,-1,0),s.up.set(0,-1,0),s.lookAt(0,0,1),o.up.set(0,-1,0),o.lookAt(0,0,-1)}for(const t of e)this.add(t),t.updateMatrixWorld()}update(t,e){null===this.parent&&this.updateMatrixWorld();const{renderTarget:n,activeMipmapLevel:r}=this;this.coordinateSystem!==t.coordinateSystem&&(this.coordinateSystem=t.coordinateSystem,this.updateCoordinateSystem());const[i,a,s,o,l,c]=this.children,h=t.getRenderTarget(),u=t.getActiveCubeFace(),d=t.getActiveMipmapLevel(),p=t.xr.enabled;t.xr.enabled=0;const f=n.texture.generateMipmaps;n.texture.generateMipmaps=0,t.setRenderTarget(n,0,r),t.render(e,i),t.setRenderTarget(n,1,r),t.render(e,a),t.setRenderTarget(n,2,r),t.render(e,s),t.setRenderTarget(n,3,r),t.render(e,o),t.setRenderTarget(n,4,r),t.render(e,l),n.texture.generateMipmaps=f,t.setRenderTarget(n,5,r),t.render(e,c),t.setRenderTarget(h,u,d),t.xr.enabled=p,n.texture.needsPMREMUpdate=1}}class os extends Wr{constructor(t=[],e=301,n,r,i,a,s,o,l,c){super(t,e,n,r,i,a,s,o,l,c),this.isCubeTexture=1,this.flipY=0}get images(){return this.image}set images(t){this.image=t}}class ls extends qr{constructor(t=1,e={}){super(t,t,e),this.isWebGLCubeRenderTarget=1;const n={width:t,height:t,depth:1},r=[n,n,n,n,n,n];this.texture=new os(r),this._setTextureOptions(e),this.texture.isRenderTargetTexture=1}fromEquirectangularTexture(t,e){this.texture.type=e.type,this.texture.colorSpace=e.colorSpace,this.texture.generateMipmaps=e.generateMipmaps,this.texture.minFilter=e.minFilter,this.texture.magFilter=e.magFilter;const n={uniforms:{tEquirect:{value:null}},vertexShader:"\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\tvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\n\t\t\t\t\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n\n\t\t\t\t}\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvWorldDirection = transformDirection( position, modelMatrix );\n\n\t\t\t\t\t#include <begin_vertex>\n\t\t\t\t\t#include <project_vertex>\n\n\t\t\t\t}\n\t\t\t",fragmentShader:"\n\n\t\t\t\tuniform sampler2D tEquirect;\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\t#include <common>\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvec3 direction = normalize( vWorldDirection );\n\n\t\t\t\t\tvec2 sampleUV = equirectUv( direction );\n\n\t\t\t\t\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\n\t\t\t\t}\n\t\t\t"},r=new Ya(5,5,5),i=new Qa({name:"CubemapFromEquirect",uniforms:Ka(n.uniforms),vertexShader:n.vertexShader,fragmentShader:n.fragmentShader,side:1,blending:0});i.uniforms.tEquirect.value=e;const a=new ja(r,i),s=e.minFilter;e.minFilter===ke&&(e.minFilter=Fe);return new ss(1,10,this).update(t,a),e.minFilter=s,a.geometry.dispose(),a.material.dispose(),this}clear(t,e=1,n=1,r=1){const i=t.getRenderTarget();for(let i=0;i<6;i++)t.setRenderTarget(this,i),t.clear(e,n,r);t.setRenderTarget(i)}}class cs extends Zi{constructor(){super(),this.isGroup=1,this.type="Group"}}const hs={type:"move"};class us{constructor(){this._targetRay=null,this._grip=null,this._hand=null}getHandSpace(){return null===this._hand&&(this._hand=new cs,this._hand.matrixAutoUpdate=0,this._hand.visible=0,this._hand.joints={},this._hand.inputState={pinching:0}),this._hand}getTargetRaySpace(){return null===this._targetRay&&(this._targetRay=new cs,this._targetRay.matrixAutoUpdate=0,this._targetRay.visible=0,this._targetRay.hasLinearVelocity=0,this._targetRay.linearVelocity=new br,this._targetRay.hasAngularVelocity=0,this._targetRay.angularVelocity=new br),this._targetRay}getGripSpace(){return null===this._grip&&(this._grip=new cs,this._grip.matrixAutoUpdate=0,this._grip.visible=0,this._grip.hasLinearVelocity=0,this._grip.linearVelocity=new br,this._grip.hasAngularVelocity=0,this._grip.angularVelocity=new br),this._grip}dispatchEvent(t){return null!==this._targetRay&&this._targetRay.dispatchEvent(t),null!==this._grip&&this._grip.dispatchEvent(t),null!==this._hand&&this._hand.dispatchEvent(t),this}connect(t){if(t&&t.hand){const e=this._hand;if(e)for(const n of t.hand.values())this._getHandJoint(e,n)}return this.dispatchEvent({type:"connected",data:t}),this}disconnect(t){return this.dispatchEvent({type:"disconnected",data:t}),null!==this._targetRay&&(this._targetRay.visible=0),null!==this._grip&&(this._grip.visible=0),null!==this._hand&&(this._hand.visible=0),this}update(t,e,n){let r=null,i=null,a=null;const s=this._targetRay,o=this._grip,l=this._hand;if(t&&"visible-blurred"!==e.session.visibilityState){if(l&&t.hand){a=1;for(const r of t.hand.values()){const t=e.getJointPose(r,n),i=this._getHandJoint(l,r);null!==t&&(i.matrix.fromArray(t.transform.matrix),i.matrix.decompose(i.position,i.rotation,i.scale),i.matrixWorldNeedsUpdate=1,i.jointRadius=t.radius),i.visible=null!==t}const r=l.joints["index-finger-tip"],i=l.joints["thumb-tip"],s=r.position.distanceTo(i.position),o=.02,c=.005;l.inputState.pinching&&s>o+c?(l.inputState.pinching=0,this.dispatchEvent({type:"pinchend",handedness:t.handedness,target:this})):!l.inputState.pinching&&s<=o-c&&(l.inputState.pinching=1,this.dispatchEvent({type:"pinchstart",handedness:t.handedness,target:this}))}else null!==o&&t.gripSpace&&(i=e.getPose(t.gripSpace,n),null!==i&&(o.matrix.fromArray(i.transform.matrix),o.matrix.decompose(o.position,o.rotation,o.scale),o.matrixWorldNeedsUpdate=1,i.linearVelocity?(o.hasLinearVelocity=1,o.linearVelocity.copy(i.linearVelocity)):o.hasLinearVelocity=0,i.angularVelocity?(o.hasAngularVelocity=1,o.angularVelocity.copy(i.angularVelocity)):o.hasAngularVelocity=0));null!==s&&(r=e.getPose(t.targetRaySpace,n),null===r&&null!==i&&(r=i),null!==r&&(s.matrix.fromArray(r.transform.matrix),s.matrix.decompose(s.position,s.rotation,s.scale),s.matrixWorldNeedsUpdate=1,r.linearVelocity?(s.hasLinearVelocity=1,s.linearVelocity.copy(r.linearVelocity)):s.hasLinearVelocity=0,r.angularVelocity?(s.hasAngularVelocity=1,s.angularVelocity.copy(r.angularVelocity)):s.hasAngularVelocity=0,this.dispatchEvent(hs)))}return null!==s&&(s.visible=null!==r),null!==o&&(o.visible=null!==i),null!==l&&(l.visible=null!==a),this}_getHandJoint(t,e){if(void 0===t.joints[e.jointName]){const n=new cs;n.matrixAutoUpdate=0,n.visible=0,t.joints[e.jointName]=n,t.add(n)}return t.joints[e.jointName]}}class ds extends Zi{constructor(){super(),this.isScene=1,this.type="Scene",this.background=null,this.environment=null,this.fog=null,this.backgroundBlurriness=0,this.backgroundIntensity=1,this.backgroundRotation=new Li,this.environmentIntensity=1,this.environmentRotation=new Li,this.overrideMaterial=null,"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}copy(t,e){return super.copy(t,e),null!==t.background&&(this.background=t.background.clone()),null!==t.environment&&(this.environment=t.environment.clone()),null!==t.fog&&(this.fog=t.fog.clone()),this.backgroundBlurriness=t.backgroundBlurriness,this.backgroundIntensity=t.backgroundIntensity,this.backgroundRotation.copy(t.backgroundRotation),this.environmentIntensity=t.environmentIntensity,this.environmentRotation.copy(t.environmentRotation),null!==t.overrideMaterial&&(this.overrideMaterial=t.overrideMaterial.clone()),this.matrixAutoUpdate=t.matrixAutoUpdate,this}toJSON(t){const e=super.toJSON(t);return null!==this.fog&&(e.object.fog=this.fog.toJSON()),this.backgroundBlurriness>0&&(e.object.backgroundBlurriness=this.backgroundBlurriness),1!==this.backgroundIntensity&&(e.object.backgroundIntensity=this.backgroundIntensity),e.object.backgroundRotation=this.backgroundRotation.toArray(),1!==this.environmentIntensity&&(e.object.environmentIntensity=this.environmentIntensity),e.object.environmentRotation=this.environmentRotation.toArray(),e}}class ps{constructor(t,e){this.isInterleavedBuffer=1,this.array=t,this.stride=e,this.count=void 0!==t?t.length/e:0,this.usage=rr,this.updateRanges=[],this.version=0,this.uuid=dr()}onUploadCallback(){}set needsUpdate(t){1==t&&this.version++}setUsage(t){return this.usage=t,this}addUpdateRange(t,e){this.updateRanges.push({start:t,count:e})}clearUpdateRanges(){this.updateRanges.length=0}copy(t){return this.array=new t.array.constructor(t.array),this.count=t.count,this.stride=t.stride,this.usage=t.usage,this}copyAt(t,e,n){t*=this.stride,n*=e.stride;for(let r=0,i=this.stride;r<i;r++)this.array[t+r]=e.array[n+r];return this}set(t,e=0){return this.array.set(t,e),this}clone(t){void 0===t.arrayBuffers&&(t.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=dr()),void 0===t.arrayBuffers[this.array.buffer._uuid]&&(t.arrayBuffers[this.array.buffer._uuid]=this.array.slice(0).buffer);const e=new this.array.constructor(t.arrayBuffers[this.array.buffer._uuid]),n=new this.constructor(e,this.stride);return n.setUsage(this.usage),n}onUpload(t){return this.onUploadCallback=t,this}toJSON(t){return void 0===t.arrayBuffers&&(t.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=dr()),void 0===t.arrayBuffers[this.array.buffer._uuid]&&(t.arrayBuffers[this.array.buffer._uuid]=Array.from(new Uint32Array(this.array.buffer))),{uuid:this.uuid,buffer:this.array.buffer._uuid,type:this.array.constructor.name,stride:this.stride}}}const fs=new br;class ms{constructor(t,e,n,r=0){this.isInterleavedBufferAttribute=1,this.name="",this.data=t,this.itemSize=e,this.offset=n,this.normalized=r}get count(){return this.data.count}get array(){return this.data.array}set needsUpdate(t){this.data.needsUpdate=t}applyMatrix4(t){for(let e=0,n=this.data.count;e<n;e++)fs.fromBufferAttribute(this,e),fs.applyMatrix4(t),this.setXYZ(e,fs.x,fs.y,fs.z);return this}applyNormalMatrix(t){for(let e=0,n=this.count;e<n;e++)fs.fromBufferAttribute(this,e),fs.applyNormalMatrix(t),this.setXYZ(e,fs.x,fs.y,fs.z);return this}transformDirection(t){for(let e=0,n=this.count;e<n;e++)fs.fromBufferAttribute(this,e),fs.transformDirection(t),this.setXYZ(e,fs.x,fs.y,fs.z);return this}getComponent(t,e){let n=this.array[t*this.data.stride+this.offset+e];return this.normalized&&(n=gr(n,this.array)),n}setComponent(t,e,n){return this.normalized&&(n=vr(n,this.array)),this.data.array[t*this.data.stride+this.offset+e]=n,this}setX(t,e){return this.normalized&&(e=vr(e,this.array)),this.data.array[t*this.data.stride+this.offset]=e,this}setY(t,e){return this.normalized&&(e=vr(e,this.array)),this.data.array[t*this.data.stride+this.offset+1]=e,this}setZ(t,e){return this.normalized&&(e=vr(e,this.array)),this.data.array[t*this.data.stride+this.offset+2]=e,this}setW(t,e){return this.normalized&&(e=vr(e,this.array)),this.data.array[t*this.data.stride+this.offset+3]=e,this}getX(t){let e=this.data.array[t*this.data.stride+this.offset];return this.normalized&&(e=gr(e,this.array)),e}getY(t){let e=this.data.array[t*this.data.stride+this.offset+1];return this.normalized&&(e=gr(e,this.array)),e}getZ(t){let e=this.data.array[t*this.data.stride+this.offset+2];return this.normalized&&(e=gr(e,this.array)),e}getW(t){let e=this.data.array[t*this.data.stride+this.offset+3];return this.normalized&&(e=gr(e,this.array)),e}setXY(t,e,n){return t=t*this.data.stride+this.offset,this.normalized&&(e=vr(e,this.array),n=vr(n,this.array)),this.data.array[t+0]=e,this.data.array[t+1]=n,this}setXYZ(t,e,n,r){return t=t*this.data.stride+this.offset,this.normalized&&(e=vr(e,this.array),n=vr(n,this.array),r=vr(r,this.array)),this.data.array[t+0]=e,this.data.array[t+1]=n,this.data.array[t+2]=r,this}setXYZW(t,e,n,r,i){return t=t*this.data.stride+this.offset,this.normalized&&(e=vr(e,this.array),n=vr(n,this.array),r=vr(r,this.array),i=vr(i,this.array)),this.data.array[t+0]=e,this.data.array[t+1]=n,this.data.array[t+2]=r,this.data.array[t+3]=i,this}clone(t){if(void 0===t){const t=[];for(let e=0;e<this.count;e++){const n=e*this.data.stride+this.offset;for(let e=0;e<this.itemSize;e++)t.push(this.data.array[n+e])}return new Ta(new this.array.constructor(t),this.itemSize,this.normalized)}return void 0===t.interleavedBuffers&&(t.interleavedBuffers={}),void 0===t.interleavedBuffers[this.data.uuid]&&(t.interleavedBuffers[this.data.uuid]=this.data.clone(t)),new ms(t.interleavedBuffers[this.data.uuid],this.itemSize,this.offset,this.normalized)}toJSON(t){if(void 0===t){const t=[];for(let e=0;e<this.count;e++){const n=e*this.data.stride+this.offset;for(let e=0;e<this.itemSize;e++)t.push(this.data.array[n+e])}return{itemSize:this.itemSize,type:this.array.constructor.name,array:t,normalized:this.normalized}}return void 0===t.interleavedBuffers&&(t.interleavedBuffers={}),void 0===t.interleavedBuffers[this.data.uuid]&&(t.interleavedBuffers[this.data.uuid]=this.data.toJSON(t)),{isInterleavedBufferAttribute:1,itemSize:this.itemSize,data:this.data.uuid,offset:this.offset,normalized:this.normalized}}}const gs=new br,vs=new Xr,xs=new Xr,_s=new br,ys=new Ti,bs=new br,Es=new fi,Ts=new Ti,Ss=new Ei;class Ms extends ja{constructor(t,e){super(t,e),this.isSkinnedMesh=1,this.type="SkinnedMesh",this.bindMode=Me,this.bindMatrix=new Ti,this.bindMatrixInverse=new Ti,this.boundingBox=null,this.boundingSphere=null}computeBoundingBox(){const t=this.geometry;null===this.boundingBox&&(this.boundingBox=new Zr),this.boundingBox.makeEmpty();const e=t.getAttribute("position");for(let t=0;t<e.count;t++)this.getVertexPosition(t,bs),this.boundingBox.expandByPoint(bs)}computeBoundingSphere(){const t=this.geometry;null===this.boundingSphere&&(this.boundingSphere=new fi),this.boundingSphere.makeEmpty();const e=t.getAttribute("position");for(let t=0;t<e.count;t++)this.getVertexPosition(t,bs),this.boundingSphere.expandByPoint(bs)}copy(t,e){return super.copy(t,e),this.bindMode=t.bindMode,this.bindMatrix.copy(t.bindMatrix),this.bindMatrixInverse.copy(t.bindMatrixInverse),this.skeleton=t.skeleton,null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),this}raycast(t,e){const n=this.material,r=this.matrixWorld;void 0!==n&&(null===this.boundingSphere&&this.computeBoundingSphere(),Es.copy(this.boundingSphere),Es.applyMatrix4(r),0!=t.ray.intersectsSphere(Es)&&(Ts.copy(r).invert(),Ss.copy(t.ray).applyMatrix4(Ts),null!==this.boundingBox&&0==Ss.intersectsBox(this.boundingBox)||this._computeIntersections(t,e,Ss)))}getVertexPosition(t,e){return super.getVertexPosition(t,e),this.applyBoneTransform(t,e),e}bind(t,e){this.skeleton=t,void 0===e&&(this.updateMatrixWorld(1),this.skeleton.calculateInverses(),e=this.matrixWorld),this.bindMatrix.copy(e),this.bindMatrixInverse.copy(e).invert()}pose(){this.skeleton.pose()}normalizeSkinWeights(){const t=new Xr,e=this.geometry.attributes.skinWeight;for(let n=0,r=e.count;n<r;n++){t.fromBufferAttribute(e,n);const r=1/t.manhattanLength();r!==1/0?t.multiplyScalar(r):t.set(1,0,0,0),e.setXYZW(n,t.x,t.y,t.z,t.w)}}updateMatrixWorld(t){super.updateMatrixWorld(t),this.bindMode===Me?this.bindMatrixInverse.copy(this.matrixWorld).invert():"detached"===this.bindMode&&this.bindMatrixInverse.copy(this.bindMatrix).invert()}applyBoneTransform(t,e){const n=this.skeleton,r=this.geometry;vs.fromBufferAttribute(r.attributes.skinIndex,t),xs.fromBufferAttribute(r.attributes.skinWeight,t),gs.copy(e).applyMatrix4(this.bindMatrix),e.set(0,0,0);for(let t=0;t<4;t++){const r=xs.getComponent(t);if(0!==r){const i=vs.getComponent(t);ys.multiplyMatrices(n.bones[i].matrixWorld,n.boneInverses[i]),e.addScaledVector(_s.copy(gs).applyMatrix4(ys),r)}}return e.applyMatrix4(this.bindMatrixInverse)}}class ws extends Zi{constructor(){super(),this.isBone=1,this.type="Bone"}}class Rs extends Wr{constructor(t=null,e=1,n=1,r,i,a,s,o,l=1003,c=1003,h,u){super(null,a,s,o,l,c,r,i,h,u),this.isDataTexture=1,this.image={data:t,width:e,height:n},this.generateMipmaps=0,this.flipY=0,this.unpackAlignment=1}}const As=new Ti,Cs=new Ti;class Ps{constructor(t=[],e=[]){this.uuid=dr(),this.bones=t.slice(0),this.boneInverses=e,this.boneMatrices=null,this.boneTexture=null,this.init()}init(){const t=this.bones,e=this.boneInverses;if(this.boneMatrices=new Float32Array(16*t.length),0===e.length)this.calculateInverses();else if(t.length!==e.length){this.boneInverses=[];for(let t=0,e=this.bones.length;t<e;t++)this.boneInverses.push(new Ti)}}calculateInverses(){this.boneInverses.length=0;for(let t=0,e=this.bones.length;t<e;t++){const e=new Ti;this.bones[t]&&e.copy(this.bones[t].matrixWorld).invert(),this.boneInverses.push(e)}}pose(){for(let t=0,e=this.bones.length;t<e;t++){const e=this.bones[t];e&&e.matrixWorld.copy(this.boneInverses[t]).invert()}for(let t=0,e=this.bones.length;t<e;t++){const e=this.bones[t];e&&(e.parent&&e.parent.isBone?(e.matrix.copy(e.parent.matrixWorld).invert(),e.matrix.multiply(e.matrixWorld)):e.matrix.copy(e.matrixWorld),e.matrix.decompose(e.position,e.quaternion,e.scale))}}update(){const t=this.bones,e=this.boneInverses,n=this.boneMatrices,r=this.boneTexture;for(let r=0,i=t.length;r<i;r++){const i=t[r]?t[r].matrixWorld:Cs;As.multiplyMatrices(i,e[r]),As.toArray(n,16*r)}null!==r&&(r.needsUpdate=1)}clone(){return new Ps(this.bones,this.boneInverses)}computeBoneTexture(){let t=Math.sqrt(4*this.bones.length);t=4*Math.ceil(t/4),t=Math.max(t,4);const e=new Float32Array(t*t*4);e.set(this.boneMatrices);const n=new Rs(e,t,t,Je,je);return n.needsUpdate=1,this.boneMatrices=e,this.boneTexture=n,this}getBoneByName(t){for(let e=0,n=this.bones.length;e<n;e++){const n=this.bones[e];if(n.name===t)return n}}dispose(){null!==this.boneTexture&&(this.boneTexture.dispose(),this.boneTexture=null)}fromJSON(t,e){this.uuid=t.uuid;for(let n=0,r=t.bones.length;n<r;n++){let r=e[t.bones[n]];void 0===r&&(r=new ws),this.bones.push(r),this.boneInverses.push((new Ti).fromArray(t.boneInverses[n]))}return this.init(),this}toJSON(){const t={metadata:{version:4.7,type:"Skeleton",generator:"Skeleton.toJSON"},bones:[],boneInverses:[]};t.uuid=this.uuid;const e=this.bones,n=this.boneInverses;for(let r=0,i=e.length;r<i;r++){const i=e[r];t.bones.push(i.uuid);const a=n[r];t.boneInverses.push(a.toArray())}return t}}class Ds extends Ta{constructor(t,e,n,r=1){super(t,e,n),this.isInstancedBufferAttribute=1,this.meshPerAttribute=r}copy(t){return super.copy(t),this.meshPerAttribute=t.meshPerAttribute,this}toJSON(){const t=super.toJSON();return t.meshPerAttribute=this.meshPerAttribute,t.isInstancedBufferAttribute=1,t}}const Us=new Ti,Ls=new Ti,Is=[],Ns=new Zr,Os=new Ti,Fs=new ja,Bs=new fi;class ks extends ja{constructor(t,e,n){super(t,e),this.isInstancedMesh=1,this.instanceMatrix=new Ds(new Float32Array(16*n),16),this.instanceColor=null,this.morphTexture=null,this.count=n,this.boundingBox=null,this.boundingSphere=null;for(let t=0;t<n;t++)this.setMatrixAt(t,Os)}computeBoundingBox(){const t=this.geometry,e=this.count;null===this.boundingBox&&(this.boundingBox=new Zr),null===t.boundingBox&&t.computeBoundingBox(),this.boundingBox.makeEmpty();for(let n=0;n<e;n++)this.getMatrixAt(n,Us),Ns.copy(t.boundingBox).applyMatrix4(Us),this.boundingBox.union(Ns)}computeBoundingSphere(){const t=this.geometry,e=this.count;null===this.boundingSphere&&(this.boundingSphere=new fi),null===t.boundingSphere&&t.computeBoundingSphere(),this.boundingSphere.makeEmpty();for(let n=0;n<e;n++)this.getMatrixAt(n,Us),Bs.copy(t.boundingSphere).applyMatrix4(Us),this.boundingSphere.union(Bs)}copy(t,e){return super.copy(t,e),this.instanceMatrix.copy(t.instanceMatrix),null!==t.morphTexture&&(this.morphTexture=t.morphTexture.clone()),null!==t.instanceColor&&(this.instanceColor=t.instanceColor.clone()),this.count=t.count,null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),this}getColorAt(t,e){e.fromArray(this.instanceColor.array,3*t)}getMatrixAt(t,e){e.fromArray(this.instanceMatrix.array,16*t)}getMorphAt(t,e){const n=e.morphTargetInfluences,r=this.morphTexture.source.data.data,i=t*(n.length+1)+1;for(let t=0;t<n.length;t++)n[t]=r[i+t]}raycast(t,e){const n=this.matrixWorld,r=this.count;if(Fs.geometry=this.geometry,Fs.material=this.material,void 0!==Fs.material&&(null===this.boundingSphere&&this.computeBoundingSphere(),Bs.copy(this.boundingSphere),Bs.applyMatrix4(n),0!=t.ray.intersectsSphere(Bs)))for(let i=0;i<r;i++){this.getMatrixAt(i,Us),Ls.multiplyMatrices(n,Us),Fs.matrixWorld=Ls,Fs.raycast(t,Is);for(let t=0,n=Is.length;t<n;t++){const n=Is[t];n.instanceId=i,n.object=this,e.push(n)}Is.length=0}}setColorAt(t,e){null===this.instanceColor&&(this.instanceColor=new Ds(new Float32Array(3*this.instanceMatrix.count).fill(1),3)),e.toArray(this.instanceColor.array,3*t)}setMatrixAt(t,e){e.toArray(this.instanceMatrix.array,16*t)}setMorphAt(t,e){const n=e.morphTargetInfluences,r=n.length+1;null===this.morphTexture&&(this.morphTexture=new Rs(new Float32Array(r*this.count),r,this.count,en,je));const i=this.morphTexture.source.data.data;let a=0;for(let t=0;t<n.length;t++)a+=n[t];const s=this.geometry.morphTargetsRelative?1:1-a,o=r*t;i[o]=s,i.set(n,o+1)}updateMorphTargets(){}dispose(){this.dispatchEvent({type:"dispose"}),null!==this.morphTexture&&(this.morphTexture.dispose(),this.morphTexture=null)}}const zs=new br,Vs=new br,Hs=new Sr;class Gs{constructor(t=new br(1,0,0),e=0){this.isPlane=1,this.normal=t,this.constant=e}set(t,e){return this.normal.copy(t),this.constant=e,this}setComponents(t,e,n,r){return this.normal.set(t,e,n),this.constant=r,this}setFromNormalAndCoplanarPoint(t,e){return this.normal.copy(t),this.constant=-e.dot(this.normal),this}setFromCoplanarPoints(t,e,n){const r=zs.subVectors(n,e).cross(Vs.subVectors(t,e)).normalize();return this.setFromNormalAndCoplanarPoint(r,t),this}copy(t){return this.normal.copy(t.normal),this.constant=t.constant,this}normalize(){const t=1/this.normal.length();return this.normal.multiplyScalar(t),this.constant*=t,this}negate(){return this.constant*=-1,this.normal.negate(),this}distanceToPoint(t){return this.normal.dot(t)+this.constant}distanceToSphere(t){return this.distanceToPoint(t.center)-t.radius}projectPoint(t,e){return e.copy(t).addScaledVector(this.normal,-this.distanceToPoint(t))}intersectLine(t,e){const n=t.delta(zs),r=this.normal.dot(n);if(0===r)return 0===this.distanceToPoint(t.start)?e.copy(t.start):null;const i=-(t.start.dot(this.normal)+this.constant)/r;return i<0||i>1?null:e.copy(t.start).addScaledVector(n,i)}intersectsLine(t){const e=this.distanceToPoint(t.start),n=this.distanceToPoint(t.end);return e<0&&n>0||n<0&&e>0}intersectsBox(t){return t.intersectsPlane(this)}intersectsSphere(t){return t.intersectsPlane(this)}coplanarPoint(t){return t.copy(this.normal).multiplyScalar(-this.constant)}applyMatrix4(t,e){const n=e||Hs.getNormalMatrix(t),r=this.coplanarPoint(zs).applyMatrix4(t),i=this.normal.applyMatrix3(n).normalize();return this.constant=-r.dot(i),this}translate(t){return this.constant-=t.dot(this.normal),this}equals(t){return t.normal.equals(this.normal)&&t.constant===this.constant}clone(){return(new this.constructor).copy(this)}}const Ws=new fi,Xs=new _r(.5,.5),js=new br;class qs{constructor(t=new Gs,e=new Gs,n=new Gs,r=new Gs,i=new Gs,a=new Gs){this.planes=[t,e,n,r,i,a]}set(t,e,n,r,i,a){const s=this.planes;return s[0].copy(t),s[1].copy(e),s[2].copy(n),s[3].copy(r),s[4].copy(i),s[5].copy(a),this}copy(t){const e=this.planes;for(let n=0;n<6;n++)e[n].copy(t.planes[n]);return this}setFromProjectionMatrix(t,e=2e3,n=0){const r=this.planes,i=t.elements,a=i[0],s=i[1],o=i[2],l=i[3],c=i[4],h=i[5],u=i[6],d=i[7],p=i[8],f=i[9],m=i[10],g=i[11],v=i[12],x=i[13],_=i[14],y=i[15];if(r[0].setComponents(l-a,d-c,g-p,y-v).normalize(),r[1].setComponents(l+a,d+c,g+p,y+v).normalize(),r[2].setComponents(l+s,d+h,g+f,y+x).normalize(),r[3].setComponents(l-s,d-h,g-f,y-x).normalize(),n)r[4].setComponents(o,u,m,_).normalize(),r[5].setComponents(l-o,d-u,g-m,y-_).normalize();else if(r[4].setComponents(l-o,d-u,g-m,y-_).normalize(),e===ar)r[5].setComponents(l+o,d+u,g+m,y+_).normalize();else{if(e!==sr)throw new Error("THREE.Frustum.setFromProjectionMatrix(): Invalid coordinate system: "+e);r[5].setComponents(o,u,m,_).normalize()}return this}intersectsObject(t){if(void 0!==t.boundingSphere)null===t.boundingSphere&&t.computeBoundingSphere(),Ws.copy(t.boundingSphere).applyMatrix4(t.matrixWorld);else{const e=t.geometry;null===e.boundingSphere&&e.computeBoundingSphere(),Ws.copy(e.boundingSphere).applyMatrix4(t.matrixWorld)}return this.intersectsSphere(Ws)}intersectsSprite(t){Ws.center.set(0,0,0);const e=Xs.distanceTo(t.center);return Ws.radius=.7071067811865476+e,Ws.applyMatrix4(t.matrixWorld),this.intersectsSphere(Ws)}intersectsSphere(t){const e=this.planes,n=t.center,r=-t.radius;for(let t=0;t<6;t++){if(e[t].distanceToPoint(n)<r)return 0}return 1}intersectsBox(t){const e=this.planes;for(let n=0;n<6;n++){const r=e[n];if(js.x=r.normal.x>0?t.max.x:t.min.x,js.y=r.normal.y>0?t.max.y:t.min.y,js.z=r.normal.z>0?t.max.z:t.min.z,r.distanceToPoint(js)<0)return 0}return 1}containsPoint(t){const e=this.planes;for(let n=0;n<6;n++)if(e[n].distanceToPoint(t)<0)return 0;return 1}clone(){return(new this.constructor).copy(this)}}class Ys extends xa{constructor(t){super(),this.isLineBasicMaterial=1,this.type="LineBasicMaterial",this.color=new ma(16777215),this.map=null,this.linewidth=1,this.linecap="round",this.linejoin="round",this.fog=1,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.linewidth=t.linewidth,this.linecap=t.linecap,this.linejoin=t.linejoin,this.fog=t.fog,this}}const Ks=new br,Zs=new br,$s=new Ti,Js=new Ei,Qs=new fi,to=new br,eo=new br;class no extends Zi{constructor(t=new Ia,e=new Ys){super(),this.isLine=1,this.type="Line",this.geometry=t,this.material=e,this.morphTargetDictionary=void 0,this.morphTargetInfluences=void 0,this.updateMorphTargets()}copy(t,e){return super.copy(t,e),this.material=Array.isArray(t.material)?t.material.slice():t.material,this.geometry=t.geometry,this}computeLineDistances(){const t=this.geometry;if(null===t.index){const e=t.attributes.position,n=[0];for(let t=1,r=e.count;t<r;t++)Ks.fromBufferAttribute(e,t-1),Zs.fromBufferAttribute(e,t),n[t]=n[t-1],n[t]+=Ks.distanceTo(Zs);t.setAttribute("lineDistance",new wa(n,1))}return this}raycast(t,e){const n=this.geometry,r=this.matrixWorld,i=t.params.Line.threshold,a=n.drawRange;if(null===n.boundingSphere&&n.computeBoundingSphere(),Qs.copy(n.boundingSphere),Qs.applyMatrix4(r),Qs.radius+=i,0==t.ray.intersectsSphere(Qs))return;$s.copy(r).invert(),Js.copy(t.ray).applyMatrix4($s);const s=i/((this.scale.x+this.scale.y+this.scale.z)/3),o=s*s,l=this.isLineSegments?2:1,c=n.index,h=n.attributes.position;if(null!==c){const n=Math.max(0,a.start),r=Math.min(c.count,a.start+a.count);for(let i=n,a=r-1;i<a;i+=l){const n=c.getX(i),r=c.getX(i+1),a=ro(this,t,Js,o,n,r,i);a&&e.push(a)}if(this.isLineLoop){const i=c.getX(r-1),a=c.getX(n),s=ro(this,t,Js,o,i,a,r-1);s&&e.push(s)}}else{const n=Math.max(0,a.start),r=Math.min(h.count,a.start+a.count);for(let i=n,a=r-1;i<a;i+=l){const n=ro(this,t,Js,o,i,i+1,i);n&&e.push(n)}if(this.isLineLoop){const i=ro(this,t,Js,o,r-1,n,r-1);i&&e.push(i)}}}updateMorphTargets(){const t=this.geometry.morphAttributes,e=Object.keys(t);if(e.length>0){const n=t[e[0]];if(void 0!==n){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,e=n.length;t<e;t++){const e=n[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[e]=t}}}}}function ro(t,e,n,r,i,a,s){const o=t.geometry.attributes.position;Ks.fromBufferAttribute(o,i),Zs.fromBufferAttribute(o,a);if(n.distanceSqToSegment(Ks,Zs,to,eo)>r)return;to.applyMatrix4(t.matrixWorld);const l=e.ray.origin.distanceTo(to);return l<e.near||l>e.far?void 0:{distance:l,point:eo.clone().applyMatrix4(t.matrixWorld),index:s,face:null,faceIndex:null,barycoord:null,object:t}}const io=new br,ao=new br;class so extends no{constructor(t,e){super(t,e),this.isLineSegments=1,this.type="LineSegments"}computeLineDistances(){const t=this.geometry;if(null===t.index){const e=t.attributes.position,n=[];for(let t=0,r=e.count;t<r;t+=2)io.fromBufferAttribute(e,t),ao.fromBufferAttribute(e,t+1),n[t]=0===t?0:n[t-1],n[t+1]=n[t]+io.distanceTo(ao);t.setAttribute("lineDistance",new wa(n,1))}return this}}class oo extends no{constructor(t,e){super(t,e),this.isLineLoop=1,this.type="LineLoop"}}class lo extends xa{constructor(t){super(),this.isPointsMaterial=1,this.type="PointsMaterial",this.color=new ma(16777215),this.map=null,this.alphaMap=null,this.size=1,this.sizeAttenuation=1,this.fog=1,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.alphaMap=t.alphaMap,this.size=t.size,this.sizeAttenuation=t.sizeAttenuation,this.fog=t.fog,this}}const co=new Ti,ho=new Ei,uo=new fi,po=new br;class fo extends Zi{constructor(t=new Ia,e=new lo){super(),this.isPoints=1,this.type="Points",this.geometry=t,this.material=e,this.morphTargetDictionary=void 0,this.morphTargetInfluences=void 0,this.updateMorphTargets()}copy(t,e){return super.copy(t,e),this.material=Array.isArray(t.material)?t.material.slice():t.material,this.geometry=t.geometry,this}raycast(t,e){const n=this.geometry,r=this.matrixWorld,i=t.params.Points.threshold,a=n.drawRange;if(null===n.boundingSphere&&n.computeBoundingSphere(),uo.copy(n.boundingSphere),uo.applyMatrix4(r),uo.radius+=i,0==t.ray.intersectsSphere(uo))return;co.copy(r).invert(),ho.copy(t.ray).applyMatrix4(co);const s=i/((this.scale.x+this.scale.y+this.scale.z)/3),o=s*s,l=n.index,c=n.attributes.position;if(null!==l){for(let n=Math.max(0,a.start),i=Math.min(l.count,a.start+a.count);n<i;n++){const i=l.getX(n);po.fromBufferAttribute(c,i),mo(po,i,o,r,t,e,this)}}else{for(let n=Math.max(0,a.start),i=Math.min(c.count,a.start+a.count);n<i;n++)po.fromBufferAttribute(c,n),mo(po,n,o,r,t,e,this)}}updateMorphTargets(){const t=this.geometry.morphAttributes,e=Object.keys(t);if(e.length>0){const n=t[e[0]];if(void 0!==n){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,e=n.length;t<e;t++){const e=n[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[e]=t}}}}}function mo(t,e,n,r,i,a,s){const o=ho.distanceSqToPoint(t);if(o<n){const n=new br;ho.closestPointToPoint(t,n),n.applyMatrix4(r);const l=i.ray.origin.distanceTo(n);if(l<i.near||l>i.far)return;a.push({distance:l,distanceToRay:Math.sqrt(o),point:n,index:e,face:null,faceIndex:null,barycoord:null,object:s})}}class go extends Wr{constructor(t,e,n=1014,r,i,a,s=1003,o=1003,l,c=1026,h=1){if(c!==Qe&&c!==tn)throw new Error("DepthTexture format must be either THREE.DepthFormat or THREE.DepthStencilFormat");super({width:t,height:e,depth:h},r,i,a,s,o,c,n,l),this.isDepthTexture=1,this.flipY=0,this.generateMipmaps=0,this.compareFunction=null}copy(t){return super.copy(t),this.source=new zr(Object.assign({},t.image)),this.compareFunction=t.compareFunction,this}toJSON(t){const e=super.toJSON(t);return null!==this.compareFunction&&(e.compareFunction=this.compareFunction),e}}class vo extends Ia{constructor(t=1,e=1,n=1,r=1){super(),this.type="PlaneGeometry",this.parameters={width:t,height:e,widthSegments:n,heightSegments:r};const i=t/2,a=e/2,s=Math.floor(n),o=Math.floor(r),l=s+1,c=o+1,h=t/s,u=e/o,d=[],p=[],f=[],m=[];for(let t=0;t<c;t++){const e=t*u-a;for(let n=0;n<l;n++){const r=n*h-i;p.push(r,-e,0),f.push(0,0,1),m.push(n/s),m.push(1-t/o)}}for(let t=0;t<o;t++)for(let e=0;e<s;e++){const n=e+l*t,r=e+l*(t+1),i=e+1+l*(t+1),a=e+1+l*t;d.push(n,r,a),d.push(r,i,a)}this.setIndex(d),this.setAttribute("position",new wa(p,3)),this.setAttribute("normal",new wa(f,3)),this.setAttribute("uv",new wa(m,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new vo(t.width,t.height,t.widthSegments,t.heightSegments)}}class xo extends Ia{constructor(t=1,e=32,n=16,r=0,i=2*Math.PI,a=0,s=Math.PI){super(),this.type="SphereGeometry",this.parameters={radius:t,widthSegments:e,heightSegments:n,phiStart:r,phiLength:i,thetaStart:a,thetaLength:s},e=Math.max(3,Math.floor(e)),n=Math.max(2,Math.floor(n));const o=Math.min(a+s,Math.PI);let l=0;const c=[],h=new br,u=new br,d=[],p=[],f=[],m=[];for(let d=0;d<=n;d++){const g=[],v=d/n;let x=0;0===d&&0===a?x=.5/e:d===n&&o===Math.PI&&(x=-.5/e);for(let n=0;n<=e;n++){const o=n/e;h.x=-t*Math.cos(r+o*i)*Math.sin(a+v*s),h.y=t*Math.cos(a+v*s),h.z=t*Math.sin(r+o*i)*Math.sin(a+v*s),p.push(h.x,h.y,h.z),u.copy(h).normalize(),f.push(u.x,u.y,u.z),m.push(o+x,1-v),g.push(l++)}c.push(g)}for(let t=0;t<n;t++)for(let r=0;r<e;r++){const e=c[t][r+1],i=c[t][r],s=c[t+1][r],l=c[t+1][r+1];(0!==t||a>0)&&d.push(e,i,l),(t!==n-1||o<Math.PI)&&d.push(i,s,l)}this.setIndex(d),this.setAttribute("position",new wa(p,3)),this.setAttribute("normal",new wa(f,3)),this.setAttribute("uv",new wa(m,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new xo(t.radius,t.widthSegments,t.heightSegments,t.phiStart,t.phiLength,t.thetaStart,t.thetaLength)}}class _o extends xa{constructor(t){super(),this.isMeshStandardMaterial=1,this.type="MeshStandardMaterial",this.defines={STANDARD:""},this.color=new ma(16777215),this.roughness=1,this.metalness=0,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new ma(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new _r(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.roughnessMap=null,this.metalnessMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Li,this.envMapIntensity=1,this.wireframe=0,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=0,this.fog=1,this.setValues(t)}copy(t){return super.copy(t),this.defines={STANDARD:""},this.color.copy(t.color),this.roughness=t.roughness,this.metalness=t.metalness,this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.roughnessMap=t.roughnessMap,this.metalnessMap=t.metalnessMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapRotation.copy(t.envMapRotation),this.envMapIntensity=t.envMapIntensity,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.flatShading=t.flatShading,this.fog=t.fog,this}}class yo extends _o{constructor(t){super(),this.isMeshPhysicalMaterial=1,this.defines={STANDARD:"",PHYSICAL:""},this.type="MeshPhysicalMaterial",this.anisotropyRotation=0,this.anisotropyMap=null,this.clearcoatMap=null,this.clearcoatRoughness=0,this.clearcoatRoughnessMap=null,this.clearcoatNormalScale=new _r(1,1),this.clearcoatNormalMap=null,this.ior=1.5,Object.defineProperty(this,"reflectivity",{get:function(){return pr(2.5*(this.ior-1)/(this.ior+1),0,1)},set:function(t){this.ior=(1+.4*t)/(1-.4*t)}}),this.iridescenceMap=null,this.iridescenceIOR=1.3,this.iridescenceThicknessRange=[100,400],this.iridescenceThicknessMap=null,this.sheenColor=new ma(0),this.sheenColorMap=null,this.sheenRoughness=1,this.sheenRoughnessMap=null,this.transmissionMap=null,this.thickness=0,this.thicknessMap=null,this.attenuationDistance=1/0,this.attenuationColor=new ma(1,1,1),this.specularIntensity=1,this.specularIntensityMap=null,this.specularColor=new ma(1,1,1),this.specularColorMap=null,this._anisotropy=0,this._clearcoat=0,this._dispersion=0,this._iridescence=0,this._sheen=0,this._transmission=0,this.setValues(t)}get anisotropy(){return this._anisotropy}set anisotropy(t){this._anisotropy>0!=t>0&&this.version++,this._anisotropy=t}get clearcoat(){return this._clearcoat}set clearcoat(t){this._clearcoat>0!=t>0&&this.version++,this._clearcoat=t}get iridescence(){return this._iridescence}set iridescence(t){this._iridescence>0!=t>0&&this.version++,this._iridescence=t}get dispersion(){return this._dispersion}set dispersion(t){this._dispersion>0!=t>0&&this.version++,this._dispersion=t}get sheen(){return this._sheen}set sheen(t){this._sheen>0!=t>0&&this.version++,this._sheen=t}get transmission(){return this._transmission}set transmission(t){this._transmission>0!=t>0&&this.version++,this._transmission=t}copy(t){return super.copy(t),this.defines={STANDARD:"",PHYSICAL:""},this.anisotropy=t.anisotropy,this.anisotropyRotation=t.anisotropyRotation,this.anisotropyMap=t.anisotropyMap,this.clearcoat=t.clearcoat,this.clearcoatMap=t.clearcoatMap,this.clearcoatRoughness=t.clearcoatRoughness,this.clearcoatRoughnessMap=t.clearcoatRoughnessMap,this.clearcoatNormalMap=t.clearcoatNormalMap,this.clearcoatNormalScale.copy(t.clearcoatNormalScale),this.dispersion=t.dispersion,this.ior=t.ior,this.iridescence=t.iridescence,this.iridescenceMap=t.iridescenceMap,this.iridescenceIOR=t.iridescenceIOR,this.iridescenceThicknessRange=[...t.iridescenceThicknessRange],this.iridescenceThicknessMap=t.iridescenceThicknessMap,this.sheen=t.sheen,this.sheenColor.copy(t.sheenColor),this.sheenColorMap=t.sheenColorMap,this.sheenRoughness=t.sheenRoughness,this.sheenRoughnessMap=t.sheenRoughnessMap,this.transmission=t.transmission,this.transmissionMap=t.transmissionMap,this.thickness=t.thickness,this.thicknessMap=t.thicknessMap,this.attenuationDistance=t.attenuationDistance,this.attenuationColor.copy(t.attenuationColor),this.specularIntensity=t.specularIntensity,this.specularIntensityMap=t.specularIntensityMap,this.specularColor.copy(t.specularColor),this.specularColorMap=t.specularColorMap,this}}class bo extends xa{constructor(t){super(),this.isMeshDepthMaterial=1,this.type="MeshDepthMaterial",this.depthPacking=3200,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=0,this.wireframeLinewidth=1,this.setValues(t)}copy(t){return super.copy(t),this.depthPacking=t.depthPacking,this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this}}class Eo extends xa{constructor(t){super(),this.isMeshDistanceMaterial=1,this.type="MeshDistanceMaterial",this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.setValues(t)}copy(t){return super.copy(t),this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this}}function To(t,e){return t&&t.constructor!==e?"number"==typeof e.BYTES_PER_ELEMENT?new e(t):Array.prototype.slice.call(t):t}function So(t){return ArrayBuffer.isView(t)&&!(t instanceof DataView)}function Mo(t){const e=t.length,n=new Array(e);for(let t=0;t!==e;++t)n[t]=t;return n.sort(function(e,n){return t[e]-t[n]}),n}function wo(t,e,n){const r=t.length,i=new t.constructor(r);for(let a=0,s=0;s!==r;++a){const r=n[a]*e;for(let n=0;n!==e;++n)i[s++]=t[r+n]}return i}function Ro(t,e,n,r){let i=1,a=t[0];for(;void 0!==a&&void 0===a[r];)a=t[i++];if(void 0===a)return;let s=a[r];if(void 0!==s)if(Array.isArray(s))do{s=a[r],void 0!==s&&(e.push(a.time),n.push(...s)),a=t[i++]}while(void 0!==a);else if(void 0!==s.toArray)do{s=a[r],void 0!==s&&(e.push(a.time),s.toArray(n,n.length)),a=t[i++]}while(void 0!==a);else do{s=a[r],void 0!==s&&(e.push(a.time),n.push(s)),a=t[i++]}while(void 0!==a)}class Ao{constructor(t,e,n,r){this.parameterPositions=t,this._cachedIndex=0,this.resultBuffer=void 0!==r?r:new e.constructor(n),this.sampleValues=e,this.valueSize=n,this.settings=null,this.DefaultSettings_={}}evaluate(t){const e=this.parameterPositions;let n=this._cachedIndex,r=e[n],i=e[n-1];t:{e:{let a;n:{r:if(!(t<r)){for(let a=n+2;;){if(void 0===r){if(t<i)break r;return n=e.length,this._cachedIndex=n,this.copySampleValue_(n-1)}if(n===a)break;if(i=r,r=e[++n],t<r)break e}a=e.length;break n}if(!(t>=i)){const s=e[1];t<s&&(n=2,i=s);for(let a=n-2;;){if(void 0===i)return this._cachedIndex=0,this.copySampleValue_(0);if(n===a)break;if(r=i,i=e[--n-1],t>=i)break e}a=n,n=0;break n}break t}for(;n<a;){const r=n+a>>>1;t<e[r]?a=r:n=r+1}if(r=e[n],i=e[n-1],void 0===i)return this._cachedIndex=0,this.copySampleValue_(0);if(void 0===r)return n=e.length,this._cachedIndex=n,this.copySampleValue_(n-1)}this._cachedIndex=n,this.intervalChanged_(n,i,r)}return this.interpolate_(n,i,t,r)}getSettings_(){return this.settings||this.DefaultSettings_}copySampleValue_(t){const e=this.resultBuffer,n=this.sampleValues,r=this.valueSize,i=t*r;for(let t=0;t!==r;++t)e[t]=n[i+t];return e}interpolate_(){throw new Error("call to abstract method")}intervalChanged_(){}}class Co extends Ao{constructor(t,e,n,r){super(t,e,n,r),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0,this.DefaultSettings_={endingStart:zn,endingEnd:zn}}intervalChanged_(t,e,n){const r=this.parameterPositions;let i=t-2,a=t+1,s=r[i],o=r[a];if(void 0===s)switch(this.getSettings_().endingStart){case Vn:i=t,s=2*e-n;break;case Hn:i=r.length-2,s=e+r[i]-r[i+1];break;default:i=t,s=n}if(void 0===o)switch(this.getSettings_().endingEnd){case Vn:a=t,o=2*n-e;break;case Hn:a=1,o=n+r[1]-r[0];break;default:a=t-1,o=e}const l=.5*(n-e),c=this.valueSize;this._weightPrev=l/(e-s),this._weightNext=l/(o-n),this._offsetPrev=i*c,this._offsetNext=a*c}interpolate_(t,e,n,r){const i=this.resultBuffer,a=this.sampleValues,s=this.valueSize,o=t*s,l=o-s,c=this._offsetPrev,h=this._offsetNext,u=this._weightPrev,d=this._weightNext,p=(n-e)/(r-e),f=p*p,m=f*p,g=-u*m+2*u*f-u*p,v=(1+u)*m+(-1.5-2*u)*f+(-.5+u)*p+1,x=(-1-d)*m+(1.5+d)*f+.5*p,_=d*m-d*f;for(let t=0;t!==s;++t)i[t]=g*a[c+t]+v*a[l+t]+x*a[o+t]+_*a[h+t];return i}}class Po extends Ao{constructor(t,e,n,r){super(t,e,n,r)}interpolate_(t,e,n,r){const i=this.resultBuffer,a=this.sampleValues,s=this.valueSize,o=t*s,l=o-s,c=(n-e)/(r-e),h=1-c;for(let t=0;t!==s;++t)i[t]=a[l+t]*h+a[o+t]*c;return i}}class Do extends Ao{constructor(t,e,n,r){super(t,e,n,r)}interpolate_(t){return this.copySampleValue_(t-1)}}class Uo{constructor(t,e,n,r){if(void 0===t)throw new Error("THREE.KeyframeTrack: track name is undefined");if(void 0===e||0===e.length)throw new Error("THREE.KeyframeTrack: no keyframes in track named "+t);this.name=t,this.times=To(e,this.TimeBufferType),this.values=To(n,this.ValueBufferType),this.setInterpolation(r||this.DefaultInterpolation)}static toJSON(t){const e=t.constructor;let n;if(e.toJSON!==this.toJSON)n=e.toJSON(t);else{n={name:t.name,times:To(t.times,Array),values:To(t.values,Array)};const e=t.getInterpolation();e!==t.DefaultInterpolation&&(n.interpolation=e)}return n.type=t.ValueTypeName,n}InterpolantFactoryMethodDiscrete(t){return new Do(this.times,this.values,this.getValueSize(),t)}InterpolantFactoryMethodLinear(t){return new Po(this.times,this.values,this.getValueSize(),t)}InterpolantFactoryMethodSmooth(t){return new Co(this.times,this.values,this.getValueSize(),t)}setInterpolation(t){let e;switch(t){case Fn:e=this.InterpolantFactoryMethodDiscrete;break;case Bn:e=this.InterpolantFactoryMethodLinear;break;case kn:e=this.InterpolantFactoryMethodSmooth}if(void 0===e){const e="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant){if(t===this.DefaultInterpolation)throw new Error(e);this.setInterpolation(this.DefaultInterpolation)}return this}return this.createInterpolant=e,this}getInterpolation(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return Fn;case this.InterpolantFactoryMethodLinear:return Bn;case this.InterpolantFactoryMethodSmooth:return kn}}getValueSize(){return this.values.length/this.times.length}shift(t){if(0!==t){const e=this.times;for(let n=0,r=e.length;n!==r;++n)e[n]+=t}return this}scale(t){if(1!==t){const e=this.times;for(let n=0,r=e.length;n!==r;++n)e[n]*=t}return this}trim(t,e){const n=this.times,r=n.length;let i=0,a=r-1;for(;i!==r&&n[i]<t;)++i;for(;-1!==a&&n[a]>e;)--a;if(++a,0!==i||a!==r){i>=a&&(a=Math.max(a,1),i=a-1);const t=this.getValueSize();this.times=n.slice(i,a),this.values=this.values.slice(i*t,a*t)}return this}validate(){let t=1;const e=this.getValueSize();e-Math.floor(e)!==0&&(t=0);const n=this.times,r=this.values,i=n.length;0===i&&(t=0);let a=null;for(let e=0;e!==i;e++){const r=n[e];if("number"==typeof r&&isNaN(r)){t=0;break}if(null!==a&&a>r){t=0;break}a=r}if(void 0!==r&&So(r))for(let e=0,n=r.length;e!==n;++e){const n=r[e];if(isNaN(n)){t=0;break}}return t}optimize(){const t=this.times.slice(),e=this.values.slice(),n=this.getValueSize(),r=this.getInterpolation()===kn,i=t.length-1;let a=1;for(let s=1;s<i;++s){let i=0;const o=t[s];if(o!==t[s+1]&&(1!==s||o!==t[0]))if(r)i=1;else{const t=s*n,r=t-n,a=t+n;for(let s=0;s!==n;++s){const n=e[t+s];if(n!==e[r+s]||n!==e[a+s]){i=1;break}}}if(i){if(s!==a){t[a]=t[s];const r=s*n,i=a*n;for(let t=0;t!==n;++t)e[i+t]=e[r+t]}++a}}if(i>0){t[a]=t[i];for(let t=i*n,r=a*n,s=0;s!==n;++s)e[r+s]=e[t+s];++a}return a!==t.length?(this.times=t.slice(0,a),this.values=e.slice(0,a*n)):(this.times=t,this.values=e),this}clone(){const t=this.times.slice(),e=this.values.slice(),n=new(0,this.constructor)(this.name,t,e);return n.createInterpolant=this.createInterpolant,n}}Uo.prototype.ValueTypeName="",Uo.prototype.TimeBufferType=Float32Array,Uo.prototype.ValueBufferType=Float32Array,Uo.prototype.DefaultInterpolation=Bn;class Lo extends Uo{constructor(t,e,n){super(t,e,n)}}Lo.prototype.ValueTypeName="bool",Lo.prototype.ValueBufferType=Array,Lo.prototype.DefaultInterpolation=Fn,Lo.prototype.InterpolantFactoryMethodLinear=void 0,Lo.prototype.InterpolantFactoryMethodSmooth=void 0;class Io extends Uo{constructor(t,e,n,r){super(t,e,n,r)}}Io.prototype.ValueTypeName="color";class No extends Uo{constructor(t,e,n,r){super(t,e,n,r)}}No.prototype.ValueTypeName="number";class Oo extends Ao{constructor(t,e,n,r){super(t,e,n,r)}interpolate_(t,e,n,r){const i=this.resultBuffer,a=this.sampleValues,s=this.valueSize,o=(n-e)/(r-e);let l=t*s;for(let t=l+s;l!==t;l+=4)yr.slerpFlat(i,0,a,l-s,a,l,o);return i}}class Fo extends Uo{constructor(t,e,n,r){super(t,e,n,r)}InterpolantFactoryMethodLinear(t){return new Oo(this.times,this.values,this.getValueSize(),t)}}Fo.prototype.ValueTypeName="quaternion",Fo.prototype.InterpolantFactoryMethodSmooth=void 0;class Bo extends Uo{constructor(t,e,n){super(t,e,n)}}Bo.prototype.ValueTypeName="string",Bo.prototype.ValueBufferType=Array,Bo.prototype.DefaultInterpolation=Fn,Bo.prototype.InterpolantFactoryMethodLinear=void 0,Bo.prototype.InterpolantFactoryMethodSmooth=void 0;class ko extends Uo{constructor(t,e,n,r){super(t,e,n,r)}}ko.prototype.ValueTypeName="vector";class zo{constructor(t="",e=-1,n=[],r=2500){this.name=t,this.tracks=n,this.duration=e,this.blendMode=r,this.uuid=dr(),this.duration<0&&this.resetDuration()}static parse(t){const e=[],n=t.tracks,r=1/(t.fps||1);for(let t=0,i=n.length;t!==i;++t)e.push(Vo(n[t]).scale(r));const i=new this(t.name,t.duration,e,t.blendMode);return i.uuid=t.uuid,i}static toJSON(t){const e=[],n=t.tracks,r={name:t.name,duration:t.duration,tracks:e,uuid:t.uuid,blendMode:t.blendMode};for(let t=0,r=n.length;t!==r;++t)e.push(Uo.toJSON(n[t]));return r}static CreateFromMorphTargetSequence(t,e,n,r){const i=e.length,a=[];for(let t=0;t<i;t++){let s=[],o=[];s.push((t+i-1)%i,t,(t+1)%i),o.push(0,1,0);const l=Mo(s);s=wo(s,1,l),o=wo(o,1,l),r||0!==s[0]||(s.push(i),o.push(o[0])),a.push(new No(".morphTargetInfluences["+e[t].name+"]",s,o).scale(1/n))}return new this(t,-1,a)}static findByName(t,e){let n=t;if(!Array.isArray(t)){const e=t;n=e.geometry&&e.geometry.animations||e.animations}for(let t=0;t<n.length;t++)if(n[t].name===e)return n[t];return null}static CreateClipsFromMorphTargetSequences(t,e,n){const r={},i=/^([\w-]*?)([\d]+)$/;for(let e=0,n=t.length;e<n;e++){const n=t[e],a=n.name.match(i);if(a&&a.length>1){const t=a[1];let e=r[t];e||(r[t]=e=[]),e.push(n)}}const a=[];for(const t in r)a.push(this.CreateFromMorphTargetSequence(t,r[t],e,n));return a}static parseAnimation(t,e){if(!t)return null;const n=function(t,e,n,r,i){if(0!==n.length){const a=[],s=[];Ro(n,a,s,r),0!==a.length&&i.push(new t(e,a,s))}},r=[],i=t.name||"default",a=t.fps||30,s=t.blendMode;let o=t.length||-1;const l=t.hierarchy||[];for(let t=0;t<l.length;t++){const i=l[t].keys;if(i&&0!==i.length)if(i[0].morphTargets){const t={};let e;for(e=0;e<i.length;e++)if(i[e].morphTargets)for(let n=0;n<i[e].morphTargets.length;n++)t[i[e].morphTargets[n]]=-1;for(const n in t){const t=[],a=[];for(let r=0;r!==i[e].morphTargets.length;++r){const r=i[e];t.push(r.time),a.push(r.morphTarget===n?1:0)}r.push(new No(".morphTargetInfluence["+n+"]",t,a))}o=t.length*a}else{const a=".bones["+e[t].name+"]";n(ko,a+".position",i,"pos",r),n(Fo,a+".quaternion",i,"rot",r),n(ko,a+".scale",i,"scl",r)}}if(0===r.length)return null;return new this(i,o,r,s)}resetDuration(){let t=0;for(let e=0,n=this.tracks.length;e!==n;++e){const n=this.tracks[e];t=Math.max(t,n.times[n.times.length-1])}return this.duration=t,this}trim(){for(let t=0;t<this.tracks.length;t++)this.tracks[t].trim(0,this.duration);return this}validate(){let t=1;for(let e=0;e<this.tracks.length;e++)t=t&&this.tracks[e].validate();return t}optimize(){for(let t=0;t<this.tracks.length;t++)this.tracks[t].optimize();return this}clone(){const t=[];for(let e=0;e<this.tracks.length;e++)t.push(this.tracks[e].clone());return new this.constructor(this.name,this.duration,t,this.blendMode)}toJSON(){return this.constructor.toJSON(this)}}function Vo(t){if(void 0===t.type)throw new Error("THREE.KeyframeTrack: track type undefined, can not parse");const e=function(t){switch(t.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return No;case"vector":case"vector2":case"vector3":case"vector4":return ko;case"color":return Io;case"quaternion":return Fo;case"bool":case"boolean":return Lo;case"string":return Bo}throw new Error("THREE.KeyframeTrack: Unsupported typeName: "+t)}(t.type);if(void 0===t.times){const e=[],n=[];Ro(t.keys,e,n,"value"),t.times=e,t.values=n}return void 0!==e.parse?e.parse(t):new e(t.name,t.times,t.values,t.interpolation)}const Ho={enabled:0,files:{},add:function(t,e){0!=this.enabled&&(this.files[t]=e)},get:function(t){if(0!=this.enabled)return this.files[t]},remove:function(t){delete this.files[t]},clear:function(){this.files={}}};class Go{constructor(t,e,n){const r=this;let i,a=0,s=0,o=0;const l=[];this.onStart=void 0,this.onLoad=t,this.onProgress=e,this.onError=n,this.abortController=new AbortController,this.itemStart=function(t){o++,0==a&&void 0!==r.onStart&&r.onStart(t,s,o),a=1},this.itemEnd=function(t){s++,void 0!==r.onProgress&&r.onProgress(t,s,o),s===o&&(a=0,void 0!==r.onLoad&&r.onLoad())},this.itemError=function(t){void 0!==r.onError&&r.onError(t)},this.resolveURL=function(t){return i?i(t):t},this.setURLModifier=function(t){return i=t,this},this.addHandler=function(t,e){return l.push(t,e),this},this.removeHandler=function(t){const e=l.indexOf(t);return-1!==e&&l.splice(e,2),this},this.getHandler=function(t){for(let e=0,n=l.length;e<n;e+=2){const n=l[e],r=l[e+1];if(n.global&&(n.lastIndex=0),n.test(t))return r}return null},this.abort=function(){return this.abortController.abort(),this.abortController=new AbortController,this}}}const Wo=new Go;class Xo{constructor(t){this.manager=void 0!==t?t:Wo,this.crossOrigin="anonymous",this.withCredentials=0,this.path="",this.resourcePath="",this.requestHeader={}}load(){}loadAsync(t,e){const n=this;return new Promise(function(r,i){n.load(t,r,e,i)})}parse(){}setCrossOrigin(t){return this.crossOrigin=t,this}setWithCredentials(t){return this.withCredentials=t,this}setPath(t){return this.path=t,this}setResourcePath(t){return this.resourcePath=t,this}setRequestHeader(t){return this.requestHeader=t,this}abort(){return this}}Xo.DEFAULT_MATERIAL_NAME="__DEFAULT";const jo={};class qo extends Error{constructor(t,e){super(t),this.response=e}}class Yo extends Xo{constructor(t){super(t),this.mimeType="",this.responseType="",this._abortController=new AbortController}load(t,e,n,r){void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const i=Ho.get(`file:${t}`);if(void 0!==i)return this.manager.itemStart(t),setTimeout(()=>{e&&e(i),this.manager.itemEnd(t)},0),i;if(void 0!==jo[t])return void jo[t].push({onLoad:e,onProgress:n,onError:r});jo[t]=[],jo[t].push({onLoad:e,onProgress:n,onError:r});const a=new Request(t,{headers:new Headers(this.requestHeader),credentials:this.withCredentials?"include":"same-origin",signal:"function"==typeof AbortSignal.any?AbortSignal.any([this._abortController.signal,this.manager.abortController.signal]):this._abortController.signal}),s=this.mimeType,o=this.responseType;fetch(a).then(e=>{if(200===e.status||0===e.status){if(e.status,"undefined"==typeof ReadableStream||void 0===e.body||void 0===e.body.getReader)return e;const n=jo[t],r=e.body.getReader(),i=e.headers.get("X-File-Size")||e.headers.get("Content-Length"),a=i?parseInt(i):0,s=0!==a;let o=0;const l=new ReadableStream({start(t){!function e(){r.read().then(({done:r,value:i})=>{if(r)t.close();else{o+=i.byteLength;const r=new ProgressEvent("progress",{lengthComputable:s,loaded:o,total:a});for(let t=0,e=n.length;t<e;t++){const e=n[t];e.onProgress&&e.onProgress(r)}t.enqueue(i),e()}},e=>{t.error(e)})}()}});return new Response(l)}throw new qo(`fetch for "${e.url}" responded with ${e.status}: ${e.statusText}`,e)}).then(t=>{switch(o){case"arraybuffer":return t.arrayBuffer();case"blob":return t.blob();case"document":return t.text().then(t=>(new DOMParser).parseFromString(t,s));case"json":return t.json();default:if(""===s)return t.text();{const e=/charset="?([^;"\s]*)"?/i.exec(s),n=e&&e[1]?e[1].toLowerCase():void 0,r=new TextDecoder(n);return t.arrayBuffer().then(t=>r.decode(t))}}}).then(e=>{Ho.add(`file:${t}`,e);const n=jo[t];delete jo[t];for(let t=0,r=n.length;t<r;t++){const r=n[t];r.onLoad&&r.onLoad(e)}}).catch(e=>{const n=jo[t];if(void 0===n)throw this.manager.itemError(t),e;delete jo[t];for(let t=0,r=n.length;t<r;t++){const r=n[t];r.onError&&r.onError(e)}this.manager.itemError(t)}).finally(()=>{this.manager.itemEnd(t)}),this.manager.itemStart(t)}setResponseType(t){return this.responseType=t,this}setMimeType(t){return this.mimeType=t,this}abort(){return this._abortController.abort(),this._abortController=new AbortController,this}}const Ko=new WeakMap;class Zo extends Xo{constructor(t){super(t)}load(t,e,n,r){void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const i=this,a=Ho.get(`image:${t}`);if(void 0!==a){if(1==a.complete)i.manager.itemStart(t),setTimeout(function(){e&&e(a),i.manager.itemEnd(t)},0);else{let t=Ko.get(a);void 0===t&&(t=[],Ko.set(a,t)),t.push({onLoad:e,onError:r})}return a}const s=Rr("img");function o(){c(),e&&e(this);const n=Ko.get(this)||[];for(let t=0;t<n.length;t++){const e=n[t];e.onLoad&&e.onLoad(this)}Ko.delete(this),i.manager.itemEnd(t)}function l(e){c(),r&&r(e),Ho.remove(`image:${t}`);const n=Ko.get(this)||[];for(let t=0;t<n.length;t++){const r=n[t];r.onError&&r.onError(e)}Ko.delete(this),i.manager.itemError(t),i.manager.itemEnd(t)}function c(){s.removeEventListener("load",o,0),s.removeEventListener("error",l,0)}return s.addEventListener("load",o,0),s.addEventListener("error",l,0),"data:"!==t.slice(0,5)&&void 0!==this.crossOrigin&&(s.crossOrigin=this.crossOrigin),Ho.add(`image:${t}`,s),i.manager.itemStart(t),s.src=t,s}}class $o extends Xo{constructor(t){super(t)}load(t,e,n,r){const i=new Wr,a=new Zo(this.manager);return a.setCrossOrigin(this.crossOrigin),a.setPath(this.path),a.load(t,function(t){i.image=t,i.needsUpdate=1,void 0!==e&&e(i)},n,r),i}}class Jo extends Zi{constructor(t,e=1){super(),this.isLight=1,this.type="Light",this.color=new ma(t),this.intensity=e}dispose(){}copy(t,e){return super.copy(t,e),this.color.copy(t.color),this.intensity=t.intensity,this}toJSON(t){const e=super.toJSON(t);return e.object.color=this.color.getHex(),e.object.intensity=this.intensity,void 0!==this.groundColor&&(e.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(e.object.distance=this.distance),void 0!==this.angle&&(e.object.angle=this.angle),void 0!==this.decay&&(e.object.decay=this.decay),void 0!==this.penumbra&&(e.object.penumbra=this.penumbra),void 0!==this.shadow&&(e.object.shadow=this.shadow.toJSON()),void 0!==this.target&&(e.object.target=this.target.uuid),e}}const Qo=new Ti,tl=new br,el=new br;class nl{constructor(t){this.camera=t,this.intensity=1,this.bias=0,this.normalBias=0,this.radius=1,this.blurSamples=8,this.mapSize=new _r(512,512),this.mapType=ze,this.map=null,this.mapPass=null,this.matrix=new Ti,this.autoUpdate=1,this.needsUpdate=0,this._frustum=new qs,this._frameExtents=new _r(1,1),this._viewportCount=1,this._viewports=[new Xr(0,0,1,1)]}getViewportCount(){return this._viewportCount}getFrustum(){return this._frustum}updateMatrices(t){const e=this.camera,n=this.matrix;tl.setFromMatrixPosition(t.matrixWorld),e.position.copy(tl),el.setFromMatrixPosition(t.target.matrixWorld),e.lookAt(el),e.updateMatrixWorld(),Qo.multiplyMatrices(e.projectionMatrix,e.matrixWorldInverse),this._frustum.setFromProjectionMatrix(Qo,e.coordinateSystem,e.reversedDepth),e.reversedDepth?n.set(.5,0,0,.5,0,.5,0,.5,0,0,1,0,0,0,0,1):n.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),n.multiply(Qo)}getViewport(t){return this._viewports[t]}getFrameExtents(){return this._frameExtents}dispose(){this.map&&this.map.dispose(),this.mapPass&&this.mapPass.dispose()}copy(t){return this.camera=t.camera.clone(),this.intensity=t.intensity,this.bias=t.bias,this.radius=t.radius,this.autoUpdate=t.autoUpdate,this.needsUpdate=t.needsUpdate,this.normalBias=t.normalBias,this.blurSamples=t.blurSamples,this.mapSize.copy(t.mapSize),this}clone(){return(new this.constructor).copy(this)}toJSON(){const t={};return 1!==this.intensity&&(t.intensity=this.intensity),0!==this.bias&&(t.bias=this.bias),0!==this.normalBias&&(t.normalBias=this.normalBias),1!==this.radius&&(t.radius=this.radius),512===this.mapSize.x&&512===this.mapSize.y||(t.mapSize=this.mapSize.toArray()),t.camera=this.camera.toJSON(0).object,delete t.camera.matrix,t}}class rl extends nl{constructor(){super(new is(50,1,.5,500)),this.isSpotLightShadow=1,this.focus=1,this.aspect=1}updateMatrices(t){const e=this.camera,n=2*ur*t.angle*this.focus,r=this.mapSize.width/this.mapSize.height*this.aspect,i=t.distance||e.far;n===e.fov&&r===e.aspect&&i===e.far||(e.fov=n,e.aspect=r,e.far=i,e.updateProjectionMatrix()),super.updateMatrices(t)}copy(t){return super.copy(t),this.focus=t.focus,this}}class il extends Jo{constructor(t,e,n=0,r=Math.PI/3,i=0,a=2){super(t,e),this.isSpotLight=1,this.type="SpotLight",this.position.copy(Zi.DEFAULT_UP),this.updateMatrix(),this.target=new Zi,this.distance=n,this.angle=r,this.penumbra=i,this.decay=a,this.map=null,this.shadow=new rl}get power(){return this.intensity*Math.PI}set power(t){this.intensity=t/Math.PI}dispose(){this.shadow.dispose()}copy(t,e){return super.copy(t,e),this.distance=t.distance,this.angle=t.angle,this.penumbra=t.penumbra,this.decay=t.decay,this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}const al=new Ti,sl=new br,ol=new br;class ll extends nl{constructor(){super(new is(90,1,.5,500)),this.isPointLightShadow=1,this._frameExtents=new _r(4,2),this._viewportCount=6,this._viewports=[new Xr(2,1,1,1),new Xr(0,1,1,1),new Xr(3,1,1,1),new Xr(1,1,1,1),new Xr(3,0,1,1),new Xr(1,0,1,1)],this._cubeDirections=[new br(1,0,0),new br(-1,0,0),new br(0,0,1),new br(0,0,-1),new br(0,1,0),new br(0,-1,0)],this._cubeUps=[new br(0,1,0),new br(0,1,0),new br(0,1,0),new br(0,1,0),new br(0,0,1),new br(0,0,-1)]}updateMatrices(t,e=0){const n=this.camera,r=this.matrix,i=t.distance||n.far;i!==n.far&&(n.far=i,n.updateProjectionMatrix()),sl.setFromMatrixPosition(t.matrixWorld),n.position.copy(sl),ol.copy(n.position),ol.add(this._cubeDirections[e]),n.up.copy(this._cubeUps[e]),n.lookAt(ol),n.updateMatrixWorld(),r.makeTranslation(-sl.x,-sl.y,-sl.z),al.multiplyMatrices(n.projectionMatrix,n.matrixWorldInverse),this._frustum.setFromProjectionMatrix(al,n.coordinateSystem,n.reversedDepth)}}class cl extends Jo{constructor(t,e,n=0,r=2){super(t,e),this.isPointLight=1,this.type="PointLight",this.distance=n,this.decay=r,this.shadow=new ll}get power(){return 4*this.intensity*Math.PI}set power(t){this.intensity=t/(4*Math.PI)}dispose(){this.shadow.dispose()}copy(t,e){return super.copy(t,e),this.distance=t.distance,this.decay=t.decay,this.shadow=t.shadow.clone(),this}}class hl extends ts{constructor(t=-1,e=1,n=1,r=-1,i=.1,a=2e3){super(),this.isOrthographicCamera=1,this.type="OrthographicCamera",this.zoom=1,this.view=null,this.left=t,this.right=e,this.top=n,this.bottom=r,this.near=i,this.far=a,this.updateProjectionMatrix()}copy(t,e){return super.copy(t,e),this.left=t.left,this.right=t.right,this.top=t.top,this.bottom=t.bottom,this.near=t.near,this.far=t.far,this.zoom=t.zoom,this.view=null===t.view?null:Object.assign({},t.view),this}setViewOffset(t,e,n,r,i,a){null===this.view&&(this.view={enabled:1,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=1,this.view.fullWidth=t,this.view.fullHeight=e,this.view.offsetX=n,this.view.offsetY=r,this.view.width=i,this.view.height=a,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=0),this.updateProjectionMatrix()}updateProjectionMatrix(){const t=(this.right-this.left)/(2*this.zoom),e=(this.top-this.bottom)/(2*this.zoom),n=(this.right+this.left)/2,r=(this.top+this.bottom)/2;let i=n-t,a=n+t,s=r+e,o=r-e;if(null!==this.view&&this.view.enabled){const t=(this.right-this.left)/this.view.fullWidth/this.zoom,e=(this.top-this.bottom)/this.view.fullHeight/this.zoom;i+=t*this.view.offsetX,a=i+t*this.view.width,s-=e*this.view.offsetY,o=s-e*this.view.height}this.projectionMatrix.makeOrthographic(i,a,s,o,this.near,this.far,this.coordinateSystem,this.reversedDepth),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}toJSON(t){const e=super.toJSON(t);return e.object.zoom=this.zoom,e.object.left=this.left,e.object.right=this.right,e.object.top=this.top,e.object.bottom=this.bottom,e.object.near=this.near,e.object.far=this.far,null!==this.view&&(e.object.view=Object.assign({},this.view)),e}}class ul extends nl{constructor(){super(new hl(-5,5,5,-5,.5,500)),this.isDirectionalLightShadow=1}}class dl extends Jo{constructor(t,e){super(t,e),this.isDirectionalLight=1,this.type="DirectionalLight",this.position.copy(Zi.DEFAULT_UP),this.updateMatrix(),this.target=new Zi,this.shadow=new ul}dispose(){this.shadow.dispose()}copy(t){return super.copy(t),this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}class pl extends Jo{constructor(t,e){super(t,e),this.isAmbientLight=1,this.type="AmbientLight"}}class fl{static extractUrlBase(t){const e=t.lastIndexOf("/");return-1===e?"./":t.slice(0,e+1)}static resolveURL(t,e){return"string"!=typeof t||""===t?"":(/^https?:\/\//i.test(e)&&/^\//.test(t)&&(e=e.replace(/(^https?:\/\/[^\/]+).*/i,"$1")),/^(https?:)?\/\//i.test(t)||/^data:.*,.*$/i.test(t)||/^blob:.*$/i.test(t)?t:e+t)}}const ml=new WeakMap;class gl extends Xo{constructor(t){super(t),this.isImageBitmapLoader=1,this.options={premultiplyAlpha:"none"},this._abortController=new AbortController}setOptions(t){return this.options=t,this}load(t,e,n,r){void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const i=this,a=Ho.get(`image-bitmap:${t}`);if(void 0!==a)return i.manager.itemStart(t),a.then?void a.then(n=>{if(1!=ml.has(a))return e&&e(n),i.manager.itemEnd(t),n;r&&r(ml.get(a)),i.manager.itemError(t),i.manager.itemEnd(t)}):(setTimeout(function(){e&&e(a),i.manager.itemEnd(t)},0),a);const s={};s.credentials="anonymous"===this.crossOrigin?"same-origin":"include",s.headers=this.requestHeader,s.signal="function"==typeof AbortSignal.any?AbortSignal.any([this._abortController.signal,this.manager.abortController.signal]):this._abortController.signal;const o=fetch(t,s).then(function(t){return t.blob()}).then(function(t){return createImageBitmap(t,Object.assign(i.options,{colorSpaceConversion:"none"}))}).then(function(n){return Ho.add(`image-bitmap:${t}`,n),e&&e(n),i.manager.itemEnd(t),n}).catch(function(e){r&&r(e),ml.set(o,e),Ho.remove(`image-bitmap:${t}`),i.manager.itemError(t),i.manager.itemEnd(t)});Ho.add(`image-bitmap:${t}`,o),i.manager.itemStart(t)}abort(){return this._abortController.abort(),this._abortController=new AbortController,this}}class vl extends is{constructor(t=[]){super(),this.isArrayCamera=1,this.isMultiViewCamera=0,this.cameras=t}}const xl="\\[\\]\\.:\\/",_l=new RegExp("["+xl+"]","g"),yl="[^"+xl+"]",bl="[^"+xl.replace("\\.","")+"]",El=new RegExp("^"+/((?:WC+[\/:])*)/.source.replace("WC",yl)+/(WCOD+)?/.source.replace("WCOD",bl)+/(?:\.(WC+)(?:\[(.+)\])?)?/.source.replace("WC",yl)+/\.(WC+)(?:\[(.+)\])?/.source.replace("WC",yl)+"$"),Tl=["material","materials","bones","map"];class Sl{constructor(t,e,n){this.path=e,this.parsedPath=n||Sl.parseTrackName(e),this.node=Sl.findNode(t,this.parsedPath.nodeName),this.rootNode=t,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}static create(t,e,n){return t&&t.isAnimationObjectGroup?new Sl.Composite(t,e,n):new Sl(t,e,n)}static sanitizeNodeName(t){return t.replace(/\s/g,"_").replace(_l,"")}static parseTrackName(t){const e=El.exec(t);if(null===e)throw new Error("PropertyBinding: Cannot parse trackName: "+t);const n={nodeName:e[2],objectName:e[3],objectIndex:e[4],propertyName:e[5],propertyIndex:e[6]},r=n.nodeName&&n.nodeName.lastIndexOf(".");if(void 0!==r&&-1!==r){const t=n.nodeName.substring(r+1);-1!==Tl.indexOf(t)&&(n.nodeName=n.nodeName.substring(0,r),n.objectName=t)}if(null===n.propertyName||0===n.propertyName.length)throw new Error("PropertyBinding: can not parse propertyName from trackName: "+t);return n}static findNode(t,e){if(void 0===e||""===e||"."===e||-1===e||e===t.name||e===t.uuid)return t;if(t.skeleton){const n=t.skeleton.getBoneByName(e);if(void 0!==n)return n}if(t.children){const n=function(t){for(let r=0;r<t.length;r++){const i=t[r];if(i.name===e||i.uuid===e)return i;const a=n(i.children);if(a)return a}return null},r=n(t.children);if(r)return r}return null}_getValue_unavailable(){}_setValue_unavailable(){}_getValue_direct(t,e){t[e]=this.targetObject[this.propertyName]}_getValue_array(t,e){const n=this.resolvedProperty;for(let r=0,i=n.length;r!==i;++r)t[e++]=n[r]}_getValue_arrayElement(t,e){t[e]=this.resolvedProperty[this.propertyIndex]}_getValue_toArray(t,e){this.resolvedProperty.toArray(t,e)}_setValue_direct(t,e){this.targetObject[this.propertyName]=t[e]}_setValue_direct_setNeedsUpdate(t,e){this.targetObject[this.propertyName]=t[e],this.targetObject.needsUpdate=1}_setValue_direct_setMatrixWorldNeedsUpdate(t,e){this.targetObject[this.propertyName]=t[e],this.targetObject.matrixWorldNeedsUpdate=1}_setValue_array(t,e){const n=this.resolvedProperty;for(let r=0,i=n.length;r!==i;++r)n[r]=t[e++]}_setValue_array_setNeedsUpdate(t,e){const n=this.resolvedProperty;for(let r=0,i=n.length;r!==i;++r)n[r]=t[e++];this.targetObject.needsUpdate=1}_setValue_array_setMatrixWorldNeedsUpdate(t,e){const n=this.resolvedProperty;for(let r=0,i=n.length;r!==i;++r)n[r]=t[e++];this.targetObject.matrixWorldNeedsUpdate=1}_setValue_arrayElement(t,e){this.resolvedProperty[this.propertyIndex]=t[e]}_setValue_arrayElement_setNeedsUpdate(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.needsUpdate=1}_setValue_arrayElement_setMatrixWorldNeedsUpdate(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.matrixWorldNeedsUpdate=1}_setValue_fromArray(t,e){this.resolvedProperty.fromArray(t,e)}_setValue_fromArray_setNeedsUpdate(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.needsUpdate=1}_setValue_fromArray_setMatrixWorldNeedsUpdate(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.matrixWorldNeedsUpdate=1}_getValue_unbound(t,e){this.bind(),this.getValue(t,e)}_setValue_unbound(t,e){this.bind(),this.setValue(t,e)}bind(){let t=this.node;const e=this.parsedPath,n=e.objectName,r=e.propertyName;let i=e.propertyIndex;if(t||(t=Sl.findNode(this.rootNode,e.nodeName),this.node=t),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,!t)return;if(n){let r=e.objectIndex;switch(n){case"materials":if(!t.material)return;if(!t.material.materials)return;t=t.material.materials;break;case"bones":if(!t.skeleton)return;t=t.skeleton.bones;for(let e=0;e<t.length;e++)if(t[e].name===r){r=e;break}break;case"map":if("map"in t){t=t.map;break}if(!t.material)return;if(!t.material.map)return;t=t.material.map;break;default:if(void 0===t[n])return;t=t[n]}if(void 0!==r){if(void 0===t[r])return;t=t[r]}}const a=t[r];if(void 0===a){e.nodeName;return}let s=this.Versioning.None;this.targetObject=t,1==t.isMaterial?s=this.Versioning.NeedsUpdate:1==t.isObject3D&&(s=this.Versioning.MatrixWorldNeedsUpdate);let o=this.BindingType.Direct;if(void 0!==i){if("morphTargetInfluences"===r){if(!t.geometry)return;if(!t.geometry.morphAttributes)return;void 0!==t.morphTargetDictionary[i]&&(i=t.morphTargetDictionary[i])}o=this.BindingType.ArrayElement,this.resolvedProperty=a,this.propertyIndex=i}else void 0!==a.fromArray&&void 0!==a.toArray?(o=this.BindingType.HasFromToArray,this.resolvedProperty=a):Array.isArray(a)?(o=this.BindingType.EntireArray,this.resolvedProperty=a):this.propertyName=r;this.getValue=this.GetterByBindingType[o],this.setValue=this.SetterByBindingTypeAndVersioning[o][s]}unbind(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}}Sl.Composite=class{constructor(t,e,n){const r=n||Sl.parseTrackName(e);this._targetGroup=t,this._bindings=t.subscribe_(e,r)}getValue(t,e){this.bind();const n=this._targetGroup.nCachedObjects_,r=this._bindings[n];void 0!==r&&r.getValue(t,e)}setValue(t,e){const n=this._bindings;for(let r=this._targetGroup.nCachedObjects_,i=n.length;r!==i;++r)n[r].setValue(t,e)}bind(){const t=this._bindings;for(let e=this._targetGroup.nCachedObjects_,n=t.length;e!==n;++e)t[e].bind()}unbind(){const t=this._bindings;for(let e=this._targetGroup.nCachedObjects_,n=t.length;e!==n;++e)t[e].unbind()}},Sl.prototype.BindingType={Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},Sl.prototype.Versioning={None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},Sl.prototype.GetterByBindingType=[Sl.prototype._getValue_direct,Sl.prototype._getValue_array,Sl.prototype._getValue_arrayElement,Sl.prototype._getValue_toArray],Sl.prototype.SetterByBindingTypeAndVersioning=[[Sl.prototype._setValue_direct,Sl.prototype._setValue_direct_setNeedsUpdate,Sl.prototype._setValue_direct_setMatrixWorldNeedsUpdate],[Sl.prototype._setValue_array,Sl.prototype._setValue_array_setNeedsUpdate,Sl.prototype._setValue_array_setMatrixWorldNeedsUpdate],[Sl.prototype._setValue_arrayElement,Sl.prototype._setValue_arrayElement_setNeedsUpdate,Sl.prototype._setValue_arrayElement_setMatrixWorldNeedsUpdate],[Sl.prototype._setValue_fromArray,Sl.prototype._setValue_fromArray_setNeedsUpdate,Sl.prototype._setValue_fromArray_setMatrixWorldNeedsUpdate]];new Float32Array(1);function Ml(t,e,n,r){const i=function(t){switch(t){case ze:case Ve:return{byteLength:1,components:1};case Ge:case He:case qe:return{byteLength:2,components:1};case Ye:case Ke:return{byteLength:2,components:4};case Xe:case We:case je:return{byteLength:4,components:1};case $e:return{byteLength:4,components:3}}throw new Error(`Unknown texture type ${t}.`)}(r);switch(n){case 1021:return t*e;case en:case nn:return t*e/i.components*i.byteLength;case 1030:case rn:return t*e*2/i.components*i.byteLength;case 1022:return t*e*3/i.components*i.byteLength;case Je:case an:return t*e*4/i.components*i.byteLength;case sn:case on:return Math.floor((t+3)/4)*Math.floor((e+3)/4)*8;case ln:case cn:return Math.floor((t+3)/4)*Math.floor((e+3)/4)*16;case un:case pn:return Math.max(t,16)*Math.max(e,8)/4;case hn:case dn:return Math.max(t,8)*Math.max(e,8)/2;case fn:case mn:return Math.floor((t+3)/4)*Math.floor((e+3)/4)*8;case gn:case vn:return Math.floor((t+3)/4)*Math.floor((e+3)/4)*16;case xn:return Math.floor((t+4)/5)*Math.floor((e+3)/4)*16;case _n:return Math.floor((t+4)/5)*Math.floor((e+4)/5)*16;case yn:return Math.floor((t+5)/6)*Math.floor((e+4)/5)*16;case bn:return Math.floor((t+5)/6)*Math.floor((e+5)/6)*16;case En:return Math.floor((t+7)/8)*Math.floor((e+4)/5)*16;case Tn:return Math.floor((t+7)/8)*Math.floor((e+5)/6)*16;case Sn:return Math.floor((t+7)/8)*Math.floor((e+7)/8)*16;case Mn:return Math.floor((t+9)/10)*Math.floor((e+4)/5)*16;case wn:return Math.floor((t+9)/10)*Math.floor((e+5)/6)*16;case Rn:return Math.floor((t+9)/10)*Math.floor((e+7)/8)*16;case An:return Math.floor((t+9)/10)*Math.floor((e+9)/10)*16;case Cn:return Math.floor((t+11)/12)*Math.floor((e+9)/10)*16;case Pn:return Math.floor((t+11)/12)*Math.floor((e+11)/12)*16;case Dn:case Un:case Ln:return Math.ceil(t/4)*Math.ceil(e/4)*16;case 36283:case In:return Math.ceil(t/4)*Math.ceil(e/4)*8;case Nn:case On:return Math.ceil(t/4)*Math.ceil(e/4)*16}throw new Error(`Unable to determine texture byte length for ${n} format.`)}function wl(){let t=null,e=0,n=null,r=null;function i(e,a){n(e,a),r=t.requestAnimationFrame(i)}return{start:function(){1!=e&&null!==n&&(r=t.requestAnimationFrame(i),e=1)},stop:function(){t.cancelAnimationFrame(r),e=0},setAnimationLoop:function(t){n=t},setContext:function(e){t=e}}}function Rl(t){const e=new WeakMap;return{get:function(t){return t.isInterleavedBufferAttribute&&(t=t.data),e.get(t)},remove:function(n){n.isInterleavedBufferAttribute&&(n=n.data);const r=e.get(n);r&&(t.deleteBuffer(r.buffer),e.delete(n))},update:function(n,r){if(n.isInterleavedBufferAttribute&&(n=n.data),n.isGLBufferAttribute){const t=e.get(n);return void((!t||t.version<n.version)&&e.set(n,{buffer:n.buffer,type:n.type,bytesPerElement:n.elementSize,version:n.version}))}const i=e.get(n);if(void 0===i)e.set(n,function(e,n){const r=e.array,i=e.usage,a=r.byteLength,s=t.createBuffer();let o;if(t.bindBuffer(n,s),t.bufferData(n,r,i),e.onUploadCallback(),r instanceof Float32Array)o=t.FLOAT;else if("undefined"!=typeof Float16Array&&r instanceof Float16Array)o=t.HALF_FLOAT;else if(r instanceof Uint16Array)o=e.isFloat16BufferAttribute?t.HALF_FLOAT:t.UNSIGNED_SHORT;else if(r instanceof Int16Array)o=t.SHORT;else if(r instanceof Uint32Array)o=t.UNSIGNED_INT;else if(r instanceof Int32Array)o=t.INT;else if(r instanceof Int8Array)o=t.BYTE;else if(r instanceof Uint8Array)o=t.UNSIGNED_BYTE;else{if(!(r instanceof Uint8ClampedArray))throw new Error("THREE.WebGLAttributes: Unsupported buffer data format: "+r);o=t.UNSIGNED_BYTE}return{buffer:s,type:o,bytesPerElement:r.BYTES_PER_ELEMENT,version:e.version,size:a}}(n,r));else if(i.version<n.version){if(i.size!==n.array.byteLength)throw new Error("THREE.WebGLAttributes: The size of the buffer attribute's array buffer does not match the original size. Resizing buffer attributes is not supported.");!function(e,n,r){const i=n.array,a=n.updateRanges;if(t.bindBuffer(r,e),0===a.length)t.bufferSubData(r,0,i);else{a.sort((t,e)=>t.start-e.start);let e=0;for(let t=1;t<a.length;t++){const n=a[e],r=a[t];r.start<=n.start+n.count+1?n.count=Math.max(n.count,r.start+r.count-n.start):(++e,a[e]=r)}a.length=e+1;for(let e=0,n=a.length;e<n;e++){const n=a[e];t.bufferSubData(r,n.start*i.BYTES_PER_ELEMENT,i,n.start,n.count)}n.clearUpdateRanges()}n.onUploadCallback()}(i.buffer,n,r),i.version=n.version}}}}"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("register",{detail:{revision:Kt}})),"undefined"!=typeof window&&(window.__THREE__||(window.__THREE__=Kt));const Al={alphahash_fragment:"#ifdef USE_ALPHAHASH\n\tif ( diffuseColor.a < getAlphaHashThreshold( vPosition ) ) discard;\n#endif",alphahash_pars_fragment:"#ifdef USE_ALPHAHASH\n\tconst float ALPHA_HASH_SCALE = 0.05;\n\tfloat hash2D( vec2 value ) {\n\t\treturn fract( 1.0e4 * sin( 17.0 * value.x + 0.1 * value.y ) * ( 0.1 + abs( sin( 13.0 * value.y + value.x ) ) ) );\n\t}\n\tfloat hash3D( vec3 value ) {\n\t\treturn hash2D( vec2( hash2D( value.xy ), value.z ) );\n\t}\n\tfloat getAlphaHashThreshold( vec3 position ) {\n\t\tfloat maxDeriv = max(\n\t\t\tlength( dFdx( position.xyz ) ),\n\t\t\tlength( dFdy( position.xyz ) )\n\t\t);\n\t\tfloat pixScale = 1.0 / ( ALPHA_HASH_SCALE * maxDeriv );\n\t\tvec2 pixScales = vec2(\n\t\t\texp2( floor( log2( pixScale ) ) ),\n\t\t\texp2( ceil( log2( pixScale ) ) )\n\t\t);\n\t\tvec2 alpha = vec2(\n\t\t\thash3D( floor( pixScales.x * position.xyz ) ),\n\t\t\thash3D( floor( pixScales.y * position.xyz ) )\n\t\t);\n\t\tfloat lerpFactor = fract( log2( pixScale ) );\n\t\tfloat x = ( 1.0 - lerpFactor ) * alpha.x + lerpFactor * alpha.y;\n\t\tfloat a = min( lerpFactor, 1.0 - lerpFactor );\n\t\tvec3 cases = vec3(\n\t\t\tx * x / ( 2.0 * a * ( 1.0 - a ) ),\n\t\t\t( x - 0.5 * a ) / ( 1.0 - a ),\n\t\t\t1.0 - ( ( 1.0 - x ) * ( 1.0 - x ) / ( 2.0 * a * ( 1.0 - a ) ) )\n\t\t);\n\t\tfloat threshold = ( x < ( 1.0 - a ) )\n\t\t\t? ( ( x < a ) ? cases.x : cases.y )\n\t\t\t: cases.z;\n\t\treturn clamp( threshold , 1.0e-6, 1.0 );\n\t}\n#endif",alphamap_fragment:"#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vAlphaMapUv ).g;\n#endif",alphamap_pars_fragment:"#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",alphatest_fragment:"#ifdef USE_ALPHATEST\n\t#ifdef ALPHA_TO_COVERAGE\n\tdiffuseColor.a = smoothstep( alphaTest, alphaTest + fwidth( diffuseColor.a ), diffuseColor.a );\n\tif ( diffuseColor.a == 0.0 ) discard;\n\t#else\n\tif ( diffuseColor.a < alphaTest ) discard;\n\t#endif\n#endif",alphatest_pars_fragment:"#ifdef USE_ALPHATEST\n\tuniform float alphaTest;\n#endif",aomap_fragment:"#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vAoMapUv ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_CLEARCOAT ) \n\t\tclearcoatSpecularIndirect *= ambientOcclusion;\n\t#endif\n\t#if defined( USE_SHEEN ) \n\t\tsheenSpecularIndirect *= ambientOcclusion;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD )\n\t\tfloat dotNV = saturate( dot( geometryNormal, geometryViewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.roughness );\n\t#endif\n#endif",aomap_pars_fragment:"#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif",batching_pars_vertex:"#ifdef USE_BATCHING\n\t#if ! defined( GL_ANGLE_multi_draw )\n\t#define gl_DrawID _gl_DrawID\n\tuniform int _gl_DrawID;\n\t#endif\n\tuniform highp sampler2D batchingTexture;\n\tuniform highp usampler2D batchingIdTexture;\n\tmat4 getBatchingMatrix( const in float i ) {\n\t\tint size = textureSize( batchingTexture, 0 ).x;\n\t\tint j = int( i ) * 4;\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\tvec4 v1 = texelFetch( batchingTexture, ivec2( x, y ), 0 );\n\t\tvec4 v2 = texelFetch( batchingTexture, ivec2( x + 1, y ), 0 );\n\t\tvec4 v3 = texelFetch( batchingTexture, ivec2( x + 2, y ), 0 );\n\t\tvec4 v4 = texelFetch( batchingTexture, ivec2( x + 3, y ), 0 );\n\t\treturn mat4( v1, v2, v3, v4 );\n\t}\n\tfloat getIndirectIndex( const in int i ) {\n\t\tint size = textureSize( batchingIdTexture, 0 ).x;\n\t\tint x = i % size;\n\t\tint y = i / size;\n\t\treturn float( texelFetch( batchingIdTexture, ivec2( x, y ), 0 ).r );\n\t}\n#endif\n#ifdef USE_BATCHING_COLOR\n\tuniform sampler2D batchingColorTexture;\n\tvec3 getBatchingColor( const in float i ) {\n\t\tint size = textureSize( batchingColorTexture, 0 ).x;\n\t\tint j = int( i );\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\treturn texelFetch( batchingColorTexture, ivec2( x, y ), 0 ).rgb;\n\t}\n#endif",batching_vertex:"#ifdef USE_BATCHING\n\tmat4 batchingMatrix = getBatchingMatrix( getIndirectIndex( gl_DrawID ) );\n#endif",begin_vertex:"vec3 transformed = vec3( position );\n#ifdef USE_ALPHAHASH\n\tvPosition = vec3( position );\n#endif",beginnormal_vertex:"vec3 objectNormal = vec3( normal );\n#ifdef USE_TANGENT\n\tvec3 objectTangent = vec3( tangent.xyz );\n#endif",bsdfs:"float G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_BlinnPhong( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, 1.0, dotVH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n} // validated",iridescence_fragment:"#ifdef USE_IRIDESCENCE\n\tconst mat3 XYZ_TO_REC709 = mat3(\n\t\t 3.2404542, -0.9692660,  0.0556434,\n\t\t-1.5371385,  1.8760108, -0.2040259,\n\t\t-0.4985314,  0.0415560,  1.0572252\n\t);\n\tvec3 Fresnel0ToIor( vec3 fresnel0 ) {\n\t\tvec3 sqrtF0 = sqrt( fresnel0 );\n\t\treturn ( vec3( 1.0 ) + sqrtF0 ) / ( vec3( 1.0 ) - sqrtF0 );\n\t}\n\tvec3 IorToFresnel0( vec3 transmittedIor, float incidentIor ) {\n\t\treturn pow2( ( transmittedIor - vec3( incidentIor ) ) / ( transmittedIor + vec3( incidentIor ) ) );\n\t}\n\tfloat IorToFresnel0( float transmittedIor, float incidentIor ) {\n\t\treturn pow2( ( transmittedIor - incidentIor ) / ( transmittedIor + incidentIor ));\n\t}\n\tvec3 evalSensitivity( float OPD, vec3 shift ) {\n\t\tfloat phase = 2.0 * PI * OPD * 1.0e-9;\n\t\tvec3 val = vec3( 5.4856e-13, 4.4201e-13, 5.2481e-13 );\n\t\tvec3 pos = vec3( 1.6810e+06, 1.7953e+06, 2.2084e+06 );\n\t\tvec3 var = vec3( 4.3278e+09, 9.3046e+09, 6.6121e+09 );\n\t\tvec3 xyz = val * sqrt( 2.0 * PI * var ) * cos( pos * phase + shift ) * exp( - pow2( phase ) * var );\n\t\txyz.x += 9.7470e-14 * sqrt( 2.0 * PI * 4.5282e+09 ) * cos( 2.2399e+06 * phase + shift[ 0 ] ) * exp( - 4.5282e+09 * pow2( phase ) );\n\t\txyz /= 1.0685e-7;\n\t\tvec3 rgb = XYZ_TO_REC709 * xyz;\n\t\treturn rgb;\n\t}\n\tvec3 evalIridescence( float outsideIOR, float eta2, float cosTheta1, float thinFilmThickness, vec3 baseF0 ) {\n\t\tvec3 I;\n\t\tfloat iridescenceIOR = mix( outsideIOR, eta2, smoothstep( 0.0, 0.03, thinFilmThickness ) );\n\t\tfloat sinTheta2Sq = pow2( outsideIOR / iridescenceIOR ) * ( 1.0 - pow2( cosTheta1 ) );\n\t\tfloat cosTheta2Sq = 1.0 - sinTheta2Sq;\n\t\tif ( cosTheta2Sq < 0.0 ) {\n\t\t\treturn vec3( 1.0 );\n\t\t}\n\t\tfloat cosTheta2 = sqrt( cosTheta2Sq );\n\t\tfloat R0 = IorToFresnel0( iridescenceIOR, outsideIOR );\n\t\tfloat R12 = F_Schlick( R0, 1.0, cosTheta1 );\n\t\tfloat T121 = 1.0 - R12;\n\t\tfloat phi12 = 0.0;\n\t\tif ( iridescenceIOR < outsideIOR ) phi12 = PI;\n\t\tfloat phi21 = PI - phi12;\n\t\tvec3 baseIOR = Fresnel0ToIor( clamp( baseF0, 0.0, 0.9999 ) );\t\tvec3 R1 = IorToFresnel0( baseIOR, iridescenceIOR );\n\t\tvec3 R23 = F_Schlick( R1, 1.0, cosTheta2 );\n\t\tvec3 phi23 = vec3( 0.0 );\n\t\tif ( baseIOR[ 0 ] < iridescenceIOR ) phi23[ 0 ] = PI;\n\t\tif ( baseIOR[ 1 ] < iridescenceIOR ) phi23[ 1 ] = PI;\n\t\tif ( baseIOR[ 2 ] < iridescenceIOR ) phi23[ 2 ] = PI;\n\t\tfloat OPD = 2.0 * iridescenceIOR * thinFilmThickness * cosTheta2;\n\t\tvec3 phi = vec3( phi21 ) + phi23;\n\t\tvec3 R123 = clamp( R12 * R23, 1e-5, 0.9999 );\n\t\tvec3 r123 = sqrt( R123 );\n\t\tvec3 Rs = pow2( T121 ) * R23 / ( vec3( 1.0 ) - R123 );\n\t\tvec3 C0 = R12 + Rs;\n\t\tI = C0;\n\t\tvec3 Cm = Rs - T121;\n\t\tfor ( int m = 1; m <= 2; ++ m ) {\n\t\t\tCm *= r123;\n\t\t\tvec3 Sm = 2.0 * evalSensitivity( float( m ) * OPD, float( m ) * phi );\n\t\t\tI += Cm * Sm;\n\t\t}\n\t\treturn max( I, vec3( 0.0 ) );\n\t}\n#endif",bumpmap_pars_fragment:"#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vBumpMapUv );\n\t\tvec2 dSTdy = dFdy( vBumpMapUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vBumpMapUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vBumpMapUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vBumpMapUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy, float faceDirection ) {\n\t\tvec3 vSigmaX = normalize( dFdx( surf_pos.xyz ) );\n\t\tvec3 vSigmaY = normalize( dFdy( surf_pos.xyz ) );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 ) * faceDirection;\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif",clipping_planes_fragment:"#if NUM_CLIPPING_PLANES > 0\n\tvec4 plane;\n\t#ifdef ALPHA_TO_COVERAGE\n\t\tfloat distanceToPlane, distanceGradient;\n\t\tfloat clipOpacity = 1.0;\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tdistanceToPlane = - dot( vClipPosition, plane.xyz ) + plane.w;\n\t\t\tdistanceGradient = fwidth( distanceToPlane ) / 2.0;\n\t\t\tclipOpacity *= smoothstep( - distanceGradient, distanceGradient, distanceToPlane );\n\t\t\tif ( clipOpacity == 0.0 ) discard;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\t\tfloat unionClipOpacity = 1.0;\n\t\t\t#pragma unroll_loop_start\n\t\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\t\tplane = clippingPlanes[ i ];\n\t\t\t\tdistanceToPlane = - dot( vClipPosition, plane.xyz ) + plane.w;\n\t\t\t\tdistanceGradient = fwidth( distanceToPlane ) / 2.0;\n\t\t\t\tunionClipOpacity *= 1.0 - smoothstep( - distanceGradient, distanceGradient, distanceToPlane );\n\t\t\t}\n\t\t\t#pragma unroll_loop_end\n\t\t\tclipOpacity *= 1.0 - unionClipOpacity;\n\t\t#endif\n\t\tdiffuseColor.a *= clipOpacity;\n\t\tif ( diffuseColor.a == 0.0 ) discard;\n\t#else\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tif ( dot( vClipPosition, plane.xyz ) > plane.w ) discard;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\t\tbool clipped = true;\n\t\t\t#pragma unroll_loop_start\n\t\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\t\tplane = clippingPlanes[ i ];\n\t\t\t\tclipped = ( dot( vClipPosition, plane.xyz ) > plane.w ) && clipped;\n\t\t\t}\n\t\t\t#pragma unroll_loop_end\n\t\t\tif ( clipped ) discard;\n\t\t#endif\n\t#endif\n#endif",clipping_planes_pars_fragment:"#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif",clipping_planes_pars_vertex:"#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n#endif",clipping_planes_vertex:"#if NUM_CLIPPING_PLANES > 0\n\tvClipPosition = - mvPosition.xyz;\n#endif",color_fragment:"#if defined( USE_COLOR_ALPHA )\n\tdiffuseColor *= vColor;\n#elif defined( USE_COLOR )\n\tdiffuseColor.rgb *= vColor;\n#endif",color_pars_fragment:"#if defined( USE_COLOR_ALPHA )\n\tvarying vec4 vColor;\n#elif defined( USE_COLOR )\n\tvarying vec3 vColor;\n#endif",color_pars_vertex:"#if defined( USE_COLOR_ALPHA )\n\tvarying vec4 vColor;\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR ) || defined( USE_BATCHING_COLOR )\n\tvarying vec3 vColor;\n#endif",color_vertex:"#if defined( USE_COLOR_ALPHA )\n\tvColor = vec4( 1.0 );\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR ) || defined( USE_BATCHING_COLOR )\n\tvColor = vec3( 1.0 );\n#endif\n#ifdef USE_COLOR\n\tvColor *= color;\n#endif\n#ifdef USE_INSTANCING_COLOR\n\tvColor.xyz *= instanceColor.xyz;\n#endif\n#ifdef USE_BATCHING_COLOR\n\tvec3 batchingColor = getBatchingColor( getIndirectIndex( gl_DrawID ) );\n\tvColor.xyz *= batchingColor.xyz;\n#endif",common:"#define PI 3.141592653589793\n#define PI2 6.283185307179586\n#define PI_HALF 1.5707963267948966\n#define RECIPROCAL_PI 0.3183098861837907\n#define RECIPROCAL_PI2 0.15915494309189535\n#define EPSILON 1e-6\n#ifndef saturate\n#define saturate( a ) clamp( a, 0.0, 1.0 )\n#endif\n#define whiteComplement( a ) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nvec3 pow2( const in vec3 x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat max3( const in vec3 v ) { return max( max( v.x, v.y ), v.z ); }\nfloat average( const in vec3 v ) { return dot( v, vec3( 0.3333333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract( sin( sn ) * c );\n}\n#ifdef HIGH_PRECISION\n\tfloat precisionSafeLength( vec3 v ) { return length( v ); }\n#else\n\tfloat precisionSafeLength( vec3 v ) {\n\t\tfloat maxComponent = max3( abs( v ) );\n\t\treturn length( v / maxComponent ) * maxComponent;\n\t}\n#endif\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\n#ifdef USE_ALPHAHASH\n\tvarying vec3 vPosition;\n#endif\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nmat3 transposeMat3( const in mat3 m ) {\n\tmat3 tmp;\n\ttmp[ 0 ] = vec3( m[ 0 ].x, m[ 1 ].x, m[ 2 ].x );\n\ttmp[ 1 ] = vec3( m[ 0 ].y, m[ 1 ].y, m[ 2 ].y );\n\ttmp[ 2 ] = vec3( m[ 0 ].z, m[ 1 ].z, m[ 2 ].z );\n\treturn tmp;\n}\nbool isPerspectiveMatrix( mat4 m ) {\n\treturn m[ 2 ][ 3 ] == - 1.0;\n}\nvec2 equirectUv( in vec3 dir ) {\n\tfloat u = atan( dir.z, dir.x ) * RECIPROCAL_PI2 + 0.5;\n\tfloat v = asin( clamp( dir.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\treturn vec2( u, v );\n}\nvec3 BRDF_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 f0, const in float f90, const in float dotVH ) {\n\tfloat fresnel = exp2( ( - 5.55473 * dotVH - 6.98316 ) * dotVH );\n\treturn f0 * ( 1.0 - fresnel ) + ( f90 * fresnel );\n}\nfloat F_Schlick( const in float f0, const in float f90, const in float dotVH ) {\n\tfloat fresnel = exp2( ( - 5.55473 * dotVH - 6.98316 ) * dotVH );\n\treturn f0 * ( 1.0 - fresnel ) + ( f90 * fresnel );\n} // validated",cube_uv_reflection_fragment:"#ifdef ENVMAP_TYPE_CUBE_UV\n\t#define cubeUV_minMipLevel 4.0\n\t#define cubeUV_minTileSize 16.0\n\tfloat getFace( vec3 direction ) {\n\t\tvec3 absDirection = abs( direction );\n\t\tfloat face = - 1.0;\n\t\tif ( absDirection.x > absDirection.z ) {\n\t\t\tif ( absDirection.x > absDirection.y )\n\t\t\t\tface = direction.x > 0.0 ? 0.0 : 3.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t} else {\n\t\t\tif ( absDirection.z > absDirection.y )\n\t\t\t\tface = direction.z > 0.0 ? 2.0 : 5.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t}\n\t\treturn face;\n\t}\n\tvec2 getUV( vec3 direction, float face ) {\n\t\tvec2 uv;\n\t\tif ( face == 0.0 ) {\n\t\t\tuv = vec2( direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 1.0 ) {\n\t\t\tuv = vec2( - direction.x, - direction.z ) / abs( direction.y );\n\t\t} else if ( face == 2.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.y ) / abs( direction.z );\n\t\t} else if ( face == 3.0 ) {\n\t\t\tuv = vec2( - direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 4.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.z ) / abs( direction.y );\n\t\t} else {\n\t\t\tuv = vec2( direction.x, direction.y ) / abs( direction.z );\n\t\t}\n\t\treturn 0.5 * ( uv + 1.0 );\n\t}\n\tvec3 bilinearCubeUV( sampler2D envMap, vec3 direction, float mipInt ) {\n\t\tfloat face = getFace( direction );\n\t\tfloat filterInt = max( cubeUV_minMipLevel - mipInt, 0.0 );\n\t\tmipInt = max( mipInt, cubeUV_minMipLevel );\n\t\tfloat faceSize = exp2( mipInt );\n\t\thighp vec2 uv = getUV( direction, face ) * ( faceSize - 2.0 ) + 1.0;\n\t\tif ( face > 2.0 ) {\n\t\t\tuv.y += faceSize;\n\t\t\tface -= 3.0;\n\t\t}\n\t\tuv.x += face * faceSize;\n\t\tuv.x += filterInt * 3.0 * cubeUV_minTileSize;\n\t\tuv.y += 4.0 * ( exp2( CUBEUV_MAX_MIP ) - faceSize );\n\t\tuv.x *= CUBEUV_TEXEL_WIDTH;\n\t\tuv.y *= CUBEUV_TEXEL_HEIGHT;\n\t\t#ifdef texture2DGradEXT\n\t\t\treturn texture2DGradEXT( envMap, uv, vec2( 0.0 ), vec2( 0.0 ) ).rgb;\n\t\t#else\n\t\t\treturn texture2D( envMap, uv ).rgb;\n\t\t#endif\n\t}\n\t#define cubeUV_r0 1.0\n\t#define cubeUV_m0 - 2.0\n\t#define cubeUV_r1 0.8\n\t#define cubeUV_m1 - 1.0\n\t#define cubeUV_r4 0.4\n\t#define cubeUV_m4 2.0\n\t#define cubeUV_r5 0.305\n\t#define cubeUV_m5 3.0\n\t#define cubeUV_r6 0.21\n\t#define cubeUV_m6 4.0\n\tfloat roughnessToMip( float roughness ) {\n\t\tfloat mip = 0.0;\n\t\tif ( roughness >= cubeUV_r1 ) {\n\t\t\tmip = ( cubeUV_r0 - roughness ) * ( cubeUV_m1 - cubeUV_m0 ) / ( cubeUV_r0 - cubeUV_r1 ) + cubeUV_m0;\n\t\t} else if ( roughness >= cubeUV_r4 ) {\n\t\t\tmip = ( cubeUV_r1 - roughness ) * ( cubeUV_m4 - cubeUV_m1 ) / ( cubeUV_r1 - cubeUV_r4 ) + cubeUV_m1;\n\t\t} else if ( roughness >= cubeUV_r5 ) {\n\t\t\tmip = ( cubeUV_r4 - roughness ) * ( cubeUV_m5 - cubeUV_m4 ) / ( cubeUV_r4 - cubeUV_r5 ) + cubeUV_m4;\n\t\t} else if ( roughness >= cubeUV_r6 ) {\n\t\t\tmip = ( cubeUV_r5 - roughness ) * ( cubeUV_m6 - cubeUV_m5 ) / ( cubeUV_r5 - cubeUV_r6 ) + cubeUV_m5;\n\t\t} else {\n\t\t\tmip = - 2.0 * log2( 1.16 * roughness );\t\t}\n\t\treturn mip;\n\t}\n\tvec4 textureCubeUV( sampler2D envMap, vec3 sampleDir, float roughness ) {\n\t\tfloat mip = clamp( roughnessToMip( roughness ), cubeUV_m0, CUBEUV_MAX_MIP );\n\t\tfloat mipF = fract( mip );\n\t\tfloat mipInt = floor( mip );\n\t\tvec3 color0 = bilinearCubeUV( envMap, sampleDir, mipInt );\n\t\tif ( mipF == 0.0 ) {\n\t\t\treturn vec4( color0, 1.0 );\n\t\t} else {\n\t\t\tvec3 color1 = bilinearCubeUV( envMap, sampleDir, mipInt + 1.0 );\n\t\t\treturn vec4( mix( color0, color1, mipF ), 1.0 );\n\t\t}\n\t}\n#endif",defaultnormal_vertex:"vec3 transformedNormal = objectNormal;\n#ifdef USE_TANGENT\n\tvec3 transformedTangent = objectTangent;\n#endif\n#ifdef USE_BATCHING\n\tmat3 bm = mat3( batchingMatrix );\n\ttransformedNormal /= vec3( dot( bm[ 0 ], bm[ 0 ] ), dot( bm[ 1 ], bm[ 1 ] ), dot( bm[ 2 ], bm[ 2 ] ) );\n\ttransformedNormal = bm * transformedNormal;\n\t#ifdef USE_TANGENT\n\t\ttransformedTangent = bm * transformedTangent;\n\t#endif\n#endif\n#ifdef USE_INSTANCING\n\tmat3 im = mat3( instanceMatrix );\n\ttransformedNormal /= vec3( dot( im[ 0 ], im[ 0 ] ), dot( im[ 1 ], im[ 1 ] ), dot( im[ 2 ], im[ 2 ] ) );\n\ttransformedNormal = im * transformedNormal;\n\t#ifdef USE_TANGENT\n\t\ttransformedTangent = im * transformedTangent;\n\t#endif\n#endif\ntransformedNormal = normalMatrix * transformedNormal;\n#ifdef FLIP_SIDED\n\ttransformedNormal = - transformedNormal;\n#endif\n#ifdef USE_TANGENT\n\ttransformedTangent = ( modelViewMatrix * vec4( transformedTangent, 0.0 ) ).xyz;\n\t#ifdef FLIP_SIDED\n\t\ttransformedTangent = - transformedTangent;\n\t#endif\n#endif",displacementmap_pars_vertex:"#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif",displacementmap_vertex:"#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, vDisplacementMapUv ).x * displacementScale + displacementBias );\n#endif",emissivemap_fragment:"#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vEmissiveMapUv );\n\t#ifdef DECODE_VIDEO_TEXTURE_EMISSIVE\n\t\temissiveColor = sRGBTransferEOTF( emissiveColor );\n\t#endif\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif",emissivemap_pars_fragment:"#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif",colorspace_fragment:"gl_FragColor = linearToOutputTexel( gl_FragColor );",colorspace_pars_fragment:"vec4 LinearTransferOETF( in vec4 value ) {\n\treturn value;\n}\nvec4 sRGBTransferEOTF( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.a );\n}\nvec4 sRGBTransferOETF( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.a );\n}",envmap_fragment:"#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvec3 cameraToFrag;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToFrag = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToFrag = normalize( vWorldPosition - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToFrag, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToFrag, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, envMapRotation * vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif",envmap_common_pars_fragment:"#ifdef USE_ENVMAP\n\tuniform float envMapIntensity;\n\tuniform float flipEnvMap;\n\tuniform mat3 envMapRotation;\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\t\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\n\tuniform float reflectivity;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( LAMBERT )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\tvarying vec3 vWorldPosition;\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( LAMBERT )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\t\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif",envmap_physical_pars_fragment:"#ifdef USE_ENVMAP\n\tvec3 getIBLIrradiance( const in vec3 normal ) {\n\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, envMapRotation * worldNormal, 1.0 );\n\t\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t\t#else\n\t\t\treturn vec3( 0.0 );\n\t\t#endif\n\t}\n\tvec3 getIBLRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness ) {\n\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\tvec3 reflectVec = reflect( - viewDir, normal );\n\t\t\treflectVec = normalize( mix( reflectVec, normal, roughness * roughness) );\n\t\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, envMapRotation * reflectVec, roughness );\n\t\t\treturn envMapColor.rgb * envMapIntensity;\n\t\t#else\n\t\t\treturn vec3( 0.0 );\n\t\t#endif\n\t}\n\t#ifdef USE_ANISOTROPY\n\t\tvec3 getIBLAnisotropyRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness, const in vec3 bitangent, const in float anisotropy ) {\n\t\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\t\tvec3 bentNormal = cross( bitangent, viewDir );\n\t\t\t\tbentNormal = normalize( cross( bentNormal, bitangent ) );\n\t\t\t\tbentNormal = normalize( mix( bentNormal, normal, pow2( pow2( 1.0 - anisotropy * ( 1.0 - roughness ) ) ) ) );\n\t\t\t\treturn getIBLRadiance( viewDir, bentNormal, roughness );\n\t\t\t#else\n\t\t\t\treturn vec3( 0.0 );\n\t\t\t#endif\n\t\t}\n\t#endif\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToVertex = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif",fog_vertex:"#ifdef USE_FOG\n\tvFogDepth = - mvPosition.z;\n#endif",fog_pars_vertex:"#ifdef USE_FOG\n\tvarying float vFogDepth;\n#endif",fog_fragment:"#ifdef USE_FOG\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = 1.0 - exp( - fogDensity * fogDensity * vFogDepth * vFogDepth );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, vFogDepth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif",fog_pars_fragment:"#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\tvarying float vFogDepth;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif",gradientmap_pars_fragment:"#ifdef USE_GRADIENTMAP\n\tuniform sampler2D gradientMap;\n#endif\nvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\n\tfloat dotNL = dot( normal, lightDirection );\n\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\n\t#ifdef USE_GRADIENTMAP\n\t\treturn vec3( texture2D( gradientMap, coord ).r );\n\t#else\n\t\tvec2 fw = fwidth( coord ) * 0.5;\n\t\treturn mix( vec3( 0.7 ), vec3( 1.0 ), smoothstep( 0.7 - fw.x, 0.7 + fw.x, coord.x ) );\n\t#endif\n}",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif",lights_lambert_fragment:"LambertMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularStrength = specularStrength;",lights_lambert_pars_fragment:"varying vec3 vViewPosition;\nstruct LambertMaterial {\n\tvec3 diffuseColor;\n\tfloat specularStrength;\n};\nvoid RE_Direct_Lambert( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in LambertMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Lambert( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in LambertMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Lambert\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Lambert",lights_pars_begin:"uniform bool receiveShadow;\nuniform vec3 ambientLightColor;\n#if defined( USE_LIGHT_PROBES )\n\tuniform vec3 lightProbe[ 9 ];\n#endif\nvec3 shGetIrradianceAt( in vec3 normal, in vec3 shCoefficients[ 9 ] ) {\n\tfloat x = normal.x, y = normal.y, z = normal.z;\n\tvec3 result = shCoefficients[ 0 ] * 0.886227;\n\tresult += shCoefficients[ 1 ] * 2.0 * 0.511664 * y;\n\tresult += shCoefficients[ 2 ] * 2.0 * 0.511664 * z;\n\tresult += shCoefficients[ 3 ] * 2.0 * 0.511664 * x;\n\tresult += shCoefficients[ 4 ] * 2.0 * 0.429043 * x * y;\n\tresult += shCoefficients[ 5 ] * 2.0 * 0.429043 * y * z;\n\tresult += shCoefficients[ 6 ] * ( 0.743125 * z * z - 0.247708 );\n\tresult += shCoefficients[ 7 ] * 2.0 * 0.429043 * x * z;\n\tresult += shCoefficients[ 8 ] * 0.429043 * ( x * x - y * y );\n\treturn result;\n}\nvec3 getLightProbeIrradiance( const in vec3 lightProbe[ 9 ], const in vec3 normal ) {\n\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\tvec3 irradiance = shGetIrradianceAt( worldNormal, lightProbe );\n\treturn irradiance;\n}\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\treturn irradiance;\n}\nfloat getDistanceAttenuation( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\tif ( cutoffDistance > 0.0 ) {\n\t\tdistanceFalloff *= pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t}\n\treturn distanceFalloff;\n}\nfloat getSpotAttenuation( const in float coneCosine, const in float penumbraCosine, const in float angleCosine ) {\n\treturn smoothstep( coneCosine, penumbraCosine, angleCosine );\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalLightInfo( const in DirectionalLight directionalLight, out IncidentLight light ) {\n\t\tlight.color = directionalLight.color;\n\t\tlight.direction = directionalLight.direction;\n\t\tlight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointLightInfo( const in PointLight pointLight, const in vec3 geometryPosition, out IncidentLight light ) {\n\t\tvec3 lVector = pointLight.position - geometryPosition;\n\t\tlight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tlight.color = pointLight.color;\n\t\tlight.color *= getDistanceAttenuation( lightDistance, pointLight.distance, pointLight.decay );\n\t\tlight.visible = ( light.color != vec3( 0.0 ) );\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotLightInfo( const in SpotLight spotLight, const in vec3 geometryPosition, out IncidentLight light ) {\n\t\tvec3 lVector = spotLight.position - geometryPosition;\n\t\tlight.direction = normalize( lVector );\n\t\tfloat angleCos = dot( light.direction, spotLight.direction );\n\t\tfloat spotAttenuation = getSpotAttenuation( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\tif ( spotAttenuation > 0.0 ) {\n\t\t\tfloat lightDistance = length( lVector );\n\t\t\tlight.color = spotLight.color * spotAttenuation;\n\t\t\tlight.color *= getDistanceAttenuation( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tlight.visible = ( light.color != vec3( 0.0 ) );\n\t\t} else {\n\t\t\tlight.color = vec3( 0.0 );\n\t\t\tlight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_RECT_AREA_LIGHTS > 0\n\tstruct RectAreaLight {\n\t\tvec3 color;\n\t\tvec3 position;\n\t\tvec3 halfWidth;\n\t\tvec3 halfHeight;\n\t};\n\tuniform sampler2D ltc_1;\tuniform sampler2D ltc_2;\n\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in vec3 normal ) {\n\t\tfloat dotNL = dot( normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\treturn irradiance;\n\t}\n#endif",lights_toon_fragment:"ToonMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;",lights_toon_pars_fragment:"varying vec3 vViewPosition;\nstruct ToonMaterial {\n\tvec3 diffuseColor;\n};\nvoid RE_Direct_Toon( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\tvec3 irradiance = getGradientIrradiance( geometryNormal, directLight.direction ) * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Toon( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Toon\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Toon",lights_phong_fragment:"BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;",lights_phong_pars_fragment:"varying vec3 vViewPosition;\nstruct BlinnPhongMaterial {\n\tvec3 diffuseColor;\n\tvec3 specularColor;\n\tfloat specularShininess;\n\tfloat specularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_BlinnPhong( directLight.direction, geometryViewDir, geometryNormal, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong",lights_physical_fragment:"PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nvec3 dxy = max( abs( dFdx( nonPerturbedNormal ) ), abs( dFdy( nonPerturbedNormal ) ) );\nfloat geometryRoughness = max( max( dxy.x, dxy.y ), dxy.z );\nmaterial.roughness = max( roughnessFactor, 0.0525 );material.roughness += geometryRoughness;\nmaterial.roughness = min( material.roughness, 1.0 );\n#ifdef IOR\n\tmaterial.ior = ior;\n\t#ifdef USE_SPECULAR\n\t\tfloat specularIntensityFactor = specularIntensity;\n\t\tvec3 specularColorFactor = specularColor;\n\t\t#ifdef USE_SPECULAR_COLORMAP\n\t\t\tspecularColorFactor *= texture2D( specularColorMap, vSpecularColorMapUv ).rgb;\n\t\t#endif\n\t\t#ifdef USE_SPECULAR_INTENSITYMAP\n\t\t\tspecularIntensityFactor *= texture2D( specularIntensityMap, vSpecularIntensityMapUv ).a;\n\t\t#endif\n\t\tmaterial.specularF90 = mix( specularIntensityFactor, 1.0, metalnessFactor );\n\t#else\n\t\tfloat specularIntensityFactor = 1.0;\n\t\tvec3 specularColorFactor = vec3( 1.0 );\n\t\tmaterial.specularF90 = 1.0;\n\t#endif\n\tmaterial.specularColor = mix( min( pow2( ( material.ior - 1.0 ) / ( material.ior + 1.0 ) ) * specularColorFactor, vec3( 1.0 ) ) * specularIntensityFactor, diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( 0.04 ), diffuseColor.rgb, metalnessFactor );\n\tmaterial.specularF90 = 1.0;\n#endif\n#ifdef USE_CLEARCOAT\n\tmaterial.clearcoat = clearcoat;\n\tmaterial.clearcoatRoughness = clearcoatRoughness;\n\tmaterial.clearcoatF0 = vec3( 0.04 );\n\tmaterial.clearcoatF90 = 1.0;\n\t#ifdef USE_CLEARCOATMAP\n\t\tmaterial.clearcoat *= texture2D( clearcoatMap, vClearcoatMapUv ).x;\n\t#endif\n\t#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\t\tmaterial.clearcoatRoughness *= texture2D( clearcoatRoughnessMap, vClearcoatRoughnessMapUv ).y;\n\t#endif\n\tmaterial.clearcoat = saturate( material.clearcoat );\tmaterial.clearcoatRoughness = max( material.clearcoatRoughness, 0.0525 );\n\tmaterial.clearcoatRoughness += geometryRoughness;\n\tmaterial.clearcoatRoughness = min( material.clearcoatRoughness, 1.0 );\n#endif\n#ifdef USE_DISPERSION\n\tmaterial.dispersion = dispersion;\n#endif\n#ifdef USE_IRIDESCENCE\n\tmaterial.iridescence = iridescence;\n\tmaterial.iridescenceIOR = iridescenceIOR;\n\t#ifdef USE_IRIDESCENCEMAP\n\t\tmaterial.iridescence *= texture2D( iridescenceMap, vIridescenceMapUv ).r;\n\t#endif\n\t#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\t\tmaterial.iridescenceThickness = (iridescenceThicknessMaximum - iridescenceThicknessMinimum) * texture2D( iridescenceThicknessMap, vIridescenceThicknessMapUv ).g + iridescenceThicknessMinimum;\n\t#else\n\t\tmaterial.iridescenceThickness = iridescenceThicknessMaximum;\n\t#endif\n#endif\n#ifdef USE_SHEEN\n\tmaterial.sheenColor = sheenColor;\n\t#ifdef USE_SHEEN_COLORMAP\n\t\tmaterial.sheenColor *= texture2D( sheenColorMap, vSheenColorMapUv ).rgb;\n\t#endif\n\tmaterial.sheenRoughness = clamp( sheenRoughness, 0.07, 1.0 );\n\t#ifdef USE_SHEEN_ROUGHNESSMAP\n\t\tmaterial.sheenRoughness *= texture2D( sheenRoughnessMap, vSheenRoughnessMapUv ).a;\n\t#endif\n#endif\n#ifdef USE_ANISOTROPY\n\t#ifdef USE_ANISOTROPYMAP\n\t\tmat2 anisotropyMat = mat2( anisotropyVector.x, anisotropyVector.y, - anisotropyVector.y, anisotropyVector.x );\n\t\tvec3 anisotropyPolar = texture2D( anisotropyMap, vAnisotropyMapUv ).rgb;\n\t\tvec2 anisotropyV = anisotropyMat * normalize( 2.0 * anisotropyPolar.rg - vec2( 1.0 ) ) * anisotropyPolar.b;\n\t#else\n\t\tvec2 anisotropyV = anisotropyVector;\n\t#endif\n\tmaterial.anisotropy = length( anisotropyV );\n\tif( material.anisotropy == 0.0 ) {\n\t\tanisotropyV = vec2( 1.0, 0.0 );\n\t} else {\n\t\tanisotropyV /= material.anisotropy;\n\t\tmaterial.anisotropy = saturate( material.anisotropy );\n\t}\n\tmaterial.alphaT = mix( pow2( material.roughness ), 1.0, pow2( material.anisotropy ) );\n\tmaterial.anisotropyT = tbn[ 0 ] * anisotropyV.x + tbn[ 1 ] * anisotropyV.y;\n\tmaterial.anisotropyB = tbn[ 1 ] * anisotropyV.x - tbn[ 0 ] * anisotropyV.y;\n#endif",lights_physical_pars_fragment:"struct PhysicalMaterial {\n\tvec3 diffuseColor;\n\tfloat roughness;\n\tvec3 specularColor;\n\tfloat specularF90;\n\tfloat dispersion;\n\t#ifdef USE_CLEARCOAT\n\t\tfloat clearcoat;\n\t\tfloat clearcoatRoughness;\n\t\tvec3 clearcoatF0;\n\t\tfloat clearcoatF90;\n\t#endif\n\t#ifdef USE_IRIDESCENCE\n\t\tfloat iridescence;\n\t\tfloat iridescenceIOR;\n\t\tfloat iridescenceThickness;\n\t\tvec3 iridescenceFresnel;\n\t\tvec3 iridescenceF0;\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tvec3 sheenColor;\n\t\tfloat sheenRoughness;\n\t#endif\n\t#ifdef IOR\n\t\tfloat ior;\n\t#endif\n\t#ifdef USE_TRANSMISSION\n\t\tfloat transmission;\n\t\tfloat transmissionAlpha;\n\t\tfloat thickness;\n\t\tfloat attenuationDistance;\n\t\tvec3 attenuationColor;\n\t#endif\n\t#ifdef USE_ANISOTROPY\n\t\tfloat anisotropy;\n\t\tfloat alphaT;\n\t\tvec3 anisotropyT;\n\t\tvec3 anisotropyB;\n\t#endif\n};\nvec3 clearcoatSpecularDirect = vec3( 0.0 );\nvec3 clearcoatSpecularIndirect = vec3( 0.0 );\nvec3 sheenSpecularDirect = vec3( 0.0 );\nvec3 sheenSpecularIndirect = vec3(0.0 );\nvec3 Schlick_to_F0( const in vec3 f, const in float f90, const in float dotVH ) {\n    float x = clamp( 1.0 - dotVH, 0.0, 1.0 );\n    float x2 = x * x;\n    float x5 = clamp( x * x2 * x2, 0.0, 0.9999 );\n    return ( f - vec3( f90 ) * x5 ) / ( 1.0 - x5 );\n}\nfloat V_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\n#ifdef USE_ANISOTROPY\n\tfloat V_GGX_SmithCorrelated_Anisotropic( const in float alphaT, const in float alphaB, const in float dotTV, const in float dotBV, const in float dotTL, const in float dotBL, const in float dotNV, const in float dotNL ) {\n\t\tfloat gv = dotNL * length( vec3( alphaT * dotTV, alphaB * dotBV, dotNV ) );\n\t\tfloat gl = dotNV * length( vec3( alphaT * dotTL, alphaB * dotBL, dotNL ) );\n\t\tfloat v = 0.5 / ( gv + gl );\n\t\treturn saturate(v);\n\t}\n\tfloat D_GGX_Anisotropic( const in float alphaT, const in float alphaB, const in float dotNH, const in float dotTH, const in float dotBH ) {\n\t\tfloat a2 = alphaT * alphaB;\n\t\thighp vec3 v = vec3( alphaB * dotTH, alphaT * dotBH, a2 * dotNH );\n\t\thighp float v2 = dot( v, v );\n\t\tfloat w2 = a2 / v2;\n\t\treturn RECIPROCAL_PI * a2 * pow2 ( w2 );\n\t}\n#endif\n#ifdef USE_CLEARCOAT\n\tvec3 BRDF_GGX_Clearcoat( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in PhysicalMaterial material) {\n\t\tvec3 f0 = material.clearcoatF0;\n\t\tfloat f90 = material.clearcoatF90;\n\t\tfloat roughness = material.clearcoatRoughness;\n\t\tfloat alpha = pow2( roughness );\n\t\tvec3 halfDir = normalize( lightDir + viewDir );\n\t\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\t\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\t\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\t\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\t\tvec3 F = F_Schlick( f0, f90, dotVH );\n\t\tfloat V = V_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\t\tfloat D = D_GGX( alpha, dotNH );\n\t\treturn F * ( V * D );\n\t}\n#endif\nvec3 BRDF_GGX( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in PhysicalMaterial material ) {\n\tvec3 f0 = material.specularColor;\n\tfloat f90 = material.specularF90;\n\tfloat roughness = material.roughness;\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\tvec3 F = F_Schlick( f0, f90, dotVH );\n\t#ifdef USE_IRIDESCENCE\n\t\tF = mix( F, material.iridescenceFresnel, material.iridescence );\n\t#endif\n\t#ifdef USE_ANISOTROPY\n\t\tfloat dotTL = dot( material.anisotropyT, lightDir );\n\t\tfloat dotTV = dot( material.anisotropyT, viewDir );\n\t\tfloat dotTH = dot( material.anisotropyT, halfDir );\n\t\tfloat dotBL = dot( material.anisotropyB, lightDir );\n\t\tfloat dotBV = dot( material.anisotropyB, viewDir );\n\t\tfloat dotBH = dot( material.anisotropyB, halfDir );\n\t\tfloat V = V_GGX_SmithCorrelated_Anisotropic( material.alphaT, alpha, dotTV, dotBV, dotTL, dotBL, dotNV, dotNL );\n\t\tfloat D = D_GGX_Anisotropic( material.alphaT, alpha, dotNH, dotTH, dotBH );\n\t#else\n\t\tfloat V = V_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\t\tfloat D = D_GGX( alpha, dotNH );\n\t#endif\n\treturn F * ( V * D );\n}\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n\tconst float LUT_SIZE = 64.0;\n\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n\tconst float LUT_BIAS = 0.5 / LUT_SIZE;\n\tfloat dotNV = saturate( dot( N, V ) );\n\tvec2 uv = vec2( roughness, sqrt( 1.0 - dotNV ) );\n\tuv = uv * LUT_SCALE + LUT_BIAS;\n\treturn uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n\tfloat l = length( f );\n\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n\tfloat x = dot( v1, v2 );\n\tfloat y = abs( x );\n\tfloat a = 0.8543985 + ( 0.4965155 + 0.0145206 * y ) * y;\n\tfloat b = 3.4175940 + ( 4.1616724 + y ) * y;\n\tfloat v = a / b;\n\tfloat theta_sintheta = ( x > 0.0 ) ? v : 0.5 * inversesqrt( max( 1.0 - x * x, 1e-7 ) ) - v;\n\treturn cross( v1, v2 ) * theta_sintheta;\n}\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\n\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\n\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\n\tvec3 lightNormal = cross( v1, v2 );\n\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\n\tvec3 T1, T2;\n\tT1 = normalize( V - N * dot( V, N ) );\n\tT2 = - cross( N, T1 );\n\tmat3 mat = mInv * transposeMat3( mat3( T1, T2, N ) );\n\tvec3 coords[ 4 ];\n\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\n\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\n\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\n\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\n\tcoords[ 0 ] = normalize( coords[ 0 ] );\n\tcoords[ 1 ] = normalize( coords[ 1 ] );\n\tcoords[ 2 ] = normalize( coords[ 2 ] );\n\tcoords[ 3 ] = normalize( coords[ 3 ] );\n\tvec3 vectorFormFactor = vec3( 0.0 );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n\tfloat result = LTC_ClippedSphereFormFactor( vectorFormFactor );\n\treturn vec3( result );\n}\n#if defined( USE_SHEEN )\nfloat D_Charlie( float roughness, float dotNH ) {\n\tfloat alpha = pow2( roughness );\n\tfloat invAlpha = 1.0 / alpha;\n\tfloat cos2h = dotNH * dotNH;\n\tfloat sin2h = max( 1.0 - cos2h, 0.0078125 );\n\treturn ( 2.0 + invAlpha ) * pow( sin2h, invAlpha * 0.5 ) / ( 2.0 * PI );\n}\nfloat V_Neubelt( float dotNV, float dotNL ) {\n\treturn saturate( 1.0 / ( 4.0 * ( dotNL + dotNV - dotNL * dotNV ) ) );\n}\nvec3 BRDF_Sheen( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, vec3 sheenColor, const in float sheenRoughness ) {\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat D = D_Charlie( sheenRoughness, dotNH );\n\tfloat V = V_Neubelt( dotNV, dotNL );\n\treturn sheenColor * ( D * V );\n}\n#endif\nfloat IBLSheenBRDF( const in vec3 normal, const in vec3 viewDir, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat r2 = roughness * roughness;\n\tfloat a = roughness < 0.25 ? -339.2 * r2 + 161.4 * roughness - 25.9 : -8.48 * r2 + 14.3 * roughness - 9.95;\n\tfloat b = roughness < 0.25 ? 44.0 * r2 - 23.7 * roughness + 3.26 : 1.97 * r2 - 3.27 * roughness + 0.72;\n\tfloat DG = exp( a * dotNV + b ) + ( roughness < 0.25 ? 0.0 : 0.1 * ( roughness - 0.25 ) );\n\treturn saturate( DG * RECIPROCAL_PI );\n}\nvec2 DFGApprox( const in vec3 normal, const in vec3 viewDir, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\tvec2 fab = vec2( - 1.04, 1.04 ) * a004 + r.zw;\n\treturn fab;\n}\nvec3 EnvironmentBRDF( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float roughness ) {\n\tvec2 fab = DFGApprox( normal, viewDir, roughness );\n\treturn specularColor * fab.x + specularF90 * fab.y;\n}\n#ifdef USE_IRIDESCENCE\nvoid computeMultiscatteringIridescence( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float iridescence, const in vec3 iridescenceF0, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n#else\nvoid computeMultiscattering( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n#endif\n\tvec2 fab = DFGApprox( normal, viewDir, roughness );\n\t#ifdef USE_IRIDESCENCE\n\t\tvec3 Fr = mix( specularColor, iridescenceF0, iridescence );\n\t#else\n\t\tvec3 Fr = specularColor;\n\t#endif\n\tvec3 FssEss = Fr * fab.x + specularF90 * fab.y;\n\tfloat Ess = fab.x + fab.y;\n\tfloat Ems = 1.0 - Ess;\n\tvec3 Favg = Fr + ( 1.0 - Fr ) * 0.047619;\tvec3 Fms = FssEss * Favg / ( 1.0 - Ems * Favg );\n\tsingleScatter += FssEss;\n\tmultiScatter += Fms * Ems;\n}\n#if NUM_RECT_AREA_LIGHTS > 0\n\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t\tvec3 normal = geometryNormal;\n\t\tvec3 viewDir = geometryViewDir;\n\t\tvec3 position = geometryPosition;\n\t\tvec3 lightPos = rectAreaLight.position;\n\t\tvec3 halfWidth = rectAreaLight.halfWidth;\n\t\tvec3 halfHeight = rectAreaLight.halfHeight;\n\t\tvec3 lightColor = rectAreaLight.color;\n\t\tfloat roughness = material.roughness;\n\t\tvec3 rectCoords[ 4 ];\n\t\trectCoords[ 0 ] = lightPos + halfWidth - halfHeight;\t\trectCoords[ 1 ] = lightPos - halfWidth - halfHeight;\n\t\trectCoords[ 2 ] = lightPos - halfWidth + halfHeight;\n\t\trectCoords[ 3 ] = lightPos + halfWidth + halfHeight;\n\t\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\n\t\tvec4 t1 = texture2D( ltc_1, uv );\n\t\tvec4 t2 = texture2D( ltc_2, uv );\n\t\tmat3 mInv = mat3(\n\t\t\tvec3( t1.x, 0, t1.y ),\n\t\t\tvec3(    0, 1,    0 ),\n\t\t\tvec3( t1.z, 0, t1.w )\n\t\t);\n\t\tvec3 fresnel = ( material.specularColor * t2.x + ( vec3( 1.0 ) - material.specularColor ) * t2.y );\n\t\treflectedLight.directSpecular += lightColor * fresnel * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\n\t\treflectedLight.directDiffuse += lightColor * material.diffuseColor * LTC_Evaluate( normal, viewDir, position, mat3( 1.0 ), rectCoords );\n\t}\n#endif\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifdef USE_CLEARCOAT\n\t\tfloat dotNLcc = saturate( dot( geometryClearcoatNormal, directLight.direction ) );\n\t\tvec3 ccIrradiance = dotNLcc * directLight.color;\n\t\tclearcoatSpecularDirect += ccIrradiance * BRDF_GGX_Clearcoat( directLight.direction, geometryViewDir, geometryClearcoatNormal, material );\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tsheenSpecularDirect += irradiance * BRDF_Sheen( directLight.direction, geometryViewDir, geometryNormal, material.sheenColor, material.sheenRoughness );\n\t#endif\n\treflectedLight.directSpecular += irradiance * BRDF_GGX( directLight.direction, geometryViewDir, geometryNormal, material );\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 irradiance, const in vec3 clearcoatRadiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight) {\n\t#ifdef USE_CLEARCOAT\n\t\tclearcoatSpecularIndirect += clearcoatRadiance * EnvironmentBRDF( geometryClearcoatNormal, geometryViewDir, material.clearcoatF0, material.clearcoatF90, material.clearcoatRoughness );\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tsheenSpecularIndirect += irradiance * material.sheenColor * IBLSheenBRDF( geometryNormal, geometryViewDir, material.sheenRoughness );\n\t#endif\n\tvec3 singleScattering = vec3( 0.0 );\n\tvec3 multiScattering = vec3( 0.0 );\n\tvec3 cosineWeightedIrradiance = irradiance * RECIPROCAL_PI;\n\t#ifdef USE_IRIDESCENCE\n\t\tcomputeMultiscatteringIridescence( geometryNormal, geometryViewDir, material.specularColor, material.specularF90, material.iridescence, material.iridescenceFresnel, material.roughness, singleScattering, multiScattering );\n\t#else\n\t\tcomputeMultiscattering( geometryNormal, geometryViewDir, material.specularColor, material.specularF90, material.roughness, singleScattering, multiScattering );\n\t#endif\n\tvec3 totalScattering = singleScattering + multiScattering;\n\tvec3 diffuse = material.diffuseColor * ( 1.0 - max( max( totalScattering.r, totalScattering.g ), totalScattering.b ) );\n\treflectedLight.indirectSpecular += radiance * singleScattering;\n\treflectedLight.indirectSpecular += multiScattering * cosineWeightedIrradiance;\n\treflectedLight.indirectDiffuse += diffuse * cosineWeightedIrradiance;\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_Direct_RectArea\t\tRE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}",lights_fragment_begin:"\nvec3 geometryPosition = - vViewPosition;\nvec3 geometryNormal = normal;\nvec3 geometryViewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( vViewPosition );\nvec3 geometryClearcoatNormal = vec3( 0.0 );\n#ifdef USE_CLEARCOAT\n\tgeometryClearcoatNormal = clearcoatNormal;\n#endif\n#ifdef USE_IRIDESCENCE\n\tfloat dotNVi = saturate( dot( normal, geometryViewDir ) );\n\tif ( material.iridescenceThickness == 0.0 ) {\n\t\tmaterial.iridescence = 0.0;\n\t} else {\n\t\tmaterial.iridescence = saturate( material.iridescence );\n\t}\n\tif ( material.iridescence > 0.0 ) {\n\t\tmaterial.iridescenceFresnel = evalIridescence( 1.0, material.iridescenceIOR, dotNVi, material.iridescenceThickness, material.specularColor );\n\t\tmaterial.iridescenceF0 = Schlick_to_F0( material.iridescenceFresnel, 1.0, dotNVi );\n\t}\n#endif\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointLightInfo( pointLight, geometryPosition, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_POINT_LIGHT_SHADOWS )\n\t\tpointLightShadow = pointLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getPointShadow( pointShadowMap[ i ], pointLightShadow.shadowMapSize, pointLightShadow.shadowIntensity, pointLightShadow.shadowBias, pointLightShadow.shadowRadius, vPointShadowCoord[ i ], pointLightShadow.shadowCameraNear, pointLightShadow.shadowCameraFar ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\tvec4 spotColor;\n\tvec3 spotLightCoord;\n\tbool inSpotLightMap;\n\t#if defined( USE_SHADOWMAP ) && NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotLightInfo( spotLight, geometryPosition, directLight );\n\t\t#if ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS )\n\t\t#define SPOT_LIGHT_MAP_INDEX UNROLLED_LOOP_INDEX\n\t\t#elif ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\t#define SPOT_LIGHT_MAP_INDEX NUM_SPOT_LIGHT_MAPS\n\t\t#else\n\t\t#define SPOT_LIGHT_MAP_INDEX ( UNROLLED_LOOP_INDEX - NUM_SPOT_LIGHT_SHADOWS + NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS )\n\t\t#endif\n\t\t#if ( SPOT_LIGHT_MAP_INDEX < NUM_SPOT_LIGHT_MAPS )\n\t\t\tspotLightCoord = vSpotLightCoord[ i ].xyz / vSpotLightCoord[ i ].w;\n\t\t\tinSpotLightMap = all( lessThan( abs( spotLightCoord * 2. - 1. ), vec3( 1.0 ) ) );\n\t\t\tspotColor = texture2D( spotLightMap[ SPOT_LIGHT_MAP_INDEX ], spotLightCoord.xy );\n\t\t\tdirectLight.color = inSpotLightMap ? directLight.color * spotColor.rgb : directLight.color;\n\t\t#endif\n\t\t#undef SPOT_LIGHT_MAP_INDEX\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\tspotLightShadow = spotLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getShadow( spotShadowMap[ i ], spotLightShadow.shadowMapSize, spotLightShadow.shadowIntensity, spotLightShadow.shadowBias, spotLightShadow.shadowRadius, vSpotLightCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalLightInfo( directionalLight, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_DIR_LIGHT_SHADOWS )\n\t\tdirectionalLightShadow = directionalLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getShadow( directionalShadowMap[ i ], directionalLightShadow.shadowMapSize, directionalLightShadow.shadowIntensity, directionalLightShadow.shadowBias, directionalLightShadow.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\n\tRectAreaLight rectAreaLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\n\t\trectAreaLight = rectAreaLights[ i ];\n\t\tRE_Direct_RectArea( rectAreaLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 iblIrradiance = vec3( 0.0 );\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\t#if defined( USE_LIGHT_PROBES )\n\t\tirradiance += getLightProbeIrradiance( lightProbe, geometryNormal );\n\t#endif\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometryNormal );\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n#endif\n#if defined( RE_IndirectSpecular )\n\tvec3 radiance = vec3( 0.0 );\n\tvec3 clearcoatRadiance = vec3( 0.0 );\n#endif",lights_fragment_maps:"#if defined( RE_IndirectDiffuse )\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel = texture2D( lightMap, vLightMapUv );\n\t\tvec3 lightMapIrradiance = lightMapTexel.rgb * lightMapIntensity;\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t\tiblIrradiance += getIBLIrradiance( geometryNormal );\n\t#endif\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\t#ifdef USE_ANISOTROPY\n\t\tradiance += getIBLAnisotropyRadiance( geometryViewDir, geometryNormal, material.roughness, material.anisotropyB, material.anisotropy );\n\t#else\n\t\tradiance += getIBLRadiance( geometryViewDir, geometryNormal, material.roughness );\n\t#endif\n\t#ifdef USE_CLEARCOAT\n\t\tclearcoatRadiance += getIBLRadiance( geometryViewDir, geometryClearcoatNormal, material.clearcoatRoughness );\n\t#endif\n#endif",lights_fragment_end:"#if defined( RE_IndirectDiffuse )\n\tRE_IndirectDiffuse( irradiance, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n#endif\n#if defined( RE_IndirectSpecular )\n\tRE_IndirectSpecular( radiance, iblIrradiance, clearcoatRadiance, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n#endif",logdepthbuf_fragment:"#if defined( USE_LOGDEPTHBUF )\n\tgl_FragDepth = vIsPerspective == 0.0 ? gl_FragCoord.z : log2( vFragDepth ) * logDepthBufFC * 0.5;\n#endif",logdepthbuf_pars_fragment:"#if defined( USE_LOGDEPTHBUF )\n\tuniform float logDepthBufFC;\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif",logdepthbuf_pars_vertex:"#ifdef USE_LOGDEPTHBUF\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif",logdepthbuf_vertex:"#ifdef USE_LOGDEPTHBUF\n\tvFragDepth = 1.0 + gl_Position.w;\n\tvIsPerspective = float( isPerspectiveMatrix( projectionMatrix ) );\n#endif",map_fragment:"#ifdef USE_MAP\n\tvec4 sampledDiffuseColor = texture2D( map, vMapUv );\n\t#ifdef DECODE_VIDEO_TEXTURE\n\t\tsampledDiffuseColor = sRGBTransferEOTF( sampledDiffuseColor );\n\t#endif\n\tdiffuseColor *= sampledDiffuseColor;\n#endif",map_pars_fragment:"#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif",map_particle_fragment:"#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\t#if defined( USE_POINTS_UV )\n\t\tvec2 uv = vUv;\n\t#else\n\t\tvec2 uv = ( uvTransform * vec3( gl_PointCoord.x, 1.0 - gl_PointCoord.y, 1 ) ).xy;\n\t#endif\n#endif\n#ifdef USE_MAP\n\tdiffuseColor *= texture2D( map, uv );\n#endif\n#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, uv ).g;\n#endif",map_particle_pars_fragment:"#if defined( USE_POINTS_UV )\n\tvarying vec2 vUv;\n#else\n\t#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\t\tuniform mat3 uvTransform;\n\t#endif\n#endif\n#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",metalnessmap_fragment:"float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vMetalnessMapUv );\n\tmetalnessFactor *= texelMetalness.b;\n#endif",metalnessmap_pars_fragment:"#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif",morphinstance_vertex:"#ifdef USE_INSTANCING_MORPH\n\tfloat morphTargetInfluences[ MORPHTARGETS_COUNT ];\n\tfloat morphTargetBaseInfluence = texelFetch( morphTexture, ivec2( 0, gl_InstanceID ), 0 ).r;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tmorphTargetInfluences[i] =  texelFetch( morphTexture, ivec2( i + 1, gl_InstanceID ), 0 ).r;\n\t}\n#endif",morphcolor_vertex:"#if defined( USE_MORPHCOLORS )\n\tvColor *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\t#if defined( USE_COLOR_ALPHA )\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) vColor += getMorph( gl_VertexID, i, 2 ) * morphTargetInfluences[ i ];\n\t\t#elif defined( USE_COLOR )\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) vColor += getMorph( gl_VertexID, i, 2 ).rgb * morphTargetInfluences[ i ];\n\t\t#endif\n\t}\n#endif",morphnormal_vertex:"#ifdef USE_MORPHNORMALS\n\tobjectNormal *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tif ( morphTargetInfluences[ i ] != 0.0 ) objectNormal += getMorph( gl_VertexID, i, 1 ).xyz * morphTargetInfluences[ i ];\n\t}\n#endif",morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\n\t#ifndef USE_INSTANCING_MORPH\n\t\tuniform float morphTargetBaseInfluence;\n\t\tuniform float morphTargetInfluences[ MORPHTARGETS_COUNT ];\n\t#endif\n\tuniform sampler2DArray morphTargetsTexture;\n\tuniform ivec2 morphTargetsTextureSize;\n\tvec4 getMorph( const in int vertexIndex, const in int morphTargetIndex, const in int offset ) {\n\t\tint texelIndex = vertexIndex * MORPHTARGETS_TEXTURE_STRIDE + offset;\n\t\tint y = texelIndex / morphTargetsTextureSize.x;\n\t\tint x = texelIndex - y * morphTargetsTextureSize.x;\n\t\tivec3 morphUV = ivec3( x, y, morphTargetIndex );\n\t\treturn texelFetch( morphTargetsTexture, morphUV, 0 );\n\t}\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\n\ttransformed *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tif ( morphTargetInfluences[ i ] != 0.0 ) transformed += getMorph( gl_VertexID, i, 0 ).xyz * morphTargetInfluences[ i ];\n\t}\n#endif",normal_fragment_begin:"float faceDirection = gl_FrontFacing ? 1.0 : - 1.0;\n#ifdef FLAT_SHADED\n\tvec3 fdx = dFdx( vViewPosition );\n\tvec3 fdy = dFdy( vViewPosition );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal );\n\t#ifdef DOUBLE_SIDED\n\t\tnormal *= faceDirection;\n\t#endif\n#endif\n#if defined( USE_NORMALMAP_TANGENTSPACE ) || defined( USE_CLEARCOAT_NORMALMAP ) || defined( USE_ANISOTROPY )\n\t#ifdef USE_TANGENT\n\t\tmat3 tbn = mat3( normalize( vTangent ), normalize( vBitangent ), normal );\n\t#else\n\t\tmat3 tbn = getTangentFrame( - vViewPosition, normal,\n\t\t#if defined( USE_NORMALMAP )\n\t\t\tvNormalMapUv\n\t\t#elif defined( USE_CLEARCOAT_NORMALMAP )\n\t\t\tvClearcoatNormalMapUv\n\t\t#else\n\t\t\tvUv\n\t\t#endif\n\t\t);\n\t#endif\n\t#if defined( DOUBLE_SIDED ) && ! defined( FLAT_SHADED )\n\t\ttbn[0] *= faceDirection;\n\t\ttbn[1] *= faceDirection;\n\t#endif\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\t#ifdef USE_TANGENT\n\t\tmat3 tbn2 = mat3( normalize( vTangent ), normalize( vBitangent ), normal );\n\t#else\n\t\tmat3 tbn2 = getTangentFrame( - vViewPosition, normal, vClearcoatNormalMapUv );\n\t#endif\n\t#if defined( DOUBLE_SIDED ) && ! defined( FLAT_SHADED )\n\t\ttbn2[0] *= faceDirection;\n\t\ttbn2[1] *= faceDirection;\n\t#endif\n#endif\nvec3 nonPerturbedNormal = normal;",normal_fragment_maps:"#ifdef USE_NORMALMAP_OBJECTSPACE\n\tnormal = texture2D( normalMap, vNormalMapUv ).xyz * 2.0 - 1.0;\n\t#ifdef FLIP_SIDED\n\t\tnormal = - normal;\n\t#endif\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * faceDirection;\n\t#endif\n\tnormal = normalize( normalMatrix * normal );\n#elif defined( USE_NORMALMAP_TANGENTSPACE )\n\tvec3 mapN = texture2D( normalMap, vNormalMapUv ).xyz * 2.0 - 1.0;\n\tmapN.xy *= normalScale;\n\tnormal = normalize( tbn * mapN );\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( - vViewPosition, normal, dHdxy_fwd(), faceDirection );\n#endif",normal_pars_fragment:"#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif",normal_pars_vertex:"#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif",normal_vertex:"#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n\t#ifdef USE_TANGENT\n\t\tvTangent = normalize( transformedTangent );\n\t\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\n\t#endif\n#endif",normalmap_pars_fragment:"#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n#endif\n#ifdef USE_NORMALMAP_OBJECTSPACE\n\tuniform mat3 normalMatrix;\n#endif\n#if ! defined ( USE_TANGENT ) && ( defined ( USE_NORMALMAP_TANGENTSPACE ) || defined ( USE_CLEARCOAT_NORMALMAP ) || defined( USE_ANISOTROPY ) )\n\tmat3 getTangentFrame( vec3 eye_pos, vec3 surf_norm, vec2 uv ) {\n\t\tvec3 q0 = dFdx( eye_pos.xyz );\n\t\tvec3 q1 = dFdy( eye_pos.xyz );\n\t\tvec2 st0 = dFdx( uv.st );\n\t\tvec2 st1 = dFdy( uv.st );\n\t\tvec3 N = surf_norm;\n\t\tvec3 q1perp = cross( q1, N );\n\t\tvec3 q0perp = cross( N, q0 );\n\t\tvec3 T = q1perp * st0.x + q0perp * st1.x;\n\t\tvec3 B = q1perp * st0.y + q0perp * st1.y;\n\t\tfloat det = max( dot( T, T ), dot( B, B ) );\n\t\tfloat scale = ( det == 0.0 ) ? 0.0 : inversesqrt( det );\n\t\treturn mat3( T * scale, B * scale, N );\n\t}\n#endif",clearcoat_normal_fragment_begin:"#ifdef USE_CLEARCOAT\n\tvec3 clearcoatNormal = nonPerturbedNormal;\n#endif",clearcoat_normal_fragment_maps:"#ifdef USE_CLEARCOAT_NORMALMAP\n\tvec3 clearcoatMapN = texture2D( clearcoatNormalMap, vClearcoatNormalMapUv ).xyz * 2.0 - 1.0;\n\tclearcoatMapN.xy *= clearcoatNormalScale;\n\tclearcoatNormal = normalize( tbn2 * clearcoatMapN );\n#endif",clearcoat_pars_fragment:"#ifdef USE_CLEARCOATMAP\n\tuniform sampler2D clearcoatMap;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform sampler2D clearcoatNormalMap;\n\tuniform vec2 clearcoatNormalScale;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tuniform sampler2D clearcoatRoughnessMap;\n#endif",iridescence_pars_fragment:"#ifdef USE_IRIDESCENCEMAP\n\tuniform sampler2D iridescenceMap;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tuniform sampler2D iridescenceThicknessMap;\n#endif",opaque_fragment:"#ifdef OPAQUE\ndiffuseColor.a = 1.0;\n#endif\n#ifdef USE_TRANSMISSION\ndiffuseColor.a *= material.transmissionAlpha;\n#endif\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );",packing:"vec3 packNormalToRGB( const in vec3 normal ) {\n\treturn normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n\treturn 2.0 * rgb.xyz - 1.0;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;const float ShiftRight8 = 1. / 256.;\nconst float Inv255 = 1. / 255.;\nconst vec4 PackFactors = vec4( 1.0, 256.0, 256.0 * 256.0, 256.0 * 256.0 * 256.0 );\nconst vec2 UnpackFactors2 = vec2( UnpackDownscale, 1.0 / PackFactors.g );\nconst vec3 UnpackFactors3 = vec3( UnpackDownscale / PackFactors.rg, 1.0 / PackFactors.b );\nconst vec4 UnpackFactors4 = vec4( UnpackDownscale / PackFactors.rgb, 1.0 / PackFactors.a );\nvec4 packDepthToRGBA( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec4( 0., 0., 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec4( 1., 1., 1., 1. );\n\tfloat vuf;\n\tfloat af = modf( v * PackFactors.a, vuf );\n\tfloat bf = modf( vuf * ShiftRight8, vuf );\n\tfloat gf = modf( vuf * ShiftRight8, vuf );\n\treturn vec4( vuf * Inv255, gf * PackUpscale, bf * PackUpscale, af );\n}\nvec3 packDepthToRGB( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec3( 0., 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec3( 1., 1., 1. );\n\tfloat vuf;\n\tfloat bf = modf( v * PackFactors.b, vuf );\n\tfloat gf = modf( vuf * ShiftRight8, vuf );\n\treturn vec3( vuf * Inv255, gf * PackUpscale, bf );\n}\nvec2 packDepthToRG( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec2( 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec2( 1., 1. );\n\tfloat vuf;\n\tfloat gf = modf( v * 256., vuf );\n\treturn vec2( vuf * Inv255, gf );\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors4 );\n}\nfloat unpackRGBToDepth( const in vec3 v ) {\n\treturn dot( v, UnpackFactors3 );\n}\nfloat unpackRGToDepth( const in vec2 v ) {\n\treturn v.r * UnpackFactors2.r + v.g * UnpackFactors2.g;\n}\nvec4 pack2HalfToRGBA( const in vec2 v ) {\n\tvec4 r = vec4( v.x, fract( v.x * 255.0 ), v.y, fract( v.y * 255.0 ) );\n\treturn vec4( r.x - r.y / 255.0, r.y, r.z - r.w / 255.0, r.w );\n}\nvec2 unpackRGBATo2Half( const in vec4 v ) {\n\treturn vec2( v.x + ( v.y / 255.0 ), v.z + ( v.w / 255.0 ) );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float depth, const in float near, const in float far ) {\n\treturn depth * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( ( near + viewZ ) * far ) / ( ( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float depth, const in float near, const in float far ) {\n\treturn ( near * far ) / ( ( far - near ) * depth - far );\n}",premultiplied_alpha_fragment:"#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif",project_vertex:"vec4 mvPosition = vec4( transformed, 1.0 );\n#ifdef USE_BATCHING\n\tmvPosition = batchingMatrix * mvPosition;\n#endif\n#ifdef USE_INSTANCING\n\tmvPosition = instanceMatrix * mvPosition;\n#endif\nmvPosition = modelViewMatrix * mvPosition;\ngl_Position = projectionMatrix * mvPosition;",dithering_fragment:"#ifdef DITHERING\n\tgl_FragColor.rgb = dithering( gl_FragColor.rgb );\n#endif",dithering_pars_fragment:"#ifdef DITHERING\n\tvec3 dithering( vec3 color ) {\n\t\tfloat grid_position = rand( gl_FragCoord.xy );\n\t\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\n\t\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\n\t\treturn color + dither_shift_RGB;\n\t}\n#endif",roughnessmap_fragment:"float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vRoughnessMapUv );\n\troughnessFactor *= texelRoughness.g;\n#endif",roughnessmap_pars_fragment:"#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif",shadowmap_pars_fragment:"#if NUM_SPOT_LIGHT_COORDS > 0\n\tvarying vec4 vSpotLightCoord[ NUM_SPOT_LIGHT_COORDS ];\n#endif\n#if NUM_SPOT_LIGHT_MAPS > 0\n\tuniform sampler2D spotLightMap[ NUM_SPOT_LIGHT_MAPS ];\n#endif\n#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\tfloat depth = unpackRGBAToDepth( texture2D( depths, uv ) );\n\t\t#ifdef USE_REVERSEDEPTHBUF\n\t\t\treturn step( depth, compare );\n\t\t#else\n\t\t\treturn step( compare, depth );\n\t\t#endif\n\t}\n\tvec2 texture2DDistribution( sampler2D shadow, vec2 uv ) {\n\t\treturn unpackRGBATo2Half( texture2D( shadow, uv ) );\n\t}\n\tfloat VSMShadow (sampler2D shadow, vec2 uv, float compare ){\n\t\tfloat occlusion = 1.0;\n\t\tvec2 distribution = texture2DDistribution( shadow, uv );\n\t\t#ifdef USE_REVERSEDEPTHBUF\n\t\t\tfloat hard_shadow = step( distribution.x, compare );\n\t\t#else\n\t\t\tfloat hard_shadow = step( compare , distribution.x );\n\t\t#endif\n\t\tif (hard_shadow != 1.0 ) {\n\t\t\tfloat distance = compare - distribution.x ;\n\t\t\tfloat variance = max( 0.00000, distribution.y * distribution.y );\n\t\t\tfloat softness_probability = variance / (variance + distance * distance );\t\t\tsoftness_probability = clamp( ( softness_probability - 0.3 ) / ( 0.95 - 0.3 ), 0.0, 1.0 );\t\t\tocclusion = clamp( max( hard_shadow, softness_probability ), 0.0, 1.0 );\n\t\t}\n\t\treturn occlusion;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowIntensity, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tfloat shadow = 1.0;\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbool inFrustum = shadowCoord.x >= 0.0 && shadowCoord.x <= 1.0 && shadowCoord.y >= 0.0 && shadowCoord.y <= 1.0;\n\t\tbool frustumTest = inFrustum && shadowCoord.z <= 1.0;\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tfloat dx2 = dx0 / 2.0;\n\t\t\tfloat dy2 = dy0 / 2.0;\n\t\t\tfloat dx3 = dx1 / 2.0;\n\t\t\tfloat dy3 = dy1 / 2.0;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 17.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx = texelSize.x;\n\t\t\tfloat dy = texelSize.y;\n\t\t\tvec2 uv = shadowCoord.xy;\n\t\t\tvec2 f = fract( uv * shadowMapSize + 0.5 );\n\t\t\tuv -= f * texelSize;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, uv, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( dx, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( 0.0, dy ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + texelSize, shadowCoord.z ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, 0.0 ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 0.0 ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, dy ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, dy ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( 0.0, -dy ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 0.0, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( mix( texture2DCompare( shadowMap, uv + vec2( -dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t\t  f.x ),\n\t\t\t\t\t mix( texture2DCompare( shadowMap, uv + vec2( -dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t\t  f.x ),\n\t\t\t\t\t f.y )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_VSM )\n\t\t\tshadow = VSMShadow( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#else\n\t\t\tshadow = texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn mix( 1.0, shadow, shadowIntensity );\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowIntensity, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\n\t\tfloat shadow = 1.0;\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\t\n\t\tfloat lightToPositionLength = length( lightToPosition );\n\t\tif ( lightToPositionLength - shadowCameraFar <= 0.0 && lightToPositionLength - shadowCameraNear >= 0.0 ) {\n\t\t\tfloat dp = ( lightToPositionLength - shadowCameraNear ) / ( shadowCameraFar - shadowCameraNear );\t\t\tdp += shadowBias;\n\t\t\tvec3 bd3D = normalize( lightToPosition );\n\t\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT ) || defined( SHADOWMAP_TYPE_VSM )\n\t\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\t\tshadow = (\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t\t) * ( 1.0 / 9.0 );\n\t\t\t#else\n\t\t\t\tshadow = texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t\t#endif\n\t\t}\n\t\treturn mix( 1.0, shadow, shadowIntensity );\n\t}\n#endif",shadowmap_pars_vertex:"#if NUM_SPOT_LIGHT_COORDS > 0\n\tuniform mat4 spotLightMatrix[ NUM_SPOT_LIGHT_COORDS ];\n\tvarying vec4 vSpotLightCoord[ NUM_SPOT_LIGHT_COORDS ];\n#endif\n#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n#endif",shadowmap_vertex:"#if ( defined( USE_SHADOWMAP ) && ( NUM_DIR_LIGHT_SHADOWS > 0 || NUM_POINT_LIGHT_SHADOWS > 0 ) ) || ( NUM_SPOT_LIGHT_COORDS > 0 )\n\tvec3 shadowWorldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\tvec4 shadowWorldPosition;\n#endif\n#if defined( USE_SHADOWMAP )\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * directionalLightShadows[ i ].shadowNormalBias, 0 );\n\t\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * shadowWorldPosition;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * pointLightShadows[ i ].shadowNormalBias, 0 );\n\t\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * shadowWorldPosition;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n#endif\n#if NUM_SPOT_LIGHT_COORDS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_COORDS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition;\n\t\t#if ( defined( USE_SHADOWMAP ) && UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\t\tshadowWorldPosition.xyz += shadowWorldNormal * spotLightShadows[ i ].shadowNormalBias;\n\t\t#endif\n\t\tvSpotLightCoord[ i ] = spotLightMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n#endif",shadowmask_pars_fragment:"float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tdirectionalLight = directionalLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowIntensity, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tspotLight = spotLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowIntensity, spotLight.shadowBias, spotLight.shadowRadius, vSpotLightCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tpointLight = pointLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowIntensity, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#endif\n\treturn shadow;\n}",skinbase_vertex:"#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\tuniform highp sampler2D boneTexture;\n\tmat4 getBoneMatrix( const in float i ) {\n\t\tint size = textureSize( boneTexture, 0 ).x;\n\t\tint j = int( i ) * 4;\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\tvec4 v1 = texelFetch( boneTexture, ivec2( x, y ), 0 );\n\t\tvec4 v2 = texelFetch( boneTexture, ivec2( x + 1, y ), 0 );\n\t\tvec4 v3 = texelFetch( boneTexture, ivec2( x + 2, y ), 0 );\n\t\tvec4 v4 = texelFetch( boneTexture, ivec2( x + 3, y ), 0 );\n\t\treturn mat4( v1, v2, v3, v4 );\n\t}\n#endif",skinning_vertex:"#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\ttransformed = ( bindMatrixInverse * skinned ).xyz;\n#endif",skinnormal_vertex:"#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n\t#ifdef USE_TANGENT\n\t\tobjectTangent = vec4( skinMatrix * vec4( objectTangent, 0.0 ) ).xyz;\n\t#endif\n#endif",specularmap_fragment:"float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vSpecularMapUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif",specularmap_pars_fragment:"#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif",tonemapping_fragment:"#if defined( TONE_MAPPING )\n\tgl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif",tonemapping_pars_fragment:"#ifndef saturate\n#define saturate( a ) clamp( a, 0.0, 1.0 )\n#endif\nuniform float toneMappingExposure;\nvec3 LinearToneMapping( vec3 color ) {\n\treturn saturate( toneMappingExposure * color );\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( color / ( vec3( 1.0 ) + color ) );\n}\nvec3 CineonToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\tcolor = max( vec3( 0.0 ), color - 0.004 );\n\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\nvec3 RRTAndODTFit( vec3 v ) {\n\tvec3 a = v * ( v + 0.0245786 ) - 0.000090537;\n\tvec3 b = v * ( 0.983729 * v + 0.4329510 ) + 0.238081;\n\treturn a / b;\n}\nvec3 ACESFilmicToneMapping( vec3 color ) {\n\tconst mat3 ACESInputMat = mat3(\n\t\tvec3( 0.59719, 0.07600, 0.02840 ),\t\tvec3( 0.35458, 0.90834, 0.13383 ),\n\t\tvec3( 0.04823, 0.01566, 0.83777 )\n\t);\n\tconst mat3 ACESOutputMat = mat3(\n\t\tvec3(  1.60475, -0.10208, -0.00327 ),\t\tvec3( -0.53108,  1.10813, -0.07276 ),\n\t\tvec3( -0.07367, -0.00605,  1.07602 )\n\t);\n\tcolor *= toneMappingExposure / 0.6;\n\tcolor = ACESInputMat * color;\n\tcolor = RRTAndODTFit( color );\n\tcolor = ACESOutputMat * color;\n\treturn saturate( color );\n}\nconst mat3 LINEAR_REC2020_TO_LINEAR_SRGB = mat3(\n\tvec3( 1.6605, - 0.1246, - 0.0182 ),\n\tvec3( - 0.5876, 1.1329, - 0.1006 ),\n\tvec3( - 0.0728, - 0.0083, 1.1187 )\n);\nconst mat3 LINEAR_SRGB_TO_LINEAR_REC2020 = mat3(\n\tvec3( 0.6274, 0.0691, 0.0164 ),\n\tvec3( 0.3293, 0.9195, 0.0880 ),\n\tvec3( 0.0433, 0.0113, 0.8956 )\n);\nvec3 agxDefaultContrastApprox( vec3 x ) {\n\tvec3 x2 = x * x;\n\tvec3 x4 = x2 * x2;\n\treturn + 15.5 * x4 * x2\n\t\t- 40.14 * x4 * x\n\t\t+ 31.96 * x4\n\t\t- 6.868 * x2 * x\n\t\t+ 0.4298 * x2\n\t\t+ 0.1191 * x\n\t\t- 0.00232;\n}\nvec3 AgXToneMapping( vec3 color ) {\n\tconst mat3 AgXInsetMatrix = mat3(\n\t\tvec3( 0.856627153315983, 0.137318972929847, 0.11189821299995 ),\n\t\tvec3( 0.0951212405381588, 0.761241990602591, 0.0767994186031903 ),\n\t\tvec3( 0.0482516061458583, 0.101439036467562, 0.811302368396859 )\n\t);\n\tconst mat3 AgXOutsetMatrix = mat3(\n\t\tvec3( 1.1271005818144368, - 0.1413297634984383, - 0.14132976349843826 ),\n\t\tvec3( - 0.11060664309660323, 1.157823702216272, - 0.11060664309660294 ),\n\t\tvec3( - 0.016493938717834573, - 0.016493938717834257, 1.2519364065950405 )\n\t);\n\tconst float AgxMinEv = - 12.47393;\tconst float AgxMaxEv = 4.026069;\n\tcolor *= toneMappingExposure;\n\tcolor = LINEAR_SRGB_TO_LINEAR_REC2020 * color;\n\tcolor = AgXInsetMatrix * color;\n\tcolor = max( color, 1e-10 );\tcolor = log2( color );\n\tcolor = ( color - AgxMinEv ) / ( AgxMaxEv - AgxMinEv );\n\tcolor = clamp( color, 0.0, 1.0 );\n\tcolor = agxDefaultContrastApprox( color );\n\tcolor = AgXOutsetMatrix * color;\n\tcolor = pow( max( vec3( 0.0 ), color ), vec3( 2.2 ) );\n\tcolor = LINEAR_REC2020_TO_LINEAR_SRGB * color;\n\tcolor = clamp( color, 0.0, 1.0 );\n\treturn color;\n}\nvec3 NeutralToneMapping( vec3 color ) {\n\tconst float StartCompression = 0.8 - 0.04;\n\tconst float Desaturation = 0.15;\n\tcolor *= toneMappingExposure;\n\tfloat x = min( color.r, min( color.g, color.b ) );\n\tfloat offset = x < 0.08 ? x - 6.25 * x * x : 0.04;\n\tcolor -= offset;\n\tfloat peak = max( color.r, max( color.g, color.b ) );\n\tif ( peak < StartCompression ) return color;\n\tfloat d = 1. - StartCompression;\n\tfloat newPeak = 1. - d * d / ( peak + d - StartCompression );\n\tcolor *= newPeak / peak;\n\tfloat g = 1. - 1. / ( Desaturation * ( peak - newPeak ) + 1. );\n\treturn mix( color, vec3( newPeak ), g );\n}\nvec3 CustomToneMapping( vec3 color ) { return color; }",transmission_fragment:"#ifdef USE_TRANSMISSION\n\tmaterial.transmission = transmission;\n\tmaterial.transmissionAlpha = 1.0;\n\tmaterial.thickness = thickness;\n\tmaterial.attenuationDistance = attenuationDistance;\n\tmaterial.attenuationColor = attenuationColor;\n\t#ifdef USE_TRANSMISSIONMAP\n\t\tmaterial.transmission *= texture2D( transmissionMap, vTransmissionMapUv ).r;\n\t#endif\n\t#ifdef USE_THICKNESSMAP\n\t\tmaterial.thickness *= texture2D( thicknessMap, vThicknessMapUv ).g;\n\t#endif\n\tvec3 pos = vWorldPosition;\n\tvec3 v = normalize( cameraPosition - pos );\n\tvec3 n = inverseTransformDirection( normal, viewMatrix );\n\tvec4 transmitted = getIBLVolumeRefraction(\n\t\tn, v, material.roughness, material.diffuseColor, material.specularColor, material.specularF90,\n\t\tpos, modelMatrix, viewMatrix, projectionMatrix, material.dispersion, material.ior, material.thickness,\n\t\tmaterial.attenuationColor, material.attenuationDistance );\n\tmaterial.transmissionAlpha = mix( material.transmissionAlpha, transmitted.a, material.transmission );\n\ttotalDiffuse = mix( totalDiffuse, transmitted.rgb, material.transmission );\n#endif",transmission_pars_fragment:"#ifdef USE_TRANSMISSION\n\tuniform float transmission;\n\tuniform float thickness;\n\tuniform float attenuationDistance;\n\tuniform vec3 attenuationColor;\n\t#ifdef USE_TRANSMISSIONMAP\n\t\tuniform sampler2D transmissionMap;\n\t#endif\n\t#ifdef USE_THICKNESSMAP\n\t\tuniform sampler2D thicknessMap;\n\t#endif\n\tuniform vec2 transmissionSamplerSize;\n\tuniform sampler2D transmissionSamplerMap;\n\tuniform mat4 modelMatrix;\n\tuniform mat4 projectionMatrix;\n\tvarying vec3 vWorldPosition;\n\tfloat w0( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a * ( a * ( - a + 3.0 ) - 3.0 ) + 1.0 );\n\t}\n\tfloat w1( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a *  a * ( 3.0 * a - 6.0 ) + 4.0 );\n\t}\n\tfloat w2( float a ){\n\t\treturn ( 1.0 / 6.0 ) * ( a * ( a * ( - 3.0 * a + 3.0 ) + 3.0 ) + 1.0 );\n\t}\n\tfloat w3( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a * a * a );\n\t}\n\tfloat g0( float a ) {\n\t\treturn w0( a ) + w1( a );\n\t}\n\tfloat g1( float a ) {\n\t\treturn w2( a ) + w3( a );\n\t}\n\tfloat h0( float a ) {\n\t\treturn - 1.0 + w1( a ) / ( w0( a ) + w1( a ) );\n\t}\n\tfloat h1( float a ) {\n\t\treturn 1.0 + w3( a ) / ( w2( a ) + w3( a ) );\n\t}\n\tvec4 bicubic( sampler2D tex, vec2 uv, vec4 texelSize, float lod ) {\n\t\tuv = uv * texelSize.zw + 0.5;\n\t\tvec2 iuv = floor( uv );\n\t\tvec2 fuv = fract( uv );\n\t\tfloat g0x = g0( fuv.x );\n\t\tfloat g1x = g1( fuv.x );\n\t\tfloat h0x = h0( fuv.x );\n\t\tfloat h1x = h1( fuv.x );\n\t\tfloat h0y = h0( fuv.y );\n\t\tfloat h1y = h1( fuv.y );\n\t\tvec2 p0 = ( vec2( iuv.x + h0x, iuv.y + h0y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p1 = ( vec2( iuv.x + h1x, iuv.y + h0y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p2 = ( vec2( iuv.x + h0x, iuv.y + h1y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p3 = ( vec2( iuv.x + h1x, iuv.y + h1y ) - 0.5 ) * texelSize.xy;\n\t\treturn g0( fuv.y ) * ( g0x * textureLod( tex, p0, lod ) + g1x * textureLod( tex, p1, lod ) ) +\n\t\t\tg1( fuv.y ) * ( g0x * textureLod( tex, p2, lod ) + g1x * textureLod( tex, p3, lod ) );\n\t}\n\tvec4 textureBicubic( sampler2D sampler, vec2 uv, float lod ) {\n\t\tvec2 fLodSize = vec2( textureSize( sampler, int( lod ) ) );\n\t\tvec2 cLodSize = vec2( textureSize( sampler, int( lod + 1.0 ) ) );\n\t\tvec2 fLodSizeInv = 1.0 / fLodSize;\n\t\tvec2 cLodSizeInv = 1.0 / cLodSize;\n\t\tvec4 fSample = bicubic( sampler, uv, vec4( fLodSizeInv, fLodSize ), floor( lod ) );\n\t\tvec4 cSample = bicubic( sampler, uv, vec4( cLodSizeInv, cLodSize ), ceil( lod ) );\n\t\treturn mix( fSample, cSample, fract( lod ) );\n\t}\n\tvec3 getVolumeTransmissionRay( const in vec3 n, const in vec3 v, const in float thickness, const in float ior, const in mat4 modelMatrix ) {\n\t\tvec3 refractionVector = refract( - v, normalize( n ), 1.0 / ior );\n\t\tvec3 modelScale;\n\t\tmodelScale.x = length( vec3( modelMatrix[ 0 ].xyz ) );\n\t\tmodelScale.y = length( vec3( modelMatrix[ 1 ].xyz ) );\n\t\tmodelScale.z = length( vec3( modelMatrix[ 2 ].xyz ) );\n\t\treturn normalize( refractionVector ) * thickness * modelScale;\n\t}\n\tfloat applyIorToRoughness( const in float roughness, const in float ior ) {\n\t\treturn roughness * clamp( ior * 2.0 - 2.0, 0.0, 1.0 );\n\t}\n\tvec4 getTransmissionSample( const in vec2 fragCoord, const in float roughness, const in float ior ) {\n\t\tfloat lod = log2( transmissionSamplerSize.x ) * applyIorToRoughness( roughness, ior );\n\t\treturn textureBicubic( transmissionSamplerMap, fragCoord.xy, lod );\n\t}\n\tvec3 volumeAttenuation( const in float transmissionDistance, const in vec3 attenuationColor, const in float attenuationDistance ) {\n\t\tif ( isinf( attenuationDistance ) ) {\n\t\t\treturn vec3( 1.0 );\n\t\t} else {\n\t\t\tvec3 attenuationCoefficient = -log( attenuationColor ) / attenuationDistance;\n\t\t\tvec3 transmittance = exp( - attenuationCoefficient * transmissionDistance );\t\t\treturn transmittance;\n\t\t}\n\t}\n\tvec4 getIBLVolumeRefraction( const in vec3 n, const in vec3 v, const in float roughness, const in vec3 diffuseColor,\n\t\tconst in vec3 specularColor, const in float specularF90, const in vec3 position, const in mat4 modelMatrix,\n\t\tconst in mat4 viewMatrix, const in mat4 projMatrix, const in float dispersion, const in float ior, const in float thickness,\n\t\tconst in vec3 attenuationColor, const in float attenuationDistance ) {\n\t\tvec4 transmittedLight;\n\t\tvec3 transmittance;\n\t\t#ifdef USE_DISPERSION\n\t\t\tfloat halfSpread = ( ior - 1.0 ) * 0.025 * dispersion;\n\t\t\tvec3 iors = vec3( ior - halfSpread, ior, ior + halfSpread );\n\t\t\tfor ( int i = 0; i < 3; i ++ ) {\n\t\t\t\tvec3 transmissionRay = getVolumeTransmissionRay( n, v, thickness, iors[ i ], modelMatrix );\n\t\t\t\tvec3 refractedRayExit = position + transmissionRay;\n\t\t\t\tvec4 ndcPos = projMatrix * viewMatrix * vec4( refractedRayExit, 1.0 );\n\t\t\t\tvec2 refractionCoords = ndcPos.xy / ndcPos.w;\n\t\t\t\trefractionCoords += 1.0;\n\t\t\t\trefractionCoords /= 2.0;\n\t\t\t\tvec4 transmissionSample = getTransmissionSample( refractionCoords, roughness, iors[ i ] );\n\t\t\t\ttransmittedLight[ i ] = transmissionSample[ i ];\n\t\t\t\ttransmittedLight.a += transmissionSample.a;\n\t\t\t\ttransmittance[ i ] = diffuseColor[ i ] * volumeAttenuation( length( transmissionRay ), attenuationColor, attenuationDistance )[ i ];\n\t\t\t}\n\t\t\ttransmittedLight.a /= 3.0;\n\t\t#else\n\t\t\tvec3 transmissionRay = getVolumeTransmissionRay( n, v, thickness, ior, modelMatrix );\n\t\t\tvec3 refractedRayExit = position + transmissionRay;\n\t\t\tvec4 ndcPos = projMatrix * viewMatrix * vec4( refractedRayExit, 1.0 );\n\t\t\tvec2 refractionCoords = ndcPos.xy / ndcPos.w;\n\t\t\trefractionCoords += 1.0;\n\t\t\trefractionCoords /= 2.0;\n\t\t\ttransmittedLight = getTransmissionSample( refractionCoords, roughness, ior );\n\t\t\ttransmittance = diffuseColor * volumeAttenuation( length( transmissionRay ), attenuationColor, attenuationDistance );\n\t\t#endif\n\t\tvec3 attenuatedColor = transmittance * transmittedLight.rgb;\n\t\tvec3 F = EnvironmentBRDF( n, v, specularColor, specularF90, roughness );\n\t\tfloat transmittanceFactor = ( transmittance.r + transmittance.g + transmittance.b ) / 3.0;\n\t\treturn vec4( ( 1.0 - F ) * attenuatedColor, 1.0 - ( 1.0 - transmittedLight.a ) * transmittanceFactor );\n\t}\n#endif",uv_pars_fragment:"#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvarying vec2 vUv;\n#endif\n#ifdef USE_MAP\n\tvarying vec2 vMapUv;\n#endif\n#ifdef USE_ALPHAMAP\n\tvarying vec2 vAlphaMapUv;\n#endif\n#ifdef USE_LIGHTMAP\n\tvarying vec2 vLightMapUv;\n#endif\n#ifdef USE_AOMAP\n\tvarying vec2 vAoMapUv;\n#endif\n#ifdef USE_BUMPMAP\n\tvarying vec2 vBumpMapUv;\n#endif\n#ifdef USE_NORMALMAP\n\tvarying vec2 vNormalMapUv;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tvarying vec2 vEmissiveMapUv;\n#endif\n#ifdef USE_METALNESSMAP\n\tvarying vec2 vMetalnessMapUv;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tvarying vec2 vRoughnessMapUv;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tvarying vec2 vAnisotropyMapUv;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tvarying vec2 vClearcoatMapUv;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tvarying vec2 vClearcoatNormalMapUv;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tvarying vec2 vClearcoatRoughnessMapUv;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tvarying vec2 vIridescenceMapUv;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tvarying vec2 vIridescenceThicknessMapUv;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tvarying vec2 vSheenColorMapUv;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tvarying vec2 vSheenRoughnessMapUv;\n#endif\n#ifdef USE_SPECULARMAP\n\tvarying vec2 vSpecularMapUv;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tvarying vec2 vSpecularColorMapUv;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tvarying vec2 vSpecularIntensityMapUv;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tuniform mat3 transmissionMapTransform;\n\tvarying vec2 vTransmissionMapUv;\n#endif\n#ifdef USE_THICKNESSMAP\n\tuniform mat3 thicknessMapTransform;\n\tvarying vec2 vThicknessMapUv;\n#endif",uv_pars_vertex:"#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvarying vec2 vUv;\n#endif\n#ifdef USE_MAP\n\tuniform mat3 mapTransform;\n\tvarying vec2 vMapUv;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform mat3 alphaMapTransform;\n\tvarying vec2 vAlphaMapUv;\n#endif\n#ifdef USE_LIGHTMAP\n\tuniform mat3 lightMapTransform;\n\tvarying vec2 vLightMapUv;\n#endif\n#ifdef USE_AOMAP\n\tuniform mat3 aoMapTransform;\n\tvarying vec2 vAoMapUv;\n#endif\n#ifdef USE_BUMPMAP\n\tuniform mat3 bumpMapTransform;\n\tvarying vec2 vBumpMapUv;\n#endif\n#ifdef USE_NORMALMAP\n\tuniform mat3 normalMapTransform;\n\tvarying vec2 vNormalMapUv;\n#endif\n#ifdef USE_DISPLACEMENTMAP\n\tuniform mat3 displacementMapTransform;\n\tvarying vec2 vDisplacementMapUv;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tuniform mat3 emissiveMapTransform;\n\tvarying vec2 vEmissiveMapUv;\n#endif\n#ifdef USE_METALNESSMAP\n\tuniform mat3 metalnessMapTransform;\n\tvarying vec2 vMetalnessMapUv;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tuniform mat3 roughnessMapTransform;\n\tvarying vec2 vRoughnessMapUv;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tuniform mat3 anisotropyMapTransform;\n\tvarying vec2 vAnisotropyMapUv;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tuniform mat3 clearcoatMapTransform;\n\tvarying vec2 vClearcoatMapUv;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform mat3 clearcoatNormalMapTransform;\n\tvarying vec2 vClearcoatNormalMapUv;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tuniform mat3 clearcoatRoughnessMapTransform;\n\tvarying vec2 vClearcoatRoughnessMapUv;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tuniform mat3 sheenColorMapTransform;\n\tvarying vec2 vSheenColorMapUv;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tuniform mat3 sheenRoughnessMapTransform;\n\tvarying vec2 vSheenRoughnessMapUv;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tuniform mat3 iridescenceMapTransform;\n\tvarying vec2 vIridescenceMapUv;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tuniform mat3 iridescenceThicknessMapTransform;\n\tvarying vec2 vIridescenceThicknessMapUv;\n#endif\n#ifdef USE_SPECULARMAP\n\tuniform mat3 specularMapTransform;\n\tvarying vec2 vSpecularMapUv;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tuniform mat3 specularColorMapTransform;\n\tvarying vec2 vSpecularColorMapUv;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tuniform mat3 specularIntensityMapTransform;\n\tvarying vec2 vSpecularIntensityMapUv;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tuniform mat3 transmissionMapTransform;\n\tvarying vec2 vTransmissionMapUv;\n#endif\n#ifdef USE_THICKNESSMAP\n\tuniform mat3 thicknessMapTransform;\n\tvarying vec2 vThicknessMapUv;\n#endif",uv_vertex:"#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvUv = vec3( uv, 1 ).xy;\n#endif\n#ifdef USE_MAP\n\tvMapUv = ( mapTransform * vec3( MAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ALPHAMAP\n\tvAlphaMapUv = ( alphaMapTransform * vec3( ALPHAMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_LIGHTMAP\n\tvLightMapUv = ( lightMapTransform * vec3( LIGHTMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_AOMAP\n\tvAoMapUv = ( aoMapTransform * vec3( AOMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_BUMPMAP\n\tvBumpMapUv = ( bumpMapTransform * vec3( BUMPMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_NORMALMAP\n\tvNormalMapUv = ( normalMapTransform * vec3( NORMALMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_DISPLACEMENTMAP\n\tvDisplacementMapUv = ( displacementMapTransform * vec3( DISPLACEMENTMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tvEmissiveMapUv = ( emissiveMapTransform * vec3( EMISSIVEMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_METALNESSMAP\n\tvMetalnessMapUv = ( metalnessMapTransform * vec3( METALNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tvRoughnessMapUv = ( roughnessMapTransform * vec3( ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tvAnisotropyMapUv = ( anisotropyMapTransform * vec3( ANISOTROPYMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tvClearcoatMapUv = ( clearcoatMapTransform * vec3( CLEARCOATMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tvClearcoatNormalMapUv = ( clearcoatNormalMapTransform * vec3( CLEARCOAT_NORMALMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tvClearcoatRoughnessMapUv = ( clearcoatRoughnessMapTransform * vec3( CLEARCOAT_ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tvIridescenceMapUv = ( iridescenceMapTransform * vec3( IRIDESCENCEMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tvIridescenceThicknessMapUv = ( iridescenceThicknessMapTransform * vec3( IRIDESCENCE_THICKNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tvSheenColorMapUv = ( sheenColorMapTransform * vec3( SHEEN_COLORMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tvSheenRoughnessMapUv = ( sheenRoughnessMapTransform * vec3( SHEEN_ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULARMAP\n\tvSpecularMapUv = ( specularMapTransform * vec3( SPECULARMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tvSpecularColorMapUv = ( specularColorMapTransform * vec3( SPECULAR_COLORMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tvSpecularIntensityMapUv = ( specularIntensityMapTransform * vec3( SPECULAR_INTENSITYMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tvTransmissionMapUv = ( transmissionMapTransform * vec3( TRANSMISSIONMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_THICKNESSMAP\n\tvThicknessMapUv = ( thicknessMapTransform * vec3( THICKNESSMAP_UV, 1 ) ).xy;\n#endif",worldpos_vertex:"#if defined( USE_ENVMAP ) || defined( DISTANCE ) || defined ( USE_SHADOWMAP ) || defined ( USE_TRANSMISSION ) || NUM_SPOT_LIGHT_COORDS > 0\n\tvec4 worldPosition = vec4( transformed, 1.0 );\n\t#ifdef USE_BATCHING\n\t\tworldPosition = batchingMatrix * worldPosition;\n\t#endif\n\t#ifdef USE_INSTANCING\n\t\tworldPosition = instanceMatrix * worldPosition;\n\t#endif\n\tworldPosition = modelMatrix * worldPosition;\n#endif",background_vert:"varying vec2 vUv;\nuniform mat3 uvTransform;\nvoid main() {\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\tgl_Position = vec4( position.xy, 1.0, 1.0 );\n}",background_frag:"uniform sampler2D t2D;\nuniform float backgroundIntensity;\nvarying vec2 vUv;\nvoid main() {\n\tvec4 texColor = texture2D( t2D, vUv );\n\t#ifdef DECODE_VIDEO_TEXTURE\n\t\ttexColor = vec4( mix( pow( texColor.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), texColor.rgb * 0.0773993808, vec3( lessThanEqual( texColor.rgb, vec3( 0.04045 ) ) ) ), texColor.w );\n\t#endif\n\ttexColor.rgb *= backgroundIntensity;\n\tgl_FragColor = texColor;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",backgroundCube_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}",backgroundCube_frag:"#ifdef ENVMAP_TYPE_CUBE\n\tuniform samplerCube envMap;\n#elif defined( ENVMAP_TYPE_CUBE_UV )\n\tuniform sampler2D envMap;\n#endif\nuniform float flipEnvMap;\nuniform float backgroundBlurriness;\nuniform float backgroundIntensity;\nuniform mat3 backgroundRotation;\nvarying vec3 vWorldDirection;\n#include <cube_uv_reflection_fragment>\nvoid main() {\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 texColor = textureCube( envMap, backgroundRotation * vec3( flipEnvMap * vWorldDirection.x, vWorldDirection.yz ) );\n\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\tvec4 texColor = textureCubeUV( envMap, backgroundRotation * vWorldDirection, backgroundBlurriness );\n\t#else\n\t\tvec4 texColor = vec4( 0.0, 0.0, 0.0, 1.0 );\n\t#endif\n\ttexColor.rgb *= backgroundIntensity;\n\tgl_FragColor = texColor;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",cube_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}",cube_frag:"uniform samplerCube tCube;\nuniform float tFlip;\nuniform float opacity;\nvarying vec3 vWorldDirection;\nvoid main() {\n\tvec4 texColor = textureCube( tCube, vec3( tFlip * vWorldDirection.x, vWorldDirection.yz ) );\n\tgl_FragColor = texColor;\n\tgl_FragColor.a *= opacity;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",depth_vert:"#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <skinbase_vertex>\n\t#include <morphinstance_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvHighPrecisionZW = gl_Position.zw;\n}",depth_frag:"#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <clipping_planes_fragment>\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <logdepthbuf_fragment>\n\t#ifdef USE_REVERSEDEPTHBUF\n\t\tfloat fragCoordZ = vHighPrecisionZW[ 0 ] / vHighPrecisionZW[ 1 ];\n\t#else\n\t\tfloat fragCoordZ = 0.5 * vHighPrecisionZW[ 0 ] / vHighPrecisionZW[ 1 ] + 0.5;\n\t#endif\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( 1.0 - fragCoordZ ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( fragCoordZ );\n\t#elif DEPTH_PACKING == 3202\n\t\tgl_FragColor = vec4( packDepthToRGB( fragCoordZ ), 1.0 );\n\t#elif DEPTH_PACKING == 3203\n\t\tgl_FragColor = vec4( packDepthToRG( fragCoordZ ), 0.0, 1.0 );\n\t#endif\n}",distanceRGBA_vert:"#define DISTANCE\nvarying vec3 vWorldPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <skinbase_vertex>\n\t#include <morphinstance_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition.xyz;\n}",distanceRGBA_frag:"#define DISTANCE\nuniform vec3 referencePosition;\nuniform float nearDistance;\nuniform float farDistance;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <clipping_planes_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\tfloat dist = length( vWorldPosition - referencePosition );\n\tdist = ( dist - nearDistance ) / ( farDistance - nearDistance );\n\tdist = saturate( dist );\n\tgl_FragColor = packDepthToRGBA( dist );\n}",equirect_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}",equirect_frag:"uniform sampler2D tEquirect;\nvarying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldDirection );\n\tvec2 sampleUV = equirectUv( direction );\n\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",linedashed_vert:"uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <uv_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\tvLineDistance = scale * lineDistance;\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}",linedashed_frag:"uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}",meshbasic_vert:"#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#if defined ( USE_ENVMAP ) || defined ( USE_SKINNING )\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinbase_vertex>\n\t\t#include <skinnormal_vertex>\n\t\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <fog_vertex>\n}",meshbasic_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel = texture2D( lightMap, vLightMapUv );\n\t\treflectedLight.indirectDiffuse += lightMapTexel.rgb * lightMapIntensity * RECIPROCAL_PI;\n\t#else\n\t\treflectedLight.indirectDiffuse += vec3( 1.0 );\n\t#endif\n\t#include <aomap_fragment>\n\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshlambert_vert:"#define LAMBERT\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshlambert_frag:"#define LAMBERT\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_lambert_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_lambert_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshmatcap_vert:"#define MATCAP\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <color_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n\tvViewPosition = - mvPosition.xyz;\n}",meshmatcap_frag:"#define MATCAP\nuniform vec3 diffuse;\nuniform float opacity;\nuniform sampler2D matcap;\nvarying vec3 vViewPosition;\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <normal_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tvec3 viewDir = normalize( vViewPosition );\n\tvec3 x = normalize( vec3( viewDir.z, 0.0, - viewDir.x ) );\n\tvec3 y = cross( viewDir, x );\n\tvec2 uv = vec2( dot( x, normal ), dot( y, normal ) ) * 0.495 + 0.5;\n\t#ifdef USE_MATCAP\n\t\tvec4 matcapColor = texture2D( matcap, uv );\n\t#else\n\t\tvec4 matcapColor = vec4( vec3( mix( 0.2, 0.8, uv.y ) ), 1.0 );\n\t#endif\n\tvec3 outgoingLight = diffuseColor.rgb * matcapColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshnormal_vert:"#define NORMAL\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvarying vec3 vViewPosition;\n#endif\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n}",meshnormal_frag:"#define NORMAL\nuniform float opacity;\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvarying vec3 vViewPosition;\n#endif\n#include <packing>\n#include <uv_pars_fragment>\n#include <normal_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( 0.0, 0.0, 0.0, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tgl_FragColor = vec4( packNormalToRGB( normal ), diffuseColor.a );\n\t#ifdef OPAQUE\n\t\tgl_FragColor.a = 1.0;\n\t#endif\n}",meshphong_vert:"#define PHONG\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshphong_frag:"#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshphysical_vert:"#define STANDARD\nvarying vec3 vViewPosition;\n#ifdef USE_TRANSMISSION\n\tvarying vec3 vWorldPosition;\n#endif\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n#ifdef USE_TRANSMISSION\n\tvWorldPosition = worldPosition.xyz;\n#endif\n}",meshphysical_frag:"#define STANDARD\n#ifdef PHYSICAL\n\t#define IOR\n\t#define USE_SPECULAR\n#endif\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifdef IOR\n\tuniform float ior;\n#endif\n#ifdef USE_SPECULAR\n\tuniform float specularIntensity;\n\tuniform vec3 specularColor;\n\t#ifdef USE_SPECULAR_COLORMAP\n\t\tuniform sampler2D specularColorMap;\n\t#endif\n\t#ifdef USE_SPECULAR_INTENSITYMAP\n\t\tuniform sampler2D specularIntensityMap;\n\t#endif\n#endif\n#ifdef USE_CLEARCOAT\n\tuniform float clearcoat;\n\tuniform float clearcoatRoughness;\n#endif\n#ifdef USE_DISPERSION\n\tuniform float dispersion;\n#endif\n#ifdef USE_IRIDESCENCE\n\tuniform float iridescence;\n\tuniform float iridescenceIOR;\n\tuniform float iridescenceThicknessMinimum;\n\tuniform float iridescenceThicknessMaximum;\n#endif\n#ifdef USE_SHEEN\n\tuniform vec3 sheenColor;\n\tuniform float sheenRoughness;\n\t#ifdef USE_SHEEN_COLORMAP\n\t\tuniform sampler2D sheenColorMap;\n\t#endif\n\t#ifdef USE_SHEEN_ROUGHNESSMAP\n\t\tuniform sampler2D sheenRoughnessMap;\n\t#endif\n#endif\n#ifdef USE_ANISOTROPY\n\tuniform vec2 anisotropyVector;\n\t#ifdef USE_ANISOTROPYMAP\n\t\tuniform sampler2D anisotropyMap;\n\t#endif\n#endif\nvarying vec3 vViewPosition;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <iridescence_fragment>\n#include <cube_uv_reflection_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_physical_pars_fragment>\n#include <fog_pars_fragment>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_physical_pars_fragment>\n#include <transmission_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <clearcoat_pars_fragment>\n#include <iridescence_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <clearcoat_normal_fragment_begin>\n\t#include <clearcoat_normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 totalDiffuse = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse;\n\tvec3 totalSpecular = reflectedLight.directSpecular + reflectedLight.indirectSpecular;\n\t#include <transmission_fragment>\n\tvec3 outgoingLight = totalDiffuse + totalSpecular + totalEmissiveRadiance;\n\t#ifdef USE_SHEEN\n\t\tfloat sheenEnergyComp = 1.0 - 0.157 * max3( material.sheenColor );\n\t\toutgoingLight = outgoingLight * sheenEnergyComp + sheenSpecularDirect + sheenSpecularIndirect;\n\t#endif\n\t#ifdef USE_CLEARCOAT\n\t\tfloat dotNVcc = saturate( dot( geometryClearcoatNormal, geometryViewDir ) );\n\t\tvec3 Fcc = F_Schlick( material.clearcoatF0, material.clearcoatF90, dotNVcc );\n\t\toutgoingLight = outgoingLight * ( 1.0 - material.clearcoat * Fcc ) + ( clearcoatSpecularDirect + clearcoatSpecularIndirect ) * material.clearcoat;\n\t#endif\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshtoon_vert:"#define TOON\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshtoon_frag:"#define TOON\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <gradientmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_toon_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_toon_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",points_vert:"uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\n#ifdef USE_POINTS_UV\n\tvarying vec2 vUv;\n\tuniform mat3 uvTransform;\n#endif\nvoid main() {\n\t#ifdef USE_POINTS_UV\n\t\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\t#endif\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\tgl_PointSize = size;\n\t#ifdef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) gl_PointSize *= ( scale / - mvPosition.z );\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <fog_vertex>\n}",points_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}",shadow_vert:"#include <common>\n#include <batching_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",shadow_frag:"uniform vec3 color;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <logdepthbuf_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\t#include <logdepthbuf_fragment>\n\tgl_FragColor = vec4( color, opacity * ( 1.0 - getShadowMask() ) );\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n}",sprite_vert:"uniform float rotation;\nuniform vec2 center;\n#include <common>\n#include <uv_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\tvec4 mvPosition = modelViewMatrix[ 3 ];\n\tvec2 scale = vec2( length( modelMatrix[ 0 ].xyz ), length( modelMatrix[ 1 ].xyz ) );\n\t#ifndef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) scale *= - mvPosition.z;\n\t#endif\n\tvec2 alignedPosition = ( position.xy - ( center - vec2( 0.5 ) ) ) * scale;\n\tvec2 rotatedPosition;\n\trotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;\n\trotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;\n\tmvPosition.xy += rotatedPosition;\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}",sprite_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n}"},Cl={common:{diffuse:{value:new ma(16777215)},opacity:{value:1},map:{value:null},mapTransform:{value:new Sr},alphaMap:{value:null},alphaMapTransform:{value:new Sr},alphaTest:{value:0}},specularmap:{specularMap:{value:null},specularMapTransform:{value:new Sr}},envmap:{envMap:{value:null},envMapRotation:{value:new Sr},flipEnvMap:{value:-1},reflectivity:{value:1},ior:{value:1.5},refractionRatio:{value:.98}},aomap:{aoMap:{value:null},aoMapIntensity:{value:1},aoMapTransform:{value:new Sr}},lightmap:{lightMap:{value:null},lightMapIntensity:{value:1},lightMapTransform:{value:new Sr}},bumpmap:{bumpMap:{value:null},bumpMapTransform:{value:new Sr},bumpScale:{value:1}},normalmap:{normalMap:{value:null},normalMapTransform:{value:new Sr},normalScale:{value:new _r(1,1)}},displacementmap:{displacementMap:{value:null},displacementMapTransform:{value:new Sr},displacementScale:{value:1},displacementBias:{value:0}},emissivemap:{emissiveMap:{value:null},emissiveMapTransform:{value:new Sr}},metalnessmap:{metalnessMap:{value:null},metalnessMapTransform:{value:new Sr}},roughnessmap:{roughnessMap:{value:null},roughnessMapTransform:{value:new Sr}},gradientmap:{gradientMap:{value:null}},fog:{fogDensity:{value:25e-5},fogNear:{value:1},fogFar:{value:2e3},fogColor:{value:new ma(16777215)}},lights:{ambientLightColor:{value:[]},lightProbe:{value:[]},directionalLights:{value:[],properties:{direction:{},color:{}}},directionalLightShadows:{value:[],properties:{shadowIntensity:1,shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{}}},directionalShadowMap:{value:[]},directionalShadowMatrix:{value:[]},spotLights:{value:[],properties:{color:{},position:{},direction:{},distance:{},coneCos:{},penumbraCos:{},decay:{}}},spotLightShadows:{value:[],properties:{shadowIntensity:1,shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{}}},spotLightMap:{value:[]},spotShadowMap:{value:[]},spotLightMatrix:{value:[]},pointLights:{value:[],properties:{color:{},position:{},decay:{},distance:{}}},pointLightShadows:{value:[],properties:{shadowIntensity:1,shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{},shadowCameraNear:{},shadowCameraFar:{}}},pointShadowMap:{value:[]},pointShadowMatrix:{value:[]},hemisphereLights:{value:[],properties:{direction:{},skyColor:{},groundColor:{}}},rectAreaLights:{value:[],properties:{color:{},position:{},width:{},height:{}}},ltc_1:{value:null},ltc_2:{value:null}},points:{diffuse:{value:new ma(16777215)},opacity:{value:1},size:{value:1},scale:{value:1},map:{value:null},alphaMap:{value:null},alphaMapTransform:{value:new Sr},alphaTest:{value:0},uvTransform:{value:new Sr}},sprite:{diffuse:{value:new ma(16777215)},opacity:{value:1},center:{value:new _r(.5,.5)},rotation:{value:0},map:{value:null},mapTransform:{value:new Sr},alphaMap:{value:null},alphaMapTransform:{value:new Sr},alphaTest:{value:0}}},Pl={basic:{uniforms:Za([Cl.common,Cl.specularmap,Cl.envmap,Cl.aomap,Cl.lightmap,Cl.fog]),vertexShader:Al.meshbasic_vert,fragmentShader:Al.meshbasic_frag},lambert:{uniforms:Za([Cl.common,Cl.specularmap,Cl.envmap,Cl.aomap,Cl.lightmap,Cl.emissivemap,Cl.bumpmap,Cl.normalmap,Cl.displacementmap,Cl.fog,Cl.lights,{emissive:{value:new ma(0)}}]),vertexShader:Al.meshlambert_vert,fragmentShader:Al.meshlambert_frag},phong:{uniforms:Za([Cl.common,Cl.specularmap,Cl.envmap,Cl.aomap,Cl.lightmap,Cl.emissivemap,Cl.bumpmap,Cl.normalmap,Cl.displacementmap,Cl.fog,Cl.lights,{emissive:{value:new ma(0)},specular:{value:new ma(1118481)},shininess:{value:30}}]),vertexShader:Al.meshphong_vert,fragmentShader:Al.meshphong_frag},standard:{uniforms:Za([Cl.common,Cl.envmap,Cl.aomap,Cl.lightmap,Cl.emissivemap,Cl.bumpmap,Cl.normalmap,Cl.displacementmap,Cl.roughnessmap,Cl.metalnessmap,Cl.fog,Cl.lights,{emissive:{value:new ma(0)},roughness:{value:1},metalness:{value:0},envMapIntensity:{value:1}}]),vertexShader:Al.meshphysical_vert,fragmentShader:Al.meshphysical_frag},toon:{uniforms:Za([Cl.common,Cl.aomap,Cl.lightmap,Cl.emissivemap,Cl.bumpmap,Cl.normalmap,Cl.displacementmap,Cl.gradientmap,Cl.fog,Cl.lights,{emissive:{value:new ma(0)}}]),vertexShader:Al.meshtoon_vert,fragmentShader:Al.meshtoon_frag},matcap:{uniforms:Za([Cl.common,Cl.bumpmap,Cl.normalmap,Cl.displacementmap,Cl.fog,{matcap:{value:null}}]),vertexShader:Al.meshmatcap_vert,fragmentShader:Al.meshmatcap_frag},points:{uniforms:Za([Cl.points,Cl.fog]),vertexShader:Al.points_vert,fragmentShader:Al.points_frag},dashed:{uniforms:Za([Cl.common,Cl.fog,{scale:{value:1},dashSize:{value:1},totalSize:{value:2}}]),vertexShader:Al.linedashed_vert,fragmentShader:Al.linedashed_frag},depth:{uniforms:Za([Cl.common,Cl.displacementmap]),vertexShader:Al.depth_vert,fragmentShader:Al.depth_frag},normal:{uniforms:Za([Cl.common,Cl.bumpmap,Cl.normalmap,Cl.displacementmap,{opacity:{value:1}}]),vertexShader:Al.meshnormal_vert,fragmentShader:Al.meshnormal_frag},sprite:{uniforms:Za([Cl.sprite,Cl.fog]),vertexShader:Al.sprite_vert,fragmentShader:Al.sprite_frag},background:{uniforms:{uvTransform:{value:new Sr},t2D:{value:null},backgroundIntensity:{value:1}},vertexShader:Al.background_vert,fragmentShader:Al.background_frag},backgroundCube:{uniforms:{envMap:{value:null},flipEnvMap:{value:-1},backgroundBlurriness:{value:0},backgroundIntensity:{value:1},backgroundRotation:{value:new Sr}},vertexShader:Al.backgroundCube_vert,fragmentShader:Al.backgroundCube_frag},cube:{uniforms:{tCube:{value:null},tFlip:{value:-1},opacity:{value:1}},vertexShader:Al.cube_vert,fragmentShader:Al.cube_frag},equirect:{uniforms:{tEquirect:{value:null}},vertexShader:Al.equirect_vert,fragmentShader:Al.equirect_frag},distanceRGBA:{uniforms:Za([Cl.common,Cl.displacementmap,{referencePosition:{value:new br},nearDistance:{value:1},farDistance:{value:1e3}}]),vertexShader:Al.distanceRGBA_vert,fragmentShader:Al.distanceRGBA_frag},shadow:{uniforms:Za([Cl.lights,Cl.fog,{color:{value:new ma(0)},opacity:{value:1}}]),vertexShader:Al.shadow_vert,fragmentShader:Al.shadow_frag}};Pl.physical={uniforms:Za([Pl.standard.uniforms,{clearcoat:{value:0},clearcoatMap:{value:null},clearcoatMapTransform:{value:new Sr},clearcoatNormalMap:{value:null},clearcoatNormalMapTransform:{value:new Sr},clearcoatNormalScale:{value:new _r(1,1)},clearcoatRoughness:{value:0},clearcoatRoughnessMap:{value:null},clearcoatRoughnessMapTransform:{value:new Sr},dispersion:{value:0},iridescence:{value:0},iridescenceMap:{value:null},iridescenceMapTransform:{value:new Sr},iridescenceIOR:{value:1.3},iridescenceThicknessMinimum:{value:100},iridescenceThicknessMaximum:{value:400},iridescenceThicknessMap:{value:null},iridescenceThicknessMapTransform:{value:new Sr},sheen:{value:0},sheenColor:{value:new ma(0)},sheenColorMap:{value:null},sheenColorMapTransform:{value:new Sr},sheenRoughness:{value:1},sheenRoughnessMap:{value:null},sheenRoughnessMapTransform:{value:new Sr},transmission:{value:0},transmissionMap:{value:null},transmissionMapTransform:{value:new Sr},transmissionSamplerSize:{value:new _r},transmissionSamplerMap:{value:null},thickness:{value:0},thicknessMap:{value:null},thicknessMapTransform:{value:new Sr},attenuationDistance:{value:0},attenuationColor:{value:new ma(0)},specularColor:{value:new ma(1,1,1)},specularColorMap:{value:null},specularColorMapTransform:{value:new Sr},specularIntensity:{value:1},specularIntensityMap:{value:null},specularIntensityMapTransform:{value:new Sr},anisotropyVector:{value:new _r},anisotropyMap:{value:null},anisotropyMapTransform:{value:new Sr}}]),vertexShader:Al.meshphysical_vert,fragmentShader:Al.meshphysical_frag};const Dl={r:0,b:0,g:0},Ul=new Li,Ll=new Ti;function Il(t,e,n,r,i,a,s){const o=new ma(0);let l,c,h=1==a?0:1,u=null,d=0,p=null;function f(t){let r=1==t.isScene?t.background:null;if(r&&r.isTexture){r=(t.backgroundBlurriness>0?n:e).get(r)}return r}function m(e,n){e.getRGB(Dl,$a(t)),r.buffers.color.setClear(Dl.r,Dl.g,Dl.b,n,s)}return{getClearColor:function(){return o},setClearColor:function(t,e=1){o.set(t),h=e,m(o,h)},getClearAlpha:function(){return h},setClearAlpha:function(t){h=t,m(o,h)},render:function(e){let n=0;const i=f(e);null===i?m(o,h):i&&i.isColor&&(m(i,1),n=1);const a=t.xr.getEnvironmentBlendMode();"additive"===a?r.buffers.color.setClear(0,0,0,1,s):"alpha-blend"===a&&r.buffers.color.setClear(0,0,0,0,s),(t.autoClear||n)&&(r.buffers.depth.setTest(1),r.buffers.depth.setMask(1),r.buffers.color.setMask(1),t.clear(t.autoClearColor,t.autoClearDepth,t.autoClearStencil))},addToRenderList:function(e,n){const r=f(n);r&&(r.isCubeTexture||r.mapping===Pe)?(void 0===c&&(c=new ja(new Ya(1,1,1),new Qa({name:"BackgroundCubeMaterial",uniforms:Ka(Pl.backgroundCube.uniforms),vertexShader:Pl.backgroundCube.vertexShader,fragmentShader:Pl.backgroundCube.fragmentShader,side:1,depthTest:0,depthWrite:0,fog:0,allowOverride:0})),c.geometry.deleteAttribute("normal"),c.geometry.deleteAttribute("uv"),c.onBeforeRender=function(t,e,n){this.matrixWorld.copyPosition(n.matrixWorld)},Object.defineProperty(c.material,"envMap",{get:function(){return this.uniforms.envMap.value}}),i.update(c)),Ul.copy(n.backgroundRotation),Ul.x*=-1,Ul.y*=-1,Ul.z*=-1,r.isCubeTexture&&0==r.isRenderTargetTexture&&(Ul.y*=-1,Ul.z*=-1),c.material.uniforms.envMap.value=r,c.material.uniforms.flipEnvMap.value=r.isCubeTexture&&0==r.isRenderTargetTexture?-1:1,c.material.uniforms.backgroundBlurriness.value=n.backgroundBlurriness,c.material.uniforms.backgroundIntensity.value=n.backgroundIntensity,c.material.uniforms.backgroundRotation.value.setFromMatrix4(Ll.makeRotationFromEuler(Ul)),c.material.toneMapped=Ir.getTransfer(r.colorSpace)!==qn,u===r&&d===r.version&&p===t.toneMapping||(c.material.needsUpdate=1,u=r,d=r.version,p=t.toneMapping),c.layers.enableAll(),e.unshift(c,c.geometry,c.material,0,0,null)):r&&r.isTexture&&(void 0===l&&(l=new ja(new vo(2,2),new Qa({name:"BackgroundMaterial",uniforms:Ka(Pl.background.uniforms),vertexShader:Pl.background.vertexShader,fragmentShader:Pl.background.fragmentShader,side:0,depthTest:0,depthWrite:0,fog:0,allowOverride:0})),l.geometry.deleteAttribute("normal"),Object.defineProperty(l.material,"map",{get:function(){return this.uniforms.t2D.value}}),i.update(l)),l.material.uniforms.t2D.value=r,l.material.uniforms.backgroundIntensity.value=n.backgroundIntensity,l.material.toneMapped=Ir.getTransfer(r.colorSpace)!==qn,1==r.matrixAutoUpdate&&r.updateMatrix(),l.material.uniforms.uvTransform.value.copy(r.matrix),u===r&&d===r.version&&p===t.toneMapping||(l.material.needsUpdate=1,u=r,d=r.version,p=t.toneMapping),l.layers.enableAll(),e.unshift(l,l.geometry,l.material,0,0,null))},dispose:function(){void 0!==c&&(c.geometry.dispose(),c.material.dispose(),c=void 0),void 0!==l&&(l.geometry.dispose(),l.material.dispose(),l=void 0)}}}function Nl(t,e){const n=t.getParameter(t.MAX_VERTEX_ATTRIBS),r={},i=c(null);let a=i,s=0;function o(e){return t.bindVertexArray(e)}function l(e){return t.deleteVertexArray(e)}function c(t){const e=[],r=[],i=[];for(let t=0;t<n;t++)e[t]=0,r[t]=0,i[t]=0;return{geometry:null,program:null,wireframe:0,newAttributes:e,enabledAttributes:r,attributeDivisors:i,object:t,attributes:{},index:null}}function h(){const t=a.newAttributes;for(let e=0,n=t.length;e<n;e++)t[e]=0}function u(t){d(t,0)}function d(e,n){const r=a.newAttributes,i=a.enabledAttributes,s=a.attributeDivisors;r[e]=1,0===i[e]&&(t.enableVertexAttribArray(e),i[e]=1),s[e]!==n&&(t.vertexAttribDivisor(e,n),s[e]=n)}function p(){const e=a.newAttributes,n=a.enabledAttributes;for(let r=0,i=n.length;r<i;r++)n[r]!==e[r]&&(t.disableVertexAttribArray(r),n[r]=0)}function f(e,n,r,i,a,s,o){1==o?t.vertexAttribIPointer(e,n,r,a,s):t.vertexAttribPointer(e,n,r,i,a,s)}function m(){g(),s=1,a!==i&&(a=i,o(a.object))}function g(){i.geometry=null,i.program=null,i.wireframe=0}return{setup:function(n,i,l,m,g){let v=0;const x=function(e,n,i){const a=1==i.wireframe;let s=r[e.id];void 0===s&&(s={},r[e.id]=s);let o=s[n.id];void 0===o&&(o={},s[n.id]=o);let l=o[a];void 0===l&&(l=c(t.createVertexArray()),o[a]=l);return l}(m,l,i);a!==x&&(a=x,o(a.object)),v=function(t,e,n,r){const i=a.attributes,s=e.attributes;let o=0;const l=n.getAttributes();for(const e in l){if(l[e].location>=0){const n=i[e];let r=s[e];if(void 0===r&&("instanceMatrix"===e&&t.instanceMatrix&&(r=t.instanceMatrix),"instanceColor"===e&&t.instanceColor&&(r=t.instanceColor)),void 0===n)return 1;if(n.attribute!==r)return 1;if(r&&n.data!==r.data)return 1;o++}}return a.attributesNum!==o||a.index!==r?1:0}(n,m,l,g),v&&function(t,e,n,r){const i={},s=e.attributes;let o=0;const l=n.getAttributes();for(const e in l){if(l[e].location>=0){let n=s[e];void 0===n&&("instanceMatrix"===e&&t.instanceMatrix&&(n=t.instanceMatrix),"instanceColor"===e&&t.instanceColor&&(n=t.instanceColor));const r={};r.attribute=n,n&&n.data&&(r.data=n.data),i[e]=r,o++}}a.attributes=i,a.attributesNum=o,a.index=r}(n,m,l,g),null!==g&&e.update(g,t.ELEMENT_ARRAY_BUFFER),(v||s)&&(s=0,function(n,r,i,a){h();const s=a.attributes,o=i.getAttributes(),l=r.defaultAttributeValues;for(const r in o){const i=o[r];if(i.location>=0){let o=s[r];if(void 0===o&&("instanceMatrix"===r&&n.instanceMatrix&&(o=n.instanceMatrix),"instanceColor"===r&&n.instanceColor&&(o=n.instanceColor)),void 0!==o){const r=o.normalized,s=o.itemSize,l=e.get(o);if(void 0===l)continue;const c=l.buffer,h=l.type,p=l.bytesPerElement,m=h===t.INT||h===t.UNSIGNED_INT||o.gpuType===We;if(o.isInterleavedBufferAttribute){const e=o.data,l=e.stride,g=o.offset;if(e.isInstancedInterleavedBuffer){for(let t=0;t<i.locationSize;t++)d(i.location+t,e.meshPerAttribute);1!=n.isInstancedMesh&&void 0===a._maxInstanceCount&&(a._maxInstanceCount=e.meshPerAttribute*e.count)}else for(let t=0;t<i.locationSize;t++)u(i.location+t);t.bindBuffer(t.ARRAY_BUFFER,c);for(let t=0;t<i.locationSize;t++)f(i.location+t,s/i.locationSize,h,r,l*p,(g+s/i.locationSize*t)*p,m)}else{if(o.isInstancedBufferAttribute){for(let t=0;t<i.locationSize;t++)d(i.location+t,o.meshPerAttribute);1!=n.isInstancedMesh&&void 0===a._maxInstanceCount&&(a._maxInstanceCount=o.meshPerAttribute*o.count)}else for(let t=0;t<i.locationSize;t++)u(i.location+t);t.bindBuffer(t.ARRAY_BUFFER,c);for(let t=0;t<i.locationSize;t++)f(i.location+t,s/i.locationSize,h,r,s*p,s/i.locationSize*t*p,m)}}else if(void 0!==l){const e=l[r];if(void 0!==e)switch(e.length){case 2:t.vertexAttrib2fv(i.location,e);break;case 3:t.vertexAttrib3fv(i.location,e);break;case 4:t.vertexAttrib4fv(i.location,e);break;default:t.vertexAttrib1fv(i.location,e)}}}}p()}(n,i,l,m),null!==g&&t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e.get(g).buffer))},reset:m,resetDefaultState:g,dispose:function(){m();for(const t in r){const e=r[t];for(const t in e){const n=e[t];for(const t in n)l(n[t].object),delete n[t];delete e[t]}delete r[t]}},releaseStatesOfGeometry:function(t){if(void 0===r[t.id])return;const e=r[t.id];for(const t in e){const n=e[t];for(const t in n)l(n[t].object),delete n[t];delete e[t]}delete r[t.id]},releaseStatesOfProgram:function(t){for(const e in r){const n=r[e];if(void 0===n[t.id])continue;const i=n[t.id];for(const t in i)l(i[t].object),delete i[t];delete n[t.id]}},initAttributes:h,enableAttribute:u,disableUnusedAttributes:p}}function Ol(t,e,n){let r;function i(e,i,a){0!==a&&(t.drawArraysInstanced(r,e,i,a),n.update(i,r,a))}this.setMode=function(t){r=t},this.render=function(e,i){t.drawArrays(r,e,i),n.update(i,r,1)},this.renderInstances=i,this.renderMultiDraw=function(t,i,a){if(0===a)return;e.get("WEBGL_multi_draw").multiDrawArraysWEBGL(r,t,0,i,0,a);let s=0;for(let t=0;t<a;t++)s+=i[t];n.update(s,r,1)},this.renderMultiDrawInstances=function(t,a,s,o){if(0===s)return;const l=e.get("WEBGL_multi_draw");if(null===l)for(let e=0;e<t.length;e++)i(t[e],a[e],o[e]);else{l.multiDrawArraysInstancedWEBGL(r,t,0,a,0,o,0,s);let e=0;for(let t=0;t<s;t++)e+=a[t]*o[t];n.update(e,r,1)}}}function Fl(t,e,n,r){let i;function a(e){if("highp"===e){if(t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.HIGH_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.HIGH_FLOAT).precision>0)return"highp";e="mediump"}return"mediump"===e&&t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.MEDIUM_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.MEDIUM_FLOAT).precision>0?"mediump":"lowp"}let s=void 0!==n.precision?n.precision:"highp";const o=a(s);o!==s&&(s=o);const l=1==n.logarithmicDepthBuffer,c=1==n.reversedDepthBuffer&&e.has("EXT_clip_control"),h=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS),u=t.getParameter(t.MAX_VERTEX_TEXTURE_IMAGE_UNITS);return{isWebGL2:1,getMaxAnisotropy:function(){if(void 0!==i)return i;if(1==e.has("EXT_texture_filter_anisotropic")){const n=e.get("EXT_texture_filter_anisotropic");i=t.getParameter(n.MAX_TEXTURE_MAX_ANISOTROPY_EXT)}else i=0;return i},getMaxPrecision:a,textureFormatReadable:function(e){return e!==Je&&r.convert(e)!==t.getParameter(t.IMPLEMENTATION_COLOR_READ_FORMAT)?0:1},textureTypeReadable:function(n){const i=n===qe&&(e.has("EXT_color_buffer_half_float")||e.has("EXT_color_buffer_float"));return n===ze||r.convert(n)===t.getParameter(t.IMPLEMENTATION_COLOR_READ_TYPE)||n===je||i?1:0},precision:s,logarithmicDepthBuffer:l,reversedDepthBuffer:c,maxTextures:h,maxVertexTextures:u,maxTextureSize:t.getParameter(t.MAX_TEXTURE_SIZE),maxCubemapSize:t.getParameter(t.MAX_CUBE_MAP_TEXTURE_SIZE),maxAttributes:t.getParameter(t.MAX_VERTEX_ATTRIBS),maxVertexUniforms:t.getParameter(t.MAX_VERTEX_UNIFORM_VECTORS),maxVaryings:t.getParameter(t.MAX_VARYING_VECTORS),maxFragmentUniforms:t.getParameter(t.MAX_FRAGMENT_UNIFORM_VECTORS),vertexTextures:u>0,maxSamples:t.getParameter(t.MAX_SAMPLES)}}function Bl(t){const e=this;let n=null,r=0,i=0,a=0;const s=new Gs,o=new Sr,l={value:null,needsUpdate:0};function c(t,n,r,i){const a=null!==t?t.length:0;let c=null;if(0!==a){if(c=l.value,1!=i||null===c){const e=r+4*a,i=n.matrixWorldInverse;o.getNormalMatrix(i),(null===c||c.length<e)&&(c=new Float32Array(e));for(let e=0,n=r;e!==a;++e,n+=4)s.copy(t[e]).applyMatrix4(i,o),s.normal.toArray(c,n),c[n+3]=s.constant}l.value=c,l.needsUpdate=1}return e.numPlanes=a,e.numIntersection=0,c}this.uniform=l,this.numPlanes=0,this.numIntersection=0,this.init=function(t,e){const n=0!==t.length||e||0!==r||i;return i=e,r=t.length,n},this.beginShadows=function(){a=1,c(null)},this.endShadows=function(){a=0},this.setGlobalState=function(t,e){n=c(t,e,0)},this.setState=function(s,o,h){const u=s.clippingPlanes,d=s.clipIntersection,p=s.clipShadows,f=t.get(s);if(!i||null===u||0===u.length||a&&!p)a?c(null):function(){l.value!==n&&(l.value=n,l.needsUpdate=r>0);e.numPlanes=r,e.numIntersection=0}();else{const t=a?0:r,e=4*t;let i=f.clippingState||null;l.value=i,i=c(u,o,e,h);for(let t=0;t!==e;++t)i[t]=n[t];f.clippingState=i,this.numIntersection=d?this.numPlanes:0,this.numPlanes+=t}}}function kl(t){let e=new WeakMap;function n(t,e){return e===Ae?t.mapping=we:e===Ce&&(t.mapping=Re),t}function r(t){const n=t.target;n.removeEventListener("dispose",r);const i=e.get(n);void 0!==i&&(e.delete(n),i.dispose())}return{get:function(i){if(i&&i.isTexture){const a=i.mapping;if(a===Ae||a===Ce){if(e.has(i)){return n(e.get(i).texture,i.mapping)}{const a=i.image;if(a&&a.height>0){const s=new ls(a.height);return s.fromEquirectangularTexture(t,i),e.set(i,s),i.addEventListener("dispose",r),n(s.texture,i.mapping)}return null}}}return i},dispose:function(){e=new WeakMap}}}const zl=[.125,.215,.35,.446,.526,.582],Vl=20,Hl=new hl,Gl=new ma;let Wl=null,Xl=0,jl=0,ql=0;const Yl=(1+Math.sqrt(5))/2,Kl=1/Yl,Zl=[new br(-Yl,Kl,0),new br(Yl,Kl,0),new br(-Kl,0,Yl),new br(Kl,0,Yl),new br(0,Yl,-Kl),new br(0,Yl,Kl),new br(-1,1,-1),new br(1,1,-1),new br(-1,1,1),new br(1,1,1)],$l=new br;class Jl{constructor(t){this._renderer=t,this._pingPongRenderTarget=null,this._lodMax=0,this._cubeSize=0,this._lodPlanes=[],this._sizeLods=[],this._sigmas=[],this._blurMaterial=null,this._cubemapMaterial=null,this._equirectMaterial=null,this._compileMaterial(this._blurMaterial)}fromScene(t,e=0,n=.1,r=100,i={}){const{size:a=256,position:s=$l}=i;Wl=this._renderer.getRenderTarget(),Xl=this._renderer.getActiveCubeFace(),jl=this._renderer.getActiveMipmapLevel(),ql=this._renderer.xr.enabled,this._renderer.xr.enabled=0,this._setSize(a);const o=this._allocateTargets();return o.depthBuffer=1,this._sceneToCubeUV(t,n,r,o,s),e>0&&this._blur(o,0,0,e),this._applyPMREM(o),this._cleanup(o),o}fromEquirectangular(t,e=null){return this._fromTexture(t,e)}fromCubemap(t,e=null){return this._fromTexture(t,e)}compileCubemapShader(){null===this._cubemapMaterial&&(this._cubemapMaterial=nc(),this._compileMaterial(this._cubemapMaterial))}compileEquirectangularShader(){null===this._equirectMaterial&&(this._equirectMaterial=ec(),this._compileMaterial(this._equirectMaterial))}dispose(){this._dispose(),null!==this._cubemapMaterial&&this._cubemapMaterial.dispose(),null!==this._equirectMaterial&&this._equirectMaterial.dispose()}_setSize(t){this._lodMax=Math.floor(Math.log2(t)),this._cubeSize=Math.pow(2,this._lodMax)}_dispose(){null!==this._blurMaterial&&this._blurMaterial.dispose(),null!==this._pingPongRenderTarget&&this._pingPongRenderTarget.dispose();for(let t=0;t<this._lodPlanes.length;t++)this._lodPlanes[t].dispose()}_cleanup(t){this._renderer.setRenderTarget(Wl,Xl,jl),this._renderer.xr.enabled=ql,t.scissorTest=0,tc(t,0,0,t.width,t.height)}_fromTexture(t,e){t.mapping===we||t.mapping===Re?this._setSize(0===t.image.length?16:t.image[0].width||t.image[0].image.width):this._setSize(t.image.width/4),Wl=this._renderer.getRenderTarget(),Xl=this._renderer.getActiveCubeFace(),jl=this._renderer.getActiveMipmapLevel(),ql=this._renderer.xr.enabled,this._renderer.xr.enabled=0;const n=e||this._allocateTargets();return this._textureToCubeUV(t,n),this._applyPMREM(n),this._cleanup(n),n}_allocateTargets(){const t=3*Math.max(this._cubeSize,112),e=4*this._cubeSize,n={magFilter:Fe,minFilter:Fe,generateMipmaps:0,type:qe,format:Je,colorSpace:Xn,depthBuffer:0},r=Ql(t,e,n);if(null===this._pingPongRenderTarget||this._pingPongRenderTarget.width!==t||this._pingPongRenderTarget.height!==e){null!==this._pingPongRenderTarget&&this._dispose(),this._pingPongRenderTarget=Ql(t,e,n);const{_lodMax:r}=this;({sizeLods:this._sizeLods,lodPlanes:this._lodPlanes,sigmas:this._sigmas}=function(t){const e=[],n=[],r=[];let i=t;const a=t-4+1+zl.length;for(let s=0;s<a;s++){const a=Math.pow(2,i);n.push(a);let o=1/a;s>t-4?o=zl[s-t+4-1]:0===s&&(o=0),r.push(o);const l=1/(a-2),c=-l,h=1+l,u=[c,c,h,c,h,h,c,c,h,h,c,h],d=6,p=6,f=3,m=2,g=1,v=new Float32Array(f*p*d),x=new Float32Array(m*p*d),_=new Float32Array(g*p*d);for(let t=0;t<d;t++){const e=t%3*2/3-1,n=t>2?0:-1,r=[e,n,0,e+2/3,n,0,e+2/3,n+1,0,e,n,0,e+2/3,n+1,0,e,n+1,0];v.set(r,f*p*t),x.set(u,m*p*t);const i=[t,t,t,t,t,t];_.set(i,g*p*t)}const y=new Ia;y.setAttribute("position",new Ta(v,f)),y.setAttribute("uv",new Ta(x,m)),y.setAttribute("faceIndex",new Ta(_,g)),e.push(y),i>4&&i--}return{lodPlanes:e,sizeLods:n,sigmas:r}}(r)),this._blurMaterial=function(t,e,n){const r=new Float32Array(Vl),i=new br(0,1,0),a=new Qa({name:"SphericalGaussianBlur",defines:{n:Vl,CUBEUV_TEXEL_WIDTH:1/e,CUBEUV_TEXEL_HEIGHT:1/n,CUBEUV_MAX_MIP:`${t}.0`},uniforms:{envMap:{value:null},samples:{value:1},weights:{value:r},latitudinal:{value:0},dTheta:{value:0},mipInt:{value:0},poleAxis:{value:i}},vertexShader:rc(),fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform sampler2D envMap;\n\t\t\tuniform int samples;\n\t\t\tuniform float weights[ n ];\n\t\t\tuniform bool latitudinal;\n\t\t\tuniform float dTheta;\n\t\t\tuniform float mipInt;\n\t\t\tuniform vec3 poleAxis;\n\n\t\t\t#define ENVMAP_TYPE_CUBE_UV\n\t\t\t#include <cube_uv_reflection_fragment>\n\n\t\t\tvec3 getSample( float theta, vec3 axis ) {\n\n\t\t\t\tfloat cosTheta = cos( theta );\n\t\t\t\t// Rodrigues' axis-angle rotation\n\t\t\t\tvec3 sampleDirection = vOutputDirection * cosTheta\n\t\t\t\t\t+ cross( axis, vOutputDirection ) * sin( theta )\n\t\t\t\t\t+ axis * dot( axis, vOutputDirection ) * ( 1.0 - cosTheta );\n\n\t\t\t\treturn bilinearCubeUV( envMap, sampleDirection, mipInt );\n\n\t\t\t}\n\n\t\t\tvoid main() {\n\n\t\t\t\tvec3 axis = latitudinal ? poleAxis : cross( poleAxis, vOutputDirection );\n\n\t\t\t\tif ( all( equal( axis, vec3( 0.0 ) ) ) ) {\n\n\t\t\t\t\taxis = vec3( vOutputDirection.z, 0.0, - vOutputDirection.x );\n\n\t\t\t\t}\n\n\t\t\t\taxis = normalize( axis );\n\n\t\t\t\tgl_FragColor = vec4( 0.0, 0.0, 0.0, 1.0 );\n\t\t\t\tgl_FragColor.rgb += weights[ 0 ] * getSample( 0.0, axis );\n\n\t\t\t\tfor ( int i = 1; i < n; i++ ) {\n\n\t\t\t\t\tif ( i >= samples ) {\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t}\n\n\t\t\t\t\tfloat theta = dTheta * float( i );\n\t\t\t\t\tgl_FragColor.rgb += weights[ i ] * getSample( -1.0 * theta, axis );\n\t\t\t\t\tgl_FragColor.rgb += weights[ i ] * getSample( theta, axis );\n\n\t\t\t\t}\n\n\t\t\t}\n\t\t",blending:0,depthTest:0,depthWrite:0});return a}(r,t,e)}return r}_compileMaterial(t){const e=new ja(this._lodPlanes[0],t);this._renderer.compile(e,Hl)}_sceneToCubeUV(t,e,n,r,i){const a=new is(90,1,e,n),s=[1,-1,1,1,1,1],o=[1,1,1,-1,-1,-1],l=this._renderer,c=l.autoClear,h=l.toneMapping;l.getClearColor(Gl),l.toneMapping=0,l.autoClear=0;l.state.buffers.depth.getReversed()&&(l.setRenderTarget(r),l.clearDepth(),l.setRenderTarget(null));const u=new _a({name:"PMREM.Background",side:1,depthWrite:0,depthTest:0}),d=new ja(new Ya,u);let p=0;const f=t.background;f?f.isColor&&(u.color.copy(f),t.background=null,p=1):(u.color.copy(Gl),p=1);for(let e=0;e<6;e++){const n=e%3;0===n?(a.up.set(0,s[e],0),a.position.set(i.x,i.y,i.z),a.lookAt(i.x+o[e],i.y,i.z)):1===n?(a.up.set(0,0,s[e]),a.position.set(i.x,i.y,i.z),a.lookAt(i.x,i.y+o[e],i.z)):(a.up.set(0,s[e],0),a.position.set(i.x,i.y,i.z),a.lookAt(i.x,i.y,i.z+o[e]));const c=this._cubeSize;tc(r,n*c,e>2?c:0,c,c),l.setRenderTarget(r),p&&l.render(d,a),l.render(t,a)}d.geometry.dispose(),d.material.dispose(),l.toneMapping=h,l.autoClear=c,t.background=f}_textureToCubeUV(t,e){const n=this._renderer,r=t.mapping===we||t.mapping===Re;r?(null===this._cubemapMaterial&&(this._cubemapMaterial=nc()),this._cubemapMaterial.uniforms.flipEnvMap.value=0==t.isRenderTargetTexture?-1:1):null===this._equirectMaterial&&(this._equirectMaterial=ec());const i=r?this._cubemapMaterial:this._equirectMaterial,a=new ja(this._lodPlanes[0],i);i.uniforms.envMap.value=t;const s=this._cubeSize;tc(e,0,0,3*s,2*s),n.setRenderTarget(e),n.render(a,Hl)}_applyPMREM(t){const e=this._renderer,n=e.autoClear;e.autoClear=0;const r=this._lodPlanes.length;for(let e=1;e<r;e++){const n=Math.sqrt(this._sigmas[e]*this._sigmas[e]-this._sigmas[e-1]*this._sigmas[e-1]),i=Zl[(r-e-1)%Zl.length];this._blur(t,e-1,e,n,i)}e.autoClear=n}_blur(t,e,n,r,i){const a=this._pingPongRenderTarget;this._halfBlur(t,a,e,n,r,"latitudinal",i),this._halfBlur(a,t,n,n,r,"longitudinal",i)}_halfBlur(t,e,n,r,i,a,s){const o=this._renderer,l=this._blurMaterial,c=new ja(this._lodPlanes[r],l),h=l.uniforms,u=this._sizeLods[n]-1,d=isFinite(i)?Math.PI/(2*u):2*Math.PI/39,p=i/d,f=isFinite(i)?1+Math.floor(3*p):Vl,m=[];let g=0;for(let t=0;t<Vl;++t){const e=t/p,n=Math.exp(-e*e/2);m.push(n),0===t?g+=n:t<f&&(g+=2*n)}for(let t=0;t<m.length;t++)m[t]=m[t]/g;h.envMap.value=t.texture,h.samples.value=f,h.weights.value=m,h.latitudinal.value="latitudinal"===a,s&&(h.poleAxis.value=s);const{_lodMax:v}=this;h.dTheta.value=d,h.mipInt.value=v-n;const x=this._sizeLods[r];tc(e,3*x*(r>v-4?r-v+4:0),4*(this._cubeSize-x),3*x,2*x),o.setRenderTarget(e),o.render(c,Hl)}}function Ql(t,e,n){const r=new qr(t,e,n);return r.texture.mapping=Pe,r.texture.name="PMREM.cubeUv",r.scissorTest=1,r}function tc(t,e,n,r,i){t.viewport.set(e,n,r,i),t.scissor.set(e,n,r,i)}function ec(){return new Qa({name:"EquirectangularToCubeUV",uniforms:{envMap:{value:null}},vertexShader:rc(),fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform sampler2D envMap;\n\n\t\t\t#include <common>\n\n\t\t\tvoid main() {\n\n\t\t\t\tvec3 outputDirection = normalize( vOutputDirection );\n\t\t\t\tvec2 uv = equirectUv( outputDirection );\n\n\t\t\t\tgl_FragColor = vec4( texture2D ( envMap, uv ).rgb, 1.0 );\n\n\t\t\t}\n\t\t",blending:0,depthTest:0,depthWrite:0})}function nc(){return new Qa({name:"CubemapToCubeUV",uniforms:{envMap:{value:null},flipEnvMap:{value:-1}},vertexShader:rc(),fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tuniform float flipEnvMap;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform samplerCube envMap;\n\n\t\t\tvoid main() {\n\n\t\t\t\tgl_FragColor = textureCube( envMap, vec3( flipEnvMap * vOutputDirection.x, vOutputDirection.yz ) );\n\n\t\t\t}\n\t\t",blending:0,depthTest:0,depthWrite:0})}function rc(){return"\n\n\t\tprecision mediump float;\n\t\tprecision mediump int;\n\n\t\tattribute float faceIndex;\n\n\t\tvarying vec3 vOutputDirection;\n\n\t\t// RH coordinate system; PMREM face-indexing convention\n\t\tvec3 getDirection( vec2 uv, float face ) {\n\n\t\t\tuv = 2.0 * uv - 1.0;\n\n\t\t\tvec3 direction = vec3( uv, 1.0 );\n\n\t\t\tif ( face == 0.0 ) {\n\n\t\t\t\tdirection = direction.zyx; // ( 1, v, u ) pos x\n\n\t\t\t} else if ( face == 1.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xz *= -1.0; // ( -u, 1, -v ) pos y\n\n\t\t\t} else if ( face == 2.0 ) {\n\n\t\t\t\tdirection.x *= -1.0; // ( -u, v, 1 ) pos z\n\n\t\t\t} else if ( face == 3.0 ) {\n\n\t\t\t\tdirection = direction.zyx;\n\t\t\t\tdirection.xz *= -1.0; // ( -1, v, -u ) neg x\n\n\t\t\t} else if ( face == 4.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xy *= -1.0; // ( -u, -1, v ) neg y\n\n\t\t\t} else if ( face == 5.0 ) {\n\n\t\t\t\tdirection.z *= -1.0; // ( u, v, -1 ) neg z\n\n\t\t\t}\n\n\t\t\treturn direction;\n\n\t\t}\n\n\t\tvoid main() {\n\n\t\t\tvOutputDirection = getDirection( uv, faceIndex );\n\t\t\tgl_Position = vec4( position, 1.0 );\n\n\t\t}\n\t"}function ic(t){let e=new WeakMap,n=null;function r(t){const n=t.target;n.removeEventListener("dispose",r);const i=e.get(n);void 0!==i&&(e.delete(n),i.dispose())}return{get:function(i){if(i&&i.isTexture){const a=i.mapping,s=a===Ae||a===Ce,o=a===we||a===Re;if(s||o){let a=e.get(i);const l=void 0!==a?a.texture.pmremVersion:0;if(i.isRenderTargetTexture&&i.pmremVersion!==l)return null===n&&(n=new Jl(t)),a=s?n.fromEquirectangular(i,a):n.fromCubemap(i,a),a.texture.pmremVersion=i.pmremVersion,e.set(i,a),a.texture;if(void 0!==a)return a.texture;{const l=i.image;return s&&l&&l.height>0||o&&l&&function(t){let e=0;const n=6;for(let r=0;r<n;r++)void 0!==t[r]&&e++;return e===n}(l)?(null===n&&(n=new Jl(t)),a=s?n.fromEquirectangular(i):n.fromCubemap(i),a.texture.pmremVersion=i.pmremVersion,e.set(i,a),i.addEventListener("dispose",r),a.texture):null}}}return i},dispose:function(){e=new WeakMap,null!==n&&(n.dispose(),n=null)}}}function ac(t){const e={};function n(n){if(void 0!==e[n])return e[n];let r;switch(n){case"WEBGL_depth_texture":r=t.getExtension("WEBGL_depth_texture")||t.getExtension("MOZ_WEBGL_depth_texture")||t.getExtension("WEBKIT_WEBGL_depth_texture");break;case"EXT_texture_filter_anisotropic":r=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":r=t.getExtension("WEBGL_compressed_texture_s3tc")||t.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":r=t.getExtension("WEBGL_compressed_texture_pvrtc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;default:r=t.getExtension(n)}return e[n]=r,r}return{has:function(t){return null!==n(t)},init:function(){n("EXT_color_buffer_float"),n("WEBGL_clip_cull_distance"),n("OES_texture_float_linear"),n("EXT_color_buffer_half_float"),n("WEBGL_multisampled_render_to_texture"),n("WEBGL_render_shared_exponent")},get:function(t){const e=n(t);return null===e&&Pr("THREE.WebGLRenderer: "+t+" extension not supported."),e}}}function sc(t,e,n,r){const i={},a=new WeakMap;function s(t){const o=t.target;null!==o.index&&e.remove(o.index);for(const t in o.attributes)e.remove(o.attributes[t]);o.removeEventListener("dispose",s),delete i[o.id];const l=a.get(o);l&&(e.remove(l),a.delete(o)),r.releaseStatesOfGeometry(o),1==o.isInstancedBufferGeometry&&delete o._maxInstanceCount,n.memory.geometries--}function o(t){const n=[],r=t.index,i=t.attributes.position;let s=0;if(null!==r){const t=r.array;s=r.version;for(let e=0,r=t.length;e<r;e+=3){const r=t[e+0],i=t[e+1],a=t[e+2];n.push(r,i,i,a,a,r)}}else{if(void 0===i)return;{const t=i.array;s=i.version;for(let e=0,r=t.length/3-1;e<r;e+=3){const t=e+0,r=e+1,i=e+2;n.push(t,r,r,i,i,t)}}}const o=new(wr(n)?Ma:Sa)(n,1);o.version=s;const l=a.get(t);l&&e.remove(l),a.set(t,o)}return{get:function(t,e){return 1==i[e.id]||(e.addEventListener("dispose",s),i[e.id]=1,n.memory.geometries++),e},update:function(n){const r=n.attributes;for(const n in r)e.update(r[n],t.ARRAY_BUFFER)},getWireframeAttribute:function(t){const e=a.get(t);if(e){const n=t.index;null!==n&&e.version<n.version&&o(t)}else o(t);return a.get(t)}}}function oc(t,e,n){let r,i,a;function s(e,s,o){0!==o&&(t.drawElementsInstanced(r,s,i,e*a,o),n.update(s,r,o))}this.setMode=function(t){r=t},this.setIndex=function(t){i=t.type,a=t.bytesPerElement},this.render=function(e,s){t.drawElements(r,s,i,e*a),n.update(s,r,1)},this.renderInstances=s,this.renderMultiDraw=function(t,a,s){if(0===s)return;e.get("WEBGL_multi_draw").multiDrawElementsWEBGL(r,a,0,i,t,0,s);let o=0;for(let t=0;t<s;t++)o+=a[t];n.update(o,r,1)},this.renderMultiDrawInstances=function(t,o,l,c){if(0===l)return;const h=e.get("WEBGL_multi_draw");if(null===h)for(let e=0;e<t.length;e++)s(t[e]/a,o[e],c[e]);else{h.multiDrawElementsInstancedWEBGL(r,o,0,i,t,0,c,0,l);let e=0;for(let t=0;t<l;t++)e+=o[t]*c[t];n.update(e,r,1)}}}function lc(t){const e={frame:0,calls:0,triangles:0,points:0,lines:0};return{memory:{geometries:0,textures:0},render:e,programs:null,autoReset:1,reset:function(){e.calls=0,e.triangles=0,e.points=0,e.lines=0},update:function(n,r,i){switch(e.calls++,r){case t.TRIANGLES:e.triangles+=i*(n/3);break;case t.LINES:e.lines+=i*(n/2);break;case t.LINE_STRIP:e.lines+=i*(n-1);break;case t.LINE_LOOP:e.lines+=i*n;break;case t.POINTS:e.points+=i*n}}}}function cc(t,e,n){const r=new WeakMap,i=new Xr;return{update:function(a,s,o){const l=a.morphTargetInfluences,c=s.morphAttributes.position||s.morphAttributes.normal||s.morphAttributes.color,h=void 0!==c?c.length:0;let u=r.get(s);if(void 0===u||u.count!==h){void 0!==u&&u.texture.dispose();const d=void 0!==s.morphAttributes.position,p=void 0!==s.morphAttributes.normal,f=void 0!==s.morphAttributes.color,m=s.morphAttributes.position||[],g=s.morphAttributes.normal||[],v=s.morphAttributes.color||[];let x=0;1==d&&(x=1),1==p&&(x=2),1==f&&(x=3);let _=s.attributes.position.count*x,y=1;_>e.maxTextureSize&&(y=Math.ceil(_/e.maxTextureSize),_=e.maxTextureSize);const b=new Float32Array(_*y*4*h),E=new Yr(b,_,y,h);E.type=je,E.needsUpdate=1;const T=4*x;for(let M=0;M<h;M++){const w=m[M],R=g[M],A=v[M],C=_*y*4*M;for(let P=0;P<w.count;P++){const D=P*T;1==d&&(i.fromBufferAttribute(w,P),b[C+D+0]=i.x,b[C+D+1]=i.y,b[C+D+2]=i.z,b[C+D+3]=0),1==p&&(i.fromBufferAttribute(R,P),b[C+D+4]=i.x,b[C+D+5]=i.y,b[C+D+6]=i.z,b[C+D+7]=0),1==f&&(i.fromBufferAttribute(A,P),b[C+D+8]=i.x,b[C+D+9]=i.y,b[C+D+10]=i.z,b[C+D+11]=4===A.itemSize?i.w:1)}}function S(){E.dispose(),r.delete(s),s.removeEventListener("dispose",S)}u={count:h,texture:E,size:new _r(_,y)},r.set(s,u),s.addEventListener("dispose",S)}if(1==a.isInstancedMesh&&null!==a.morphTexture)o.getUniforms().setValue(t,"morphTexture",a.morphTexture,n);else{let U=0;for(let I=0;I<l.length;I++)U+=l[I];const L=s.morphTargetsRelative?1:1-U;o.getUniforms().setValue(t,"morphTargetBaseInfluence",L),o.getUniforms().setValue(t,"morphTargetInfluences",l)}o.getUniforms().setValue(t,"morphTargetsTexture",u.texture,n),o.getUniforms().setValue(t,"morphTargetsTextureSize",u.size)}}}function hc(t,e,n,r){let i=new WeakMap;function a(t){const e=t.target;e.removeEventListener("dispose",a),n.remove(e.instanceMatrix),null!==e.instanceColor&&n.remove(e.instanceColor)}return{update:function(s){const o=r.render.frame,l=s.geometry,c=e.get(s,l);if(i.get(c)!==o&&(e.update(c),i.set(c,o)),s.isInstancedMesh&&(0==s.hasEventListener("dispose",a)&&s.addEventListener("dispose",a),i.get(s)!==o&&(n.update(s.instanceMatrix,t.ARRAY_BUFFER),null!==s.instanceColor&&n.update(s.instanceColor,t.ARRAY_BUFFER),i.set(s,o))),s.isSkinnedMesh){const t=s.skeleton;i.get(t)!==o&&(t.update(),i.set(t,o))}return c},dispose:function(){i=new WeakMap}}}const uc=new Wr,dc=new go(1,1),pc=new Yr,fc=new Kr,mc=new os,gc=[],vc=[],xc=new Float32Array(16),_c=new Float32Array(9),yc=new Float32Array(4);function bc(t,e,n){const r=t[0];if(r<=0||r>0)return t;const i=e*n;let a=gc[i];if(void 0===a&&(a=new Float32Array(i),gc[i]=a),0!==e){r.toArray(a,0);for(let r=1,i=0;r!==e;++r)i+=n,t[r].toArray(a,i)}return a}function Ec(t,e){if(t.length!==e.length)return 0;for(let n=0,r=t.length;n<r;n++)if(t[n]!==e[n])return 0;return 1}function Tc(t,e){for(let n=0,r=e.length;n<r;n++)t[n]=e[n]}function Sc(t,e){let n=vc[e];void 0===n&&(n=new Int32Array(e),vc[e]=n);for(let r=0;r!==e;++r)n[r]=t.allocateTextureUnit();return n}function Mc(t,e){const n=this.cache;n[0]!==e&&(t.uniform1f(this.addr,e),n[0]=e)}function wc(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y||(t.uniform2f(this.addr,e.x,e.y),n[0]=e.x,n[1]=e.y);else{if(Ec(n,e))return;t.uniform2fv(this.addr,e),Tc(n,e)}}function Rc(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y&&n[2]===e.z||(t.uniform3f(this.addr,e.x,e.y,e.z),n[0]=e.x,n[1]=e.y,n[2]=e.z);else if(void 0!==e.r)n[0]===e.r&&n[1]===e.g&&n[2]===e.b||(t.uniform3f(this.addr,e.r,e.g,e.b),n[0]=e.r,n[1]=e.g,n[2]=e.b);else{if(Ec(n,e))return;t.uniform3fv(this.addr,e),Tc(n,e)}}function Ac(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y&&n[2]===e.z&&n[3]===e.w||(t.uniform4f(this.addr,e.x,e.y,e.z,e.w),n[0]=e.x,n[1]=e.y,n[2]=e.z,n[3]=e.w);else{if(Ec(n,e))return;t.uniform4fv(this.addr,e),Tc(n,e)}}function Cc(t,e){const n=this.cache,r=e.elements;if(void 0===r){if(Ec(n,e))return;t.uniformMatrix2fv(this.addr,0,e),Tc(n,e)}else{if(Ec(n,r))return;yc.set(r),t.uniformMatrix2fv(this.addr,0,yc),Tc(n,r)}}function Pc(t,e){const n=this.cache,r=e.elements;if(void 0===r){if(Ec(n,e))return;t.uniformMatrix3fv(this.addr,0,e),Tc(n,e)}else{if(Ec(n,r))return;_c.set(r),t.uniformMatrix3fv(this.addr,0,_c),Tc(n,r)}}function Dc(t,e){const n=this.cache,r=e.elements;if(void 0===r){if(Ec(n,e))return;t.uniformMatrix4fv(this.addr,0,e),Tc(n,e)}else{if(Ec(n,r))return;xc.set(r),t.uniformMatrix4fv(this.addr,0,xc),Tc(n,r)}}function Uc(t,e){const n=this.cache;n[0]!==e&&(t.uniform1i(this.addr,e),n[0]=e)}function Lc(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y||(t.uniform2i(this.addr,e.x,e.y),n[0]=e.x,n[1]=e.y);else{if(Ec(n,e))return;t.uniform2iv(this.addr,e),Tc(n,e)}}function Ic(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y&&n[2]===e.z||(t.uniform3i(this.addr,e.x,e.y,e.z),n[0]=e.x,n[1]=e.y,n[2]=e.z);else{if(Ec(n,e))return;t.uniform3iv(this.addr,e),Tc(n,e)}}function Nc(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y&&n[2]===e.z&&n[3]===e.w||(t.uniform4i(this.addr,e.x,e.y,e.z,e.w),n[0]=e.x,n[1]=e.y,n[2]=e.z,n[3]=e.w);else{if(Ec(n,e))return;t.uniform4iv(this.addr,e),Tc(n,e)}}function Oc(t,e){const n=this.cache;n[0]!==e&&(t.uniform1ui(this.addr,e),n[0]=e)}function Fc(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y||(t.uniform2ui(this.addr,e.x,e.y),n[0]=e.x,n[1]=e.y);else{if(Ec(n,e))return;t.uniform2uiv(this.addr,e),Tc(n,e)}}function Bc(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y&&n[2]===e.z||(t.uniform3ui(this.addr,e.x,e.y,e.z),n[0]=e.x,n[1]=e.y,n[2]=e.z);else{if(Ec(n,e))return;t.uniform3uiv(this.addr,e),Tc(n,e)}}function kc(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y&&n[2]===e.z&&n[3]===e.w||(t.uniform4ui(this.addr,e.x,e.y,e.z,e.w),n[0]=e.x,n[1]=e.y,n[2]=e.z,n[3]=e.w);else{if(Ec(n,e))return;t.uniform4uiv(this.addr,e),Tc(n,e)}}function zc(t,e,n){const r=this.cache,i=n.allocateTextureUnit();let a;r[0]!==i&&(t.uniform1i(this.addr,i),r[0]=i),this.type===t.SAMPLER_2D_SHADOW?(dc.compareFunction=515,a=dc):a=uc,n.setTexture2D(e||a,i)}function Vc(t,e,n){const r=this.cache,i=n.allocateTextureUnit();r[0]!==i&&(t.uniform1i(this.addr,i),r[0]=i),n.setTexture3D(e||fc,i)}function Hc(t,e,n){const r=this.cache,i=n.allocateTextureUnit();r[0]!==i&&(t.uniform1i(this.addr,i),r[0]=i),n.setTextureCube(e||mc,i)}function Gc(t,e,n){const r=this.cache,i=n.allocateTextureUnit();r[0]!==i&&(t.uniform1i(this.addr,i),r[0]=i),n.setTexture2DArray(e||pc,i)}function Wc(t,e){t.uniform1fv(this.addr,e)}function Xc(t,e){const n=bc(e,this.size,2);t.uniform2fv(this.addr,n)}function jc(t,e){const n=bc(e,this.size,3);t.uniform3fv(this.addr,n)}function qc(t,e){const n=bc(e,this.size,4);t.uniform4fv(this.addr,n)}function Yc(t,e){const n=bc(e,this.size,4);t.uniformMatrix2fv(this.addr,0,n)}function Kc(t,e){const n=bc(e,this.size,9);t.uniformMatrix3fv(this.addr,0,n)}function Zc(t,e){const n=bc(e,this.size,16);t.uniformMatrix4fv(this.addr,0,n)}function $c(t,e){t.uniform1iv(this.addr,e)}function Jc(t,e){t.uniform2iv(this.addr,e)}function Qc(t,e){t.uniform3iv(this.addr,e)}function th(t,e){t.uniform4iv(this.addr,e)}function eh(t,e){t.uniform1uiv(this.addr,e)}function nh(t,e){t.uniform2uiv(this.addr,e)}function rh(t,e){t.uniform3uiv(this.addr,e)}function ih(t,e){t.uniform4uiv(this.addr,e)}function ah(t,e,n){const r=this.cache,i=e.length,a=Sc(n,i);Ec(r,a)||(t.uniform1iv(this.addr,a),Tc(r,a));for(let t=0;t!==i;++t)n.setTexture2D(e[t]||uc,a[t])}function sh(t,e,n){const r=this.cache,i=e.length,a=Sc(n,i);Ec(r,a)||(t.uniform1iv(this.addr,a),Tc(r,a));for(let t=0;t!==i;++t)n.setTexture3D(e[t]||fc,a[t])}function oh(t,e,n){const r=this.cache,i=e.length,a=Sc(n,i);Ec(r,a)||(t.uniform1iv(this.addr,a),Tc(r,a));for(let t=0;t!==i;++t)n.setTextureCube(e[t]||mc,a[t])}function lh(t,e,n){const r=this.cache,i=e.length,a=Sc(n,i);Ec(r,a)||(t.uniform1iv(this.addr,a),Tc(r,a));for(let t=0;t!==i;++t)n.setTexture2DArray(e[t]||pc,a[t])}class ch{constructor(t,e,n){this.id=t,this.addr=n,this.cache=[],this.type=e.type,this.setValue=function(t){switch(t){case 5126:return Mc;case 35664:return wc;case 35665:return Rc;case 35666:return Ac;case 35674:return Cc;case 35675:return Pc;case 35676:return Dc;case 5124:case 35670:return Uc;case 35667:case 35671:return Lc;case 35668:case 35672:return Ic;case 35669:case 35673:return Nc;case 5125:return Oc;case 36294:return Fc;case 36295:return Bc;case 36296:return kc;case 35678:case 36198:case 36298:case 36306:case 35682:return zc;case 35679:case 36299:case 36307:return Vc;case 35680:case 36300:case 36308:case 36293:return Hc;case 36289:case 36303:case 36311:case 36292:return Gc}}(e.type)}}class hh{constructor(t,e,n){this.id=t,this.addr=n,this.cache=[],this.type=e.type,this.size=e.size,this.setValue=function(t){switch(t){case 5126:return Wc;case 35664:return Xc;case 35665:return jc;case 35666:return qc;case 35674:return Yc;case 35675:return Kc;case 35676:return Zc;case 5124:case 35670:return $c;case 35667:case 35671:return Jc;case 35668:case 35672:return Qc;case 35669:case 35673:return th;case 5125:return eh;case 36294:return nh;case 36295:return rh;case 36296:return ih;case 35678:case 36198:case 36298:case 36306:case 35682:return ah;case 35679:case 36299:case 36307:return sh;case 35680:case 36300:case 36308:case 36293:return oh;case 36289:case 36303:case 36311:case 36292:return lh}}(e.type)}}class uh{constructor(t){this.id=t,this.seq=[],this.map={}}setValue(t,e,n){const r=this.seq;for(let i=0,a=r.length;i!==a;++i){const a=r[i];a.setValue(t,e[a.id],n)}}}const dh=/(\w+)(\])?(\[|\.)?/g;function ph(t,e){t.seq.push(e),t.map[e.id]=e}function fh(t,e,n){const r=t.name,i=r.length;for(dh.lastIndex=0;;){const a=dh.exec(r),s=dh.lastIndex;let o=a[1];const l="]"===a[2],c=a[3];if(l&&(o|=0),void 0===c||"["===c&&s+2===i){ph(n,void 0===c?new ch(o,t,e):new hh(o,t,e));break}{let t=n.map[o];void 0===t&&(t=new uh(o),ph(n,t)),n=t}}}class mh{constructor(t,e){this.seq=[],this.map={};const n=t.getProgramParameter(e,t.ACTIVE_UNIFORMS);for(let r=0;r<n;++r){const n=t.getActiveUniform(e,r);fh(n,t.getUniformLocation(e,n.name),this)}}setValue(t,e,n,r){const i=this.map[e];void 0!==i&&i.setValue(t,n,r)}setOptional(t,e,n){const r=e[n];void 0!==r&&this.setValue(t,n,r)}static upload(t,e,n,r){for(let i=0,a=e.length;i!==a;++i){const a=e[i],s=n[a.id];0!=s.needsUpdate&&a.setValue(t,s.value,r)}}static seqWithValue(t,e){const n=[];for(let r=0,i=t.length;r!==i;++r){const i=t[r];i.id in e&&n.push(i)}return n}}function gh(t,e,n){const r=t.createShader(e);return t.shaderSource(r,n),t.compileShader(r),r}let vh=0;const xh=new Sr;function _h(t,e,n){const r=t.getShaderParameter(e,t.COMPILE_STATUS),i=(t.getShaderInfoLog(e)||"").trim();if(r&&""===i)return"";const a=/ERROR: 0:(\d+)/.exec(i);if(a){const r=parseInt(a[1]);return n.toUpperCase()+"\n\n"+i+"\n\n"+function(t,e){const n=t.split("\n"),r=[],i=Math.max(e-6,0),a=Math.min(e+6,n.length);for(let t=i;t<a;t++){const i=t+1;r.push(`${i===e?">":" "} ${i}: ${n[t]}`)}return r.join("\n")}(t.getShaderSource(e),r)}return i}function yh(t,e){const n=function(t){Ir._getMatrix(xh,Ir.workingColorSpace,t);const e=`mat3( ${xh.elements.map(t=>t.toFixed(4))} )`;switch(Ir.getTransfer(t)){case jn:return[e,"LinearTransferOETF"];case qn:return[e,"sRGBTransferOETF"];default:return[e,"LinearTransferOETF"]}}(e);return[`vec4 ${t}( vec4 value ) {`,`\treturn ${n[1]}( vec4( value.rgb * ${n[0]}, value.a ) );`,"}"].join("\n")}function bh(t,e){let n;switch(e){case 1:default:n="Linear";break;case 2:n="Reinhard";break;case 3:n="Cineon";break;case 4:n="ACESFilmic";break;case 6:n="AgX";break;case 7:n="Neutral";break;case 5:n="Custom"}return"vec3 "+t+"( vec3 color ) { return "+n+"ToneMapping( color ); }"}const Eh=new br;function Th(){Ir.getLuminanceCoefficients(Eh);return["float luminance( const in vec3 rgb ) {",`\tconst vec3 weights = vec3( ${Eh.x.toFixed(4)}, ${Eh.y.toFixed(4)}, ${Eh.z.toFixed(4)} );`,"\treturn dot( weights, rgb );","}"].join("\n")}function Sh(t){return""!==t}function Mh(t,e){const n=e.numSpotLightShadows+e.numSpotLightMaps-e.numSpotLightShadowsWithMaps;return t.replace(/NUM_DIR_LIGHTS/g,e.numDirLights).replace(/NUM_SPOT_LIGHTS/g,e.numSpotLights).replace(/NUM_SPOT_LIGHT_MAPS/g,e.numSpotLightMaps).replace(/NUM_SPOT_LIGHT_COORDS/g,n).replace(/NUM_RECT_AREA_LIGHTS/g,e.numRectAreaLights).replace(/NUM_POINT_LIGHTS/g,e.numPointLights).replace(/NUM_HEMI_LIGHTS/g,e.numHemiLights).replace(/NUM_DIR_LIGHT_SHADOWS/g,e.numDirLightShadows).replace(/NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS/g,e.numSpotLightShadowsWithMaps).replace(/NUM_SPOT_LIGHT_SHADOWS/g,e.numSpotLightShadows).replace(/NUM_POINT_LIGHT_SHADOWS/g,e.numPointLightShadows)}function wh(t,e){return t.replace(/NUM_CLIPPING_PLANES/g,e.numClippingPlanes).replace(/UNION_CLIPPING_PLANES/g,e.numClippingPlanes-e.numClipIntersection)}const Rh=/^[ \t]*#include +<([\w\d./]+)>/gm;function Ah(t){return t.replace(Rh,Ph)}const Ch=new Map;function Ph(t,e){let n=Al[e];if(void 0===n){const t=Ch.get(e);if(void 0===t)throw new Error("Can not resolve #include <"+e+">");n=Al[t]}return Ah(n)}const Dh=/#pragma unroll_loop_start\s+for\s*\(\s*int\s+i\s*=\s*(\d+)\s*;\s*i\s*<\s*(\d+)\s*;\s*i\s*\+\+\s*\)\s*{([\s\S]+?)}\s+#pragma unroll_loop_end/g;function Uh(t){return t.replace(Dh,Lh)}function Lh(t,e,n,r){let i="";for(let t=parseInt(e);t<parseInt(n);t++)i+=r.replace(/\[\s*i\s*\]/g,"[ "+t+" ]").replace(/UNROLLED_LOOP_INDEX/g,t);return i}function Ih(t){let e=`precision ${t.precision} float;\n\tprecision ${t.precision} int;\n\tprecision ${t.precision} sampler2D;\n\tprecision ${t.precision} samplerCube;\n\tprecision ${t.precision} sampler3D;\n\tprecision ${t.precision} sampler2DArray;\n\tprecision ${t.precision} sampler2DShadow;\n\tprecision ${t.precision} samplerCubeShadow;\n\tprecision ${t.precision} sampler2DArrayShadow;\n\tprecision ${t.precision} isampler2D;\n\tprecision ${t.precision} isampler3D;\n\tprecision ${t.precision} isamplerCube;\n\tprecision ${t.precision} isampler2DArray;\n\tprecision ${t.precision} usampler2D;\n\tprecision ${t.precision} usampler3D;\n\tprecision ${t.precision} usamplerCube;\n\tprecision ${t.precision} usampler2DArray;\n\t`;return"highp"===t.precision?e+="\n#define HIGH_PRECISION":"mediump"===t.precision?e+="\n#define MEDIUM_PRECISION":"lowp"===t.precision&&(e+="\n#define LOW_PRECISION"),e}function Nh(t,e,n,r){const i=t.getContext(),a=n.defines;let s=n.vertexShader,o=n.fragmentShader;const l=function(t){let e="SHADOWMAP_TYPE_BASIC";return 1===t.shadowMapType?e="SHADOWMAP_TYPE_PCF":2===t.shadowMapType?e="SHADOWMAP_TYPE_PCF_SOFT":3===t.shadowMapType&&(e="SHADOWMAP_TYPE_VSM"),e}(n),c=function(t){let e="ENVMAP_TYPE_CUBE";if(t.envMap)switch(t.envMapMode){case we:case Re:e="ENVMAP_TYPE_CUBE";break;case Pe:e="ENVMAP_TYPE_CUBE_UV"}return e}(n),h=function(t){let e="ENVMAP_MODE_REFLECTION";t.envMap&&t.envMapMode===Re&&(e="ENVMAP_MODE_REFRACTION");return e}(n),u=function(t){let e="ENVMAP_BLENDING_NONE";if(t.envMap)switch(t.combine){case 0:e="ENVMAP_BLENDING_MULTIPLY";break;case 1:e="ENVMAP_BLENDING_MIX";break;case 2:e="ENVMAP_BLENDING_ADD"}return e}(n),d=function(t){const e=t.envMapCubeUVHeight;if(null===e)return null;const n=Math.log2(e)-2,r=1/e;return{texelWidth:1/(3*Math.max(Math.pow(2,n),112)),texelHeight:r,maxMip:n}}(n),p=function(t){return[t.extensionClipCullDistance?"#extension GL_ANGLE_clip_cull_distance : require":"",t.extensionMultiDraw?"#extension GL_ANGLE_multi_draw : require":""].filter(Sh).join("\n")}(n),f=function(t){const e=[];for(const n in t){const r=t[n];0!=r&&e.push("#define "+n+" "+r)}return e.join("\n")}(a),m=i.createProgram();let g,v,x=n.glslVersion?"#version "+n.glslVersion+"\n":"";n.isRawShaderMaterial?(g=["#define SHADER_TYPE "+n.shaderType,"#define SHADER_NAME "+n.shaderName,f].filter(Sh).join("\n"),g.length>0&&(g+="\n"),v=["#define SHADER_TYPE "+n.shaderType,"#define SHADER_NAME "+n.shaderName,f].filter(Sh).join("\n"),v.length>0&&(v+="\n")):(g=[Ih(n),"#define SHADER_TYPE "+n.shaderType,"#define SHADER_NAME "+n.shaderName,f,n.extensionClipCullDistance?"#define USE_CLIP_DISTANCE":"",n.batching?"#define USE_BATCHING":"",n.batchingColor?"#define USE_BATCHING_COLOR":"",n.instancing?"#define USE_INSTANCING":"",n.instancingColor?"#define USE_INSTANCING_COLOR":"",n.instancingMorph?"#define USE_INSTANCING_MORPH":"",n.useFog&&n.fog?"#define USE_FOG":"",n.useFog&&n.fogExp2?"#define FOG_EXP2":"",n.map?"#define USE_MAP":"",n.envMap?"#define USE_ENVMAP":"",n.envMap?"#define "+h:"",n.lightMap?"#define USE_LIGHTMAP":"",n.aoMap?"#define USE_AOMAP":"",n.bumpMap?"#define USE_BUMPMAP":"",n.normalMap?"#define USE_NORMALMAP":"",n.normalMapObjectSpace?"#define USE_NORMALMAP_OBJECTSPACE":"",n.normalMapTangentSpace?"#define USE_NORMALMAP_TANGENTSPACE":"",n.displacementMap?"#define USE_DISPLACEMENTMAP":"",n.emissiveMap?"#define USE_EMISSIVEMAP":"",n.anisotropy?"#define USE_ANISOTROPY":"",n.anisotropyMap?"#define USE_ANISOTROPYMAP":"",n.clearcoatMap?"#define USE_CLEARCOATMAP":"",n.clearcoatRoughnessMap?"#define USE_CLEARCOAT_ROUGHNESSMAP":"",n.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",n.iridescenceMap?"#define USE_IRIDESCENCEMAP":"",n.iridescenceThicknessMap?"#define USE_IRIDESCENCE_THICKNESSMAP":"",n.specularMap?"#define USE_SPECULARMAP":"",n.specularColorMap?"#define USE_SPECULAR_COLORMAP":"",n.specularIntensityMap?"#define USE_SPECULAR_INTENSITYMAP":"",n.roughnessMap?"#define USE_ROUGHNESSMAP":"",n.metalnessMap?"#define USE_METALNESSMAP":"",n.alphaMap?"#define USE_ALPHAMAP":"",n.alphaHash?"#define USE_ALPHAHASH":"",n.transmission?"#define USE_TRANSMISSION":"",n.transmissionMap?"#define USE_TRANSMISSIONMAP":"",n.thicknessMap?"#define USE_THICKNESSMAP":"",n.sheenColorMap?"#define USE_SHEEN_COLORMAP":"",n.sheenRoughnessMap?"#define USE_SHEEN_ROUGHNESSMAP":"",n.mapUv?"#define MAP_UV "+n.mapUv:"",n.alphaMapUv?"#define ALPHAMAP_UV "+n.alphaMapUv:"",n.lightMapUv?"#define LIGHTMAP_UV "+n.lightMapUv:"",n.aoMapUv?"#define AOMAP_UV "+n.aoMapUv:"",n.emissiveMapUv?"#define EMISSIVEMAP_UV "+n.emissiveMapUv:"",n.bumpMapUv?"#define BUMPMAP_UV "+n.bumpMapUv:"",n.normalMapUv?"#define NORMALMAP_UV "+n.normalMapUv:"",n.displacementMapUv?"#define DISPLACEMENTMAP_UV "+n.displacementMapUv:"",n.metalnessMapUv?"#define METALNESSMAP_UV "+n.metalnessMapUv:"",n.roughnessMapUv?"#define ROUGHNESSMAP_UV "+n.roughnessMapUv:"",n.anisotropyMapUv?"#define ANISOTROPYMAP_UV "+n.anisotropyMapUv:"",n.clearcoatMapUv?"#define CLEARCOATMAP_UV "+n.clearcoatMapUv:"",n.clearcoatNormalMapUv?"#define CLEARCOAT_NORMALMAP_UV "+n.clearcoatNormalMapUv:"",n.clearcoatRoughnessMapUv?"#define CLEARCOAT_ROUGHNESSMAP_UV "+n.clearcoatRoughnessMapUv:"",n.iridescenceMapUv?"#define IRIDESCENCEMAP_UV "+n.iridescenceMapUv:"",n.iridescenceThicknessMapUv?"#define IRIDESCENCE_THICKNESSMAP_UV "+n.iridescenceThicknessMapUv:"",n.sheenColorMapUv?"#define SHEEN_COLORMAP_UV "+n.sheenColorMapUv:"",n.sheenRoughnessMapUv?"#define SHEEN_ROUGHNESSMAP_UV "+n.sheenRoughnessMapUv:"",n.specularMapUv?"#define SPECULARMAP_UV "+n.specularMapUv:"",n.specularColorMapUv?"#define SPECULAR_COLORMAP_UV "+n.specularColorMapUv:"",n.specularIntensityMapUv?"#define SPECULAR_INTENSITYMAP_UV "+n.specularIntensityMapUv:"",n.transmissionMapUv?"#define TRANSMISSIONMAP_UV "+n.transmissionMapUv:"",n.thicknessMapUv?"#define THICKNESSMAP_UV "+n.thicknessMapUv:"",n.vertexTangents&&0==n.flatShading?"#define USE_TANGENT":"",n.vertexColors?"#define USE_COLOR":"",n.vertexAlphas?"#define USE_COLOR_ALPHA":"",n.vertexUv1s?"#define USE_UV1":"",n.vertexUv2s?"#define USE_UV2":"",n.vertexUv3s?"#define USE_UV3":"",n.pointsUvs?"#define USE_POINTS_UV":"",n.flatShading?"#define FLAT_SHADED":"",n.skinning?"#define USE_SKINNING":"",n.morphTargets?"#define USE_MORPHTARGETS":"",n.morphNormals&&0==n.flatShading?"#define USE_MORPHNORMALS":"",n.morphColors?"#define USE_MORPHCOLORS":"",n.morphTargetsCount>0?"#define MORPHTARGETS_TEXTURE_STRIDE "+n.morphTextureStride:"",n.morphTargetsCount>0?"#define MORPHTARGETS_COUNT "+n.morphTargetsCount:"",n.doubleSided?"#define DOUBLE_SIDED":"",n.flipSided?"#define FLIP_SIDED":"",n.shadowMapEnabled?"#define USE_SHADOWMAP":"",n.shadowMapEnabled?"#define "+l:"",n.sizeAttenuation?"#define USE_SIZEATTENUATION":"",n.numLightProbes>0?"#define USE_LIGHT_PROBES":"",n.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",n.reversedDepthBuffer?"#define USE_REVERSEDEPTHBUF":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;","#ifdef USE_INSTANCING","\tattribute mat4 instanceMatrix;","#endif","#ifdef USE_INSTANCING_COLOR","\tattribute vec3 instanceColor;","#endif","#ifdef USE_INSTANCING_MORPH","\tuniform sampler2D morphTexture;","#endif","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_UV1","\tattribute vec2 uv1;","#endif","#ifdef USE_UV2","\tattribute vec2 uv2;","#endif","#ifdef USE_UV3","\tattribute vec2 uv3;","#endif","#ifdef USE_TANGENT","\tattribute vec4 tangent;","#endif","#if defined( USE_COLOR_ALPHA )","\tattribute vec4 color;","#elif defined( USE_COLOR )","\tattribute vec3 color;","#endif","#ifdef USE_SKINNING","\tattribute vec4 skinIndex;","\tattribute vec4 skinWeight;","#endif","\n"].filter(Sh).join("\n"),v=[Ih(n),"#define SHADER_TYPE "+n.shaderType,"#define SHADER_NAME "+n.shaderName,f,n.useFog&&n.fog?"#define USE_FOG":"",n.useFog&&n.fogExp2?"#define FOG_EXP2":"",n.alphaToCoverage?"#define ALPHA_TO_COVERAGE":"",n.map?"#define USE_MAP":"",n.matcap?"#define USE_MATCAP":"",n.envMap?"#define USE_ENVMAP":"",n.envMap?"#define "+c:"",n.envMap?"#define "+h:"",n.envMap?"#define "+u:"",d?"#define CUBEUV_TEXEL_WIDTH "+d.texelWidth:"",d?"#define CUBEUV_TEXEL_HEIGHT "+d.texelHeight:"",d?"#define CUBEUV_MAX_MIP "+d.maxMip+".0":"",n.lightMap?"#define USE_LIGHTMAP":"",n.aoMap?"#define USE_AOMAP":"",n.bumpMap?"#define USE_BUMPMAP":"",n.normalMap?"#define USE_NORMALMAP":"",n.normalMapObjectSpace?"#define USE_NORMALMAP_OBJECTSPACE":"",n.normalMapTangentSpace?"#define USE_NORMALMAP_TANGENTSPACE":"",n.emissiveMap?"#define USE_EMISSIVEMAP":"",n.anisotropy?"#define USE_ANISOTROPY":"",n.anisotropyMap?"#define USE_ANISOTROPYMAP":"",n.clearcoat?"#define USE_CLEARCOAT":"",n.clearcoatMap?"#define USE_CLEARCOATMAP":"",n.clearcoatRoughnessMap?"#define USE_CLEARCOAT_ROUGHNESSMAP":"",n.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",n.dispersion?"#define USE_DISPERSION":"",n.iridescence?"#define USE_IRIDESCENCE":"",n.iridescenceMap?"#define USE_IRIDESCENCEMAP":"",n.iridescenceThicknessMap?"#define USE_IRIDESCENCE_THICKNESSMAP":"",n.specularMap?"#define USE_SPECULARMAP":"",n.specularColorMap?"#define USE_SPECULAR_COLORMAP":"",n.specularIntensityMap?"#define USE_SPECULAR_INTENSITYMAP":"",n.roughnessMap?"#define USE_ROUGHNESSMAP":"",n.metalnessMap?"#define USE_METALNESSMAP":"",n.alphaMap?"#define USE_ALPHAMAP":"",n.alphaTest?"#define USE_ALPHATEST":"",n.alphaHash?"#define USE_ALPHAHASH":"",n.sheen?"#define USE_SHEEN":"",n.sheenColorMap?"#define USE_SHEEN_COLORMAP":"",n.sheenRoughnessMap?"#define USE_SHEEN_ROUGHNESSMAP":"",n.transmission?"#define USE_TRANSMISSION":"",n.transmissionMap?"#define USE_TRANSMISSIONMAP":"",n.thicknessMap?"#define USE_THICKNESSMAP":"",n.vertexTangents&&0==n.flatShading?"#define USE_TANGENT":"",n.vertexColors||n.instancingColor||n.batchingColor?"#define USE_COLOR":"",n.vertexAlphas?"#define USE_COLOR_ALPHA":"",n.vertexUv1s?"#define USE_UV1":"",n.vertexUv2s?"#define USE_UV2":"",n.vertexUv3s?"#define USE_UV3":"",n.pointsUvs?"#define USE_POINTS_UV":"",n.gradientMap?"#define USE_GRADIENTMAP":"",n.flatShading?"#define FLAT_SHADED":"",n.doubleSided?"#define DOUBLE_SIDED":"",n.flipSided?"#define FLIP_SIDED":"",n.shadowMapEnabled?"#define USE_SHADOWMAP":"",n.shadowMapEnabled?"#define "+l:"",n.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",n.numLightProbes>0?"#define USE_LIGHT_PROBES":"",n.decodeVideoTexture?"#define DECODE_VIDEO_TEXTURE":"",n.decodeVideoTextureEmissive?"#define DECODE_VIDEO_TEXTURE_EMISSIVE":"",n.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",n.reversedDepthBuffer?"#define USE_REVERSEDEPTHBUF":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;",0!==n.toneMapping?"#define TONE_MAPPING":"",0!==n.toneMapping?Al.tonemapping_pars_fragment:"",0!==n.toneMapping?bh("toneMapping",n.toneMapping):"",n.dithering?"#define DITHERING":"",n.opaque?"#define OPAQUE":"",Al.colorspace_pars_fragment,yh("linearToOutputTexel",n.outputColorSpace),Th(),n.useDepthPacking?"#define DEPTH_PACKING "+n.depthPacking:"","\n"].filter(Sh).join("\n")),s=Ah(s),s=Mh(s,n),s=wh(s,n),o=Ah(o),o=Mh(o,n),o=wh(o,n),s=Uh(s),o=Uh(o),1!=n.isRawShaderMaterial&&(x="#version 300 es\n",g=[p,"#define attribute in","#define varying out","#define texture2D texture"].join("\n")+"\n"+g,v=["#define varying in",n.glslVersion===ir?"":"layout(location = 0) out highp vec4 pc_fragColor;",n.glslVersion===ir?"":"#define gl_FragColor pc_fragColor","#define gl_FragDepthEXT gl_FragDepth","#define texture2D texture","#define textureCube texture","#define texture2DProj textureProj","#define texture2DLodEXT textureLod","#define texture2DProjLodEXT textureProjLod","#define textureCubeLodEXT textureLod","#define texture2DGradEXT textureGrad","#define texture2DProjGradEXT textureProjGrad","#define textureCubeGradEXT textureGrad"].join("\n")+"\n"+v);const _=x+g+s,y=x+v+o,b=gh(i,i.VERTEX_SHADER,_),E=gh(i,i.FRAGMENT_SHADER,y);function T(e){if(t.debug.checkShaderErrors){const n=i.getProgramInfoLog(m)||"",r=i.getShaderInfoLog(b)||"",a=i.getShaderInfoLog(E)||"",s=n.trim(),o=r.trim(),l=a.trim();let c=1,h=1;if(0==i.getProgramParameter(m,i.LINK_STATUS))if(c=0,"function"==typeof t.debug.onShaderError)t.debug.onShaderError(i,m,b,E);else{_h(i,b,"vertex"),_h(i,E,"fragment")}else""!==s||""!==o&&""!==l||(h=0);h&&(e.diagnostics={runnable:c,programLog:s,vertexShader:{log:o,prefix:g},fragmentShader:{log:l,prefix:v}})}i.deleteShader(b),i.deleteShader(E),S=new mh(i,m),M=function(t,e){const n={},r=t.getProgramParameter(e,t.ACTIVE_ATTRIBUTES);for(let i=0;i<r;i++){const r=t.getActiveAttrib(e,i),a=r.name;let s=1;r.type===t.FLOAT_MAT2&&(s=2),r.type===t.FLOAT_MAT3&&(s=3),r.type===t.FLOAT_MAT4&&(s=4),n[a]={type:r.type,location:t.getAttribLocation(e,a),locationSize:s}}return n}(i,m)}let S,M;i.attachShader(m,b),i.attachShader(m,E),void 0!==n.index0AttributeName?i.bindAttribLocation(m,0,n.index0AttributeName):1==n.morphTargets&&i.bindAttribLocation(m,0,"position"),i.linkProgram(m),this.getUniforms=function(){return void 0===S&&T(this),S},this.getAttributes=function(){return void 0===M&&T(this),M};let w=0==n.rendererExtensionParallelShaderCompile;return this.isReady=function(){return 0==w&&(w=i.getProgramParameter(m,37297)),w},this.destroy=function(){r.releaseStatesOfProgram(this),i.deleteProgram(m),this.program=void 0},this.type=n.shaderType,this.name=n.shaderName,this.id=vh++,this.cacheKey=e,this.usedTimes=1,this.program=m,this.vertexShader=b,this.fragmentShader=E,this}let Oh=0;class Fh{constructor(){this.shaderCache=new Map,this.materialCache=new Map}update(t){const e=t.vertexShader,n=t.fragmentShader,r=this._getShaderStage(e),i=this._getShaderStage(n),a=this._getShaderCacheForMaterial(t);return 0==a.has(r)&&(a.add(r),r.usedTimes++),0==a.has(i)&&(a.add(i),i.usedTimes++),this}remove(t){const e=this.materialCache.get(t);for(const t of e)t.usedTimes--,0===t.usedTimes&&this.shaderCache.delete(t.code);return this.materialCache.delete(t),this}getVertexShaderID(t){return this._getShaderStage(t.vertexShader).id}getFragmentShaderID(t){return this._getShaderStage(t.fragmentShader).id}dispose(){this.shaderCache.clear(),this.materialCache.clear()}_getShaderCacheForMaterial(t){const e=this.materialCache;let n=e.get(t);return void 0===n&&(n=new Set,e.set(t,n)),n}_getShaderStage(t){const e=this.shaderCache;let n=e.get(t);return void 0===n&&(n=new Bh(t),e.set(t,n)),n}}class Bh{constructor(t){this.id=Oh++,this.code=t,this.usedTimes=0}}function kh(t,e,n,r,i,a,s){const o=new Ii,l=new Fh,c=new Set,h=[],u=i.logarithmicDepthBuffer,d=i.vertexTextures;let p=i.precision;const f={MeshDepthMaterial:"depth",MeshDistanceMaterial:"distanceRGBA",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshToonMaterial:"toon",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",MeshMatcapMaterial:"matcap",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points",ShadowMaterial:"shadow",SpriteMaterial:"sprite"};function m(t){return c.add(t),0===t?"uv":`uv${t}`}return{getParameters:function(a,o,h,g,v){const x=g.fog,_=v.geometry,y=a.isMeshStandardMaterial?g.environment:null,b=(a.isMeshStandardMaterial?n:e).get(a.envMap||y),E=b&&b.mapping===Pe?b.image.height:null,T=f[a.type];null!==a.precision&&(p=i.getMaxPrecision(a.precision),a.precision);const S=_.morphAttributes.position||_.morphAttributes.normal||_.morphAttributes.color,M=void 0!==S?S.length:0;let w,R,A,C,P=0;if(void 0!==_.morphAttributes.position&&(P=1),void 0!==_.morphAttributes.normal&&(P=2),void 0!==_.morphAttributes.color&&(P=3),T){const t=Pl[T];w=t.vertexShader,R=t.fragmentShader}else w=a.vertexShader,R=a.fragmentShader,l.update(a),A=l.getVertexShaderID(a),C=l.getFragmentShaderID(a);const D=t.getRenderTarget(),U=t.state.buffers.depth.getReversed(),L=1==v.isInstancedMesh,I=1==v.isBatchedMesh,N=!!a.map,O=!!a.matcap,F=!!b,B=!!a.aoMap,k=!!a.lightMap,z=!!a.bumpMap,V=!!a.normalMap,H=!!a.displacementMap,G=!!a.emissiveMap,W=!!a.metalnessMap,X=!!a.roughnessMap,j=a.anisotropy>0,q=a.clearcoat>0,Y=a.dispersion>0,K=a.iridescence>0,Z=a.sheen>0,$=a.transmission>0,J=j&&!!a.anisotropyMap,Q=q&&!!a.clearcoatMap,tt=q&&!!a.clearcoatNormalMap,et=q&&!!a.clearcoatRoughnessMap,nt=K&&!!a.iridescenceMap,rt=K&&!!a.iridescenceThicknessMap,it=Z&&!!a.sheenColorMap,at=Z&&!!a.sheenRoughnessMap,st=!!a.specularMap,ot=!!a.specularColorMap,lt=!!a.specularIntensityMap,ct=$&&!!a.transmissionMap,ht=$&&!!a.thicknessMap,ut=!!a.gradientMap,dt=!!a.alphaMap,pt=a.alphaTest>0,ft=!!a.alphaHash,mt=!!a.extensions;let gt=0;a.toneMapped&&(null!==D&&1!=D.isXRRenderTarget||(gt=t.toneMapping));const vt={shaderID:T,shaderType:a.type,shaderName:a.name,vertexShader:w,fragmentShader:R,defines:a.defines,customVertexShaderID:A,customFragmentShaderID:C,isRawShaderMaterial:1==a.isRawShaderMaterial,glslVersion:a.glslVersion,precision:p,batching:I,batchingColor:I&&null!==v._colorsTexture,instancing:L,instancingColor:L&&null!==v.instanceColor,instancingMorph:L&&null!==v.morphTexture,supportsVertexTextures:d,outputColorSpace:null===D?t.outputColorSpace:1==D.isXRRenderTarget?D.texture.colorSpace:Xn,alphaToCoverage:!!a.alphaToCoverage,map:N,matcap:O,envMap:F,envMapMode:F&&b.mapping,envMapCubeUVHeight:E,aoMap:B,lightMap:k,bumpMap:z,normalMap:V,displacementMap:d&&H,emissiveMap:G,normalMapObjectSpace:V&&1===a.normalMapType,normalMapTangentSpace:V&&0===a.normalMapType,metalnessMap:W,roughnessMap:X,anisotropy:j,anisotropyMap:J,clearcoat:q,clearcoatMap:Q,clearcoatNormalMap:tt,clearcoatRoughnessMap:et,dispersion:Y,iridescence:K,iridescenceMap:nt,iridescenceThicknessMap:rt,sheen:Z,sheenColorMap:it,sheenRoughnessMap:at,specularMap:st,specularColorMap:ot,specularIntensityMap:lt,transmission:$,transmissionMap:ct,thicknessMap:ht,gradientMap:ut,opaque:0==a.transparent&&1===a.blending&&0==a.alphaToCoverage,alphaMap:dt,alphaTest:pt,alphaHash:ft,combine:a.combine,mapUv:N&&m(a.map.channel),aoMapUv:B&&m(a.aoMap.channel),lightMapUv:k&&m(a.lightMap.channel),bumpMapUv:z&&m(a.bumpMap.channel),normalMapUv:V&&m(a.normalMap.channel),displacementMapUv:H&&m(a.displacementMap.channel),emissiveMapUv:G&&m(a.emissiveMap.channel),metalnessMapUv:W&&m(a.metalnessMap.channel),roughnessMapUv:X&&m(a.roughnessMap.channel),anisotropyMapUv:J&&m(a.anisotropyMap.channel),clearcoatMapUv:Q&&m(a.clearcoatMap.channel),clearcoatNormalMapUv:tt&&m(a.clearcoatNormalMap.channel),clearcoatRoughnessMapUv:et&&m(a.clearcoatRoughnessMap.channel),iridescenceMapUv:nt&&m(a.iridescenceMap.channel),iridescenceThicknessMapUv:rt&&m(a.iridescenceThicknessMap.channel),sheenColorMapUv:it&&m(a.sheenColorMap.channel),sheenRoughnessMapUv:at&&m(a.sheenRoughnessMap.channel),specularMapUv:st&&m(a.specularMap.channel),specularColorMapUv:ot&&m(a.specularColorMap.channel),specularIntensityMapUv:lt&&m(a.specularIntensityMap.channel),transmissionMapUv:ct&&m(a.transmissionMap.channel),thicknessMapUv:ht&&m(a.thicknessMap.channel),alphaMapUv:dt&&m(a.alphaMap.channel),vertexTangents:!!_.attributes.tangent&&(V||j),vertexColors:a.vertexColors,vertexAlphas:1==a.vertexColors&&!!_.attributes.color&&4===_.attributes.color.itemSize,pointsUvs:1==v.isPoints&&!!_.attributes.uv&&(N||dt),fog:!!x,useFog:1==a.fog,fogExp2:!!x&&x.isFogExp2,flatShading:1==a.flatShading&&0==a.wireframe,sizeAttenuation:1==a.sizeAttenuation,logarithmicDepthBuffer:u,reversedDepthBuffer:U,skinning:1==v.isSkinnedMesh,morphTargets:void 0!==_.morphAttributes.position,morphNormals:void 0!==_.morphAttributes.normal,morphColors:void 0!==_.morphAttributes.color,morphTargetsCount:M,morphTextureStride:P,numDirLights:o.directional.length,numPointLights:o.point.length,numSpotLights:o.spot.length,numSpotLightMaps:o.spotLightMap.length,numRectAreaLights:o.rectArea.length,numHemiLights:o.hemi.length,numDirLightShadows:o.directionalShadowMap.length,numPointLightShadows:o.pointShadowMap.length,numSpotLightShadows:o.spotShadowMap.length,numSpotLightShadowsWithMaps:o.numSpotLightShadowsWithMaps,numLightProbes:o.numLightProbes,numClippingPlanes:s.numPlanes,numClipIntersection:s.numIntersection,dithering:a.dithering,shadowMapEnabled:t.shadowMap.enabled&&h.length>0,shadowMapType:t.shadowMap.type,toneMapping:gt,decodeVideoTexture:N&&1==a.map.isVideoTexture&&Ir.getTransfer(a.map.colorSpace)===qn,decodeVideoTextureEmissive:G&&1==a.emissiveMap.isVideoTexture&&Ir.getTransfer(a.emissiveMap.colorSpace)===qn,premultipliedAlpha:a.premultipliedAlpha,doubleSided:2===a.side,flipSided:1===a.side,useDepthPacking:a.depthPacking>=0,depthPacking:a.depthPacking||0,index0AttributeName:a.index0AttributeName,extensionClipCullDistance:mt&&1==a.extensions.clipCullDistance&&r.has("WEBGL_clip_cull_distance"),extensionMultiDraw:(mt&&1==a.extensions.multiDraw||I)&&r.has("WEBGL_multi_draw"),rendererExtensionParallelShaderCompile:r.has("KHR_parallel_shader_compile"),customProgramCacheKey:a.customProgramCacheKey()};return vt.vertexUv1s=c.has(1),vt.vertexUv2s=c.has(2),vt.vertexUv3s=c.has(3),c.clear(),vt},getProgramCacheKey:function(e){const n=[];if(e.shaderID?n.push(e.shaderID):(n.push(e.customVertexShaderID),n.push(e.customFragmentShaderID)),void 0!==e.defines)for(const t in e.defines)n.push(t),n.push(e.defines[t]);return 0==e.isRawShaderMaterial&&(!function(t,e){t.push(e.precision),t.push(e.outputColorSpace),t.push(e.envMapMode),t.push(e.envMapCubeUVHeight),t.push(e.mapUv),t.push(e.alphaMapUv),t.push(e.lightMapUv),t.push(e.aoMapUv),t.push(e.bumpMapUv),t.push(e.normalMapUv),t.push(e.displacementMapUv),t.push(e.emissiveMapUv),t.push(e.metalnessMapUv),t.push(e.roughnessMapUv),t.push(e.anisotropyMapUv),t.push(e.clearcoatMapUv),t.push(e.clearcoatNormalMapUv),t.push(e.clearcoatRoughnessMapUv),t.push(e.iridescenceMapUv),t.push(e.iridescenceThicknessMapUv),t.push(e.sheenColorMapUv),t.push(e.sheenRoughnessMapUv),t.push(e.specularMapUv),t.push(e.specularColorMapUv),t.push(e.specularIntensityMapUv),t.push(e.transmissionMapUv),t.push(e.thicknessMapUv),t.push(e.combine),t.push(e.fogExp2),t.push(e.sizeAttenuation),t.push(e.morphTargetsCount),t.push(e.morphAttributeCount),t.push(e.numDirLights),t.push(e.numPointLights),t.push(e.numSpotLights),t.push(e.numSpotLightMaps),t.push(e.numHemiLights),t.push(e.numRectAreaLights),t.push(e.numDirLightShadows),t.push(e.numPointLightShadows),t.push(e.numSpotLightShadows),t.push(e.numSpotLightShadowsWithMaps),t.push(e.numLightProbes),t.push(e.shadowMapType),t.push(e.toneMapping),t.push(e.numClippingPlanes),t.push(e.numClipIntersection),t.push(e.depthPacking)}(n,e),function(t,e){o.disableAll(),e.supportsVertexTextures&&o.enable(0);e.instancing&&o.enable(1);e.instancingColor&&o.enable(2);e.instancingMorph&&o.enable(3);e.matcap&&o.enable(4);e.envMap&&o.enable(5);e.normalMapObjectSpace&&o.enable(6);e.normalMapTangentSpace&&o.enable(7);e.clearcoat&&o.enable(8);e.iridescence&&o.enable(9);e.alphaTest&&o.enable(10);e.vertexColors&&o.enable(11);e.vertexAlphas&&o.enable(12);e.vertexUv1s&&o.enable(13);e.vertexUv2s&&o.enable(14);e.vertexUv3s&&o.enable(15);e.vertexTangents&&o.enable(16);e.anisotropy&&o.enable(17);e.alphaHash&&o.enable(18);e.batching&&o.enable(19);e.dispersion&&o.enable(20);e.batchingColor&&o.enable(21);e.gradientMap&&o.enable(22);t.push(o.mask),o.disableAll(),e.fog&&o.enable(0);e.useFog&&o.enable(1);e.flatShading&&o.enable(2);e.logarithmicDepthBuffer&&o.enable(3);e.reversedDepthBuffer&&o.enable(4);e.skinning&&o.enable(5);e.morphTargets&&o.enable(6);e.morphNormals&&o.enable(7);e.morphColors&&o.enable(8);e.premultipliedAlpha&&o.enable(9);e.shadowMapEnabled&&o.enable(10);e.doubleSided&&o.enable(11);e.flipSided&&o.enable(12);e.useDepthPacking&&o.enable(13);e.dithering&&o.enable(14);e.transmission&&o.enable(15);e.sheen&&o.enable(16);e.opaque&&o.enable(17);e.pointsUvs&&o.enable(18);e.decodeVideoTexture&&o.enable(19);e.decodeVideoTextureEmissive&&o.enable(20);e.alphaToCoverage&&o.enable(21);t.push(o.mask)}(n,e),n.push(t.outputColorSpace)),n.push(e.customProgramCacheKey),n.join()},getUniforms:function(t){const e=f[t.type];let n;if(e){const t=Pl[e];n=Ja.clone(t.uniforms)}else n=t.uniforms;return n},acquireProgram:function(e,n){let r;for(let t=0,e=h.length;t<e;t++){const e=h[t];if(e.cacheKey===n){r=e,++r.usedTimes;break}}return void 0===r&&(r=new Nh(t,n,e,a),h.push(r)),r},releaseProgram:function(t){if(0===--t.usedTimes){const e=h.indexOf(t);h[e]=h[h.length-1],h.pop(),t.destroy()}},releaseShaderCache:function(t){l.remove(t)},programs:h,dispose:function(){l.dispose()}}}function zh(){let t=new WeakMap;return{has:function(e){return t.has(e)},get:function(e){let n=t.get(e);return void 0===n&&(n={},t.set(e,n)),n},remove:function(e){t.delete(e)},update:function(e,n,r){t.get(e)[n]=r},dispose:function(){t=new WeakMap}}}function Vh(t,e){return t.groupOrder!==e.groupOrder?t.groupOrder-e.groupOrder:t.renderOrder!==e.renderOrder?t.renderOrder-e.renderOrder:t.material.id!==e.material.id?t.material.id-e.material.id:t.z!==e.z?t.z-e.z:t.id-e.id}function Hh(t,e){return t.groupOrder!==e.groupOrder?t.groupOrder-e.groupOrder:t.renderOrder!==e.renderOrder?t.renderOrder-e.renderOrder:t.z!==e.z?e.z-t.z:t.id-e.id}function Gh(){const t=[];let e=0;const n=[],r=[],i=[];function a(n,r,i,a,s,o){let l=t[e];return void 0===l?(l={id:n.id,object:n,geometry:r,material:i,groupOrder:a,renderOrder:n.renderOrder,z:s,group:o},t[e]=l):(l.id=n.id,l.object=n,l.geometry=r,l.material=i,l.groupOrder=a,l.renderOrder=n.renderOrder,l.z=s,l.group=o),e++,l}return{opaque:n,transmissive:r,transparent:i,init:function(){e=0,n.length=0,r.length=0,i.length=0},push:function(t,e,s,o,l,c){const h=a(t,e,s,o,l,c);s.transmission>0?r.push(h):1==s.transparent?i.push(h):n.push(h)},unshift:function(t,e,s,o,l,c){const h=a(t,e,s,o,l,c);s.transmission>0?r.unshift(h):1==s.transparent?i.unshift(h):n.unshift(h)},finish:function(){for(let n=e,r=t.length;n<r;n++){const e=t[n];if(null===e.id)break;e.id=null,e.object=null,e.geometry=null,e.material=null,e.group=null}},sort:function(t,e){n.length>1&&n.sort(t||Vh),r.length>1&&r.sort(e||Hh),i.length>1&&i.sort(e||Hh)}}}function Wh(){let t=new WeakMap;return{get:function(e,n){const r=t.get(e);let i;return void 0===r?(i=new Gh,t.set(e,[i])):n>=r.length?(i=new Gh,r.push(i)):i=r[n],i},dispose:function(){t=new WeakMap}}}function Xh(){const t={};return{get:function(e){if(void 0!==t[e.id])return t[e.id];let n;switch(e.type){case"DirectionalLight":n={direction:new br,color:new ma};break;case"SpotLight":n={position:new br,direction:new br,color:new ma,distance:0,coneCos:0,penumbraCos:0,decay:0};break;case"PointLight":n={position:new br,color:new ma,distance:0,decay:0};break;case"HemisphereLight":n={direction:new br,skyColor:new ma,groundColor:new ma};break;case"RectAreaLight":n={color:new ma,position:new br,halfWidth:new br,halfHeight:new br}}return t[e.id]=n,n}}}let jh=0;function qh(t,e){return(e.castShadow?2:0)-(t.castShadow?2:0)+(e.map?1:0)-(t.map?1:0)}function Yh(t){const e=new Xh,n=function(){const t={};return{get:function(e){if(void 0!==t[e.id])return t[e.id];let n;switch(e.type){case"DirectionalLight":case"SpotLight":n={shadowIntensity:1,shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new _r};break;case"PointLight":n={shadowIntensity:1,shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new _r,shadowCameraNear:1,shadowCameraFar:1e3}}return t[e.id]=n,n}}}(),r={version:0,hash:{directionalLength:-1,pointLength:-1,spotLength:-1,rectAreaLength:-1,hemiLength:-1,numDirectionalShadows:-1,numPointShadows:-1,numSpotShadows:-1,numSpotMaps:-1,numLightProbes:-1},ambient:[0,0,0],probe:[],directional:[],directionalShadow:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotLightMap:[],spotShadow:[],spotShadowMap:[],spotLightMatrix:[],rectArea:[],rectAreaLTC1:null,rectAreaLTC2:null,point:[],pointShadow:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[],numSpotLightShadowsWithMaps:0,numLightProbes:0};for(let t=0;t<9;t++)r.probe.push(new br);const i=new br,a=new Ti,s=new Ti;return{setup:function(i){let a=0,s=0,o=0;for(let t=0;t<9;t++)r.probe[t].set(0,0,0);let l=0,c=0,h=0,u=0,d=0,p=0,f=0,m=0,g=0,v=0,x=0;i.sort(qh);for(let t=0,_=i.length;t<_;t++){const _=i[t],y=_.color,b=_.intensity,E=_.distance,T=_.shadow&&_.shadow.map?_.shadow.map.texture:null;if(_.isAmbientLight)a+=y.r*b,s+=y.g*b,o+=y.b*b;else if(_.isLightProbe){for(let t=0;t<9;t++)r.probe[t].addScaledVector(_.sh.coefficients[t],b);x++}else if(_.isDirectionalLight){const t=e.get(_);if(t.color.copy(_.color).multiplyScalar(_.intensity),_.castShadow){const t=_.shadow,e=n.get(_);e.shadowIntensity=t.intensity,e.shadowBias=t.bias,e.shadowNormalBias=t.normalBias,e.shadowRadius=t.radius,e.shadowMapSize=t.mapSize,r.directionalShadow[l]=e,r.directionalShadowMap[l]=T,r.directionalShadowMatrix[l]=_.shadow.matrix,p++}r.directional[l]=t,l++}else if(_.isSpotLight){const t=e.get(_);t.position.setFromMatrixPosition(_.matrixWorld),t.color.copy(y).multiplyScalar(b),t.distance=E,t.coneCos=Math.cos(_.angle),t.penumbraCos=Math.cos(_.angle*(1-_.penumbra)),t.decay=_.decay,r.spot[h]=t;const i=_.shadow;if(_.map&&(r.spotLightMap[g]=_.map,g++,i.updateMatrices(_),_.castShadow&&v++),r.spotLightMatrix[h]=i.matrix,_.castShadow){const t=n.get(_);t.shadowIntensity=i.intensity,t.shadowBias=i.bias,t.shadowNormalBias=i.normalBias,t.shadowRadius=i.radius,t.shadowMapSize=i.mapSize,r.spotShadow[h]=t,r.spotShadowMap[h]=T,m++}h++}else if(_.isRectAreaLight){const t=e.get(_);t.color.copy(y).multiplyScalar(b),t.halfWidth.set(.5*_.width,0,0),t.halfHeight.set(0,.5*_.height,0),r.rectArea[u]=t,u++}else if(_.isPointLight){const t=e.get(_);if(t.color.copy(_.color).multiplyScalar(_.intensity),t.distance=_.distance,t.decay=_.decay,_.castShadow){const t=_.shadow,e=n.get(_);e.shadowIntensity=t.intensity,e.shadowBias=t.bias,e.shadowNormalBias=t.normalBias,e.shadowRadius=t.radius,e.shadowMapSize=t.mapSize,e.shadowCameraNear=t.camera.near,e.shadowCameraFar=t.camera.far,r.pointShadow[c]=e,r.pointShadowMap[c]=T,r.pointShadowMatrix[c]=_.shadow.matrix,f++}r.point[c]=t,c++}else if(_.isHemisphereLight){const t=e.get(_);t.skyColor.copy(_.color).multiplyScalar(b),t.groundColor.copy(_.groundColor).multiplyScalar(b),r.hemi[d]=t,d++}}u>0&&(1==t.has("OES_texture_float_linear")?(r.rectAreaLTC1=Cl.LTC_FLOAT_1,r.rectAreaLTC2=Cl.LTC_FLOAT_2):(r.rectAreaLTC1=Cl.LTC_HALF_1,r.rectAreaLTC2=Cl.LTC_HALF_2)),r.ambient[0]=a,r.ambient[1]=s,r.ambient[2]=o;const _=r.hash;_.directionalLength===l&&_.pointLength===c&&_.spotLength===h&&_.rectAreaLength===u&&_.hemiLength===d&&_.numDirectionalShadows===p&&_.numPointShadows===f&&_.numSpotShadows===m&&_.numSpotMaps===g&&_.numLightProbes===x||(r.directional.length=l,r.spot.length=h,r.rectArea.length=u,r.point.length=c,r.hemi.length=d,r.directionalShadow.length=p,r.directionalShadowMap.length=p,r.pointShadow.length=f,r.pointShadowMap.length=f,r.spotShadow.length=m,r.spotShadowMap.length=m,r.directionalShadowMatrix.length=p,r.pointShadowMatrix.length=f,r.spotLightMatrix.length=m+g-v,r.spotLightMap.length=g,r.numSpotLightShadowsWithMaps=v,r.numLightProbes=x,_.directionalLength=l,_.pointLength=c,_.spotLength=h,_.rectAreaLength=u,_.hemiLength=d,_.numDirectionalShadows=p,_.numPointShadows=f,_.numSpotShadows=m,_.numSpotMaps=g,_.numLightProbes=x,r.version=jh++)},setupView:function(t,e){let n=0,o=0,l=0,c=0,h=0;const u=e.matrixWorldInverse;for(let e=0,d=t.length;e<d;e++){const d=t[e];if(d.isDirectionalLight){const t=r.directional[n];t.direction.setFromMatrixPosition(d.matrixWorld),i.setFromMatrixPosition(d.target.matrixWorld),t.direction.sub(i),t.direction.transformDirection(u),n++}else if(d.isSpotLight){const t=r.spot[l];t.position.setFromMatrixPosition(d.matrixWorld),t.position.applyMatrix4(u),t.direction.setFromMatrixPosition(d.matrixWorld),i.setFromMatrixPosition(d.target.matrixWorld),t.direction.sub(i),t.direction.transformDirection(u),l++}else if(d.isRectAreaLight){const t=r.rectArea[c];t.position.setFromMatrixPosition(d.matrixWorld),t.position.applyMatrix4(u),s.identity(),a.copy(d.matrixWorld),a.premultiply(u),s.extractRotation(a),t.halfWidth.set(.5*d.width,0,0),t.halfHeight.set(0,.5*d.height,0),t.halfWidth.applyMatrix4(s),t.halfHeight.applyMatrix4(s),c++}else if(d.isPointLight){const t=r.point[o];t.position.setFromMatrixPosition(d.matrixWorld),t.position.applyMatrix4(u),o++}else if(d.isHemisphereLight){const t=r.hemi[h];t.direction.setFromMatrixPosition(d.matrixWorld),t.direction.transformDirection(u),h++}}},state:r}}function Kh(t){const e=new Yh(t),n=[],r=[];const i={lightsArray:n,shadowsArray:r,camera:null,lights:e,transmissionRenderTarget:{}};return{init:function(t){i.camera=t,n.length=0,r.length=0},state:i,setupLights:function(){e.setup(n)},setupLightsView:function(t){e.setupView(n,t)},pushLight:function(t){n.push(t)},pushShadow:function(t){r.push(t)}}}function Zh(t){let e=new WeakMap;return{get:function(n,r=0){const i=e.get(n);let a;return void 0===i?(a=new Kh(t),e.set(n,[a])):r>=i.length?(a=new Kh(t),i.push(a)):a=i[r],a},dispose:function(){e=new WeakMap}}}function $h(t,e,n){let r=new qs;const i=new _r,a=new _r,s=new Xr,o=new bo({depthPacking:3201}),l=new Eo,c={},h=n.maxTextureSize,u={[Zt]:1,[$t]:0,[Jt]:2},d=new Qa({defines:{VSM_SAMPLES:8},uniforms:{shadow_pass:{value:null},resolution:{value:new _r},radius:{value:4}},vertexShader:"void main() {\n\tgl_Position = vec4( position, 1.0 );\n}",fragmentShader:"uniform sampler2D shadow_pass;\nuniform vec2 resolution;\nuniform float radius;\n#include <packing>\nvoid main() {\n\tconst float samples = float( VSM_SAMPLES );\n\tfloat mean = 0.0;\n\tfloat squared_mean = 0.0;\n\tfloat uvStride = samples <= 1.0 ? 0.0 : 2.0 / ( samples - 1.0 );\n\tfloat uvStart = samples <= 1.0 ? 0.0 : - 1.0;\n\tfor ( float i = 0.0; i < samples; i ++ ) {\n\t\tfloat uvOffset = uvStart + i * uvStride;\n\t\t#ifdef HORIZONTAL_PASS\n\t\t\tvec2 distribution = unpackRGBATo2Half( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( uvOffset, 0.0 ) * radius ) / resolution ) );\n\t\t\tmean += distribution.x;\n\t\t\tsquared_mean += distribution.y * distribution.y + distribution.x * distribution.x;\n\t\t#else\n\t\t\tfloat depth = unpackRGBAToDepth( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( 0.0, uvOffset ) * radius ) / resolution ) );\n\t\t\tmean += depth;\n\t\t\tsquared_mean += depth * depth;\n\t\t#endif\n\t}\n\tmean = mean / samples;\n\tsquared_mean = squared_mean / samples;\n\tfloat std_dev = sqrt( squared_mean - mean * mean );\n\tgl_FragColor = pack2HalfToRGBA( vec2( mean, std_dev ) );\n}"}),p=d.clone();p.defines.HORIZONTAL_PASS=1;const f=new Ia;f.setAttribute("position",new Ta(new Float32Array([-1,-1,.5,3,-1,.5,-1,3,.5]),3));const m=new ja(f,d),g=this;this.enabled=0,this.autoUpdate=1,this.needsUpdate=0,this.type=1;let v=this.type;function x(n,r){const a=e.update(m);d.defines.VSM_SAMPLES!==n.blurSamples&&(d.defines.VSM_SAMPLES=n.blurSamples,p.defines.VSM_SAMPLES=n.blurSamples,d.needsUpdate=1,p.needsUpdate=1),null===n.mapPass&&(n.mapPass=new qr(i.x,i.y)),d.uniforms.shadow_pass.value=n.map.texture,d.uniforms.resolution.value=n.mapSize,d.uniforms.radius.value=n.radius,t.setRenderTarget(n.mapPass),t.clear(),t.renderBufferDirect(r,null,a,d,m,null),p.uniforms.shadow_pass.value=n.mapPass.texture,p.uniforms.resolution.value=n.mapSize,p.uniforms.radius.value=n.radius,t.setRenderTarget(n.map),t.clear(),t.renderBufferDirect(r,null,a,p,m,null)}function _(e,n,r,i){let a=null;const s=1==r.isPointLight?e.customDistanceMaterial:e.customDepthMaterial;if(void 0!==s)a=s;else if(a=1==r.isPointLight?l:o,t.localClippingEnabled&&1==n.clipShadows&&Array.isArray(n.clippingPlanes)&&0!==n.clippingPlanes.length||n.displacementMap&&0!==n.displacementScale||n.alphaMap&&n.alphaTest>0||n.map&&n.alphaTest>0||1==n.alphaToCoverage){const t=a.uuid,e=n.uuid;let r=c[t];void 0===r&&(r={},c[t]=r);let i=r[e];void 0===i&&(i=a.clone(),r[e]=i,n.addEventListener("dispose",b)),a=i}if(a.visible=n.visible,a.wireframe=n.wireframe,a.side=3===i?null!==n.shadowSide?n.shadowSide:n.side:null!==n.shadowSide?n.shadowSide:u[n.side],a.alphaMap=n.alphaMap,a.alphaTest=1==n.alphaToCoverage?.5:n.alphaTest,a.map=n.map,a.clipShadows=n.clipShadows,a.clippingPlanes=n.clippingPlanes,a.clipIntersection=n.clipIntersection,a.displacementMap=n.displacementMap,a.displacementScale=n.displacementScale,a.displacementBias=n.displacementBias,a.wireframeLinewidth=n.wireframeLinewidth,a.linewidth=n.linewidth,1==r.isPointLight&&1==a.isMeshDistanceMaterial){t.properties.get(a).light=r}return a}function y(n,i,a,s,o){if(0==n.visible)return;if(n.layers.test(i.layers)&&(n.isMesh||n.isLine||n.isPoints)&&(n.castShadow||n.receiveShadow&&3===o)&&(!n.frustumCulled||r.intersectsObject(n))){n.modelViewMatrix.multiplyMatrices(a.matrixWorldInverse,n.matrixWorld);const r=e.update(n),l=n.material;if(Array.isArray(l)){const e=r.groups;for(let c=0,h=e.length;c<h;c++){const h=e[c],u=l[h.materialIndex];if(u&&u.visible){const e=_(n,u,s,o);n.onBeforeShadow(t,n,i,a,r,e,h),t.renderBufferDirect(a,null,r,e,n,h),n.onAfterShadow(t,n,i,a,r,e,h)}}}else if(l.visible){const e=_(n,l,s,o);n.onBeforeShadow(t,n,i,a,r,e,null),t.renderBufferDirect(a,null,r,e,n,null),n.onAfterShadow(t,n,i,a,r,e,null)}}const l=n.children;for(let t=0,e=l.length;t<e;t++)y(l[t],i,a,s,o)}function b(t){t.target.removeEventListener("dispose",b);for(const e in c){const n=c[e],r=t.target.uuid;if(r in n){n[r].dispose(),delete n[r]}}}this.render=function(e,n,o){if(0==g.enabled)return;if(0==g.autoUpdate&&0==g.needsUpdate)return;if(0===e.length)return;const l=t.getRenderTarget(),c=t.getActiveCubeFace(),u=t.getActiveMipmapLevel(),d=t.state;d.setBlending(0),d.buffers.depth.getReversed()?d.buffers.color.setClear(0,0,0,0):d.buffers.color.setClear(1,1,1,1),d.buffers.depth.setTest(1),d.setScissorTest(0);const p=3!==v&&3===this.type,f=3===v&&3!==this.type;for(let l=0,c=e.length;l<c;l++){const c=e[l],u=c.shadow;if(void 0===u)continue;if(0==u.autoUpdate&&0==u.needsUpdate)continue;i.copy(u.mapSize);const m=u.getFrameExtents();if(i.multiply(m),a.copy(u.mapSize),(i.x>h||i.y>h)&&(i.x>h&&(a.x=Math.floor(h/m.x),i.x=a.x*m.x,u.mapSize.x=a.x),i.y>h&&(a.y=Math.floor(h/m.y),i.y=a.y*m.y,u.mapSize.y=a.y)),null===u.map||1==p||1==f){const t=3!==this.type?{minFilter:Ie,magFilter:Ie}:{};null!==u.map&&u.map.dispose(),u.map=new qr(i.x,i.y,t),u.map.texture.name=c.name+".shadowMap",u.camera.updateProjectionMatrix()}t.setRenderTarget(u.map),t.clear();const g=u.getViewportCount();for(let t=0;t<g;t++){const e=u.getViewport(t);s.set(a.x*e.x,a.y*e.y,a.x*e.z,a.y*e.w),d.viewport(s),u.updateMatrices(c,t),r=u.getFrustum(),y(n,o,u.camera,c,this.type)}1!=u.isPointLightShadow&&3===this.type&&x(u,o),u.needsUpdate=0}v=this.type,g.needsUpdate=0,t.setRenderTarget(l,c,u)}}const Jh={[ve]:1,[_e]:6,[be]:7,[ye]:5,[xe]:0,[Te]:2,[Se]:4,[Ee]:3};function Qh(t,e){const n=new function(){let e=0;const n=new Xr;let r=null;const i=new Xr(0,0,0,0);return{setMask:function(n){r===n||e||(t.colorMask(n,n,n,n),r=n)},setLocked:function(t){e=t},setClear:function(e,r,a,s,o){1==o&&(e*=s,r*=s,a*=s),n.set(e,r,a,s),0==i.equals(n)&&(t.clearColor(e,r,a,s),i.copy(n))},reset:function(){e=0,r=null,i.set(-1,0,0,0)}}},r=new function(){let n=0,r=0,i=null,a=null,s=null;return{setReversed:function(t){if(r!==t){const n=e.get("EXT_clip_control");t?n.clipControlEXT(n.LOWER_LEFT_EXT,n.ZERO_TO_ONE_EXT):n.clipControlEXT(n.LOWER_LEFT_EXT,n.NEGATIVE_ONE_TO_ONE_EXT),r=t;const i=s;s=null,this.setClear(i)}},getReversed:function(){return r},setTest:function(e){e?z(t.DEPTH_TEST):V(t.DEPTH_TEST)},setMask:function(e){i===e||n||(t.depthMask(e),i=e)},setFunc:function(e){if(r&&(e=Jh[e]),a!==e){switch(e){case 0:t.depthFunc(t.NEVER);break;case 1:t.depthFunc(t.ALWAYS);break;case 2:t.depthFunc(t.LESS);break;case 3:default:t.depthFunc(t.LEQUAL);break;case 4:t.depthFunc(t.EQUAL);break;case 5:t.depthFunc(t.GEQUAL);break;case 6:t.depthFunc(t.GREATER);break;case 7:t.depthFunc(t.NOTEQUAL)}a=e}},setLocked:function(t){n=t},setClear:function(e){s!==e&&(r&&(e=1-e),t.clearDepth(e),s=e)},reset:function(){n=0,i=null,a=null,s=null,r=0}}},i=new function(){let e=0,n=null,r=null,i=null,a=null,s=null,o=null,l=null,c=null;return{setTest:function(n){e||(n?z(t.STENCIL_TEST):V(t.STENCIL_TEST))},setMask:function(r){n===r||e||(t.stencilMask(r),n=r)},setFunc:function(e,n,s){r===e&&i===n&&a===s||(t.stencilFunc(e,n,s),r=e,i=n,a=s)},setOp:function(e,n,r){s===e&&o===n&&l===r||(t.stencilOp(e,n,r),s=e,o=n,l=r)},setLocked:function(t){e=t},setClear:function(e){c!==e&&(t.clearStencil(e),c=e)},reset:function(){e=0,n=null,r=null,i=null,a=null,s=null,o=null,l=null,c=null}}},a=new WeakMap,s=new WeakMap;let o={},l={},c=new WeakMap,h=[],u=null,d=0,p=null,f=null,m=null,g=null,v=null,x=null,_=null,y=new ma(0,0,0),b=0,E=0,T=null,S=null,M=null,w=null,R=null;const A=t.getParameter(t.MAX_COMBINED_TEXTURE_IMAGE_UNITS);let C=0,P=0;const D=t.getParameter(t.VERSION);-1!==D.indexOf("WebGL")?(P=parseFloat(/^WebGL (\d)/.exec(D)[1]),C=P>=1):-1!==D.indexOf("OpenGL ES")&&(P=parseFloat(/^OpenGL ES (\d)/.exec(D)[1]),C=P>=2);let U=null,L={};const I=t.getParameter(t.SCISSOR_BOX),N=t.getParameter(t.VIEWPORT),O=(new Xr).fromArray(I),F=(new Xr).fromArray(N);function B(e,n,r,i){const a=new Uint8Array(4),s=t.createTexture();t.bindTexture(e,s),t.texParameteri(e,t.TEXTURE_MIN_FILTER,t.NEAREST),t.texParameteri(e,t.TEXTURE_MAG_FILTER,t.NEAREST);for(let s=0;s<r;s++)e===t.TEXTURE_3D||e===t.TEXTURE_2D_ARRAY?t.texImage3D(n,0,t.RGBA,1,1,i,0,t.RGBA,t.UNSIGNED_BYTE,a):t.texImage2D(n+s,0,t.RGBA,1,1,0,t.RGBA,t.UNSIGNED_BYTE,a);return s}const k={};function z(e){1!=o[e]&&(t.enable(e),o[e]=1)}function V(e){0!=o[e]&&(t.disable(e),o[e]=0)}k[t.TEXTURE_2D]=B(t.TEXTURE_2D,t.TEXTURE_2D,1),k[t.TEXTURE_CUBE_MAP]=B(t.TEXTURE_CUBE_MAP,t.TEXTURE_CUBE_MAP_POSITIVE_X,6),k[t.TEXTURE_2D_ARRAY]=B(t.TEXTURE_2D_ARRAY,t.TEXTURE_2D_ARRAY,1,1),k[t.TEXTURE_3D]=B(t.TEXTURE_3D,t.TEXTURE_3D,1,1),n.setClear(0,0,0,1),r.setClear(1),i.setClear(0),z(t.DEPTH_TEST),r.setFunc(3),X(0),j(1),z(t.CULL_FACE),W(0);const H={[Qt]:t.FUNC_ADD,[te]:t.FUNC_SUBTRACT,[ee]:t.FUNC_REVERSE_SUBTRACT};H[103]=t.MIN,H[104]=t.MAX;const G={[ne]:t.ZERO,[re]:t.ONE,[ie]:t.SRC_COLOR,[se]:t.SRC_ALPHA,[de]:t.SRC_ALPHA_SATURATE,[he]:t.DST_COLOR,[le]:t.DST_ALPHA,[ae]:t.ONE_MINUS_SRC_COLOR,[oe]:t.ONE_MINUS_SRC_ALPHA,[ue]:t.ONE_MINUS_DST_COLOR,[ce]:t.ONE_MINUS_DST_ALPHA,[pe]:t.CONSTANT_COLOR,[fe]:t.ONE_MINUS_CONSTANT_COLOR,[me]:t.CONSTANT_ALPHA,[ge]:t.ONE_MINUS_CONSTANT_ALPHA};function W(e,n,r,i,a,s,o,l,c,h){if(0!==e){if(0==d&&(z(t.BLEND),d=1),5===e)a=a||n,s=s||r,o=o||i,n===f&&a===v||(t.blendEquationSeparate(H[n],H[a]),f=n,v=a),r===m&&i===g&&s===x&&o===_||(t.blendFuncSeparate(G[r],G[i],G[s],G[o]),m=r,g=i,x=s,_=o),0!=l.equals(y)&&c===b||(t.blendColor(l.r,l.g,l.b,c),y.copy(l),b=c),p=e,E=0;else if(e!==p||h!==E){if(f===Qt&&v===Qt||(t.blendEquation(t.FUNC_ADD),f=Qt,v=Qt),h)switch(e){case 1:t.blendFuncSeparate(t.ONE,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA);break;case 2:t.blendFunc(t.ONE,t.ONE);break;case 3:t.blendFuncSeparate(t.ZERO,t.ONE_MINUS_SRC_COLOR,t.ZERO,t.ONE);break;case 4:t.blendFuncSeparate(t.DST_COLOR,t.ONE_MINUS_SRC_ALPHA,t.ZERO,t.ONE)}else switch(e){case 1:t.blendFuncSeparate(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA);break;case 2:t.blendFuncSeparate(t.SRC_ALPHA,t.ONE,t.ONE,t.ONE)}m=null,g=null,x=null,_=null,y.set(0,0,0),b=0,p=e,E=h}}else 1==d&&(V(t.BLEND),d=0)}function X(e){T!==e&&(e?t.frontFace(t.CW):t.frontFace(t.CCW),T=e)}function j(e){0!==e?(z(t.CULL_FACE),e!==S&&(1===e?t.cullFace(t.BACK):2===e?t.cullFace(t.FRONT):t.cullFace(t.FRONT_AND_BACK))):V(t.CULL_FACE),S=e}function q(e,n,r){e?(z(t.POLYGON_OFFSET_FILL),w===n&&R===r||(t.polygonOffset(n,r),w=n,R=r)):V(t.POLYGON_OFFSET_FILL)}return{buffers:{color:n,depth:r,stencil:i},enable:z,disable:V,bindFramebuffer:function(e,n){return l[e]!==n?(t.bindFramebuffer(e,n),l[e]=n,e===t.DRAW_FRAMEBUFFER&&(l[t.FRAMEBUFFER]=n),e===t.FRAMEBUFFER&&(l[t.DRAW_FRAMEBUFFER]=n),1):0},drawBuffers:function(e,n){let r=h,i=0;if(e){r=c.get(n),void 0===r&&(r=[],c.set(n,r));const a=e.textures;if(r.length!==a.length||r[0]!==t.COLOR_ATTACHMENT0){for(let e=0,n=a.length;e<n;e++)r[e]=t.COLOR_ATTACHMENT0+e;r.length=a.length,i=1}}else r[0]!==t.BACK&&(r[0]=t.BACK,i=1);i&&t.drawBuffers(r)},useProgram:function(e){return u!==e?(t.useProgram(e),u=e,1):0},setBlending:W,setMaterial:function(e,a){2===e.side?V(t.CULL_FACE):z(t.CULL_FACE);let s=1===e.side;a&&(s=!s),X(s),1===e.blending&&0==e.transparent?W(0):W(e.blending,e.blendEquation,e.blendSrc,e.blendDst,e.blendEquationAlpha,e.blendSrcAlpha,e.blendDstAlpha,e.blendColor,e.blendAlpha,e.premultipliedAlpha),r.setFunc(e.depthFunc),r.setTest(e.depthTest),r.setMask(e.depthWrite),n.setMask(e.colorWrite);const o=e.stencilWrite;i.setTest(o),o&&(i.setMask(e.stencilWriteMask),i.setFunc(e.stencilFunc,e.stencilRef,e.stencilFuncMask),i.setOp(e.stencilFail,e.stencilZFail,e.stencilZPass)),q(e.polygonOffset,e.polygonOffsetFactor,e.polygonOffsetUnits),1==e.alphaToCoverage?z(t.SAMPLE_ALPHA_TO_COVERAGE):V(t.SAMPLE_ALPHA_TO_COVERAGE)},setFlipSided:X,setCullFace:j,setLineWidth:function(e){e!==M&&(C&&t.lineWidth(e),M=e)},setPolygonOffset:q,setScissorTest:function(e){e?z(t.SCISSOR_TEST):V(t.SCISSOR_TEST)},activeTexture:function(e){void 0===e&&(e=t.TEXTURE0+A-1),U!==e&&(t.activeTexture(e),U=e)},bindTexture:function(e,n,r){void 0===r&&(r=null===U?t.TEXTURE0+A-1:U);let i=L[r];void 0===i&&(i={type:void 0,texture:void 0},L[r]=i),i.type===e&&i.texture===n||(U!==r&&(t.activeTexture(r),U=r),t.bindTexture(e,n||k[e]),i.type=e,i.texture=n)},unbindTexture:function(){const e=L[U];void 0!==e&&void 0!==e.type&&(t.bindTexture(e.type,null),e.type=void 0,e.texture=void 0)},compressedTexImage2D:function(){try{t.compressedTexImage2D(...arguments)}catch(t){}},compressedTexImage3D:function(){try{t.compressedTexImage3D(...arguments)}catch(t){}},texImage2D:function(){try{t.texImage2D(...arguments)}catch(t){}},texImage3D:function(){try{t.texImage3D(...arguments)}catch(t){}},updateUBOMapping:function(e,n){let r=s.get(n);void 0===r&&(r=new WeakMap,s.set(n,r));let i=r.get(e);void 0===i&&(i=t.getUniformBlockIndex(n,e.name),r.set(e,i))},uniformBlockBinding:function(e,n){const r=s.get(n).get(e);a.get(n)!==r&&(t.uniformBlockBinding(n,r,e.__bindingPointIndex),a.set(n,r))},texStorage2D:function(){try{t.texStorage2D(...arguments)}catch(t){}},texStorage3D:function(){try{t.texStorage3D(...arguments)}catch(t){}},texSubImage2D:function(){try{t.texSubImage2D(...arguments)}catch(t){}},texSubImage3D:function(){try{t.texSubImage3D(...arguments)}catch(t){}},compressedTexSubImage2D:function(){try{t.compressedTexSubImage2D(...arguments)}catch(t){}},compressedTexSubImage3D:function(){try{t.compressedTexSubImage3D(...arguments)}catch(t){}},scissor:function(e){0==O.equals(e)&&(t.scissor(e.x,e.y,e.z,e.w),O.copy(e))},viewport:function(e){0==F.equals(e)&&(t.viewport(e.x,e.y,e.z,e.w),F.copy(e))},reset:function(){t.disable(t.BLEND),t.disable(t.CULL_FACE),t.disable(t.DEPTH_TEST),t.disable(t.POLYGON_OFFSET_FILL),t.disable(t.SCISSOR_TEST),t.disable(t.STENCIL_TEST),t.disable(t.SAMPLE_ALPHA_TO_COVERAGE),t.blendEquation(t.FUNC_ADD),t.blendFunc(t.ONE,t.ZERO),t.blendFuncSeparate(t.ONE,t.ZERO,t.ONE,t.ZERO),t.blendColor(0,0,0,0),t.colorMask(1,1,1,1),t.clearColor(0,0,0,0),t.depthMask(1),t.depthFunc(t.LESS),r.setReversed(0),t.clearDepth(1),t.stencilMask(4294967295),t.stencilFunc(t.ALWAYS,0,4294967295),t.stencilOp(t.KEEP,t.KEEP,t.KEEP),t.clearStencil(0),t.cullFace(t.BACK),t.frontFace(t.CCW),t.polygonOffset(0,0),t.activeTexture(t.TEXTURE0),t.bindFramebuffer(t.FRAMEBUFFER,null),t.bindFramebuffer(t.DRAW_FRAMEBUFFER,null),t.bindFramebuffer(t.READ_FRAMEBUFFER,null),t.useProgram(null),t.lineWidth(1),t.scissor(0,0,t.canvas.width,t.canvas.height),t.viewport(0,0,t.canvas.width,t.canvas.height),o={},U=null,L={},l={},c=new WeakMap,h=[],u=null,d=0,p=null,f=null,m=null,g=null,v=null,x=null,_=null,y=new ma(0,0,0),b=0,E=0,T=null,S=null,M=null,w=null,R=null,O.set(0,0,t.canvas.width,t.canvas.height),F.set(0,0,t.canvas.width,t.canvas.height),n.reset(),r.reset(),i.reset()}}}function tu(t,e,n,r,i,a,s){const o=e.has("WEBGL_multisampled_render_to_texture")?e.get("WEBGL_multisampled_render_to_texture"):null,l="undefined"==typeof navigator?0:/OculusBrowser/g.test(navigator.userAgent),c=new _r,h=new WeakMap;let u;const d=new WeakMap;let p=0;try{p="undefined"!=typeof OffscreenCanvas&&null!==new OffscreenCanvas(1,1).getContext("2d")}catch(t){}function f(t,e){return p?new OffscreenCanvas(t,e):Rr("canvas")}function m(t,e,n){let r=1;const i=G(t);if((i.width>n||i.height>n)&&(r=n/Math.max(i.width,i.height)),r<1){if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap||"undefined"!=typeof VideoFrame&&t instanceof VideoFrame){const n=Math.floor(r*i.width),a=Math.floor(r*i.height);void 0===u&&(u=f(n,a));const s=e?f(n,a):u;s.width=n,s.height=a;return s.getContext("2d").drawImage(t,0,0,n,a),s}return t}return t}function g(t){return t.generateMipmaps}function v(e){t.generateMipmap(e)}function x(e){return e.isWebGLCubeRenderTarget?t.TEXTURE_CUBE_MAP:e.isWebGL3DRenderTarget?t.TEXTURE_3D:e.isWebGLArrayRenderTarget||e.isCompressedArrayTexture?t.TEXTURE_2D_ARRAY:t.TEXTURE_2D}function _(n,r,i,a,s=0){if(null!==n&&void 0!==t[n])return t[n];let o=r;if(r===t.RED&&(i===t.FLOAT&&(o=t.R32F),i===t.HALF_FLOAT&&(o=t.R16F),i===t.UNSIGNED_BYTE&&(o=t.R8)),r===t.RED_INTEGER&&(i===t.UNSIGNED_BYTE&&(o=t.R8UI),i===t.UNSIGNED_SHORT&&(o=t.R16UI),i===t.UNSIGNED_INT&&(o=t.R32UI),i===t.BYTE&&(o=t.R8I),i===t.SHORT&&(o=t.R16I),i===t.INT&&(o=t.R32I)),r===t.RG&&(i===t.FLOAT&&(o=t.RG32F),i===t.HALF_FLOAT&&(o=t.RG16F),i===t.UNSIGNED_BYTE&&(o=t.RG8)),r===t.RG_INTEGER&&(i===t.UNSIGNED_BYTE&&(o=t.RG8UI),i===t.UNSIGNED_SHORT&&(o=t.RG16UI),i===t.UNSIGNED_INT&&(o=t.RG32UI),i===t.BYTE&&(o=t.RG8I),i===t.SHORT&&(o=t.RG16I),i===t.INT&&(o=t.RG32I)),r===t.RGB_INTEGER&&(i===t.UNSIGNED_BYTE&&(o=t.RGB8UI),i===t.UNSIGNED_SHORT&&(o=t.RGB16UI),i===t.UNSIGNED_INT&&(o=t.RGB32UI),i===t.BYTE&&(o=t.RGB8I),i===t.SHORT&&(o=t.RGB16I),i===t.INT&&(o=t.RGB32I)),r===t.RGBA_INTEGER&&(i===t.UNSIGNED_BYTE&&(o=t.RGBA8UI),i===t.UNSIGNED_SHORT&&(o=t.RGBA16UI),i===t.UNSIGNED_INT&&(o=t.RGBA32UI),i===t.BYTE&&(o=t.RGBA8I),i===t.SHORT&&(o=t.RGBA16I),i===t.INT&&(o=t.RGBA32I)),r===t.RGB&&i===t.UNSIGNED_INT_5_9_9_9_REV&&(o=t.RGB9_E5),r===t.RGBA){const e=s?jn:Ir.getTransfer(a);i===t.FLOAT&&(o=t.RGBA32F),i===t.HALF_FLOAT&&(o=t.RGBA16F),i===t.UNSIGNED_BYTE&&(o=e===qn?t.SRGB8_ALPHA8:t.RGBA8),i===t.UNSIGNED_SHORT_4_4_4_4&&(o=t.RGBA4),i===t.UNSIGNED_SHORT_5_5_5_1&&(o=t.RGB5_A1)}return o!==t.R16F&&o!==t.R32F&&o!==t.RG16F&&o!==t.RG32F&&o!==t.RGBA16F&&o!==t.RGBA32F||e.get("EXT_color_buffer_float"),o}function y(e,n){let r;return e?null===n||n===Xe||n===Ze?r=t.DEPTH24_STENCIL8:n===je?r=t.DEPTH32F_STENCIL8:n===Ge&&(r=t.DEPTH24_STENCIL8):null===n||n===Xe||n===Ze?r=t.DEPTH_COMPONENT24:n===je?r=t.DEPTH_COMPONENT32F:n===Ge&&(r=t.DEPTH_COMPONENT16),r}function b(t,e){return 1==g(t)||t.isFramebufferTexture&&t.minFilter!==Ie&&t.minFilter!==Fe?Math.log2(Math.max(e.width,e.height))+1:void 0!==t.mipmaps&&t.mipmaps.length>0?t.mipmaps.length:t.isCompressedTexture&&Array.isArray(t.image)?e.mipmaps.length:1}function E(t){const e=t.target;e.removeEventListener("dispose",E),function(t){const e=r.get(t);if(void 0===e.__webglInit)return;const n=t.source,i=d.get(n);if(i){const r=i[e.__cacheKey];r.usedTimes--,0===r.usedTimes&&S(t),0===Object.keys(i).length&&d.delete(n)}r.remove(t)}(e),e.isVideoTexture&&h.delete(e)}function T(e){const n=e.target;n.removeEventListener("dispose",T),function(e){const n=r.get(e);e.depthTexture&&(e.depthTexture.dispose(),r.remove(e.depthTexture));if(e.isWebGLCubeRenderTarget)for(let e=0;e<6;e++){if(Array.isArray(n.__webglFramebuffer[e]))for(let r=0;r<n.__webglFramebuffer[e].length;r++)t.deleteFramebuffer(n.__webglFramebuffer[e][r]);else t.deleteFramebuffer(n.__webglFramebuffer[e]);n.__webglDepthbuffer&&t.deleteRenderbuffer(n.__webglDepthbuffer[e])}else{if(Array.isArray(n.__webglFramebuffer))for(let e=0;e<n.__webglFramebuffer.length;e++)t.deleteFramebuffer(n.__webglFramebuffer[e]);else t.deleteFramebuffer(n.__webglFramebuffer);if(n.__webglDepthbuffer&&t.deleteRenderbuffer(n.__webglDepthbuffer),n.__webglMultisampledFramebuffer&&t.deleteFramebuffer(n.__webglMultisampledFramebuffer),n.__webglColorRenderbuffer)for(let e=0;e<n.__webglColorRenderbuffer.length;e++)n.__webglColorRenderbuffer[e]&&t.deleteRenderbuffer(n.__webglColorRenderbuffer[e]);n.__webglDepthRenderbuffer&&t.deleteRenderbuffer(n.__webglDepthRenderbuffer)}const i=e.textures;for(let e=0,n=i.length;e<n;e++){const n=r.get(i[e]);n.__webglTexture&&(t.deleteTexture(n.__webglTexture),s.memory.textures--),r.remove(i[e])}r.remove(e)}(n)}function S(e){const n=r.get(e);t.deleteTexture(n.__webglTexture);const i=e.source;delete d.get(i)[n.__cacheKey],s.memory.textures--}let M=0;function w(e,i){const a=r.get(e);if(e.isVideoTexture&&function(t){const e=s.render.frame;h.get(t)!==e&&(h.set(t,e),t.update())}(e),0==e.isRenderTargetTexture&&1!=e.isExternalTexture&&e.version>0&&a.__version!==e.version){const t=e.image;if(null===t);else if(0!=t.complete)return void L(a,e,i)}else e.isExternalTexture&&(a.__webglTexture=e.sourceTexture?e.sourceTexture:null);n.bindTexture(t.TEXTURE_2D,a.__webglTexture,t.TEXTURE0+i)}const R={[De]:t.REPEAT,[Ue]:t.CLAMP_TO_EDGE,[Le]:t.MIRRORED_REPEAT},A={[Ie]:t.NEAREST,[Ne]:t.NEAREST_MIPMAP_NEAREST,[Oe]:t.NEAREST_MIPMAP_LINEAR,[Fe]:t.LINEAR,[Be]:t.LINEAR_MIPMAP_NEAREST,[ke]:t.LINEAR_MIPMAP_LINEAR},C={[Kn]:t.NEVER,[nr]:t.ALWAYS,[Zn]:t.LESS,[Jn]:t.LEQUAL,[$n]:t.EQUAL,[er]:t.GEQUAL,[Qn]:t.GREATER,[tr]:t.NOTEQUAL};function P(n,a){if(a.type===je&&0==e.has("OES_texture_float_linear")&&(a.magFilter===Fe||a.magFilter===Be||a.magFilter===Oe||a.magFilter===ke||a.minFilter===Fe||a.minFilter===Be||a.minFilter===Oe||a.minFilter),t.texParameteri(n,t.TEXTURE_WRAP_S,R[a.wrapS]),t.texParameteri(n,t.TEXTURE_WRAP_T,R[a.wrapT]),n!==t.TEXTURE_3D&&n!==t.TEXTURE_2D_ARRAY||t.texParameteri(n,t.TEXTURE_WRAP_R,R[a.wrapR]),t.texParameteri(n,t.TEXTURE_MAG_FILTER,A[a.magFilter]),t.texParameteri(n,t.TEXTURE_MIN_FILTER,A[a.minFilter]),a.compareFunction&&(t.texParameteri(n,t.TEXTURE_COMPARE_MODE,t.COMPARE_REF_TO_TEXTURE),t.texParameteri(n,t.TEXTURE_COMPARE_FUNC,C[a.compareFunction])),1==e.has("EXT_texture_filter_anisotropic")){if(a.magFilter===Ie)return;if(a.minFilter!==Oe&&a.minFilter!==ke)return;if(a.type===je&&0==e.has("OES_texture_float_linear"))return;if(a.anisotropy>1||r.get(a).__currentAnisotropy){const s=e.get("EXT_texture_filter_anisotropic");t.texParameterf(n,s.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(a.anisotropy,i.getMaxAnisotropy())),r.get(a).__currentAnisotropy=a.anisotropy}}}function D(e,n){let r=0;void 0===e.__webglInit&&(e.__webglInit=1,n.addEventListener("dispose",E));const i=n.source;let a=d.get(i);void 0===a&&(a={},d.set(i,a));const o=function(t){const e=[];return e.push(t.wrapS),e.push(t.wrapT),e.push(t.wrapR||0),e.push(t.magFilter),e.push(t.minFilter),e.push(t.anisotropy),e.push(t.internalFormat),e.push(t.format),e.push(t.type),e.push(t.generateMipmaps),e.push(t.premultiplyAlpha),e.push(t.flipY),e.push(t.unpackAlignment),e.push(t.colorSpace),e.join()}(n);if(o!==e.__cacheKey){void 0===a[o]&&(a[o]={texture:t.createTexture(),usedTimes:0},s.memory.textures++,r=1),a[o].usedTimes++;const i=a[e.__cacheKey];void 0!==i&&(a[e.__cacheKey].usedTimes--,0===i.usedTimes&&S(n)),e.__cacheKey=o,e.__webglTexture=a[o].texture}return r}function U(t,e,n){return Math.floor(Math.floor(t/n)/e)}function L(e,s,o){let l=t.TEXTURE_2D;(s.isDataArrayTexture||s.isCompressedArrayTexture)&&(l=t.TEXTURE_2D_ARRAY),s.isData3DTexture&&(l=t.TEXTURE_3D);const c=D(e,s),h=s.source;n.bindTexture(l,e.__webglTexture,t.TEXTURE0+o);const u=r.get(h);if(h.version!==u.__version||1==c){n.activeTexture(t.TEXTURE0+o);const e=Ir.getPrimaries(Ir.workingColorSpace),r=s.colorSpace===Gn?null:Ir.getPrimaries(s.colorSpace),d=s.colorSpace===Gn||e===r?t.NONE:t.BROWSER_DEFAULT_WEBGL;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,s.flipY),t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,s.premultiplyAlpha),t.pixelStorei(t.UNPACK_ALIGNMENT,s.unpackAlignment),t.pixelStorei(t.UNPACK_COLORSPACE_CONVERSION_WEBGL,d);let p=m(s.image,0,i.maxTextureSize);p=H(s,p);const f=a.convert(s.format,s.colorSpace),x=a.convert(s.type);let E,T=_(s.internalFormat,f,x,s.colorSpace,s.isVideoTexture);P(l,s);const S=s.mipmaps,M=1!=s.isVideoTexture,w=void 0===u.__version||1==c,R=h.dataReady,A=b(s,p);if(s.isDepthTexture)T=y(s.format===tn,s.type),w&&(M?n.texStorage2D(t.TEXTURE_2D,1,T,p.width,p.height):n.texImage2D(t.TEXTURE_2D,0,T,p.width,p.height,0,f,x,null));else if(s.isDataTexture)if(S.length>0){M&&w&&n.texStorage2D(t.TEXTURE_2D,A,T,S[0].width,S[0].height);for(let e=0,r=S.length;e<r;e++)E=S[e],M?R&&n.texSubImage2D(t.TEXTURE_2D,e,0,0,E.width,E.height,f,x,E.data):n.texImage2D(t.TEXTURE_2D,e,T,E.width,E.height,0,f,x,E.data);s.generateMipmaps=0}else M?(w&&n.texStorage2D(t.TEXTURE_2D,A,T,p.width,p.height),R&&function(e,r,i,a){const s=e.updateRanges;if(0===s.length)n.texSubImage2D(t.TEXTURE_2D,0,0,0,r.width,r.height,i,a,r.data);else{s.sort((t,e)=>t.start-e.start);let o=0;for(let t=1;t<s.length;t++){const e=s[o],n=s[t],i=e.start+e.count,a=U(n.start,r.width,4),l=U(e.start,r.width,4);n.start<=i+1&&a===l&&U(n.start+n.count-1,r.width,4)===a?e.count=Math.max(e.count,n.start+n.count-e.start):(++o,s[o]=n)}s.length=o+1;const l=t.getParameter(t.UNPACK_ROW_LENGTH),c=t.getParameter(t.UNPACK_SKIP_PIXELS),h=t.getParameter(t.UNPACK_SKIP_ROWS);t.pixelStorei(t.UNPACK_ROW_LENGTH,r.width);for(let e=0,o=s.length;e<o;e++){const o=s[e],l=Math.floor(o.start/4),c=Math.ceil(o.count/4),h=l%r.width,u=Math.floor(l/r.width),d=c,p=1;t.pixelStorei(t.UNPACK_SKIP_PIXELS,h),t.pixelStorei(t.UNPACK_SKIP_ROWS,u),n.texSubImage2D(t.TEXTURE_2D,0,h,u,d,p,i,a,r.data)}e.clearUpdateRanges(),t.pixelStorei(t.UNPACK_ROW_LENGTH,l),t.pixelStorei(t.UNPACK_SKIP_PIXELS,c),t.pixelStorei(t.UNPACK_SKIP_ROWS,h)}}(s,p,f,x)):n.texImage2D(t.TEXTURE_2D,0,T,p.width,p.height,0,f,x,p.data);else if(s.isCompressedTexture)if(s.isCompressedArrayTexture){M&&w&&n.texStorage3D(t.TEXTURE_2D_ARRAY,A,T,S[0].width,S[0].height,p.depth);for(let e=0,r=S.length;e<r;e++)if(E=S[e],s.format!==Je){if(null!==f)if(M){if(R)if(s.layerUpdates.size>0){const r=Ml(E.width,E.height,s.format,s.type);for(const i of s.layerUpdates){const a=E.data.subarray(i*r/E.data.BYTES_PER_ELEMENT,(i+1)*r/E.data.BYTES_PER_ELEMENT);n.compressedTexSubImage3D(t.TEXTURE_2D_ARRAY,e,0,0,i,E.width,E.height,1,f,a)}s.clearLayerUpdates()}else n.compressedTexSubImage3D(t.TEXTURE_2D_ARRAY,e,0,0,0,E.width,E.height,p.depth,f,E.data)}else n.compressedTexImage3D(t.TEXTURE_2D_ARRAY,e,T,E.width,E.height,p.depth,0,E.data,0,0)}else M?R&&n.texSubImage3D(t.TEXTURE_2D_ARRAY,e,0,0,0,E.width,E.height,p.depth,f,x,E.data):n.texImage3D(t.TEXTURE_2D_ARRAY,e,T,E.width,E.height,p.depth,0,f,x,E.data)}else{M&&w&&n.texStorage2D(t.TEXTURE_2D,A,T,S[0].width,S[0].height);for(let e=0,r=S.length;e<r;e++)E=S[e],s.format!==Je?null!==f&&(M?R&&n.compressedTexSubImage2D(t.TEXTURE_2D,e,0,0,E.width,E.height,f,E.data):n.compressedTexImage2D(t.TEXTURE_2D,e,T,E.width,E.height,0,E.data)):M?R&&n.texSubImage2D(t.TEXTURE_2D,e,0,0,E.width,E.height,f,x,E.data):n.texImage2D(t.TEXTURE_2D,e,T,E.width,E.height,0,f,x,E.data)}else if(s.isDataArrayTexture)if(M){if(w&&n.texStorage3D(t.TEXTURE_2D_ARRAY,A,T,p.width,p.height,p.depth),R)if(s.layerUpdates.size>0){const e=Ml(p.width,p.height,s.format,s.type);for(const r of s.layerUpdates){const i=p.data.subarray(r*e/p.data.BYTES_PER_ELEMENT,(r+1)*e/p.data.BYTES_PER_ELEMENT);n.texSubImage3D(t.TEXTURE_2D_ARRAY,0,0,0,r,p.width,p.height,1,f,x,i)}s.clearLayerUpdates()}else n.texSubImage3D(t.TEXTURE_2D_ARRAY,0,0,0,0,p.width,p.height,p.depth,f,x,p.data)}else n.texImage3D(t.TEXTURE_2D_ARRAY,0,T,p.width,p.height,p.depth,0,f,x,p.data);else if(s.isData3DTexture)M?(w&&n.texStorage3D(t.TEXTURE_3D,A,T,p.width,p.height,p.depth),R&&n.texSubImage3D(t.TEXTURE_3D,0,0,0,0,p.width,p.height,p.depth,f,x,p.data)):n.texImage3D(t.TEXTURE_3D,0,T,p.width,p.height,p.depth,0,f,x,p.data);else if(s.isFramebufferTexture){if(w)if(M)n.texStorage2D(t.TEXTURE_2D,A,T,p.width,p.height);else{let e=p.width,r=p.height;for(let i=0;i<A;i++)n.texImage2D(t.TEXTURE_2D,i,T,e,r,0,f,x,null),e>>=1,r>>=1}}else if(S.length>0){if(M&&w){const e=G(S[0]);n.texStorage2D(t.TEXTURE_2D,A,T,e.width,e.height)}for(let e=0,r=S.length;e<r;e++)E=S[e],M?R&&n.texSubImage2D(t.TEXTURE_2D,e,0,0,f,x,E):n.texImage2D(t.TEXTURE_2D,e,T,f,x,E);s.generateMipmaps=0}else if(M){if(w){const e=G(p);n.texStorage2D(t.TEXTURE_2D,A,T,e.width,e.height)}R&&n.texSubImage2D(t.TEXTURE_2D,0,0,0,f,x,p)}else n.texImage2D(t.TEXTURE_2D,0,T,f,x,p);g(s)&&v(l),u.__version=h.version,s.onUpdate&&s.onUpdate(s)}e.__version=s.version}function I(e,i,s,l,c,h){const u=a.convert(s.format,s.colorSpace),d=a.convert(s.type),p=_(s.internalFormat,u,d,s.colorSpace),f=r.get(i),m=r.get(s);if(m.__renderTarget=i,!f.__hasExternalTextures){const e=Math.max(1,i.width>>h),r=Math.max(1,i.height>>h);c===t.TEXTURE_3D||c===t.TEXTURE_2D_ARRAY?n.texImage3D(c,h,p,e,r,i.depth,0,u,d,null):n.texImage2D(c,h,p,e,r,0,u,d,null)}n.bindFramebuffer(t.FRAMEBUFFER,e),V(i)?o.framebufferTexture2DMultisampleEXT(t.FRAMEBUFFER,l,c,m.__webglTexture,0,z(i)):(c===t.TEXTURE_2D||c>=t.TEXTURE_CUBE_MAP_POSITIVE_X&&c<=t.TEXTURE_CUBE_MAP_NEGATIVE_Z)&&t.framebufferTexture2D(t.FRAMEBUFFER,l,c,m.__webglTexture,h),n.bindFramebuffer(t.FRAMEBUFFER,null)}function N(e,n,r){if(t.bindRenderbuffer(t.RENDERBUFFER,e),n.depthBuffer){const i=n.depthTexture,a=i&&i.isDepthTexture?i.type:null,s=y(n.stencilBuffer,a),l=n.stencilBuffer?t.DEPTH_STENCIL_ATTACHMENT:t.DEPTH_ATTACHMENT,c=z(n);V(n)?o.renderbufferStorageMultisampleEXT(t.RENDERBUFFER,c,s,n.width,n.height):r?t.renderbufferStorageMultisample(t.RENDERBUFFER,c,s,n.width,n.height):t.renderbufferStorage(t.RENDERBUFFER,s,n.width,n.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,l,t.RENDERBUFFER,e)}else{const e=n.textures;for(let i=0;i<e.length;i++){const s=e[i],l=a.convert(s.format,s.colorSpace),c=a.convert(s.type),h=_(s.internalFormat,l,c,s.colorSpace),u=z(n);r&&0==V(n)?t.renderbufferStorageMultisample(t.RENDERBUFFER,u,h,n.width,n.height):V(n)?o.renderbufferStorageMultisampleEXT(t.RENDERBUFFER,u,h,n.width,n.height):t.renderbufferStorage(t.RENDERBUFFER,h,n.width,n.height)}}t.bindRenderbuffer(t.RENDERBUFFER,null)}function O(e,i){if(i&&i.isWebGLCubeRenderTarget)throw new Error("Depth Texture with cube render targets is not supported");if(n.bindFramebuffer(t.FRAMEBUFFER,e),!i.depthTexture||!i.depthTexture.isDepthTexture)throw new Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");const a=r.get(i.depthTexture);a.__renderTarget=i,a.__webglTexture&&i.depthTexture.image.width===i.width&&i.depthTexture.image.height===i.height||(i.depthTexture.image.width=i.width,i.depthTexture.image.height=i.height,i.depthTexture.needsUpdate=1),w(i.depthTexture,0);const s=a.__webglTexture,l=z(i);if(i.depthTexture.format===Qe)V(i)?o.framebufferTexture2DMultisampleEXT(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.TEXTURE_2D,s,0,l):t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.TEXTURE_2D,s,0);else{if(i.depthTexture.format!==tn)throw new Error("Unknown depthTexture format");V(i)?o.framebufferTexture2DMultisampleEXT(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.TEXTURE_2D,s,0,l):t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.TEXTURE_2D,s,0)}}function F(e){const i=r.get(e),a=1==e.isWebGLCubeRenderTarget;if(i.__boundDepthTexture!==e.depthTexture){const t=e.depthTexture;if(i.__depthDisposeCallback&&i.__depthDisposeCallback(),t){const e=()=>{delete i.__boundDepthTexture,delete i.__depthDisposeCallback,t.removeEventListener("dispose",e)};t.addEventListener("dispose",e),i.__depthDisposeCallback=e}i.__boundDepthTexture=t}if(e.depthTexture&&!i.__autoAllocateDepthBuffer){if(a)throw new Error("target.depthTexture not supported in Cube render targets");const t=e.texture.mipmaps;t&&t.length>0?O(i.__webglFramebuffer[0],e):O(i.__webglFramebuffer,e)}else if(a){i.__webglDepthbuffer=[];for(let r=0;r<6;r++)if(n.bindFramebuffer(t.FRAMEBUFFER,i.__webglFramebuffer[r]),void 0===i.__webglDepthbuffer[r])i.__webglDepthbuffer[r]=t.createRenderbuffer(),N(i.__webglDepthbuffer[r],e,0);else{const n=e.stencilBuffer?t.DEPTH_STENCIL_ATTACHMENT:t.DEPTH_ATTACHMENT,a=i.__webglDepthbuffer[r];t.bindRenderbuffer(t.RENDERBUFFER,a),t.framebufferRenderbuffer(t.FRAMEBUFFER,n,t.RENDERBUFFER,a)}}else{const r=e.texture.mipmaps;if(r&&r.length>0?n.bindFramebuffer(t.FRAMEBUFFER,i.__webglFramebuffer[0]):n.bindFramebuffer(t.FRAMEBUFFER,i.__webglFramebuffer),void 0===i.__webglDepthbuffer)i.__webglDepthbuffer=t.createRenderbuffer(),N(i.__webglDepthbuffer,e,0);else{const n=e.stencilBuffer?t.DEPTH_STENCIL_ATTACHMENT:t.DEPTH_ATTACHMENT,r=i.__webglDepthbuffer;t.bindRenderbuffer(t.RENDERBUFFER,r),t.framebufferRenderbuffer(t.FRAMEBUFFER,n,t.RENDERBUFFER,r)}}n.bindFramebuffer(t.FRAMEBUFFER,null)}const B=[],k=[];function z(t){return Math.min(i.maxSamples,t.samples)}function V(t){const n=r.get(t);return t.samples>0&&1==e.has("WEBGL_multisampled_render_to_texture")&&0!=n.__useRenderToTexture}function H(t,e){const n=t.colorSpace;t.format,t.type;return 1==t.isCompressedTexture||1==t.isVideoTexture||n!==Xn&&n!==Gn&&Ir.getTransfer(n),e}function G(t){return"undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement?(c.width=t.naturalWidth||t.width,c.height=t.naturalHeight||t.height):"undefined"!=typeof VideoFrame&&t instanceof VideoFrame?(c.width=t.displayWidth,c.height=t.displayHeight):(c.width=t.width,c.height=t.height),c}this.allocateTextureUnit=function(){const t=M;return i.maxTextures,M+=1,t},this.resetTextureUnits=function(){M=0},this.setTexture2D=w,this.setTexture2DArray=function(e,i){const a=r.get(e);0==e.isRenderTargetTexture&&e.version>0&&a.__version!==e.version?L(a,e,i):n.bindTexture(t.TEXTURE_2D_ARRAY,a.__webglTexture,t.TEXTURE0+i)},this.setTexture3D=function(e,i){const a=r.get(e);0==e.isRenderTargetTexture&&e.version>0&&a.__version!==e.version?L(a,e,i):n.bindTexture(t.TEXTURE_3D,a.__webglTexture,t.TEXTURE0+i)},this.setTextureCube=function(e,s){const o=r.get(e);e.version>0&&o.__version!==e.version?function(e,s,o){if(6!==s.image.length)return;const l=D(e,s),c=s.source;n.bindTexture(t.TEXTURE_CUBE_MAP,e.__webglTexture,t.TEXTURE0+o);const h=r.get(c);if(c.version!==h.__version||1==l){n.activeTexture(t.TEXTURE0+o);const e=Ir.getPrimaries(Ir.workingColorSpace),r=s.colorSpace===Gn?null:Ir.getPrimaries(s.colorSpace),u=s.colorSpace===Gn||e===r?t.NONE:t.BROWSER_DEFAULT_WEBGL;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,s.flipY),t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,s.premultiplyAlpha),t.pixelStorei(t.UNPACK_ALIGNMENT,s.unpackAlignment),t.pixelStorei(t.UNPACK_COLORSPACE_CONVERSION_WEBGL,u);const d=s.isCompressedTexture||s.image[0].isCompressedTexture,p=s.image[0]&&s.image[0].isDataTexture,f=[];for(let t=0;t<6;t++)f[t]=d||p?p?s.image[t].image:s.image[t]:m(s.image[t],1,i.maxCubemapSize),f[t]=H(s,f[t]);const x=f[0],y=a.convert(s.format,s.colorSpace),E=a.convert(s.type),T=_(s.internalFormat,y,E,s.colorSpace),S=1!=s.isVideoTexture,M=void 0===h.__version||1==l,w=c.dataReady;let R,A=b(s,x);if(P(t.TEXTURE_CUBE_MAP,s),d){S&&M&&n.texStorage2D(t.TEXTURE_CUBE_MAP,A,T,x.width,x.height);for(let e=0;e<6;e++){R=f[e].mipmaps;for(let r=0;r<R.length;r++){const i=R[r];s.format!==Je?null!==y&&(S?w&&n.compressedTexSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r,0,0,i.width,i.height,y,i.data):n.compressedTexImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r,T,i.width,i.height,0,i.data)):S?w&&n.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r,0,0,i.width,i.height,y,E,i.data):n.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r,T,i.width,i.height,0,y,E,i.data)}}}else{if(R=s.mipmaps,S&&M){R.length>0&&A++;const e=G(f[0]);n.texStorage2D(t.TEXTURE_CUBE_MAP,A,T,e.width,e.height)}for(let e=0;e<6;e++)if(p){S?w&&n.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,0,0,f[e].width,f[e].height,y,E,f[e].data):n.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,T,f[e].width,f[e].height,0,y,E,f[e].data);for(let r=0;r<R.length;r++){const i=R[r].image[e].image;S?w&&n.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r+1,0,0,i.width,i.height,y,E,i.data):n.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r+1,T,i.width,i.height,0,y,E,i.data)}}else{S?w&&n.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,0,0,y,E,f[e]):n.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,T,y,E,f[e]);for(let r=0;r<R.length;r++){const i=R[r];S?w&&n.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r+1,0,0,y,E,i.image[e]):n.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r+1,T,y,E,i.image[e])}}}g(s)&&v(t.TEXTURE_CUBE_MAP),h.__version=c.version,s.onUpdate&&s.onUpdate(s)}e.__version=s.version}(o,e,s):n.bindTexture(t.TEXTURE_CUBE_MAP,o.__webglTexture,t.TEXTURE0+s)},this.rebindTextures=function(e,n,i){const a=r.get(e);void 0!==n&&I(a.__webglFramebuffer,e,e.texture,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,0),void 0!==i&&F(e)},this.setupRenderTarget=function(e){const i=e.texture,o=r.get(e),l=r.get(i);e.addEventListener("dispose",T);const c=e.textures,h=1==e.isWebGLCubeRenderTarget,u=c.length>1;if(u||(void 0===l.__webglTexture&&(l.__webglTexture=t.createTexture()),l.__version=i.version,s.memory.textures++),h){o.__webglFramebuffer=[];for(let e=0;e<6;e++)if(i.mipmaps&&i.mipmaps.length>0){o.__webglFramebuffer[e]=[];for(let n=0;n<i.mipmaps.length;n++)o.__webglFramebuffer[e][n]=t.createFramebuffer()}else o.__webglFramebuffer[e]=t.createFramebuffer()}else{if(i.mipmaps&&i.mipmaps.length>0){o.__webglFramebuffer=[];for(let e=0;e<i.mipmaps.length;e++)o.__webglFramebuffer[e]=t.createFramebuffer()}else o.__webglFramebuffer=t.createFramebuffer();if(u)for(let e=0,n=c.length;e<n;e++){const n=r.get(c[e]);void 0===n.__webglTexture&&(n.__webglTexture=t.createTexture(),s.memory.textures++)}if(e.samples>0&&0==V(e)){o.__webglMultisampledFramebuffer=t.createFramebuffer(),o.__webglColorRenderbuffer=[],n.bindFramebuffer(t.FRAMEBUFFER,o.__webglMultisampledFramebuffer);for(let n=0;n<c.length;n++){const r=c[n];o.__webglColorRenderbuffer[n]=t.createRenderbuffer(),t.bindRenderbuffer(t.RENDERBUFFER,o.__webglColorRenderbuffer[n]);const i=a.convert(r.format,r.colorSpace),s=a.convert(r.type),l=_(r.internalFormat,i,s,r.colorSpace,1==e.isXRRenderTarget),h=z(e);t.renderbufferStorageMultisample(t.RENDERBUFFER,h,l,e.width,e.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0+n,t.RENDERBUFFER,o.__webglColorRenderbuffer[n])}t.bindRenderbuffer(t.RENDERBUFFER,null),e.depthBuffer&&(o.__webglDepthRenderbuffer=t.createRenderbuffer(),N(o.__webglDepthRenderbuffer,e,1)),n.bindFramebuffer(t.FRAMEBUFFER,null)}}if(h){n.bindTexture(t.TEXTURE_CUBE_MAP,l.__webglTexture),P(t.TEXTURE_CUBE_MAP,i);for(let n=0;n<6;n++)if(i.mipmaps&&i.mipmaps.length>0)for(let r=0;r<i.mipmaps.length;r++)I(o.__webglFramebuffer[n][r],e,i,t.COLOR_ATTACHMENT0,t.TEXTURE_CUBE_MAP_POSITIVE_X+n,r);else I(o.__webglFramebuffer[n],e,i,t.COLOR_ATTACHMENT0,t.TEXTURE_CUBE_MAP_POSITIVE_X+n,0);g(i)&&v(t.TEXTURE_CUBE_MAP),n.unbindTexture()}else if(u){for(let i=0,a=c.length;i<a;i++){const a=c[i],s=r.get(a);let l=t.TEXTURE_2D;(e.isWebGL3DRenderTarget||e.isWebGLArrayRenderTarget)&&(l=e.isWebGL3DRenderTarget?t.TEXTURE_3D:t.TEXTURE_2D_ARRAY),n.bindTexture(l,s.__webglTexture),P(l,a),I(o.__webglFramebuffer,e,a,t.COLOR_ATTACHMENT0+i,l,0),g(a)&&v(l)}n.unbindTexture()}else{let r=t.TEXTURE_2D;if((e.isWebGL3DRenderTarget||e.isWebGLArrayRenderTarget)&&(r=e.isWebGL3DRenderTarget?t.TEXTURE_3D:t.TEXTURE_2D_ARRAY),n.bindTexture(r,l.__webglTexture),P(r,i),i.mipmaps&&i.mipmaps.length>0)for(let n=0;n<i.mipmaps.length;n++)I(o.__webglFramebuffer[n],e,i,t.COLOR_ATTACHMENT0,r,n);else I(o.__webglFramebuffer,e,i,t.COLOR_ATTACHMENT0,r,0);g(i)&&v(r),n.unbindTexture()}e.depthBuffer&&F(e)},this.updateRenderTargetMipmap=function(t){const e=t.textures;for(let i=0,a=e.length;i<a;i++){const a=e[i];if(g(a)){const e=x(t),i=r.get(a).__webglTexture;n.bindTexture(e,i),v(e),n.unbindTexture()}}},this.updateMultisampleRenderTarget=function(e){if(e.samples>0)if(0==V(e)){const i=e.textures,a=e.width,s=e.height;let o=t.COLOR_BUFFER_BIT;const c=e.stencilBuffer?t.DEPTH_STENCIL_ATTACHMENT:t.DEPTH_ATTACHMENT,h=r.get(e),u=i.length>1;if(u)for(let e=0;e<i.length;e++)n.bindFramebuffer(t.FRAMEBUFFER,h.__webglMultisampledFramebuffer),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0+e,t.RENDERBUFFER,null),n.bindFramebuffer(t.FRAMEBUFFER,h.__webglFramebuffer),t.framebufferTexture2D(t.DRAW_FRAMEBUFFER,t.COLOR_ATTACHMENT0+e,t.TEXTURE_2D,null,0);n.bindFramebuffer(t.READ_FRAMEBUFFER,h.__webglMultisampledFramebuffer);const d=e.texture.mipmaps;d&&d.length>0?n.bindFramebuffer(t.DRAW_FRAMEBUFFER,h.__webglFramebuffer[0]):n.bindFramebuffer(t.DRAW_FRAMEBUFFER,h.__webglFramebuffer);for(let n=0;n<i.length;n++){if(e.resolveDepthBuffer&&(e.depthBuffer&&(o|=t.DEPTH_BUFFER_BIT),e.stencilBuffer&&e.resolveStencilBuffer&&(o|=t.STENCIL_BUFFER_BIT)),u){t.framebufferRenderbuffer(t.READ_FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.RENDERBUFFER,h.__webglColorRenderbuffer[n]);const e=r.get(i[n]).__webglTexture;t.framebufferTexture2D(t.DRAW_FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0)}t.blitFramebuffer(0,0,a,s,0,0,a,s,o,t.NEAREST),1==l&&(B.length=0,k.length=0,B.push(t.COLOR_ATTACHMENT0+n),e.depthBuffer&&0==e.resolveDepthBuffer&&(B.push(c),k.push(c),t.invalidateFramebuffer(t.DRAW_FRAMEBUFFER,k)),t.invalidateFramebuffer(t.READ_FRAMEBUFFER,B))}if(n.bindFramebuffer(t.READ_FRAMEBUFFER,null),n.bindFramebuffer(t.DRAW_FRAMEBUFFER,null),u)for(let e=0;e<i.length;e++){n.bindFramebuffer(t.FRAMEBUFFER,h.__webglMultisampledFramebuffer),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0+e,t.RENDERBUFFER,h.__webglColorRenderbuffer[e]);const a=r.get(i[e]).__webglTexture;n.bindFramebuffer(t.FRAMEBUFFER,h.__webglFramebuffer),t.framebufferTexture2D(t.DRAW_FRAMEBUFFER,t.COLOR_ATTACHMENT0+e,t.TEXTURE_2D,a,0)}n.bindFramebuffer(t.DRAW_FRAMEBUFFER,h.__webglMultisampledFramebuffer)}else if(e.depthBuffer&&0==e.resolveDepthBuffer&&l){const n=e.stencilBuffer?t.DEPTH_STENCIL_ATTACHMENT:t.DEPTH_ATTACHMENT;t.invalidateFramebuffer(t.DRAW_FRAMEBUFFER,[n])}},this.setupDepthRenderbuffer=F,this.setupFrameBufferTexture=I,this.useMultisampledRTT=V}function eu(t,e){return{convert:function(n,r=""){let i;const a=Ir.getTransfer(r);if(n===ze)return t.UNSIGNED_BYTE;if(n===Ye)return t.UNSIGNED_SHORT_4_4_4_4;if(n===Ke)return t.UNSIGNED_SHORT_5_5_5_1;if(n===$e)return t.UNSIGNED_INT_5_9_9_9_REV;if(n===Ve)return t.BYTE;if(n===He)return t.SHORT;if(n===Ge)return t.UNSIGNED_SHORT;if(n===We)return t.INT;if(n===Xe)return t.UNSIGNED_INT;if(n===je)return t.FLOAT;if(n===qe)return t.HALF_FLOAT;if(1021===n)return t.ALPHA;if(1022===n)return t.RGB;if(n===Je)return t.RGBA;if(n===Qe)return t.DEPTH_COMPONENT;if(n===tn)return t.DEPTH_STENCIL;if(n===en)return t.RED;if(n===nn)return t.RED_INTEGER;if(1030===n)return t.RG;if(n===rn)return t.RG_INTEGER;if(n===an)return t.RGBA_INTEGER;if(n===sn||n===on||n===ln||n===cn)if(a===qn){if(i=e.get("WEBGL_compressed_texture_s3tc_srgb"),null===i)return null;if(n===sn)return i.COMPRESSED_SRGB_S3TC_DXT1_EXT;if(n===on)return i.COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;if(n===ln)return i.COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;if(n===cn)return i.COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT}else{if(i=e.get("WEBGL_compressed_texture_s3tc"),null===i)return null;if(n===sn)return i.COMPRESSED_RGB_S3TC_DXT1_EXT;if(n===on)return i.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(n===ln)return i.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(n===cn)return i.COMPRESSED_RGBA_S3TC_DXT5_EXT}if(n===hn||n===un||n===dn||n===pn){if(i=e.get("WEBGL_compressed_texture_pvrtc"),null===i)return null;if(n===hn)return i.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(n===un)return i.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(n===dn)return i.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(n===pn)return i.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}if(n===fn||n===mn||n===gn){if(i=e.get("WEBGL_compressed_texture_etc"),null===i)return null;if(n===fn||n===mn)return a===qn?i.COMPRESSED_SRGB8_ETC2:i.COMPRESSED_RGB8_ETC2;if(n===gn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:i.COMPRESSED_RGBA8_ETC2_EAC}if(n===vn||n===xn||n===_n||n===yn||n===bn||n===En||n===Tn||n===Sn||n===Mn||n===wn||n===Rn||n===An||n===Cn||n===Pn){if(i=e.get("WEBGL_compressed_texture_astc"),null===i)return null;if(n===vn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR:i.COMPRESSED_RGBA_ASTC_4x4_KHR;if(n===xn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR:i.COMPRESSED_RGBA_ASTC_5x4_KHR;if(n===_n)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR:i.COMPRESSED_RGBA_ASTC_5x5_KHR;if(n===yn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR:i.COMPRESSED_RGBA_ASTC_6x5_KHR;if(n===bn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR:i.COMPRESSED_RGBA_ASTC_6x6_KHR;if(n===En)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR:i.COMPRESSED_RGBA_ASTC_8x5_KHR;if(n===Tn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR:i.COMPRESSED_RGBA_ASTC_8x6_KHR;if(n===Sn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR:i.COMPRESSED_RGBA_ASTC_8x8_KHR;if(n===Mn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR:i.COMPRESSED_RGBA_ASTC_10x5_KHR;if(n===wn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR:i.COMPRESSED_RGBA_ASTC_10x6_KHR;if(n===Rn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR:i.COMPRESSED_RGBA_ASTC_10x8_KHR;if(n===An)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR:i.COMPRESSED_RGBA_ASTC_10x10_KHR;if(n===Cn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR:i.COMPRESSED_RGBA_ASTC_12x10_KHR;if(n===Pn)return a===qn?i.COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR:i.COMPRESSED_RGBA_ASTC_12x12_KHR}if(n===Dn||n===Un||n===Ln){if(i=e.get("EXT_texture_compression_bptc"),null===i)return null;if(n===Dn)return a===qn?i.COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT:i.COMPRESSED_RGBA_BPTC_UNORM_EXT;if(n===Un)return i.COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT;if(n===Ln)return i.COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT}if(36283===n||n===In||n===Nn||n===On){if(i=e.get("EXT_texture_compression_rgtc"),null===i)return null;if(n===Dn)return i.COMPRESSED_RED_RGTC1_EXT;if(n===In)return i.COMPRESSED_SIGNED_RED_RGTC1_EXT;if(n===Nn)return i.COMPRESSED_RED_GREEN_RGTC2_EXT;if(n===On)return i.COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT}return n===Ze?t.UNSIGNED_INT_24_8:void 0!==t[n]?t[n]:null}}}class nu extends Wr{constructor(t=null){super(),this.sourceTexture=t,this.isExternalTexture=1}}class ru{constructor(){this.texture=null,this.mesh=null,this.depthNear=0,this.depthFar=0}init(t,e){if(null===this.texture){const n=new nu(t.texture);t.depthNear===e.depthNear&&t.depthFar===e.depthFar||(this.depthNear=t.depthNear,this.depthFar=t.depthFar),this.texture=n}}getMesh(t){if(null!==this.texture&&null===this.mesh){const e=t.cameras[0].viewport,n=new Qa({vertexShader:"\nvoid main() {\n\n\tgl_Position = vec4( position, 1.0 );\n\n}",fragmentShader:"\nuniform sampler2DArray depthColor;\nuniform float depthWidth;\nuniform float depthHeight;\n\nvoid main() {\n\n\tvec2 coord = vec2( gl_FragCoord.x / depthWidth, gl_FragCoord.y / depthHeight );\n\n\tif ( coord.x >= 1.0 ) {\n\n\t\tgl_FragDepth = texture( depthColor, vec3( coord.x - 1.0, coord.y, 1 ) ).r;\n\n\t} else {\n\n\t\tgl_FragDepth = texture( depthColor, vec3( coord.x, coord.y, 0 ) ).r;\n\n\t}\n\n}",uniforms:{depthColor:{value:this.texture},depthWidth:{value:e.z},depthHeight:{value:e.w}}});this.mesh=new ja(new vo(20,20),n)}return this.mesh}reset(){this.texture=null,this.mesh=null}getDepthTexture(){return this.texture}}class iu extends or{constructor(t,e){super();const n=this;let r=null,i=1,a=null,s="local-floor",o=1,l=null,c=null,h=null,u=null,d=null,p=null;const f=new ru,m={},g=e.getContextAttributes();let v=null,x=null;const _=[],y=[],b=new _r;let E=null;const T=new is;T.viewport=new Xr;const S=new is;S.viewport=new Xr;const M=[T,S],w=new vl;let R=null,A=null;function C(t){const e=y.indexOf(t.inputSource);if(-1===e)return;const n=_[e];void 0!==n&&(n.update(t.inputSource,t.frame,l||a),n.dispatchEvent({type:t.type,data:t.inputSource}))}function P(){r.removeEventListener("select",C),r.removeEventListener("selectstart",C),r.removeEventListener("selectend",C),r.removeEventListener("squeeze",C),r.removeEventListener("squeezestart",C),r.removeEventListener("squeezeend",C),r.removeEventListener("end",P),r.removeEventListener("inputsourceschange",D);for(let t=0;t<_.length;t++){const e=y[t];null!==e&&(y[t]=null,_[t].disconnect(e))}R=null,A=null,f.reset();for(const t in m)delete m[t];t.setRenderTarget(v),d=null,u=null,h=null,r=null,x=null,O.stop(),n.isPresenting=0,t.setPixelRatio(E),t.setSize(b.width,b.height,0),n.dispatchEvent({type:"sessionend"})}function D(t){for(let e=0;e<t.removed.length;e++){const n=t.removed[e],r=y.indexOf(n);r>=0&&(y[r]=null,_[r].disconnect(n))}for(let e=0;e<t.added.length;e++){const n=t.added[e];let r=y.indexOf(n);if(-1===r){for(let t=0;t<_.length;t++){if(t>=y.length){y.push(n),r=t;break}if(null===y[t]){y[t]=n,r=t;break}}if(-1===r)break}const i=_[r];i&&i.connect(n)}}this.cameraAutoUpdate=1,this.enabled=0,this.isPresenting=0,this.getController=function(t){let e=_[t];return void 0===e&&(e=new us,_[t]=e),e.getTargetRaySpace()},this.getControllerGrip=function(t){let e=_[t];return void 0===e&&(e=new us,_[t]=e),e.getGripSpace()},this.getHand=function(t){let e=_[t];return void 0===e&&(e=new us,_[t]=e),e.getHandSpace()},this.setFramebufferScaleFactor=function(t){i=t,n.isPresenting},this.setReferenceSpaceType=function(t){s=t,n.isPresenting},this.getReferenceSpace=function(){return l||a},this.setReferenceSpace=function(t){l=t},this.getBaseLayer=function(){return null!==u?u:d},this.getBinding=function(){return h},this.getFrame=function(){return p},this.getSession=function(){return r},this.setSession=async function(c){if(r=c,null!==r){v=t.getRenderTarget(),r.addEventListener("select",C),r.addEventListener("selectstart",C),r.addEventListener("selectend",C),r.addEventListener("squeeze",C),r.addEventListener("squeezestart",C),r.addEventListener("squeezeend",C),r.addEventListener("end",P),r.addEventListener("inputsourceschange",D),1!=g.xrCompatible&&await e.makeXRCompatible(),E=t.getPixelRatio(),t.getSize(b),"undefined"!=typeof XRWebGLBinding&&(h=new XRWebGLBinding(r,e));if(null!==h&&"createProjectionLayer"in XRWebGLBinding.prototype){let n=null,a=null,s=null;g.depth&&(s=g.stencil?e.DEPTH24_STENCIL8:e.DEPTH_COMPONENT24,n=g.stencil?tn:Qe,a=g.stencil?Ze:Xe);const o={colorFormat:e.RGBA8,depthFormat:s,scaleFactor:i};u=h.createProjectionLayer(o),r.updateRenderState({layers:[u]}),t.setPixelRatio(1),t.setSize(u.textureWidth,u.textureHeight,0),x=new qr(u.textureWidth,u.textureHeight,{format:Je,type:ze,depthTexture:new go(u.textureWidth,u.textureHeight,a,void 0,void 0,void 0,void 0,void 0,void 0,n),stencilBuffer:g.stencil,colorSpace:t.outputColorSpace,samples:g.antialias?4:0,resolveDepthBuffer:0==u.ignoreDepthValues,resolveStencilBuffer:0==u.ignoreDepthValues})}else{const n={antialias:g.antialias,alpha:1,depth:g.depth,stencil:g.stencil,framebufferScaleFactor:i};d=new XRWebGLLayer(r,e,n),r.updateRenderState({baseLayer:d}),t.setPixelRatio(1),t.setSize(d.framebufferWidth,d.framebufferHeight,0),x=new qr(d.framebufferWidth,d.framebufferHeight,{format:Je,type:ze,colorSpace:t.outputColorSpace,stencilBuffer:g.stencil,resolveDepthBuffer:0==d.ignoreDepthValues,resolveStencilBuffer:0==d.ignoreDepthValues})}x.isXRRenderTarget=1,this.setFoveation(o),l=null,a=await r.requestReferenceSpace(s),O.setContext(r),O.start(),n.isPresenting=1,n.dispatchEvent({type:"sessionstart"})}},this.getEnvironmentBlendMode=function(){if(null!==r)return r.environmentBlendMode},this.getDepthTexture=function(){return f.getDepthTexture()};const U=new br,L=new br;function I(t,e){null===e?t.matrixWorld.copy(t.matrix):t.matrixWorld.multiplyMatrices(e.matrixWorld,t.matrix),t.matrixWorldInverse.copy(t.matrixWorld).invert()}this.updateCamera=function(t){if(null===r)return;let e=t.near,n=t.far;null!==f.texture&&(f.depthNear>0&&(e=f.depthNear),f.depthFar>0&&(n=f.depthFar)),w.near=S.near=T.near=e,w.far=S.far=T.far=n,R===w.near&&A===w.far||(r.updateRenderState({depthNear:w.near,depthFar:w.far}),R=w.near,A=w.far),w.layers.mask=6|t.layers.mask,T.layers.mask=3&w.layers.mask,S.layers.mask=5&w.layers.mask;const i=t.parent,a=w.cameras;I(w,i);for(let t=0;t<a.length;t++)I(a[t],i);2===a.length?function(t,e,n){U.setFromMatrixPosition(e.matrixWorld),L.setFromMatrixPosition(n.matrixWorld);const r=U.distanceTo(L),i=e.projectionMatrix.elements,a=n.projectionMatrix.elements,s=i[14]/(i[10]-1),o=i[14]/(i[10]+1),l=(i[9]+1)/i[5],c=(i[9]-1)/i[5],h=(i[8]-1)/i[0],u=(a[8]+1)/a[0],d=s*h,p=s*u,f=r/(-h+u),m=f*-h;if(e.matrixWorld.decompose(t.position,t.quaternion,t.scale),t.translateX(m),t.translateZ(f),t.matrixWorld.compose(t.position,t.quaternion,t.scale),t.matrixWorldInverse.copy(t.matrixWorld).invert(),-1===i[10])t.projectionMatrix.copy(e.projectionMatrix),t.projectionMatrixInverse.copy(e.projectionMatrixInverse);else{const e=s+f,n=o+f,i=d-m,a=p+(r-m),h=l*o/n*e,u=c*o/n*e;t.projectionMatrix.makePerspective(i,a,h,u,e,n),t.projectionMatrixInverse.copy(t.projectionMatrix).invert()}}(w,T,S):w.projectionMatrix.copy(T.projectionMatrix),function(t,e,n){null===n?t.matrix.copy(e.matrixWorld):(t.matrix.copy(n.matrixWorld),t.matrix.invert(),t.matrix.multiply(e.matrixWorld));t.matrix.decompose(t.position,t.quaternion,t.scale),t.updateMatrixWorld(1),t.projectionMatrix.copy(e.projectionMatrix),t.projectionMatrixInverse.copy(e.projectionMatrixInverse),t.isPerspectiveCamera&&(t.fov=2*ur*Math.atan(1/t.projectionMatrix.elements[5]),t.zoom=1)}(t,w,i)},this.getCamera=function(){return w},this.getFoveation=function(){if(null!==u||null!==d)return o},this.setFoveation=function(t){o=t,null!==u&&(u.fixedFoveation=t),null!==d&&void 0!==d.fixedFoveation&&(d.fixedFoveation=t)},this.hasDepthSensing=function(){return null!==f.texture},this.getDepthSensingMesh=function(){return f.getMesh(w)},this.getCameraTexture=function(t){return m[t]};let N=null;const O=new wl;O.setAnimationLoop(function(e,i){if(c=i.getViewerPose(l||a),p=i,null!==c){const e=c.views;null!==d&&(t.setRenderTargetFramebuffer(x,d.framebuffer),t.setRenderTarget(x));let n=0;e.length!==w.cameras.length&&(w.cameras.length=0,n=1);for(let r=0;r<e.length;r++){const i=e[r];let a=null;if(null!==d)a=d.getViewport(i);else{const e=h.getViewSubImage(u,i);a=e.viewport,0===r&&(t.setRenderTargetTextures(x,e.colorTexture,e.depthStencilTexture),t.setRenderTarget(x))}let s=M[r];void 0===s&&(s=new is,s.layers.enable(r),s.viewport=new Xr,M[r]=s),s.matrix.fromArray(i.transform.matrix),s.matrix.decompose(s.position,s.quaternion,s.scale),s.projectionMatrix.fromArray(i.projectionMatrix),s.projectionMatrixInverse.copy(s.projectionMatrix).invert(),s.viewport.set(a.x,a.y,a.width,a.height),0===r&&(w.matrix.copy(s.matrix),w.matrix.decompose(w.position,w.quaternion,w.scale)),1==n&&w.cameras.push(s)}const i=r.enabledFeatures;if(i&&i.includes("depth-sensing")&&"gpu-optimized"==r.depthUsage&&h){const t=h.getDepthInformation(e[0]);t&&t.isValid&&t.texture&&f.init(t,r.renderState)}if(i&&i.includes("camera-access")&&(t.state.unbindTexture(),h))for(let t=0;t<e.length;t++){const n=e[t].camera;if(n){let t=m[n];t||(t=new nu,m[n]=t);const e=h.getCameraImage(n);t.sourceTexture=e}}}for(let t=0;t<_.length;t++){const e=y[t],n=_[t];null!==e&&void 0!==n&&n.update(e,i,l||a)}N&&N(e,i),i.detectedPlanes&&n.dispatchEvent({type:"planesdetected",data:i}),p=null}),this.setAnimationLoop=function(t){N=t},this.dispose=function(){}}}const au=new Li,su=new Ti;function ou(t,e){function n(t,e){1==t.matrixAutoUpdate&&t.updateMatrix(),e.value.copy(t.matrix)}function r(t,r){t.opacity.value=r.opacity,r.color&&t.diffuse.value.copy(r.color),r.emissive&&t.emissive.value.copy(r.emissive).multiplyScalar(r.emissiveIntensity),r.map&&(t.map.value=r.map,n(r.map,t.mapTransform)),r.alphaMap&&(t.alphaMap.value=r.alphaMap,n(r.alphaMap,t.alphaMapTransform)),r.bumpMap&&(t.bumpMap.value=r.bumpMap,n(r.bumpMap,t.bumpMapTransform),t.bumpScale.value=r.bumpScale,1===r.side&&(t.bumpScale.value*=-1)),r.normalMap&&(t.normalMap.value=r.normalMap,n(r.normalMap,t.normalMapTransform),t.normalScale.value.copy(r.normalScale),1===r.side&&t.normalScale.value.negate()),r.displacementMap&&(t.displacementMap.value=r.displacementMap,n(r.displacementMap,t.displacementMapTransform),t.displacementScale.value=r.displacementScale,t.displacementBias.value=r.displacementBias),r.emissiveMap&&(t.emissiveMap.value=r.emissiveMap,n(r.emissiveMap,t.emissiveMapTransform)),r.specularMap&&(t.specularMap.value=r.specularMap,n(r.specularMap,t.specularMapTransform)),r.alphaTest>0&&(t.alphaTest.value=r.alphaTest);const i=e.get(r),a=i.envMap,s=i.envMapRotation;a&&(t.envMap.value=a,au.copy(s),au.x*=-1,au.y*=-1,au.z*=-1,a.isCubeTexture&&0==a.isRenderTargetTexture&&(au.y*=-1,au.z*=-1),t.envMapRotation.value.setFromMatrix4(su.makeRotationFromEuler(au)),t.flipEnvMap.value=a.isCubeTexture&&0==a.isRenderTargetTexture?-1:1,t.reflectivity.value=r.reflectivity,t.ior.value=r.ior,t.refractionRatio.value=r.refractionRatio),r.lightMap&&(t.lightMap.value=r.lightMap,t.lightMapIntensity.value=r.lightMapIntensity,n(r.lightMap,t.lightMapTransform)),r.aoMap&&(t.aoMap.value=r.aoMap,t.aoMapIntensity.value=r.aoMapIntensity,n(r.aoMap,t.aoMapTransform))}return{refreshFogUniforms:function(e,n){n.color.getRGB(e.fogColor.value,$a(t)),n.isFog?(e.fogNear.value=n.near,e.fogFar.value=n.far):n.isFogExp2&&(e.fogDensity.value=n.density)},refreshMaterialUniforms:function(t,i,a,s,o){i.isMeshBasicMaterial||i.isMeshLambertMaterial?r(t,i):i.isMeshToonMaterial?(r(t,i),function(t,e){e.gradientMap&&(t.gradientMap.value=e.gradientMap)}(t,i)):i.isMeshPhongMaterial?(r(t,i),function(t,e){t.specular.value.copy(e.specular),t.shininess.value=Math.max(e.shininess,1e-4)}(t,i)):i.isMeshStandardMaterial?(r(t,i),function(t,e){t.metalness.value=e.metalness,e.metalnessMap&&(t.metalnessMap.value=e.metalnessMap,n(e.metalnessMap,t.metalnessMapTransform));t.roughness.value=e.roughness,e.roughnessMap&&(t.roughnessMap.value=e.roughnessMap,n(e.roughnessMap,t.roughnessMapTransform));e.envMap&&(t.envMapIntensity.value=e.envMapIntensity)}(t,i),i.isMeshPhysicalMaterial&&function(t,e,r){t.ior.value=e.ior,e.sheen>0&&(t.sheenColor.value.copy(e.sheenColor).multiplyScalar(e.sheen),t.sheenRoughness.value=e.sheenRoughness,e.sheenColorMap&&(t.sheenColorMap.value=e.sheenColorMap,n(e.sheenColorMap,t.sheenColorMapTransform)),e.sheenRoughnessMap&&(t.sheenRoughnessMap.value=e.sheenRoughnessMap,n(e.sheenRoughnessMap,t.sheenRoughnessMapTransform)));e.clearcoat>0&&(t.clearcoat.value=e.clearcoat,t.clearcoatRoughness.value=e.clearcoatRoughness,e.clearcoatMap&&(t.clearcoatMap.value=e.clearcoatMap,n(e.clearcoatMap,t.clearcoatMapTransform)),e.clearcoatRoughnessMap&&(t.clearcoatRoughnessMap.value=e.clearcoatRoughnessMap,n(e.clearcoatRoughnessMap,t.clearcoatRoughnessMapTransform)),e.clearcoatNormalMap&&(t.clearcoatNormalMap.value=e.clearcoatNormalMap,n(e.clearcoatNormalMap,t.clearcoatNormalMapTransform),t.clearcoatNormalScale.value.copy(e.clearcoatNormalScale),1===e.side&&t.clearcoatNormalScale.value.negate()));e.dispersion>0&&(t.dispersion.value=e.dispersion);e.iridescence>0&&(t.iridescence.value=e.iridescence,t.iridescenceIOR.value=e.iridescenceIOR,t.iridescenceThicknessMinimum.value=e.iridescenceThicknessRange[0],t.iridescenceThicknessMaximum.value=e.iridescenceThicknessRange[1],e.iridescenceMap&&(t.iridescenceMap.value=e.iridescenceMap,n(e.iridescenceMap,t.iridescenceMapTransform)),e.iridescenceThicknessMap&&(t.iridescenceThicknessMap.value=e.iridescenceThicknessMap,n(e.iridescenceThicknessMap,t.iridescenceThicknessMapTransform)));e.transmission>0&&(t.transmission.value=e.transmission,t.transmissionSamplerMap.value=r.texture,t.transmissionSamplerSize.value.set(r.width,r.height),e.transmissionMap&&(t.transmissionMap.value=e.transmissionMap,n(e.transmissionMap,t.transmissionMapTransform)),t.thickness.value=e.thickness,e.thicknessMap&&(t.thicknessMap.value=e.thicknessMap,n(e.thicknessMap,t.thicknessMapTransform)),t.attenuationDistance.value=e.attenuationDistance,t.attenuationColor.value.copy(e.attenuationColor));e.anisotropy>0&&(t.anisotropyVector.value.set(e.anisotropy*Math.cos(e.anisotropyRotation),e.anisotropy*Math.sin(e.anisotropyRotation)),e.anisotropyMap&&(t.anisotropyMap.value=e.anisotropyMap,n(e.anisotropyMap,t.anisotropyMapTransform)));t.specularIntensity.value=e.specularIntensity,t.specularColor.value.copy(e.specularColor),e.specularColorMap&&(t.specularColorMap.value=e.specularColorMap,n(e.specularColorMap,t.specularColorMapTransform));e.specularIntensityMap&&(t.specularIntensityMap.value=e.specularIntensityMap,n(e.specularIntensityMap,t.specularIntensityMapTransform))}(t,i,o)):i.isMeshMatcapMaterial?(r(t,i),function(t,e){e.matcap&&(t.matcap.value=e.matcap)}(t,i)):i.isMeshDepthMaterial?r(t,i):i.isMeshDistanceMaterial?(r(t,i),function(t,n){const r=e.get(n).light;t.referencePosition.value.setFromMatrixPosition(r.matrixWorld),t.nearDistance.value=r.shadow.camera.near,t.farDistance.value=r.shadow.camera.far}(t,i)):i.isMeshNormalMaterial?r(t,i):i.isLineBasicMaterial?(function(t,e){t.diffuse.value.copy(e.color),t.opacity.value=e.opacity,e.map&&(t.map.value=e.map,n(e.map,t.mapTransform))}(t,i),i.isLineDashedMaterial&&function(t,e){t.dashSize.value=e.dashSize,t.totalSize.value=e.dashSize+e.gapSize,t.scale.value=e.scale}(t,i)):i.isPointsMaterial?function(t,e,r,i){t.diffuse.value.copy(e.color),t.opacity.value=e.opacity,t.size.value=e.size*r,t.scale.value=.5*i,e.map&&(t.map.value=e.map,n(e.map,t.uvTransform));e.alphaMap&&(t.alphaMap.value=e.alphaMap,n(e.alphaMap,t.alphaMapTransform));e.alphaTest>0&&(t.alphaTest.value=e.alphaTest)}(t,i,a,s):i.isSpriteMaterial?function(t,e){t.diffuse.value.copy(e.color),t.opacity.value=e.opacity,t.rotation.value=e.rotation,e.map&&(t.map.value=e.map,n(e.map,t.mapTransform));e.alphaMap&&(t.alphaMap.value=e.alphaMap,n(e.alphaMap,t.alphaMapTransform));e.alphaTest>0&&(t.alphaTest.value=e.alphaTest)}(t,i):i.isShadowMaterial?(t.color.value.copy(i.color),t.opacity.value=i.opacity):i.isShaderMaterial&&(i.uniformsNeedUpdate=0)}}}function lu(t,e,n,r){let i={},a={},s=[];const o=t.getParameter(t.MAX_UNIFORM_BUFFER_BINDINGS);function l(t,e,n,r){const i=t.value,a=e+"_"+n;if(void 0===r[a])return r[a]="number"==typeof i||"boolean"==typeof i?i:i.clone(),1;{const t=r[a];if("number"==typeof i||"boolean"==typeof i){if(t!==i)return r[a]=i,1}else if(0==t.equals(i))return t.copy(i),1}return 0}function c(t){const e={boundary:0,storage:0};return"number"==typeof t||"boolean"==typeof t?(e.boundary=4,e.storage=4):t.isVector2?(e.boundary=8,e.storage=8):t.isVector3||t.isColor?(e.boundary=16,e.storage=12):t.isVector4?(e.boundary=16,e.storage=16):t.isMatrix3?(e.boundary=48,e.storage=48):t.isMatrix4?(e.boundary=64,e.storage=64):t.isTexture,e}function h(e){const n=e.target;n.removeEventListener("dispose",h);const r=s.indexOf(n.__bindingPointIndex);s.splice(r,1),t.deleteBuffer(i[n.id]),delete i[n.id],delete a[n.id]}return{bind:function(t,e){const n=e.program;r.uniformBlockBinding(t,n)},update:function(n,u){let d=i[n.id];void 0===d&&(!function(t){const e=t.uniforms;let n=0;const r=16;for(let t=0,i=e.length;t<i;t++){const i=Array.isArray(e[t])?e[t]:[e[t]];for(let t=0,e=i.length;t<e;t++){const e=i[t],a=Array.isArray(e.value)?e.value:[e.value];for(let t=0,i=a.length;t<i;t++){const i=c(a[t]),s=n%r,o=s%i.boundary,l=s+o;n+=o,0!==l&&r-l<i.storage&&(n+=r-l),e.__data=new Float32Array(i.storage/Float32Array.BYTES_PER_ELEMENT),e.__offset=n,n+=i.storage}}}const i=n%r;i>0&&(n+=r-i);t.__size=n,t.__cache={}}(n),d=function(e){const n=function(){for(let t=0;t<o;t++)if(-1===s.indexOf(t))return s.push(t),t;return 0}();e.__bindingPointIndex=n;const r=t.createBuffer(),i=e.__size,a=e.usage;return t.bindBuffer(t.UNIFORM_BUFFER,r),t.bufferData(t.UNIFORM_BUFFER,i,a),t.bindBuffer(t.UNIFORM_BUFFER,null),t.bindBufferBase(t.UNIFORM_BUFFER,n,r),r}(n),i[n.id]=d,n.addEventListener("dispose",h));const p=u.program;r.updateUBOMapping(n,p);const f=e.render.frame;a[n.id]!==f&&(!function(e){const n=i[e.id],r=e.uniforms,a=e.__cache;t.bindBuffer(t.UNIFORM_BUFFER,n);for(let e=0,n=r.length;e<n;e++){const n=Array.isArray(r[e])?r[e]:[r[e]];for(let r=0,i=n.length;r<i;r++){const i=n[r];if(1==l(i,e,r,a)){const e=i.__offset,n=Array.isArray(i.value)?i.value:[i.value];let r=0;for(let a=0;a<n.length;a++){const s=n[a],o=c(s);"number"==typeof s||"boolean"==typeof s?(i.__data[0]=s,t.bufferSubData(t.UNIFORM_BUFFER,e+r,i.__data)):s.isMatrix3?(i.__data[0]=s.elements[0],i.__data[1]=s.elements[1],i.__data[2]=s.elements[2],i.__data[3]=0,i.__data[4]=s.elements[3],i.__data[5]=s.elements[4],i.__data[6]=s.elements[5],i.__data[7]=0,i.__data[8]=s.elements[6],i.__data[9]=s.elements[7],i.__data[10]=s.elements[8],i.__data[11]=0):(s.toArray(i.__data,r),r+=o.storage/Float32Array.BYTES_PER_ELEMENT)}t.bufferSubData(t.UNIFORM_BUFFER,e,i.__data)}}}t.bindBuffer(t.UNIFORM_BUFFER,null)}(n),a[n.id]=f)},dispose:function(){for(const e in i)t.deleteBuffer(i[e]);s=[],i={},a={}}}}class cu{constructor(t={}){const{canvas:e=Ar(),context:n=null,depth:r=1,stencil:i=0,alpha:a=0,antialias:s=0,premultipliedAlpha:o=1,preserveDrawingBuffer:l=0,powerPreference:c="default",failIfMajorPerformanceCaveat:h=0,reversedDepthBuffer:u=0}=t;let d;if(this.isWebGLRenderer=1,null!==n){if("undefined"!=typeof WebGLRenderingContext&&n instanceof WebGLRenderingContext)throw new Error("THREE.WebGLRenderer: WebGL 1 is not supported since r163.");d=n.getContextAttributes().alpha}else d=a;const p=new Uint32Array(4),f=new Int32Array(4);let m=null,g=null;const v=[],x=[];this.domElement=e,this.debug={checkShaderErrors:1,onShaderError:null},this.autoClear=1,this.autoClearColor=1,this.autoClearDepth=1,this.autoClearStencil=1,this.sortObjects=1,this.clippingPlanes=[],this.localClippingEnabled=0,this.toneMapping=0,this.toneMappingExposure=1,this.transmissionResolutionScale=1;const _=this;let y=0;this._outputColorSpace=Wn;let b=0,E=0,T=null,S=-1,M=null;const w=new Xr,R=new Xr;let A=null;const C=new ma(0);let P=0,D=e.width,U=e.height,L=1,I=null,N=null;const O=new Xr(0,0,D,U),F=new Xr(0,0,D,U);let B=0;const k=new qs;let z=0,V=0;const H=new Ti,G=new br,W=new Xr,X={background:null,fog:null,environment:null,overrideMaterial:null,isScene:1};let j=0;function q(){return null===T?L:1}let Y,K,Z,$,J,Q,tt,et,nt,rt,it,at,st,ot,lt,ct,ht,ut,dt,pt,ft,mt,gt,vt,xt=n;function _t(t,n){return e.getContext(t,n)}try{const t={alpha:1,depth:r,stencil:i,antialias:s,premultipliedAlpha:o,preserveDrawingBuffer:l,powerPreference:c,failIfMajorPerformanceCaveat:h};if("setAttribute"in e&&e.setAttribute("data-engine",`three.js r${Kt}`),e.addEventListener("webglcontextlost",Et,0),e.addEventListener("webglcontextrestored",Tt,0),e.addEventListener("webglcontextcreationerror",St,0),null===xt){const e="webgl2";if(xt=_t(e,t),null===xt)throw _t(e)?new Error("Error creating WebGL context with your selected attributes."):new Error("Error creating WebGL context.")}}catch(t){throw t}function yt(){Y=new ac(xt),Y.init(),mt=new eu(xt,Y),K=new Fl(xt,Y,t,mt),Z=new Qh(xt,Y),K.reversedDepthBuffer&&u&&Z.buffers.depth.setReversed(1),$=new lc(xt),J=new zh,Q=new tu(xt,Y,Z,J,K,mt,$),tt=new kl(_),et=new ic(_),nt=new Rl(xt),gt=new Nl(xt,nt),rt=new sc(xt,nt,$,gt),it=new hc(xt,rt,nt,$),dt=new cc(xt,K,Q),ct=new Bl(J),at=new kh(_,tt,et,Y,K,gt,ct),st=new ou(_,J),ot=new Wh,lt=new Zh(Y),ut=new Il(_,tt,et,Z,it,d,o),ht=new $h(_,it,K),vt=new lu(xt,$,K,Z),pt=new Ol(xt,Y,$),ft=new oc(xt,Y,$),$.programs=at.programs,_.capabilities=K,_.extensions=Y,_.properties=J,_.renderLists=ot,_.shadowMap=ht,_.state=Z,_.info=$}yt();const bt=new iu(_,xt);function Et(t){t.preventDefault(),y=1}function Tt(){y=0;const t=$.autoReset,e=ht.enabled,n=ht.autoUpdate,r=ht.needsUpdate,i=ht.type;yt(),$.autoReset=t,ht.enabled=e,ht.autoUpdate=n,ht.needsUpdate=r,ht.type=i}function St(t){}function Mt(t){const e=t.target;e.removeEventListener("dispose",Mt),function(t){(function(t){const e=J.get(t).programs;void 0!==e&&(e.forEach(function(t){at.releaseProgram(t)}),t.isShaderMaterial&&at.releaseShaderCache(t))})(t),J.remove(t)}(e)}function wt(t,e,n){1==t.transparent&&2===t.side&&0==t.forceSinglePass?(t.side=1,t.needsUpdate=1,Ot(t,e,n),t.side=0,t.needsUpdate=1,Ot(t,e,n),t.side=2):Ot(t,e,n)}this.xr=bt,this.getContext=function(){return xt},this.getContextAttributes=function(){return xt.getContextAttributes()},this.forceContextLoss=function(){const t=Y.get("WEBGL_lose_context");t&&t.loseContext()},this.forceContextRestore=function(){const t=Y.get("WEBGL_lose_context");t&&t.restoreContext()},this.getPixelRatio=function(){return L},this.setPixelRatio=function(t){void 0!==t&&(L=t,this.setSize(D,U,0))},this.getSize=function(t){return t.set(D,U)},this.setSize=function(t,n,r=1){bt.isPresenting||(D=t,U=n,e.width=Math.floor(t*L),e.height=Math.floor(n*L),1==r&&(e.style.width=t+"px",e.style.height=n+"px"),this.setViewport(0,0,t,n))},this.getDrawingBufferSize=function(t){return t.set(D*L,U*L).floor()},this.setDrawingBufferSize=function(t,n,r){D=t,U=n,L=r,e.width=Math.floor(t*r),e.height=Math.floor(n*r),this.setViewport(0,0,t,n)},this.getCurrentViewport=function(t){return t.copy(w)},this.getViewport=function(t){return t.copy(O)},this.setViewport=function(t,e,n,r){t.isVector4?O.set(t.x,t.y,t.z,t.w):O.set(t,e,n,r),Z.viewport(w.copy(O).multiplyScalar(L).round())},this.getScissor=function(t){return t.copy(F)},this.setScissor=function(t,e,n,r){t.isVector4?F.set(t.x,t.y,t.z,t.w):F.set(t,e,n,r),Z.scissor(R.copy(F).multiplyScalar(L).round())},this.getScissorTest=function(){return B},this.setScissorTest=function(t){Z.setScissorTest(B=t)},this.setOpaqueSort=function(t){I=t},this.setTransparentSort=function(t){N=t},this.getClearColor=function(t){return t.copy(ut.getClearColor())},this.setClearColor=function(){ut.setClearColor(...arguments)},this.getClearAlpha=function(){return ut.getClearAlpha()},this.setClearAlpha=function(){ut.setClearAlpha(...arguments)},this.clear=function(t=1,e=1,n=1){let r=0;if(t){let t=0;if(null!==T){const e=T.texture.format;t=e===an||e===rn||e===nn}if(t){const t=T.texture.type,e=t===ze||t===Xe||t===Ge||t===Ze||t===Ye||t===Ke,n=ut.getClearColor(),r=ut.getClearAlpha(),i=n.r,a=n.g,s=n.b;e?(p[0]=i,p[1]=a,p[2]=s,p[3]=r,xt.clearBufferuiv(xt.COLOR,0,p)):(f[0]=i,f[1]=a,f[2]=s,f[3]=r,xt.clearBufferiv(xt.COLOR,0,f))}else r|=xt.COLOR_BUFFER_BIT}e&&(r|=xt.DEPTH_BUFFER_BIT),n&&(r|=xt.STENCIL_BUFFER_BIT,this.state.buffers.stencil.setMask(4294967295)),xt.clear(r)},this.clearColor=function(){this.clear(1,0,0)},this.clearDepth=function(){this.clear(0,1,0)},this.clearStencil=function(){this.clear(0,0,1)},this.dispose=function(){e.removeEventListener("webglcontextlost",Et,0),e.removeEventListener("webglcontextrestored",Tt,0),e.removeEventListener("webglcontextcreationerror",St,0),ut.dispose(),ot.dispose(),lt.dispose(),J.dispose(),tt.dispose(),et.dispose(),it.dispose(),gt.dispose(),vt.dispose(),at.dispose(),bt.dispose(),bt.removeEventListener("sessionstart",At),bt.removeEventListener("sessionend",Ct),Pt.stop()},this.renderBufferDirect=function(t,e,n,r,i,a){null===e&&(e=X);const s=i.isMesh&&i.matrixWorld.determinant()<0,o=function(t,e,n,r,i){1!=e.isScene&&(e=X);Q.resetTextureUnits();const a=e.fog,s=r.isMeshStandardMaterial?e.environment:null,o=null===T?_.outputColorSpace:1==T.isXRRenderTarget?T.texture.colorSpace:Xn,l=(r.isMeshStandardMaterial?et:tt).get(r.envMap||s),c=1==r.vertexColors&&!!n.attributes.color&&4===n.attributes.color.itemSize,h=!!n.attributes.tangent&&(!!r.normalMap||r.anisotropy>0),u=!!n.morphAttributes.position,d=!!n.morphAttributes.normal,p=!!n.morphAttributes.color;let f=0;r.toneMapped&&(null!==T&&1!=T.isXRRenderTarget||(f=_.toneMapping));const m=n.morphAttributes.position||n.morphAttributes.normal||n.morphAttributes.color,v=void 0!==m?m.length:0,x=J.get(r),y=g.state.lights;if(1==z&&(1==V||t!==M)){const e=t===M&&r.id===S;ct.setState(r,t,e)}let b=0;r.version===x.__version?x.needsLights&&x.lightsStateVersion!==y.state.version||x.outputColorSpace!==o||i.isBatchedMesh&&0==x.batching?b=1:i.isBatchedMesh||1!=x.batching?i.isBatchedMesh&&1==x.batchingColor&&null===i.colorTexture||i.isBatchedMesh&&0==x.batchingColor&&null!==i.colorTexture||i.isInstancedMesh&&0==x.instancing?b=1:i.isInstancedMesh||1!=x.instancing?i.isSkinnedMesh&&0==x.skinning?b=1:i.isSkinnedMesh||1!=x.skinning?i.isInstancedMesh&&1==x.instancingColor&&null===i.instanceColor||i.isInstancedMesh&&0==x.instancingColor&&null!==i.instanceColor||i.isInstancedMesh&&1==x.instancingMorph&&null===i.morphTexture||i.isInstancedMesh&&0==x.instancingMorph&&null!==i.morphTexture||x.envMap!==l||1==r.fog&&x.fog!==a?b=1:void 0===x.numClippingPlanes||x.numClippingPlanes===ct.numPlanes&&x.numIntersection===ct.numIntersection?(x.vertexAlphas!==c||x.vertexTangents!==h||x.morphTargets!==u||x.morphNormals!==d||x.morphColors!==p||x.toneMapping!==f||x.morphTargetsCount!==v)&&(b=1):b=1:b=1:b=1:b=1:(b=1,x.__version=r.version);let E=x.currentProgram;1==b&&(E=Ot(r,e,i));let w=0,R=0,A=0;const C=E.getUniforms(),P=x.uniforms;Z.useProgram(E.program)&&(w=1,R=1,A=1);r.id!==S&&(S=r.id,R=1);if(w||M!==t){Z.buffers.depth.getReversed()&&1!=t.reversedDepth&&(t._reversedDepth=1,t.updateProjectionMatrix()),C.setValue(xt,"projectionMatrix",t.projectionMatrix),C.setValue(xt,"viewMatrix",t.matrixWorldInverse);const e=C.map.cameraPosition;void 0!==e&&e.setValue(xt,G.setFromMatrixPosition(t.matrixWorld)),K.logarithmicDepthBuffer&&C.setValue(xt,"logDepthBufFC",2/(Math.log(t.far+1)/Math.LN2)),(r.isMeshPhongMaterial||r.isMeshToonMaterial||r.isMeshLambertMaterial||r.isMeshBasicMaterial||r.isMeshStandardMaterial||r.isShaderMaterial)&&C.setValue(xt,"isOrthographic",1==t.isOrthographicCamera),M!==t&&(M=t,R=1,A=1)}if(i.isSkinnedMesh){C.setOptional(xt,i,"bindMatrix"),C.setOptional(xt,i,"bindMatrixInverse");const t=i.skeleton;t&&(null===t.boneTexture&&t.computeBoneTexture(),C.setValue(xt,"boneTexture",t.boneTexture,Q))}i.isBatchedMesh&&(C.setOptional(xt,i,"batchingTexture"),C.setValue(xt,"batchingTexture",i._matricesTexture,Q),C.setOptional(xt,i,"batchingIdTexture"),C.setValue(xt,"batchingIdTexture",i._indirectTexture,Q),C.setOptional(xt,i,"batchingColorTexture"),null!==i._colorsTexture&&C.setValue(xt,"batchingColorTexture",i._colorsTexture,Q));const D=n.morphAttributes;void 0===D.position&&void 0===D.normal&&void 0===D.color||dt.update(i,n,E);(R||x.receiveShadow!==i.receiveShadow)&&(x.receiveShadow=i.receiveShadow,C.setValue(xt,"receiveShadow",i.receiveShadow));r.isMeshGouraudMaterial&&null!==r.envMap&&(P.envMap.value=l,P.flipEnvMap.value=l.isCubeTexture&&0==l.isRenderTargetTexture?-1:1);r.isMeshStandardMaterial&&null===r.envMap&&null!==e.environment&&(P.envMapIntensity.value=e.environmentIntensity);R&&(C.setValue(xt,"toneMappingExposure",_.toneMappingExposure),x.needsLights&&(N=A,(I=P).ambientLightColor.needsUpdate=N,I.lightProbe.needsUpdate=N,I.directionalLights.needsUpdate=N,I.directionalLightShadows.needsUpdate=N,I.pointLights.needsUpdate=N,I.pointLightShadows.needsUpdate=N,I.spotLights.needsUpdate=N,I.spotLightShadows.needsUpdate=N,I.rectAreaLights.needsUpdate=N,I.hemisphereLights.needsUpdate=N),a&&1==r.fog&&st.refreshFogUniforms(P,a),st.refreshMaterialUniforms(P,r,L,U,g.state.transmissionRenderTarget[t.id]),mh.upload(xt,Ft(x),P,Q));var I,N;r.isShaderMaterial&&1==r.uniformsNeedUpdate&&(mh.upload(xt,Ft(x),P,Q),r.uniformsNeedUpdate=0);r.isSpriteMaterial&&C.setValue(xt,"center",i.center);if(C.setValue(xt,"modelViewMatrix",i.modelViewMatrix),C.setValue(xt,"normalMatrix",i.normalMatrix),C.setValue(xt,"modelMatrix",i.matrixWorld),r.isShaderMaterial||r.isRawShaderMaterial){const t=r.uniformsGroups;for(let e=0,n=t.length;e<n;e++){const n=t[e];vt.update(n,E),vt.bind(n,E)}}return E}(t,e,n,r,i);Z.setMaterial(r,s);let l=n.index,c=1;if(1==r.wireframe){if(l=rt.getWireframeAttribute(n),void 0===l)return;c=2}const h=n.drawRange,u=n.attributes.position;let d=h.start*c,p=(h.start+h.count)*c;null!==a&&(d=Math.max(d,a.start*c),p=Math.min(p,(a.start+a.count)*c)),null!==l?(d=Math.max(d,0),p=Math.min(p,l.count)):null!=u&&(d=Math.max(d,0),p=Math.min(p,u.count));const f=p-d;if(f<0||f===1/0)return;let m;gt.setup(i,r,o,n,l);let v=pt;if(null!==l&&(m=nt.get(l),v=ft,v.setIndex(m)),i.isMesh)1==r.wireframe?(Z.setLineWidth(r.wireframeLinewidth*q()),v.setMode(xt.LINES)):v.setMode(xt.TRIANGLES);else if(i.isLine){let t=r.linewidth;void 0===t&&(t=1),Z.setLineWidth(t*q()),i.isLineSegments?v.setMode(xt.LINES):i.isLineLoop?v.setMode(xt.LINE_LOOP):v.setMode(xt.LINE_STRIP)}else i.isPoints?v.setMode(xt.POINTS):i.isSprite&&v.setMode(xt.TRIANGLES);if(i.isBatchedMesh)if(null!==i._multiDrawInstances)Pr("THREE.WebGLRenderer: renderMultiDrawInstances has been deprecated and will be removed in r184. Append to renderMultiDraw arguments and use indirection."),v.renderMultiDrawInstances(i._multiDrawStarts,i._multiDrawCounts,i._multiDrawCount,i._multiDrawInstances);else if(Y.get("WEBGL_multi_draw"))v.renderMultiDraw(i._multiDrawStarts,i._multiDrawCounts,i._multiDrawCount);else{const t=i._multiDrawStarts,e=i._multiDrawCounts,n=i._multiDrawCount,a=l?nt.get(l).bytesPerElement:1,s=J.get(r).currentProgram.getUniforms();for(let r=0;r<n;r++)s.setValue(xt,"_gl_DrawID",r),v.render(t[r]/a,e[r])}else if(i.isInstancedMesh)v.renderInstances(d,f,i.count);else if(n.isInstancedBufferGeometry){const t=void 0!==n._maxInstanceCount?n._maxInstanceCount:1/0,e=Math.min(n.instanceCount,t);v.renderInstances(d,f,e)}else v.render(d,f)},this.compile=function(t,e,n=null){null===n&&(n=t),g=lt.get(n),g.init(e),x.push(g),n.traverseVisible(function(t){t.isLight&&t.layers.test(e.layers)&&(g.pushLight(t),t.castShadow&&g.pushShadow(t))}),t!==n&&t.traverseVisible(function(t){t.isLight&&t.layers.test(e.layers)&&(g.pushLight(t),t.castShadow&&g.pushShadow(t))}),g.setupLights();const r=new Set;return t.traverse(function(t){if(!(t.isMesh||t.isPoints||t.isLine||t.isSprite))return;const e=t.material;if(e)if(Array.isArray(e))for(let i=0;i<e.length;i++){const a=e[i];wt(a,n,t),r.add(a)}else wt(e,n,t),r.add(e)}),g=x.pop(),r},this.compileAsync=function(t,e,n=null){const r=this.compile(t,e,n);return new Promise(e=>{function n(){r.forEach(function(t){J.get(t).currentProgram.isReady()&&r.delete(t)}),0!==r.size?setTimeout(n,10):e(t)}null!==Y.get("KHR_parallel_shader_compile")?n():setTimeout(n,10)})};let Rt=null;function At(){Pt.stop()}function Ct(){Pt.start()}const Pt=new wl;function Dt(t,e,n,r){if(0==t.visible)return;if(t.layers.test(e.layers))if(t.isGroup)n=t.renderOrder;else if(t.isLOD)1==t.autoUpdate&&t.update(e);else if(t.isLight)g.pushLight(t),t.castShadow&&g.pushShadow(t);else if(t.isSprite){if(!t.frustumCulled||k.intersectsSprite(t)){r&&W.setFromMatrixPosition(t.matrixWorld).applyMatrix4(H);const e=it.update(t),i=t.material;i.visible&&m.push(t,e,i,n,W.z,null)}}else if((t.isMesh||t.isLine||t.isPoints)&&(!t.frustumCulled||k.intersectsObject(t))){const e=it.update(t),i=t.material;if(r&&(void 0!==t.boundingSphere?(null===t.boundingSphere&&t.computeBoundingSphere(),W.copy(t.boundingSphere.center)):(null===e.boundingSphere&&e.computeBoundingSphere(),W.copy(e.boundingSphere.center)),W.applyMatrix4(t.matrixWorld).applyMatrix4(H)),Array.isArray(i)){const r=e.groups;for(let a=0,s=r.length;a<s;a++){const s=r[a],o=i[s.materialIndex];o&&o.visible&&m.push(t,e,o,n,W.z,s)}}else i.visible&&m.push(t,e,i,n,W.z,null)}const i=t.children;for(let t=0,a=i.length;t<a;t++)Dt(i[t],e,n,r)}function Ut(t,e,n,r){const i=t.opaque,a=t.transmissive,s=t.transparent;g.setupLightsView(n),1==z&&ct.setGlobalState(_.clippingPlanes,n),r&&Z.viewport(w.copy(r)),i.length>0&&It(i,e,n),a.length>0&&It(a,e,n),s.length>0&&It(s,e,n),Z.buffers.depth.setTest(1),Z.buffers.depth.setMask(1),Z.buffers.color.setMask(1),Z.setPolygonOffset(0)}function Lt(t,e,n,r){if(null!==(1==n.isScene?n.overrideMaterial:null))return;void 0===g.state.transmissionRenderTarget[r.id]&&(g.state.transmissionRenderTarget[r.id]=new qr(1,1,{generateMipmaps:1,type:Y.has("EXT_color_buffer_half_float")||Y.has("EXT_color_buffer_float")?qe:ze,minFilter:ke,samples:4,stencilBuffer:i,resolveDepthBuffer:0,resolveStencilBuffer:0,colorSpace:Ir.workingColorSpace}));const a=g.state.transmissionRenderTarget[r.id],s=r.viewport||w;a.setSize(s.z*_.transmissionResolutionScale,s.w*_.transmissionResolutionScale);const o=_.getRenderTarget(),l=_.getActiveCubeFace(),c=_.getActiveMipmapLevel();_.setRenderTarget(a),_.getClearColor(C),P=_.getClearAlpha(),P<1&&_.setClearColor(16777215,.5),_.clear(),j&&ut.render(n);const h=_.toneMapping;_.toneMapping=0;const u=r.viewport;if(void 0!==r.viewport&&(r.viewport=void 0),g.setupLightsView(r),1==z&&ct.setGlobalState(_.clippingPlanes,r),It(t,n,r),Q.updateMultisampleRenderTarget(a),Q.updateRenderTargetMipmap(a),0==Y.has("WEBGL_multisampled_render_to_texture")){let t=0;for(let i=0,a=e.length;i<a;i++){const a=e[i],s=a.object,o=a.geometry,l=a.material,c=a.group;if(2===l.side&&s.layers.test(r.layers)){const e=l.side;l.side=1,l.needsUpdate=1,Nt(s,n,r,o,l,c),l.side=e,l.needsUpdate=1,t=1}}1==t&&(Q.updateMultisampleRenderTarget(a),Q.updateRenderTargetMipmap(a))}_.setRenderTarget(o,l,c),_.setClearColor(C,P),void 0!==u&&(r.viewport=u),_.toneMapping=h}function It(t,e,n){const r=1==e.isScene?e.overrideMaterial:null;for(let i=0,a=t.length;i<a;i++){const a=t[i],s=a.object,o=a.geometry,l=a.group;let c=a.material;1==c.allowOverride&&null!==r&&(c=r),s.layers.test(n.layers)&&Nt(s,e,n,o,c,l)}}function Nt(t,e,n,r,i,a){t.onBeforeRender(_,e,n,r,i,a),t.modelViewMatrix.multiplyMatrices(n.matrixWorldInverse,t.matrixWorld),t.normalMatrix.getNormalMatrix(t.modelViewMatrix),i.onBeforeRender(_,e,n,r,t,a),1==i.transparent&&2===i.side&&0==i.forceSinglePass?(i.side=1,i.needsUpdate=1,_.renderBufferDirect(n,e,r,i,t,a),i.side=0,i.needsUpdate=1,_.renderBufferDirect(n,e,r,i,t,a),i.side=2):_.renderBufferDirect(n,e,r,i,t,a),t.onAfterRender(_,e,n,r,i,a)}function Ot(t,e,n){1!=e.isScene&&(e=X);const r=J.get(t),i=g.state.lights,a=g.state.shadowsArray,s=i.state.version,o=at.getParameters(t,i.state,a,e,n),l=at.getProgramCacheKey(o);let c=r.programs;r.environment=t.isMeshStandardMaterial?e.environment:null,r.fog=e.fog,r.envMap=(t.isMeshStandardMaterial?et:tt).get(t.envMap||r.environment),r.envMapRotation=null!==r.environment&&null===t.envMap?e.environmentRotation:t.envMapRotation,void 0===c&&(t.addEventListener("dispose",Mt),c=new Map,r.programs=c);let h=c.get(l);if(void 0!==h){if(r.currentProgram===h&&r.lightsStateVersion===s)return Bt(t,o),h}else o.uniforms=at.getUniforms(t),t.onBeforeCompile(o,_),h=at.acquireProgram(o,l),c.set(l,h),r.uniforms=o.uniforms;const u=r.uniforms;return(t.isShaderMaterial||t.isRawShaderMaterial)&&1!=t.clipping||(u.clippingPlanes=ct.uniform),Bt(t,o),r.needsLights=function(t){return t.isMeshLambertMaterial||t.isMeshToonMaterial||t.isMeshPhongMaterial||t.isMeshStandardMaterial||t.isShadowMaterial||t.isShaderMaterial&&1==t.lights}(t),r.lightsStateVersion=s,r.needsLights&&(u.ambientLightColor.value=i.state.ambient,u.lightProbe.value=i.state.probe,u.directionalLights.value=i.state.directional,u.directionalLightShadows.value=i.state.directionalShadow,u.spotLights.value=i.state.spot,u.spotLightShadows.value=i.state.spotShadow,u.rectAreaLights.value=i.state.rectArea,u.ltc_1.value=i.state.rectAreaLTC1,u.ltc_2.value=i.state.rectAreaLTC2,u.pointLights.value=i.state.point,u.pointLightShadows.value=i.state.pointShadow,u.hemisphereLights.value=i.state.hemi,u.directionalShadowMap.value=i.state.directionalShadowMap,u.directionalShadowMatrix.value=i.state.directionalShadowMatrix,u.spotShadowMap.value=i.state.spotShadowMap,u.spotLightMatrix.value=i.state.spotLightMatrix,u.spotLightMap.value=i.state.spotLightMap,u.pointShadowMap.value=i.state.pointShadowMap,u.pointShadowMatrix.value=i.state.pointShadowMatrix),r.currentProgram=h,r.uniformsList=null,h}function Ft(t){if(null===t.uniformsList){const e=t.currentProgram.getUniforms();t.uniformsList=mh.seqWithValue(e.seq,t.uniforms)}return t.uniformsList}function Bt(t,e){const n=J.get(t);n.outputColorSpace=e.outputColorSpace,n.batching=e.batching,n.batchingColor=e.batchingColor,n.instancing=e.instancing,n.instancingColor=e.instancingColor,n.instancingMorph=e.instancingMorph,n.skinning=e.skinning,n.morphTargets=e.morphTargets,n.morphNormals=e.morphNormals,n.morphColors=e.morphColors,n.morphTargetsCount=e.morphTargetsCount,n.numClippingPlanes=e.numClippingPlanes,n.numIntersection=e.numClipIntersection,n.vertexAlphas=e.vertexAlphas,n.vertexTangents=e.vertexTangents,n.toneMapping=e.toneMapping}Pt.setAnimationLoop(function(t){Rt&&Rt(t)}),"undefined"!=typeof self&&Pt.setContext(self),this.setAnimationLoop=function(t){Rt=t,bt.setAnimationLoop(t),null===t?Pt.stop():Pt.start()},bt.addEventListener("sessionstart",At),bt.addEventListener("sessionend",Ct),this.render=function(t,e){if(void 0!==e&&1!=e.isCamera)return;if(1==y)return;if(1==t.matrixWorldAutoUpdate&&t.updateMatrixWorld(),null===e.parent&&1==e.matrixWorldAutoUpdate&&e.updateMatrixWorld(),1==bt.enabled&&1==bt.isPresenting&&(1==bt.cameraAutoUpdate&&bt.updateCamera(e),e=bt.getCamera()),1==t.isScene&&t.onBeforeRender(_,t,e,T),g=lt.get(t,x.length),g.init(e),x.push(g),H.multiplyMatrices(e.projectionMatrix,e.matrixWorldInverse),k.setFromProjectionMatrix(H,ar,e.reversedDepth),V=this.localClippingEnabled,z=ct.init(this.clippingPlanes,V),m=ot.get(t,v.length),m.init(),v.push(m),1==bt.enabled&&1==bt.isPresenting){const t=_.xr.getDepthSensingMesh();null!==t&&Dt(t,e,-1/0,_.sortObjects)}Dt(t,e,0,_.sortObjects),m.finish(),1==_.sortObjects&&m.sort(I,N),j=0==bt.enabled||0==bt.isPresenting||0==bt.hasDepthSensing(),j&&ut.addToRenderList(m,t),this.info.render.frame++,1==z&&ct.beginShadows();const n=g.state.shadowsArray;ht.render(n,t,e),1==z&&ct.endShadows(),1==this.info.autoReset&&this.info.reset();const r=m.opaque,i=m.transmissive;if(g.setupLights(),e.isArrayCamera){const n=e.cameras;if(i.length>0)for(let e=0,a=n.length;e<a;e++){Lt(r,i,t,n[e])}j&&ut.render(t);for(let e=0,r=n.length;e<r;e++){const r=n[e];Ut(m,t,r,r.viewport)}}else i.length>0&&Lt(r,i,t,e),j&&ut.render(t),Ut(m,t,e);null!==T&&0===E&&(Q.updateMultisampleRenderTarget(T),Q.updateRenderTargetMipmap(T)),1==t.isScene&&t.onAfterRender(_,t,e),gt.resetDefaultState(),S=-1,M=null,x.pop(),x.length>0?(g=x[x.length-1],1==z&&ct.setGlobalState(_.clippingPlanes,g.state.camera)):g=null,v.pop(),m=v.length>0?v[v.length-1]:null},this.getActiveCubeFace=function(){return b},this.getActiveMipmapLevel=function(){return E},this.getRenderTarget=function(){return T},this.setRenderTargetTextures=function(t,e,n){const r=J.get(t);r.__autoAllocateDepthBuffer=0==t.resolveDepthBuffer,0==r.__autoAllocateDepthBuffer&&(r.__useRenderToTexture=0),J.get(t.texture).__webglTexture=e,J.get(t.depthTexture).__webglTexture=r.__autoAllocateDepthBuffer?void 0:n,r.__hasExternalTextures=1},this.setRenderTargetFramebuffer=function(t,e){const n=J.get(t);n.__webglFramebuffer=e,n.__useDefaultFramebuffer=void 0===e};const kt=xt.createFramebuffer();this.setRenderTarget=function(t,e=0,n=0){T=t,b=e,E=n;let r=1,i=null,a=0,s=0;if(t){const o=J.get(t);if(void 0!==o.__useDefaultFramebuffer)Z.bindFramebuffer(xt.FRAMEBUFFER,null),r=0;else if(void 0===o.__webglFramebuffer)Q.setupRenderTarget(t);else if(o.__hasExternalTextures)Q.rebindTextures(t,J.get(t.texture).__webglTexture,J.get(t.depthTexture).__webglTexture);else if(t.depthBuffer){const e=t.depthTexture;if(o.__boundDepthTexture!==e){if(null!==e&&J.has(e)&&(t.width!==e.image.width||t.height!==e.image.height))throw new Error("WebGLRenderTarget: Attached DepthTexture is initialized to the incorrect size.");Q.setupDepthRenderbuffer(t)}}const l=t.texture;(l.isData3DTexture||l.isDataArrayTexture||l.isCompressedArrayTexture)&&(s=1);const c=J.get(t).__webglFramebuffer;t.isWebGLCubeRenderTarget?(i=Array.isArray(c[e])?c[e][n]:c[e],a=1):i=t.samples>0&&0==Q.useMultisampledRTT(t)?J.get(t).__webglMultisampledFramebuffer:Array.isArray(c)?c[n]:c,w.copy(t.viewport),R.copy(t.scissor),A=t.scissorTest}else w.copy(O).multiplyScalar(L).floor(),R.copy(F).multiplyScalar(L).floor(),A=B;0!==n&&(i=kt);if(Z.bindFramebuffer(xt.FRAMEBUFFER,i)&&r&&Z.drawBuffers(t,i),Z.viewport(w),Z.scissor(R),Z.setScissorTest(A),a){const r=J.get(t.texture);xt.framebufferTexture2D(xt.FRAMEBUFFER,xt.COLOR_ATTACHMENT0,xt.TEXTURE_CUBE_MAP_POSITIVE_X+e,r.__webglTexture,n)}else if(s){const r=e;for(let e=0;e<t.textures.length;e++){const i=J.get(t.textures[e]);xt.framebufferTextureLayer(xt.FRAMEBUFFER,xt.COLOR_ATTACHMENT0+e,i.__webglTexture,n,r)}}else if(null!==t&&0!==n){const e=J.get(t.texture);xt.framebufferTexture2D(xt.FRAMEBUFFER,xt.COLOR_ATTACHMENT0,xt.TEXTURE_2D,e.__webglTexture,n)}S=-1},this.readRenderTargetPixels=function(t,e,n,r,i,a,s,o=0){if(!t||!t.isWebGLRenderTarget)return;let l=J.get(t).__webglFramebuffer;if(t.isWebGLCubeRenderTarget&&void 0!==s&&(l=l[s]),l){Z.bindFramebuffer(xt.FRAMEBUFFER,l);try{const s=t.textures[o],l=s.format,c=s.type;if(!K.textureFormatReadable(l))return;if(!K.textureTypeReadable(c))return;e>=0&&e<=t.width-r&&n>=0&&n<=t.height-i&&(t.textures.length>1&&xt.readBuffer(xt.COLOR_ATTACHMENT0+o),xt.readPixels(e,n,r,i,mt.convert(l),mt.convert(c),a))}finally{const t=null!==T?J.get(T).__webglFramebuffer:null;Z.bindFramebuffer(xt.FRAMEBUFFER,t)}}},this.readRenderTargetPixelsAsync=async function(t,e,n,r,i,a,s,o=0){if(!t||!t.isWebGLRenderTarget)throw new Error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.");let l=J.get(t).__webglFramebuffer;if(t.isWebGLCubeRenderTarget&&void 0!==s&&(l=l[s]),l){if(e>=0&&e<=t.width-r&&n>=0&&n<=t.height-i){Z.bindFramebuffer(xt.FRAMEBUFFER,l);const s=t.textures[o],c=s.format,h=s.type;if(!K.textureFormatReadable(c))throw new Error("THREE.WebGLRenderer.readRenderTargetPixelsAsync: renderTarget is not in RGBA or implementation defined format.");if(!K.textureTypeReadable(h))throw new Error("THREE.WebGLRenderer.readRenderTargetPixelsAsync: renderTarget is not in UnsignedByteType or implementation defined type.");const u=xt.createBuffer();xt.bindBuffer(xt.PIXEL_PACK_BUFFER,u),xt.bufferData(xt.PIXEL_PACK_BUFFER,a.byteLength,xt.STREAM_READ),t.textures.length>1&&xt.readBuffer(xt.COLOR_ATTACHMENT0+o),xt.readPixels(e,n,r,i,mt.convert(c),mt.convert(h),0);const d=null!==T?J.get(T).__webglFramebuffer:null;Z.bindFramebuffer(xt.FRAMEBUFFER,d);const p=xt.fenceSync(xt.SYNC_GPU_COMMANDS_COMPLETE,0);return xt.flush(),await function(t,e,n){return new Promise(function(r,i){setTimeout(function a(){switch(t.clientWaitSync(e,t.SYNC_FLUSH_COMMANDS_BIT,0)){case t.WAIT_FAILED:i();break;case t.TIMEOUT_EXPIRED:setTimeout(a,n);break;default:r()}},n)})}(xt,p,4),xt.bindBuffer(xt.PIXEL_PACK_BUFFER,u),xt.getBufferSubData(xt.PIXEL_PACK_BUFFER,0,a),xt.deleteBuffer(u),xt.deleteSync(p),a}throw new Error("THREE.WebGLRenderer.readRenderTargetPixelsAsync: requested read bounds are out of range.")}},this.copyFramebufferToTexture=function(t,e=null,n=0){const r=Math.pow(2,-n),i=Math.floor(t.image.width*r),a=Math.floor(t.image.height*r),s=null!==e?e.x:0,o=null!==e?e.y:0;Q.setTexture2D(t,0),xt.copyTexSubImage2D(xt.TEXTURE_2D,n,0,0,s,o,i,a),Z.unbindTexture()};const zt=xt.createFramebuffer(),Vt=xt.createFramebuffer();this.copyTextureToTexture=function(t,e,n=null,r=null,i=0,a=null){let s,o,l,c,h,u,d,p,f;null===a&&(0!==i?(Pr("WebGLRenderer: copyTextureToTexture function signature has changed to support src and dst mipmap levels."),a=i,i=0):a=0);const m=t.isCompressedTexture?t.mipmaps[a]:t.image;if(null!==n)s=n.max.x-n.min.x,o=n.max.y-n.min.y,l=n.isBox3?n.max.z-n.min.z:1,c=n.min.x,h=n.min.y,u=n.isBox3?n.min.z:0;else{const e=Math.pow(2,-i);s=Math.floor(m.width*e),o=Math.floor(m.height*e),l=t.isDataArrayTexture?m.depth:t.isData3DTexture?Math.floor(m.depth*e):1,c=0,h=0,u=0}null!==r?(d=r.x,p=r.y,f=r.z):(d=0,p=0,f=0);const g=mt.convert(e.format),v=mt.convert(e.type);let x;e.isData3DTexture?(Q.setTexture3D(e,0),x=xt.TEXTURE_3D):e.isDataArrayTexture||e.isCompressedArrayTexture?(Q.setTexture2DArray(e,0),x=xt.TEXTURE_2D_ARRAY):(Q.setTexture2D(e,0),x=xt.TEXTURE_2D),xt.pixelStorei(xt.UNPACK_FLIP_Y_WEBGL,e.flipY),xt.pixelStorei(xt.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e.premultiplyAlpha),xt.pixelStorei(xt.UNPACK_ALIGNMENT,e.unpackAlignment);const _=xt.getParameter(xt.UNPACK_ROW_LENGTH),y=xt.getParameter(xt.UNPACK_IMAGE_HEIGHT),b=xt.getParameter(xt.UNPACK_SKIP_PIXELS),E=xt.getParameter(xt.UNPACK_SKIP_ROWS),T=xt.getParameter(xt.UNPACK_SKIP_IMAGES);xt.pixelStorei(xt.UNPACK_ROW_LENGTH,m.width),xt.pixelStorei(xt.UNPACK_IMAGE_HEIGHT,m.height),xt.pixelStorei(xt.UNPACK_SKIP_PIXELS,c),xt.pixelStorei(xt.UNPACK_SKIP_ROWS,h),xt.pixelStorei(xt.UNPACK_SKIP_IMAGES,u);const S=t.isDataArrayTexture||t.isData3DTexture,M=e.isDataArrayTexture||e.isData3DTexture;if(t.isDepthTexture){const n=J.get(t),r=J.get(e),m=J.get(n.__renderTarget),g=J.get(r.__renderTarget);Z.bindFramebuffer(xt.READ_FRAMEBUFFER,m.__webglFramebuffer),Z.bindFramebuffer(xt.DRAW_FRAMEBUFFER,g.__webglFramebuffer);for(let n=0;n<l;n++)S&&(xt.framebufferTextureLayer(xt.READ_FRAMEBUFFER,xt.COLOR_ATTACHMENT0,J.get(t).__webglTexture,i,u+n),xt.framebufferTextureLayer(xt.DRAW_FRAMEBUFFER,xt.COLOR_ATTACHMENT0,J.get(e).__webglTexture,a,f+n)),xt.blitFramebuffer(c,h,s,o,d,p,s,o,xt.DEPTH_BUFFER_BIT,xt.NEAREST);Z.bindFramebuffer(xt.READ_FRAMEBUFFER,null),Z.bindFramebuffer(xt.DRAW_FRAMEBUFFER,null)}else if(0!==i||t.isRenderTargetTexture||J.has(t)){const n=J.get(t),r=J.get(e);Z.bindFramebuffer(xt.READ_FRAMEBUFFER,zt),Z.bindFramebuffer(xt.DRAW_FRAMEBUFFER,Vt);for(let t=0;t<l;t++)S?xt.framebufferTextureLayer(xt.READ_FRAMEBUFFER,xt.COLOR_ATTACHMENT0,n.__webglTexture,i,u+t):xt.framebufferTexture2D(xt.READ_FRAMEBUFFER,xt.COLOR_ATTACHMENT0,xt.TEXTURE_2D,n.__webglTexture,i),M?xt.framebufferTextureLayer(xt.DRAW_FRAMEBUFFER,xt.COLOR_ATTACHMENT0,r.__webglTexture,a,f+t):xt.framebufferTexture2D(xt.DRAW_FRAMEBUFFER,xt.COLOR_ATTACHMENT0,xt.TEXTURE_2D,r.__webglTexture,a),0!==i?xt.blitFramebuffer(c,h,s,o,d,p,s,o,xt.COLOR_BUFFER_BIT,xt.NEAREST):M?xt.copyTexSubImage3D(x,a,d,p,f+t,c,h,s,o):xt.copyTexSubImage2D(x,a,d,p,c,h,s,o);Z.bindFramebuffer(xt.READ_FRAMEBUFFER,null),Z.bindFramebuffer(xt.DRAW_FRAMEBUFFER,null)}else M?t.isDataTexture||t.isData3DTexture?xt.texSubImage3D(x,a,d,p,f,s,o,l,g,v,m.data):e.isCompressedArrayTexture?xt.compressedTexSubImage3D(x,a,d,p,f,s,o,l,g,m.data):xt.texSubImage3D(x,a,d,p,f,s,o,l,g,v,m):t.isDataTexture?xt.texSubImage2D(xt.TEXTURE_2D,a,d,p,s,o,g,v,m.data):t.isCompressedTexture?xt.compressedTexSubImage2D(xt.TEXTURE_2D,a,d,p,m.width,m.height,g,m.data):xt.texSubImage2D(xt.TEXTURE_2D,a,d,p,s,o,g,v,m);xt.pixelStorei(xt.UNPACK_ROW_LENGTH,_),xt.pixelStorei(xt.UNPACK_IMAGE_HEIGHT,y),xt.pixelStorei(xt.UNPACK_SKIP_PIXELS,b),xt.pixelStorei(xt.UNPACK_SKIP_ROWS,E),xt.pixelStorei(xt.UNPACK_SKIP_IMAGES,T),0===a&&e.generateMipmaps&&xt.generateMipmap(x),Z.unbindTexture()},this.copyTextureToTexture3D=function(t,e,n=null,r=null,i=0){return Pr('WebGLRenderer: copyTextureToTexture3D function has been deprecated. Use "copyTextureToTexture" instead.'),this.copyTextureToTexture(t,e,n,r,i)},this.initRenderTarget=function(t){void 0===J.get(t).__webglFramebuffer&&Q.setupRenderTarget(t)},this.initTexture=function(t){t.isCubeTexture?Q.setTextureCube(t,0):t.isData3DTexture?Q.setTexture3D(t,0):t.isDataArrayTexture||t.isCompressedArrayTexture?Q.setTexture2DArray(t,0):Q.setTexture2D(t,0),Z.unbindTexture()},this.resetState=function(){b=0,E=0,T=null,Z.reset(),gt.reset()},"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}get coordinateSystem(){return ar}get outputColorSpace(){return this._outputColorSpace}set outputColorSpace(t){this._outputColorSpace=t;const e=this.getContext();e.drawingBufferColorSpace=Ir._getDrawingBufferColorSpace(t),e.unpackColorSpace=Ir._getUnpackColorSpace()}}const hu=["BLEND","CULL_FACE","DEPTH_TEST","DITHER","POLYGON_OFFSET_FILL","SAMPLE_ALPHA_TO_COVERAGE","SAMPLE_COVERAGE","SCISSOR_TEST","STENCIL_TEST","RASTERIZER_DISCARD"];let uu={};const du=(t,e,n,r)=>t[0]===e&&t[1]===n&&t[2]===r,pu=(t,e,n,r,i)=>t[0]===e&&t[1]===n&&t[2]===r&&t[3]===i,fu=(t,e,n,r)=>{t[0]=e,t[1]=n,t[2]=r},mu=(t,e,n,r,i)=>{t[0]=e,t[1]=n,t[2]=r,t[3]=i};function gu(t){if(t.stateSyncEnabled)return;t.stateSyncEnabled=1;t.drawArrays;uu=hu.reduce((e,n)=>(Number.isInteger(t[n])&&(e[t[n]]=n),e),{});const{state:e,sgl:n}=vu(t);t.state=e,t.sgl=n,t.defaultDrawBuffers=Array(t.getParameter(t.MAX_DRAW_BUFFERS)).fill(t.NONE),t.defaultDrawBuffers[0]=t.COLOR_ATTACHMENT0,function(t){let e=0;const n=t.useProgram,r=[];let i=0;t.useProgram=function(e){if(t.sgl.activeProgram!==e)return t.sgl.activeProgram=e,n.call(t,e)};const a=t.bindTexture;t.bindTexture=function(e,n){const r=t.state.activeTexture-t.TEXTURE0;return t.sgl.textures[r]=n?[e,n]:null,a.call(t,e,n)},t.state.activeTexture=t.TEXTURE0;const s=t.activeTexture;t.activeTexture=function(e){if(t.state.activeTexture!==e)return t.state.activeTexture=e,s.call(t,e)};const o=t.viewport;t.viewport=function(e,n,r,i){pu(t.state.viewport,e,n,r,i)||(mu(t.state.viewport,e,n,r,i),o.call(t,e,n,r,i))};const l=t.blendColor;t.blendColor=function(e,n,r,i){pu(t.state.blendColor,e,n,r,i)||(mu(t.state.blendColor,e,n,r,i),l.call(t,e,n,r,i))};const c=t.blendEquation;t.blendEquation=function(e){t.state.blendEquationRgb===e&&t.state.blendEquationAlpha===e||(t.state.blendEquationRgb=e,t.state.blendEquationAlpha=e,c.call(t,e))};const h=t.blendEquationSeparate;t.blendEquationSeparate=function(e,n){t.state.blendEquationRgb===e&&t.state.blendEquationAlpha===n||(t.state.blendEquationRgb=e,t.state.blendEquationAlpha=n,h.call(t,e,n))};const u=t.blendFunc;t.blendFunc=function(e,n){pu(t.state.blendFuncSeparate,e,n,e,n)||(mu(t.state.blendFuncSeparate,e,n,e,n),u.call(t,e,n))};const d=t.blendFuncSeparate;t.blendFuncSeparate=function(e,n,r,i){if(!pu(t.state.blendFuncSeparate,e,n,r,i))return mu(t.state.blendFuncSeparate,e,n,r,i),d.call(t,e,n,r,i)};const p=t.cullFace;t.cullFace=function(e){if(t.state.cullFaceMode!==e)return t.state.cullFaceMode=e,p.call(t,e)};const f=t.frontFace;t.frontFace=function(e){if(t.state.frontFace!==e)return t.state.frontFace=e,f.call(t,e)};const m=t.lineWidth;t.lineWidth=function(e){if(t.state.lineWidth!==e)return t.state.lineWidth=e,m.call(t,e)};const g=t.clearColor;t.clearColor=function(e,n,r,i){if(!pu(t.state.clearColor,e,n,r,i))return mu(t.state.clearColor,e,n,r,i),g.call(t,e,n,r,i)};const v=t.colorMask;t.colorMask=function(e,n,r,i){if(!pu(t.state.colorMask,e,n,r,i))return mu(t.state.colorMask,e,n,r,i),v.call(t,e,n,r,i)};const x=t.clearDepth;t.clearDepth=function(e){if(t.state.clearDepth!==e)return t.state.clearDepth=e,x.call(t,e)};const _=t.depthFunc;t.depthFunc=function(e){if(t.state.depthFunc!==e)return t.state.depthFunc=e,_.call(t,e)};const y=t.depthMask;t.depthMask=function(e){if(t.state.depthMask!==e)return t.state.depthMask=e,y.call(t,e)};const b=t.depthRange;t.depthRange=function(e,n){if(t.state.depthRange[0]!==e||t.state.depthRange[1]!==n)return t.state.depthRange=[e,n],b.call(t,e,n)};const E=t.polygonOffset;t.polygonOffset=function(e,n){if(t.state.polygonOffset[0]!==e||t.state.polygonOffset[1]!==n)return t.state.polygonOffset=[e,n],E.call(t,e,n)};const T=t.sampleCoverage;t.sampleCoverage=function(e,n){if(t.state.sampleCoverage[0]!==e||t.state.sampleCoverage[1]!==n)return t.state.sampleCoverage=[e,n],T.call(t,e,n)};const S=t.scissor;t.scissor=function(e,n,r,i){if(!pu(t.state.scissor,e,n,r,i))return mu(t.state.scissor,e,n,r,i),S.call(t,e,n,r,i)};const M=t.stencilFunc;t.stencilFunc=function(e,n,r){if(!du(t.state.stencilFunc,e,n,r)||!du(t.state.stencilBackFunc,e,n,r))return fu(t.state.stencilFunc,e,n,r),fu(t.state.stencilBackFunc,e,n,r),M.call(t,e,n,r)};const w=t.stencilOp;t.stencilOp=function(e,n,r){if(!du(t.state.stencilOp,e,n,r)||!du(t.state.stencilBackOp,e,n,r))return fu(t.state.stencilOp,e,n,r),fu(t.state.stencilBackOp,e,n,r),w.call(t,e,n,r)};const R=t.stencilMask;t.stencilMask=function(e){if(t.state.stencilMask!==e||t.state.stencilBackMask!==e)return t.state.stencilMask=e,t.state.stencilBackMask=e,R.call(t,e)};const A=t.clearStencil;t.clearStencil=function(e){if(t.state.clearStencil!==e)return t.state.clearStencil=e,A.call(t,e)};const C=t.stencilFuncSeparate;t.stencilFuncSeparate=function(e,n,r,i){const a=e===t.FRONT||e===t.FRONT_AND_BACK,s=e===t.BACK||e===t.FRONT_AND_BACK;let o=0;if(a&&!du(t.state.stencilFunc,n,r,i)&&(fu(t.state.stencilFunc,n,r,i),o=1),s&&!du(t.state.stencilBackFunc,n,r,i)&&(fu(t.state.stencilBackFunc,n,r,i),o=1),o)return C.call(t,e,n,r,i)};const P=t.stencilOpSeparate;t.stencilOpSeparate=function(e,n,r,i){const a=e===t.FRONT||e===t.FRONT_AND_BACK,s=e===t.BACK||e===t.FRONT_AND_BACK;let o=0;if(a&&!du(t.state.stencilOp,n,r,i)&&(fu(t.state.stencilOp,n,r,i),o=1),s&&!du(t.state.stencilBackOp,n,r,i)&&(fu(t.state.stencilBackOp,n,r,i),o=1),o)return P.call(t,e,n,r,i)};const D=t.stencilMaskSeparate;t.stencilMaskSeparate=function(e,n){let r=0;if(e!==t.FRONT&&e!==t.FRONT_AND_BACK||t.state.stencilMask===n||(t.state.stencilMask=n,r=1),e!==t.BACK&&e!==t.FRONT_AND_BACK||t.state.stencilBackMask===n||(t.state.stencilBackMask=n,r=1),r)return D.call(t,e,n)};const U=t.drawBuffers;t.drawBuffers=function(e){t.lastDrawBufferBound.currentDrawBuffers=e.slice();return U.call(t,e)};const L=t.readBuffer;t.readBuffer=function(e){t.lastReadBufferBound.currentReadBuffer=e;return L.call(t,e)};const I=t.bindFramebuffer;t.bindFramebuffer=function(n,r){n===t.FRAMEBUFFER?(t.sgl.boundFramebuffer=r,t.sgl.boundDrawingBuffer=r,t.sgl.boundReadingBuffer=r,t.lastReadBufferBound=r,t.lastDrawBufferBound=r):n===t.DRAW_FRAMEBUFFER?(t.sgl.boundDrawingBuffer=r,t.lastDrawBufferBound=r):n===t.READ_FRAMEBUFFER&&(t.sgl.boundReadingBuffer=r,t.lastReadBufferBound=r),r&&void 0===r.id&&(r.id=e++);return I.call(t,n,r)},t.sgl.boundFramebuffer=null,t.sgl.boundReadingBuffer=null,t.sgl.boundDrawingBuffer=null;const N=t.bindVertexArray;t.bindVertexArray=function(e){t.sgl.vertexArrayBinding!==e&&(t.sgl.vertexArrayBinding=e,N.call(t,e))};const O=t.bindBuffer;t.bindBuffer=function(e,n){if(t.sgl.boundBufferTarget!==e||t.sgl.boundBuffer!==n)return e===t.ARRAY_BUFFER?t.sgl.arrayBufferBinding=n:e===t.ELEMENT_ARRAY_BUFFER?t.sgl.elementArrayBufferBinding=n:e===t.UNIFORM_BUFFER&&(t.sgl.uniformBufferBinding=n),t.sgl.boundBufferTarget=e,t.sgl.boundBuffer=n,O.call(t,e,n)};const F=t.pixelStorei;t.pixelStorei=function(e,n){t.state.storei[e]!==n&&(t.state.storei[e]=n,F.call(t,e,n))};const B=t.enable;t.enable=function(e){if(1!=t.state.feats[e])return t.state.feats[e]=1,B.call(t,e)};const k=t.disable;t.disable=function(e){if(0!=t.state.feats[e])return t.state.feats[e]=0,k.call(t,e)},t.record=function(){r.length=0,i=1},t.stopRecording=function(){i=0},t.copyState=function(e,n){V(e,n=n||t)};function z(t,e,n){for(let r=0;r<n;++r)t[r]=e[r]}function V(e,n){Object.assign(e.state.feats,n.state.feats),Object.assign(e.state.storei,n.state.storei),e.state.activeTexture=n.state.activeTexture,z(e.state.viewport,n.state.viewport,4),z(e.state.blendColor,n.state.blendColor,4),e.state.blendEquationRgb=n.state.blendEquationRgb,e.state.blendEquationAlpha=n.state.blendEquationAlpha,e.state.cullFaceMode=n.state.cullFaceMode,e.state.depthFunc=n.state.depthFunc,e.state.frontFace=n.state.frontFace,e.state.lineWidth=n.state.lineWidth,z(e.state.blendFuncSeparate,n.state.blendFuncSeparate,4),z(e.state.clearColor,n.state.clearColor,4),z(e.state.colorMask,n.state.colorMask,4),e.state.clearDepth=n.state.clearDepth,e.state.depthMask=n.state.depthMask,z(e.state.depthRange,n.state.depthRange,2),z(e.state.polygonOffset,n.state.polygonOffset,2),z(e.state.sampleCoverage,n.state.sampleCoverage,2),z(e.state.scissor,n.state.scissor,4),z(e.state.stencilFunc,n.state.stencilFunc,3),z(e.state.stencilOp,n.state.stencilOp,3),e.state.stencilMask=n.state.stencilMask,e.state.clearStencil=n.state.clearStencil,z(e.state.stencilBackFunc,n.state.stencilBackFunc,3),z(e.state.stencilBackOp,n.state.stencilBackOp,3),e.state.stencilBackMask=n.state.stencilBackMask,e.sgl.activeProgram=n.sgl.activeProgram,e.sgl.arrayBufferBinding=n.sgl.arrayBufferBinding,e.sgl.elementArrayBufferBinding=n.sgl.elementArrayBufferBinding,e.sgl.uniformBufferBinding=n.sgl.uniformBufferBinding,e.sgl.vertexArrayBinding=n.sgl.vertexArrayBinding,e.sgl.lastReadBufferBound=n.sgl.lastReadBufferBound,e.sgl.lastDrawBufferBound=n.sgl.lastDrawBufferBound,yu(t,e.sgl.framebuffer,t.sgl.boundFramebuffer,t.FRAMEBUFFER),yu(t,e.sgl.readingBuffer,t.sgl.boundReadingBuffer,t.READ_FRAMEBUFFER),yu(t,e.sgl.drawingBuffer,t.sgl.boundDrawingBuffer,t.DRAW_FRAMEBUFFER);for(let n=0,r=t.sgl.textures.length;n<r;n++)e.sgl.textures[n]=t.sgl.textures[n]}t.saveState=function(e){V(e||t.savedState,t)},t.createState=function(){const e=JSON.parse(JSON.stringify(t.state)),n={};return n.arrayBufferBinding=t.sgl.arrayBufferBinding,n.elementArrayBufferBinding=t.sgl.elementArrayBufferBinding,n.uniformBufferBinding=t.sgl.uniformBufferBinding,n.vertexArrayBinding=t.sgl.vertexArrayBinding,n.activeProgram=t.sgl.activeProgram,n.framebuffer=_u(t,t.sgl.boundFramebuffer,t.FRAMEBUFFER),n.readingBuffer=_u(t,t.sgl.boundReadingBuffer,t.READ_FRAMEBUFFER),n.drawingBuffer=_u(t,t.sgl.boundDrawingBuffer,t.DRAW_FRAMEBUFFER),n.lastDrawBufferBound=t.lastDrawBufferBound,n.lastReadBufferBound=t.lastReadBufferBound,n.textures=t.sgl.textures.slice(),{state:e,sgl:n}},t.restoreState=function(e){!function(t,e){const n=e.sgl;t.useProgram(n.activeProgram),t.bindVertexArray(n.vertexArrayBinding),t.bindBuffer(t.ARRAY_BUFFER,n.arrayBufferBinding),t.bindBuffer(t.UNIFORM_BUFFER,n.uniformBufferBinding);const r=e.state;(function(t,e,n){Object.keys(e).forEach(r=>{if(e[r]===n[r])return;uu[r];e[r]?t.enable(r):t.disable(r)})})(t,r.feats,t.state.feats),function(t,e,n){Object.keys(e).forEach(r=>{e[r]!==n[r]&&t.pixelStorei(r,e[r])})}(t,r.storei,t.state.storei),t.viewport(r.viewport[0],r.viewport[1],r.viewport[2],r.viewport[3]),t.blendColor(r.blendColor[0],r.blendColor[1],r.blendColor[2],r.blendColor[3]),t.blendEquationSeparate(r.blendEquationRgb,r.blendEquationAlpha),t.cullFace(r.cullFaceMode),t.depthFunc(r.depthFunc),t.frontFace(r.frontFace),t.lineWidth(r.lineWidth),t.blendFuncSeparate(r.blendFuncSeparate[0],r.blendFuncSeparate[1],r.blendFuncSeparate[2],r.blendFuncSeparate[3]),t.clearColor(r.clearColor[0],r.clearColor[1],r.clearColor[2],r.clearColor[3]),t.colorMask(r.colorMask[0],r.colorMask[1],r.colorMask[2],r.colorMask[3]),t.clearDepth(r.clearDepth),t.depthMask(r.depthMask),t.depthRange(r.depthRange[0],r.depthRange[1]),t.polygonOffset(r.polygonOffset[0],r.polygonOffset[1]),t.sampleCoverage(r.sampleCoverage[0],r.sampleCoverage[1]),t.scissor(r.scissor[0],r.scissor[1],r.scissor[2],r.scissor[3]),t.stencilFunc(r.stencilFunc[0],r.stencilFunc[1],r.stencilFunc[2]),t.stencilOp(r.stencilOp[0],r.stencilOp[1],r.stencilOp[2]),t.stencilMask(r.stencilMask),t.clearStencil(r.clearStencil),t.stencilFuncSeparate(t.BACK,r.stencilBackFunc[0],r.stencilBackFunc[1],r.stencilBackFunc[2]),t.stencilOpSeparate(t.BACK,r.stencilBackOp[0],r.stencilBackOp[1],r.stencilBackOp[2]),t.stencilMaskSeparate(t.BACK,r.stencilBackMask),n.lastDrawBufferBound===n.framebuffer.buffer&&(n.lastReadBufferBound,n.framebuffer.buffer);Eu(t,t.FRAMEBUFFER,n.framebuffer),n.lastDrawBufferBound===n.drawingBuffer.buffer&&n.lastDrawBufferBound!==n.framebuffer.buffer&&Eu(t,t.DRAW_FRAMEBUFFER,n.drawingBuffer);n.lastReadBufferBound===n.readingBuffer.buffer&&n.lastReadBufferBound!==n.framebuffer.buffer&&Eu(t,t.READ_FRAMEBUFFER,n.readingBuffer);bu(t,n.textures,r.activeTexture)}(t,e||t.savedState)},t.setState=function(e){!function(t,e){const n=e.sgl,r=e.state;if(n){n.activeProgram&&t.useProgram(n.activeProgram),void 0!==n.vertexArrayBinding&&t.bindVertexArray(n.vertexArrayBinding),void 0!==n.vertexArrayBinding&&n.elementArrayBufferBinding&&t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,n.elementArrayBufferBinding),void 0!==n.arrayBufferBinding&&t.bindBuffer(t.ARRAY_BUFFER,n.arrayBufferBinding),void 0!==n.uniformBufferBinding&&t.bindBuffer(t.UNIFORM_BUFFER,n.uniformBufferBinding);const e=r&&void 0!==r.activeTexture?r.activeTexture:t.state.activeTexture;n.textures&&bu(t,n.textures,e)}r.feats&&function(t,e){Object.keys(e).forEach(n=>{const r=e[n];void 0!==r&&(r?t.enable(n):t.disable(n))})}(t,r.feats,t.state.feats);r.viewport&&t.viewport(r.viewport[0],r.viewport[1],r.viewport[2],r.viewport[3]);r.blendColor&&t.blendColor(r.blendColor[0],r.blendColor[1],r.blendColor[2],r.blendColor[3]);r.blendEquationRgb&&r.blendEquationAlpha&&t.blendEquationSeparate(r.blendEquationRgb,r.blendEquationAlpha);void 0!==r.cullFaceMode&&t.cullFace(r.cullFaceMode);void 0!==r.depthFunc&&t.depthFunc(r.depthFunc);void 0!==r.frontFace&&t.frontFace(r.frontFace);void 0!==r.lineWidth&&t.lineWidth(r.lineWidth);r.blendFuncSeparate&&t.blendFuncSeparate(r.blendFuncSeparate[0],r.blendFuncSeparate[1],r.blendFuncSeparate[2],r.blendFuncSeparate[3]);r.clearColor&&t.clearColor(r.clearColor[0],r.clearColor[1],r.clearColor[2],r.clearColor[3]);r.colorMask&&t.colorMask(r.colorMask[0],r.colorMask[1],r.colorMask[2],r.colorMask[3]);void 0!==r.clearDepth&&t.clearDepth(r.clearDepth);void 0!==r.depthMask&&t.depthMask(r.depthMask);r.depthRange&&t.depthRange(r.depthRange[0],r.depthRange[1]);r.polygonOffset&&t.polygonOffset(r.polygonOffset[0],r.polygonOffset[1]);r.sampleCoverage&&t.sampleCoverage(r.sampleCoverage[0],r.sampleCoverage[1]);r.scissor&&t.scissor(r.scissor[0],r.scissor[1],r.scissor[2],r.scissor[3]);r.stencilFunc&&t.stencilFunc(r.stencilFunc[0],r.stencilFunc[1],r.stencilFunc[2]);r.stencilOp&&t.stencilOp(r.stencilOp[0],r.stencilOp[1],r.stencilOp[2]);r.stencilMask&&t.stencilMask(r.stencilMask);r.clearStencil&&t.clearStencil(r.clearStencil);r.stencilBackFunc&&t.stencilFuncSeparate(t.BACK,r.stencilBackFunc[0],r.stencilBackFunc[1],r.stencilBackFunc[2]);r.stencilBackOp&&t.stencilOpSeparate(t.BACK,r.stencilBackOp[0],r.stencilBackOp[1],r.stencilBackOp[2]);r.stencilBackMask&&t.stencilMaskSeparate(t.BACK,r.stencilBackMask);r.framebuffer&&r.lastDrawBufferBound===r.framebuffer.buffer&&r.lastReadBufferBound===r.framebuffer.buffer&&(Eu(t,t.DRAW_FRAMEBUFFER,r.drawingBuffer),Eu(t,t.READ_FRAMEBUFFER,r.readingBuffer));r.framebuffer&&Eu(t,t.FRAMEBUFFER,r.framebuffer);r.drawingBuffer&&r.lastDrawBufferBound===r.drawingBuffer.buffer&&Eu(t,t.DRAW_FRAMEBUFFER,r.drawingBuffer);r.readingBuffer&&r.lastReadBufferBound===r.readingBuffer.buffer&&Eu(t,t.READ_FRAMEBUFFER,r.readingBuffer)}(t,e)},t.resetToDefaults=function e(){e(t)},t.showCurrentState=function(){},t.defaultPixelStore=function(){t.state.storei[t.UNPACK_FLIP_Y_WEBGL]&&t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,0),t.state.storei[t.UNPACK_PREMULTIPLY_ALPHA_WEBGL]&&t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,0),t.state.storei[t.UNPACK_COLORSPACE_CONVERSION_WEBGL]!==t.BROWSER_DEFAULT_WEBGL&&t.pixelStorei(t.UNPACK_COLORSPACE_CONVERSION_WEBGL,t.BROWSER_DEFAULT_WEBGL),4!==t.state.storei[t.UNPACK_ALIGNMENT]&&t.pixelStorei(t.UNPACK_ALIGNMENT,4),4!==t.state.storei[t.PACK_ALIGNMENT]&&t.pixelStorei(t.PACK_ALIGNMENT,4)},t.slowFetchState=function(){return vu(t)}}(t),t.defaultState=t.createState(),t.savedState=t.createState()}function vu(t){const e={};e.feats=function(t){const e=[t.BLEND,t.CULL_FACE,t.DEPTH_TEST,t.DITHER,t.POLYGON_OFFSET_FILL,t.SAMPLE_ALPHA_TO_COVERAGE,t.SAMPLE_COVERAGE,t.SCISSOR_TEST,t.STENCIL_TEST];var n={};return e.forEach(function(e){n[e]=t.isEnabled(e)}),n}(t),e.storei=function(t){const e=[t.PACK_ALIGNMENT,t.UNPACK_ALIGNMENT,t.UNPACK_FLIP_Y_WEBGL,t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t.UNPACK_COLORSPACE_CONVERSION_WEBGL,t.UNPACK_ROW_LENGTH,t.UNPACK_SKIP_ROWS,t.UNPACK_SKIP_PIXELS,t.PACK_ROW_LENGTH,t.PACK_SKIP_PIXELS,t.PACK_SKIP_ROWS];var n={};return e.forEach(function(e){n[e]=t.getParameter(e)}),n}(t),e.activeTexture=t.getParameter(t.ACTIVE_TEXTURE)||t.TEXTURE0;const n=t.getParameter(t.VIEWPORT);e.viewport=[n[0],n[1],n[2],n[3]],e.blendColor=t.getParameter(t.BLEND_COLOR),e.blendEquationRgb=t.getParameter(t.BLEND_EQUATION_RGB),e.blendEquationAlpha=t.getParameter(t.BLEND_EQUATION_ALPHA),e.cullFaceMode=t.getParameter(t.CULL_FACE_MODE),e.depthFunc=t.getParameter(t.DEPTH_FUNC),e.frontFace=t.getParameter(t.FRONT_FACE),e.lineWidth=t.getParameter(t.LINE_WIDTH),e.blendFuncSeparate=[t.getParameter(t.BLEND_SRC_RGB),t.getParameter(t.BLEND_DST_RGB),t.getParameter(t.BLEND_SRC_ALPHA),t.getParameter(t.BLEND_DST_ALPHA)],e.clearColor=t.getParameter(t.COLOR_CLEAR_VALUE),e.colorMask=t.getParameter(t.COLOR_WRITEMASK),e.clearDepth=t.getParameter(t.DEPTH_CLEAR_VALUE),e.depthMask=t.getParameter(t.DEPTH_WRITEMASK),e.depthRange=t.getParameter(t.DEPTH_RANGE),e.polygonOffset=[t.getParameter(t.POLYGON_OFFSET_FACTOR),t.getParameter(t.POLYGON_OFFSET_UNITS)],e.sampleCoverage=[t.getParameter(t.SAMPLE_COVERAGE_VALUE),t.getParameter(t.SAMPLE_COVERAGE_INVERT)],e.scissor=t.getParameter(t.SCISSOR_BOX),e.stencilFunc=[t.getParameter(t.STENCIL_FUNC),t.getParameter(t.STENCIL_REF),t.getParameter(t.STENCIL_VALUE_MASK)],e.stencilOp=[t.getParameter(t.STENCIL_FAIL),t.getParameter(t.STENCIL_PASS_DEPTH_FAIL),t.getParameter(t.STENCIL_PASS_DEPTH_PASS)],e.stencilMask=t.getParameter(t.STENCIL_WRITEMASK),2147483647===e.stencilMask&&(e.stencilMask=4294967295),e.clearStencil=t.getParameter(t.STENCIL_CLEAR_VALUE),e.stencilBackFunc=[t.getParameter(t.STENCIL_BACK_FUNC),t.getParameter(t.STENCIL_BACK_REF),t.getParameter(t.STENCIL_BACK_VALUE_MASK)],e.stencilBackOp=[t.getParameter(t.STENCIL_BACK_FAIL),t.getParameter(t.STENCIL_BACK_PASS_DEPTH_FAIL),t.getParameter(t.STENCIL_BACK_PASS_DEPTH_PASS)],e.stencilBackMask=t.getParameter(t.STENCIL_BACK_WRITEMASK),2147483647===e.stencilBackMask&&(e.stencilBackMask=4294967295);const r={};return r.activeProgram=t.getParameter(t.CURRENT_PROGRAM),r.arrayBufferBinding=t.getParameter(t.ARRAY_BUFFER_BINDING),r.elementArrayBufferBinding=t.getParameter(t.ELEMENT_ARRAY_BUFFER_BINDING),r.uniformBufferBinding=t.getParameter(t.UNIFORM_BUFFER_BINDING),r.vertexArrayBinding=t.getParameter(t.VERTEX_ARRAY_BINDING),r.framebuffer=xu(t,t.getParameter(t.FRAMEBUFFER_BINDING),t.FRAMEBUFFER),r.readingBuffer=xu(t,t.getParameter(t.READ_FRAMEBUFFER_BINDING),t.READ_FRAMEBUFFER),r.drawingBuffer=xu(t,t.getParameter(t.DRAW_FRAMEBUFFER_BINDING),t.DRAW_FRAMEBUFFER),r.lastReadBufferBound=r.readingBuffer.buffer,r.lastDrawBufferBound=r.drawingBuffer.buffer,r.textures=function(t,e){var n=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS);const r=new Array(n);for(var i=0;i<n;++i){t.activeTexture(t.TEXTURE0+i);let e=null,n=null;(n=t.getParameter(t.TEXTURE_BINDING_2D))?e=t.TEXTURE_2D:(n=t.getParameter(t.TEXTURE_BINDING_CUBE_MAP))?e=t.TEXTURE_CUBE_MAP:(n=t.getParameter(t.TEXTURE_BINDING_3D))?e=t.TEXTURE_3D:(n=t.getParameter(t.TEXTURE_BINDING_2D_ARRAY))&&(e=t.TEXTURE_2D_ARRAY),r[i]=e?[e,n]:null}return t.activeTexture(e),r}(t,e.activeTexture),{state:e,sgl:r}}function xu(t,e,n){const r={buffer:e};if(null!==e&&(t.bindFramebuffer(n,e),n!==t.FRAMEBUFFER&&n!==t.READ_FRAMEBUFFER||(r.readBuffer=t.getParameter(t.READ_BUFFER)),n===t.FRAMEBUFFER||n===t.DRAW_FRAMEBUFFER)){const e=t.getParameter(t.MAX_DRAW_BUFFERS);r.drawBuffers=[];for(let n=0;n<e;n++)r.drawBuffers.push(t.getParameter(t.DRAW_BUFFER0+n))}return r}function _u(t,e,n){const r={buffer:e};return null!==e&&(n!==t.FRAMEBUFFER&&n!==t.READ_FRAMEBUFFER||(r.readBuffer=e.currentReadBuffer||t.COLOR_ATTACHMENT0),n!==t.FRAMEBUFFER&&n!==t.DRAW_FRAMEBUFFER||(e.currentDrawBuffers?r.drawBuffers=e.currentDrawBuffers.slice():r.drawBuffers=t.defaultDrawBuffers)),r}function yu(t,e,n,r){e.buffer=n;const i=e;return i.readBuffer=void 0,i.drawBuffers=void 0,null!==n&&(r!==t.FRAMEBUFFER&&r!==t.READ_FRAMEBUFFER||(i.readBuffer=n.currentReadBuffer||t.COLOR_ATTACHMENT0),r!==t.FRAMEBUFFER&&r!==t.DRAW_FRAMEBUFFER||(n.currentDrawBuffers?i.drawBuffers=n.currentDrawBuffers.slice():i.drawBuffers=t.defaultDrawBuffers)),i}function bu(t,e,n){for(var r=0;r<16;r++){const n=t.sgl.textures[r],i=e[r];0,n!==i&&(n&&i&&i[0]===n[0]&&i[1]===n[1]||(t.activeTexture(t.TEXTURE0+r),t.bindTexture(i?i[0]:t.TEXTURE_2D,i?i[1]:null)))}t.activeTexture(n)}function Eu(t,e,n){t.bindFramebuffer(e,n.buffer),null!==n.buffer&&(e!==t.FRAMEBUFFER&&e!==t.DRAW_FRAMEBUFFER||t.drawBuffers(n.drawBuffers),e!==t.FRAMEBUFFER&&e!==t.READ_FRAMEBUFFER||t.readBuffer(n.readBuffer))}const Tu=new WeakMap;class Su extends Xo{constructor(t){super(t),this.decoderPath="",this.decoderConfig={},this.decoderBinary=null,this.decoderPending=null,this.workerLimit=4,this.workerPool=[],this.workerNextTaskID=1,this.workerSourceURL="",this.defaultAttributeIDs={position:"POSITION",normal:"NORMAL",color:"COLOR",uv:"TEX_COORD"},this.defaultAttributeTypes={position:"Float32Array",normal:"Float32Array",color:"Float32Array",uv:"Float32Array"}}setDecoderPath(t){return this.decoderPath=t,this}setDecoderConfig(t){return this.decoderConfig=t,this}setWorkerLimit(t){return this.workerLimit=t,this}load(t,e,n,r){const i=new Yo(this.manager);i.setPath(this.path),i.setResponseType("arraybuffer"),i.setRequestHeader(this.requestHeader),i.setWithCredentials(this.withCredentials),i.load(t,t=>{this.parse(t,e,r)},n,r)}parse(t,e,n=()=>{}){this.decodeDracoFile(t,e,null,null,Wn,n).catch(n)}decodeDracoFile(t,e,n,r,i=Xn,a=()=>{}){const s={attributeIDs:n||this.defaultAttributeIDs,attributeTypes:r||this.defaultAttributeTypes,useUniqueIDs:!!n,vertexColorSpace:i};return this.decodeGeometry(t,s).then(e).catch(a)}decodeGeometry(t,e){const n=JSON.stringify(e);if(Tu.has(t)){const e=Tu.get(t);if(e.key===n)return e.promise;if(0===t.byteLength)throw new Error("THREE.DRACOLoader: Unable to re-decode a buffer with different settings. Buffer has already been transferred.")}let r;const i=this.workerNextTaskID++,a=t.byteLength,s=this._getWorker(i,a).then(n=>(r=n,new Promise((n,a)=>{r._callbacks[i]={resolve:n,reject:a},r.postMessage({type:"decode",id:i,taskConfig:e,buffer:t},[t])}))).then(t=>this._createGeometry(t.geometry));return s.catch(()=>1).then(()=>{r&&i&&this._releaseTask(r,i)}),Tu.set(t,{key:n,promise:s}),s}_createGeometry(t){const e=new Ia;t.index&&e.setIndex(new Ta(t.index.array,1));for(let n=0;n<t.attributes.length;n++){const r=t.attributes[n],i=r.name,a=r.array,s=r.itemSize,o=new Ta(a,s);"color"===i&&(this._assignVertexColorSpace(o,r.vertexColorSpace),o.normalized=a instanceof Float32Array==0),e.setAttribute(i,o)}return e}_assignVertexColorSpace(t,e){if(e!==Wn)return;const n=new ma;for(let e=0,r=t.count;e<r;e++)n.fromBufferAttribute(t,e),Ir.colorSpaceToWorking(n,Wn),t.setXYZ(e,n.r,n.g,n.b)}_loadLibrary(t,e){const n=new Yo(this.manager);return n.setPath(this.decoderPath),n.setResponseType(e),n.setWithCredentials(this.withCredentials),new Promise((e,r)=>{n.load(t,e,void 0,r)})}preload(){return this._initDecoder(),this}_initDecoder(){if(this.decoderPending)return this.decoderPending;const t="object"!=typeof WebAssembly||"js"===this.decoderConfig.type,e=[];return t?e.push(this._loadLibrary("draco_decoder.js","text")):(e.push(this._loadLibrary("draco_wasm_wrapper.js","text")),e.push(this._loadLibrary("draco_decoder.wasm","arraybuffer"))),this.decoderPending=Promise.all(e).then(e=>{const n=e[0];t||(this.decoderConfig.wasmBinary=e[1]);const r=Mu.toString(),i=["/* draco decoder */",n,"","/* worker */",r.substring(r.indexOf("{")+1,r.lastIndexOf("}"))].join("\n");this.workerSourceURL=URL.createObjectURL(new Blob([i]))}),this.decoderPending}_getWorker(t,e){return this._initDecoder().then(()=>{if(this.workerPool.length<this.workerLimit){const t=new Worker(this.workerSourceURL);t._callbacks={},t._taskCosts={},t._taskLoad=0,t.postMessage({type:"init",decoderConfig:this.decoderConfig}),t.onmessage=function(e){const n=e.data;switch(n.type){case"decode":t._callbacks[n.id].resolve(n);break;case"error":t._callbacks[n.id].reject(n)}},this.workerPool.push(t)}else this.workerPool.sort(function(t,e){return t._taskLoad>e._taskLoad?-1:1});const n=this.workerPool[this.workerPool.length-1];return n._taskCosts[t]=e,n._taskLoad+=e,n})}_releaseTask(t,e){t._taskLoad-=t._taskCosts[e],delete t._callbacks[e],delete t._taskCosts[e]}debug(){}dispose(){for(let t=0;t<this.workerPool.length;++t)this.workerPool[t].terminate();return this.workerPool.length=0,""!==this.workerSourceURL&&URL.revokeObjectURL(this.workerSourceURL),this}}function Mu(){let t,e;function n(t,e,n,r,i,a){const s=a.num_components(),o=n.num_points()*s,l=o*i.BYTES_PER_ELEMENT,c=function(t,e){switch(e){case Float32Array:return t.DT_FLOAT32;case Int8Array:return t.DT_INT8;case Int16Array:return t.DT_INT16;case Int32Array:return t.DT_INT32;case Uint8Array:return t.DT_UINT8;case Uint16Array:return t.DT_UINT16;case Uint32Array:return t.DT_UINT32}}(t,i),h=t._malloc(l);e.GetAttributeDataArrayForAllPoints(n,a,c,l,h);const u=new i(t.HEAPF32.buffer,h,o).slice();return t._free(h),{name:r,array:u,itemSize:s}}onmessage=function(r){const i=r.data;switch(i.type){case"init":t=i.decoderConfig,e=new Promise(function(e){t.onModuleLoaded=function(t){e({draco:t})},DracoDecoderModule(t)});break;case"decode":const r=i.buffer,a=i.taskConfig;e.then(t=>{const e=t.draco,s=new e.Decoder;try{const t=function(t,e,r,i){const a=i.attributeIDs,s=i.attributeTypes;let o,l;const c=e.GetEncodedGeometryType(r);if(c===t.TRIANGULAR_MESH)o=new t.Mesh,l=e.DecodeArrayToMesh(r,r.byteLength,o);else{if(c!==t.POINT_CLOUD)throw new Error("THREE.DRACOLoader: Unexpected geometry type.");o=new t.PointCloud,l=e.DecodeArrayToPointCloud(r,r.byteLength,o)}if(!l.ok()||0===o.ptr)throw new Error("THREE.DRACOLoader: Decoding failed: "+l.error_msg());const h={index:null,attributes:[]};for(const r in a){const l=self[s[r]];let c,u;if(i.useUniqueIDs)u=a[r],c=e.GetAttributeByUniqueId(o,u);else{if(u=e.GetAttributeId(o,t[a[r]]),-1===u)continue;c=e.GetAttribute(o,u)}const d=n(t,e,o,r,l,c);"color"===r&&(d.vertexColorSpace=i.vertexColorSpace),h.attributes.push(d)}c===t.TRIANGULAR_MESH&&(h.index=function(t,e,n){const r=n.num_faces(),i=3*r,a=4*i,s=t._malloc(a);e.GetTrianglesUInt32Array(n,a,s);const o=new Uint32Array(t.HEAPF32.buffer,s,i).slice();return t._free(s),{array:o,itemSize:1}}(t,e,o));return t.destroy(o),h}(e,s,new Int8Array(r),a),o=t.attributes.map(t=>t.array.buffer);t.index&&o.push(t.index.array.buffer),self.postMessage({type:"decode",id:i.id,geometry:t},o)}catch(t){self.postMessage({type:"error",id:i.id,error:t.message})}finally{e.destroy(s)}})}}}function wu(t,e){if(0===e)return t;if(2===e||1===e){let n=t.getIndex();if(null===n){const e=[],r=t.getAttribute("position");if(void 0===r)return t;for(let t=0;t<r.count;t++)e.push(t);t.setIndex(e),n=t.getIndex()}const r=n.count-2,i=[];if(2===e)for(let t=1;t<=r;t++)i.push(n.getX(0)),i.push(n.getX(t)),i.push(n.getX(t+1));else for(let t=0;t<r;t++)t%2==0?(i.push(n.getX(t)),i.push(n.getX(t+1)),i.push(n.getX(t+2))):(i.push(n.getX(t+2)),i.push(n.getX(t+1)),i.push(n.getX(t)));i.length;const a=t.clone();return a.setIndex(i),a.clearGroups(),a}return t}class Ru extends Xo{constructor(t){super(t),this.dracoLoader=null,this.ktx2Loader=null,this.meshoptDecoder=null,this.pluginCallbacks=[],this.register(function(t){return new Lu(t)}),this.register(function(t){return new Iu(t)}),this.register(function(t){return new Gu(t)}),this.register(function(t){return new Wu(t)}),this.register(function(t){return new Xu(t)}),this.register(function(t){return new Ou(t)}),this.register(function(t){return new Fu(t)}),this.register(function(t){return new Bu(t)}),this.register(function(t){return new ku(t)}),this.register(function(t){return new Uu(t)}),this.register(function(t){return new zu(t)}),this.register(function(t){return new Nu(t)}),this.register(function(t){return new Hu(t)}),this.register(function(t){return new Vu(t)}),this.register(function(t){return new Pu(t)}),this.register(function(t){return new ju(t)}),this.register(function(t){return new qu(t)})}load(t,e,n,r){const i=this;let a;if(""!==this.resourcePath)a=this.resourcePath;else if(""!==this.path){const e=fl.extractUrlBase(t);a=fl.resolveURL(e,this.path)}else a=fl.extractUrlBase(t);this.manager.itemStart(t);const s=function(e){r&&r(e),i.manager.itemError(t),i.manager.itemEnd(t)},o=new Yo(this.manager);o.setPath(this.path),o.setResponseType("arraybuffer"),o.setRequestHeader(this.requestHeader),o.setWithCredentials(this.withCredentials),o.load(t,function(n){try{i.parse(n,a,function(n){e(n),i.manager.itemEnd(t)},s)}catch(t){s(t)}},n,s)}setDRACOLoader(t){return this.dracoLoader=t,this}setKTX2Loader(t){return this.ktx2Loader=t,this}setMeshoptDecoder(t){return this.meshoptDecoder=t,this}register(t){return-1===this.pluginCallbacks.indexOf(t)&&this.pluginCallbacks.push(t),this}unregister(t){return-1!==this.pluginCallbacks.indexOf(t)&&this.pluginCallbacks.splice(this.pluginCallbacks.indexOf(t),1),this}parse(t,e,n,r){let i;const a={},s={},o=new TextDecoder;if("string"==typeof t)i=JSON.parse(t);else if(t instanceof ArrayBuffer){if(o.decode(new Uint8Array(t,0,4))===Yu){try{a[Cu.KHR_BINARY_GLTF]=new $u(t)}catch(t){return void(r&&r(t))}i=JSON.parse(a[Cu.KHR_BINARY_GLTF].content)}else i=JSON.parse(o.decode(t))}else i=t;if(void 0===i.asset||i.asset.version[0]<2)return void(r&&r(new Error("THREE.GLTFLoader: Unsupported asset. glTF versions >=2.0 are supported.")));const l=new Td(i,{path:e||this.resourcePath||"",crossOrigin:this.crossOrigin,requestHeader:this.requestHeader,manager:this.manager,ktx2Loader:this.ktx2Loader,meshoptDecoder:this.meshoptDecoder});l.fileLoader.setRequestHeader(this.requestHeader);for(let t=0;t<this.pluginCallbacks.length;t++){const e=this.pluginCallbacks[t](l);e.name,s[e.name]=e,a[e.name]=1}if(i.extensionsUsed)for(let t=0;t<i.extensionsUsed.length;++t){const e=i.extensionsUsed[t],n=i.extensionsRequired||[];switch(e){case Cu.KHR_MATERIALS_UNLIT:a[e]=new Du;break;case Cu.KHR_DRACO_MESH_COMPRESSION:a[e]=new Ju(i,this.dracoLoader);break;case Cu.KHR_TEXTURE_TRANSFORM:a[e]=new Qu;break;case Cu.KHR_MESH_QUANTIZATION:a[e]=new td;break;default:n.indexOf(e)>=0&&s[e]}}l.setExtensions(a),l.setPlugins(s),l.parse(n,r)}parseAsync(t,e){const n=this;return new Promise(function(r,i){n.parse(t,e,r,i)})}}function Au(){let t={};return{get:function(e){return t[e]},add:function(e,n){t[e]=n},remove:function(e){delete t[e]},removeAll:function(){t={}}}}const Cu={KHR_BINARY_GLTF:"KHR_binary_glTF",KHR_DRACO_MESH_COMPRESSION:"KHR_draco_mesh_compression",KHR_LIGHTS_PUNCTUAL:"KHR_lights_punctual",KHR_MATERIALS_CLEARCOAT:"KHR_materials_clearcoat",KHR_MATERIALS_DISPERSION:"KHR_materials_dispersion",KHR_MATERIALS_IOR:"KHR_materials_ior",KHR_MATERIALS_SHEEN:"KHR_materials_sheen",KHR_MATERIALS_SPECULAR:"KHR_materials_specular",KHR_MATERIALS_TRANSMISSION:"KHR_materials_transmission",KHR_MATERIALS_IRIDESCENCE:"KHR_materials_iridescence",KHR_MATERIALS_ANISOTROPY:"KHR_materials_anisotropy",KHR_MATERIALS_UNLIT:"KHR_materials_unlit",KHR_MATERIALS_VOLUME:"KHR_materials_volume",KHR_TEXTURE_BASISU:"KHR_texture_basisu",KHR_TEXTURE_TRANSFORM:"KHR_texture_transform",KHR_MESH_QUANTIZATION:"KHR_mesh_quantization",KHR_MATERIALS_EMISSIVE_STRENGTH:"KHR_materials_emissive_strength",EXT_MATERIALS_BUMP:"EXT_materials_bump",EXT_TEXTURE_WEBP:"EXT_texture_webp",EXT_TEXTURE_AVIF:"EXT_texture_avif",EXT_MESHOPT_COMPRESSION:"EXT_meshopt_compression",EXT_MESH_GPU_INSTANCING:"EXT_mesh_gpu_instancing"};class Pu{constructor(t){this.parser=t,this.name=Cu.KHR_LIGHTS_PUNCTUAL,this.cache={refs:{},uses:{}}}_markDefs(){const t=this.parser,e=this.parser.json.nodes||[];for(let n=0,r=e.length;n<r;n++){const r=e[n];r.extensions&&r.extensions[this.name]&&void 0!==r.extensions[this.name].light&&t._addNodeRef(this.cache,r.extensions[this.name].light)}}_loadLight(t){const e=this.parser,n="light:"+t;let r=e.cache.get(n);if(r)return r;const i=e.json,a=((i.extensions&&i.extensions[this.name]||{}).lights||[])[t];let s;const o=new ma(16777215);void 0!==a.color&&o.setRGB(a.color[0],a.color[1],a.color[2],Xn);const l=void 0!==a.range?a.range:0;switch(a.type){case"directional":s=new dl(o),s.target.position.set(0,0,-1),s.add(s.target);break;case"point":s=new cl(o),s.distance=l;break;case"spot":s=new il(o),s.distance=l,a.spot=a.spot||{},a.spot.innerConeAngle=void 0!==a.spot.innerConeAngle?a.spot.innerConeAngle:0,a.spot.outerConeAngle=void 0!==a.spot.outerConeAngle?a.spot.outerConeAngle:Math.PI/4,s.angle=a.spot.outerConeAngle,s.penumbra=1-a.spot.innerConeAngle/a.spot.outerConeAngle,s.target.position.set(0,0,-1),s.add(s.target);break;default:throw new Error("THREE.GLTFLoader: Unexpected light type: "+a.type)}return s.position.set(0,0,0),vd(s,a),void 0!==a.intensity&&(s.intensity=a.intensity),s.name=e.createUniqueName(a.name||"light_"+t),r=Promise.resolve(s),e.cache.add(n,r),r}getDependency(t,e){if("light"===t)return this._loadLight(e)}createNodeAttachment(t){const e=this,n=this.parser,r=n.json.nodes[t],i=(r.extensions&&r.extensions[this.name]||{}).light;return void 0===i?null:this._loadLight(i).then(function(t){return n._getNodeRef(e.cache,i,t)})}}class Du{constructor(){this.name=Cu.KHR_MATERIALS_UNLIT}getMaterialType(){return _a}extendParams(t,e,n){const r=[];t.color=new ma(1,1,1),t.opacity=1;const i=e.pbrMetallicRoughness;if(i){if(Array.isArray(i.baseColorFactor)){const e=i.baseColorFactor;t.color.setRGB(e[0],e[1],e[2],Xn),t.opacity=e[3]}void 0!==i.baseColorTexture&&r.push(n.assignTexture(t,"map",i.baseColorTexture,Wn))}return Promise.all(r)}}class Uu{constructor(t){this.parser=t,this.name=Cu.KHR_MATERIALS_EMISSIVE_STRENGTH}extendMaterialParams(t,e){const n=this.parser.json.materials[t];if(!n.extensions||!n.extensions[this.name])return Promise.resolve();const r=n.extensions[this.name].emissiveStrength;return void 0!==r&&(e.emissiveIntensity=r),Promise.resolve()}}class Lu{constructor(t){this.parser=t,this.name=Cu.KHR_MATERIALS_CLEARCOAT}getMaterialType(t){const e=this.parser.json.materials[t];return e.extensions&&e.extensions[this.name]?yo:null}extendMaterialParams(t,e){const n=this.parser,r=n.json.materials[t];if(!r.extensions||!r.extensions[this.name])return Promise.resolve();const i=[],a=r.extensions[this.name];if(void 0!==a.clearcoatFactor&&(e.clearcoat=a.clearcoatFactor),void 0!==a.clearcoatTexture&&i.push(n.assignTexture(e,"clearcoatMap",a.clearcoatTexture)),void 0!==a.clearcoatRoughnessFactor&&(e.clearcoatRoughness=a.clearcoatRoughnessFactor),void 0!==a.clearcoatRoughnessTexture&&i.push(n.assignTexture(e,"clearcoatRoughnessMap",a.clearcoatRoughnessTexture)),void 0!==a.clearcoatNormalTexture&&(i.push(n.assignTexture(e,"clearcoatNormalMap",a.clearcoatNormalTexture)),void 0!==a.clearcoatNormalTexture.scale)){const t=a.clearcoatNormalTexture.scale;e.clearcoatNormalScale=new _r(t,t)}return Promise.all(i)}}class Iu{constructor(t){this.parser=t,this.name=Cu.KHR_MATERIALS_DISPERSION}getMaterialType(t){const e=this.parser.json.materials[t];return e.extensions&&e.extensions[this.name]?yo:null}extendMaterialParams(t,e){const n=this.parser.json.materials[t];if(!n.extensions||!n.extensions[this.name])return Promise.resolve();const r=n.extensions[this.name];return e.dispersion=void 0!==r.dispersion?r.dispersion:0,Promise.resolve()}}class Nu{constructor(t){this.parser=t,this.name=Cu.KHR_MATERIALS_IRIDESCENCE}getMaterialType(t){const e=this.parser.json.materials[t];return e.extensions&&e.extensions[this.name]?yo:null}extendMaterialParams(t,e){const n=this.parser,r=n.json.materials[t];if(!r.extensions||!r.extensions[this.name])return Promise.resolve();const i=[],a=r.extensions[this.name];return void 0!==a.iridescenceFactor&&(e.iridescence=a.iridescenceFactor),void 0!==a.iridescenceTexture&&i.push(n.assignTexture(e,"iridescenceMap",a.iridescenceTexture)),void 0!==a.iridescenceIor&&(e.iridescenceIOR=a.iridescenceIor),void 0===e.iridescenceThicknessRange&&(e.iridescenceThicknessRange=[100,400]),void 0!==a.iridescenceThicknessMinimum&&(e.iridescenceThicknessRange[0]=a.iridescenceThicknessMinimum),void 0!==a.iridescenceThicknessMaximum&&(e.iridescenceThicknessRange[1]=a.iridescenceThicknessMaximum),void 0!==a.iridescenceThicknessTexture&&i.push(n.assignTexture(e,"iridescenceThicknessMap",a.iridescenceThicknessTexture)),Promise.all(i)}}class Ou{constructor(t){this.parser=t,this.name=Cu.KHR_MATERIALS_SHEEN}getMaterialType(t){const e=this.parser.json.materials[t];return e.extensions&&e.extensions[this.name]?yo:null}extendMaterialParams(t,e){const n=this.parser,r=n.json.materials[t];if(!r.extensions||!r.extensions[this.name])return Promise.resolve();const i=[];e.sheenColor=new ma(0,0,0),e.sheenRoughness=0,e.sheen=1;const a=r.extensions[this.name];if(void 0!==a.sheenColorFactor){const t=a.sheenColorFactor;e.sheenColor.setRGB(t[0],t[1],t[2],Xn)}return void 0!==a.sheenRoughnessFactor&&(e.sheenRoughness=a.sheenRoughnessFactor),void 0!==a.sheenColorTexture&&i.push(n.assignTexture(e,"sheenColorMap",a.sheenColorTexture,Wn)),void 0!==a.sheenRoughnessTexture&&i.push(n.assignTexture(e,"sheenRoughnessMap",a.sheenRoughnessTexture)),Promise.all(i)}}class Fu{constructor(t){this.parser=t,this.name=Cu.KHR_MATERIALS_TRANSMISSION}getMaterialType(t){const e=this.parser.json.materials[t];return e.extensions&&e.extensions[this.name]?yo:null}extendMaterialParams(t,e){const n=this.parser,r=n.json.materials[t];if(!r.extensions||!r.extensions[this.name])return Promise.resolve();const i=[],a=r.extensions[this.name];return void 0!==a.transmissionFactor&&(e.transmission=a.transmissionFactor),void 0!==a.transmissionTexture&&i.push(n.assignTexture(e,"transmissionMap",a.transmissionTexture)),Promise.all(i)}}class Bu{constructor(t){this.parser=t,this.name=Cu.KHR_MATERIALS_VOLUME}getMaterialType(t){const e=this.parser.json.materials[t];return e.extensions&&e.extensions[this.name]?yo:null}extendMaterialParams(t,e){const n=this.parser,r=n.json.materials[t];if(!r.extensions||!r.extensions[this.name])return Promise.resolve();const i=[],a=r.extensions[this.name];e.thickness=void 0!==a.thicknessFactor?a.thicknessFactor:0,void 0!==a.thicknessTexture&&i.push(n.assignTexture(e,"thicknessMap",a.thicknessTexture)),e.attenuationDistance=a.attenuationDistance||1/0;const s=a.attenuationColor||[1,1,1];return e.attenuationColor=(new ma).setRGB(s[0],s[1],s[2],Xn),Promise.all(i)}}class ku{constructor(t){this.parser=t,this.name=Cu.KHR_MATERIALS_IOR}getMaterialType(t){const e=this.parser.json.materials[t];return e.extensions&&e.extensions[this.name]?yo:null}extendMaterialParams(t,e){const n=this.parser.json.materials[t];if(!n.extensions||!n.extensions[this.name])return Promise.resolve();const r=n.extensions[this.name];return e.ior=void 0!==r.ior?r.ior:1.5,Promise.resolve()}}class zu{constructor(t){this.parser=t,this.name=Cu.KHR_MATERIALS_SPECULAR}getMaterialType(t){const e=this.parser.json.materials[t];return e.extensions&&e.extensions[this.name]?yo:null}extendMaterialParams(t,e){const n=this.parser,r=n.json.materials[t];if(!r.extensions||!r.extensions[this.name])return Promise.resolve();const i=[],a=r.extensions[this.name];e.specularIntensity=void 0!==a.specularFactor?a.specularFactor:1,void 0!==a.specularTexture&&i.push(n.assignTexture(e,"specularIntensityMap",a.specularTexture));const s=a.specularColorFactor||[1,1,1];return e.specularColor=(new ma).setRGB(s[0],s[1],s[2],Xn),void 0!==a.specularColorTexture&&i.push(n.assignTexture(e,"specularColorMap",a.specularColorTexture,Wn)),Promise.all(i)}}class Vu{constructor(t){this.parser=t,this.name=Cu.EXT_MATERIALS_BUMP}getMaterialType(t){const e=this.parser.json.materials[t];return e.extensions&&e.extensions[this.name]?yo:null}extendMaterialParams(t,e){const n=this.parser,r=n.json.materials[t];if(!r.extensions||!r.extensions[this.name])return Promise.resolve();const i=[],a=r.extensions[this.name];return e.bumpScale=void 0!==a.bumpFactor?a.bumpFactor:1,void 0!==a.bumpTexture&&i.push(n.assignTexture(e,"bumpMap",a.bumpTexture)),Promise.all(i)}}class Hu{constructor(t){this.parser=t,this.name=Cu.KHR_MATERIALS_ANISOTROPY}getMaterialType(t){const e=this.parser.json.materials[t];return e.extensions&&e.extensions[this.name]?yo:null}extendMaterialParams(t,e){const n=this.parser,r=n.json.materials[t];if(!r.extensions||!r.extensions[this.name])return Promise.resolve();const i=[],a=r.extensions[this.name];return void 0!==a.anisotropyStrength&&(e.anisotropy=a.anisotropyStrength),void 0!==a.anisotropyRotation&&(e.anisotropyRotation=a.anisotropyRotation),void 0!==a.anisotropyTexture&&i.push(n.assignTexture(e,"anisotropyMap",a.anisotropyTexture)),Promise.all(i)}}class Gu{constructor(t){this.parser=t,this.name=Cu.KHR_TEXTURE_BASISU}loadTexture(t){const e=this.parser,n=e.json,r=n.textures[t];if(!r.extensions||!r.extensions[this.name])return null;const i=r.extensions[this.name],a=e.options.ktx2Loader;if(!a){if(n.extensionsRequired&&n.extensionsRequired.indexOf(this.name)>=0)throw new Error("THREE.GLTFLoader: setKTX2Loader must be called before loading KTX2 textures");return null}return e.loadTextureImage(t,i.source,a)}}class Wu{constructor(t){this.parser=t,this.name=Cu.EXT_TEXTURE_WEBP}loadTexture(t){const e=this.name,n=this.parser,r=n.json,i=r.textures[t];if(!i.extensions||!i.extensions[e])return null;const a=i.extensions[e],s=r.images[a.source];let o=n.textureLoader;if(s.uri){const t=n.options.manager.getHandler(s.uri);null!==t&&(o=t)}return n.loadTextureImage(t,a.source,o)}}class Xu{constructor(t){this.parser=t,this.name=Cu.EXT_TEXTURE_AVIF}loadTexture(t){const e=this.name,n=this.parser,r=n.json,i=r.textures[t];if(!i.extensions||!i.extensions[e])return null;const a=i.extensions[e],s=r.images[a.source];let o=n.textureLoader;if(s.uri){const t=n.options.manager.getHandler(s.uri);null!==t&&(o=t)}return n.loadTextureImage(t,a.source,o)}}class ju{constructor(t){this.name=Cu.EXT_MESHOPT_COMPRESSION,this.parser=t}loadBufferView(t){const e=this.parser.json,n=e.bufferViews[t];if(n.extensions&&n.extensions[this.name]){const t=n.extensions[this.name],r=this.parser.getDependency("buffer",t.buffer),i=this.parser.options.meshoptDecoder;if(!i||!i.supported){if(e.extensionsRequired&&e.extensionsRequired.indexOf(this.name)>=0)throw new Error("THREE.GLTFLoader: setMeshoptDecoder must be called before loading compressed files");return null}return r.then(function(e){const n=t.byteOffset||0,r=t.byteLength||0,a=t.count,s=t.byteStride,o=new Uint8Array(e,n,r);return i.decodeGltfBufferAsync?i.decodeGltfBufferAsync(a,s,o,t.mode,t.filter).then(function(t){return t.buffer}):i.ready.then(function(){const e=new ArrayBuffer(a*s);return i.decodeGltfBuffer(new Uint8Array(e),a,s,o,t.mode,t.filter),e})})}return null}}class qu{constructor(t){this.name=Cu.EXT_MESH_GPU_INSTANCING,this.parser=t}createNodeMesh(t){const e=this.parser.json,n=e.nodes[t];if(!n.extensions||!n.extensions[this.name]||void 0===n.mesh)return null;const r=e.meshes[n.mesh];for(const t of r.primitives)if(t.mode!==id.TRIANGLES&&t.mode!==id.TRIANGLE_STRIP&&t.mode!==id.TRIANGLE_FAN&&void 0!==t.mode)return null;const i=n.extensions[this.name].attributes,a=[],s={};for(const t in i)a.push(this.parser.getDependency("accessor",i[t]).then(e=>(s[t]=e,s[t])));return a.length<1?null:(a.push(this.parser.createNodeMesh(t)),Promise.all(a).then(t=>{const e=t.pop(),n=e.isGroup?e.children:[e],r=t[0].count,i=[];for(const t of n){const e=new Ti,n=new br,a=new yr,o=new br(1,1,1),l=new ks(t.geometry,t.material,r);for(let t=0;t<r;t++)s.TRANSLATION&&n.fromBufferAttribute(s.TRANSLATION,t),s.ROTATION&&a.fromBufferAttribute(s.ROTATION,t),s.SCALE&&o.fromBufferAttribute(s.SCALE,t),l.setMatrixAt(t,e.compose(n,a,o));for(const e in s)if("_COLOR_0"===e){const t=s[e];l.instanceColor=new Ds(t.array,t.itemSize,t.normalized)}else"TRANSLATION"!==e&&"ROTATION"!==e&&"SCALE"!==e&&t.geometry.setAttribute(e,s[e]);Zi.prototype.copy.call(l,t),this.parser.assignFinalMaterial(l),i.push(l)}return e.isGroup?(e.clear(),e.add(...i),e):i[0]}))}}const Yu="glTF",Ku=1313821514,Zu=5130562;class $u{constructor(t){this.name=Cu.KHR_BINARY_GLTF,this.content=null,this.body=null;const e=new DataView(t,0,12),n=new TextDecoder;if(this.header={magic:n.decode(new Uint8Array(t.slice(0,4))),version:e.getUint32(4,1),length:e.getUint32(8,1)},this.header.magic!==Yu)throw new Error("THREE.GLTFLoader: Unsupported glTF-Binary header.");if(this.header.version<2)throw new Error("THREE.GLTFLoader: Legacy binary file detected.");const r=this.header.length-12,i=new DataView(t,12);let a=0;for(;a<r;){const e=i.getUint32(a,1);a+=4;const r=i.getUint32(a,1);if(a+=4,r===Ku){const r=new Uint8Array(t,12+a,e);this.content=n.decode(r)}else if(r===Zu){const n=12+a;this.body=t.slice(n,n+e)}a+=e}if(null===this.content)throw new Error("THREE.GLTFLoader: JSON content not found.")}}class Ju{constructor(t,e){if(!e)throw new Error("THREE.GLTFLoader: No DRACOLoader instance provided.");this.name=Cu.KHR_DRACO_MESH_COMPRESSION,this.json=t,this.dracoLoader=e,this.dracoLoader.preload()}decodePrimitive(t,e){const n=this.json,r=this.dracoLoader,i=t.extensions[this.name].bufferView,a=t.extensions[this.name].attributes,s={},o={},l={};for(const t in a){const e=cd[t]||t.toLowerCase();s[e]=a[t]}for(const e in t.attributes){const r=cd[e]||e.toLowerCase();if(void 0!==a[e]){const i=n.accessors[t.attributes[e]],a=ad[i.componentType];l[r]=a.name,o[r]=1==i.normalized}}return e.getDependency("bufferView",i).then(function(t){return new Promise(function(e,n){r.decodeDracoFile(t,function(t){for(const e in t.attributes){const n=t.attributes[e],r=o[e];void 0!==r&&(n.normalized=r)}e(t)},s,l,Xn,n)})})}}class Qu{constructor(){this.name=Cu.KHR_TEXTURE_TRANSFORM}extendTexture(t,e){return void 0!==e.texCoord&&e.texCoord!==t.channel||void 0!==e.offset||void 0!==e.rotation||void 0!==e.scale?(t=t.clone(),void 0!==e.texCoord&&(t.channel=e.texCoord),void 0!==e.offset&&t.offset.fromArray(e.offset),void 0!==e.rotation&&(t.rotation=e.rotation),void 0!==e.scale&&t.repeat.fromArray(e.scale),t.needsUpdate=1,t):t}}class td{constructor(){this.name=Cu.KHR_MESH_QUANTIZATION}}class ed extends Ao{constructor(t,e,n,r){super(t,e,n,r)}copySampleValue_(t){const e=this.resultBuffer,n=this.sampleValues,r=this.valueSize,i=t*r*3+r;for(let t=0;t!==r;t++)e[t]=n[i+t];return e}interpolate_(t,e,n,r){const i=this.resultBuffer,a=this.sampleValues,s=this.valueSize,o=2*s,l=3*s,c=r-e,h=(n-e)/c,u=h*h,d=u*h,p=t*l,f=p-l,m=-2*d+3*u,g=d-u,v=1-m,x=g-u+h;for(let t=0;t!==s;t++){const e=a[f+t+s],n=a[f+t+o]*c,r=a[p+t+s],l=a[p+t]*c;i[t]=v*e+x*n+m*r+g*l}return i}}const nd=new yr;class rd extends ed{interpolate_(t,e,n,r){const i=super.interpolate_(t,e,n,r);return nd.fromArray(i).normalize().toArray(i),i}}const id={FLOAT:5126,FLOAT_MAT3:35675,FLOAT_MAT4:35676,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,LINEAR:9729,REPEAT:10497,SAMPLER_2D:35678,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123},ad={5120:Int8Array,5121:Uint8Array,5122:Int16Array,5123:Uint16Array,5125:Uint32Array,5126:Float32Array},sd={9728:Ie,9729:Fe,9984:Ne,9985:Be,9986:Oe,9987:ke},od={33071:Ue,33648:Le,10497:De},ld={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16},cd={POSITION:"position",NORMAL:"normal",TANGENT:"tangent",TEXCOORD_0:"uv",TEXCOORD_1:"uv1",TEXCOORD_2:"uv2",TEXCOORD_3:"uv3",COLOR_0:"color",WEIGHTS_0:"skinWeight",JOINTS_0:"skinIndex"},hd={scale:"scale",translation:"position",rotation:"quaternion",weights:"morphTargetInfluences"},ud={CUBICSPLINE:void 0,LINEAR:Bn,STEP:Fn},dd="OPAQUE",pd="MASK",fd="BLEND";function md(t){return void 0===t.DefaultMaterial&&(t.DefaultMaterial=new _o({color:16777215,emissive:0,metalness:1,roughness:1,transparent:0,depthTest:1,side:0})),t.DefaultMaterial}function gd(t,e,n){for(const r in n.extensions)void 0===t[r]&&(e.userData.gltfExtensions=e.userData.gltfExtensions||{},e.userData.gltfExtensions[r]=n.extensions[r])}function vd(t,e){void 0!==e.extras&&"object"==typeof e.extras&&Object.assign(t.userData,e.extras)}function xd(t,e){if(t.updateMorphTargets(),void 0!==e.weights)for(let n=0,r=e.weights.length;n<r;n++)t.morphTargetInfluences[n]=e.weights[n];if(e.extras&&Array.isArray(e.extras.targetNames)){const n=e.extras.targetNames;if(t.morphTargetInfluences.length===n.length){t.morphTargetDictionary={};for(let e=0,r=n.length;e<r;e++)t.morphTargetDictionary[n[e]]=e}}}function _d(t){let e;const n=t.extensions&&t.extensions[Cu.KHR_DRACO_MESH_COMPRESSION];if(e=n?"draco:"+n.bufferView+":"+n.indices+":"+yd(n.attributes):t.indices+":"+yd(t.attributes)+":"+t.mode,void 0!==t.targets)for(let n=0,r=t.targets.length;n<r;n++)e+=":"+yd(t.targets[n]);return e}function yd(t){let e="";const n=Object.keys(t).sort();for(let r=0,i=n.length;r<i;r++)e+=n[r]+":"+t[n[r]]+";";return e}function bd(t){switch(t){case Int8Array:return 1/127;case Uint8Array:return 1/255;case Int16Array:return 1/32767;case Uint16Array:return 1/65535;default:throw new Error("THREE.GLTFLoader: Unsupported normalized accessor component type.")}}const Ed=new Ti;class Td{constructor(t={},e={}){this.json=t,this.extensions={},this.plugins={},this.options=e,this.cache=new Au,this.associations=new Map,this.primitiveCache={},this.nodeCache={},this.meshCache={refs:{},uses:{}},this.cameraCache={refs:{},uses:{}},this.lightCache={refs:{},uses:{}},this.sourceCache={},this.textureCache={},this.nodeNamesUsed={};let n=0,r=-1,i=0,a=-1;if("undefined"!=typeof navigator){const t=navigator.userAgent;n=1==/^((?!chrome|android).)*safari/i.test(t);const e=t.match(/Version\/(\d+)/);r=n&&e?parseInt(e[1],10):-1,i=t.indexOf("Firefox")>-1,a=i?t.match(/Firefox\/([0-9]+)\./)[1]:-1}"undefined"==typeof createImageBitmap||n&&r<17||i&&a<98?this.textureLoader=new $o(this.options.manager):this.textureLoader=new gl(this.options.manager),this.textureLoader.setCrossOrigin(this.options.crossOrigin),this.textureLoader.setRequestHeader(this.options.requestHeader),this.fileLoader=new Yo(this.options.manager),this.fileLoader.setResponseType("arraybuffer"),"use-credentials"===this.options.crossOrigin&&this.fileLoader.setWithCredentials(1)}setExtensions(t){this.extensions=t}setPlugins(t){this.plugins=t}parse(t,e){const n=this,r=this.json,i=this.extensions;this.cache.removeAll(),this.nodeCache={},this._invokeAll(function(t){return t._markDefs&&t._markDefs()}),Promise.all(this._invokeAll(function(t){return t.beforeRoot&&t.beforeRoot()})).then(function(){return Promise.all([n.getDependencies("scene"),n.getDependencies("animation"),n.getDependencies("camera")])}).then(function(e){const a={scene:e[0][r.scene||0],scenes:e[0],animations:e[1],cameras:e[2],asset:r.asset,parser:n,userData:{}};return gd(i,a,r),vd(a,r),Promise.all(n._invokeAll(function(t){return t.afterRoot&&t.afterRoot(a)})).then(function(){for(const t of a.scenes)t.updateMatrixWorld();t(a)})}).catch(e)}_markDefs(){const t=this.json.nodes||[],e=this.json.skins||[],n=this.json.meshes||[];for(let n=0,r=e.length;n<r;n++){const r=e[n].joints;for(let e=0,n=r.length;e<n;e++)t[r[e]].isBone=1}for(let e=0,r=t.length;e<r;e++){const r=t[e];void 0!==r.mesh&&(this._addNodeRef(this.meshCache,r.mesh),void 0!==r.skin&&(n[r.mesh].isSkinnedMesh=1)),void 0!==r.camera&&this._addNodeRef(this.cameraCache,r.camera)}}_addNodeRef(t,e){void 0!==e&&(void 0===t.refs[e]&&(t.refs[e]=t.uses[e]=0),t.refs[e]++)}_getNodeRef(t,e,n){if(t.refs[e]<=1)return n;const r=n.clone(),i=(t,e)=>{const n=this.associations.get(t);null!=n&&this.associations.set(e,n);for(const[n,r]of t.children.entries())i(r,e.children[n])};return i(n,r),r.name+="_instance_"+t.uses[e]++,r}_invokeOne(t){const e=Object.values(this.plugins);e.push(this);for(let n=0;n<e.length;n++){const r=t(e[n]);if(r)return r}return null}_invokeAll(t){const e=Object.values(this.plugins);e.unshift(this);const n=[];for(let r=0;r<e.length;r++){const i=t(e[r]);i&&n.push(i)}return n}getDependency(t,e){const n=t+":"+e;let r=this.cache.get(n);if(!r){switch(t){case"scene":r=this.loadScene(e);break;case"node":r=this._invokeOne(function(t){return t.loadNode&&t.loadNode(e)});break;case"mesh":r=this._invokeOne(function(t){return t.loadMesh&&t.loadMesh(e)});break;case"accessor":r=this.loadAccessor(e);break;case"bufferView":r=this._invokeOne(function(t){return t.loadBufferView&&t.loadBufferView(e)});break;case"buffer":r=this.loadBuffer(e);break;case"material":r=this._invokeOne(function(t){return t.loadMaterial&&t.loadMaterial(e)});break;case"texture":r=this._invokeOne(function(t){return t.loadTexture&&t.loadTexture(e)});break;case"skin":r=this.loadSkin(e);break;case"animation":r=this._invokeOne(function(t){return t.loadAnimation&&t.loadAnimation(e)});break;case"camera":r=this.loadCamera(e);break;default:if(r=this._invokeOne(function(n){return n!=this&&n.getDependency&&n.getDependency(t,e)}),!r)throw new Error("Unknown type: "+t)}this.cache.add(n,r)}return r}getDependencies(t){let e=this.cache.get(t);if(!e){const n=this,r=this.json[t+("mesh"===t?"es":"s")]||[];e=Promise.all(r.map(function(e,r){return n.getDependency(t,r)})),this.cache.add(t,e)}return e}loadBuffer(t){const e=this.json.buffers[t],n=this.fileLoader;if(e.type&&"arraybuffer"!==e.type)throw new Error("THREE.GLTFLoader: "+e.type+" buffer type is not supported.");if(void 0===e.uri&&0===t)return Promise.resolve(this.extensions[Cu.KHR_BINARY_GLTF].body);const r=this.options;return new Promise(function(t,i){n.load(fl.resolveURL(e.uri,r.path),t,void 0,function(){i(new Error('THREE.GLTFLoader: Failed to load buffer "'+e.uri+'".'))})})}loadBufferView(t){const e=this.json.bufferViews[t];return this.getDependency("buffer",e.buffer).then(function(t){const n=e.byteLength||0,r=e.byteOffset||0;return t.slice(r,r+n)})}loadAccessor(t){const e=this,n=this.json,r=this.json.accessors[t];if(void 0===r.bufferView&&void 0===r.sparse){const t=ld[r.type],e=ad[r.componentType],n=1==r.normalized,i=new e(r.count*t);return Promise.resolve(new Ta(i,t,n))}const i=[];return void 0!==r.bufferView?i.push(this.getDependency("bufferView",r.bufferView)):i.push(null),void 0!==r.sparse&&(i.push(this.getDependency("bufferView",r.sparse.indices.bufferView)),i.push(this.getDependency("bufferView",r.sparse.values.bufferView))),Promise.all(i).then(function(t){const i=t[0],a=ld[r.type],s=ad[r.componentType],o=s.BYTES_PER_ELEMENT,l=o*a,c=r.byteOffset||0,h=void 0!==r.bufferView?n.bufferViews[r.bufferView].byteStride:void 0,u=1==r.normalized;let d,p;if(h&&h!==l){const t=Math.floor(c/h),n="InterleavedBuffer:"+r.bufferView+":"+r.componentType+":"+t+":"+r.count;let l=e.cache.get(n);l||(d=new s(i,t*h,r.count*h/o),l=new ps(d,h/o),e.cache.add(n,l)),p=new ms(l,a,c%h/o,u)}else d=null===i?new s(r.count*a):new s(i,c,r.count*a),p=new Ta(d,a,u);if(void 0!==r.sparse){const e=ld.SCALAR,n=ad[r.sparse.indices.componentType],o=r.sparse.indices.byteOffset||0,l=r.sparse.values.byteOffset||0,c=new n(t[1],o,r.sparse.count*e),h=new s(t[2],l,r.sparse.count*a);null!==i&&(p=new Ta(p.array.slice(),p.itemSize,p.normalized)),p.normalized=0;for(let t=0,e=c.length;t<e;t++){const e=c[t];if(p.setX(e,h[t*a]),a>=2&&p.setY(e,h[t*a+1]),a>=3&&p.setZ(e,h[t*a+2]),a>=4&&p.setW(e,h[t*a+3]),a>=5)throw new Error("THREE.GLTFLoader: Unsupported itemSize in sparse BufferAttribute.")}p.normalized=u}return p})}loadTexture(t){const e=this.json,n=this.options,r=e.textures[t].source,i=e.images[r];let a=this.textureLoader;if(i.uri){const t=n.manager.getHandler(i.uri);null!==t&&(a=t)}return this.loadTextureImage(t,r,a)}loadTextureImage(t,e,n){const r=this,i=this.json,a=i.textures[t],s=i.images[e],o=(s.uri||s.bufferView)+":"+a.sampler;if(this.textureCache[o])return this.textureCache[o];const l=this.loadImageSource(e,n).then(function(e){e.flipY=0,e.name=a.name||s.name||"",""===e.name&&"string"==typeof s.uri&&0==s.uri.startsWith("data:image/")&&(e.name=s.uri);const n=(i.samplers||{})[a.sampler]||{};return e.magFilter=sd[n.magFilter]||Fe,e.minFilter=sd[n.minFilter]||ke,e.wrapS=od[n.wrapS]||De,e.wrapT=od[n.wrapT]||De,e.generateMipmaps=!e.isCompressedTexture&&e.minFilter!==Ie&&e.minFilter!==Fe,r.associations.set(e,{textures:t}),e}).catch(function(){return null});return this.textureCache[o]=l,l}loadImageSource(t,e){const n=this,r=this.json,i=this.options;if(void 0!==this.sourceCache[t])return this.sourceCache[t].then(t=>t.clone());const a=r.images[t],s=self.URL||self.webkitURL;let o=a.uri||"",l=0;if(void 0!==a.bufferView)o=n.getDependency("bufferView",a.bufferView).then(function(t){l=1;const e=new Blob([t],{type:a.mimeType});return o=s.createObjectURL(e),o});else if(void 0===a.uri)throw new Error("THREE.GLTFLoader: Image "+t+" is missing URI and bufferView");const c=Promise.resolve(o).then(function(t){return new Promise(function(n,r){let a=n;1==e.isImageBitmapLoader&&(a=function(t){const e=new Wr(t);e.needsUpdate=1,n(e)}),e.load(fl.resolveURL(t,i.path),a,void 0,r)})}).then(function(t){var e;return 1==l&&s.revokeObjectURL(o),vd(t,a),t.userData.mimeType=a.mimeType||((e=a.uri).search(/\.jpe?g($|\?)/i)>0||0===e.search(/^data\:image\/jpeg/)?"image/jpeg":e.search(/\.webp($|\?)/i)>0||0===e.search(/^data\:image\/webp/)?"image/webp":e.search(/\.ktx2($|\?)/i)>0||0===e.search(/^data\:image\/ktx2/)?"image/ktx2":"image/png"),t}).catch(function(t){throw t});return this.sourceCache[t]=c,c}assignTexture(t,e,n,r){const i=this;return this.getDependency("texture",n.index).then(function(a){if(!a)return null;if(void 0!==n.texCoord&&n.texCoord>0&&((a=a.clone()).channel=n.texCoord),i.extensions[Cu.KHR_TEXTURE_TRANSFORM]){const t=void 0!==n.extensions?n.extensions[Cu.KHR_TEXTURE_TRANSFORM]:void 0;if(t){const e=i.associations.get(a);a=i.extensions[Cu.KHR_TEXTURE_TRANSFORM].extendTexture(a,t),i.associations.set(a,e)}}return void 0!==r&&(a.colorSpace=r),t[e]=a,a})}assignFinalMaterial(t){const e=t.geometry;let n=t.material;const r=void 0===e.attributes.tangent,i=void 0!==e.attributes.color,a=void 0===e.attributes.normal;if(t.isPoints){const t="PointsMaterial:"+n.uuid;let e=this.cache.get(t);e||(e=new lo,xa.prototype.copy.call(e,n),e.color.copy(n.color),e.map=n.map,e.sizeAttenuation=0,this.cache.add(t,e)),n=e}else if(t.isLine){const t="LineBasicMaterial:"+n.uuid;let e=this.cache.get(t);e||(e=new Ys,xa.prototype.copy.call(e,n),e.color.copy(n.color),e.map=n.map,this.cache.add(t,e)),n=e}if(r||i||a){let t="ClonedMaterial:"+n.uuid+":";r&&(t+="derivative-tangents:"),i&&(t+="vertex-colors:"),a&&(t+="flat-shading:");let e=this.cache.get(t);e||(e=n.clone(),i&&(e.vertexColors=1),a&&(e.flatShading=1),r&&(e.normalScale&&(e.normalScale.y*=-1),e.clearcoatNormalScale&&(e.clearcoatNormalScale.y*=-1)),this.cache.add(t,e),this.associations.set(e,this.associations.get(n))),n=e}t.material=n}getMaterialType(){return _o}loadMaterial(t){const e=this,n=this.json,r=this.extensions,i=n.materials[t];let a;const s={},o=[];if((i.extensions||{})[Cu.KHR_MATERIALS_UNLIT]){const t=r[Cu.KHR_MATERIALS_UNLIT];a=t.getMaterialType(),o.push(t.extendParams(s,i,e))}else{const n=i.pbrMetallicRoughness||{};if(s.color=new ma(1,1,1),s.opacity=1,Array.isArray(n.baseColorFactor)){const t=n.baseColorFactor;s.color.setRGB(t[0],t[1],t[2],Xn),s.opacity=t[3]}void 0!==n.baseColorTexture&&o.push(e.assignTexture(s,"map",n.baseColorTexture,Wn)),s.metalness=void 0!==n.metallicFactor?n.metallicFactor:1,s.roughness=void 0!==n.roughnessFactor?n.roughnessFactor:1,void 0!==n.metallicRoughnessTexture&&(o.push(e.assignTexture(s,"metalnessMap",n.metallicRoughnessTexture)),o.push(e.assignTexture(s,"roughnessMap",n.metallicRoughnessTexture))),a=this._invokeOne(function(e){return e.getMaterialType&&e.getMaterialType(t)}),o.push(Promise.all(this._invokeAll(function(e){return e.extendMaterialParams&&e.extendMaterialParams(t,s)})))}1==i.doubleSided&&(s.side=2);const l=i.alphaMode||dd;if(l===fd?(s.transparent=1,s.depthWrite=0):(s.transparent=0,l===pd&&(s.alphaTest=void 0!==i.alphaCutoff?i.alphaCutoff:.5)),void 0!==i.normalTexture&&a!==_a&&(o.push(e.assignTexture(s,"normalMap",i.normalTexture)),s.normalScale=new _r(1,1),void 0!==i.normalTexture.scale)){const t=i.normalTexture.scale;s.normalScale.set(t,t)}if(void 0!==i.occlusionTexture&&a!==_a&&(o.push(e.assignTexture(s,"aoMap",i.occlusionTexture)),void 0!==i.occlusionTexture.strength&&(s.aoMapIntensity=i.occlusionTexture.strength)),void 0!==i.emissiveFactor&&a!==_a){const t=i.emissiveFactor;s.emissive=(new ma).setRGB(t[0],t[1],t[2],Xn)}return void 0!==i.emissiveTexture&&a!==_a&&o.push(e.assignTexture(s,"emissiveMap",i.emissiveTexture,Wn)),Promise.all(o).then(function(){const n=new a(s);return i.name&&(n.name=i.name),vd(n,i),e.associations.set(n,{materials:t}),i.extensions&&gd(r,n,i),n})}createUniqueName(t){const e=Sl.sanitizeNodeName(t||"");return e in this.nodeNamesUsed?e+"_"+ ++this.nodeNamesUsed[e]:(this.nodeNamesUsed[e]=0,e)}loadGeometries(t){const e=this,n=this.extensions,r=this.primitiveCache;function i(t){return n[Cu.KHR_DRACO_MESH_COMPRESSION].decodePrimitive(t,e).then(function(n){return Sd(n,t,e)})}const a=[];for(let n=0,s=t.length;n<s;n++){const s=t[n],o=_d(s),l=r[o];if(l)a.push(l.promise);else{let t;t=s.extensions&&s.extensions[Cu.KHR_DRACO_MESH_COMPRESSION]?i(s):Sd(new Ia,s,e),r[o]={primitive:s,promise:t},a.push(t)}}return Promise.all(a)}loadMesh(t){const e=this,n=this.json,r=this.extensions,i=n.meshes[t],a=i.primitives,s=[];for(let t=0,e=a.length;t<e;t++){const e=void 0===a[t].material?md(this.cache):this.getDependency("material",a[t].material);s.push(e)}return s.push(e.loadGeometries(a)),Promise.all(s).then(function(n){const s=n.slice(0,n.length-1),o=n[n.length-1],l=[];for(let n=0,c=o.length;n<c;n++){const c=o[n],h=a[n];let u;const d=s[n];if(h.mode===id.TRIANGLES||h.mode===id.TRIANGLE_STRIP||h.mode===id.TRIANGLE_FAN||void 0===h.mode)u=1==i.isSkinnedMesh?new Ms(c,d):new ja(c,d),1==u.isSkinnedMesh&&u.normalizeSkinWeights(),h.mode===id.TRIANGLE_STRIP?u.geometry=wu(u.geometry,1):h.mode===id.TRIANGLE_FAN&&(u.geometry=wu(u.geometry,2));else if(h.mode===id.LINES)u=new so(c,d);else if(h.mode===id.LINE_STRIP)u=new no(c,d);else if(h.mode===id.LINE_LOOP)u=new oo(c,d);else{if(h.mode!==id.POINTS)throw new Error("THREE.GLTFLoader: Primitive mode unsupported: "+h.mode);u=new fo(c,d)}Object.keys(u.geometry.morphAttributes).length>0&&xd(u,i),u.name=e.createUniqueName(i.name||"mesh_"+t),vd(u,i),h.extensions&&gd(r,u,h),e.assignFinalMaterial(u),l.push(u)}for(let n=0,r=l.length;n<r;n++)e.associations.set(l[n],{meshes:t,primitives:n});if(1===l.length)return i.extensions&&gd(r,l[0],i),l[0];const c=new cs;i.extensions&&gd(r,c,i),e.associations.set(c,{meshes:t});for(let t=0,e=l.length;t<e;t++)c.add(l[t]);return c})}loadCamera(t){let e;const n=this.json.cameras[t],r=n[n.type];if(r)return"perspective"===n.type?e=new is(xr.radToDeg(r.yfov),r.aspectRatio||1,r.znear||1,r.zfar||2e6):"orthographic"===n.type&&(e=new hl(-r.xmag,r.xmag,r.ymag,-r.ymag,r.znear,r.zfar)),n.name&&(e.name=this.createUniqueName(n.name)),vd(e,n),Promise.resolve(e)}loadSkin(t){const e=this.json.skins[t],n=[];for(let t=0,r=e.joints.length;t<r;t++)n.push(this._loadNodeShallow(e.joints[t]));return void 0!==e.inverseBindMatrices?n.push(this.getDependency("accessor",e.inverseBindMatrices)):n.push(null),Promise.all(n).then(function(t){const e=t.pop(),n=t,r=[],i=[];for(let t=0,a=n.length;t<a;t++){const a=n[t];if(a){r.push(a);const n=new Ti;null!==e&&n.fromArray(e.array,16*t),i.push(n)}}return new Ps(r,i)})}loadAnimation(t){const e=this.json,n=this,r=e.animations[t],i=r.name?r.name:"animation_"+t,a=[],s=[],o=[],l=[],c=[];for(let t=0,e=r.channels.length;t<e;t++){const e=r.channels[t],n=r.samplers[e.sampler],i=e.target,h=i.node,u=void 0!==r.parameters?r.parameters[n.input]:n.input,d=void 0!==r.parameters?r.parameters[n.output]:n.output;void 0!==i.node&&(a.push(this.getDependency("node",h)),s.push(this.getDependency("accessor",u)),o.push(this.getDependency("accessor",d)),l.push(n),c.push(i))}return Promise.all([Promise.all(a),Promise.all(s),Promise.all(o),Promise.all(l),Promise.all(c)]).then(function(t){const e=t[0],r=t[1],a=t[2],s=t[3],o=t[4],l=[];for(let t=0,i=e.length;t<i;t++){const i=e[t],c=r[t],h=a[t],u=s[t],d=o[t];if(void 0===i)continue;i.updateMatrix&&i.updateMatrix();const p=n._createAnimationTracks(i,c,h,u,d);if(p)for(let t=0;t<p.length;t++)l.push(p[t])}return new zo(i,void 0,l)})}createNodeMesh(t){const e=this.json,n=this,r=e.nodes[t];return void 0===r.mesh?null:n.getDependency("mesh",r.mesh).then(function(t){const e=n._getNodeRef(n.meshCache,r.mesh,t);return void 0!==r.weights&&e.traverse(function(t){if(t.isMesh)for(let e=0,n=r.weights.length;e<n;e++)t.morphTargetInfluences[e]=r.weights[e]}),e})}loadNode(t){const e=this,n=this.json.nodes[t],r=e._loadNodeShallow(t),i=[],a=n.children||[];for(let t=0,n=a.length;t<n;t++)i.push(e.getDependency("node",a[t]));const s=void 0===n.skin?Promise.resolve(null):e.getDependency("skin",n.skin);return Promise.all([r,Promise.all(i),s]).then(function(t){const e=t[0],n=t[1],r=t[2];null!==r&&e.traverse(function(t){t.isSkinnedMesh&&t.bind(r,Ed)});for(let t=0,r=n.length;t<r;t++)e.add(n[t]);return e})}_loadNodeShallow(t){const e=this.json,n=this.extensions,r=this;if(void 0!==this.nodeCache[t])return this.nodeCache[t];const i=e.nodes[t],a=i.name?r.createUniqueName(i.name):"",s=[],o=r._invokeOne(function(e){return e.createNodeMesh&&e.createNodeMesh(t)});return o&&s.push(o),void 0!==i.camera&&s.push(r.getDependency("camera",i.camera).then(function(t){return r._getNodeRef(r.cameraCache,i.camera,t)})),r._invokeAll(function(e){return e.createNodeAttachment&&e.createNodeAttachment(t)}).forEach(function(t){s.push(t)}),this.nodeCache[t]=Promise.all(s).then(function(e){let s;if(s=1==i.isBone?new ws:e.length>1?new cs:1===e.length?e[0]:new Zi,s!==e[0])for(let t=0,n=e.length;t<n;t++)s.add(e[t]);if(i.name&&(s.userData.name=i.name,s.name=a),vd(s,i),i.extensions&&gd(n,s,i),void 0!==i.matrix){const t=new Ti;t.fromArray(i.matrix),s.applyMatrix4(t)}else void 0!==i.translation&&s.position.fromArray(i.translation),void 0!==i.rotation&&s.quaternion.fromArray(i.rotation),void 0!==i.scale&&s.scale.fromArray(i.scale);if(r.associations.has(s)){if(void 0!==i.mesh&&r.meshCache.refs[i.mesh]>1){const t=r.associations.get(s);r.associations.set(s,{...t})}}else r.associations.set(s,{});return r.associations.get(s).nodes=t,s}),this.nodeCache[t]}loadScene(t){const e=this.extensions,n=this.json.scenes[t],r=this,i=new cs;n.name&&(i.name=r.createUniqueName(n.name)),vd(i,n),n.extensions&&gd(e,i,n);const a=n.nodes||[],s=[];for(let t=0,e=a.length;t<e;t++)s.push(r.getDependency("node",a[t]));return Promise.all(s).then(function(t){for(let e=0,n=t.length;e<n;e++)i.add(t[e]);return r.associations=(t=>{const e=new Map;for(const[t,n]of r.associations)(t instanceof xa||t instanceof Wr)&&e.set(t,n);return t.traverse(t=>{const n=r.associations.get(t);null!=n&&e.set(t,n)}),e})(i),i})}_createAnimationTracks(t,e,n,r,i){const a=[],s=t.name?t.name:t.uuid,o=[];let l;switch(hd[i.path]===hd.weights?t.traverse(function(t){t.morphTargetInfluences&&o.push(t.name?t.name:t.uuid)}):o.push(s),hd[i.path]){case hd.weights:l=No;break;case hd.rotation:l=Fo;break;case hd.translation:case hd.scale:l=ko;break;default:if(1===n.itemSize)l=No;else l=ko}const c=void 0!==r.interpolation?ud[r.interpolation]:Bn,h=this._getArrayFromAccessor(n);for(let t=0,n=o.length;t<n;t++){const n=new l(o[t]+"."+hd[i.path],e.array,h,c);"CUBICSPLINE"===r.interpolation&&this._createCubicSplineTrackInterpolant(n),a.push(n)}return a}_getArrayFromAccessor(t){let e=t.array;if(t.normalized){const t=bd(e.constructor),n=new Float32Array(e.length);for(let r=0,i=e.length;r<i;r++)n[r]=e[r]*t;e=n}return e}_createCubicSplineTrackInterpolant(t){t.createInterpolant=function(t){return new(this instanceof Fo?rd:ed)(this.times,this.values,this.getValueSize()/3,t)},t.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline=1}}function Sd(t,e,n){const r=e.attributes,i=[];function a(e,r){return n.getDependency("accessor",e).then(function(e){t.setAttribute(r,e)})}for(const e in r){const n=cd[e]||e.toLowerCase();n in t.attributes||i.push(a(r[e],n))}if(void 0!==e.indices&&!t.index){const r=n.getDependency("accessor",e.indices).then(function(e){t.setIndex(e)});i.push(r)}return Ir.workingColorSpace,vd(t,e),function(t,e,n){const r=e.attributes,i=new Zr;if(void 0===r.POSITION)return;{const t=n.json.accessors[r.POSITION],e=t.min,a=t.max;if(void 0===e||void 0===a)return;if(i.set(new br(e[0],e[1],e[2]),new br(a[0],a[1],a[2])),t.normalized){const e=bd(ad[t.componentType]);i.min.multiplyScalar(e),i.max.multiplyScalar(e)}}const a=e.targets;if(void 0!==a){const t=new br,e=new br;for(let r=0,i=a.length;r<i;r++){const i=a[r];if(void 0!==i.POSITION){const r=n.json.accessors[i.POSITION],a=r.min,s=r.max;if(void 0!==a&&void 0!==s){if(e.setX(Math.max(Math.abs(a[0]),Math.abs(s[0]))),e.setY(Math.max(Math.abs(a[1]),Math.abs(s[1]))),e.setZ(Math.max(Math.abs(a[2]),Math.abs(s[2]))),r.normalized){const t=bd(ad[r.componentType]);e.multiplyScalar(t)}t.max(e)}}}i.expandByVector(t)}t.boundingBox=i;const s=new fi;i.getCenter(s.center),s.radius=i.min.distanceTo(i.max)/2,t.boundingSphere=s}(t,e,n),Promise.all(i).then(function(){return void 0!==e.targets?function(t,e,n){let r=0,i=0,a=0;for(let t=0,n=e.length;t<n;t++){const n=e[t];if(void 0!==n.POSITION&&(r=1),void 0!==n.NORMAL&&(i=1),void 0!==n.COLOR_0&&(a=1),r&&i&&a)break}if(!r&&!i&&!a)return Promise.resolve(t);const s=[],o=[],l=[];for(let c=0,h=e.length;c<h;c++){const h=e[c];if(r){const e=void 0!==h.POSITION?n.getDependency("accessor",h.POSITION):t.attributes.position;s.push(e)}if(i){const e=void 0!==h.NORMAL?n.getDependency("accessor",h.NORMAL):t.attributes.normal;o.push(e)}if(a){const e=void 0!==h.COLOR_0?n.getDependency("accessor",h.COLOR_0):t.attributes.color;l.push(e)}}return Promise.all([Promise.all(s),Promise.all(o),Promise.all(l)]).then(function(e){const n=e[0],s=e[1],o=e[2];return r&&(t.morphAttributes.position=n),i&&(t.morphAttributes.normal=s),a&&(t.morphAttributes.color=o),t.morphTargetsRelative=1,t})}(t,e.targets,n):t})}class Md extends D{features=new Set([C.DefaultAudioFilters,C.DefaultPostProcess,C.EnableAudioAnalyzer,C.EnablePostProcess,C.DefaultOnRender]);scene;camera;threeRenderer;renderTarget;constructor(t){super(t)}initPreCompile(){super.initPreCompile()}init(){super.init(),gu(this.context),this.context.saveState(),this.scene=new ds,this.camera=new is(75,this.renderer.options.width/this.renderer.options.height,.1,1e3),this.threeRenderer=new cu({context:this.renderer.context,alpha:1,canvas:this.renderer.options.canvas}),this.threeRenderer.setClearColor(new ma(16777215)),this.threeRenderer.setClearAlpha(1);const t=new Ya(1,1,1),e=new _a({color:16776960}),n=new ja(t,e);this.camera.position.z=2,this.camera.position.x=3,this.camera.position.y=4,this.camera.lookAt(new br(0,0,0));new pl(new ma(16748592));const r=new cl(new ma(16777215),10,0,1);r.position.set(3,10,3),this.scene.add(r);this.postProcessing.As();this.addCurve(new p(0,0,0,h.RELATIVE),new p(12,0,0,h.RELATIVE),t=>{n.position.y=Math.sin(10*t),this.camera.position.x=4*Math.sin(10*t),this.camera.position.z=4*Math.cos(10*t),this.camera.lookAt(new br(0,0,0))});const i=new Su;i.setDecoderPath("jsm/libs/draco/gltf/");const a=new Ru,s=[];a.setDRACOLoader(i),a.load("ant.png",t=>{const e=t.scene.children[0];e.material=new _o({color:16748592}),this.scene.add(t.scene);for(let t=0;t<16;t++)for(let n=0;n<16;n++){const r=e.clone();this.scene.add(r),r.position.z=15*n,r.position.x=15*t+(n%2==0?7.5:0),s.push(e.clone())}}),this.context.saveState(),this.renderTarget=new qr(this.renderer.options.width,this.renderer.options.height,{internalFormat:"RGBA16F",format:Je,type:je}),this.threeRenderer.setRenderTarget(this.renderTarget),this.threeRenderer.render(this.scene,this.camera),this.context.restoreState()}start(t,e){super.start(t,e)}update(t){super.update(t)}render(t,e,n){super.render(t,e,n),this.context.saveState(),this.threeRenderer.resetState(),this.threeRenderer.setRenderTarget(this.renderTo),this.threeRenderer.render(this.scene,this.camera),this.context.restoreState()}createRenderTarget(){return this.renderTarget}getRTWebglTexture(){return this.threeRenderer.properties.get(this.renderTarget.texture).__webglTexture}}class wd{points;weights=[];constructor(t){this.update(t)}update(t){this.points=t;let e=t[0];const n=[];let r=0;for(let i=1;i<t.length;i++){const a=t[i],s=[];for(let t=0;t<a.length;t++)s[t]=a[t]-e[t];const o=Math.sqrt(s.map(t=>t*t).reduce((t,e)=>t+e));r+=o,n.push(o),e=a}n.forEach(t=>{this.weights.push(t/r)})}evaluate(t,e){t=n.clamp(0,1,t);const r=(this.points.length-1)*t,i=Math.floor(r),a=r-i,s=this.points[0===i?i:i-1],o=this.points[i],l=this.points[i>this.points.length-2?this.points.length-1:i+1],c=this.points[i>this.points.length-3?this.points.length-3:i+2];e||(e=[]);for(let t=0;t<s.length;t++)e[t]=this.catMullRom(a,s[t],o[t],l[t],c[t]);return e}catMullRom(t,e,n,r,i){const a=.5*(r-e),s=.5*(i-n),o=t*t;return(2*n-2*r+a+s)*(t*o)+(-3*n+3*r-2*a-s)*o+a*t+n}evaluateStaticSpeed(t,e){let n=0,r=this.weights[0];for(;r<t;)n++,r+=this.weights[n];const i=this.weights[n],a=1/this.weights.length,s=t>=1?t:n*a+(t-(r-i))/i*a;return this.evaluate(s,e)}}class Rd extends Lt{features=new Set([C.DefaultAudioFilters,C.DefaultPostProcess,C.EnableAudioAnalyzer,C.EnablePostProcess,C.DefaultOnRender]);timeU;cameraU;targetU;fovU;skyColorU;lightPosU;lightColU;ambienceU;cubeposU;axeposU;axerotU;axepos2U;axerot2U;axepos3U;axerot3U;fractalposU;meltU;dartposU;dartrotU;dartpos2U;dartrot2U;dartpos3U;dartrot3U;greetIntensityU;imgindex=1;textureLocations=[];constructor(t){super(t,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nlayout(location = 0) out vec4 outColor;\r\n\r\nuniform sampler2D wallRoughness;\r\nuniform sampler2D wallDisplacement;\r\nuniform sampler2D wallDiffuse;\r\nuniform sampler2D grassHeight;\r\nuniform sampler2D greets;\r\nuniform sampler2D skyTex;\r\n\r\nuniform vec2 resolution;\r\nuniform float time;\r\nuniform float fov;\r\nuniform vec3 camera;\r\nuniform vec3 target;\r\nuniform vec3 light1;\r\nuniform vec3 lightCol;\r\nuniform vec3 cubepos;\r\nuniform vec3 axepos;\r\nuniform vec3 axerot;\r\nuniform vec3 axepos2;\r\nuniform vec3 axerot2;\r\nuniform vec3 axepos3;\r\nuniform vec3 axerot3;\r\nuniform vec3 dartpos;\r\nuniform vec3 dartrot;\r\nuniform vec3 dartpos2;\r\nuniform vec3 dartrot2;\r\nuniform vec3 dartpos3;\r\nuniform vec3 dartrot3;\r\n\r\nuniform vec3 cuberot;\r\nuniform float ambience;\r\n\r\nuniform float fractalAmount;\r\nuniform float meltAmount;\r\nuniform float greetintensity;\r\n\r\nconst float PI2 = 6.28318530717;\r\nconst float PI = 3.14159265359;\r\nconst float PHI = 1.61803398874;\r\nconst vec3 V3Z = vec3(0.);\r\nstruct O\r\n{\r\n    // Distance the ray has travelled to the object\r\n    float dist;\r\n    // Material of the object\r\n    float mat;\r\n    // The position of the object in 3d space\r\n    vec3 pos;\r\n};\r\n\r\nstruct MarchResult{\r\n   // Object the marching hits.\r\n   O O;\r\n   // How many steps did the march take.\r\n   int steps;\r\n   // The position in world for march.\r\n   vec3 worldPosition;\r\n   // Normal for the object surface.\r\n   vec3 normal;\r\n   // How much did the ray travel.\r\n   float travel;\r\n};\r\n\r\n// Point rotations\r\nvec3 RotPointX(vec3 p, float d) {\r\n    mat4 rotM= mat4(1.0, 0.0, 0.0, 0.0, \r\n                    0.0, cos(d), -sin(d), 0.0, \r\n                    0.0, sin(d), cos(d), 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\nvec3 RotPointY(vec3 p, float d) {\r\n    mat4 rotM= mat4(cos(d), 0.0, sin(d), 0.0, \r\n                    0.0, 1.0, 0.0, 0.0,\r\n                    -sin(d), 0.0, cos(d), 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\nvec3 RotPointZ(vec3 p, float d) {\r\n    mat4 rotM= mat4(cos(d), -sin(d), 0.0, 0.0, \r\n                    sin(d), cos(d), 0.0, 0.0, \r\n                    0.0, 0.0, 1.0, 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\n\r\n// Matrix rotations.\r\nmat3 RotX(float a)\r\n{\r\n    return mat3(\r\n        1.0, 0.0, 0.0, \r\n        0.0, cos(a), -sin(a), \r\n        0.0, sin(a), cos(a)\r\n    );\r\n}\r\nmat3 RotY(float a)\r\n{\r\n    return mat3(\r\n        cos(a), 0.0, sin(a), \r\n        0.0, 1.0, 0.0, \r\n        -sin(a), 0.0, cos(a)\r\n    );\r\n}\r\nmat3 RotZ(float a)\r\n{\r\n    return mat3(\r\n        cos(a), -sin(a), 0.0, \r\n        sin(a), cos(a), 0.0, \r\n        0.0, 0.0, 1.0\r\n    );\r\n}\r\nmat3 Rot(float x,float y,float z)\r\n{\r\n    float xca = cos(x);\r\n    float xsa = sin(x);\r\n    float yca = cos(y);\r\n    float ysa = sin(y);\r\n    float zca = cos(z);\r\n    float zsa = sin(z);\r\n    \r\n    return mat3( \r\n        1.0, 0.0, 0.0,\r\n        0.0, xca, -xsa,\r\n        0.0, xsa, xca\r\n    ) * \r\n    mat3(\r\n        yca, 0.0, ysa,\r\n        0.0, 1.0, 0.0,\r\n        -ysa, 0.0, yca\r\n    ) * \r\n    mat3(\r\n        yca, -ysa, 0.0,\r\n        ysa, yca, 0.0,\r\n        0.0, 0.0, 1.0\r\n    );\r\n}\r\n\r\n// Rotation around fixed axis\r\nmat3 RotationMatrix(vec3 axis, float angle)\r\n{\r\n    axis = normalize(axis);\r\n    float s = sin(angle);\r\n    float c = cos(angle);\r\n    float oc = 1.0 - c;\r\n    \r\n    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,\r\n                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,\r\n                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);\r\n}\r\n/** Create a rotation matrix */\r\nmat2 Rot2D( float a )\r\n{\r\n    return mat2( cos(a), -sin(a), sin(a), cos(a) );\r\n}\r\n\r\n/** Rotate a vector with angle */\r\nvec2 Rot2DPoint( vec2 p, float a )\r\n{\r\n    return Rot2D(a) * p;\r\n}\r\n\r\nfloat HexPrism( vec3 p, vec2 h )\r\n{\r\n  const vec3 k = vec3(-0.8660254, 0.5, 0.57735);\r\n  p = abs(p);\r\n  p.xy -= 2.0*min(dot(k.xy, p.xy), 0.0)*k.xy;\r\n  vec2 d = vec2(\r\n       length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x), h.x))*sign(p.y-h.x),\r\n       p.z-h.y );\r\n  return min(max(d.x,d.y),0.0) + length(max(d,0.0));\r\n}\r\nfloat Ground(vec3 position, float height)\r\n{\r\n    return position.y - height;\r\n}\r\nfloat Sphere( vec3 pos, float radius )\r\n{\r\n    return length(pos) - radius;\r\n}\r\nfloat CappedCylinder( vec3 p, float h, float r )\r\n{\r\n  vec2 d = abs(vec2(length(p.xz),p.y)) - vec2(h,r);\r\n  return min(max(d.x,d.y),0.0) + length(max(d,0.0));\r\n}\r\nfloat CappedCone( vec3 p, float h, float r1, float r2 )\r\n{\r\n  vec2 q = vec2( length(p.xz), p.y );\r\n  vec2 k1 = vec2(r2,h);\r\n  vec2 k2 = vec2(r2-r1,2.0*h);\r\n  vec2 ca = vec2(q.x-min(q.x,(q.y<0.0)?r1:r2), abs(q.y)-h);\r\n  vec2 cb = q - k1 + k2*clamp( dot(k1-q,k2)/dot(k2,k2), 0.0, 1.0 );\r\n  float s = (cb.x<0.0 && ca.y<0.0) ? -1.0 : 1.0;\r\n  return s*sqrt( min(dot(ca,ca),dot(cb,cb)) );\r\n}\r\nfloat RoundBox( vec3 p, vec3 b, float r )\r\n{\r\n  vec3 d = abs(p) - b;\r\n  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0)) - r;\r\n}\r\n// Union of two objects with support for material mixing\r\nO Union(O a, O b){\r\n    float s = step(b.dist, a.dist);\r\n    return O( mix(a.dist, b.dist, s),\r\n                       mix(a.mat, b.mat, s),\r\n                       mix(a.pos, b.pos, s));\r\n}\r\nO Sub(O a, O b){\r\n    float s = step(-b.dist, a.dist);\r\n    return O( mix(-a.dist, b.dist, s),\r\n              mix(a.mat, b.mat, s),\r\n              mix(a.pos, b.pos, s));\r\n}\r\nvec3 Repeat( vec3 p, vec3 c)\r\n{\r\n    vec3 q = vec3(0.);\r\n    vec3 q2 = mod(p+0.5*c,c)-0.5*c;\r\n    q.x = c.x > 0. ? q2.x : p.x;\r\n    q.y = c.y > 0. ? q2.y : p.y;\r\n    q.z = c.z > 0. ? q2.z : p.z;\r\n    return q;\r\n}\r\nO SmoothUnion(O a, O b, float k)\r\n{\r\n \tfloat h = clamp(0.5 + 0.5 * (b.dist-a.dist)/k, 0.0, 1.0);\r\n    //return mix( b,a,h) - k*h*(1.0-h);\r\n    float dist =mix(b.dist, a.dist, h) - k*h*(1.0-h);\r\n    float s = step(b.dist, a.dist);\r\n    return O( dist,\r\n              mix(a.mat, b.mat, s),\r\n              mix(a.pos, b.pos, s));\r\n}\r\nfloat SmoothUnion(float a, float b, float k)\r\n{\r\n \tfloat h = clamp(0.5 + 0.5 * (b-a)/k, 0.0, 1.0);\r\n    //return mix( b,a,h) - k*h*(1.0-h);\r\n    float dist =mix(b, a, h) - k*h*(1.0-h);\r\n    return dist;\r\n}\r\n#define HASHSCALE1 .1031\r\nfloat Hash(float p)\r\n{\r\n\tvec3 p3  = fract(vec3(p) * HASHSCALE1);\r\n    p3 += dot(p3, p3.yzx + 19.19);\r\n    return fract((p3.x + p3.y) * p3.z);\r\n}\r\n\r\n\r\n/** CONSTANTS **/\r\nconst float STEP = 0.001;\r\nconst float VOLUMETRIC_STEP = 0.01;\r\nconst float MAXDIST = 100.;\r\n\r\n/** MATERIALS **/\r\nconst float WALL = 0.0;\r\nconst float BOARD = 1.0;\r\nconst float DART_TIP = 2.0;\r\nconst float DART_BODY = 3.0;\r\nconst float DART_WING = 4.0;\r\nconst float AXE_BODY = 5.0;\r\nconst float AXE_BLADE = 6.0;\r\nconst float AXE_WEDGE = 7.0;\r\nconst float GROUND = 8.0;\r\nconst float SKY = 9.0;\r\n\r\nvec3 volumetric = vec3(0.0);\r\n\r\n// fbm with gyroid as noise generator\r\nfloat gyroid (vec3 seed) { return dot(cos(seed),sin(seed.zxy)); }\r\nfloat fbm(vec3 p)\r\n{\t\r\n\tfloat t = 0.;\r\n    float a = .5;\r\n    for (int i = 0; i < 8; ++i) {\r\n        // each iteration creates a smaller effect. Travelling in any direction provides animated value from gyroid\r\n        p.z -= (t*0.1);\r\n        // the actual distance\r\n        t += abs(gyroid(p/a))*a;\r\n        // making sure next step is treated as smaller traverse\r\n        a *= .5;\r\n    }\r\n    return t;\r\n}\r\n\r\n\r\n/*************\r\n*** CAMERA ***\r\n*************/\r\nvec3 getCameraRayDir(vec2 uv, vec3 pos, vec3 target, float fov)\r\n{\r\n    vec3 forward = normalize( target - pos );\r\n    vec3 right = normalize(cross(vec3(0., 1.0, 0.), forward));\r\n    vec3 up = normalize(cross(forward,right));\r\n    return normalize( uv.x * right + uv.y * up + forward * fov);\r\n}\r\n\r\nO mapAxe(vec3 pos){\r\n\r\n    // temp shift\r\n    //pos += vec3(0., -1., 0.);\r\n\r\n    // siirretään painopistettä alaspäin siirtämällä kädensijaa alaspäin, jotta rotatoituu oikeasta kohtaa\r\n\r\n    // shaft\r\n    float shaftD = CappedCylinder(pos+vec3(0., 0.6, 0.), .05, 0.8);\r\n\r\n    // sharp part\r\n    float sD = RoundBox(pos + vec3(0.1, 0., 0.), vec3(.1, .1, 0.01), 0.01);\r\n    sD = SmoothUnion(sD, RoundBox(pos + vec3(0.3, 0., 0.), vec3(.1, .3, 0.01),0.0), 0.1);\r\n    \r\n    O shaft = O(shaftD, AXE_BODY, pos);\r\n    O sharp = O(sD, AXE_BLADE, pos);\r\n    return SmoothUnion(shaft, sharp, 0.1);\r\n}\r\n\r\nO mapDart(vec3 pos){\r\n\r\nfloat size = 2.0;\r\n    float bodyD = CappedCylinder(pos+vec3(0.), .01*size, 0.1*size);\r\n\r\n    float tip = CappedCone(pos+vec3(0.0,0.18,0.0)*size, 0.1*size, 0.0, 0.01*size);\r\n\r\n    float wing1 = RoundBox(pos+vec3(0.0,-0.14,0.0)*size, vec3(0.05,0.05, 0.0005)*size, 0.0001);\r\n    float wing2 = RoundBox(pos+vec3(0.0,-0.14,0.0)*size, vec3(0.0005,0.05, 0.05)*size, 0.0001);\r\n    wing1 = min(wing1,wing2);\r\n\r\n    O Body = O(bodyD, DART_BODY, pos);\r\n    O Tip = O(tip, DART_TIP, pos);\r\n    O Wing = O(wing1, DART_WING, pos);\r\n    return SmoothUnion( SmoothUnion(Body, Tip, 0.01), Wing, 0.01);\r\n}\r\n\r\nO wall( vec3 pos)\r\n{\r\n    float g = RoundBox(pos+vec3(0.0,1.4,0.0), vec3(3.2,1.2,2.2), 0.2);\r\n    // Bounding box\r\n    //if(g>0.01) return O(g, WALL,pos);\r\n    // Actual march\r\n    // float offset = texture(wallRoughness, pos.xz).r;\r\n    // float displacement = texture(wallDisplacement, pos.xz).r;\r\n    return O( g , WALL, pos);\r\n}\r\n\r\nO ground(vec3 pos)\r\n{\r\n    float g = RoundBox(pos+vec3(0.0,2.745,0.0), vec3(100.0,0.1,100.0), 0.2);\r\n\r\n    return O( g , GROUND, pos);\r\n}\r\n\r\n// Scene mapping method \r\nO map( vec3 pos )\r\n{\r\n    O grnd = ground(pos);\r\n    pos *= RotX(PI*0.5);\r\n    \r\n  /*  float id = floor( (pos.z+7.5)/15.0);\r\n    pos += vec3(id*7.5, 0.0,0.0);\r\n    pos += letkisPos;\r\n    pos = Repeat(pos, vec3(10.0, 15.0, 0.0));\r\n    \r\n\r\n    */\r\n    //    pos *= RotX(letkisRot.x)*RotY(letkisRot.y)*RotZ(letkisRot.z);\r\n    vec3 cubePos = (pos + cubepos);\r\n    \r\n    O cube = O( CappedCylinder( \r\n        cubePos, \r\n        1.0, 0.025\r\n        ), BOARD, cubePos);\r\n    \r\n    O result = SmoothUnion( wall(pos), cube, meltAmount);\r\n    result = SmoothUnion(result, mapAxe( (pos+axepos)*RotX(axerot.x)*RotY(axerot.y)*RotZ(axerot.z) ), meltAmount);\r\n    result = SmoothUnion(result, mapAxe( (pos+axepos2)*RotX(axerot2.x)*RotY(axerot2.y)*RotZ(axerot2.z) ), meltAmount);\r\n    result = SmoothUnion(result, mapAxe( (pos+axepos3)*RotX(axerot3.x)*RotY(axerot3.y)*RotZ(axerot3.z) ), meltAmount);\r\n    \r\n    result = SmoothUnion(result, mapDart( (pos+dartpos)*RotX(dartrot.x)*RotY(dartrot.y)*RotZ(dartrot.z) ), meltAmount);\r\n    result = SmoothUnion(result, mapDart( (pos+dartpos2)*RotX(dartrot2.x)*RotY(dartrot2.y)*RotZ(dartrot2.z) ), meltAmount);\r\n    result = SmoothUnion(result, mapDart( (pos+dartpos3)*RotX(dartrot3.x)*RotY(dartrot3.y)*RotZ(dartrot3.z) ), meltAmount);\r\n    \r\n    \r\n    result = SmoothUnion(result, grnd, meltAmount);\r\n    \r\n    /*\r\n    float spDist = -Sphere(pos, 10.);\r\n    \r\n    float ndf = min(spDist, result.dist);\r\n    if(ndf < result.dist){\r\n        result = O(spDist, SKY, pos);\r\n    }\r\n    */\r\n\r\n    if(fractalAmount > 0.0){\r\n        float s = 1.;\r\n        float dist = result.dist;\r\n        for(int m = 0; m < 3; m++){\r\n            // scale smaller\r\n            vec3 a = mod( pos*s, 2.0 )-1.0;\r\n            s *= 3.;\r\n            vec3 r = abs(1.0 - 3.0*abs(a));\r\n\r\n            float da = max(r.x,r.y)/fractalAmount;\r\n        float db = max(r.y,r.z)/fractalAmount;\r\n        float dc = max(r.z,r.x)/fractalAmount;\r\n        float c = (min(da,min(db,dc))-1.0)/s;\r\n            if(c > dist){\r\n                dist = max(c,dist);\r\n            }\r\n    }\r\n    result.dist = dist;\r\n}\r\n    \r\n    return result;\r\n}\r\n\r\n// Requires hash.fs to be included\r\n\r\nvec3 RandomSphereDir(vec2 rnd)\r\n{\r\n\tfloat s = rnd.x*PI*2.;\r\n\tfloat t = rnd.y*2.-1.;\r\n\treturn vec3(sin(s), cos(s), t) / sqrt(1.0 + t * t);\r\n}\r\nvec3 RandomHemisphereDir(vec3 dir, float i)\r\n{\r\n\tvec3 v = RandomSphereDir( vec2(Hash(i+1.), Hash(i+2.)) );\r\n\treturn v * sign(dot(v, dir));\r\n}\r\n\r\nfloat AmbientOcclusion( in vec3 p, in vec3 n, in float maxDist, in float falloff )\r\n{\r\n\tconst int nbIte = 32;\r\n    const float nbIteInv = 1./float(nbIte);\r\n    const float rad = 1.-1.*nbIteInv; //Hemispherical factor (self occlusion correction)\r\n    \r\n\tfloat ao = 0.0;\r\n    \r\n    for( int i=0; i<nbIte; i++ )\r\n    {\r\n        float l = Hash(float(i))*maxDist;\r\n        vec3 rd = normalize(n+RandomHemisphereDir(n, l )*rad)*l; // mix direction with the normal\r\n        \t\t\t\t\t\t\t\t\t\t\t\t\t    // for self occlusion problems!\r\n        \r\n        ao += (l - max(map( p + rd ).dist,0.)) / maxDist * falloff;\r\n    }\r\n\t\r\n    return clamp( 1.-ao*nbIteInv, 0., 1.);\r\n}\r\n\r\n\r\n// Calculates the surface normal\r\nvec3 CalcNormal( vec3 pos)\r\n{\r\n    float c = map(pos).dist;\r\n    vec2 e = vec2(0.001, 0.0);\r\n    return normalize( vec3( map( pos + e.xyy).dist,\r\n                            map( pos + e.yxy).dist,\r\n                            map( pos + e.yyx).dist) -c);\r\n}\r\n\r\nvec3 Diffuse( vec3 pos, vec3 light, vec3 normal )\r\n{\r\n    float dotNL = max(dot( normal, normalize(light - pos)), 0.0);\r\n    return vec3(1.) * dotNL;\r\n}\r\n\r\n\r\n/**\r\n * Main raymarch function for main image & reflections. \r\n */\r\nMarchResult raymarch(vec3 cam, vec3 rd){\r\n    float t = 0.0;\r\n    vec3 col = vec3(0.);\r\n    O res;\r\n    int steps = 0;\r\n    vec3 p = vec3(0.);\r\n    vec4 sum = vec4(0.);\r\n    for( int i = 0; i < 256; i++)\r\n    {\r\n        p = cam + rd*t;\r\n        res = map( p );\r\n        t+= res.mat < 10.0 ? res.dist : max(VOLUMETRIC_STEP, res.dist-VOLUMETRIC_STEP);\r\n        if(res.mat >= 10.0 && res.dist <VOLUMETRIC_STEP)// Materials over 10 are volumetric.\r\n        {\r\n            volumetric += vec3(10.9,10.6,10.55)*VOLUMETRIC_STEP;\r\n        }\r\n        else if(res.dist < STEP ) \r\n        {\r\n            // Ray trace hit an object\r\n            break;\r\n        }\r\n        if(t > MAXDIST) {\r\n            res.mat = -1.;\r\n            t = MAXDIST;\r\n            break;\r\n        }\r\n     /*\r\n        vec3 psmoke = p;\r\n        psmoke.y -= time;\r\n        psmoke.x += sin(time*.05);\r\n        psmoke.z += cos(time*.1);\r\n        float fbm = fbm(psmoke);\r\n        sum += fbm*vec4(1.)*0.05*smoothstep(10.,20.,t);       \r\n        */ \r\n        steps++;\r\n    }\r\n    MarchResult mr = MarchResult(res, steps, p, vec3(0), t);\r\n    // Only calculate normals if result material is [0,9]. Negative materials are skyhits, over 10 are volumetric\r\n    if(res.mat > -0.5 && res.mat < 9.5){\r\n        mr.normal = CalcNormal(mr.worldPosition);\r\n    }\r\n//    sum.rgb = clamp(sum.rgb, vec3(0.), vec3(0.8));\r\n//    volumetric = sum.rgb;\r\n    \r\n    return mr;\r\n}\r\n\r\nconst float STEP_LOW = 0.01;\r\n/**\r\n * Lower quality raymarch. Use for shadows etc. \r\n * Does not support volumetric materials.\r\n */\r\nMarchResult raymarchLow(vec3 cam, vec3 rd, float maxdist, float exclude){\r\n    float t = 0.0;\r\n    vec3 col = vec3(0.);\r\n    O res;\r\n    int steps = 0;\r\n    vec3 p = vec3(0.);\r\n    float minval = 1.0;\r\n    for( int i = 0; i < 256; i++)\r\n    {\r\n        p = cam + rd*t;\r\n        res = map( p );\r\n        t+= max(STEP_LOW,res.dist);\r\n        // Only calculate how close the ray was to solid object.\r\n        if(res.mat < 8.5 && res.mat >0.5 && length(res.mat-exclude)>0.25)\r\n        {\r\n            minval = min(minval, res.dist);\r\n        }\r\n        \r\n        if(res.dist < STEP_LOW && res.mat < 8.5 && res.mat >-0.5 ) \r\n        {\r\n            // Ray trace hit an object\r\n            break;\r\n        }\r\n        if(t > maxdist) {\r\n            res.mat = -1.;\r\n            t = maxdist;\r\n            break;\r\n        }\r\n        \r\n        steps++;\r\n    }\r\n    if(steps >=256) res.mat = -1.0;\r\n    p.x = minval;\r\n    MarchResult mr = MarchResult(res, steps, p, vec3(0), t);\r\n    \r\n    return mr;\r\n}\r\n\r\nvoid colorize(MarchResult result, vec3 rayDir, out vec3 col){\r\n    // Black bg\r\n    vec3 p = result.worldPosition;\r\n    vec3 op = result.O.pos;\r\n    vec3 normal = result.normal;\r\n    col = vec3(0.);\r\n    float shadowExclude  = -1.;\r\n    if(result.O.mat < -0.5)\r\n    {\r\n        //Skydome\r\n    }\r\n    else if (result.O.mat < WALL+0.5) \r\n    {\r\n        // Ground\r\n        vec3 color = texture(wallDiffuse, op.xz).rgb;\r\n        vec3 greets = texture(greets, op.xz*0.35*Rot2D(0.38)).rgb;\r\n        color+=greets*greetintensity;\r\n        col = color * ( ambience \r\n                        \r\n                      ) + lightCol * Diffuse(p, light1, normal) *0.2;\r\n       \r\n     \r\n        // Shadow calculate\r\n        shadowExclude = WALL;\r\n    }\r\n    else if(result.O.mat < BOARD+0.5)\r\n    {\r\n        vec3 color = vec3(1.0,0.5,0.0);/// ${color1};\r\n        \r\n        col = mix(\r\n            vec3(0.9), \r\n            vec3(0.2), \r\n            step( mod(length(op.xz)*10.0, 2.0),1.0)\r\n        );\r\n        if(length(op.xz)<0.1) col = vec3(1.0,0.0,0.0);\r\n        else if(length(op.xz)>0.98) col = vec3(0.6, 0.55, 0.7);\r\n        col = col * ( ambience + \r\n                        lightCol * Diffuse(p, light1, normal)\r\n                      );\r\n\r\n        shadowExclude = BOARD;\r\n        \r\n    }\r\n    else if(result.O.mat < DART_TIP+0.5)\r\n    {\r\n        vec3 color = vec3(0.8,0.78,0.85);/// ${color1};\r\n        col = color * ( ambience + \r\n                        lightCol * Diffuse(p, light1, normal)\r\n                      );\r\n        \r\n        shadowExclude = AXE_BODY;\r\n    }\r\n    else if(result.O.mat < DART_BODY+0.5)\r\n    {\r\n        // Cube\r\n        vec3 color = vec3(1.4,0.5,0.1);/// ${color1};\r\n        col = color * ( ambience + \r\n                        lightCol * Diffuse(p, light1, normal)\r\n                      );\r\n        \r\n        shadowExclude = AXE_BODY;\r\n    }\r\n    else if(result.O.mat < DART_WING+0.5)\r\n    {\r\n        // Cube   \r\n        vec3 color = vec3(0.4,0.9,1.1);/// ${color1};\r\n        col = color * ( ambience + \r\n                        lightCol * Diffuse(p, light1, normal)\r\n                      );\r\n        \r\n        shadowExclude = AXE_BODY;\r\n    }\r\n    \r\n    \r\n    else if(result.O.mat < AXE_BODY+0.5)\r\n    {\r\n        // Cube\r\n        vec3 color = vec3(0.4,0.25,0.1);/// ${color1};\r\n        col = color * ( ambience + \r\n                        lightCol * Diffuse(p, light1, normal)\r\n                      );\r\n        \r\n        shadowExclude = AXE_BODY;\r\n    }\r\n    else if(result.O.mat < AXE_BLADE+0.5)\r\n    {\r\n        // Cube\r\n        vec3 color = vec3(0.7,0.7,0.75);/// ${color1};\r\n        col = color * ( ambience + \r\n                        lightCol * Diffuse(p, light1, normal)\r\n                      );\r\n        \r\n        // Reflect\r\n        vec3 refCol = vec3(0.0);\r\n        vec3 refRd = reflect( rayDir, normal );\r\n        MarchResult reflectMarch = raymarch( p+normal*STEP_LOW, refRd );\r\n        vec3 Rp = reflectMarch.worldPosition;\r\n        vec3 Rnormal = reflectMarch.normal;\r\n        \r\n        if(reflectMarch.O.mat < -0.5)\r\n        { \r\n            //SKydome\r\n            \r\n        } \r\n        else if(reflectMarch.O.mat < WALL+0.5)\r\n        {\r\n            // Ground\r\n            vec3 color = texture(wallDiffuse, Rp.xy).rgb;\r\n            \r\n            refCol = color * ( ambience + \r\n                            lightCol * Diffuse(Rp, light1, Rnormal)\r\n                        );\r\n        }\r\n        else if(reflectMarch.O.mat < BOARD+0.5)\r\n        {\r\n            vec3 color = vec3(1.0,0.5,0.0);/// ${color1};\r\n            refCol = color * ( ambience + \r\n                            lightCol * Diffuse(Rp, light1, Rnormal)\r\n                        );\r\n            refCol = mix(\r\n                vec3(0.9), \r\n                vec3(0.2), \r\n                step( mod(length(p.xy)*10.0, 2.0),1.0)\r\n            );\r\n            if(length(p.xy)<0.1) refCol = vec3(1.0,0.0,0.0);\r\n            else if(length(p.xy)>0.98) refCol = vec3(0.6, 0.55, 0.7);\r\n        }\r\n        else if(reflectMarch.O.mat < AXE_BODY + 0.5)\r\n        {\r\n            vec3 color = vec3(0.4,0.25,0.1);/// ${color1};\r\n            refCol = color * ( ambience + \r\n                            lightCol * Diffuse(Rp, light1, Rnormal)\r\n                        );\r\n            \r\n        }\r\n        \r\n        col = mix(refCol, col, 0.70);\r\n        \r\n        shadowExclude = AXE_BLADE;\r\n    }\r\n    else if(result.O.mat < GROUND+0.5)\r\n    {\r\n        vec3 color = vec3(0.1,0.35,0.05);/// ${color1};\r\n        \r\n        col = color * ( ambience + \r\n                        lightCol * Diffuse(p, light1, normal)\r\n       \r\n                      );\r\n        vec3 c = texture(grassHeight, p.xz*0.01).rgb;\r\n        float biomeD = (c.x+c.y+c.z)/3.;\r\n        col.g -= biomeD*.1;\r\n        // Shadow calculate\r\n        shadowExclude = GROUND;\r\n        \r\n    }\r\n    else if(result.O.mat < SKY+0.5){\r\n        col = texture(skyTex, result.O.pos.xy).rgb;\r\n        col *= 0.5+0.5*smoothstep(-1.0,1.0,result.O.pos.y);\r\n        col*= 2.;\r\n        col = vec3(1.,0.,0.);\r\n    }\r\n\r\n    // Shadow calculate\r\n    MarchResult shadowMarch = raymarchLow( p+normal*0.1, normalize( light1-p ), distance(light1,p), shadowExclude   );\r\n    col*= 0.25 + 0.75*smoothstep(0.0,0.1,shadowMarch.worldPosition.x);\r\n    \r\n}\r\n\r\nvoid render( vec2 uv, out vec4 diffuse)\r\n{\r\n    vec3 rd = getCameraRayDir( uv, camera, target, fov);\r\n    MarchResult result= raymarch(camera, rd);\r\n    colorize(result, rd, diffuse.rgb);\r\n    diffuse.a = result.travel/MAXDIST;\r\n    \r\n        \r\n    diffuse.rgb = mix(diffuse.rgb, vec3(0.2,0.3,0.9)*smoothstep(150.0,0.0,result.worldPosition.y), smoothstep(MAXDIST*3.0/4.0, MAXDIST, result.travel));\r\n}\r\n\r\nvec4 Main(vec2 uv, float AA)\r\n{\r\n    // Output to screen\r\n    vec4 emissive = vec4(0.);\r\n    vec4 col = vec4(0.);\r\n    render(uv, col);\r\n    return col + vec4(volumetric/(1.0+AA),0.0);\r\n}\r\n\r\nfloat AA = ${AA-LEVEL};\r\n\r\nvoid main()\r\n{\r\n    vec2 uv = (gl_FragCoord.xy/resolution.xy-0.5)*2.0;\r\n    uv.y*=resolution.y/resolution.x;\r\n    \r\n\tvec4 col = Main( uv, AA );\r\n    float count = 1.0;\r\n    vec2 aaStep = vec2(1.0/AA) / resolution.xy;\r\n    for( float aaX = 0.0; aaX < AA; aaX++)\r\n    {\r\n        for( float aaY = 0.0; aaY < AA; aaY++)\r\n        {\r\n            col += Main( uv + vec2( aaX, aaY ) * aaStep, AA );\r\n            count++;\r\n        }\r\n    }\r\n    col /= count;\r\n    \r\n    // Output to screen\r\n    outColor = col;\r\n}\r\n")}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:k.f1,value:0}),this.cameraU=this.CreateUniform({name:"camera",type:k.f3v,value:[.3,1,-10.3]}),this.targetU=this.CreateUniform({name:"target",type:k.f3v,value:[0,0,0]}),this.lightColU=this.CreateUniform({name:"lightCol",type:k.f3v,value:[2,2,2],min:-1,max:2}),this.fovU=this.CreateUniform({name:"fov",type:k.f1,value:4.25,max:20}),this.lightPosU=this.CreateUniform({name:"light1",type:k.f3v,value:[10,15,-20]}),this.ambienceU=this.CreateUniform({name:"ambience",type:k.f1,value:1,min:-2,max:2}),this.cubeposU=this.CreateUniform({name:"cubepos",type:k.f3v,value:[0,-.05,0],min:-2,max:2}),this.axeposU=this.CreateUniform({name:"axepos",type:k.f3v,value:[0,0,-110],min:-2,max:2}),this.axerotU=this.CreateUniform({name:"axerot",type:k.f3v,value:[0,0,0],min:-2,max:2}),this.axepos2U=this.CreateUniform({name:"axepos2",type:k.f3v,value:[0,0,-110],min:-2,max:2}),this.axerot2U=this.CreateUniform({name:"axerot2",type:k.f3v,value:[0,0,0],min:-2,max:2}),this.axepos3U=this.CreateUniform({name:"axepos3",type:k.f3v,value:[0,0,110],min:-2,max:2}),this.axerot3U=this.CreateUniform({name:"axerot3",type:k.f3v,value:[0,0,0],min:-2,max:2}),this.fractalposU=this.CreateUniform({name:"fractalAmount",type:k.f1,value:0,min:-2,max:2}),this.meltU=this.CreateUniform({name:"meltAmount",type:k.f1,value:0,min:0,max:4}),this.skyColorU=this.CreateUniform({name:"skyCol",type:k.f3v,value:[.2,.2,1],min:[0,0,0],max:[1,1,1]}),this.dartposU=this.CreateUniform({name:"dartpos",type:k.f3v,value:[0,-1,-100],min:-2,max:2}),this.dartrotU=this.CreateUniform({name:"dartrot",type:k.f3v,value:[0,0,0],min:-2,max:2}),this.dartpos2U=this.CreateUniform({name:"dartpos2",type:k.f3v,value:[0,0,-110],min:-2,max:2}),this.dartrot2U=this.CreateUniform({name:"dartrot2",type:k.f3v,value:[0,0,0],min:-2,max:2}),this.dartpos3U=this.CreateUniform({name:"dartpos3",type:k.f3v,value:[0,0,110],min:-2,max:2}),this.dartrot3U=this.CreateUniform({name:"dartrot3",type:k.f3v,value:[0,0,0],min:-2,max:2}),this.greetIntensityU=this.CreateUniform({name:"greetintensity",type:k.f1,value:0,min:-2,max:2}),this.textureLocations=[this.renderer.context.getUniformLocation(this.program,"wallRoughness"),this.renderer.context.getUniformLocation(this.program,"wallDisplacement"),this.renderer.context.getUniformLocation(this.program,"wallDiffuse"),this.renderer.context.getUniformLocation(this.program,"greets"),this.renderer.context.getUniformLocation(this.program,"grassHeight"),this.renderer.context.getUniformLocation(this.program,"skyTex")];const t=this.postProcessing.As();let e=1;this.addCurve(new p(0,0,0,h.ABSOLUTE),new p(12,0,0,h.ABSOLUTE),n=>{e=1,this.greetIntensityU.value=0,t.Rain.intensity.value=10,t.Godrays.amount.value=0,t.Bloom.amount.value=0,t.Vignetting.vignetting.value=.1,t.ColorAdjustment.contrast.value=1.25});let r=0;this.addCurve(new p(12,0,0,h.ABSOLUTE),new p(120,0,0,h.ABSOLUTE),n=>{e=0,this.greetIntensityU.value=.4,t.Rain.intensity.value=1.3-.3*r,t.Godrays.amount.value=0,t.Bloom.amount.value=5*r,t.Vignetting.vignetting.value=.7,t.ColorAdjustment.contrast.value=1+r,t.ColorAdjustment.brightness.value=-.3*r,t.DistortReplace.enabled=1,t.DistortReplace.limit.value=.1,t.DistortReplace.intensity.value=.3*r,t.DistortReplace.splits.value=[20,720],t.DoF.range.value=.05,t.DoF.focus.value=.06*Math.sin(1e3*n)+.15,t.Rain.color.value=[1-Math.sin(450.5*n+32)*r*.2,1-Math.sin(-257*n+2)*r*.2,1-Math.sin(-350.1*n+5)*r*.2]}),this.addCurve(new p(12,0,0,h.RELATIVE),new p(14,0,0,h.RELATIVE),e=>{t.DistortReplace.intensity.value=.3+.7*e,t.DistortReplace.limit.value=.1+.9*e,t.DistortReplace.splits.value=[20+700*e,720-700*e]}),this.addCurve(new p(13,2,0,h.RELATIVE),new p(14,0,0,h.RELATIVE),e=>{t.ColorAdjustment.brightness.value=-e}),this.addCurve(new p(12,3,0,h.RELATIVE),new p(14,0,0,h.RELATIVE),e=>{t.Kaleidoscope.enabled=1,t.Kaleidoscope.amount.value=e}),this.addCurve(new p(0,0,0,h.RELATIVE),new p(8,0,0,h.RELATIVE),t=>{r=.15*t});const i=new wd([[0,0,0],[0,.2,.3],[-.23,0,0],[.2,-.1,0],[0,0,0],[.3,.3,.2],[0,0,0],[-.2,0,0],[0,-.1,-.2],[0,0,0]]);this.addCurve(new p(0,0,0,h.RELATIVE),new p(8,0,0,h.RELATIVE),t=>{const r=e?.1:1-n.lerp(0,1,Vt(n.normalizeValue(.9,1,t))),a=i.evaluate(t).map(t=>.2*t),s=i.evaluate(6.3*t%1).map(t=>.1*t);this.targetU.value=[a[0]+s[0],a[1]+s[1],a[2]+s[2]].map(t=>t*r),this.cameraU.value=[-.24*this.targetU.value[0],-.1*this.targetU.value[2],-10]});const a=new wd([[0,0,0],[-.1,.1,0],[1.1,.1,0],[2.1,.4,0],[.1,-2.1,0]]),s=new wd([[0,0,-10],[0,0,-3],[.1,0,-1],[.1,0,-.4],[0,.1,.3]]);this.addCurve(new p(8,0,0,h.RELATIVE),new p(14,0,0,h.RELATIVE),t=>{const n=e?0:1,r=i.evaluate(t).map(t=>.2*t),o=i.evaluate(6.3*t%1).map(t=>.1*t);this.targetU.value=[r[0]+o[0]-5*Math.sin(9.9*t),r[1]+o[1]+7*Wt(t),r[2]+o[2]].map(e=>n*e*(1+3*t)),this.targetU.value=a.evaluate(t),this.cameraU.value=s.evaluate(t)});const o=[-.1,-.47,-.3],l=[-.1,.06,.1];this.addCurve(new p(2,3,0,h.RELATIVE),new p(2,4,0,h.RELATIVE),t=>{e||(t=1),this.dartposU.value=n.lerpList([-2.2,-12,-.8],o,t),this.dartrotU.value=n.lerpList([-0,-1.66,0],l,t)});const c=[0,-.47,-.07],u=[-0,-.1,-.05];this.addCurve(new p(2,2,0,h.RELATIVE),new p(2,3,0,h.RELATIVE),t=>{e||(t=1),this.dartpos2U.value=n.lerpList([-2.2,-12,-.8],c,t),this.dartrot2U.value=n.lerpList([-0,-10.66,0],u,t)});const d=[-.3,-.47,.2],f=[-0,.66,-.1];this.addCurve(new p(2,0,0,h.RELATIVE),new p(2,1,0,h.RELATIVE),t=>{e||(t=1),this.dartpos3U.value=n.lerpList([-2.2,-12,-.8],d,t),this.dartrot3U.value=n.lerpList([-0,-0,0],f,t)});const m=[-.1,-.47,-.57],v=[-.5,-.66,-2];this.addCurve(new p(1,2,0,h.RELATIVE),new p(1,3,0,h.RELATIVE),t=>{e||(this.axeposU.value=n.lerpList([-1,-16,-.8],m,t),this.axerotU.value=n.lerpList([-0,-1.66,0],v,t))});const x=[1,-.47,.57],_=[-.15,-1,-1];this.addCurve(new p(2,2,0,h.RELATIVE),new p(2,3,0,h.RELATIVE),t=>{e||(this.axepos2U.value=n.lerpList([1,-19,.8],x,t),this.axerot2U.value=n.lerpList([-0,-10.66,0],_,t))});const y=[-.3,-.47,1],b=[-0,.66,-2.8];this.addCurve(new p(3,4,0,h.RELATIVE),new p(3,5,0,h.RELATIVE),t=>{e||(this.axepos3U.value=n.lerpList([-3,-20,-.8],y,t),this.axerot3U.value=n.lerpList([-10,-1.66,0],b,t))}),this.addCurve(new p(5,0,0,h.RELATIVE),new p(6,0,0,h.RELATIVE),t=>{e||(this.fovU.value=n.lerp(4.2,3,jt(t)))}),this.addCurve(new p(6,0,0,h.RELATIVE),new p(12,0,0,h.RELATIVE),t=>{e||(this.fovU.value=n.lerp(3,1.5,Gt(t)))}),this.addCurve(new p(6,0,0,h.RELATIVE),new p(8,0,0,h.RELATIVE),t=>{e||(this.meltU.value=n.lerp(0,3.74,Gt(t)))}),this.addCurve(new p(7,0,0,h.RELATIVE),new p(12,0,0,h.RELATIVE),t=>{e||(this.fractalposU.value=n.lerp(2,.7,Gt(t))+n.lerp(0,.3,Gt(n.normalizeValue(.7,1,t))))}),this.addCurve(new p(3,3,0,h.RELATIVE),new p(4,0,0,h.RELATIVE),t=>{e&&(g.instance.overlay.elements.get("logo.png").style.opacity=100*(1-t)+"%")});const E=[{rot:-.1,step:0},{rot:-.1,step:0},{rot:.1,step:0},{rot:.1,step:0},{rot:0,step:1},{rot:0,step:-1},{rot:0,step:1},{rot:0,step:1},{rot:0,step:1}];let T=0;for(let t=0;t<32;t++){T+=4*E[t%E.length].step,this.addCurve(new p(6,t,0,h.RELATIVE),new p(6,t+1,0,h.RELATIVE),t=>{})}this.addTrigger(new p(-1,0,0,h.PATTERN),t=>{this.imgindex=this.imgindex++%4+1})}start(t,e){super.start(t,e),0===t.bar&&g.instance.overlay.showImage("logo.png",{x:960,y:540})}stop(){super.stop(),g.instance.overlay.hideAll()}update(t){super.update(t)}render(t,e,n){for(let t=0;t<this.textureLocations.length;t++)this.renderer.context.uniform1i(this.textureLocations[t],t);n.activeTexture(n.TEXTURE0),n.bindTexture(n.TEXTURE_2D,Bd.get("polyhaven/planks_brown_10_rough_1k.jpg")),n.activeTexture(n.TEXTURE1),n.bindTexture(n.TEXTURE_2D,Bd.get("polyhaven/planks_brown_10_disp_1k.png")),n.activeTexture(n.TEXTURE2),n.bindTexture(n.TEXTURE_2D,Bd.get("polyhaven/planks_brown_10_diff_1k.jpg")),n.activeTexture(n.TEXTURE3),n.bindTexture(n.TEXTURE_2D,Bd.get("greets.png")),n.activeTexture(n.TEXTURE4),n.bindTexture(n.TEXTURE_2D,Bd.get("textures/grass-heightmap.png")),n.activeTexture(n.TEXTURE5),n.bindTexture(n.TEXTURE_2D,Bd.get(`textures/sky${this.imgindex}.jpg`)),super.render(t,e,n)}}let Ad;class Cd extends D{program;vertexShader;fragmentShader;uniforms=[];scene;camera;renderTarget;constructor(t,e,n){super(t),this.vertexShader=n,this.fragmentShader=e}init(){super.init(),Ad||(gu(this.context),this.context.saveState(),Ad=new cu({context:this.renderer.context,alpha:1,canvas:this.renderer.options.canvas}),Ad.setClearColor(new ma(0)),Ad.setClearAlpha(1)),this.scene=new ds,this.camera=new is(75,this.renderer.options.width/this.renderer.options.height,.1,1e3),this.renderTarget=new qr(this.renderer.options.width,this.renderer.options.height,{internalFormat:"RGBA16F",format:Je,type:je}),Ad.setRenderTarget(this.renderTarget),Ad.render(this.scene,this.camera),this.context.restoreState()}render(t,e,n){super.render(t,e,n),this.context.saveState(),Ad.resetState(),Ad.setRenderTarget(this.renderTo),this.camera.updateProjectionMatrix(),Ad.render(this.scene,this.camera),this.context.restoreState()}createRenderTarget(){return this.renderTarget}getRTWebglTexture(){return Ad.properties.get(this.renderTarget.texture).__webglTexture}getThreeRenderer(){return Ad}}class Pd extends ja{constructor(t,e={}){super(t),this.isWater=1;const n=this,r=void 0!==e.textureWidth?e.textureWidth:512,i=void 0!==e.textureHeight?e.textureHeight:512,a=void 0!==e.clipBias?e.clipBias:0,s=void 0!==e.alpha?e.alpha:1,o=void 0!==e.time?e.time:0,l=void 0!==e.waterNormals?e.waterNormals:null,c=void 0!==e.sunDirection?e.sunDirection:new br(.70707,.70707,0),h=new ma(void 0!==e.sunColor?e.sunColor:16777215),u=new ma(void 0!==e.waterColor?e.waterColor:8355711),d=void 0!==e.eye?e.eye:new br(0,0,0),p=void 0!==e.distortionScale?e.distortionScale:20,f=void 0!==e.side?e.side:0,m=void 0!==e.fog?e.fog:0,g=new Gs,v=new br,x=new br,_=new br,y=new Ti,b=new br(0,0,-1),E=new Xr,T=new br,S=new br,M=new Xr,w=new Ti,R=new is,A=new qr(r,i),C={name:"MirrorShader",uniforms:Ja.merge([Cl.fog,Cl.lights,{normalSampler:{value:null},mirrorSampler:{value:null},alpha:{value:1},time:{value:0},size:{value:1},distortionScale:{value:20},textureMatrix:{value:new Ti},sunColor:{value:new ma(8355711)},sunDirection:{value:new br(.70707,.70707,0)},eye:{value:new br},waterColor:{value:new ma(5592405)}}]),vertexShader:"\n\t\t\t\tuniform mat4 textureMatrix;\n\t\t\t\tuniform float time;\n\n\t\t\t\tvarying vec4 mirrorCoord;\n\t\t\t\tvarying vec4 worldPosition;\n\n\t\t\t\t#include <common>\n\t\t\t\t#include <fog_pars_vertex>\n\t\t\t\t#include <shadowmap_pars_vertex>\n\t\t\t\t#include <logdepthbuf_pars_vertex>\n\n\t\t\t\tvoid main() {\n\t\t\t\t\tmirrorCoord = modelMatrix * vec4( position, 1.0 );\n\t\t\t\t\tworldPosition = mirrorCoord.xyzw;\n\t\t\t\t\tmirrorCoord = textureMatrix * mirrorCoord;\n\t\t\t\t\tvec4 mvPosition =  modelViewMatrix * vec4( position, 1.0 );\n\t\t\t\t\tgl_Position = projectionMatrix * mvPosition;\n\n\t\t\t\t#include <beginnormal_vertex>\n\t\t\t\t#include <defaultnormal_vertex>\n\t\t\t\t#include <logdepthbuf_vertex>\n\t\t\t\t#include <fog_vertex>\n\t\t\t\t#include <shadowmap_vertex>\n\t\t\t}",fragmentShader:"\n\t\t\t\tuniform sampler2D mirrorSampler;\n\t\t\t\tuniform float alpha;\n\t\t\t\tuniform float time;\n\t\t\t\tuniform float size;\n\t\t\t\tuniform float distortionScale;\n\t\t\t\tuniform sampler2D normalSampler;\n\t\t\t\tuniform vec3 sunColor;\n\t\t\t\tuniform vec3 sunDirection;\n\t\t\t\tuniform vec3 eye;\n\t\t\t\tuniform vec3 waterColor;\n\n\t\t\t\tvarying vec4 mirrorCoord;\n\t\t\t\tvarying vec4 worldPosition;\n\n\t\t\t\tvec4 getNoise( vec2 uv ) {\n\t\t\t\t\tvec2 uv0 = ( uv / 103.0 ) + vec2(time / 17.0, time / 29.0);\n\t\t\t\t\tvec2 uv1 = uv / 107.0-vec2( time / -19.0, time / 31.0 );\n\t\t\t\t\tvec2 uv2 = uv / vec2( 8907.0, 9803.0 ) + vec2( time / 101.0, time / 97.0 );\n\t\t\t\t\tvec2 uv3 = uv / vec2( 1091.0, 1027.0 ) - vec2( time / 109.0, time / -113.0 );\n\t\t\t\t\tvec4 noise = texture2D( normalSampler, uv0 ) +\n\t\t\t\t\t\ttexture2D( normalSampler, uv1 ) +\n\t\t\t\t\t\ttexture2D( normalSampler, uv2 ) +\n\t\t\t\t\t\ttexture2D( normalSampler, uv3 );\n\t\t\t\t\treturn noise * 0.5 - 1.0;\n\t\t\t\t}\n\n\t\t\t\tvoid sunLight( const vec3 surfaceNormal, const vec3 eyeDirection, float shiny, float spec, float diffuse, inout vec3 diffuseColor, inout vec3 specularColor ) {\n\t\t\t\t\tvec3 reflection = normalize( reflect( -sunDirection, surfaceNormal ) );\n\t\t\t\t\tfloat direction = max( 0.0, dot( eyeDirection, reflection ) );\n\t\t\t\t\tspecularColor += pow( direction, shiny ) * sunColor * spec;\n\t\t\t\t\tdiffuseColor += max( dot( sunDirection, surfaceNormal ), 0.0 ) * sunColor * diffuse;\n\t\t\t\t}\n\n\t\t\t\t#include <common>\n\t\t\t\t#include <packing>\n\t\t\t\t#include <bsdfs>\n\t\t\t\t#include <fog_pars_fragment>\n\t\t\t\t#include <logdepthbuf_pars_fragment>\n\t\t\t\t#include <lights_pars_begin>\n\t\t\t\t#include <shadowmap_pars_fragment>\n\t\t\t\t#include <shadowmask_pars_fragment>\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\t#include <logdepthbuf_fragment>\n\t\t\t\t\tvec4 noise = getNoise( worldPosition.xz * size );\n\t\t\t\t\tvec3 surfaceNormal = normalize( noise.xzy * vec3( 1.5, 1.0, 1.5 ) );\n\n\t\t\t\t\tvec3 diffuseLight = vec3(0.0);\n\t\t\t\t\tvec3 specularLight = vec3(0.0);\n\n\t\t\t\t\tvec3 worldToEye = eye-worldPosition.xyz;\n\t\t\t\t\tvec3 eyeDirection = normalize( worldToEye );\n\t\t\t\t\tsunLight( surfaceNormal, eyeDirection, 100.0, 2.0, 0.5, diffuseLight, specularLight );\n\n\t\t\t\t\tfloat distance = length(worldToEye);\n\n\t\t\t\t\tvec2 distortion = surfaceNormal.xz * ( 0.001 + 1.0 / distance ) * distortionScale;\n\t\t\t\t\tvec3 reflectionSample = vec3( texture2D( mirrorSampler, mirrorCoord.xy / mirrorCoord.w + distortion ) );\n\n\t\t\t\t\tfloat theta = max( dot( eyeDirection, surfaceNormal ), 0.0 );\n\t\t\t\t\tfloat rf0 = 0.3;\n\t\t\t\t\tfloat reflectance = rf0 + ( 1.0 - rf0 ) * pow( ( 1.0 - theta ), 5.0 );\n\t\t\t\t\tvec3 scatter = max( 0.0, dot( surfaceNormal, eyeDirection ) ) * waterColor;\n\t\t\t\t\tvec3 albedo = mix( ( sunColor * diffuseLight * 0.3 + scatter ) * getShadowMask(), ( vec3( 0.1 ) + reflectionSample * 0.9 + reflectionSample * specularLight ), reflectance);\n\t\t\t\t\tvec3 outgoingLight = albedo;\n\t\t\t\t\tgl_FragColor = vec4( outgoingLight, alpha );\n\n\t\t\t\t\t#include <tonemapping_fragment>\n\t\t\t\t\t#include <colorspace_fragment>\n\t\t\t\t\t#include <fog_fragment>\t\n\t\t\t\t}"},P=new Qa({name:C.name,uniforms:Ja.clone(C.uniforms),vertexShader:C.vertexShader,fragmentShader:C.fragmentShader,lights:1,side:f,fog:m});P.uniforms.mirrorSampler.value=A.texture,P.uniforms.textureMatrix.value=w,P.uniforms.alpha.value=s,P.uniforms.time.value=o,P.uniforms.normalSampler.value=l,P.uniforms.sunColor.value=h,P.uniforms.waterColor.value=u,P.uniforms.sunDirection.value=c,P.uniforms.distortionScale.value=p,P.uniforms.eye.value=d,n.material=P,n.onBeforeRender=function(t,e,r){if(x.setFromMatrixPosition(n.matrixWorld),_.setFromMatrixPosition(r.matrixWorld),y.extractRotation(n.matrixWorld),v.set(0,0,1),v.applyMatrix4(y),T.subVectors(x,_),T.dot(v)>0)return;T.reflect(v).negate(),T.add(x),y.extractRotation(r.matrixWorld),b.set(0,0,-1),b.applyMatrix4(y),b.add(_),S.subVectors(x,b),S.reflect(v).negate(),S.add(x),R.position.copy(T),R.up.set(0,1,0),R.up.applyMatrix4(y),R.up.reflect(v),R.lookAt(S),R.far=r.far,R.updateMatrixWorld(),R.projectionMatrix.copy(r.projectionMatrix),w.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),w.multiply(R.projectionMatrix),w.multiply(R.matrixWorldInverse),g.setFromNormalAndCoplanarPoint(v,x),g.applyMatrix4(R.matrixWorldInverse),E.set(g.normal.x,g.normal.y,g.normal.z,g.constant);const i=R.projectionMatrix;M.x=(Math.sign(E.x)+i.elements[8])/i.elements[0],M.y=(Math.sign(E.y)+i.elements[9])/i.elements[5],M.z=-1,M.w=(1+i.elements[10])/i.elements[14],E.multiplyScalar(2/E.dot(M)),i.elements[2]=E.x,i.elements[6]=E.y,i.elements[10]=E.z+1-a,i.elements[14]=E.w,d.setFromMatrixPosition(r.matrixWorld);const s=t.getRenderTarget(),o=t.xr.enabled,l=t.shadowMap.autoUpdate;n.visible=0,t.xr.enabled=0,t.shadowMap.autoUpdate=0,t.setRenderTarget(A),t.state.buffers.depth.setMask(1),0==t.autoClear&&t.clear(),t.render(e,R),n.visible=1,t.xr.enabled=o,t.shadowMap.autoUpdate=l,t.setRenderTarget(s);const c=r.viewport;void 0!==c&&t.state.viewport(c)}}}class Dd extends ja{constructor(){const t=Dd.SkyShader,e=new Qa({name:t.name,uniforms:Ja.clone(t.uniforms),vertexShader:t.vertexShader,fragmentShader:t.fragmentShader,side:1,depthWrite:0});super(new Ya(1,1,1),e),this.isSky=1}}Dd.SkyShader={name:"SkyShader",uniforms:{turbidity:{value:2},rayleigh:{value:1},mieCoefficient:{value:.005},mieDirectionalG:{value:.8},sunPosition:{value:new br},up:{value:new br(0,1,0)}},vertexShader:"\n\t\tuniform vec3 sunPosition;\n\t\tuniform float rayleigh;\n\t\tuniform float turbidity;\n\t\tuniform float mieCoefficient;\n\t\tuniform vec3 up;\n\n\t\tvarying vec3 vWorldPosition;\n\t\tvarying vec3 vSunDirection;\n\t\tvarying float vSunfade;\n\t\tvarying vec3 vBetaR;\n\t\tvarying vec3 vBetaM;\n\t\tvarying float vSunE;\n\n\t\t// constants for atmospheric scattering\n\t\tconst float e = 2.71828182845904523536028747135266249775724709369995957;\n\t\tconst float pi = 3.141592653589793238462643383279502884197169;\n\n\t\t// wavelength of used primaries, according to preetham\n\t\tconst vec3 lambda = vec3( 680E-9, 550E-9, 450E-9 );\n\t\t// this pre-calculation replaces older TotalRayleigh(vec3 lambda) function:\n\t\t// (8.0 * pow(pi, 3.0) * pow(pow(n, 2.0) - 1.0, 2.0) * (6.0 + 3.0 * pn)) / (3.0 * N * pow(lambda, vec3(4.0)) * (6.0 - 7.0 * pn))\n\t\tconst vec3 totalRayleigh = vec3( 5.804542996261093E-6, 1.3562911419845635E-5, 3.0265902468824876E-5 );\n\n\t\t// mie stuff\n\t\t// K coefficient for the primaries\n\t\tconst float v = 4.0;\n\t\tconst vec3 K = vec3( 0.686, 0.678, 0.666 );\n\t\t// MieConst = pi * pow( ( 2.0 * pi ) / lambda, vec3( v - 2.0 ) ) * K\n\t\tconst vec3 MieConst = vec3( 1.8399918514433978E14, 2.7798023919660528E14, 4.0790479543861094E14 );\n\n\t\t// earth shadow hack\n\t\t// cutoffAngle = pi / 1.95;\n\t\tconst float cutoffAngle = 1.6110731556870734;\n\t\tconst float steepness = 1.5;\n\t\tconst float EE = 1000.0;\n\n\t\tfloat sunIntensity( float zenithAngleCos ) {\n\t\t\tzenithAngleCos = clamp( zenithAngleCos, -1.0, 1.0 );\n\t\t\treturn EE * max( 0.0, 1.0 - pow( e, -( ( cutoffAngle - acos( zenithAngleCos ) ) / steepness ) ) );\n\t\t}\n\n\t\tvec3 totalMie( float T ) {\n\t\t\tfloat c = ( 0.2 * T ) * 10E-18;\n\t\t\treturn 0.434 * c * MieConst;\n\t\t}\n\n\t\tvoid main() {\n\n\t\t\tvec4 worldPosition = modelMatrix * vec4( position, 1.0 );\n\t\t\tvWorldPosition = worldPosition.xyz;\n\n\t\t\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n\t\t\tgl_Position.z = gl_Position.w; // set z to camera.far\n\n\t\t\tvSunDirection = normalize( sunPosition );\n\n\t\t\tvSunE = sunIntensity( dot( vSunDirection, up ) );\n\n\t\t\tvSunfade = 1.0 - clamp( 1.0 - exp( ( sunPosition.y / 450000.0 ) ), 0.0, 1.0 );\n\n\t\t\tfloat rayleighCoefficient = rayleigh - ( 1.0 * ( 1.0 - vSunfade ) );\n\n\t\t\t// extinction (absorption + out scattering)\n\t\t\t// rayleigh coefficients\n\t\t\tvBetaR = totalRayleigh * rayleighCoefficient;\n\n\t\t\t// mie coefficients\n\t\t\tvBetaM = totalMie( turbidity ) * mieCoefficient;\n\n\t\t}",fragmentShader:"\n\t\tvarying vec3 vWorldPosition;\n\t\tvarying vec3 vSunDirection;\n\t\tvarying float vSunfade;\n\t\tvarying vec3 vBetaR;\n\t\tvarying vec3 vBetaM;\n\t\tvarying float vSunE;\n\n\t\tuniform float mieDirectionalG;\n\t\tuniform vec3 up;\n\n\t\t// constants for atmospheric scattering\n\t\tconst float pi = 3.141592653589793238462643383279502884197169;\n\n\t\tconst float n = 1.0003; // refractive index of air\n\t\tconst float N = 2.545E25; // number of molecules per unit volume for air at 288.15K and 1013mb (sea level -45 celsius)\n\n\t\t// optical length at zenith for molecules\n\t\tconst float rayleighZenithLength = 8.4E3;\n\t\tconst float mieZenithLength = 1.25E3;\n\t\t// 66 arc seconds -> degrees, and the cosine of that\n\t\tconst float sunAngularDiameterCos = 0.999956676946448443553574619906976478926848692873900859324;\n\n\t\t// 3.0 / ( 16.0 * pi )\n\t\tconst float THREE_OVER_SIXTEENPI = 0.05968310365946075;\n\t\t// 1.0 / ( 4.0 * pi )\n\t\tconst float ONE_OVER_FOURPI = 0.07957747154594767;\n\n\t\tfloat rayleighPhase( float cosTheta ) {\n\t\t\treturn THREE_OVER_SIXTEENPI * ( 1.0 + pow( cosTheta, 2.0 ) );\n\t\t}\n\n\t\tfloat hgPhase( float cosTheta, float g ) {\n\t\t\tfloat g2 = pow( g, 2.0 );\n\t\t\tfloat inverse = 1.0 / pow( 1.0 - 2.0 * g * cosTheta + g2, 1.5 );\n\t\t\treturn ONE_OVER_FOURPI * ( ( 1.0 - g2 ) * inverse );\n\t\t}\n\n\t\tvoid main() {\n\n\t\t\tvec3 direction = normalize( vWorldPosition - cameraPosition );\n\n\t\t\t// optical length\n\t\t\t// cutoff angle at 90 to avoid singularity in next formula.\n\t\t\tfloat zenithAngle = acos( max( 0.0, dot( up, direction ) ) );\n\t\t\tfloat inverse = 1.0 / ( cos( zenithAngle ) + 0.15 * pow( 93.885 - ( ( zenithAngle * 180.0 ) / pi ), -1.253 ) );\n\t\t\tfloat sR = rayleighZenithLength * inverse;\n\t\t\tfloat sM = mieZenithLength * inverse;\n\n\t\t\t// combined extinction factor\n\t\t\tvec3 Fex = exp( -( vBetaR * sR + vBetaM * sM ) );\n\n\t\t\t// in scattering\n\t\t\tfloat cosTheta = dot( direction, vSunDirection );\n\n\t\t\tfloat rPhase = rayleighPhase( cosTheta * 0.5 + 0.5 );\n\t\t\tvec3 betaRTheta = vBetaR * rPhase;\n\n\t\t\tfloat mPhase = hgPhase( cosTheta, mieDirectionalG );\n\t\t\tvec3 betaMTheta = vBetaM * mPhase;\n\n\t\t\tvec3 Lin = pow( vSunE * ( ( betaRTheta + betaMTheta ) / ( vBetaR + vBetaM ) ) * ( 1.0 - Fex ), vec3( 1.5 ) );\n\t\t\tLin *= mix( vec3( 1.0 ), pow( vSunE * ( ( betaRTheta + betaMTheta ) / ( vBetaR + vBetaM ) ) * Fex, vec3( 1.0 / 2.0 ) ), clamp( pow( 1.0 - dot( up, vSunDirection ), 5.0 ), 0.0, 1.0 ) );\n\n\t\t\t// nightsky\n\t\t\tfloat theta = acos( direction.y ); // elevation --\x3e y-axis, [-pi/2, pi/2]\n\t\t\tfloat phi = atan( direction.z, direction.x ); // azimuth --\x3e x-axis [-pi/2, pi/2]\n\t\t\tvec2 uv = vec2( phi, theta ) / vec2( 2.0 * pi, pi ) + vec2( 0.5, 0.0 );\n\t\t\tvec3 L0 = vec3( 0.1 ) * Fex;\n\n\t\t\t// composition + solar disc\n\t\t\tfloat sundisk = smoothstep( sunAngularDiameterCos, sunAngularDiameterCos + 0.00002, cosTheta );\n\t\t\tL0 += ( vSunE * 19000.0 * Fex ) * sundisk;\n\n\t\t\tvec3 texColor = ( Lin + L0 ) * 0.04 + vec3( 0.0, 0.0003, 0.00075 );\n\n\t\t\tvec3 retColor = pow( texColor, vec3( 1.0 / ( 1.2 + ( 1.2 * vSunfade ) ) ) );\n\n\t\t\tgl_FragColor = vec4( retColor, 1.0 );\n\n\t\t\t#include <tonemapping_fragment>\n\t\t\t#include <colorspace_fragment>\n\n\t\t}"};let Ud=new Ot(123);class Ld extends Zi{meshes=[];geometried=[];rot=0;speed=0;constructor(t,e){super();const n=new Ya(10,10,10),r=new _o({color:16777215,normalMap:new Wr(g.instance.overlay.elements.get("waternormals.jpg"))});this.speed=.5*Ud.nextFloat()+1;for(let t=0;t<30;t++){const e=new ja(n,r);this.add(e),e.position.set(0,30*Math.cos(t/12*Math.PI),130*Math.sin(t/12*Math.PI/3)),e.rotation.set(3.14*Math.random(),3.14*Math.random(),3.14*Math.random()),this.meshes.push(e)}this.rot=0*Ud.nextFloat()*Math.PI}update(t){this.meshes.forEach((e,n)=>{e.position.set(0,30*Math.cos(n/10*Math.PI+t),130*Math.sin(n/10*Math.PI/2+t))})}}class Id extends Cd{features=new Set([C.DefaultAudioFilters,C.DefaultPostProcess,C.EnableAudioAnalyzer,C.EnablePostProcess,C.DefaultOnRender]);water;lookat=new br;worms=[];cubecamera;constructor(t){super(t)}initPreCompile(){super.initPreCompile()}init(){super.init(),gu(this.context),this.context.saveState(),this.scene=new ds,this.camera=new is(75,this.renderer.options.width/this.renderer.options.height,.1,1e3);const t=new Ot(432),e=new xo(30),r=new _a({color:3174480});for(let n=0;n<10;n++){const n=new ja(e,r);this.scene.add(n),n.scale.set(1+t.nextFloat(),.2+.73*t.nextFloat(),1+t.nextFloat()),n.position.set(0+20*t.nextFloat(),0,20*t.nextFloat()-100)}for(let n=0;n<10;n++){const n=new ja(e,r);this.scene.add(n),n.scale.set(1+t.nextFloat(),.2+.73*t.nextFloat(),1+t.nextFloat()),n.position.set(70+120*t.nextFloat(),0,120*t.nextFloat()-100)}for(let n=0;n<10;n++){const n=new ja(e,r);this.scene.add(n),n.scale.set(1+t.nextFloat(),.2+.73*t.nextFloat(),1+t.nextFloat()),n.position.set(120*t.nextFloat()-170,0,120*t.nextFloat()-100)}const i=new Dd;i.scale.setScalar(1e4),this.scene.add(i);const a=i.material.uniforms;a.turbidity.value=7,a.rayleigh.value=.45,a.mieCoefficient.value=.005,a.mieDirectionalG.value=.8,this.camera.position.z=0,this.camera.position.x=0,this.camera.position.y=4,this.camera.lookAt(new br(0,0,0));const s=this.postProcessing.As();s.DoF.enabled=0,s.Godrays.amount.value=0,s.Bloom.amount.value=0,s.ChromaticAberration.intensity.value=.07,s.ChromaticAberration.lensing.value=.15,s.ColorAdjustment.exposure.value=1.75,s.ColorAdjustment.brightness.value=0,s.ColorAdjustment.exposure.value=1.1,this.scene.add(new pl(16777215,0)),this.addCurve(new p(0,0,0,h.RELATIVE),new p(12,2,0,h.RELATIVE),t=>{this.lookat=new br(20*Math.cos(t),1,20*Math.sin(t)),this.camera.position.z=n.lerp(700,200,t),this.camera.position.y=2+.2*Math.sin(17*t+.2*Math.sin(39*t))+.1*Math.cos(11*t),s.ColorAdjustment.saturation.value=n.lerp(2,.5,t),s.ColorAdjustment.exposure.value=n.lerp(2,1.25,t),s.ColorAdjustment.brightness.value=n.lerp(.1,-.1,t),s.Rain.intensity.value=n.lerp(2,.4,t),a.rayleigh.value=n.lerp(2.5,.45,t)});const o=new vo(1e4,1e4);this.water=new Pd(o,{textureWidth:512,textureHeight:512,waterNormals:(new $o).load("waternormals.jpg",function(t){t.wrapS=t.wrapT=De}),sunDirection:new br,sunColor:16777215,waterColor:7695,distortionScale:.25,fog:0}),this.water.material.uniforms.size.value=10,this.water.rotation.x=-Math.PI/2,this.scene.add(this.water);const l={elevation:50,azimuth:40},c=new Jl(this.getThreeRenderer()),u=new ds;let d;const f=new br,m=()=>{const t=xr.degToRad(90-l.elevation),e=xr.degToRad(l.azimuth);f.setFromSphericalCoords(1,t,e),i.material.uniforms.sunPosition.value.copy(f),this.water.material.uniforms.sunDirection.value.copy(f).normalize(),void 0!==d&&d.dispose(),u.add(i),d=c.fromScene(u),this.scene.add(i),this.scene.environment=d.texture};this.updateSun=m,this.sunparams=l,m();const g=new cl(65280,1,100);g.lookAt(new br(0,-1,0)),g.position.y=30;const v=new cl(16711680,1,100);v.lookAt(new br(0,1,0)),v.position.y=-30,this.scene.add(g),this.scene.add(v);const x=new ls(128,{generateMipmaps:1,minFilter:ke});for(let e=0;e<6;e++){const r=new Ld(this.scene,x);this.scene.add(r),r.position.set(450*(t.nextFloat()-.5),10*(t.nextFloat()-.5),500-60*e),r.visible=0;const i=r.position.y;this.addCurve(new p(0,0,0,h.RELATIVE),new p(12,4,0,h.RELATIVE),t=>{r.visible=1,r.update(8*t),r.position.y=n.lerp(i-40,i,n.normalizeValue(0,.5,t))}),this.worms.push(r)}}sunparams;updateSun;start(t,e){super.start(t,e)}update(t){super.update(t)}render(t,e,n){const r=t.toMilliseconds()/1e3;this.camera.rotation.x=.06*Math.sin(1.8*r+.9*Math.cos(1.43*r+.53)+.3*Math.cos(4.5*-r-55.3)),this.worms.forEach(t=>{}),this.camera.matrixAutoUpdate=1,this.water.material.uniforms.time.value=t.toMilliseconds()/6e3,super.render(t,e,n)}}class Nd extends Lt{features=new Set([C.DefaultAudioFilters,C.DefaultPostProcess,C.EnableAudioAnalyzer,C.EnablePostProcess,C.DefaultOnRender]);timeU;cameraU;targetU;fovU;ambienceU;light1U;light2U;light3U;biomeLocation;constructor(t){super(t,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nlayout(location = 0) out vec4 outColor;\r\n\r\nuniform vec2 resolution;\r\nuniform float time;\r\nuniform float fov;\r\nuniform vec3 camera;\r\nuniform vec3 target;\r\nuniform vec3 light1;\r\nuniform vec3 light2;\r\nuniform vec3 light3;\r\nuniform vec3 cubepos;\r\nuniform vec3 cuberot;\r\nuniform float ambience;\r\nuniform sampler2D biome;\r\n\r\nconst float PI2 = 6.28318530717;\r\nconst float PI = 3.14159265359;\r\nconst float PHI = 1.61803398874;\r\nconst vec3 V3Z = vec3(0.);\r\nstruct O\r\n{\r\n    // Distance the ray has travelled to the object\r\n    float dist;\r\n    // Material of the object\r\n    float mat;\r\n    // The position of the object in 3d space\r\n    vec3 pos;\r\n};\r\n\r\nstruct MarchResult{\r\n   // Object the marching hits.\r\n   O O;\r\n   // How many steps did the march take.\r\n   int steps;\r\n   // The position in world for march.\r\n   vec3 worldPosition;\r\n   // Normal for the object surface.\r\n   vec3 normal;\r\n   // How much did the ray travel.\r\n   float travel;\r\n};\r\n\r\n// Point rotations\r\nvec3 RotPointX(vec3 p, float d) {\r\n    mat4 rotM= mat4(1.0, 0.0, 0.0, 0.0, \r\n                    0.0, cos(d), -sin(d), 0.0, \r\n                    0.0, sin(d), cos(d), 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\nvec3 RotPointY(vec3 p, float d) {\r\n    mat4 rotM= mat4(cos(d), 0.0, sin(d), 0.0, \r\n                    0.0, 1.0, 0.0, 0.0,\r\n                    -sin(d), 0.0, cos(d), 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\nvec3 RotPointZ(vec3 p, float d) {\r\n    mat4 rotM= mat4(cos(d), -sin(d), 0.0, 0.0, \r\n                    sin(d), cos(d), 0.0, 0.0, \r\n                    0.0, 0.0, 1.0, 0.0, \r\n                    0.0, 0.0, 0.0, 1.0);\r\n    return vec3(rotM * vec4(p, 1.0));\r\n}\r\n\r\n// Matrix rotations.\r\nmat3 RotX(float a)\r\n{\r\n    return mat3(\r\n        1.0, 0.0, 0.0, \r\n        0.0, cos(a), -sin(a), \r\n        0.0, sin(a), cos(a)\r\n    );\r\n}\r\nmat3 RotY(float a)\r\n{\r\n    return mat3(\r\n        cos(a), 0.0, sin(a), \r\n        0.0, 1.0, 0.0, \r\n        -sin(a), 0.0, cos(a)\r\n    );\r\n}\r\nmat3 RotZ(float a)\r\n{\r\n    return mat3(\r\n        cos(a), -sin(a), 0.0, \r\n        sin(a), cos(a), 0.0, \r\n        0.0, 0.0, 1.0\r\n    );\r\n}\r\nmat3 Rot(float x,float y,float z)\r\n{\r\n    float xca = cos(x);\r\n    float xsa = sin(x);\r\n    float yca = cos(y);\r\n    float ysa = sin(y);\r\n    float zca = cos(z);\r\n    float zsa = sin(z);\r\n    \r\n    return mat3( \r\n        1.0, 0.0, 0.0,\r\n        0.0, xca, -xsa,\r\n        0.0, xsa, xca\r\n    ) * \r\n    mat3(\r\n        yca, 0.0, ysa,\r\n        0.0, 1.0, 0.0,\r\n        -ysa, 0.0, yca\r\n    ) * \r\n    mat3(\r\n        yca, -ysa, 0.0,\r\n        ysa, yca, 0.0,\r\n        0.0, 0.0, 1.0\r\n    );\r\n}\r\n\r\n// Rotation around fixed axis\r\nmat3 RotationMatrix(vec3 axis, float angle)\r\n{\r\n    axis = normalize(axis);\r\n    float s = sin(angle);\r\n    float c = cos(angle);\r\n    float oc = 1.0 - c;\r\n    \r\n    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,\r\n                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,\r\n                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);\r\n}\r\nfloat HexPrism( vec3 p, vec2 h )\r\n{\r\n  const vec3 k = vec3(-0.8660254, 0.5, 0.57735);\r\n  p = abs(p);\r\n  p.xy -= 2.0*min(dot(k.xy, p.xy), 0.0)*k.xy;\r\n  vec2 d = vec2(\r\n       length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x), h.x))*sign(p.y-h.x),\r\n       p.z-h.y );\r\n  return min(max(d.x,d.y),0.0) + length(max(d,0.0));\r\n}\r\nfloat Ground(vec3 position, float height)\r\n{\r\n    return position.y - height;\r\n}\r\nfloat Torus( vec3 pos, vec2 t )\r\n{\r\n  vec2 q = vec2(length(pos.xz)-t.x,pos.y);\r\n  return length(q)-t.y;\r\n}\r\nfloat RoundBox( vec3 p, vec3 b, float r )\r\n{\r\n  vec3 d = abs(p) - b;\r\n  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0)) - r;\r\n}\r\nfloat Sphere( vec3 pos, float radius )\r\n{\r\n    return length(pos) - radius;\r\n}\r\n// Union of two objects with support for material mixing\r\nO Union(O a, O b){\r\n    float s = step(b.dist, a.dist);\r\n    return O( mix(a.dist, b.dist, s),\r\n                       mix(a.mat, b.mat, s),\r\n                       mix(a.pos, b.pos, s));\r\n}\r\nvec3 Repeat( vec3 p, vec3 c)\r\n{\r\n    vec3 q = vec3(0.);\r\n    vec3 q2 = mod(p+0.5*c,c)-0.5*c;\r\n    q.x = c.x > 0. ? q2.x : p.x;\r\n    q.y = c.y > 0. ? q2.y : p.y;\r\n    q.z = c.z > 0. ? q2.z : p.z;\r\n    return q;\r\n}\r\n#define HASHSCALE1 .1031\r\nfloat Hash(float p)\r\n{\r\n\tvec3 p3  = fract(vec3(p) * HASHSCALE1);\r\n    p3 += dot(p3, p3.yzx + 19.19);\r\n    return fract((p3.x + p3.y) * p3.z);\r\n}\r\n\r\nvec3 buildOffset(vec2 p){\r\n  return vec3(0.);\r\n}\r\n\r\n/** CONSTANTS **/\r\nconst float STEP = 0.001;\r\nconst float VOLUMETRIC_STEP = 0.01;\r\nconst float MAXDIST = 30.;\r\n\r\nvec3 volumetric = vec3(0.0);\r\n\r\n\r\n/*************\r\n*** CAMERA ***\r\n*************/\r\nvec3 getCameraRayDir(vec2 uv, vec3 pos, vec3 target, float fov)\r\n{\r\n    vec3 forward = normalize( target - pos );\r\n    vec3 right = normalize(cross(vec3(0., 1.0, 0.), forward));\r\n    vec3 up = normalize(cross(forward,right));\r\n    return normalize( uv.x * right + uv.y * up + forward * fov);\r\n}\r\n\r\nvec2 wpToTexture(vec2 p) { return p*0.01;}\r\n\r\n// Scene mapping method \r\nO map( vec3 pos )\r\n{\r\n    // displace distance with biome\r\n    float dG = Ground(pos, -1.);\r\n    vec3 c = texture(biome, wpToTexture(pos.xz)).rgb;\r\n    float biomeD = (c.x+c.y+c.z)/3.;\r\n    vec3 jc = buildOffset(pos.xz);\r\n    float od = (jc.x+jc.y+jc.z)/3.;\r\n    O groundBottom = O( dG+biomeD+od, 0.0, pos);\r\n\r\n    O result = groundBottom;\r\n   \r\n    return result;\r\n}\r\n\r\n// Requires hash.fs to be included\r\n\r\nvec3 RandomSphereDir(vec2 rnd)\r\n{\r\n\tfloat s = rnd.x*PI*2.;\r\n\tfloat t = rnd.y*2.-1.;\r\n\treturn vec3(sin(s), cos(s), t) / sqrt(1.0 + t * t);\r\n}\r\nvec3 RandomHemisphereDir(vec3 dir, float i)\r\n{\r\n\tvec3 v = RandomSphereDir( vec2(Hash(i+1.), Hash(i+2.)) );\r\n\treturn v * sign(dot(v, dir));\r\n}\r\n\r\nfloat AmbientOcclusion( in vec3 p, in vec3 n, in float maxDist, in float falloff )\r\n{\r\n\tconst int nbIte = 32;\r\n    const float nbIteInv = 1./float(nbIte);\r\n    const float rad = 1.-1.*nbIteInv; //Hemispherical factor (self occlusion correction)\r\n    \r\n\tfloat ao = 0.0;\r\n    \r\n    for( int i=0; i<nbIte; i++ )\r\n    {\r\n        float l = Hash(float(i))*maxDist;\r\n        vec3 rd = normalize(n+RandomHemisphereDir(n, l )*rad)*l; // mix direction with the normal\r\n        \t\t\t\t\t\t\t\t\t\t\t\t\t    // for self occlusion problems!\r\n        \r\n        ao += (l - max(map( p + rd ).dist,0.)) / maxDist * falloff;\r\n    }\r\n\t\r\n    return clamp( 1.-ao*nbIteInv, 0., 1.);\r\n}\r\n\r\n\r\n// Calculates the surface normal\r\nvec3 CalcNormal( vec3 pos)\r\n{\r\n    float c = map(pos).dist;\r\n    vec2 e = vec2(0.001, 0.0);\r\n    return normalize( vec3( map( pos + e.xyy).dist,\r\n                            map( pos + e.yxy).dist,\r\n                            map( pos + e.yyx).dist) -c);\r\n}\r\n\r\nvec3 Diffuse( vec3 pos, vec3 light, vec3 normal )\r\n{\r\n    float dotNL = max(dot( normal, normalize(light - pos)), 0.0);\r\n    return vec3(1.) * dotNL;\r\n}\r\n\r\n\r\n/**\r\n * Main raymarch function for main image & reflections. \r\n */\r\nMarchResult raymarch(vec3 cam, vec3 rd){\r\n    float t = 0.0;\r\n    vec3 col = vec3(0.);\r\n    O res;\r\n    int steps = 0;\r\n    vec3 p = vec3(0.);\r\n    for( int i = 0; i < 256; i++)\r\n    {\r\n        p = cam + rd*t;\r\n        res = map( p );\r\n        t+= res.mat < 10.0 ? res.dist : max(VOLUMETRIC_STEP, res.dist-VOLUMETRIC_STEP);\r\n        if(res.mat >= 10.0 && res.dist <VOLUMETRIC_STEP)// Materials over 10 are volumetric.\r\n        {\r\n            volumetric += vec3(10.9,10.6,10.55)*VOLUMETRIC_STEP;\r\n        }\r\n        else if(res.dist < STEP ) \r\n        {\r\n            // Ray trace hit an object\r\n            break;\r\n        }\r\n        if(t > MAXDIST) {\r\n            res.mat = -1.;\r\n            t = MAXDIST;\r\n            break;\r\n        }\r\n        \r\n        steps++;\r\n    }\r\n    MarchResult mr = MarchResult(res, steps, p, vec3(0), t);\r\n    // Only calculate normals if result material is [0,9]. Negative materials are skyhits, over 10 are volumetric\r\n    if(res.mat > -0.5 && res.mat < 9.5){\r\n        mr.normal = CalcNormal(mr.worldPosition);\r\n    }\r\n    return mr;\r\n}\r\n\r\nconst float STEP_LOW = 0.01;\r\n/**\r\n * Lower quality raymarch. Use for shadows etc. \r\n * Does not support volumetric materials.\r\n */\r\nMarchResult raymarchLow(vec3 cam, vec3 rd, float maxdist){\r\n    float t = 0.0;\r\n    vec3 col = vec3(0.);\r\n    O res;\r\n    int steps = 0;\r\n    vec3 p = vec3(0.);\r\n    float minval = 1.0;\r\n    for( int i = 0; i < 512; i++)\r\n    {\r\n        p = cam + rd*t;\r\n        res = map( p );\r\n        t+= max(STEP_LOW,res.dist);\r\n        // Only calculate how close the ray was to solid object.\r\n        if(res.mat < 9.5 && res.mat >0.5)\r\n        {\r\n            minval = min(minval, res.dist);\r\n        }\r\n        \r\n        if(res.dist < STEP_LOW && res.mat < 9.5 && res.mat >0.5 ) \r\n        {\r\n            // Ray trace hit an object\r\n            break;\r\n        }\r\n        if(t > maxdist) {\r\n            res.mat = -1.;\r\n            t = maxdist;\r\n            break;\r\n        }\r\n        \r\n        steps++;\r\n    }\r\n    if(steps >=512) res.mat = -1.0;\r\n    p.x = minval;\r\n    MarchResult mr = MarchResult(res, steps, p, vec3(0), t);\r\n    \r\n    return mr;\r\n}\r\n\r\nvoid colorize(MarchResult result, vec3 rayDir, out vec3 col){\r\n    // Black bg\r\n    col = vec3(0.);\r\n    vec3 p = result.worldPosition;\r\n    vec3 normal = result.normal;\r\n    \r\n    if(result.O.mat < -0.5)\r\n    {\r\n        //Skydome\r\n    }\r\n    else if (result.O.mat < 0.5) \r\n    {\r\n        // Ground\r\n        vec3 color = vec3(.1,0.1,0.1);/// ${color1};\r\n        col = color * ( ambience + \r\n                        ${color1} * Diffuse(p, light1, normal) +\r\n                        ${color2} * Diffuse(p, light2, normal) +\r\n                        ${color3} * Diffuse(p, light3, normal)\r\n                      );        \r\n\r\n        vec4 biomeD = texture(biome, wpToTexture(p.xz));\r\n        col = biomeD.xyz; \r\n    }\r\n    else if(result.O.mat < 1.5)\r\n    {\r\n        // Cube       \r\n        vec3 color = vec3(1.0,0.5,0.0);/// ${color1};\r\n        col = color * ( ambience + \r\n                        ${color1} * Diffuse(p, light1, normal) +\r\n                        ${color2} * Diffuse(p, light2, normal) +\r\n                        ${color3} * Diffuse(p, light3, normal)\r\n                      );\r\n        \r\n        // Shadow calculate\r\n        MarchResult shadowMarch = raymarchLow( p+normal*STEP_LOW, normalize( light1-p ), distance(light1,p)   );\r\n        \r\n        //col*= 0.5 + 0.5*smoothstep(0.0,0.1,shadowMarch.worldPosition.x);\r\n    }\r\n}\r\n\r\nvoid render( vec2 uv, out vec4 diffuse)\r\n{\r\n    vec3 rd = getCameraRayDir( uv, camera, target, fov);\r\n    MarchResult result= raymarch(camera, rd);\r\n    colorize(result, rd, diffuse.rgb);\r\n    diffuse.a = result.travel/MAXDIST;\r\n    \r\n    diffuse.rgb = mix(diffuse.rgb, vec3(0), smoothstep(MAXDIST*3.0/4.0, MAXDIST, result.travel));\r\n}\r\n\r\nvec4 Main(vec2 uv, float AA)\r\n{\r\n    // Output to screen\r\n    vec4 emissive = vec4(0.);\r\n    vec4 col = vec4(0.);\r\n    render(uv, col);\r\n    return col + vec4(volumetric/(1.0+AA),0.0);\r\n}\r\n\r\nfloat AA = ${AA-LEVEL};\r\n\r\nvoid main()\r\n{\r\n    vec2 uv = (gl_FragCoord.xy/resolution.xy-0.5)*2.0;\r\n    uv.y*=resolution.y/resolution.x;\r\n    \r\n\tvec4 col = Main( uv, AA );\r\n    float count = 1.0;\r\n    vec2 aaStep = vec2(1.0/AA) / resolution.xy;\r\n    for( float aaX = 0.0; aaX < AA; aaX++)\r\n    {\r\n        for( float aaY = 0.0; aaY < AA; aaY++)\r\n        {\r\n            col += Main( uv + vec2( aaX, aaY ) * aaStep, AA );\r\n            count++;\r\n        }\r\n    }\r\n    col /= count;\r\n    \r\n    // Output to screen\r\n    outColor = col;\r\n}\r\n")}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:k.f1,value:0}),this.cameraU=this.CreateUniform({name:"camera",type:k.f3v,value:[0,2,4]}),this.targetU=this.CreateUniform({name:"target",type:k.f3v,value:[0,0,0]}),this.light1U=this.CreateUniform({name:"light1",type:k.f3v,value:[0,1,0]}),this.light2U=this.CreateUniform({name:"light2",type:k.f3v,value:[0,.7,-1]}),this.light3U=this.CreateUniform({name:"light3",type:k.f3v,value:[0,.7,1]}),this.fovU=this.CreateUniform({name:"fov",type:k.f1,value:1.1,max:20}),this.biomeLocation=this.renderer.context.getUniformLocation(this.program,"biome")}start(t,e){super.start(t,e),this.timeU.value=.001*t.toMilliseconds()}update(t){super.update(t),this.timeU.value=.001*t.toMilliseconds(),this.light1U.value=this.cameraU.value,this.light2U.value=this.cameraU.value,this.light3U.value=this.cameraU.value}render(t,e,n){this.renderer.context.uniform1i(this.biomeLocation,0),n.activeTexture(n.TEXTURE0),n.bindTexture(n.TEXTURE_2D,Bd.get("textures/tech1_height.jpg")),super.render(t,e,n)}}class Od extends Cd{features=new Set([C.DefaultAudioFilters,C.DefaultPostProcess,C.EnableAudioAnalyzer,C.EnablePostProcess,C.DefaultOnRender]);water;constructor(t){super(t)}initPreCompile(){super.initPreCompile()}init(){super.init(),gu(this.context),this.context.saveState(),this.scene=new ds,this.camera=new is(75,this.renderer.options.width/this.renderer.options.height,.1,1e3),this.camera.fov=110,this.camera.updateProjectionMatrix();const t=new Ya(.815,.815,.815),e=new _a({color:16772656}),r=new ja(t,e);this.scene.add(r),this.camera.position.z=22,this.camera.position.x=23,this.camera.position.y=7,this.camera.lookAt(new br(0,0,0));const i=this.postProcessing.As();i.DoF.amount.value=.4,i.BarrelDistort.amount.value=-.3,i.ColorAdjustment.brightness.value=-.1,i.ColorAdjustment.contrast.value=1.2,i.ColorAdjustment.exposure.value=1.3,this.addCurve(new p(0,0,0,h.RELATIVE),new p(12,0,0,h.RELATIVE),t=>{r.position.y=Math.sin(10*t),this.camera.lookAt(new br(14+t,-26,19)),this.camera.rotation.x=-1-.4*t;const e=Math.abs(Math.cos(7*t));i.DoF.amount.value=e*e*e*e*e*e*.4+.4,i.Vignetting.vignetting.value=1+e*e*e*.5});let a=0;this.addCurve(new p(47,0,0,h.ABSOLUTE),new p(49,0,0,h.ABSOLUTE),t=>{i.ColorAdjustment.exposure.value=1.3-.3*t,i.ColorAdjustment.brightness.value=-.1-Ht(t),a||(g.instance.overlay.showImage("outro.png",{x:960,y:540}),a=1),g.instance.overlay.elements.get("outro.png").style.opacity=100*n.clamp(0,1,2*t)+"%"});const s=new Su;s.setDecoderPath("jsm/libs/draco/gltf/");const o=new Ru,l=[],c=[],u=new Ot(1233);for(let t=0;t<256;t++)c.push(u.nextFloat()-.5);o.setDRACOLoader(s),o.load("ant.png",t=>{const e=t.scene.children[0];e.material=new _o({color:0}),this.scene.add(t.scene);for(let t=0;t<16;t++)for(let i=0;i<16;i++){const a=e.clone();this.scene.add(a),a.position.z=15*i-20+10*c[16*i+t],a.position.x=7.5*t+(i%2==0?4.5:0)-20+-12*c[16*t+i],l.push(e.clone());const s=r.clone();this.addCurve(new p(0,0,0,h.RELATIVE),new p(4,0,0,h.RELATIVE),e=>{const r=Math.floor(4*e),o=4*e%1,l=n.normalizeValue(0,1,o);a.position.y=.15*Math.sin(l*Math.PI*8),a.position.z=15*i+2*r+2*o-20+7*c[16*i+t],a.matrixWorldNeedsUpdate=1,a.rotation.y=.1*Math.sin(l*Math.PI*4)+Math.PI/2,s.position.set(a.position.x-0,a.position.y+1.2,a.position.z+4)})}});const d=new vo(1e4,1e4);this.water=new Pd(d,{textureWidth:512,textureHeight:512,waterNormals:(new $o).load("waternormals.jpg",function(t){t.wrapS=t.wrapT=De}),sunDirection:new br,sunColor:16777215,waterColor:7695,distortionScale:3.7,fog:0}),this.water.material.uniforms.size.value=10,this.water.rotation.x=-Math.PI/2,this.scene.add(this.water);const f=new Dd;f.scale.setScalar(1e4),this.scene.add(f);const m=f.material.uniforms;m.turbidity.value=10,m.rayleigh.value=2,m.mieCoefficient.value=.005,m.mieDirectionalG.value=.8;const v=4,x=180,_=new Jl(this.getThreeRenderer()),y=new ds;let b;const E=new br;(()=>{const t=xr.degToRad(90-v),e=xr.degToRad(x);E.setFromSphericalCoords(1,t,e),f.material.uniforms.sunPosition.value.copy(E),this.water.material.uniforms.sunDirection.value.copy(E).normalize(),void 0!==b&&b.dispose(),y.add(f),b=_.fromScene(y),this.scene.add(f),this.scene.environment=b.texture})()}start(t,e){super.start(t,e)}update(t){super.update(t)}render(t,e,n){super.render(t,e,n),this.water.material.uniforms.time.value=t.toMilliseconds()/6e3}}class Fd extends Lt{features=new Set([C.EnableAudioAnalyzer,C.DefaultOnRender]);timeU;heightU;transitionU;foamColorU;beerColorU;textureLocations=[];from;to;low=0;first=0;constructor(t,e,n,r=0,i=0){super(t,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nlayout(location = 0) out vec4 outColor;\r\n\r\nuniform vec2 resolution;\r\nuniform float time;\r\nuniform float height;\r\nuniform sampler2D perlin;\r\nuniform sampler2D partA;\r\nuniform sampler2D partB;\r\nuniform vec3 colorFoam;\r\nuniform vec3 colorBeer;\r\nuniform float transition;\r\n\r\nconst float PI2 = 6.28318530717;\r\nconst float PI = 3.14159265359;\r\nconst float PHI = 1.61803398874;\r\nconst vec3 V3Z = vec3(0.);\r\n\r\n#define HASHSCALE1 .1031\r\nfloat Hash(float p)\r\n{\r\n\tvec3 p3  = fract(vec3(p) * HASHSCALE1);\r\n    p3 += dot(p3, p3.yzx + 19.19);\r\n    return fract((p3.x + p3.y) * p3.z);\r\n}\r\n\r\nfloat Noise( in vec3 x ) { // in [0,1]\r\n    vec3 p = floor(x);\r\n    vec3 f = fract(x);\r\n\r\n    f = f*f*(3.-2.*f);\r\n\r\n    float n = p.x + p.y*57. + 113.*p.z;\r\n\r\n    float res = mix(mix(mix( Hash(n+  0.), Hash(n+  1.),f.x),\r\n                        mix( Hash(n+ 57.), Hash(n+ 58.),f.x),f.y),\r\n                    mix(mix( Hash(n+113.), Hash(n+114.),f.x),\r\n                        mix( Hash(n+170.), Hash(n+171.),f.x),f.y),f.z);\r\n    return res;\r\n}\r\n\r\nfloat SNoise( in vec3 x ) {\r\n    return Noise(x) * 2.0 - 1.0;\r\n}\r\n\r\n\r\nvec4 Main(vec2 uv, float AA)\r\n{\r\n    vec4 col = vec4(0.);\r\n    float foamHeight = (sin(uv.x*8.0+time*2.3)*0.1+\r\n                       sin(uv.x*-11.9130-0.932*time-0.8)*0.1+\r\n                       sin(uv.x*+7.1130+1.62*time)*0.05)*0.1;\r\n    float foamHeight2 = (sin(-uv.x*6.0-time*3.3)*0.1+\r\n                       sin(uv.x*-3.9130-1.832*time+0.4)*0.1+\r\n                       sin(uv.x*+1.1130+3.62*time)*0.05)*0.1;\r\n    \r\n    float foamDistance = distance(uv.y,foamHeight+height);\r\n    float foamDistance2 = distance(uv.y,foamHeight2+height);\r\n    \r\n    float beerAmount = (1.0-smoothstep(foamHeight+height-0.04,foamHeight+height, uv.y));\r\n\r\n    vec4 texA = texelFetch( partA, ivec2(gl_FragCoord.xy), 0);\r\n    vec4 texB = texelFetch( partB, ivec2(gl_FragCoord.xy), 0);\r\n    \r\n    vec4 colA = mix(texA, texB, transition);\r\n    vec4 colB = mix(texA, texB, 1.0-transition);\r\n\r\n    if(transition>=1.0-0.01) colB=colA;\r\n    col = mix(colB, colA, step(foamHeight+height,uv.y));\r\ncol.a =1.0;\r\n    col.rgb += smoothstep(0.04,0.02,foamDistance)*colorFoam+smoothstep(0.05,0.03,foamDistance2)*colorFoam;\r\n    col.rgb = mix(col.rgb,beerAmount*colorBeer * mix(1.0,0.7,smoothstep(0.,1.25,abs(uv.x))),0.84*beerAmount);\r\n\r\n\r\n    \r\n    // float bubbles1 = texture(perlin,uv*44.0-vec2(sin(time+uv.y)*0.1, 3.5*time)).r;\r\n    // float bubbles2 = texture(perlin,vec2(0.3)+uv*24.1-vec2(sin(time+uv.y*0.97)*0.1, 2.51*time)).r;\r\n    // float bubbles3 = texture(perlin,vec2(-0.4)+uv*14.2-vec2(sin(time+uv.y*0.95)*0.1 ,7.53*time)).r;\r\n    // float bAmount = smoothstep(0.6,0.7,0.33*(bubbles1+bubbles2+bubbles3))*beerAmount;\r\n    // col.rgb+=bAmount*vec3(2.0);\r\n\r\n    \r\n\r\n\r\n    return col;\r\n}\r\n\r\nfloat AA = ${AA-LEVEL};\r\n\r\nvoid main()\r\n{\r\n    vec2 uv = (gl_FragCoord.xy/resolution.xy-0.5)*2.0;\r\n    uv.y*=resolution.y/resolution.x;\r\n    \r\n\tvec4 col = Main( uv, AA );\r\n    float count = 1.0;\r\n    vec2 aaStep = vec2(1.0/AA) / resolution.xy;\r\n    for( float aaX = 0.0; aaX < AA; aaX++)\r\n    {\r\n        for( float aaY = 0.0; aaY < AA; aaY++)\r\n        {\r\n            col += Main( uv + vec2( aaX, aaY ) * aaStep, AA );\r\n            count++;\r\n        }\r\n    }\r\n    col /= count;\r\n    \r\n    // Output to screen\r\n    outColor = col;\r\n}\r\n"),this.first=i,this.low=r,this.from=e,this.to=n}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:k.f1,value:0}),this.heightU=this.CreateUniform({name:"height",type:k.f1,value:-1.1,max:2}),this.transitionU=this.CreateUniform({name:"transition",type:k.f1,value:0,max:1}),this.foamColorU=this.CreateUniform({name:"colorFoam",type:k.f3v,value:[1,1,1],min:-1,max:2}),this.beerColorU=this.CreateUniform({name:"colorBeer",type:k.f3v,value:[.88,.56,.17],min:-1,max:2}),this.textureLocations=[this.renderer.context.getUniformLocation(this.program,"perlin"),this.renderer.context.getUniformLocation(this.program,"partA"),this.renderer.context.getUniformLocation(this.program,"partB")],this.first?(this.addCurve(new p(0,0,0,h.RELATIVE),new p(3,0,0,h.RELATIVE),t=>{this.transitionU.value=0,this.heightU.value=(this.low?.71:1.56)*Gt(t)-1}),this.addCurve(new p(3,0,0,h.RELATIVE),new p(3,1,0,h.RELATIVE),t=>{this.low||(this.transitionU.value=1,this.heightU.value=.56-2*t)})):(this.addCurve(new p(0,0,0,h.RELATIVE),new p(0,2,0,h.RELATIVE),t=>{this.transitionU.value=0,this.heightU.value=(this.low?.71:1.56)*Gt(t)-1}),this.addCurve(new p(0,2,0,h.RELATIVE),new p(0,3,0,h.RELATIVE),t=>{this.low||(this.transitionU.value=1,this.heightU.value=.56-2*t)}))}start(t,e){super.start(t,e),this.timeU.value=.001*t.toMilliseconds()}update(t){super.update(t),this.timeU.value=.005*t.toMilliseconds()}render(t,e,n){for(let t=0;t<this.textureLocations.length;t++)this.renderer.context.uniform1i(this.textureLocations[t],t);n.activeTexture(n.TEXTURE0),n.bindTexture(n.TEXTURE_2D,Bd.get("perlin-512.png")),n.activeTexture(n.TEXTURE1),n.bindTexture(n.TEXTURE_2D,g.instance.getPart(this.from).getRTWebglTexture()),n.activeTexture(n.TEXTURE2),n.bindTexture(n.TEXTURE_2D,g.instance.getPart(this.to).getRTWebglTexture()),super.render(t,e,n)}}const Bd=new Map;new class{config;partInitalizers=[];postProcessInitializers=[];filterInitializer=void 0;postProcesses=new Map;filters=new Map;setupEventListeners={};partRender=void 0;constructor(t){this.config=t}isConstructor(t){return!!t.prototype}addPart(t){return this.isConstructor(t)?this.partInitalizers.push(()=>new t):this.partInitalizers.push(t),this}addDefaultPost(t,e,n){return this.postProcessInitializers.push({name:e??t.name,initializer:r=>{const i=new t(g.instance.renderer,r?{...n,...r}:n);return e&&(i.name=e),i}}),this}addDefaultAudioFilters(t){return this.filterInitializer=t,this}onSetup(t){if(this.setupEventListeners.onSetup)throw new Error("Only one onSetup allowed.");return this.setupEventListeners.onSetup=t,this}onBuilt(t){if(this.setupEventListeners.onSetup)throw new Error("Only one onBuilt allowed.");return this.setupEventListeners.onBuilt=t,this}onStart(t){if(this.setupEventListeners.onSetup)throw new Error("Only one onStart allowed.");return this.setupEventListeners.onStart=t,this}onPartRender(t){if(this.partRender)throw new Error("Only one onPartUpdate allowed");return this.partRender=t,this}buildParts(){return this.partInitalizers.map(t=>t())}onPartPreCompile(t){const e={};this.postProcessInitializers.forEach(n=>{const r=Reflect.get(t,"common"),i=r?Reflect.get(r,n.name):{},a=n.initializer(i);t.postProcessing.attach(a,a.name),e[a.name]=a}),this.postProcesses.set(t.id,e)}onPartInit(t){const e=this.filterInitializer?.(t);e&&this.filters.set(t.id,e)}update(t,e){this.partRender?.(t,e,this.postProcesses.get(e.id),this.filters.get(e.id))}build(){return new ut(this.config,this.buildParts(),this.setupEventListeners,{onPartPreCompile:t=>this.onPartPreCompile(t),onPartInit:t=>this.onPartInit(t),onPartRender:(t,e)=>this.update(t,e)}),this}}(Pt).addPart(()=>new It("example")).addPart(()=>new Nt("water")).addPart(()=>new Yt("grill")).addPart(()=>new Md("henrintest2")).addPart(()=>new Id("threejsisland")).addPart(()=>new Rd("tikkataulu")).addPart(()=>new Nd("terrain")).addPart(()=>new Od("ants")).addPart(()=>new Fd("beeroverlay","tikkataulu","threejsisland",0,1)).addPart(()=>new Fd("beeroverlay2","threejsisland","grill")).addPart(()=>new Fd("beeroverlay3","grill","grill")).addPart(()=>new Fd("beeroverlay4","grill","tikkataulu")).addPart(()=>new Fd("beeroverlay5","ants","ants",1,0)).addDefaultPost(class extends dt{name="Rain";time;intensity;color;options;constructor(t,e){super(t,void 0,"#version 300 es\r\n//based on https://www.shadertoy.com/view/4sXSWs\r\nprecision highp float;\r\n\r\nuniform sampler2D texture;\r\nuniform float intensity;\r\nuniform vec3 color;\r\nuniform float time;\r\nuniform vec2 resolution;\r\n\r\nout vec4 outColor;\r\n#define HASHSCALE1 .1031\r\nfloat Hash(float p)\r\n{\r\n\tvec3 p3  = fract(vec3(p) * HASHSCALE1);\r\n    p3 += dot(p3, p3.yzx + 19.19);\r\n    return fract((p3.x + p3.y) * p3.z);\r\n}\r\n\r\nfloat Noise( in vec3 x ) { // in [0,1]\r\n    vec3 p = floor(x);\r\n    vec3 f = fract(x);\r\n\r\n    f = f*f*(3.-2.*f);\r\n\r\n    float n = p.x + p.y*57. + 113.*p.z;\r\n\r\n    float res = mix(mix(mix( Hash(n+  0.), Hash(n+  1.),f.x),\r\n                        mix( Hash(n+ 57.), Hash(n+ 58.),f.x),f.y),\r\n                    mix(mix( Hash(n+113.), Hash(n+114.),f.x),\r\n                        mix( Hash(n+170.), Hash(n+171.),f.x),f.y),f.z);\r\n    return res;\r\n}\r\n\r\nfloat SNoise( in vec3 x ) {\r\n    return Noise(x) * 2.0 - 1.0;\r\n}\r\n\r\nvoid main() \r\n{\r\n    vec2 uv = gl_FragCoord.xy / resolution;\r\n    vec2 p = -1.0+2.0*uv;\r\n    p.x *= resolution.x/resolution.y;\r\n\tvec2 st =  p * vec2(.5, .01)+vec2(time*.3-uv.y*.6*-0.25, time*.3);\r\n    \r\n    float f = SNoise(vec3(st*120.0,time));// * rand(st*0.773)*1.55;\r\n    float f2 = SNoise(vec3(vec2(0.9823,0.12)+st*320.0,time));// * rand(st*0.773)*1.55;\r\n    f+=f2;\r\n    f = max(0.0,f-intensity);\r\n    f = clamp(pow(abs(f), 1.0) * 1.0, 0.0, uv.y*.34) * (1.0);\r\n    \r\n    vec4 base = texelFetch( texture, ivec2(gl_FragCoord.xy), 0);\r\n\t//base.rgb = mix(base.rgb+ f*color, f*color, smoothstep(0.0, 0.45,f));\r\n    base.rgb += f*color;\r\n    \r\n    outColor = base;\r\n}"),this.options={...Ut,...e}}programReady(){super.programReady(),this.buildUniforms([{name:"intensity",type:k.f1,value:this.options.intensity,min:-1,max:5,generateDebugSlider:1},{name:"time",type:k.f1,value:0},{name:"resolution",type:k.f2v,value:[this.renderer.options.width,this.renderer.options.height]},{name:"color",type:k.f3v,value:this.options.color,min:-2,max:2}],this.program),this.time=this.uniforms.get(this.program).get("time"),this.intensity=this.uniforms.get(this.program).get("intensity"),this.color=this.uniforms.get(this.program).get("color")}},"Rain",{}).addDefaultPost(class extends dt{name="BarrelDistort";amount;constructor(t){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D tex;\r\nuniform float amount;\r\nuniform vec2 resolution;\r\n\r\nout vec4 outColor;\r\n\r\nvec2 barrelDistortion(vec2 uv, float k)\r\n{\r\n  float rd = length(uv);    \r\n  float ru = rd * (1.0 + k * rd * rd);\r\n  uv /= rd;\r\n  uv *= ru;\r\n  return uv;\r\n}\r\n\r\nvoid main() {\r\n    vec2 uv = gl_FragCoord.xy / resolution - vec2(0.5);\r\n    uv = barrelDistortion(uv, amount);\r\n    uv += 0.5;\r\n    vec4 c = texture(tex, uv);\r\n    outColor = c;\r\n  }")}programReady(){super.programReady(),this.buildUniforms([{name:"amount",type:k.f1,value:0,min:-5,max:5,generateDebugSlider:1},{name:"resolution",type:k.f2v,value:[this.renderer.options.width,this.renderer.options.height]}],this.program),this.amount=this.uniforms.get(this.program).get("amount")}},"BarrelDistort",{}).addDefaultPost(class extends dt{name="DoF";amount;radius;direction;focus;aperture;range;options;constructor(t,e){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D original;\r\nuniform float radius;\r\nuniform float amount;\r\nuniform vec2 direction;\r\nuniform float focus;\r\nuniform float aperture;\r\nuniform vec2 size;\r\nuniform float range;\r\n\r\nout vec4 outColor;\r\n\r\nconst float STEPS = 80.;\r\n\r\nfloat SCurve (float x) {\r\n\t\r\n    \r\n\t\tx = x * 2.0 - 1.0;\r\n\t\treturn -x * abs(x) * 0.5 + x + 0.5;\r\n\t\t\r\n        //return dot(vec3(-x, 2.0, 1.0 ),vec3(abs(x), x, 1.0)) * 0.5; // possibly faster version\r\n\r\n}\r\n\r\nvec3 blur( float radius, ivec2 pos)\r\n{\r\n    if(radius>1.)\r\n    {\r\n        vec2 uv = gl_FragCoord.xy/size;\r\n        float rm = 1./radius;\r\n        vec3 sum = vec3(0);\r\n        float divisor = 0.;\r\n        float stpY = 1./size.y;\r\n        float stpX = 1./size.x;\r\n        for( float i = -STEPS/2.; i < STEPS/2.; i++)\r\n        {\r\n            vec3 c = texture(original, uv + radius*direction*i/40.*vec2(stpX,stpY)).rgb;\r\n            sum +=c;\r\n            //float weight = SCurve( 1. - abs(i)*rm );\r\n            //sum += c * weight;\r\n            divisor++;// += weight;\r\n        }\r\n        return sum/divisor;\r\n    }\r\n    else\r\n    {\r\n        return texelFetch(original,pos,0).rgb;\r\n    }\r\n}\r\n\r\nvoid main() {\r\n    \r\n    ivec2 pos = ivec2(gl_FragCoord.xy);\r\n    vec4 base = texelFetch(original, pos,0);\r\n    vec4 blurred = vec4( blur(radius*(max(0.,abs(base.a-focus)-range)*amount)/aperture/**size.x/720.*/, pos), 1.);\r\n    \r\n    outColor = vec4(blurred.rgb, base.a);\r\n    \r\n}"),this.options={...pt,...e},ft=ft??t.createRenderTarget(),mt=mt??t.createFrameBuffer(ft),gt=gt??t.createRenderTarget(),vt=vt??t.createFrameBuffer(gt)}programReady(){super.programReady(),this.buildUniforms([{name:"amount",type:k.f1,value:this.options.amount,min:0,max:5,generateDebugSlider:1},{name:"radius",type:k.f1,value:this.options.radius,min:0,max:2,generateDebugSlider:1},{name:"size",type:k.f2,value:new M(this.renderer.options.width,this.renderer.options.height)},{name:"direction",type:k.f2v,value:this.options.direction},{name:"focus",type:k.f1,value:this.options.focus,min:0,max:1,generateDebugSlider:1},{name:"aperture",type:k.f1,value:this.options.aperture,min:0,max:1,generateDebugSlider:1},{name:"range",type:k.f1,value:this.options.range,min:0,max:1,generateDebugSlider:1}],this.program),this.amount=this.uniforms.get(this.program).get("amount"),this.radius=this.uniforms.get(this.program).get("radius"),this.direction=this.uniforms.get(this.program).get("direction"),this.focus=this.uniforms.get(this.program).get("focus"),this.aperture=this.uniforms.get(this.program).get("aperture"),this.range=this.uniforms.get(this.program).get("range"),this.renderer.context.useProgram(this.program),this.renderer.context.uniform1i(this.renderer.context.getUniformLocation(this.program,"tex"),1)}render(t,e,n,r){t.bindFramebuffer(t.FRAMEBUFFER,mt),t.useProgram(this.program),this.direction.value=[.866,.5],this.syncShader(this.uniforms.get(this.program)),t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,n),t.drawArrays(t.TRIANGLES,0,3),t.bindFramebuffer(t.FRAMEBUFFER,vt),t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,ft),this.direction.value=[0,1],this.direction.sync(),t.drawArrays(t.TRIANGLES,0,3),t.bindFramebuffer(t.FRAMEBUFFER,e),t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,gt),this.direction.value=[-.866,.5],this.direction.sync(),t.drawArrays(t.TRIANGLES,0,3)}},"DoF",{amount:3,aperture:.2,focus:.1,range:.2}).addDefaultPost(class extends dt{name="Kaleidoscope";amount;radius;radiusMultiplier;sections;offset;additive;additiveOpacity;colorChange;rotation;constructor(t){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D texture1;\r\nuniform float amount;\r\n\r\nuniform float radius;\r\nuniform float radiusMultiplier;\r\nuniform float sections;\r\nuniform vec2 offset;\r\nuniform vec2 resolution;\r\nuniform float additive;\r\nuniform float additiveOpacity;\r\nuniform vec3 colorChange;\r\nuniform float rotation;\r\n\r\nout vec4 outColor;\r\n\r\nvec2 kaleidoscope(vec2 uv)\r\n{\r\n    float th = atan(uv.x, uv.y);\r\n    float r = pow(length(uv), radius);\r\n    float f = 3.14159 / (sections);\r\n    float t = (sections/2.0);\r\n    th = abs(mod( th + f/4.0, f) - f/2.0) / (1.0 + r);\r\n    return vec2( cos(th), sin(th)) * r * radiusMultiplier;\r\n}\r\n\r\n/** Create a rotation matrix */\r\nmat2 Rot2D( float a )\r\n{\r\n    return mat2( cos(a), -sin(a), sin(a), cos(a) );\r\n}\r\n\r\n/** Rotate a vector with angle */\r\nvec2 Rot2DPoint( vec2 p, float a )\r\n{\r\n    return Rot2D(a) * p;\r\n}\r\n\r\nvoid main() \r\n{\r\n    vec2 uv = gl_FragCoord.xy / resolution;\r\n    uv.x = mix(-1.0, 1.0, uv.x);\r\n\tuv.y = mix(-1.0, 1.0, uv.y);\r\n\tuv.y *= resolution.y / resolution.x;\r\n    uv = Rot2DPoint(uv, rotation);\r\n    \r\n    vec4 oc = texelFetch(texture1, ivec2(gl_FragCoord.xy),0);\r\n    vec3 c = texture(texture1, mod( kaleidoscope((uv)*5.0)+offset, vec2(1.0))).rgb;\r\n    //vec4 c = texture(texture1, uv*5.0);\r\n    vec3 finalcol = mix( mix(oc.rgb,c, amount), oc.rgb + (1.0 - step(0.015,max(oc.x, max(oc.y,oc.z)))) * length(c)*colorChange * additiveOpacity, additive);\r\n    outColor = vec4(finalcol, oc.a);\r\n}\r\n  ")}programReady(){super.programReady(),this.buildUniforms([{name:"amount",type:k.f1,value:.85,min:0,max:1,generateDebugSlider:1},{name:"radius",type:k.f1,value:.9,min:0,max:10,generateDebugSlider:1},{name:"radiusMultiplier",type:k.f1,value:1.25,min:0,max:10,generateDebugSlider:1},{name:"sections",type:k.f1,value:Math.PI/2,min:0,max:100,generateDebugSlider:1},{name:"offset",type:k.f2v,value:[0,0],min:0,max:1,generateDebugSlider:1},{name:"additive",type:k.f1,value:0,min:0,max:1,generateDebugSlider:1},{name:"additiveOpacity",type:k.f1,value:0,min:0,max:1,generateDebugSlider:1},{name:"resolution",type:k.f2v,value:[this.renderer.options.width,this.renderer.options.height],generateDebugSlider:0},{name:"colorChange",type:k.f3v,value:[0,0,0],min:0,max:1,generateDebugSlider:1},{name:"rotation",type:k.f1,value:0,min:0,max:1,generateDebugSlider:1}],this.program),this.amount=this.uniforms.get(this.program).get("amount"),this.additive=this.uniforms.get(this.program).get("additive"),this.additiveOpacity=this.uniforms.get(this.program).get("additiveOpacity"),this.colorChange=this.uniforms.get(this.program).get("colorChange"),this.rotation=this.uniforms.get(this.program).get("rotation"),this.sections=this.uniforms.get(this.program).get("sections"),this.radius=this.uniforms.get(this.program).get("radius"),this.radiusMultiplier=this.uniforms.get(this.program).get("radiusMultiplier"),this.offset=this.uniforms.get(this.program).get("offset"),this.enabled=0}},"Kaleidoscope",{}).addDefaultPost(class extends dt{name="Godrays";center;amount;color;options;constructor(t,e){super(t,void 0,"#version 300 es\r\n//based on https://www.shadertoy.com/view/Xd3cRs\r\nprecision highp float;\r\n\r\nuniform sampler2D tex;\r\nuniform vec2 resolution;\r\n\r\nuniform vec2 center;\r\nuniform vec3 color;\r\nuniform float amount;\r\n\r\nout vec4 outColor;\r\n\r\n#define STEPS 256\r\nfloat sunShafts(vec2 uv) {\r\n    float sum = 0.0;\r\n    vec2 stepV = (uv - center) / float(STEPS);\r\n    \r\n    for(int i = 0; i < STEPS; i++) {\r\n        vec4 t =texture(tex, uv);\r\n        sum += t.w*length(t.rgb);\r\n        uv -= stepV;\r\n    }\r\n    \r\n    return sum / float(STEPS) * amount;\r\n}\r\n\r\nvoid main() \r\n{\r\n    vec2 uv = gl_FragCoord.xy / resolution;\r\n    float shafts = sunShafts(uv);\r\n    vec4 base = texture(tex,uv);\r\n    outColor = vec4(base.rgb+color*shafts, base.a);\r\n}\r\n\r\n    "),this.options={...Ct,...e}}programReady(){super.programReady(),this.buildUniforms([{name:"resolution",type:k.f2v,value:[this.renderer.options.width,this.renderer.options.height]},{name:"center",type:k.f2v,value:this.options.center,min:-2,max:3,generateDebugSlider:1},{name:"amount",type:k.f1,value:this.options.amount,min:0,max:2,generateDebugSlider:1},{name:"color",type:k.f3v,value:this.options.color,min:-5,max:5,generateDebugSlider:1}],this.program),this.center=this.uniforms.get(this.program).get("center"),this.amount=this.uniforms.get(this.program).get("amount"),this.color=this.uniforms.get(this.program).get("color")}},"Godrays",{}).addDefaultPost(class extends dt{name="DistortReplace";intensity;limit;splits;seed;offset;rotation;options;constructor(t,e=At){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D original;\r\n\r\n/** Seed to use with rng */\r\nuniform float seed;\r\n/** How many regions */\r\nuniform vec2 splits;\r\n/** At what random number does the stepping occur */\r\nuniform float limit;\r\n\r\n/** How intense the light is. */ \r\nuniform float intensity;\r\n\r\nuniform float rotation;\r\n\r\nuniform vec2 resolution;\r\n\r\nuniform vec4 offset;\r\n\r\nout vec4 outColor;\r\n\r\n#define HASHSCALE1 .1031\r\nfloat Hash(float p)\r\n{\r\n\tvec3 p3  = fract(vec3(p) * HASHSCALE1);\r\n    p3 += dot(p3, p3.yzx + 19.19);\r\n    return fract((p3.x + p3.y) * p3.z);\r\n}\r\nmat2 Rot2D( float a )\r\n{\r\n    return mat2( cos(a), -sin(a), sin(a), cos(a) );\r\n}\r\n\r\n\r\nvoid main() {\r\n    \r\n    ivec2 pos = ivec2(gl_FragCoord.xy);\r\n    vec4 base = texelFetch(original, pos,0);\r\n    \r\n    vec2 uv = gl_FragCoord.xy / resolution * Rot2D(rotation);\r\n    \r\n    uv.x += offset.x * (step(uv.y * offset.z,2.0)*2.0-1.0);\r\n    uv.y += offset.y * (step(uv.x * offset.w,2.0)*2.0-1.0);\r\n    \r\n    vec3 col = base.rgb;\r\n    \r\n    vec2 p = floor( uv * splits )/splits;\r\n    \r\n    float n = Hash( p.x * seed + p.y *seed * 3.33 + seed );\r\n    \r\n    vec3 extra = texture( original, mod(gl_FragCoord.xy/resolution + vec2( n*resolution.x, n+resolution.y ), vec2(1.0)) ).rgb;\r\n    \r\n    float add = step(n, limit) * intensity;\r\n    \r\n    col.rgb = mix( col.rgb, (add > 0.0 ? extra.rgb : col.rgb) , intensity );\r\n    \r\n    outColor = vec4(col.rgb , base.a);\r\n    \r\n}\r\n"),this.options={...At,...e},this.enabled=e.enabled??0}programReady(){super.programReady(),this.buildUniforms([{name:"intensity",type:k.f1,value:this.options.intensity,min:0,max:2,generateDebugSlider:1},{name:"limit",type:k.f1,value:this.options.limit,min:0,max:1,generateDebugSlider:1},{name:"splits",type:k.f2v,value:this.options.splits,min:[0,0],max:[100,100],generateDebugSlider:1},{name:"seed",type:k.f1,value:this.options.seed,min:-100,max:100,generateDebugSlider:1},{name:"resolution",type:k.f2v,value:[this.renderer.options.width,this.renderer.options.height]},{name:"offset",type:k.f4v,value:[0,0,0,0]},{name:"rotation",type:k.f1,value:this.options.rotation}]),this.intensity=this.uniforms.get(this.program).get("intensity"),this.limit=this.uniforms.get(this.program).get("limit"),this.splits=this.uniforms.get(this.program).get("splits"),this.seed=this.uniforms.get(this.program).get("seed"),this.offset=this.uniforms.get(this.program).get("offset"),this.rotation=this.uniforms.get(this.program).get("rotation")}render(t,e,n,r){t.bindFramebuffer(t.FRAMEBUFFER,e),t.useProgram(this.program),this.syncShader(this.uniforms.get(this.program)),t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,n),t.drawArrays(t.TRIANGLES,0,3)}},"DistortReplace",{splits:[1920/4.33,1080/4.33],intensity:1,enabled:0}).addDefaultPost(class extends dt{name="ChromaticAberration";intensity;lensing;options;constructor(t,e){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D tex;\r\nuniform float intensity;\r\nuniform float lensing;\r\nuniform vec2 resolution;\r\n\r\nout vec4 outColor;\r\n\r\nvoid main() \r\n{\r\n    vec2 uv = gl_FragCoord.xy / resolution;\r\n    vec2 cuv = uv-vec2(0.5);\r\n    vec2 off = normalize(cuv);\r\n    off *= intensity * ( length(cuv)*lensing);\r\n    \r\n    vec4 base = texture(tex, uv + off);\r\n    base.g = texture(tex, uv ).g;\r\n    base.b = texture(tex, uv + off).b;\r\n    \r\n    outColor = base;\r\n}"),this.options={..._t,...e}}programReady(){super.programReady(),this.buildUniforms([{name:"intensity",type:k.f1,value:this.options.intensity,min:0,max:1,generateDebugSlider:1},{name:"lensing",type:k.f1,value:this.options.lensing,min:-2,max:2,generateDebugSlider:1},{name:"resolution",type:k.f2v,value:[this.renderer.options.width,this.renderer.options.height]}],this.program),this.intensity=this.uniforms.get(this.program).get("intensity"),this.lensing=this.uniforms.get(this.program).get("lensing")}},"ChromaticAberration",{lensing:1,intensity:0}).addDefaultPost(class extends dt{name="Bloom";amount;radius;radiusY;thresholdLow;thresholdHigh;distance;distanceY;blurY;threshold;options;constructor(t,e){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D original;\r\nuniform sampler2D tex;\r\nuniform float radius;\r\nuniform float amount;\r\nuniform float distance;\r\n\r\nuniform vec2 size;\r\n\r\nout vec4 outColor;\r\n\r\nconst float STEPS = 80.;\r\n\r\nfloat SCurve (float x) {\r\n\t\r\n    \r\n\t\tx = x * 2.0 - 1.0;\r\n\t\treturn -x * abs(x) * 0.5 + x + 0.5;\r\n\t\t\r\n        //return dot(vec3(-x, 2.0, 1.0 ),vec3(abs(x), x, 1.0)) * 0.5; // possibly faster version\r\n\r\n}\r\n\r\nvec3 blur( float radius, ivec2 pos)\r\n{\r\n    if(radius>1.)\r\n    {\r\n        vec2 uv = gl_FragCoord.xy/size;\r\n        float rm = 1./radius;\r\n        vec3 sum = vec3(0);\r\n        float divisor = 0.;\r\n        float stp = 1./size.y;\r\n        for( float i = -STEPS/2.; i < STEPS/2.; i++)\r\n        {\r\n            vec3 c = texture(tex, uv + distance*vec2(0, i*stp)).rgb;\r\n            float weight = SCurve( 1. - abs(i)*rm );\r\n            sum += c * weight;\r\n            divisor += weight;\r\n        }\r\n        return sum/divisor;\r\n    }\r\n    else\r\n    {\r\n        return texelFetch(tex,pos,0).rgb;\r\n    }\r\n}\r\n\r\nvoid main() {\r\n    \r\n    ivec2 pos = ivec2(gl_FragCoord.xy);\r\n    vec4 blurred = vec4( blur(radius, pos), 1.);\r\n    vec4 base = texelFetch(original, pos,0);\r\n    \r\n    outColor = vec4(blurred.rgb * amount + base.rgb,base.a>1.0 ? 2.0 - base.a : 1.0);\r\n    \r\n}"),this.options={...St,...e},bt=bt??t.createRenderTarget(),yt=yt??t.createFrameBuffer(bt),Et=Et??t.createRenderTarget(),Tt=t.createFrameBuffer(Et),this.blurY=t.context.createProgram(),this.threshold=t.context.createProgram(),this.programs.push({program:this.blurY,fragmentShader:"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D tex;\r\nuniform float radius;\r\nuniform vec2 size;\r\nuniform float distance;\r\n\r\nout vec4 outColor;\r\n\r\nconst float STEPS = 40.;\r\n\r\nfloat SCurve (float x) {\r\n\t\r\n    \r\n\t\tx = x * 2.0 - 1.0;\r\n\t\treturn -x * abs(x) * 0.5 + x + 0.5;\r\n\t\t\r\n        //return dot(vec3(-x, 2.0, 1.0 ),vec3(abs(x), x, 1.0)) * 0.5; // possibly faster version\r\n\r\n}\r\n\r\nvec3 blur( float radius, ivec2 pos)\r\n{\r\n    if(radius>1.)\r\n    {\r\n        vec2 uv = gl_FragCoord.xy/size;\r\n        float rm = 1./radius;\r\n        vec3 sum = vec3(0);\r\n        float divisor = 0.;\r\n        float stp = 1./size.y;\r\n        \r\n        for( float i = -STEPS/2.; i < STEPS/2.; i++)\r\n        {\r\n            vec3 c = texture(tex, uv + distance*vec2(i*stp,0.)).rgb;\r\n            float weight = SCurve( 1. - abs(i)*rm );\r\n            sum += c * weight;\r\n            divisor += weight;\r\n        }\r\n        return sum/divisor;\r\n    }\r\n    else\r\n    {\r\n        return texelFetch(tex,pos,0).rgb;\r\n    }\r\n}\r\n\r\nvoid main() {\r\n    \r\n    ivec2 pos = ivec2(gl_FragCoord.xy);\r\n    vec4 blurred = vec4(blur(radius, pos),1.0);\r\n    outColor = blurred;\r\n    \r\n}"}),this.programs.push({program:this.threshold,fragmentShader:"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D tex;\r\nuniform vec3 thresholdHigh;\r\nuniform vec3 thresholdLow;\r\n\r\nout vec4 outColor;\r\n\r\nvoid main() {\r\n    \r\n    ivec2 pos = ivec2(gl_FragCoord.xy);\r\n    vec4 base = texelFetch(tex, pos,0);\r\n    \r\n    outColor = vec4(smoothstep(thresholdLow, thresholdHigh, base.rgb),1.0);\r\n}"})}programReady(){super.programReady(),this.buildUniforms([{name:"thresholdLow",type:k.f3v,value:"number"==typeof this.options.thresholdLow?[this.options.thresholdLow,this.options.thresholdLow,this.options.thresholdLow]:this.options.thresholdLow,min:0,max:2,generateDebugSlider:1},{name:"thresholdHigh",type:k.f3v,value:"number"==typeof this.options.thresholdHigh?[this.options.thresholdHigh,this.options.thresholdHigh,this.options.thresholdHigh]:this.options.thresholdHigh,min:0,max:2,generateDebugSlider:1}],this.threshold),this.thresholdLow=this.uniforms.get(this.threshold).get("thresholdLow"),this.thresholdHigh=this.uniforms.get(this.threshold).get("thresholdHigh"),this.buildUniforms([{name:"amount",type:k.f1,value:this.options.amount,min:0,max:5,generateDebugSlider:1},{name:"radius",type:k.f1,value:this.options.radius,min:0,max:500,generateDebugSlider:1},{name:"distance",type:k.f1,value:this.options.distance,min:0,max:5,generateDebugSlider:1},{name:"size",type:k.f2,value:new M(this.renderer.options.width,this.renderer.options.height)}]),this.amount=this.uniforms.get(this.program).get("amount"),this.radius=this.uniforms.get(this.program).get("radius"),this.distance=this.uniforms.get(this.program).get("distance"),this.buildUniforms([{name:"radius",type:k.f1,value:this.options.radiusY,min:0,max:500,generateDebugSlider:1},{name:"distance",type:k.f1,value:this.options.distanceY,min:0,max:5,generateDebugSlider:1},{name:"size",type:k.f2,value:new M(this.renderer.options.width,this.renderer.options.height)}],this.blurY),this.radiusY=this.uniforms.get(this.blurY).get("radius"),this.distanceY=this.uniforms.get(this.blurY).get("distance"),this.renderer.context.useProgram(this.program),this.renderer.context.uniform1i(this.renderer.context.getUniformLocation(this.program,"tex"),1)}render(t,e,n,r){t.bindFramebuffer(t.FRAMEBUFFER,Tt),t.useProgram(this.threshold),this.syncShader(this.uniforms.get(this.threshold)),t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,n),t.drawArrays(t.TRIANGLES,0,3),t.bindFramebuffer(t.FRAMEBUFFER,yt),t.useProgram(this.blurY),t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,Et),this.syncShader(this.uniforms.get(this.blurY)),t.drawArrays(t.TRIANGLES,0,3),t.bindFramebuffer(t.FRAMEBUFFER,e),t.useProgram(this.program),t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,n),t.activeTexture(t.TEXTURE1),t.bindTexture(t.TEXTURE_2D,bt),this.syncShader(this.uniforms.get(this.program)),t.drawArrays(t.TRIANGLES,0,3)}},"Bloom",{amount:1,radius:1,radiusY:1,distance:.25,distanceY:.25,thresholdHigh:1,thresholdLow:.9,enabled:0}).addDefaultPost(class extends dt{name="Vignetting";vignetting;options;constructor(t,e){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D texture;\r\n\r\nuniform float vignetting;\r\nuniform vec2 size;\r\n\r\n\r\nout vec4 outColor;\r\n\r\nvoid main() {\r\n    \r\n    vec2 uv = gl_FragCoord.xy/size;\r\n    float vign = 1.0-length(vec2(0.5,0.5)-uv)*vignetting;\r\n    vec4 c = texelFetch(texture, ivec2(gl_FragCoord.xy), 0);\r\n    c.rgb*=vign;\r\n    \r\n    outColor = c;\r\n  }"),this.options={...Mt,...e}}programReady(){super.programReady(),this.buildUniforms([{name:"vignetting",type:k.f1,value:this.options.vignetting,min:-5,max:5,generateDebugSlider:1},{name:"size",type:k.f2,value:new M(this.renderer.options.width,this.renderer.options.height)}],this.program),this.vignetting=this.uniforms.get(this.program).get("vignetting")}},"Vignetting",{}).addDefaultPost(class extends dt{name="ColorAdjustment";exposure;contrast;brightness;saturation;options;constructor(t,e){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D texture;\r\nuniform float exposure;\r\nuniform float brightness;\r\nuniform float contrast;\r\nuniform float saturation;\r\n\r\nout vec4 outColor;\r\n\r\nvoid main() {\r\n    \r\n    vec4 c = texelFetch(texture, ivec2(gl_FragCoord.xy),0);\r\n    \r\n    c.rgb = vec3(1.0) - exp(-c.rgb * exposure);\r\n    c.rgb*=contrast;\r\n    c.rgb += vec3(brightness);\r\n    c.rgb = max(vec3(0.), c.rgb);\r\n    \r\n    vec4 g = vec4( 0.21 * c.r + 0.71 * c.g + 0.07 * c.b );\r\n    c = mix(g,c,saturation);\r\n    \r\n    c.r += max(0.0, c.g-1.0) + max(0.0, c.b-1.0);\r\n    c.g += max(0.0, c.r-1.0) + max(0.0, c.b-1.0);\r\n    c.b += max(0.0, c.g-1.0) + max(0.0, c.r-1.0);\r\n    \r\n    outColor = c;\r\n  }"),this.options={...wt,...e}}programReady(){super.programReady(),this.buildUniforms([{name:"exposure",type:k.f1,value:this.options.exposure,min:0,max:5,generateDebugSlider:1},{name:"contrast",type:k.f1,value:this.options.contrast,min:0,max:5,generateDebugSlider:1},{name:"brightness",type:k.f1,value:this.options.brightness,min:-1,max:1,generateDebugSlider:1},{name:"saturation",type:k.f1,value:this.options.saturation,min:-1,max:2,generateDebugSlider:1}],this.program),this.exposure=this.uniforms.get(this.program).get("exposure"),this.contrast=this.uniforms.get(this.program).get("contrast"),this.brightness=this.uniforms.get(this.program).get("brightness"),this.saturation=this.uniforms.get(this.program).get("saturation")}},"ColorAdjustment",{contrast:1,brightness:0,exposure:1,saturation:1}).addDefaultPost(class extends dt{name="Grain";time;grain;noise;blueNoise;options;constructor(t,e){super(t,void 0,"#version 300 es\r\n//based on https://www.shadertoy.com/view/4sXSWs\r\nprecision highp float;\r\n\r\nuniform sampler2D texture;\r\nuniform float grainVal;\r\nuniform float noiseVal;\r\nuniform float time;\r\nuniform float blueNoiseVal;\r\n\r\nout vec4 outColor;\r\n\r\nfloat rand(vec2 co){\r\n    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);\r\n}\r\n\r\nvoid main() \r\n{\r\n    float grain = rand( (gl_FragCoord.xy*0.2+time)*0.356 );\r\n    grain = smoothstep(0.4, 0.9,grain)*grainVal;\r\n    float n = rand( (gl_FragCoord.xy+time*0.25)*0.156 );\r\n    vec4 base = texelFetch( texture, ivec2(gl_FragCoord.xy), 0);\r\n    \r\n    outColor = vec4(\r\n            base.rgb *(1.-grain) + \r\n            noiseVal*n + \r\n            blueNoiseVal* (vec3(1.0)-(normalize(base.rgb))) * n, \r\n        base.a\r\n    );\r\n}"),this.options={...xt,...e}}programReady(){super.programReady(),this.buildUniforms([{name:"grainVal",type:k.f1,value:this.options.grain,min:0,max:5,generateDebugSlider:1},{name:"noiseVal",type:k.f1,value:this.options.noise,min:0,max:5,generateDebugSlider:1},{name:"blueNoiseVal",type:k.f1,value:this.options.blueNoise,min:0,max:5,generateDebugSlider:1},{name:"time",type:k.f1,value:0}],this.program),this.time=this.uniforms.get(this.program).get("time"),this.grain=this.uniforms.get(this.program).get("grainVal"),this.noise=this.uniforms.get(this.program).get("noiseVal"),this.blueNoise=this.uniforms.get(this.program).get("blueNoiseVal")}},"Grain",{grain:.03,blueNoise:.05,noise:0}).addDefaultPost(class extends dt{name="CGA";clipping;clipColor;constructor(t){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D texture1;\r\nuniform vec4 clipping;\r\nuniform vec4 clipColor;\r\nuniform vec2 resolution;\r\n\r\nout vec4 outColor;\r\n\r\nvoid main() {\r\n    vec2 uv =  gl_FragCoord.xy/resolution;\r\n    vec4 c = texture(texture1, uv );\r\n    float top = step(1.0-clipping.x, uv.y);\r\n    float bottom = 1.0-step(clipping.z, uv.y);\r\n    float left = 1.0 - step(clipping.y, uv.x);\r\n    float right = step(1.0-clipping.w, uv.x);\r\n    vec4 col = mix(max(vec4(0.0), c),clipColor, min(1.0, top + bottom + left + right) );\r\n    col.a = 1.0;\r\n    outColor = col;\r\n  }\r\n  ")}programReady(){super.programReady(),this.buildUniforms([{name:"clipping",type:k.f4v,value:[0,0,0,0],min:0,max:1,generateDebugSlider:1},{name:"clipColor",type:k.f4v,value:[0,0,0,1],min:0,max:1,generateDebugSlider:1},{name:"resolution",type:k.f2v,value:[this.renderer.options.width,this.renderer.options.height]}],this.program),this.clipping=this.uniforms.get(this.program).get("clipping"),this.clipColor=this.uniforms.get(this.program).get("clipColor")}},"Clipping",{}).addDefaultPost(class extends dt{name="Feedback";offset;rotation;scale;pivot;addAmount;textures=[];buffers=[];sampleFrames=1;active=0;options;first=1;constructor(t,e){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D original;\r\nuniform sampler2D tex0;\r\n\r\nuniform vec2 resolution;\r\nuniform vec2 offset;\r\nuniform float rotation;\r\nuniform vec2 scale;\r\nuniform vec2 pivot;\r\nuniform float addAmount;\r\n\r\nout vec4 outColor;\r\n\r\nvoid main() {\r\n    \r\n    ivec2 pos = ivec2(gl_FragCoord.xy);\r\n    vec4 base = texelFetch(original, pos,0);\r\n    \r\n    vec2 uv = gl_FragCoord.xy/resolution.xy;\r\n\r\n    uv -= pivot;\r\n    uv *= scale;\r\n    uv += pivot;\r\n\r\n    vec4 history1 = texture(tex0, uv);\r\n    \r\n    vec3 col = base.rgb;\r\n    col.rg += offset + scale + pivot;\r\n    col.b = rotation + addAmount;\r\n    \r\n    col = base.rgb + clamp( history1.rgb * addAmount, vec3(0.0), vec3(1.0));\r\n\r\n    outColor = vec4(col.rgb, base.a);\r\n    \r\n}"),this.options={...Rt,...e};for(let e=0;e<this.sampleFrames;e++)this.textures.push(t.createRenderTarget()),this.buffers.push(t.createFrameBuffer(this.textures[this.textures.length-1]));this.enabled=this.options.enabled}programReady(){super.programReady(),this.buildUniforms([{name:"rotation",type:k.f1,value:this.options.rotation,min:-Math.PI,max:Math.PI,generateDebugSlider:1},{name:"offset",type:k.f2v,value:this.options.offset,min:[-1,-1],max:[1,1],generateDebugSlider:1},{name:"scale",type:k.f2v,value:this.options.scale,min:[0,0],max:[2,2],generateDebugSlider:1},{name:"pivot",type:k.f2v,value:this.options.pivot,min:[-1,-1],max:[1,1],generateDebugSlider:1},{name:"addAmount",type:k.f1,value:this.options.addAmount,min:0,max:2,generateDebugSlider:1},{name:"resolution",type:k.f2v,value:[this.renderer.options.width,this.renderer.options.height]}]),this.rotation=this.uniforms.get(this.program).get("rotation"),this.offset=this.uniforms.get(this.program).get("offset"),this.scale=this.uniforms.get(this.program).get("scale"),this.pivot=this.uniforms.get(this.program).get("pivot"),this.addAmount=this.uniforms.get(this.program).get("addAmount"),this.renderer.context.useProgram(this.program);for(let t=0;t<this.sampleFrames;t++)this.renderer.context.uniform1i(this.renderer.context.getUniformLocation(this.program,`tex${t}`),t+1)}blit(t){t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,this.textures[this.active]),this.active=(this.active+1)%this.textures.length,t.copyTexImage2D(t.TEXTURE_2D,0,t.RGBA16F,0,0,this.renderer.options.canvas.width,this.renderer.options.canvas.height,0)}render(t,e,n,r){this.first&&(this.first=0),t.bindFramebuffer(t.FRAMEBUFFER,e),t.useProgram(this.program),this.syncShader(this.uniforms.get(this.program)),t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,n);for(let e=0;e<this.sampleFrames;e++)t.activeTexture(t.TEXTURE0+e+1),t.bindTexture(t.TEXTURE_2D,this.textures[e]);t.drawArrays(t.TRIANGLES,0,3)}postRender(t,e,n,r){this.blit(t)}},"Feedback",{addAmount:.75,offset:[0,0],pivot:[.5,.5],rotation:0,scale:[.97,.97],enabled:0}).addDefaultPost(class extends dt{name="FrameDelta";textures=[];buffers=[];sampleFrames;active=0;amountBase;amountDelta;options;constructor(t,e=Dt){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D original;\r\nuniform sampler2D tex0;\r\n\r\nuniform float amountBase;\r\nuniform float amountDelta;\r\n\r\nout vec4 outColor;\r\n\r\nvoid main() {\r\n    \r\n    ivec2 pos = ivec2(gl_FragCoord.xy);\r\n    vec4 base = texelFetch(original, pos,0);\r\n    vec4 history = texelFetch(tex0, pos,0);\r\n    \r\n    vec4 col = base * amountBase +  abs(base-history) * amountDelta;\r\n    \r\n    outColor = vec4(col.rgb, base.a);\r\n    \r\n}"),this.options={...Dt,...e},this.enabled=e.enabled,this.sampleFrames=this.options.sampleFrames;for(let e=0;e<this.sampleFrames;e++)this.textures.push(t.createRenderTarget()),this.buffers.push(t.createFrameBuffer(this.textures[this.textures.length-1]))}programReady(){super.programReady(),this.buildUniforms([{name:"amountBase",type:k.f1,value:this.options.amountBase,min:0,max:1,generateDebugSlider:1},{name:"amountDelta",type:k.f1,value:this.options.amountDelta,min:0,max:1,generateDebugSlider:1}]),this.amountBase=this.uniforms.get(this.program).get("amountBase"),this.amountDelta=this.uniforms.get(this.program).get("amountDelta"),this.renderer.context.useProgram(this.program),this.renderer.context.uniform1i(this.renderer.context.getUniformLocation(this.program,"tex0"),1)}render(t,e,n){t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,this.textures[this.active]),this.active=(this.active+1)%this.textures.length,t.copyTexImage2D(t.TEXTURE_2D,0,t.RGBA16F,0,0,this.renderer.options.canvas.width,this.renderer.options.canvas.height,0),t.bindFramebuffer(t.FRAMEBUFFER,e),t.useProgram(this.program),this.syncShader(this.uniforms.get(this.program)),t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,n),t.activeTexture(t.TEXTURE0+1),t.bindTexture(t.TEXTURE_2D,this.textures[this.active]),t.drawArrays(t.TRIANGLES,0,3)}},"FrameDelta",{enabled:0}).addDefaultPost(class extends dt{name="TextureOverlay";opacity;options;constructor(t,e){super(t,void 0,"#version 300 es\r\n\r\nprecision highp float;\r\n\r\nuniform sampler2D texture1;\r\nuniform sampler2D texture2;\r\n\r\nuniform float opacity;\r\nout vec4 outColor;\r\n\r\nvoid main() {\r\n    \r\n    vec4 c1 = texelFetch(texture1, ivec2(gl_FragCoord.xy),0);\r\n    vec4 c2 = texelFetch(texture2, ivec2(gl_FragCoord.xy),0);\r\n    \r\n    outColor = mix(c1,c2,opacity);\r\n  }"),this.options=e??{},this.enabled=this.options.enabled??0}programReady(){super.programReady(),this.buildUniforms([{name:"opacity",type:k.f1,value:0,min:0,max:1,generateDebugSlider:1}],this.program),this.opacity=this.uniforms.get(this.program).get("opacity"),this.renderer.context.useProgram(this.program),this.renderer.context.uniform1i(this.renderer.context.getUniformLocation(this.program,"texture2"),1)}render(t,e,n){t.bindFramebuffer(t.FRAMEBUFFER,e),t.useProgram(this.program),t.activeTexture(t.TEXTURE1),t.bindTexture(t.TEXTURE_2D,this.options.texture),this.syncShader(this.uniforms.get(this.program)),t.activeTexture(t.TEXTURE0),t.bindTexture(t.TEXTURE_2D,n),t.drawArrays(t.TRIANGLES,0,3)}},"TextureOverlay",{enabled:0}).addDefaultAudioFilters(t=>{const e=t.analyser.addFilter("low");e.low=150,e.high=600,e.channel=.5;const n=t.analyser.addFilter("medium");n.low=1400,n.high=2e3,n.requireAmplitude=.7,n.channel=.5,n.accumulateType=R.min;const r=t.analyser.addFilter("high");r.high=2e4,r.low=5e3;const i=t.analyser.addFilter("titidi");return i.low=3800,i.high=4250,i.requireAmplitude=.7,{low:e,medium:n,high:r,titidi:i}}).onPartRender((t,e,n,r)=>{if(g.instance.state!==d.Paused&&n){Reflect.get(e,"common");if(n.Grain.time.value=t.toMilliseconds()/1e3,n.Rain.time.value=t.toMilliseconds()/1e3,n.DistortReplace.seed.value=t.toMilliseconds()/1e3,r&&Reflect.has(e,"overrideCommonPost")){Reflect.get(e,"overrideCommonPost").apply(e,[n,r])}}}).onSetup(t=>{Bd.set("perlin-512.png",b(t.renderer.context,t.overlay.elements.get("perlin-512.png"),0)),Bd.set("greets.png",b(t.renderer.context,t.overlay.elements.get("greets.png"),0)),Bd.set("textures/tech1_height.jpg",b(t.renderer.context,t.overlay.elements.get("textures/tech1_height.jpg"),0)),Bd.set("textures/sky1.jpg",b(t.renderer.context,t.overlay.elements.get("textures/sky1.jpg"),0)),Bd.set("textures/sky2.jpg",b(t.renderer.context,t.overlay.elements.get("textures/sky2.jpg"),0)),Bd.set("textures/sky3.jpg",b(t.renderer.context,t.overlay.elements.get("textures/sky3.jpg"),0)),Bd.set("textures/sky4.jpg",b(t.renderer.context,t.overlay.elements.get("textures/sky4.jpg"),0)),Bd.set("textures/grass-heightmap.png",b(t.renderer.context,t.overlay.elements.get("textures/grass-heightmap.png"),0)),Bd.set("polyhaven/planks_brown_10_rough_1k.jpg",b(t.renderer.context,t.overlay.elements.get("polyhaven/planks_brown_10_rough_1k.jpg"),0)),Bd.set("polyhaven/planks_brown_10_diff_1k.jpg",b(t.renderer.context,t.overlay.elements.get("polyhaven/planks_brown_10_diff_1k.jpg"),0)),Bd.set("polyhaven/planks_brown_10_disp_1k.png",b(t.renderer.context,t.overlay.elements.get("polyhaven/planks_brown_10_disp_1k.png"),0)),t.renderer.context.bindTexture(t.renderer.context.TEXTURE_2D,Bd.get("perlin-512.png")),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_S,t.renderer.context.REPEAT),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_R,t.renderer.context.REPEAT),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_T,t.renderer.context.REPEAT),t.renderer.context.bindTexture(t.renderer.context.TEXTURE_2D,Bd.get("greets.png")),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_S,t.renderer.context.REPEAT),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_R,t.renderer.context.REPEAT),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_T,t.renderer.context.REPEAT),t.renderer.context.bindTexture(t.renderer.context.TEXTURE_2D,Bd.get("polyhaven/planks_brown_10_rough_1k.jpg")),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_S,t.renderer.context.REPEAT),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_R,t.renderer.context.REPEAT),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_T,t.renderer.context.REPEAT),t.renderer.context.bindTexture(t.renderer.context.TEXTURE_2D,Bd.get("polyhaven/planks_brown_10_diff_1k.jpg")),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_S,t.renderer.context.REPEAT),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_R,t.renderer.context.REPEAT),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_T,t.renderer.context.REPEAT),t.renderer.context.bindTexture(t.renderer.context.TEXTURE_2D,Bd.get("polyhaven/planks_brown_10_disp_1k.png")),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_S,t.renderer.context.REPEAT),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_R,t.renderer.context.REPEAT),t.renderer.context.texParameteri(t.renderer.context.TEXTURE_2D,t.renderer.context.TEXTURE_WRAP_T,t.renderer.context.REPEAT)}).build()})();